/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.Data;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.EditSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.QueryResultDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.ResultItem;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsBrandDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsClasstreeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.StockReDomain;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.rs.RsEsbGoodsRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.rs.RsEsbGoodsResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusRsGoodsService;
import com.yqbsoft.laser.service.ext.bus.data.supbase.RsGoodsBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.HttpClientUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BusRsGoodsServiceImpl
extends RsGoodsBaseService
implements BusRsGoodsService {
    private String SYS_CODE = "busdata.BusRsGoodsServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusRsGoodsServiceImpl.class);

    @Override
    public String sendSaveBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendSaveBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendSaveBusClass(RsClasstreeDomain rsClasstreeDomain) {
        return null;
    }

    @Override
    public String sendSaveBusGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        return null;
    }

    @Override
    public String sendSaveBusBrand(RsBrandDomain rsBrandDomain) {
        return null;
    }

    @Override
    public String checkSkuByESB(String sku, String tenantCode) {
        String esbKey = this.getDdFlag(tenantCode, "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(tenantCode, "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(tenantCode, "EsbGoodsUrl", "EsbGoodsUrl");
        Esbfacade esbfacade = new Esbfacade(url, esbKey, esbSecret, null);
        String[] split = sku.split(",");
        RsEsbGoodsRequest rsEsbGoodsRequest = new RsEsbGoodsRequest();
        rsEsbGoodsRequest.setClientsecret(esbSecret);
        rsEsbGoodsRequest.setClientid(esbKey);
        rsEsbGoodsRequest.setHost(url);
        rsEsbGoodsRequest.setIT_MATNR(split);
        RsEsbGoodsResponse ocContractResponse = esbfacade.execute(rsEsbGoodsRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.ocContractResponse");
            return this.makeErrorReturn("-1", ocContractResponse.getDataObj());
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            return this.makeErrorReturn("-1", ocContractResponse.getDataObj());
        }
        return this.makeSuccessReturn(ocContractResponse.getDataObj());
    }

    public void updateStockJst(Map<String, Object> stockMap, String tenantCode) {
        String apiCode = "rs.resourceGoods.updateStockJst";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(stockMap));
        param.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, param);
    }

    public void updateStockRsSkuDomain(EditSkuDomain editSkuDomain) {
        logger.error(this.SYS_CODE + ".updateStockRsSkuDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain));
        this.updateRsSkuDomain(editSkuDomain);
    }

    @Override
    public String sendUpBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendUpBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendDownBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendDownBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendqueryStockSearch(String tenantCode, String skus, String warehouseCode, String startCreated, String endCreated, String endModified, String pageSize, String pageNo) {
        logger.info(this.SYS_CODE + "sendqueryStockSearch", (Object)("tenantCode" + tenantCode + "skus" + skus + "warehouseCode" + warehouseCode + "startCreated" + startCreated + "endCreated" + endCreated + "endModified" + endModified + "pageSize" + pageSize + "pageNo" + pageNo));
        Long startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "2023072819990101";
        }
        String url = "";
        url = this.getdd(tenantCode, "omsUrl", "omsUrl");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendqueryStockSearch\uff0curl", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd(tenantCode, "appKey", "appKey");
        if (StringUtils.isBlank((String)appKey)) {
            logger.error(this.SYS_CODE + ".sendqueryStockSearch\uff0cappKey", (Object)"appKey\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appSecret = "";
        appSecret = this.getdd(tenantCode, "appSecret", "appSecret");
        if (StringUtils.isBlank((String)appSecret)) {
            logger.error(this.SYS_CODE + ".sendqueryStockSearch\uff0cappSecret", (Object)"appSecret\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "Stock.Search");
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        mapStr.put("owner_code", "HEGII");
        if (StringUtils.isNotBlank((String)skus)) {
            mapStr.put("skus", skus);
        }
        if (StringUtils.isNotBlank((String)warehouseCode)) {
            mapStr.put("warehouse_code", warehouseCode);
        }
        if (StringUtils.isNotBlank((String)startCreated)) {
            mapStr.put("start_created", startCreated);
        }
        if (StringUtils.isNotBlank((String)endCreated)) {
            mapStr.put("end_created", endCreated);
        }
        if (StringUtils.isNotBlank((String)endModified)) {
            mapStr.put("end_modified", endModified);
        }
        if (StringUtils.isNotBlank((String)endModified)) {
            mapStr.put("end_modified", endModified);
        }
        if (StringUtils.isNotBlank((String)endModified)) {
            mapStr.put("end_modified", endModified);
        }
        mapStr.put("page_size", "100");
        if (StringUtils.isNotBlank((String)pageSize)) {
            mapStr.put("page_size", pageSize);
        }
        Integer page = 1;
        if (StringUtils.isNotBlank((String)pageNo)) {
            page = Integer.valueOf(pageNo);
        }
        boolean flag = true;
        while (flag) {
            Data data1;
            String data = null;
            mapStr.put("page_no", page.toString());
            try {
                data = HttpClientUtil.doGet(url, mapStr);
                Integer n = page;
                Integer n2 = page = Integer.valueOf(page + 1);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".sendqueryStockSearch.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(mapStr));
                continue;
            }
            StockReDomain stockReDomain = (StockReDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, StockReDomain.class);
            if (null == stockReDomain || null == (data1 = stockReDomain.getData())) continue;
            List<ResultItem> result = data1.getResult();
            for (ResultItem resultItem : result) {
                EditSkuDomain editSkuDomain = new EditSkuDomain();
                editSkuDomain.setSkuNo(resultItem.getSku());
                editSkuDomain.setGoodsSupplynum(new BigDecimal(resultItem.getStockUsable()));
                this.updateStockRsSkuDomain(editSkuDomain);
            }
            if (data1.isHasNext()) continue;
            flag = false;
        }
        return "error";
    }

    protected String getdd(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    public static void main(String[] args) {
        String json = "{\"shop_id\":\"2\",\"order_no\":\"20092500000192\",\"warehouse_code\":\"WH01\",\"express_code\":\"cs_ex_code\",\"express_no\":\"\",\"goods_total\":\"1\",\"sku_total\":\"1\",\"order_status\":\"60\",\"no_stock_status\":\"10\",\"question_status\":\"0\",\"lock_status\":\"0\",\"refund_status\":\"0\",\"urgent_status\":\"0\",\"pre_sale_status\":\"0\",\"delivery_time\":\"0000-00-00 00:00:00\",\"write_back_time\":\"0000-00-00 00:00:00\",\"write_back_status\":\"0\",\"notice_time\":\"0000-00-00 00:00:00\",\"check_time\":\"0000-00-00 00:00:00\",\"cancel_time\":\"2021-09-04 17:15:06\",\"cancel_reason\":\"MERGE\",\"lock_user\":\"\",\"part_refund_status\":\"0\",\"owner_id\":\"1\",\"modified\":\"2023-07-28 09:43:51\",\"notice_send_date\":\"0000-00-00\",\"latest_delivery_time\":\"0000-00-00 00:00:00\",\"order_type\":\"0\",\"platform_code\":\"TB\",\"tid\":\"139240889093282116\",\"user_nick\":\"~kgGAlT5t5R7EhSx+1SNvYg==~1~\",\"consignee\":\"~VAVLOKg7Hz+GEaPTmDSqpA==~1~\",\"phone\":\"\",\"mobile\":\"$183$Sjoja4KsLeWZZtdFV+3YtA==$1$\",\"email\":\"\",\"address\":\"\u82b1\u56ed\u9547\u5b5d\u660c\u53bf\u91d1\u5229\u885790\u4e09\u697c\",\"state\":\"\u4e2d\u56fd\",\"province\":\"\u6e56\u5317\u7701\",\"city\":\"\u5b5d\u611f\u5e02\",\"area\":\"\u5b5d\u660c\u53bf\",\"town\":\"\",\"state_code\":\"1\",\"province_code\":\"420000\",\"city_code\":\"420900\",\"area_code\":\"420921\",\"town_code\":\"\",\"zipcode\":\"432900\",\"remark\":\"\",\"seller_flag\":\"0\",\"is_buyer_remark\":\"0\",\"is_seller_remark\":\"0\",\"buyer_remark\":\"\",\"seller_remark\":\"\",\"order_price\":\"107.00\",\"postage\":\"0.00\",\"pre_tax_price\":\"0.00\",\"tax_price\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"order_time\":\"2018-03-20 16:31:19\",\"payment_time\":\"2018-03-20 16:31:22\",\"invoice_type\":\"0\",\"invoice_title\":\"\",\"invoice_content\":\"\",\"invoice_amount\":\"107.00\",\"payment_type\":\"0\",\"payment_way\":\"ALIPAY\",\"weight\":\"0.00\",\"real_weight\":\"0.00\",\"volume\":\"0.00\",\"distribution_status\":\"0\",\"copy_order_status\":\"1\",\"split_order_status\":\"0\",\"merge_order_status\":\"0\",\"change_order_status\":\"0\",\"split_order_no\":\"\",\"merge_order_no\":\"\",\"copy_order_no\":\"8032000000027\",\"change_order_no\":\"\",\"distribution_mode\":\"0\",\"distribution_name\":\"\",\"copy_order_num\":\"0\",\"cod_price\":\"0.00\",\"consignee_doc_type\":\"1\",\"consignee_doc_no\":\"\",\"cert_name\":\"\",\"invoice_register_no\":\"\",\"created\":\"2020-09-25 13:58:29\",\"oaid\":\"\",\"demolition_price\":\"0.00\",\"wms_order_no\":\"\",\"shop_code\":\"CS02\",\"shop_name\":\"\u7231\u679c\u4e50\u4f18\u52a0\u65d7\u8230\u5e97\",\"cancel_reason_name\":\"\u5408\u5355\u4f5c\u5e9f\",\"detail\":[{\"id\":\"308141\",\"order_no\":\"20092500000192\",\"tid\":\"139240889093282116\",\"oid\":\"139240889094282116\",\"goods_no\":\"B01002007\",\"sku\":\"B01002007w\",\"num\":\"1\",\"lock_num\":\"0\",\"goods_price\":\"119.00\",\"avg_money\":\"107.00\",\"order_avg_money\":\"107.00\",\"postage_avg_money\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"demolition_price\":\"0.00\",\"is_gift\":\"0\",\"volume\":\"0.00\",\"weight\":\"0.00\",\"return_status\":\"0\",\"return_num\":\"0\",\"return_fee\":\"0.00\",\"pre_sale_status\":\"0\",\"payment_number\":\"\",\"package_sku\":\"\",\"replace_status\":\"0\",\"sku_id\":\"\",\"item_id\":\"\",\"ean\":\"\",\"attribute_value_name\":\"\",\"goods_name\":\"test\u9001\",\"is_package\":\"n\"}],\"batch_detail\":[],\"order_label\":[{\"order_no\":\"20092500000192\",\"flag\":\"undefined\"}],\"_custom\":{\"order_no\":\"20092500000192\",\"111\":\"111\",\"rtet\":\"\"},\"express_name\":\"\",\"warehouse_name\":\"WH01\"},{\"shop_id\":\"2\",\"order_no\":\"20092500000208\",\"warehouse_code\":\"WH01\",\"express_code\":\"ZT\",\"express_no\":\"\",\"goods_total\":\"1\",\"sku_total\":\"1\",\"order_status\":\"60\",\"no_stock_status\":\"10\",\"question_status\":\"0\",\"lock_status\":\"0\",\"refund_status\":\"0\",\"urgent_status\":\"0\",\"pre_sale_status\":\"0\",\"delivery_time\":\"0000-00-00 00:00:00\",\"write_back_time\":\"0000-00-00 00:00:00\",\"write_back_status\":\"0\",\"notice_time\":\"0000-00-00 00:00:00\",\"check_time\":\"0000-00-00 00:00:00\",\"cancel_time\":\"2021-09-04 17:15:06\",\"cancel_reason\":\"MERGE\",\"lock_user\":\"\",\"part_refund_status\":\"0\",\"owner_id\":\"1\",\"modified\":\"2023-07-28 09:43:51\",\"notice_send_date\":\"0000-00-00\",\"latest_delivery_time\":\"0000-00-00 00:00:00\",\"order_type\":\"0\",\"platform_code\":\"TB\",\"tid\":\"139240889093282116\",\"user_nick\":\"~kgGAlT5t5R7EhSx+1SNvYg==~1~\",\"consignee\":\"~VAVLOKg7Hz+GEaPTmDSqpA==~1~\",\"phone\":\"\",\"mobile\":\"$183$Sjoja4KsLeWZZtdFV+3YtA==$1$\",\"email\":\"\",\"address\":\"\u82b1\u56ed\u9547\u5b5d\u660c\u53bf\u91d1\u5229\u885790\u4e09\u697c\",\"state\":\"\u4e2d\u56fd\",\"province\":\"\u6e56\u5317\u7701\",\"city\":\"\u5b5d\u611f\u5e02\",\"area\":\"\u5b5d\u660c\u53bf\",\"town\":\"\",\"state_code\":\"1\",\"province_code\":\"420000\",\"city_code\":\"420900\",\"area_code\":\"420921\",\"town_code\":\"\",\"zipcode\":\"432900\",\"remark\":\"\",\"seller_flag\":\"0\",\"is_buyer_remark\":\"0\",\"is_seller_remark\":\"0\",\"buyer_remark\":\"\",\"seller_remark\":\"\",\"order_price\":\"0.00\",\"postage\":\"0.00\",\"pre_tax_price\":\"0.00\",\"tax_price\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"order_time\":\"2018-03-20 16:31:19\",\"payment_time\":\"2018-03-20 16:31:22\",\"invoice_type\":\"0\",\"invoice_title\":\"\",\"invoice_content\":\"\",\"invoice_amount\":\"107.00\",\"payment_type\":\"0\",\"payment_way\":\"ALIPAY\",\"weight\":\"0.00\",\"real_weight\":\"0.00\",\"volume\":\"0.00\",\"distribution_status\":\"0\",\"copy_order_status\":\"1\",\"split_order_status\":\"0\",\"merge_order_status\":\"0\",\"change_order_status\":\"0\",\"split_order_no\":\"\",\"merge_order_no\":\"\",\"copy_order_no\":\"8032000000034\",\"change_order_no\":\"\",\"distribution_mode\":\"0\",\"distribution_name\":\"\",\"copy_order_num\":\"0\",\"cod_price\":\"0.00\",\"consignee_doc_type\":\"1\",\"consignee_doc_no\":\"\",\"cert_name\":\"\",\"invoice_register_no\":\"\",\"created\":\"2020-09-25 13:58:29\",\"oaid\":\"\",\"demolition_price\":\"0.00\",\"wms_order_no\":\"\",\"shop_code\":\"CS02\",\"shop_name\":\"\u7231\u679c\u4e50\u4f18\u52a0\u65d7\u8230\u5e97\",\"cancel_reason_name\":\"\u5408\u5355\u4f5c\u5e9f\",\"detail\":[{\"id\":\"308142\",\"order_no\":\"20092500000208\",\"tid\":\"139240889093282116\",\"oid\":\"139240889095282116\",\"goods_no\":\"C0001P000101\",\"sku\":\"zb000089\",\"num\":\"1\",\"lock_num\":\"0\",\"goods_price\":\"12.00\",\"avg_money\":\"0.00\",\"order_avg_money\":\"0.00\",\"postage_avg_money\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"demolition_price\":\"0.00\",\"is_gift\":\"0\",\"volume\":\"0.00\",\"weight\":\"0.00\",\"return_status\":\"0\",\"return_num\":\"0\",\"return_fee\":\"0.00\",\"pre_sale_status\":\"0\",\"payment_number\":\"\",\"package_sku\":\"\",\"replace_status\":\"0\",\"sku_id\":\"\",\"item_id\":\"\",\"ean\":\"\",\"attribute_value_name\":\"\",\"goods_name\":\"\u6d4b\u8bd5\u5546\u54c1\",\"is_package\":\"n\"}],\"batch_detail\":[],\"order_label\":[{\"order_no\":\"20092500000208\",\"flag\":\"undefined\"}],\"_custom\":{\"order_no\":\"20092500000208\",\"111\":\"111\",\"rtet\":\"\"},\"express_name\":\"\",\"warehouse_name\":\"WH01\"},{\"shop_id\":\"2\",\"order_no\":\"20092500000217\",\"warehouse_code\":\"WH01\",\"express_code\":\"ZTO\",\"express_no\":\"\",\"goods_total\":\"1\",\"sku_total\":\"1\",\"order_status\":\"60\",\"no_stock_status\":\"10\",\"question_status\":\"0\",\"lock_status\":\"0\",\"refund_status\":\"0\",\"urgent_status\":\"0\",\"pre_sale_status\":\"0\",\"delivery_time\":\"0000-00-00 00:00:00\",\"write_back_time\":\"0000-00-00 00:00:00\",\"write_back_status\":\"0\",\"notice_time\":\"0000-00-00 00:00:00\",\"check_time\":\"0000-00-00 00:00:00\",\"cancel_time\":\"2021-09-04 17:15:06\",\"cancel_reason\":\"MERGE\",\"lock_user\":\"\",\"part_refund_status\":\"0\",\"owner_id\":\"1\",\"modified\":\"2023-07-28 09:43:51\",\"notice_send_date\":\"0000-00-00\",\"latest_delivery_time\":\"0000-00-00 00:00:00\",\"order_type\":\"0\",\"platform_code\":\"TB\",\"tid\":\"139240889093282116\",\"user_nick\":\"~kgGAlT5t5R7EhSx+1SNvYg==~1~\",\"consignee\":\"~VAVLOKg7Hz+GEaPTmDSqpA==~1~\",\"phone\":\"\",\"mobile\":\"$183$Sjoja4KsLeWZZtdFV+3YtA==$1$\",\"email\":\"\",\"address\":\"\u82b1\u56ed\u9547\u5b5d\u660c\u53bf\u91d1\u5229\u885790\u4e09\u697c\",\"state\":\"\u4e2d\u56fd\",\"province\":\"\u6e56\u5317\u7701\",\"city\":\"\u5b5d\u611f\u5e02\",\"area\":\"\u5b5d\u660c\u53bf\",\"town\":\"\",\"state_code\":\"1\",\"province_code\":\"420000\",\"city_code\":\"420900\",\"area_code\":\"420921\",\"town_code\":\"\",\"zipcode\":\"432900\",\"remark\":\"\",\"seller_flag\":\"0\",\"is_buyer_remark\":\"0\",\"is_seller_remark\":\"0\",\"buyer_remark\":\"\",\"seller_remark\":\"\",\"order_price\":\"0.00\",\"postage\":\"0.00\",\"pre_tax_price\":\"0.00\",\"tax_price\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"order_time\":\"2018-03-20 16:31:19\",\"payment_time\":\"2018-03-20 16:31:22\",\"invoice_type\":\"0\",\"invoice_title\":\"\",\"invoice_content\":\"\",\"invoice_amount\":\"107.00\",\"payment_type\":\"0\",\"payment_way\":\"ALIPAY\",\"weight\":\"0.00\",\"real_weight\":\"0.00\",\"volume\":\"0.00\",\"distribution_status\":\"0\",\"copy_order_status\":\"1\",\"split_order_status\":\"0\",\"merge_order_status\":\"0\",\"change_order_status\":\"0\",\"split_order_no\":\"\",\"merge_order_no\":\"\",\"copy_order_no\":\"8032000000041\",\"change_order_no\":\"\",\"distribution_mode\":\"0\",\"distribution_name\":\"\",\"copy_order_num\":\"0\",\"cod_price\":\"0.00\",\"consignee_doc_type\":\"1\",\"consignee_doc_no\":\"\",\"cert_name\":\"\",\"invoice_register_no\":\"\",\"created\":\"2020-09-25 13:58:30\",\"oaid\":\"\",\"demolition_price\":\"0.00\",\"wms_order_no\":\"\",\"shop_code\":\"CS02\",\"shop_name\":\"\u7231\u679c\u4e50\u4f18\u52a0\u65d7\u8230\u5e97\",\"cancel_reason_name\":\"\u5408\u5355\u4f5c\u5e9f\",\"detail\":[{\"id\":\"308143\",\"order_no\":\"20092500000217\",\"tid\":\"139240889093282116\",\"oid\":\"\",\"goods_no\":\"C0001P000101\",\"sku\":\"19315090204220\",\"num\":\"1\",\"lock_num\":\"0\",\"goods_price\":\"0.00\",\"avg_money\":\"0.00\",\"order_avg_money\":\"0.00\",\"postage_avg_money\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"demolition_price\":\"0.00\",\"is_gift\":\"0\",\"volume\":\"0.00\",\"weight\":\"0.00\",\"return_status\":\"0\",\"return_num\":\"0\",\"return_fee\":\"0.00\",\"pre_sale_status\":\"0\",\"payment_number\":\"\",\"package_sku\":\"\",\"replace_status\":\"0\",\"sku_id\":\"\",\"item_id\":\"\",\"ean\":\"\",\"attribute_value_name\":\"\",\"goods_name\":\"\u6d4b\u8bd5\u5546\u54c1\",\"is_package\":\"n\"}],\"batch_detail\":[],\"order_label\":[{\"order_no\":\"20092500000217\",\"flag\":\"undefined\"}],\"_custom\":{\"order_no\":\"20092500000217\",\"111\":\"111\",\"rtet\":\"\",\"detail\":[{\"order_no\":\"20092500000217\",\"oid\":\"\",\"sku\":\"19315090204220\",\"is_gift\":\"0\",\"cost_price1\":\"\"}]},\"express_name\":\"\u4e2d\u901a\u5feb\u9012\",\"warehouse_name\":\"WH01\"},{\"shop_id\":\"2\",\"order_no\":\"20092500000226\",\"warehouse_code\":\"WH01\",\"express_code\":\"ZTO\",\"express_no\":\"\",\"goods_total\":\"1\",\"sku_total\":\"1\",\"order_status\":\"60\",\"no_stock_status\":\"10\",\"question_status\":\"0\",\"lock_status\":\"0\",\"refund_status\":\"0\",\"urgent_status\":\"0\",\"pre_sale_status\":\"0\",\"delivery_time\":\"0000-00-00 00:00:00\",\"write_back_time\":\"0000-00-00 00:00:00\",\"write_back_status\":\"0\",\"notice_time\":\"0000-00-00 00:00:00\",\"check_time\":\"0000-00-00 00:00:00\",\"cancel_time\":\"2021-09-04 17:15:05\",\"cancel_reason\":\"MERGE\",\"lock_user\":\"\",\"part_refund_status\":\"0\",\"owner_id\":\"1\",\"modified\":\"2023-07-28 09:43:51\",\"notice_send_date\":\"0000-00-00\",\"latest_delivery_time\":\"0000-00-00 00:00:00\",\"order_type\":\"0\",\"platform_code\":\"TB\",\"tid\":\"139240889093282116\",\"user_nick\":\"~kgGAlT5t5R7EhSx+1SNvYg==~1~\",\"consignee\":\"~VAVLOKg7Hz+GEaPTmDSqpA==~1~\",\"phone\":\"\",\"mobile\":\"$183$Sjoja4KsLeWZZtdFV+3YtA==$1$\",\"email\":\"\",\"address\":\"\u82b1\u56ed\u9547\u5b5d\u660c\u53bf\u91d1\u5229\u885790\u4e09\u697c\",\"state\":\"\u4e2d\u56fd\",\"province\":\"\u6e56\u5317\u7701\",\"city\":\"\u5b5d\u611f\u5e02\",\"area\":\"\u5b5d\u660c\u53bf\",\"town\":\"\",\"state_code\":\"1\",\"province_code\":\"420000\",\"city_code\":\"420900\",\"area_code\":\"420921\",\"town_code\":\"\",\"zipcode\":\"432900\",\"remark\":\"\",\"seller_flag\":\"0\",\"is_buyer_remark\":\"0\",\"is_seller_remark\":\"0\",\"buyer_remark\":\"\",\"seller_remark\":\"\",\"order_price\":\"0.00\",\"postage\":\"0.00\",\"pre_tax_price\":\"0.00\",\"tax_price\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"order_time\":\"2018-03-20 16:31:19\",\"payment_time\":\"2018-03-20 16:31:22\",\"invoice_type\":\"0\",\"invoice_title\":\"\",\"invoice_content\":\"\",\"invoice_amount\":\"107.00\",\"payment_type\":\"0\",\"payment_way\":\"ALIPAY\",\"weight\":\"0.00\",\"real_weight\":\"0.00\",\"volume\":\"0.00\",\"distribution_status\":\"0\",\"copy_order_status\":\"1\",\"split_order_status\":\"0\",\"merge_order_status\":\"0\",\"change_order_status\":\"0\",\"split_order_no\":\"\",\"merge_order_no\":\"\",\"copy_order_no\":\"8033100000023\",\"change_order_no\":\"\",\"distribution_mode\":\"0\",\"distribution_name\":\"\",\"copy_order_num\":\"0\",\"cod_price\":\"0.00\",\"consignee_doc_type\":\"1\",\"consignee_doc_no\":\"\",\"cert_name\":\"\",\"invoice_register_no\":\"\",\"created\":\"2020-09-25 13:58:31\",\"oaid\":\"\",\"demolition_price\":\"0.00\",\"wms_order_no\":\"\",\"shop_code\":\"CS02\",\"shop_name\":\"\u7231\u679c\u4e50\u4f18\u52a0\u65d7\u8230\u5e97\",\"cancel_reason_name\":\"\u5408\u5355\u4f5c\u5e9f\",\"detail\":[{\"id\":\"308144\",\"order_no\":\"20092500000226\",\"tid\":\"139240889093282116\",\"oid\":\"\",\"goods_no\":\"C0001P000101\",\"sku\":\"19315090204220\",\"num\":\"1\",\"lock_num\":\"0\",\"goods_price\":\"0.00\",\"avg_money\":\"0.00\",\"order_avg_money\":\"0.00\",\"postage_avg_money\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"demolition_price\":\"0.00\",\"is_gift\":\"0\",\"volume\":\"0.00\",\"weight\":\"0.00\",\"return_status\":\"0\",\"return_num\":\"0\",\"return_fee\":\"0.00\",\"pre_sale_status\":\"0\",\"payment_number\":\"\",\"package_sku\":\"\",\"replace_status\":\"0\",\"sku_id\":\"\",\"item_id\":\"\",\"ean\":\"\",\"attribute_value_name\":\"\",\"goods_name\":\"\u6d4b\u8bd5\u5546\u54c1\",\"is_package\":\"n\"}],\"batch_detail\":[],\"order_label\":[{\"order_no\":\"20092500000226\",\"flag\":\"undefined\"}],\"_custom\":{\"order_no\":\"20092500000226\",\"111\":\"111\",\"rtet\":\"\",\"detail\":[{\"order_no\":\"20092500000226\",\"oid\":\"\",\"sku\":\"19315090204220\",\"is_gift\":\"0\",\"cost_price1\":\"\"}]},\"express_name\":\"\u4e2d\u901a\u5feb\u9012\",\"warehouse_name\":\"WH01\"},{\"shop_id\":\"2\",\"order_no\":\"21090400000103\",\"warehouse_code\":\"WH01\",\"express_code\":\"ZTO1\",\"express_no\":\"\",\"goods_total\":\"4\",\"sku_total\":\"3\",\"order_status\":\"5\",\"no_stock_status\":\"10\",\"question_status\":\"0\",\"lock_status\":\"0\",\"refund_status\":\"0\",\"urgent_status\":\"0\",\"pre_sale_status\":\"0\",\"delivery_time\":\"0000-00-00 00:00:00\",\"write_back_time\":\"0000-00-00 00:00:00\",\"write_back_status\":\"0\",\"notice_time\":\"0000-00-00 00:00:00\",\"check_time\":\"0000-00-00 00:00:00\",\"cancel_time\":\"0000-00-00 00:00:00\",\"cancel_reason\":\"\",\"lock_user\":\"\",\"part_refund_status\":\"0\",\"owner_id\":\"1\",\"modified\":\"2023-07-28 09:43:51\",\"notice_send_date\":\"0000-00-00\",\"latest_delivery_time\":\"0000-00-00 00:00:00\",\"order_type\":\"0\",\"platform_code\":\"TB\",\"tid\":\"139240889093282116\",\"user_nick\":\"~kgGAlT5t5R7EhSx+1SNvYg==~1~\",\"consignee\":\"~VAVLOKg7Hz+GEaPTmDSqpA==~1~\",\"phone\":\"\",\"mobile\":\"$183$Sjoja4KsLeWZZtdFV+3YtA==$1$\",\"email\":\"\",\"address\":\"\u82b1\u56ed\u9547\u5b5d\u660c\u53bf\u91d1\u5229\u885790\u4e09\u697c\",\"state\":\"\u4e2d\u56fd\",\"province\":\"\u6e56\u5317\u7701\",\"city\":\"\u5b5d\u611f\u5e02\",\"area\":\"\u5b5d\u660c\u53bf\",\"town\":\"\",\"state_code\":\"1\",\"province_code\":\"420000\",\"city_code\":\"420900\",\"area_code\":\"420921\",\"town_code\":\"\",\"zipcode\":\"432900\",\"remark\":\"\",\"seller_flag\":\"0\",\"is_buyer_remark\":\"0\",\"is_seller_remark\":\"0\",\"buyer_remark\":\"\",\"seller_remark\":\"\",\"order_price\":\"107.00\",\"postage\":\"0.00\",\"pre_tax_price\":\"0.00\",\"tax_price\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"order_time\":\"2018-03-20 16:31:19\",\"payment_time\":\"2018-03-20 16:31:22\",\"invoice_type\":\"0\",\"invoice_title\":\"\",\"invoice_content\":\"\",\"invoice_amount\":\"428.00\",\"payment_type\":\"0\",\"payment_way\":\"ALIPAY\",\"weight\":\"42.00\",\"real_weight\":\"0.00\",\"volume\":\"0.00\",\"distribution_status\":\"0\",\"copy_order_status\":\"0\",\"split_order_status\":\"0\",\"merge_order_status\":\"2\",\"change_order_status\":\"0\",\"split_order_no\":\"\",\"merge_order_no\":\"20092500000226,20092500000192,20092500000208,20092500000217\",\"copy_order_no\":\"\",\"change_order_no\":\"\",\"distribution_mode\":\"0\",\"distribution_name\":\"\",\"copy_order_num\":\"0\",\"cod_price\":\"0.00\",\"consignee_doc_type\":\"1\",\"consignee_doc_no\":\"\",\"cert_name\":\"\",\"invoice_register_no\":\"\",\"created\":\"2021-09-04 17:15:06\",\"oaid\":\"\",\"demolition_price\":\"0.00\",\"wms_order_no\":\"\",\"shop_code\":\"CS02\",\"shop_name\":\"\u7231\u679c\u4e50\u4f18\u52a0\u65d7\u8230\u5e97\",\"cancel_reason_name\":\"\",\"detail\":[{\"id\":\"313617\",\"order_no\":\"21090400000103\",\"tid\":\"139240889093282116\",\"oid\":\"\",\"goods_no\":\"C0001P000101\",\"sku\":\"19315090204220\",\"num\":\"2\",\"lock_num\":\"0\",\"goods_price\":\"0.00\",\"avg_money\":\"0.00\",\"order_avg_money\":\"0.00\",\"postage_avg_money\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"demolition_price\":\"0.00\",\"is_gift\":\"0\",\"volume\":\"0.00\",\"weight\":\"0.00\",\"return_status\":\"0\",\"return_num\":\"0\",\"return_fee\":\"0.00\",\"pre_sale_status\":\"0\",\"payment_number\":\"\",\"package_sku\":\"\",\"replace_status\":\"2\",\"sku_id\":\"\",\"item_id\":\"\",\"ean\":\"\",\"attribute_value_name\":\"\",\"goods_name\":\"\u6d4b\u8bd5\u5546\u54c1\",\"is_package\":\"n\"},{\"id\":\"313618\",\"order_no\":\"21090400000103\",\"tid\":\"139240889093282116\",\"oid\":\"139240889094282116\",\"goods_no\":\"B01002007\",\"sku\":\"B01002007w\",\"num\":\"1\",\"lock_num\":\"1\",\"goods_price\":\"119.00\",\"avg_money\":\"107.00\",\"order_avg_money\":\"107.00\",\"postage_avg_money\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"demolition_price\":\"0.00\",\"is_gift\":\"0\",\"volume\":\"0.00\",\"weight\":\"0.00\",\"return_status\":\"0\",\"return_num\":\"0\",\"return_fee\":\"0.00\",\"pre_sale_status\":\"0\",\"payment_number\":\"\",\"package_sku\":\"\",\"replace_status\":\"2\",\"sku_id\":\"\",\"item_id\":\"\",\"ean\":\"\",\"attribute_value_name\":\"\",\"goods_name\":\"test\u9001\",\"is_package\":\"n\"},{\"id\":\"313619\",\"order_no\":\"21090400000103\",\"tid\":\"139240889093282116\",\"oid\":\"139240889095282116\",\"goods_no\":\"C0001P000101\",\"sku\":\"zb000089\",\"num\":\"1\",\"lock_num\":\"0\",\"goods_price\":\"12.00\",\"avg_money\":\"0.00\",\"order_avg_money\":\"0.00\",\"postage_avg_money\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"demolition_price\":\"0.00\",\"is_gift\":\"0\",\"volume\":\"0.00\",\"weight\":\"0.00\",\"return_status\":\"0\",\"return_num\":\"0\",\"return_fee\":\"0.00\",\"pre_sale_status\":\"0\",\"payment_number\":\"\",\"package_sku\":\"\",\"replace_status\":\"2\",\"sku_id\":\"\",\"item_id\":\"\",\"ean\":\"\",\"attribute_value_name\":\"\",\"goods_name\":\"\u6d4b\u8bd5\u5546\u54c1\",\"is_package\":\"n\"}],\"batch_detail\":[],\"order_label\":[{\"order_no\":\"21090400000103\",\"flag\":\"undefined\"}],\"_custom\":{\"order_no\":\"21090400000103\",\"111\":\"111\",\"rtet\":\"\",\"detail\":[{\"order_no\":\"21090400000103\",\"oid\":\"\",\"sku\":\"19315090204220\",\"is_gift\":\"0\",\"cost_price1\":\"\"}]},\"express_name\":\"\",\"warehouse_name\":\"WH01\"},{\"shop_id\":\"2\",\"order_no\":\"8032000000027\",\"warehouse_code\":\"WH01\",\"express_code\":\"cs_ex_code\",\"express_no\":\"1381234568\",\"goods_total\":\"1\",\"sku_total\":\"1\",\"order_status\":\"50\",\"no_stock_status\":\"10\",\"question_status\":\"0\",\"lock_status\":\"0\",\"refund_status\":\"1\",\"urgent_status\":\"0\",\"pre_sale_status\":\"0\",\"delivery_time\":\"2020-06-17 17:34:59\",\"write_back_time\":\"2020-08-31 19:18:20\",\"write_back_status\":\"30\",\"notice_time\":\"2018-03-21 10:14:03\",\"check_time\":\"2018-03-21 10:14:02\",\"cancel_time\":\"0000-00-00 00:00:00\",\"cancel_reason\":\"\",\"lock_user\":\"\",\"part_refund_status\":\"0\",\"owner_id\":\"1\",\"modified\":\"2022-06-27 14:43:57\",\"notice_send_date\":\"0000-00-00\",\"latest_delivery_time\":null,\"order_type\":\"0\",\"platform_code\":\"TB\",\"tid\":\"139240889093282116\",\"user_nick\":\"~kgGAlT5t5R7EhSx+1SNvYg==~1~\",\"consignee\":\"~VAVLOKg7Hz+GEaPTmDSqpA==~1~\",\"phone\":\"\",\"mobile\":\"$183$Sjoja4KsLeWZZtdFV+3YtA==$1$\",\"email\":\"\",\"address\":\"\u82b1\u56ed\u9547\u5b5d\u660c\u53bf\u91d1\u5229\u885790\u4e09\u697c\",\"state\":\"\u4e2d\u56fd\",\"province\":\"\u6e56\u5317\u7701\",\"city\":\"\u5b5d\u611f\u5e02\",\"area\":\"\u5b5d\u660c\u53bf\",\"town\":\"\",\"state_code\":\"1\",\"province_code\":\"420000\",\"city_code\":\"420900\",\"area_code\":\"420921\",\"town_code\":\"\",\"zipcode\":\"432900\",\"remark\":\"\",\"seller_flag\":\"0\",\"is_buyer_remark\":\"0\",\"is_seller_remark\":\"0\",\"buyer_remark\":\"\",\"seller_remark\":\"\",\"order_price\":\"107.00\",\"postage\":\"0.00\",\"pre_tax_price\":\"0.00\",\"tax_price\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"order_time\":\"2018-03-20 16:31:19\",\"payment_time\":\"2018-03-20 16:31:22\",\"invoice_type\":\"0\",\"invoice_title\":\"\",\"invoice_content\":\"\",\"invoice_amount\":\"107.00\",\"payment_type\":\"0\",\"payment_way\":\"ALIPAY\",\"weight\":\"0.00\",\"real_weight\":\"0.00\",\"volume\":\"0.00\",\"distribution_status\":\"0\",\"copy_order_status\":\"0\",\"split_order_status\":\"1\",\"merge_order_status\":\"0\",\"change_order_status\":\"0\",\"split_order_no\":\"8032000000010\",\"merge_order_no\":\"\",\"copy_order_no\":\"\",\"change_order_no\":\"\",\"distribution_mode\":\"0\",\"distribution_name\":\"\",\"copy_order_num\":\"1\",\"cod_price\":\"0.00\",\"consignee_doc_type\":\"1\",\"consignee_doc_no\":\"\",\"cert_name\":null,\"invoice_register_no\":\"\",\"created\":\"2018-03-20 16:56:43\",\"oaid\":\"\",\"demolition_price\":\"0.00\",\"wms_order_no\":\"\",\"shop_code\":\"CS02\",\"shop_name\":\"\u7231\u679c\u4e50\u4f18\u52a0\u65d7\u8230\u5e97\",\"cancel_reason_name\":\"\",\"detail\":[{\"id\":\"4\",\"order_no\":\"8032000000027\",\"tid\":\"139240889093282116\",\"oid\":\"139240889094282116\",\"goods_no\":\"B01002007\",\"sku\":\"B01002007w\",\"num\":\"1\",\"lock_num\":\"1\",\"goods_price\":\"119.00\",\"avg_money\":\"107.00\",\"order_avg_money\":\"107.00\",\"postage_avg_money\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"demolition_price\":\"0.00\",\"is_gift\":\"0\",\"volume\":\"0.00\",\"weight\":\"0.00\",\"return_status\":\"0\",\"return_num\":\"0\",\"return_fee\":\"0.00\",\"pre_sale_status\":\"0\",\"payment_number\":\"\",\"package_sku\":\"\",\"replace_status\":\"0\",\"sku_id\":\"\",\"item_id\":\"\",\"ean\":\"\",\"attribute_value_name\":\"\",\"goods_name\":\"test\u9001\",\"is_package\":\"n\"}],\"batch_detail\":[],\"order_express\":[{\"sku\":\"B01002007w\",\"num\":\"1\",\"express_code\":\"SF\",\"express_no\":\"1381234568\",\"package_no\":null}],\"express_name\":\"\",\"warehouse_name\":\"WH01\"},{\"shop_id\":\"2\",\"order_no\":\"8032000000034\",\"warehouse_code\":\"WH01\",\"express_code\":\"ZT\",\"express_no\":\"\",\"goods_total\":\"1\",\"sku_total\":\"1\",\"order_status\":\"60\",\"no_stock_status\":\"10\",\"question_status\":\"0\",\"lock_status\":\"0\",\"refund_status\":\"0\",\"urgent_status\":\"0\",\"pre_sale_status\":\"0\",\"delivery_time\":\"0000-00-00 00:00:00\",\"write_back_time\":\"0000-00-00 00:00:00\",\"write_back_status\":\"0\",\"notice_time\":\"2018-11-27 11:12:52\",\"check_time\":\"2018-08-22 14:06:34\",\"cancel_time\":\"2020-03-18 10:21:09\",\"cancel_reason\":\"\",\"lock_user\":\"\",\"part_refund_status\":\"0\",\"owner_id\":\"1\",\"modified\":\"2023-07-28 09:43:51\",\"notice_send_date\":\"0000-00-00\",\"latest_delivery_time\":null,\"order_type\":\"0\",\"platform_code\":\"TB\",\"tid\":\"139240889093282116\",\"user_nick\":\"~kgGAlT5t5R7EhSx+1SNvYg==~1~\",\"consignee\":\"~VAVLOKg7Hz+GEaPTmDSqpA==~1~\",\"phone\":\"\",\"mobile\":\"$183$Sjoja4KsLeWZZtdFV+3YtA==$1$\",\"email\":\"\",\"address\":\"\u82b1\u56ed\u9547\u5b5d\u660c\u53bf\u91d1\u5229\u885790\u4e09\u697c\",\"state\":\"\u4e2d\u56fd\",\"province\":\"\u6e56\u5317\u7701\",\"city\":\"\u5b5d\u611f\u5e02\",\"area\":\"\u5b5d\u660c\u53bf\",\"town\":\"\",\"state_code\":\"1\",\"province_code\":\"420000\",\"city_code\":\"420900\",\"area_code\":\"420921\",\"town_code\":\"\",\"zipcode\":\"432900\",\"remark\":\"\",\"seller_flag\":\"0\",\"is_buyer_remark\":\"0\",\"is_seller_remark\":\"0\",\"buyer_remark\":\"\",\"seller_remark\":\"\",\"order_price\":\"0.00\",\"postage\":\"0.00\",\"pre_tax_price\":\"0.00\",\"tax_price\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"order_time\":\"2018-03-20 16:31:19\",\"payment_time\":\"2018-03-20 16:31:22\",\"invoice_type\":\"0\",\"invoice_title\":\"\",\"invoice_content\":\"\",\"invoice_amount\":\"107.00\",\"payment_type\":\"0\",\"payment_way\":\"ALIPAY\",\"weight\":\"0.00\",\"real_weight\":\"0.00\",\"volume\":\"0.00\",\"distribution_status\":\"0\",\"copy_order_status\":\"0\",\"split_order_status\":\"1\",\"merge_order_status\":\"0\",\"change_order_status\":\"0\",\"split_order_no\":\"8032000000010\",\"merge_order_no\":\"\",\"copy_order_no\":\"\",\"change_order_no\":\"\",\"distribution_mode\":\"0\",\"distribution_name\":\"\",\"copy_order_num\":\"1\",\"cod_price\":\"0.00\",\"consignee_doc_type\":\"1\",\"consignee_doc_no\":\"\",\"cert_name\":null,\"invoice_register_no\":\"\",\"created\":\"2018-03-20 16:56:43\",\"oaid\":\"\",\"demolition_price\":\"0.00\",\"wms_order_no\":\"\",\"shop_code\":\"CS02\",\"shop_name\":\"\u7231\u679c\u4e50\u4f18\u52a0\u65d7\u8230\u5e97\",\"cancel_reason_name\":\"\",\"detail\":[{\"id\":\"5\",\"order_no\":\"8032000000034\",\"tid\":\"139240889093282116\",\"oid\":\"139240889095282116\",\"goods_no\":\"C0001P000101\",\"sku\":\"zb000089\",\"num\":\"1\",\"lock_num\":\"0\",\"goods_price\":\"12.00\",\"avg_money\":\"0.00\",\"order_avg_money\":\"0.00\",\"postage_avg_money\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"demolition_price\":\"0.00\",\"is_gift\":\"0\",\"volume\":\"0.00\",\"weight\":\"0.00\",\"return_status\":\"0\",\"return_num\":\"0\",\"return_fee\":\"0.00\",\"pre_sale_status\":\"0\",\"payment_number\":\"\",\"package_sku\":\"\",\"replace_status\":\"0\",\"sku_id\":\"\",\"item_id\":\"\",\"ean\":\"\",\"attribute_value_name\":\"\",\"goods_name\":\"\u6d4b\u8bd5\u5546\u54c1\",\"is_package\":\"n\"}],\"batch_detail\":[],\"express_name\":\"\",\"warehouse_name\":\"WH01\"},{\"shop_id\":\"2\",\"order_no\":\"8032000000041\",\"warehouse_code\":\"WH01\",\"express_code\":\"ZTO\",\"express_no\":\"ex000999\",\"goods_total\":\"1\",\"sku_total\":\"1\",\"order_status\":\"60\",\"no_stock_status\":\"10\",\"question_status\":\"1\",\"lock_status\":\"0\",\"refund_status\":\"1\",\"urgent_status\":\"0\",\"pre_sale_status\":\"0\",\"delivery_time\":\"0000-00-00 00:00:00\",\"write_back_time\":\"0000-00-00 00:00:00\",\"write_back_status\":\"0\",\"notice_time\":\"0000-00-00 00:00:00\",\"check_time\":\"0000-00-00 00:00:00\",\"cancel_time\":\"2020-08-15 11:24:32\",\"cancel_reason\":\"\",\"lock_user\":\"\",\"part_refund_status\":\"0\",\"owner_id\":\"1\",\"modified\":\"2023-07-28 09:43:51\",\"notice_send_date\":\"0000-00-00\",\"latest_delivery_time\":null,\"order_type\":\"0\",\"platform_code\":\"TB\",\"tid\":\"139240889093282116\",\"user_nick\":\"~kgGAlT5t5R7EhSx+1SNvYg==~1~\",\"consignee\":\"~VAVLOKg7Hz+GEaPTmDSqpA==~1~\",\"phone\":\"\",\"mobile\":\"$183$Sjoja4KsLeWZZtdFV+3YtA==$1$\",\"email\":\"\",\"address\":\"\u82b1\u56ed\u9547\u5b5d\u660c\u53bf\u91d1\u5229\u885790\u4e09\u697c\",\"state\":\"\u4e2d\u56fd\",\"province\":\"\u6e56\u5317\u7701\",\"city\":\"\u5b5d\u611f\u5e02\",\"area\":\"\u5b5d\u660c\u53bf\",\"town\":\"\",\"state_code\":\"1\",\"province_code\":\"420000\",\"city_code\":\"420900\",\"area_code\":\"420921\",\"town_code\":\"\",\"zipcode\":\"432900\",\"remark\":\"\",\"seller_flag\":\"0\",\"is_buyer_remark\":\"0\",\"is_seller_remark\":\"0\",\"buyer_remark\":\"\",\"seller_remark\":\"\",\"order_price\":\"0.00\",\"postage\":\"0.00\",\"pre_tax_price\":\"0.00\",\"tax_price\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"order_time\":\"2018-03-20 16:31:19\",\"payment_time\":\"2018-03-20 16:31:22\",\"invoice_type\":\"0\",\"invoice_title\":\"\",\"invoice_content\":\"\",\"invoice_amount\":\"107.00\",\"payment_type\":\"0\",\"payment_way\":\"ALIPAY\",\"weight\":\"0.00\",\"real_weight\":\"0.00\",\"volume\":\"0.00\",\"distribution_status\":\"0\",\"copy_order_status\":\"0\",\"split_order_status\":\"1\",\"merge_order_status\":\"0\",\"change_order_status\":\"0\",\"split_order_no\":\"8032000000010\",\"merge_order_no\":\"\",\"copy_order_no\":\"\",\"change_order_no\":\"\",\"distribution_mode\":\"0\",\"distribution_name\":\"\",\"copy_order_num\":\"1\",\"cod_price\":\"0.00\",\"consignee_doc_type\":\"1\",\"consignee_doc_no\":\"\",\"cert_name\":null,\"invoice_register_no\":\"\",\"created\":\"2018-03-20 16:56:43\",\"oaid\":\"\",\"demolition_price\":\"0.00\",\"wms_order_no\":\"\",\"shop_code\":\"CS02\",\"shop_name\":\"\u7231\u679c\u4e50\u4f18\u52a0\u65d7\u8230\u5e97\",\"cancel_reason_name\":\"\",\"detail\":[{\"id\":\"6\",\"order_no\":\"8032000000041\",\"tid\":\"139240889093282116\",\"oid\":\"\",\"goods_no\":\"C0001P000101\",\"sku\":\"19315090204220\",\"num\":\"1\",\"lock_num\":\"0\",\"goods_price\":\"0.00\",\"avg_money\":\"0.00\",\"order_avg_money\":\"0.00\",\"postage_avg_money\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"demolition_price\":\"0.00\",\"is_gift\":\"0\",\"volume\":\"0.00\",\"weight\":\"0.00\",\"return_status\":\"0\",\"return_num\":\"0\",\"return_fee\":\"0.00\",\"pre_sale_status\":\"0\",\"payment_number\":\"\",\"package_sku\":\"\",\"replace_status\":\"0\",\"sku_id\":\"\",\"item_id\":\"\",\"ean\":\"\",\"attribute_value_name\":\"\",\"goods_name\":\"\u6d4b\u8bd5\u5546\u54c1\",\"is_package\":\"n\"}],\"batch_detail\":[],\"_custom\":{\"detail\":[{\"order_no\":\"8032000000041\",\"oid\":\"\",\"sku\":\"19315090204220\",\"is_gift\":\"0\",\"cost_price1\":\"\"}]},\"express_name\":\"\u4e2d\u901a\u5feb\u9012\",\"warehouse_name\":\"WH01\"},{\"shop_id\":\"2\",\"order_no\":\"8033100000023\",\"warehouse_code\":\"WH01\",\"express_code\":\"ZTO\",\"express_no\":\"1231313\",\"goods_total\":\"1\",\"sku_total\":\"1\",\"order_status\":\"50\",\"no_stock_status\":\"10\",\"question_status\":\"0\",\"lock_status\":\"0\",\"refund_status\":\"1\",\"urgent_status\":\"0\",\"pre_sale_status\":\"0\",\"delivery_time\":\"2020-08-27 17:35:00\",\"write_back_time\":\"2020-08-31 19:18:20\",\"write_back_status\":\"30\",\"notice_time\":\"2018-11-27 11:12:52\",\"check_time\":\"2018-08-22 17:12:39\",\"cancel_time\":\"0000-00-00 00:00:00\",\"cancel_reason\":\"\",\"lock_user\":\"\",\"part_refund_status\":\"0\",\"owner_id\":\"1\",\"modified\":\"2022-06-27 14:43:57\",\"notice_send_date\":\"0000-00-00\",\"latest_delivery_time\":null,\"order_type\":\"0\",\"platform_code\":\"TB\",\"tid\":\"139240889093282116\",\"user_nick\":\"~kgGAlT5t5R7EhSx+1SNvYg==~1~\",\"consignee\":\"~VAVLOKg7Hz+GEaPTmDSqpA==~1~\",\"phone\":\"\",\"mobile\":\"$183$Sjoja4KsLeWZZtdFV+3YtA==$1$\",\"email\":\"\",\"address\":\"\u82b1\u56ed\u9547\u5b5d\u660c\u53bf\u91d1\u5229\u885790\u4e09\u697c\",\"state\":\"\u4e2d\u56fd\",\"province\":\"\u6e56\u5317\u7701\",\"city\":\"\u5b5d\u611f\u5e02\",\"area\":\"\u5b5d\u660c\u53bf\",\"town\":\"\",\"state_code\":\"1\",\"province_code\":\"420000\",\"city_code\":\"420900\",\"area_code\":\"420921\",\"town_code\":\"\",\"zipcode\":\"432900\",\"remark\":\"\",\"seller_flag\":\"0\",\"is_buyer_remark\":\"0\",\"is_seller_remark\":\"0\",\"buyer_remark\":\"\",\"seller_remark\":\"\",\"order_price\":\"0.00\",\"postage\":\"0.00\",\"pre_tax_price\":\"0.00\",\"tax_price\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"order_time\":\"2018-03-20 16:31:19\",\"payment_time\":\"2018-03-20 16:31:22\",\"invoice_type\":\"0\",\"invoice_title\":\"\",\"invoice_content\":\"\",\"invoice_amount\":\"107.00\",\"payment_type\":\"0\",\"payment_way\":\"ALIPAY\",\"weight\":\"0.00\",\"real_weight\":\"0.00\",\"volume\":\"0.00\",\"distribution_status\":\"0\",\"copy_order_status\":\"0\",\"split_order_status\":\"4\",\"merge_order_status\":\"0\",\"change_order_status\":\"0\",\"split_order_no\":\"8032100000064\",\"merge_order_no\":\"\",\"copy_order_no\":\"\",\"change_order_no\":\"\",\"distribution_mode\":\"0\",\"distribution_name\":\"\",\"copy_order_num\":\"1\",\"cod_price\":\"0.00\",\"consignee_doc_type\":\"1\",\"consignee_doc_no\":\"\",\"cert_name\":null,\"invoice_register_no\":\"\",\"created\":\"2018-03-31 11:15:02\",\"oaid\":\"\",\"demolition_price\":\"0.00\",\"wms_order_no\":\"\",\"shop_code\":\"CS02\",\"shop_name\":\"\u7231\u679c\u4e50\u4f18\u52a0\u65d7\u8230\u5e97\",\"cancel_reason_name\":\"\",\"detail\":[{\"id\":\"81\",\"order_no\":\"8033100000023\",\"tid\":\"139240889093282116\",\"oid\":\"\",\"goods_no\":\"C0001P000101\",\"sku\":\"19315090204220\",\"num\":\"1\",\"lock_num\":\"1\",\"goods_price\":\"0.00\",\"avg_money\":\"0.00\",\"order_avg_money\":\"0.00\",\"postage_avg_money\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"demolition_price\":\"0.00\",\"is_gift\":\"0\",\"volume\":\"0.00\",\"weight\":\"0.00\",\"return_status\":\"0\",\"return_num\":\"0\",\"return_fee\":\"0.00\",\"pre_sale_status\":\"0\",\"payment_number\":\"\",\"package_sku\":\"\",\"replace_status\":\"0\",\"sku_id\":\"\",\"item_id\":\"\",\"ean\":\"\",\"attribute_value_name\":\"\",\"goods_name\":\"\u6d4b\u8bd5\u5546\u54c1\",\"is_package\":\"n\"}],\"batch_detail\":[],\"order_express\":[{\"sku\":\"19315090204220\",\"num\":\"1\",\"express_code\":\"ZT\",\"express_no\":\"\",\"package_no\":null}],\"_custom\":{\"order_no\":\"8033100000023\",\"111\":\"111\",\"rtet\":\"\",\"detail\":[{\"order_no\":\"8033100000023\",\"oid\":\"\",\"sku\":\"19315090204220\",\"is_gift\":\"0\",\"cost_price1\":\"\"}]},\"express_name\":\"\u4e2d\u901a\u5feb\u9012\",\"warehouse_name\":\"WH01\"}";
        QueryResultDomain jsonToObject = (QueryResultDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResultDomain.class);
        System.out.println(jsonToObject);
    }
}

