/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.Data;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.EditSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.ResultItem;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsBrandDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsClasstreeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.StockReDomain;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.rs.RsEsbGoodsRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.rs.RsEsbGoodsResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusRsGoodsService;
import com.yqbsoft.laser.service.ext.bus.data.supbase.RsGoodsBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.HttpClientUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BusRsGoodsServiceImpl
extends RsGoodsBaseService
implements BusRsGoodsService {
    private String SYS_CODE = "busdata.BusRsGoodsServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusRsGoodsServiceImpl.class);

    @Override
    public String sendSaveBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendSaveBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendSaveBusClass(RsClasstreeDomain rsClasstreeDomain) {
        return null;
    }

    @Override
    public String sendSaveBusGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        return null;
    }

    @Override
    public String sendSaveBusBrand(RsBrandDomain rsBrandDomain) {
        return null;
    }

    @Override
    public String checkSkuByESB(String sku, String tenantCode) {
        String esbKey = this.getDdFlag(tenantCode, "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(tenantCode, "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(tenantCode, "EsbGoodsUrl", "EsbGoodsUrl");
        Esbfacade esbfacade = new Esbfacade(url, esbKey, esbSecret, null);
        String[] split = sku.split(",");
        RsEsbGoodsRequest rsEsbGoodsRequest = new RsEsbGoodsRequest();
        rsEsbGoodsRequest.setClientsecret(esbSecret);
        rsEsbGoodsRequest.setClientid(esbKey);
        rsEsbGoodsRequest.setHost(url);
        rsEsbGoodsRequest.setIT_MATNR(split);
        RsEsbGoodsResponse ocContractResponse = esbfacade.execute(rsEsbGoodsRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.ocContractResponse");
            return this.makeErrorReturn("-1", ocContractResponse.getDataObj());
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            return this.makeErrorReturn("-1", ocContractResponse.getDataObj());
        }
        return this.makeSuccessReturn(ocContractResponse.getDataObj());
    }

    public void updateStockJst(Map<String, Object> stockMap, String tenantCode) {
        String apiCode = "rs.resourceGoods.updateStockJst";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(stockMap));
        param.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, param);
    }

    public void updateStockRsSkuDomain(EditSkuDomain editSkuDomain) {
        logger.error(this.SYS_CODE + ".updateStockRsSkuDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain));
        this.updateRsSkuDomain(editSkuDomain);
    }

    @Override
    public String sendUpBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendUpBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendDownBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendDownBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendqueryStockSearch(String tenantCode, String skus, String warehouseCode, String startCreated, String endCreated, String endModified, String pageSize, String pageNo) {
        logger.info(this.SYS_CODE + "sendqueryStockSearch", (Object)("tenantCode" + tenantCode + "skus" + skus + "warehouseCode" + warehouseCode + "startCreated" + startCreated + "endCreated" + endCreated + "endModified" + endModified + "pageSize" + pageSize + "pageNo" + pageNo));
        Long startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "2023072819990101";
        }
        String url = "";
        url = this.getdd(tenantCode, "omsUrl", "omsUrl");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendqueryStockSearch\uff0curl", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd(tenantCode, "appKey", "appKey");
        if (StringUtils.isBlank((String)appKey)) {
            logger.error(this.SYS_CODE + ".sendqueryStockSearch\uff0cappKey", (Object)"appKey\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appSecret = "";
        appSecret = this.getdd(tenantCode, "appSecret", "appSecret");
        if (StringUtils.isBlank((String)appSecret)) {
            logger.error(this.SYS_CODE + ".sendqueryStockSearch\uff0cappSecret", (Object)"appSecret\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "Stock.Search");
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        mapStr.put("owner_code", "HEGII");
        if (StringUtils.isNotBlank((String)skus)) {
            mapStr.put("skus", skus);
        }
        if (StringUtils.isNotBlank((String)warehouseCode)) {
            mapStr.put("warehouse_code", warehouseCode);
        }
        if (StringUtils.isNotBlank((String)startCreated)) {
            mapStr.put("start_created", startCreated);
        }
        if (StringUtils.isNotBlank((String)endCreated)) {
            mapStr.put("end_created", endCreated);
        }
        if (StringUtils.isNotBlank((String)endModified)) {
            mapStr.put("end_modified", endModified);
        }
        if (StringUtils.isNotBlank((String)endModified)) {
            mapStr.put("end_modified", endModified);
        }
        if (StringUtils.isNotBlank((String)endModified)) {
            mapStr.put("end_modified", endModified);
        }
        mapStr.put("page_size", "100");
        if (StringUtils.isNotBlank((String)pageSize)) {
            mapStr.put("page_size", pageSize);
        }
        Integer page = 1;
        if (StringUtils.isNotBlank((String)pageNo)) {
            page = Integer.valueOf(pageNo);
        }
        boolean flag = true;
        while (flag) {
            Data data1;
            String data = null;
            mapStr.put("page_no", page.toString());
            try {
                data = HttpClientUtil.doGet(url, mapStr);
                Integer n = page;
                Integer n2 = page = Integer.valueOf(page + 1);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".sendqueryStockSearch.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(mapStr));
                continue;
            }
            StockReDomain stockReDomain = (StockReDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, StockReDomain.class);
            if (null == stockReDomain || null == (data1 = stockReDomain.getData())) continue;
            List<ResultItem> result = data1.getResult();
            for (ResultItem resultItem : result) {
                EditSkuDomain editSkuDomain = new EditSkuDomain();
                editSkuDomain.setSkuNo(resultItem.getSku());
                editSkuDomain.setGoodsSupplynum(new BigDecimal(resultItem.getStock()).subtract(new BigDecimal(resultItem.getOccupy())));
                editSkuDomain.setTenantCode(tenantCode);
                editSkuDomain.setChannelCode("plat");
                this.updateStockRsSkuDomain(editSkuDomain);
            }
            if (data1.isHasNext()) continue;
            flag = false;
        }
        return "error";
    }

    protected String getdd(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }
}

