/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.Data;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.EditSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.ResultItem;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsBrandDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsClasstreeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.StockReDomain;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.rs.RsEsbGoodsRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.rs.RsEsbGoodsResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusRsGoodsService;
import com.yqbsoft.laser.service.ext.bus.data.supbase.RsGoodsBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.HttpClientUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BusRsGoodsServiceImpl
extends RsGoodsBaseService
implements BusRsGoodsService {
    private String SYS_CODE = "busdata.BusRsGoodsServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusRsGoodsServiceImpl.class);

    @Override
    public String sendSaveBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendSaveBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendSaveBusClass(RsClasstreeDomain rsClasstreeDomain) {
        return null;
    }

    @Override
    public String sendSaveBusGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        return null;
    }

    @Override
    public String sendSaveBusBrand(RsBrandDomain rsBrandDomain) {
        return null;
    }

    @Override
    public String checkSkuByESB(String sku, String tenantCode) {
        String esbKey = this.getDdFlag(tenantCode, "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(tenantCode, "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(tenantCode, "EsbGoodsUrl", "EsbGoodsUrl");
        Esbfacade esbfacade = new Esbfacade(url, esbKey, esbSecret, null);
        String[] split = sku.split(",");
        RsEsbGoodsRequest rsEsbGoodsRequest = new RsEsbGoodsRequest();
        rsEsbGoodsRequest.setClientsecret(esbSecret);
        rsEsbGoodsRequest.setClientid(esbKey);
        rsEsbGoodsRequest.setHost(url);
        rsEsbGoodsRequest.setIT_MATNR(split);
        RsEsbGoodsResponse ocContractResponse = esbfacade.execute(rsEsbGoodsRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.ocContractResponse");
            return this.makeErrorReturn("-1", ocContractResponse.getDataObj());
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            return this.makeErrorReturn("-1", ocContractResponse.getDataObj());
        }
        return this.makeSuccessReturn(ocContractResponse.getDataObj());
    }

    public void updateStockJst(Map<String, Object> stockMap, String tenantCode) {
        String apiCode = "rs.resourceGoods.updateStockJst";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(stockMap));
        param.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, param);
    }

    public void updateStockRsSkuDomain(EditSkuDomain editSkuDomain) {
        logger.error(this.SYS_CODE + ".updateStockRsSkuDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain));
        this.updateRsSkuDomain(editSkuDomain);
    }

    @Override
    public String sendUpBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendUpBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendDownBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendDownBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendqueryStockSearch(String tenantCode, String skus, String warehouseCode, String startCreated, String endCreated, String endModified, String pageSize, String pageNo) {
        logger.info(this.SYS_CODE + "sendqueryStockSearch", (Object)("tenantCode" + tenantCode + "skus" + skus + "warehouseCode" + warehouseCode + "startCreated" + startCreated + "endCreated" + endCreated + "endModified" + endModified + "pageSize" + pageSize + "pageNo" + pageNo));
        Long startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "2023072819990101";
        }
        String url = "";
        url = this.getdd(tenantCode, "omsUrl", "omsUrl");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendqueryStockSearch\uff0curl", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd(tenantCode, "appKey", "appKey");
        if (StringUtils.isBlank((String)appKey)) {
            logger.error(this.SYS_CODE + ".sendqueryStockSearch\uff0cappKey", (Object)"appKey\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appSecret = "";
        appSecret = this.getdd(tenantCode, "appSecret", "appSecret");
        if (StringUtils.isBlank((String)appSecret)) {
            logger.error(this.SYS_CODE + ".sendqueryStockSearch\uff0cappSecret", (Object)"appSecret\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "Stock.Search");
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        mapStr.put("owner_code", "HEGII");
        if (StringUtils.isNotBlank((String)skus)) {
            mapStr.put("skus", skus);
        }
        if (StringUtils.isNotBlank((String)warehouseCode)) {
            mapStr.put("warehouse_code", warehouseCode);
        }
        if (StringUtils.isNotBlank((String)startCreated)) {
            mapStr.put("start_created", startCreated);
        }
        if (StringUtils.isNotBlank((String)endCreated)) {
            mapStr.put("end_created", endCreated);
        }
        if (StringUtils.isNotBlank((String)endModified)) {
            mapStr.put("end_modified", endModified);
        }
        if (StringUtils.isNotBlank((String)endModified)) {
            mapStr.put("end_modified", endModified);
        }
        if (StringUtils.isNotBlank((String)endModified)) {
            mapStr.put("end_modified", endModified);
        }
        mapStr.put("page_size", "100");
        if (StringUtils.isNotBlank((String)pageSize)) {
            mapStr.put("page_size", pageSize);
        }
        Integer page = 1;
        if (StringUtils.isNotBlank((String)pageNo)) {
            page = Integer.valueOf(pageNo);
        }
        boolean flag = true;
        while (flag) {
            Data data1;
            String data = null;
            mapStr.put("page_no", page.toString());
            try {
                data = HttpClientUtil.doGet(url, mapStr);
                Integer n = page;
                Integer n2 = page = Integer.valueOf(page + 1);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".sendqueryStockSearch.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(mapStr));
                continue;
            }
            StockReDomain stockReDomain = (StockReDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, StockReDomain.class);
            if (null == stockReDomain || null == (data1 = stockReDomain.getData())) continue;
            List<ResultItem> result = data1.getResult();
            for (ResultItem resultItem : result) {
                EditSkuDomain editSkuDomain = new EditSkuDomain();
                editSkuDomain.setSkuNo(resultItem.getSku());
                editSkuDomain.setGoodsSupplynum(new BigDecimal(resultItem.getStock()).subtract(new BigDecimal(resultItem.getOccupy())));
                editSkuDomain.setTenantCode(tenantCode);
                editSkuDomain.setChannelCode("plat");
                this.updateStockRsSkuDomain(editSkuDomain);
            }
            if (data1.isHasNext()) continue;
            flag = false;
        }
        return "error";
    }

    @Override
    public String sendsdkTaobaoGoodsGet(String tenantCode, Map<String, Object> map) throws ApiException {
        logger.error(this.SYS_CODE + ".sendsdkTaobaoGoodsGet.map.1", (Object)JsonUtil.buildNormalBinder().toJson(map));
        Long startTime = System.currentTimeMillis();
        if (null == map) {
            logger.error(this.SYS_CODE + ".sendsdkTaobaoGoodsGet.map", (Object)"isnull");
            return null;
        }
        String url = "";
        url = this.getdd(tenantCode, "omsUrl", "omsUrl");
        url = "http://172.17.193.112/oms/webservice.php";
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendsdkTaobaoGoodsGet\uff0curl", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd(tenantCode, "appKey", "appKey");
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "oms.SdkTaobaoGoodsGet");
        mapStr.put("app_key", "1722318531");
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        mapStr.put("shop_code", "CS01");
        mapStr.put("num_iid", (String)map.get("num_iid"));
        String data = null;
        try {
            data = HttpClientUtil.doGet(url, mapStr);
            logger.error(this.SYS_CODE + ".sendsdkTaobaoGoodsGet.returnResultsMap.codeurl" + url + "mapStr" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)("data" + data + "startTime" + (System.currentTimeMillis() - startTime)));
            Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)returnResultsMap)) {
                logger.error(this.SYS_CODE + ".sendsdkTaobaoGoodsGet.returnResultsMap" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)data);
                return null;
            }
            Object code = returnResultsMap.get("status");
            long code1 = Long.parseLong(code.toString());
            if (code1 > 0L) {
                return JsonUtil.buildNonNullBinder().toJson((Object)returnResultsMap);
            }
            logger.error(this.SYS_CODE + ".sendsdkTaobaoGoodsGet.url.code1" + url, (Object)JsonUtil.buildNormalBinder().toJson((Object)returnResultsMap));
            return null;
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendsdkTaobaoGoodsGet.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(mapStr));
            logger.error(this.SYS_CODE + ".sendsdkTaobaoGoodsGet.Exception", (Throwable)e);
            return null;
        }
    }

    @Override
    public String queryPlatformGoodsSearch(String tenantCode, Map<String, Object> map) throws ApiException {
        logger.error(this.SYS_CODE + ".queryPlatformGoodsSearch.map.1", (Object)JsonUtil.buildNormalBinder().toJson(map));
        Long startTime = System.currentTimeMillis();
        if (null == map) {
            logger.error(this.SYS_CODE + ".queryPlatformGoodsSearch.map", (Object)"isnull");
            return null;
        }
        String url = "";
        url = this.getdd(tenantCode, "omsUrl", "omsUrl");
        url = "http://172.17.193.112/oms/webservice.php";
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".queryPlatformGoodsSearch\uff0curl", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        String appKey = "";
        appKey = this.getdd(tenantCode, "appKey", "appKey");
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "Platform.GoodsSearch");
        mapStr.put("app_key", "1722318531");
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        mapStr.put("shop_code", "CS01");
        if (null != map.get("owner_code")) {
            mapStr.put("owner_code", (String)map.get("owner_code"));
        }
        if (null != map.get("skus")) {
            mapStr.put("skus", (String)map.get("skus"));
        }
        if (null != map.get("start_created")) {
            mapStr.put("start_created", (String)map.get("start_created"));
        }
        if (null != map.get("end_created")) {
            mapStr.put("end_created", (String)map.get("end_created"));
        }
        if (null != map.get("end_created")) {
            mapStr.put("end_created", (String)map.get("end_created"));
        }
        if (null != map.get("page_size")) {
            mapStr.put("page_size", (String)map.get("page_size"));
        } else {
            mapStr.put("page_size", "1");
        }
        if (null != map.get("page_no")) {
            mapStr.put("page_no", (String)map.get("page_no"));
        } else {
            mapStr.put("page_no", "1");
        }
        String data = null;
        try {
            data = HttpClientUtil.doGet(url, mapStr);
            logger.error(this.SYS_CODE + ".queryPlatformGoodsSearch.returnResultsMap.codeurl" + url + "mapStr" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)("data" + data + "startTime" + (System.currentTimeMillis() - startTime)));
            Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)returnResultsMap)) {
                logger.error(this.SYS_CODE + ".queryPlatformGoodsSearch.returnResultsMap" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)data);
                return null;
            }
            Object code = returnResultsMap.get("status");
            long code1 = Long.parseLong(code.toString());
            if (code1 > 0L) {
                Map data1 = (Map)returnResultsMap.get("data");
                List data2 = (List)data1.get("result");
                for (Map data3 : data2) {
                    HashMap<String, Object> map1 = new HashMap<String, Object>();
                    map1.put("shop_code", data3.get("shop_code"));
                    map1.put("num_iid", data3.get("item_id"));
                    String s = this.sendsdkTaobaoGoodsGet(tenantCode, map1);
                    Map returnResultsMap1 = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(s, String.class, Object.class);
                    data3.put("data1", returnResultsMap1);
                }
                return JsonUtil.buildNonNullBinder().toJson((Object)returnResultsMap);
            }
            logger.error(this.SYS_CODE + ".queryPlatformGoodsSearch.code1.url" + url, (Object)JsonUtil.buildNormalBinder().toJson((Object)returnResultsMap));
            return null;
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".queryPlatformGoodsSearch.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(mapStr));
            logger.error(this.SYS_CODE + ".queryPlatformGoodsSearch.Exception", (Throwable)e);
            return null;
        }
    }

    protected String getdd(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    public static String removeBackslashes(String input) {
        String regex = "\\\\";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceAll("");
    }

    public static void main(String[] args) {
        String data1 = "{\n\t\"app_sign\": \"\",\n\t\"app_key\": \"1722318531\",\n\t\"method\": \"oms.SdkTaobaoGoodsGet\",\n\t\"shop_code\": \"CS01\",\n\t\"page_no\": \"1\",\n\t\"timestamp\": \"2024-12-03 13:37:44\",\n\t\"num_iid\": \"550966068666\"\n}";
        Map mapStr = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data1, String.class, String.class);
        Long startTime = System.currentTimeMillis();
        String data = HttpClientUtil.doGet("http://omsdev.hegii.com:9112/oms/webservice.php?method=Platform.GoodsSearch", mapStr);
        String s = BusRsGoodsServiceImpl.removeBackslashes(data);
        System.out.println(System.currentTimeMillis() - startTime + "=============");
        System.out.println(s);
    }
}

