/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.common;

import com.yqbsoft.laser.service.ext.bus.data.common.ErpRequestParams;
import com.yqbsoft.laser.service.ext.bus.data.common.ErpResponseParams;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ErpApiUtil {
    private static final SupperLogUtil logger = new SupperLogUtil(ErpApiUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErpResponseParams sendRequest(String url, ErpRequestParams request, String secret) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        CloseableHttpResponse response = null;
        try {
            request.generateSign(secret);
            httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
            StringEntity entity = new StringEntity(request.toJsonString(), "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            logger.info("ErpApiUtil.sendRequest.request", (Object)request.toJsonString());
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                ErpResponseParams result;
                String responseBody = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
                logger.info("ErpApiUtil.sendRequest.response", (Object)responseBody);
                ErpResponseParams erpResponseParams = result = (ErpResponseParams)JsonUtil.buildNormalBinder().getJsonToObject(responseBody, ErpResponseParams.class);
                return erpResponseParams;
            }
        }
        catch (IOException e) {
            logger.error("ErpApiUtil.sendRequest.error", (Throwable)e);
            ErpResponseParams erpResponseParams = ErpResponseParams.buildError("API_ERROR", "\u63a5\u53e3\u8c03\u7528\u5f02\u5e38: " + e.getMessage(), request.getMethod());
            return erpResponseParams;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpClient.close();
            }
            catch (IOException e) {
                logger.error("ErpApiUtil.sendRequest.close", (Throwable)e);
            }
        }
        return ErpResponseParams.buildError("API_ERROR", "\u63a5\u53e3\u8c03\u7528\u65e0\u54cd\u5e94", request.getMethod());
    }
}

