/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data;

import com.yqbsoft.laser.service.tool.util.StringUtils;

public class ComConstants {
    public static final String SYS_CODE = "busdata";
    public static final String success = "success";
    public static final String error = "error";
    private static final String[] NUMBERS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] IUNIT = new String[]{"\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] DUNIT = new String[]{"\u89d2", "\u5206", "\u5398"};
    public static String tenantCode = "728243877368496147";
    public static String channelCode = "728296217517314110";
    public static String userinfoCode = "20000210463648";
    public static String membercode = "20000210463648";
    public static String membername = "\u7231\u5eb7";
    public static String storeGoodsBtype_d = "D";
    public static String storeGoodsBtype_t = "T";
    public static String storeType_1 = "1";
    public static final String STOCK_STORE_COVER_TYPE = "0";
    public static final String RECHARGE_TYPE_01 = "1";
    public static final String RECHARGE_TYPE_02 = "2";
    public static final String RECHARGE_CREATE_URL = "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
    public static final String VOUCHER_CREATE_URL = "/U9/RestServices/Cust.Akan.U9.APISV.ICust_AkanSV.svc/Do";
    public static final String RECHARGE_DEL_URL = "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
    public static final String REST_SERVICES_URL = "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
    public static final String CLOSE_SERVICES_URL = "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
    public static final String SEND_ORDER_SERVICES_URL = "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
    public static final String OA_APPID = "0e6439cc-9f84-42b0-a676-fefcb6587b7d";
    public static final String OA_SECRET = "0e6439cc-9f84-42b0-a676-fefcb6587b7d";
    public static final String OA_SPK = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA7A+ULq+P6UYXPb/8Xf8Qip/XghaopLBFgRoVovAjufp29L/jYZZyhVhYM5LYq+TaDVaIIYYJELxYABKoITwDR5dvPMJCr9X98ezleaAULtWGF1QwXhGBdTdMru7o8oQ8clMGAlUCemd7jo5uLaeiE8cX4dWM2HendMCZTeL5lHTzK5u1SkkGbdNip7u2CcPd6WgDiqMTV/3CFcha2tg4SyUkxepF6TiNEc4F9fBXUJsyeSJ5V4gVDMHrtnuEy15uz5lE1bZYLcbrYneMLiZvrFeenL5bpGJmdBKAZKoGszKxp1YU3kw7Dzur7OYufXN+CpwG+Aai7tsIe1HnAG/WEQIDAQAB";
    public static final String OA_TOKEN_URL = "http://58.247.90.118:8090/api/ec/dev/auth/applytoken";
    public static final String PM_DATASTATE_0 = "0";
    public static final String PM_DATASTATE_4 = "4";
    public static final String PM_DATASTATE_5 = "5";
    public static final String YY_GATEWAY_URL = "/iuap-api-gateway";
    public static final String YY_TOKEN_URL = "/iuap-api-auth/open-auth";
    public static final String YY_GETBSFILE_URL = "/yonbip/tax/output-tax/api/einvoice/getbsfile";
    public static String storeGoodsType_3 = "3";
    public static String storeGoodsType_4 = "4";
    public static String storeGoodsType_20 = "20";
    public static final String SENDGOODS_SERVICES_URL = "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
    public static final String SENDGOODS_CANCEL_URL = "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
    public static final String EHR_EMPLOYEES_URL = "/api/employees";
    public static final String EHR_ORGANIZATIONS_URL = "/api/organizations";
    public static final String EHR_POSITIONS_URL = "/api/positions";
    public static final String FW_TOKEN_URL = "/api/ec/dev/auth/applytoken";
    public static final String FW_WORKFLOW_URL = "/api/workflow/paService/doCreateRequest";

    public static String toChinese(String str) {
        String decimalStr;
        String integerStr;
        if (StringUtils.isBlank((String)str) || !str.matches("(-)?[\\d]*(.)?[\\d]*")) {
            return "\u62b1\u6b49\uff0c\u8bf7\u8f93\u5165\u6570\u5b57\uff01";
        }
        if ("0".equals(str) || "0.00".equals(str) || "0.0".equals(str)) {
            return "\u96f6\u5143";
        }
        boolean flag = false;
        if (str.startsWith("-")) {
            flag = true;
            str = str.replaceAll("-", "");
        }
        if ((str = str.replaceAll(",", "")).indexOf(".") > 0) {
            integerStr = str.substring(0, str.indexOf("."));
            decimalStr = str.substring(str.indexOf(".") + 1);
        } else if (str.indexOf(".") == 0) {
            integerStr = "";
            decimalStr = str.substring(1);
        } else {
            integerStr = str;
            decimalStr = "";
        }
        if (integerStr.length() > IUNIT.length) {
            return "\u8d85\u51fa\u8ba1\u7b97\u80fd\u529b\uff01";
        }
        int[] integers = ComConstants.toIntArray(integerStr);
        if (integers.length > 1 && integers[0] == 0) {
            return "\u62b1\u6b49\uff0c\u8f93\u5165\u6570\u5b57\u4e0d\u7b26\u5408\u8981\u6c42\uff01";
        }
        boolean isWan = ComConstants.isWan5(integerStr);
        int[] decimals = ComConstants.toIntArray(decimalStr);
        String result = ComConstants.getChineseInteger(integers, isWan) + ComConstants.getChineseDecimal(decimals);
        if (flag) {
            return "\u8d1f" + result;
        }
        return result;
    }

    private static int[] toIntArray(String number) {
        int[] array = new int[number.length()];
        for (int i = 0; i < number.length(); ++i) {
            array[i] = Integer.parseInt(number.substring(i, i + 1));
        }
        return array;
    }

    public static String getChineseInteger(int[] integers, boolean isWan) {
        StringBuffer chineseInteger = new StringBuffer("");
        int length = integers.length;
        if (length == 1 && integers[0] == 0) {
            return "";
        }
        for (int i = 0; i < length; ++i) {
            String key = "";
            if (integers[i] == 0) {
                if (length - i == 13) {
                    key = IUNIT[4];
                } else if (length - i == 9) {
                    key = IUNIT[8];
                } else if (length - i == 5 && isWan) {
                    key = IUNIT[4];
                } else if (length - i == 1) {
                    key = IUNIT[0];
                }
                if (length - i > 1 && integers[i + 1] != 0) {
                    key = key + NUMBERS[0];
                }
            }
            chineseInteger.append(integers[i] == 0 ? key : NUMBERS[integers[i]] + IUNIT[length - i - 1]);
        }
        return chineseInteger.toString();
    }

    private static String getChineseDecimal(int[] decimals) {
        StringBuffer chineseDecimal = new StringBuffer("");
        for (int i = 0; i < decimals.length && i != 3; ++i) {
            chineseDecimal.append(decimals[i] == 0 ? "" : NUMBERS[decimals[i]] + DUNIT[i]);
        }
        return chineseDecimal.toString();
    }

    private static boolean isWan5(String integerStr) {
        int length = integerStr.length();
        if (length > 4) {
            String subInteger = "";
            subInteger = length > 8 ? integerStr.substring(length - 8, length - 4) : integerStr.substring(0, length - 4);
            return Integer.parseInt(subInteger) > 0;
        }
        return false;
    }

    public static void main(String[] args) {
        String number = "12.56";
        System.out.println(number + ": " + ComConstants.toChinese(number));
        number = "1234567890563886.123";
        System.out.println(number + ": " + ComConstants.toChinese(number));
    }
}

