/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.dis.DisChannelReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractproDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsRelReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsLogReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmAddressReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhGoodsBean;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.oc.OcContractRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.oc.OcEsbContractRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.oc.OcRefundRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.oc.OcSapContractRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.sg.SgSendgoodsLogRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.wh.WhFreightFeeRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.wh.WhStockStateFeeRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.oc.EsbContractResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.oc.OcContractResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.oc.OcRefundResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.oc.SapContractResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.sg.SgSendgoodsLogResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.wh.WhFreightFeeResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.wh.WhStockStateResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusOrderService;
import com.yqbsoft.laser.service.ext.bus.data.service.impl.BusUserServiceImpl;
import com.yqbsoft.laser.service.ext.bus.data.supbase.OrderBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.OkhttpsUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

public class BusOrderServiceImpl
extends OrderBaseService
implements BusOrderService {
    private String SYS_CODE = "busdata.BusOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusOrderServiceImpl.class);
    private String ddcode = "order";
    @Autowired
    RestTempfacade restTempfacade;
    @Autowired
    OkhttpsUtils okhttpsUtils;

    @Override
    public String sendSaveBusOrder(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractDomain");
            return "error";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        OcContractRequest ocContractRequest = new OcContractRequest();
        ocContractRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        this.makeOcContractReDomain(ocContractDomain);
        ocContractRequest.setOrgTenantCode(ocContractDomain.getTenantCode());
        String t = this.getTenantCodeBuUrl(ocContractRequest.getHost());
        if (StringUtils.isNotBlank((String)t)) {
            ocContractDomain.setTenantCode(t);
        }
        ocContractRequest.getSendMap().put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        logger.info(this.SYS_CODE + ".sendSaveExGoods.req", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractRequest));
        OcContractResponse ocContractResponse = this.restTempfacade.execute(ocContractRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractResponse");
            return "error";
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractResponse", (Object)ocContractResponse.getMsg());
            return ocContractResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String getFreight(List<WhGoodsBean> whGoodsBeanList, String areaStr, String memberCode, String tenantCode) throws ApiException {
        if (ListUtil.isEmpty(whGoodsBeanList) || StringUtils.isBlank((String)areaStr) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getFreight.param");
            return "error";
        }
        WhFreightFeeRequest whFreightFeeRequest = new WhFreightFeeRequest();
        whFreightFeeRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        whFreightFeeRequest.setOrgTenantCode(tenantCode);
        String t = this.getTenantCodeBuUrl(whFreightFeeRequest.getHost());
        if (StringUtils.isBlank((String)t)) {
            t = tenantCode;
        }
        whFreightFeeRequest.getSendMap().put("whGoodsBeanList", JsonUtil.buildNormalBinder().toJson(whGoodsBeanList));
        whFreightFeeRequest.getSendMap().put("areaStr", areaStr);
        whFreightFeeRequest.getSendMap().put("memberCode", memberCode);
        whFreightFeeRequest.getSendMap().put("tenantCode", tenantCode);
        WhFreightFeeResponse whFreightFeeResponse = this.restTempfacade.execute(whFreightFeeRequest);
        if (null == whFreightFeeResponse) {
            logger.error(this.SYS_CODE + ".getFreight.whFreightFeeResponse");
            return "error";
        }
        if (!whFreightFeeResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".getFreight.whFreightFeeResponsemsg", (Object)whFreightFeeResponse.getMsg());
            return whFreightFeeResponse.getMsg();
        }
        return whFreightFeeResponse.getFreightFee().toString();
    }

    @Override
    public List<WhGoodsBean> getNewStockById(List<WhGoodsBean> whGoodsBeanList, String areaStr, String memberCode, String tenantCode) throws ApiException {
        if (ListUtil.isEmpty(whGoodsBeanList) || StringUtils.isBlank((String)areaStr) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getNewStockById.param");
            return null;
        }
        WhStockStateFeeRequest whStockStateFeeRequest = new WhStockStateFeeRequest();
        whStockStateFeeRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        whStockStateFeeRequest.setOrgTenantCode(tenantCode);
        String t = this.getTenantCodeBuUrl(whStockStateFeeRequest.getHost());
        if (StringUtils.isBlank((String)t)) {
            t = tenantCode;
        }
        whStockStateFeeRequest.getSendMap().put("whGoodsBeanList", JsonUtil.buildNormalBinder().toJson(whGoodsBeanList));
        whStockStateFeeRequest.getSendMap().put("areaStr", areaStr);
        whStockStateFeeRequest.getSendMap().put("memberCode", memberCode);
        whStockStateFeeRequest.getSendMap().put("tenantCode", tenantCode);
        WhStockStateResponse whStockStateResponse = this.restTempfacade.execute(whStockStateFeeRequest);
        if (null == whStockStateResponse) {
            logger.error(this.SYS_CODE + ".getNewStockById.whStockStateResponse");
            return null;
        }
        if (!whStockStateResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".getNewStockById.whStockStateResponse", (Object)whStockStateResponse.getMsg());
            return null;
        }
        return whStockStateResponse.getWhGoodsBeanList();
    }

    private void makeOcContractReDomain(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return;
        }
        String memberCcode = ocContractDomain.getMemberCcode();
        if (StringUtils.isBlank((String)memberCcode)) {
            return;
        }
        DisChannelReDomain disChannelReDomain = this.getDisChannelByMemberCcode(memberCcode, ocContractDomain.getTenantCode());
        if (null == disChannelReDomain) {
            return;
        }
        ocContractDomain.setChannelCode(disChannelReDomain.getChannelOcode());
    }

    @Override
    public String sendSaveBusRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund.ocRefundDomain");
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        OcRefundRequest ocRefundRequest = new OcRefundRequest();
        ocRefundRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundRequest, (Object)ocRefundDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.e", (Object)e);
            return "error";
        }
        OcRefundResponse ocRefundResponse = this.restTempfacade.execute(ocRefundRequest);
        if (null == ocRefundResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse");
            return "error";
        }
        if (!ocRefundResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse", (Object)ocRefundResponse.getMsg());
            return ocRefundResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoods.sgSendgoodsDomain");
            return "error";
        }
        String url = BusOrderServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9Domain", "AkanU9Domain");
        url = url + "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Map<String, String> context = BusUserServiceImpl.getContextMap(sgSendgoodsDomain.getMemberGcode(), BusOrderServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9EntCode", "AkanU9EntCode"));
        dataMap.put("context", context);
        dataMap.put("cust", "AKan");
        dataMap.put("aPIType", "ShipPlanSplit_Create");
        ArrayList paramList = new ArrayList();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("DocNo", sgSendgoodsDomain.getContractNbbillcode());
        param.put("IMSKey", sgSendgoodsDomain.getSendgoodsCode());
        param.put("Pub8", "");
        param.put("Pub19", "");
        param.put("Pub20", "");
        ArrayList subLineDTOS = new ArrayList();
        for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
            HashMap<String, String> subLine = new HashMap<String, String>();
            subLine.put("IMSLineKey", sgSendgoodsGoodsDomain.getSendgoodsGoodsCode());
            subLine.put("DocLineNo", sgSendgoodsGoodsDomain.getMemberContactQq());
            subLine.put("WHCode", sgSendgoodsGoodsDomain.getWarehouseCode());
            subLine.put("Qty", sgSendgoodsGoodsDomain.getGoodsCamount().toString());
            subLine.put("Prv1", sgSendgoodsDomain.getGoodsReceiptMem());
            subLine.put("Prv2", sgSendgoodsDomain.getGoodsReceiptPhone());
            subLine.put("Prv3", sgSendgoodsDomain.getGoodsReceiptArrdess());
            subLine.put("Prv6", sgSendgoodsGoodsDomain.getGoodsProperty5());
            subLineDTOS.add(subLine);
        }
        param.put("SubLineDTOS", subLineDTOS);
        paramList.add(param);
        dataMap.put("paramList", paramList);
        Map<String, String> header = BusOrderServiceImpl.getStringStringMap(sgSendgoodsDomain.getTenantCode());
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(dataMap), header, "busdata.busOrder.sendSaveBusSendgoods");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoods.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(header), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusSendgoods.ex1", (Throwable)e);
        }
        Long startTime = System.currentTimeMillis();
        logger.error(this.SYS_CODE + ".sendSaveBusSendgoods.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(dataMap) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoods.returnResultsMap" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusSendgoods.ex2");
        }
        Object code = returnResultsMap.get("d");
        if (null != code) {
            String dStr = JsonUtil.buildNormalBinder().toJson(code);
            List list = JsonUtil.buildNormalBinder().getJsonToList(dStr, Map.class);
            SgSendgoodsDomain sgSendgoodsNewDomain = new SgSendgoodsDomain();
            ArrayList<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomains = new ArrayList<SgSendgoodsGoodsDomain>();
            for (Map map : list) {
                String docNo = String.valueOf(map.get("DocNo"));
                String goodsSpec5 = String.valueOf(map.get("DocLineNo"));
                String sendgoodsGoodsCode = (String)map.get("IMSLineKey");
                String sendgoodsCode = (String)map.get("IMSKey");
                sgSendgoodsNewDomain.setSendgoodsCode(sendgoodsCode);
                sgSendgoodsNewDomain.setContractObillcode(docNo);
                SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain = new SgSendgoodsGoodsDomain();
                sgSendgoodsGoodsDomain.setSendgoodsGoodsCode(sendgoodsGoodsCode);
                sgSendgoodsGoodsDomain.setGoodsSpec5(goodsSpec5);
                sgSendgoodsGoodsDomains.add(sgSendgoodsGoodsDomain);
            }
            sgSendgoodsNewDomain.setSgSendgoodsGoodsDomainList(sgSendgoodsGoodsDomains);
            this.updateSendgoodsU9No(sgSendgoodsNewDomain);
            return "success";
        }
        logger.error(this.SYS_CODE + ".restServicesToU9.code.1" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".restServicesToU9.ex4");
    }

    public String updateSendgoodsU9No(SgSendgoodsDomain sgSendgoodsDomain) {
        String apiCode = "sg.sendgoods.updateSendgoodsU9No";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    @Override
    public String sendSaveBusSendgoodsLog(SgSendgoodsLogReDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsLogDomain.getTenantCode();
        SgSendgoodsLogRequest sgSendgoodsLogRequest = new SgSendgoodsLogRequest();
        sgSendgoodsLogRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsLogRequest, (Object)sgSendgoodsLogDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.e", (Object)e);
            return "error";
        }
        SgSendgoodsLogResponse sgSendgoodsLogResponse = this.restTempfacade.execute(sgSendgoodsLogRequest);
        if (null == sgSendgoodsLogResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse");
            return "error";
        }
        if (!sgSendgoodsLogResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse", (Object)sgSendgoodsLogResponse.getMsg());
            return sgSendgoodsLogResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefundToEsb(OcRefundReDomain ocRefundDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusRefundToEsb.ocRefundDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            return "error";
        }
        String esbKey = BusOrderServiceImpl.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = BusOrderServiceImpl.getDdFlag(ocRefundDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = BusOrderServiceImpl.getDdFlag(ocRefundDomain.getTenantCode(), "EsbRefundUrl", "EsbRefundUrl");
        String EsbWarehouseCode = BusOrderServiceImpl.getDdFlag(ocRefundDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = BusOrderServiceImpl.getDdFlag(ocRefundDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, String> entryOrder = new HashMap<String, String>();
        entryOrder.put("entryOrderCode", ocRefundDomain.getRefundCode());
        entryOrder.put("orderType", "THRK");
        entryOrder.put("warehouseCode", EsbWarehouseCode);
        entryOrder.put("ownerCode", EsbOwnerCode);
        HashMap orderLines = new HashMap();
        ArrayList orderLineList = new ArrayList();
        List<OcRefundGoodsDomain> refundGoodsList = ocRefundDomain.getOcRefundGoodsDomainList();
        for (OcRefundGoodsDomain goods : refundGoodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocRefundDomain.getTenantCode());
                relmap.put("goodsCode", goods.getGoodsCode());
                relmap.put("goodsRelType", "3");
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("itemCode", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ownerCode", EsbOwnerCode);
                    orderLine.put("itemName", rsGoodsRelReDomain.getGoodsName());
                    orderLine.put("planQty", goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum()));
                    orderLineList.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("ownerCode", EsbOwnerCode);
            orderLine.put("itemName", goods.getGoodsName());
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getRefundGoodsNum());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("entryOrder", entryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefundConfirmToEsb(OcRefundReDomain ocRefundDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusRefundConfirmToEsb.ocRefundDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            return "error";
        }
        String esbKey = BusOrderServiceImpl.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = BusOrderServiceImpl.getDdFlag(ocRefundDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = BusOrderServiceImpl.getDdFlag(ocRefundDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String KUNNR = BusOrderServiceImpl.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String NAME1 = BusOrderServiceImpl.getDdFlag(ocRefundDomain.getTenantCode(), "EsbNAME1", "EsbNAME1");
        String LGORT = BusOrderServiceImpl.getDdFlag(ocRefundDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = BusOrderServiceImpl.getDdFlag(ocRefundDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocSapContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcRefundGoodsDomain> ocRefundGoodsList = ocRefundDomain.getOcRefundGoodsDomainList();
        String date = BusOrderServiceImpl.getDate();
        int POSEX = 0;
        for (OcRefundGoodsDomain goods : ocRefundGoodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocRefundDomain.getTenantCode());
                relmap.put("goodsCode", goods.getGoodsCode());
                relmap.put("goodsRelType", "3");
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendSaveBusRefundConfirmToEsb.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("BSTKD", ocRefundDomain.getRefundCode());
                    orderLine.put("POSEX", ++POSEX);
                    orderLine.put("AUART", "ZG02");
                    orderLine.put("KUNNR", KUNNR);
                    orderLine.put("NAME1", NAME1);
                    orderLine.put("FKDAT", date);
                    orderLine.put("MATNR", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ARKTX", rsGoodsRelReDomain.getGoodsName());
                    BigDecimal multiply = goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum());
                    orderLine.put("KWMENG", multiply);
                    orderLine.put("ACTPR", rsGoodsRelReDomain.getPricesetNprice());
                    orderLine.put("WRBTR", rsGoodsRelReDomain.getPricesetNprice().multiply(multiply));
                    orderLine.put("WERKS", WERKS);
                    orderLine.put("LGORT", LGORT);
                    list.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocRefundDomain.getRefundCode());
            orderLine.put("POSEX", ++POSEX);
            orderLine.put("AUART", "ZG02");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocSapContractRequest.setMap(map);
        ocSapContractRequest.setClientsecret(esbSecret);
        ocSapContractRequest.setClientid(esbKey);
        ocSapContractRequest.setHost(url);
        SapContractResponse sapContractResponse = invoicefacade.execute(ocSapContractRequest);
        if (null == sapContractResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefundConfirmToEsb.esbContractResponse");
            return "error";
        }
        if (!sapContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainToEsb(OcContractReDomain ocContractDomain) {
        String[] split;
        logger.error(this.SYS_CODE + ".sendContractDomainToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbOrderUrl", "EsbOrderUrl");
        String EsbWarehouseCode = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        String EsbSourcePlatformCode = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbSourcePlatformCode", "EsbSourcePlatformCode");
        String EsbLogisticsCode = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbLogisticsCode", "EsbLogisticsCode");
        String EsbShopNick = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbShopNick", "EsbShopNick");
        String EsbSenderInfo = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbSenderInfo", "EsbSenderInfo");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, Object> deliveryOrder = new HashMap<String, Object>();
        deliveryOrder.put("deliveryOrderCode", ocContractDomain.getContractBillcode());
        deliveryOrder.put("orderType", "XSDD");
        deliveryOrder.put("warehouseCode", EsbWarehouseCode);
        deliveryOrder.put("ownerCode", EsbOwnerCode);
        deliveryOrder.put("sourcePlatformCode", EsbSourcePlatformCode);
        deliveryOrder.put("logisticsCode", EsbLogisticsCode);
        deliveryOrder.put("shopNick", EsbShopNick);
        HashMap orderLines = new HashMap();
        Map senderInfo = new HashMap();
        if (StringUtils.isNotBlank((String)EsbSenderInfo)) {
            senderInfo = JsonUtil.buildNormalBinder().getJsonToMap(EsbSenderInfo, String.class, Object.class);
            deliveryOrder.put("senderInfo", senderInfo);
        }
        HashMap<String, String> receiverInfo = new HashMap<String, String>();
        receiverInfo.put("name", ocContractDomain.getGoodsReceiptMem());
        receiverInfo.put("mobile", ocContractDomain.getGoodsReceiptPhone());
        if (ListUtil.isNotEmpty(ocContractDomain.getOcContractproDomainList())) {
            for (OcContractproDomain ocContractproDomain : ocContractDomain.getOcContractproDomainList()) {
                String[] umAddressReDomain;
                if (!"address".equals(ocContractproDomain.getContractproKey()) || null == (umAddressReDomain = (UmAddressReDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContractproDomain.getContractproValue(), UmAddressReDomain.class))) continue;
                receiverInfo.put("province", umAddressReDomain.getProvinceName());
                receiverInfo.put("city", umAddressReDomain.getCityName());
                String detailAddress = "";
                if (StringUtils.isNotBlank((String)umAddressReDomain.getProvinceName())) {
                    detailAddress = umAddressReDomain.getProvinceName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getCityName())) {
                    detailAddress = detailAddress + umAddressReDomain.getCityName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getAreaName())) {
                    detailAddress = detailAddress + umAddressReDomain.getAreaName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getRoadName())) {
                    detailAddress = detailAddress + umAddressReDomain.getRoadName();
                }
                receiverInfo.put("detailAddress", detailAddress);
            }
        }
        if (null == receiverInfo.get("detailAddress") && (split = ocContractDomain.getGoodsReceiptArrdess().split(",")).length > 3) {
            receiverInfo.put("province", split[0]);
            receiverInfo.put("city", split[1]);
            String detailAddress = "";
            for (String str : split) {
                detailAddress = detailAddress + str;
            }
            receiverInfo.put("detailAddress", detailAddress);
        }
        deliveryOrder.put("receiverInfo", receiverInfo);
        ArrayList orderLineList = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain goods : goodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocContractDomain.getTenantCode());
                relmap.put("goodsCode", goods.getGoodsCode());
                relmap.put("goodsRelType", "3");
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("itemCode", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("planQty", goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum()));
                    orderLineList.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getGoodsCamount());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("deliveryOrder", deliveryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainEndToEsb(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendContractDomainEndToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbOderCancelUrl", "EsbOderCancelUrl");
        String EsbWarehouseCode = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("warehouseCode", EsbWarehouseCode);
        request.put("ownerCode", EsbOwnerCode);
        request.put("orderCode", ocContractDomain.getContractBillcode());
        request.put("orderType", "XSDD");
        request.put("cancelType", "out");
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    private static String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyMMdd");
        return df.format(new Date());
    }

    @Override
    public String sendContractDomainConfirmToEsb(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendContractDomainConfirmToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String KUNNR = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String NAME1 = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbNAME1", "EsbNAME1");
        String LGORT = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = BusOrderServiceImpl.getDdFlag(ocContractDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocEsbContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        int POSEX = 0;
        for (OcContractGoodsDomain goods : goodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocContractDomain.getTenantCode());
                relmap.put("goodsCode", goods.getGoodsCode());
                relmap.put("goodsRelType", "3");
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
                    orderLine.put("POSEX", ++POSEX);
                    orderLine.put("AUART", "ZG01");
                    orderLine.put("KUNNR", KUNNR);
                    orderLine.put("NAME1", NAME1);
                    orderLine.put("FKDAT", date);
                    orderLine.put("MATNR", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ARKTX", rsGoodsRelReDomain.getGoodsName());
                    BigDecimal multiply = goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum());
                    orderLine.put("KWMENG", multiply);
                    orderLine.put("ACTPR", rsGoodsRelReDomain.getPricesetNprice());
                    orderLine.put("WRBTR", rsGoodsRelReDomain.getPricesetNprice().multiply(multiply));
                    orderLine.put("WERKS", WERKS);
                    orderLine.put("LGORT", LGORT);
                    list.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
            orderLine.put("POSEX", ++POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        SapContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    public static void main(String[] args) {
        String esbKey = "WYDS-TRMF98BC";
        String esbSecret = "WYDS#@YFD";
        String url = "https://ipaasqas.rifeng.com.cn:31443/298153907928989696/SAP/ZR_SEND_ORDER_TO_SAP_C/1.0.0";
        String POSEX = "1";
        String KUNNR = "105911";
        String NAME1 = "\u7f8e\u5c45\u5e97";
        String LGORT = "9100";
        String WERKS = "1101";
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setGoodsReceiptArrdess("\u9655\u897f,\u5b9d\u9e21\u5e02,\u9648\u4ed3\u533a,\u78fb\u6eaa\u9547,\u6d4b\u8bd5");
        ocContractDomain.setGoodsReceiptMem("\u6d4b\u8bd5\u7528\u6237");
        ocContractDomain.setGoodsReceiptPhone("15515425755");
        ocContractDomain.setContractBillcode("DS2022081515040000003");
        ArrayList<OcContractGoodsDomain> goodsDomains = new ArrayList<OcContractGoodsDomain>();
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        ocContractGoodsDomain.setSkuNo("1100012026");
        ocContractGoodsDomain.setGoodsName("\u660e\u6746\u6dcb\u6d74\u82b1\u6d12");
        ocContractGoodsDomain.setPricesetNprice(new BigDecimal(99));
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        goodsDomains.add(ocContractGoodsDomain);
        OcContractGoodsDomain ocContractGoodsDomain2 = new OcContractGoodsDomain();
        ocContractGoodsDomain2.setSkuNo("1100020379");
        ocContractGoodsDomain2.setGoodsName("\u660e\u6746\u6dcb\u6d74\u82b1\u6d12");
        ocContractGoodsDomain2.setPricesetNprice(new BigDecimal(99));
        ocContractGoodsDomain2.setGoodsCamount(new BigDecimal("1"));
        goodsDomains.add(ocContractGoodsDomain2);
        ocContractDomain.setGoodsList(goodsDomains);
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocEsbContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
            orderLine.put("POSEX", POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        SapContractResponse execute = invoicefacade.execute(ocEsbContractRequest);
        if (null == execute) {
            System.out.println("null");
        }
        if (!execute.getSuccess().booleanValue()) {
            System.out.println("error");
        }
        System.out.println(execute.getDataObj());
    }

    private String checkOrderInfoToU9Parameter(OcContractReDomain ocContractDomain) {
        if (StringUtils.isEmpty((String)ocContractDomain.getDocNo())) {
            return "U9\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtils.isEmpty(ocContractDomain.getGoodsList())) {
            return "\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtils.isEmpty((Object)ocContractDomain.getPricesetCurrency1())) {
            return "\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    @Override
    public String restServicesToU9(OcContractReDomain ocContractDomain) throws ApiException {
        String msg = this.checkOrderInfoToU9Parameter(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".restServicesToU9.msg", (Object)msg);
            throw new ApiException(msg);
        }
        logger.info(this.SYS_CODE + ".restServicesToU9", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        String url = BusOrderServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9Domain", "AkanU9Domain") + "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Map<String, String> context = BusUserServiceImpl.getContextMap(ocContractDomain.getMemberGcode(), BusOrderServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9EntCode", "AkanU9EntCode"));
        dataMap.put("context", context);
        dataMap.put("cust", "AKan");
        dataMap.put("aPIType", "SOLine_Close");
        ArrayList paramList = new ArrayList();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("DocNo", ocContractDomain.getDocNo());
        ArrayList subLineDTOS = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, String> subLine = new HashMap<String, String>();
            subLine.put("DocLineNo", goods.getDocLineNo());
            subLine.put("Qty", goods.getGoodsNum().toString());
            subLine.put("Price", goods.getContractGoodsPrice().toString());
            subLineDTOS.add(subLine);
        }
        param.put("SubLineDTOS", subLineDTOS);
        paramList.add(param);
        dataMap.put("paramList", paramList);
        Map<String, String> header = BusOrderServiceImpl.getStringStringMap(ocContractDomain.getTenantCode());
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(dataMap), header, "busdata.busOrder.restServicesToU9");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".restServicesToU9.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(header), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".restServicesToU9.ex1", (Throwable)e);
        }
        Long startTime = System.currentTimeMillis();
        logger.error(this.SYS_CODE + ".restServicesToU9.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(dataMap) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".restServicesToU9.returnResultsMap" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendRecharge.ex2");
        }
        Object code = returnResultsMap.get("d");
        if (null != code) {
            String dStr = JsonUtil.buildNormalBinder().toJson(code);
            List list = JsonUtil.buildNormalBinder().getJsonToList(dStr, Map.class);
            Map returnResultsObjMap = (Map)list.get(0);
            String code1 = (String)returnResultsObjMap.get("Flag");
            String message = "";
            if (returnResultsObjMap.get("Message") != null) {
                message = returnResultsObjMap.get("Message").toString();
            }
            if ("True".equals(code1)) {
                String docNo = (String)returnResultsObjMap.get("DocNo");
                return message;
            }
            logger.error(this.SYS_CODE + ".restServicesToU9.code" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".restServicesToU9.ex3" + message);
        }
        logger.error(this.SYS_CODE + ".restServicesToU9.code.1" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".restServicesToU9.ex4");
    }

    @Override
    public String sendgoodsCancel(List<SgSendgoodsReDomain> sgSendgoodsDomains) {
        if (CollectionUtils.isEmpty(sgSendgoodsDomains)) {
            logger.error(this.SYS_CODE + ".sendgoodsCancel.isnull", sgSendgoodsDomains);
            return "success";
        }
        String url = BusOrderServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9Domain", "AkanU9Domain");
        url = url + "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        SgSendgoodsReDomain sgSendgoodsReDomain = sgSendgoodsDomains.get(0);
        Map<String, String> context = BusUserServiceImpl.getContextMap(sgSendgoodsReDomain.getMemberGcode(), BusOrderServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9EntCode", "AkanU9EntCode"));
        dataMap.put("context", context);
        dataMap.put("cust", "AKan");
        dataMap.put("aPIType", "ShipPlanLine_Close_Create");
        ArrayList paramList = new ArrayList();
        for (SgSendgoodsReDomain sgSendgoodsDomain : sgSendgoodsDomains) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("DocNo", sgSendgoodsDomain.getContractObillcode());
            param.put("SrcDocNo", sgSendgoodsDomain.getContractNbbillcode());
            param.put("Pub", "");
            param.put("Prv", "");
            param.put("Prv30", sgSendgoodsDomain.getSendgoodsCode());
            ArrayList subLineDTOS = new ArrayList();
            for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
                HashMap<String, String> subLine = new HashMap<String, String>();
                subLine.put("DocLineNo", sgSendgoodsGoodsDomain.getGoodsSpec4());
                subLine.put("SrcDocLineNo", sgSendgoodsGoodsDomain.getMemberContactQq());
                subLine.put("WHCode", sgSendgoodsGoodsDomain.getWarehouseCode());
                subLine.put("Qty", sgSendgoodsGoodsDomain.getGoodsNum().toString());
                subLine.put("Prv30", sgSendgoodsGoodsDomain.getSendgoodsGoodsCode());
                subLineDTOS.add(subLine);
            }
            param.put("SubLineDTOS", subLineDTOS);
            paramList.add(param);
        }
        dataMap.put("paramList", paramList);
        Map<String, String> header = BusOrderServiceImpl.getStringStringMap(sgSendgoodsReDomain.getTenantCode());
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(dataMap), header, "busdata.busOrder.sendgoodsCancel");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendgoodsCancel.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(header), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendgoodsCancel.ex1", (Throwable)e);
        }
        Long startTime = System.currentTimeMillis();
        logger.error(this.SYS_CODE + ".sendgoodsCancel.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(dataMap) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".restServicesToU9.returnResultsMap" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendgoodsCancel.ex2");
        }
        Object code = returnResultsMap.get("d");
        if (null != code) {
            String dStr = JsonUtil.buildNormalBinder().toJson(code);
            List list = JsonUtil.buildNormalBinder().getJsonToList(dStr, Map.class);
            Map returnResultsObjMap = (Map)list.get(0);
            String code1 = (String)returnResultsObjMap.get("Flag");
            String message = "";
            if (returnResultsObjMap.get("Message") != null) {
                message = returnResultsObjMap.get("Message").toString();
            }
            if ("True".equals(code1)) {
                return message;
            }
            logger.error(this.SYS_CODE + ".sendgoodsCancel.code" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".sendgoodsCancel.ex3" + message);
        }
        logger.error(this.SYS_CODE + ".sendgoodsCancel.code.1" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendgoodsCancel.ex4");
    }

    @Override
    public String closeServicesToU9(OcRefundReDomain ocRefundReDomain) throws ApiException {
        String msg = this.checkCloseServicesToU9(ocRefundReDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".closeServicesToU9.msg", (Object)msg);
            throw new ApiException(msg);
        }
        logger.info(this.SYS_CODE + ".closeServicesToU9", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundReDomain));
        String url = BusOrderServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9Domain", "AkanU9Domain") + "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Map<String, String> context = BusUserServiceImpl.getContextMap(ocRefundReDomain.getMemberGcode(), BusOrderServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9EntCode", "AkanU9EntCode"));
        dataMap.put("context", context);
        dataMap.put("cust", "AKan");
        dataMap.put("aPIType", "SOLine_Close");
        ArrayList paramList = new ArrayList();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("DocNo", ocRefundReDomain.getContractNbbillcode());
        ArrayList subLineDTOS = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocRefundReDomain.getGoodsList();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, String> subLine = new HashMap<String, String>();
            subLine.put("DocLineNo", goods.getMemberContactQq());
            subLineDTOS.add(subLine);
        }
        param.put("SubLineDTOS", subLineDTOS);
        paramList.add(param);
        dataMap.put("paramList", paramList);
        Map<String, String> header = BusOrderServiceImpl.getStringStringMap(ocRefundReDomain.getTenantCode());
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(dataMap), header, "busdata.busOrder.closeServicesToU9");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".closeServicesToU9.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(header), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".closeServicesToU9.ex1", (Throwable)e);
        }
        Long startTime = System.currentTimeMillis();
        logger.error(this.SYS_CODE + ".closeServicesToU9.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(dataMap) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".closeServicesToU9.returnResultsMap" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendRecharge.ex2");
        }
        Object code = returnResultsMap.get("d");
        if (null != code) {
            String dStr = JsonUtil.buildNormalBinder().toJson(code);
            List list = JsonUtil.buildNormalBinder().getJsonToList(dStr, Map.class);
            Map returnResultsObjMap = (Map)list.get(0);
            String code1 = (String)returnResultsObjMap.get("Flag");
            String message = "";
            if (returnResultsObjMap.get("Message") != null) {
                message = returnResultsObjMap.get("Message").toString();
            }
            if ("True".equals(code1)) {
                return message;
            }
            logger.error(this.SYS_CODE + ".closeServicesToU9.code" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".closeServicesToU9.ex3" + message);
        }
        logger.error(this.SYS_CODE + ".closeServicesToU9.code.1" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".closeServicesToU9.ex4");
    }

    private String checkCloseServicesToU9(OcRefundReDomain ocRefundReDomain) {
        if (ocRefundReDomain == null) {
            return "\u9000\u5355\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isNotEmpty(ocRefundReDomain.getGoodsList())) {
            return "\u9000\u5355\u5546\u54c1\u884c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    @Override
    public String sendBusOrderToU9(OcContractReDomain ocContractDomain) throws ApiException {
        String msg = this.checkBusOrderToU9(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendBusOrderToU9.msg", (Object)msg);
            throw new ApiException(msg);
        }
        logger.info(this.SYS_CODE + ".sendBusOrderToU9", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        String url = BusOrderServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9Domain", "AkanU9Domain") + "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Map<String, String> context = BusUserServiceImpl.getContextMap(ocContractDomain.getMemberGcode(), BusOrderServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9EntCode", "AkanU9EntCode"));
        dataMap.put("context", context);
        dataMap.put("cust", "AKan");
        dataMap.put("aPIType", "SO_Create_Approve");
        ArrayList paramList = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("IMSKey", ocContractDomain.getContractBillcode());
            param.put("IMSLineKey", goods.getContractGoodsCode());
            String docType = BusOrderServiceImpl.getDdFlag(ComConstants.tenantCode, "DocType", ocContractDomain.getPricesetCurrency1());
            if (StringUtils.isBlank((String)docType)) {
                throw new ApiException("OMS\u8ba2\u5355\u7c7b\u578b\uff1a" + ocContractDomain.getPricesetCurrency1() + "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684U9\u8ba2\u5355\u7c7b\u578b");
            }
            param.put("DocType", docType);
            param.put("TradeCode", ocContractDomain.getContractBillcode());
            param.put("OrderItemId", goods.getContractGoodsCode());
            param.put("BusinessDate", ocContractDomain.getGmtCreate());
            param.put("DeliveryDate", goods.getGoodsDay());
            param.put("ItemCode", goods.getSkuNo());
            param.put("CustCode", ocContractDomain.getCustrelCode());
            param.put("Qty", goods.getGoodsNum());
            param.put("OrderPrice", goods.getPricesetMakeprice());
            param.put("Price", goods.getContractGoodsPrice());
            param.put("Pub27", goods.getContractGoodsOprice());
            if (goods.getContractGoodsOrefnum() != null) {
                param.put("Pub26", goods.getContractGoodsOrefnum());
                param.put("Pub28", goods.getContractGoodsOrefnum().multiply(goods.getGoodsNum()));
            }
            if ("11".equals(ocContractDomain.getPricesetCurrency1())) {
                param.put("Pub36", "true");
            }
            param.put("Pub39", "");
            param.put("Pub47", "");
            param.put("Prv1", ocContractDomain.getGoodsReceiptMem());
            param.put("Prv2", ocContractDomain.getGoodsReceiptPhone());
            param.put("Prv3", ocContractDomain.getGoodsReceiptArrdess());
            param.put("Prv4", goods.getWarehouseCode());
            param.put("Prv5", goods.getMschannelCode());
            paramList.add(param);
        }
        dataMap.put("paramList", paramList);
        Map<String, String> header = BusOrderServiceImpl.getStringStringMap(ocContractDomain.getTenantCode());
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(dataMap), header, "busdata.busOrder.sendBusOrderToU9");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendBusOrderToU9.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(header), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendBusOrderToU9.ex1", (Throwable)e);
        }
        Long startTime = System.currentTimeMillis();
        logger.error(this.SYS_CODE + ".sendBusOrderToU9.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(dataMap) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendBusOrderToU9.returnResultsMap" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendRecharge.ex2");
        }
        Object code = returnResultsMap.get("d");
        if (null != code) {
            String dStr = JsonUtil.buildNormalBinder().toJson(code);
            List list = JsonUtil.buildNormalBinder().getJsonToList(dStr, Map.class);
            for (Map map : list) {
                ocContractDomain.setContractNbbillcode(String.valueOf(map.get("DocNo")));
                for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
                    String imsLineKey = String.valueOf(map.get("IMSLineKey"));
                    String contractGoodsCode = ocContractGoodsDomain.getContractGoodsCode();
                    if (!contractGoodsCode.equals(imsLineKey)) continue;
                    ocContractGoodsDomain.setMemberContactQq(String.valueOf(map.get("DocLineNo")));
                }
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            this.restTempfacade.internalInvoke("oc.contract.updateOrderU9No", paramMap);
            return "success";
        }
        logger.error(this.SYS_CODE + ".sendBusOrderToU9.code.1" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendBusOrderToU9.ex4");
    }

    private String checkBusOrderToU9(OcContractReDomain ocContractDomain) {
        if (ocContractDomain == null) {
            return "\u8ba2\u5355\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty(ocContractDomain.getGoodsList())) {
            return "\u8ba2\u5355\u5546\u54c1\u884c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private static Map<String, String> getStringStringMap(String tenantCode) {
        String hacckey;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("haccid", "256");
        header.put("hacckey", "97269a9502214c11bcf91b33a15c71c6");
        String haccid = BusOrderServiceImpl.getddFlag(tenantCode, "haccid", "haccid");
        if (StringUtils.isNotBlank((String)haccid)) {
            header.put("haccid", haccid);
        }
        if (StringUtils.isNotBlank((String)(hacckey = BusOrderServiceImpl.getddFlag(tenantCode, "hacckey", "hacckey")))) {
            header.put("hacckey", hacckey);
        }
        return header;
    }

    protected static String getddFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }
}

