/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.api.ExOrderService;
import com.yqbsoft.laser.service.ext.bus.data.common.LogRouterlogDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcPackageDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundSettlDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoods;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsGoods;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsLogDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsPackageDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfo;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoapply;
import com.yqbsoft.laser.service.ext.bus.data.domain.vd.VdFaccountInfo;
import com.yqbsoft.laser.service.ext.bus.data.enums.MessageEnum;
import com.yqbsoft.laser.service.ext.bus.data.supbase.OrderBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.util.CollectionUtils;

public class ExOrderServiceImpl
extends OrderBaseService
implements ExOrderService {
    private String SYS_CODE = "busdata.ExOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(ExOrderServiceImpl.class);

    @Override
    public SupQueryResult<OcRefundReDomain> queryExRefund(String dwStartTime, String dwEndTime, Integer pageIndex, Integer pageSize, String refundGoodsType, String contractBillcode, String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (dwStartTime != null && dwEndTime != null) {
            map.put("gmtModifiedQstart", dwStartTime);
            map.put("gmtModifiedQend", dwEndTime);
        }
        if (refundGoodsType != null) {
            map.put("refundType", refundGoodsType);
        }
        if (contractBillcode != null) {
            map.put("contractBillcode", contractBillcode);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("tenantCode", tenantCode);
        return this.queryOcRefundPage(map);
    }

    @Override
    public String updateExSendgoods(String sendgoodsCode, String expressName, String expressCode, String packageBillno, String sendgoodsGetdate) {
        SgSendgoodsGoods sg = this.getSendgoodsGoodsByCode(sendgoodsCode);
        if (null == sg) {
            return "\u53d1\u8d27\u5355\u3010" + sendgoodsCode + "\u3011\u4e0d\u5b58\u5728";
        }
        SgSendgoodsPackageDomain sgSendgoodsPackageDomain = new SgSendgoodsPackageDomain();
        sgSendgoodsPackageDomain.setTenantCode(sg.getTenantCode());
        return "success";
    }

    @Override
    public String sendSaveExSgSendgoodsPackage(SgSendgoodsPackageDomain sendgoodsPackageDomain) {
        if (null == sendgoodsPackageDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExSgSendgoodsPackage");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSgSendgoodsPackage", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkSendgoodsPackageDomain(sendgoodsPackageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExSgSendgoodsPackage.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSgSendgoodsPackage.msg", msg);
        }
        this.sendSaveSendgoodsPackage(sendgoodsPackageDomain);
        return this.sendSendgoodsNext(sendgoodsPackageDomain.getSendgoodsCode(), sendgoodsPackageDomain.getTenantCode(), null);
    }

    private String checkSendgoodsPackageDomain(SgSendgoodsPackageDomain sendgoodsPackageDomain) {
        String msg = "";
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getSendgoodsCode())) {
            msg = msg + "\u53d1\u8d27\u5355\u53f7 sendgoodsCode \u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u53f7 tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getExpressCode())) {
            msg = msg + "\u7269\u6d41\u516c\u53f8\u4ee3\u7801 expressCode \u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getExpressName())) {
            msg = msg + "\u7269\u6d41\u516c\u53f8\u540d\u79f0 expressName \u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getPackageBillno())) {
            msg = msg + "\u7269\u6d41\u5355\u53f7 packageBillno \u4e3a\u7a7a\uff01";
        }
        return msg;
    }

    @Override
    public SupQueryResult<SgSendgoodsReDomain> queryContractsChange(boolean childFlag, String brandChannelCode, String dwStartTime, String dwEndTime, Integer pageIndex, Integer pageSize, Integer orderStatus, String contractBillcode, String tenantCode) {
        logger.info("brandChannelCode:" + brandChannelCode + "dwStartTime:" + dwStartTime + "--dwEndTime" + dwEndTime + "--orderStatus" + orderStatus);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (brandChannelCode != null) {
            map.put("memberCcode", brandChannelCode);
        }
        if (dwStartTime != null && dwEndTime != null) {
            map.put("gmtModifiedQstart", dwStartTime);
            map.put("gmtModifiedQend", dwEndTime);
        }
        if (orderStatus != null) {
            map.put("dataState", orderStatus);
        }
        if (contractBillcode != null) {
            map.put("contractBillcode", contractBillcode);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("goodsProFlag", true);
        map.put("goodsFlag", childFlag);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult ocContractReDomainSupQueryResult = this.getQueryResutl("sg.sendgoods.querySgSendgoodsPageReDomain", pMap, SgSendgoodsReDomain.class);
        if (ocContractReDomainSupQueryResult == null) {
            return new SupQueryResult();
        }
        if (ocContractReDomainSupQueryResult.getRows() == null) {
            return new SupQueryResult();
        }
        logger.info("\u8fd4\u56de\u5217\u8868\u6570\u636e:{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomainSupQueryResult));
        return ocContractReDomainSupQueryResult;
    }

    @Override
    public String sendSaveExOrder(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.msg", msg);
        }
        try {
            msg = this.makeOcContractDomain(ocContractDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                logger.error(this.SYS_CODE + ".sendSaveExOrder.makeOcContractDomain", (Object)msg);
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.makeOcContractDomain", msg);
            }
            String contractBillcode = this.saveOrder(ocContractDomain);
            if (StringUtils.isBlank((String)contractBillcode)) {
                logger.error(this.SYS_CODE + ".sendSaveExOrder.contractBillcode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.contractBillcode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(contractBillcode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendContractState(String contractNbillcode, String channelCode, String tenantCode, String type, Map<String, Object> map) {
        if (StringUtils.isBlank((String)type)) {
            logger.error(this.SYS_CODE + ".sendContractState");
            return this.makeErrorReturn(this.SYS_CODE + ".sendContractState", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String contractBillcode = null;
        String msg = this.checkQueryContract(contractNbillcode, channelCode, tenantCode);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.msg", msg);
        }
        QueryResult<OcContractReDomain> qlist = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode,channelCode", new Object[]{contractNbillcode, tenantCode, channelCode}));
        if (null == qlist || !ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.contractBillcode", "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        contractBillcode = ((OcContractReDomain)qlist.getList().get(0)).getContractBillcode();
        try {
            if (type.equals("AN")) {
                this.orderNext(contractBillcode, tenantCode, map);
            } else if (type.equals("AB")) {
                this.orderBack(contractBillcode, tenantCode, map);
            }
            return "success";
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendRefundState(String refundNcode, String channelCode, String tenantCode, String type, Map<String, Object> map) {
        if (StringUtils.isBlank((String)type) || MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendRefundState");
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String refundCode = null;
        String msg = this.checkQueryRefund(refundNcode, channelCode, tenantCode);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendRefundState.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState.msg", msg);
        }
        QueryResult<OcRefundReDomain> qlist = this.queryRefundPage(this.getQueryMapParam("refundNcode,tenantCode,channelCode", new Object[]{refundNcode, tenantCode, channelCode}));
        if (null == qlist || !ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState.msg", "refundNcode[" + refundNcode + "]\u4e0d\u5b58\u5728! ");
        }
        refundCode = ((OcRefundReDomain)qlist.getList().get(0)).getRefundCode();
        try {
            if (type.equals("AN")) {
                this.refundNext(refundCode, tenantCode, map);
            } else if (type.equals("AB")) {
                this.refundBack(refundCode, tenantCode, map);
            }
            return "success";
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExRefund(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.ocRefundDomain");
            throw new ApiException(this.SYS_CODE + ".sendSaveExRefund.ocRefundDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkRefund(ocRefundDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.msg", (Object)msg);
            throw new ApiException(this.SYS_CODE + ".sendSaveExRefund.msg", msg);
        }
        ArrayList<OcRefundSettlDomain> ocRefundSettlDomainList = new ArrayList<OcRefundSettlDomain>();
        OcRefundSettlDomain ocRefundSettlDomain = new OcRefundSettlDomain();
        ocRefundSettlDomain.setTenantCode(ComConstants.tenantCode);
        ocRefundSettlDomain.setContractSettlOpno(this.queryAccountId(ocRefundDomain));
        ocRefundSettlDomain.setMemberBcode(ocRefundDomain.getMemberBcode());
        ocRefundSettlDomain.setMemberBname(ocRefundDomain.getMemberBname());
        ocRefundSettlDomain.setMemberCode("20000210463648");
        ocRefundSettlDomain.setContractSettlType("0");
        ocRefundSettlDomain.setContractSettlBlance("VD");
        ocRefundSettlDomain.setContractPmode("0");
        ocRefundSettlDomain.setContractSettlGmoney(ocRefundDomain.getRefundMoney());
        ocRefundSettlDomain.setContractSettlPmoney(ocRefundDomain.getRefundMoney());
        ocRefundSettlDomain.setContractSettlOpemo("01");
        ocRefundSettlDomain.setRefundSettlBillcode(ocRefundDomain.getRefundOcode());
        ocRefundSettlDomain.setContractSettlBillcode(ocRefundDomain.getRefundOcode());
        ocRefundSettlDomainList.add(ocRefundSettlDomain);
        ocRefundDomain.setOcRefundSettlDomainList(ocRefundSettlDomainList);
        ocRefundDomain.setTenantCode(ComConstants.tenantCode);
        ocRefundDomain.setRefundType("U07");
        ocRefundDomain.setGoodsClass("B2B");
        try {
            msg = this.makeOcRefundDomain(ocRefundDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                logger.error(this.SYS_CODE + ".sendSaveExRefund.makeOcRefundDomain", (Object)msg);
                throw new ApiException(this.SYS_CODE + ".sendSaveExRefund.makeOcRefundDomain", msg);
            }
            ocRefundDomain.setGoodsClass("B2B");
            String refundCode = this.saveRefund(ocRefundDomain);
            if (StringUtils.isBlank((String)refundCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExRefund.refundCode");
                throw new ApiException(this.SYS_CODE + ".sendSaveExRefund.refundCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(refundCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.e", (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveExRefund.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.e1", (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveExRefund.e1", e.getMessage());
        }
    }

    private String queryAccountId(OcRefundDomain ocRefundDomain) {
        HashMap<String, Object> userinfoParamMap3 = new HashMap<String, Object>();
        userinfoParamMap3.put("userinfoChannelCode", ocRefundDomain.getMemberGcode());
        userinfoParamMap3.put("dateState", 1);
        userinfoParamMap3.put("userinfoCode", ocRefundDomain.getMemberBcode());
        HashMap<String, String> invokeMap3 = new HashMap<String, String>();
        invokeMap3.put("map", JsonUtil.buildNonNullBinder().toJson(userinfoParamMap3));
        QueryResult quresult3 = this.getQueryResutl("um.umUserinfoapply.queryUserinfoapplyPage", invokeMap3, UmUserinfoapply.class);
        if (quresult3.getList() == null || CollectionUtils.isEmpty((Collection)quresult3.getList())) {
            throw new ApiException("\u7528\u6237\u4fe1\u606f\u7533\u8bf7\u8868\u6682\u672a\u67e5\u5230");
        }
        UmUserinfoapply umUserinfoapply = (UmUserinfoapply)quresult3.getList().get(0);
        String message = MessageEnum.getMessage(umUserinfoapply.getUserinfoDischannelcode(), "01");
        if (StringUtils.isBlank((String)message)) {
            throw new ApiException("MessageEnum\u6682\u672a\u5339\u914d\u5230");
        }
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("type", "01");
        map1.put("merchantCode", ocRefundDomain.getMemberBcode());
        map1.put("faccountType", message);
        HashMap<String, String> invokeMap1 = new HashMap<String, String>();
        invokeMap1.put("map", JsonUtil.buildNonNullBinder().toJson(map1));
        QueryResult quresult1 = this.getQueryResutl("vd.faccount.queryOuterFaccountInfoPage", invokeMap1, VdFaccountInfo.class);
        if (quresult1 == null || CollectionUtils.isEmpty((Collection)quresult1.getList())) {
            throw new ApiException("\u8d26\u6237\u4fe1\u606f\u6682\u672a\u67e5\u5230");
        }
        return ((VdFaccountInfo)quresult1.getList().get(0)).getFaccountOuterNo();
    }

    @Override
    public String sendSaveExSendgoods(SgSendgoodsDomain sgSendgoodsDomain) {
        LogRouterlogDomain logRouterlogDomain = this.creteLogRouterlogDomain(JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain), "busdata.exOrder.sendSaveExSendgoods", null, "\u53d1\u8d27\u5355\u53d1\u8d27\u63a5\u53e3");
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.sgSendgoodsDomain");
            logRouterlogDomain.setRouterlogReturn("\u53c2\u6570\u4e3a\u7a7a");
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            throw new ApiException(this.SYS_CODE + ".sendSaveExSendgoods.sgSendgoodsDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkSendgoods(sgSendgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.msg", (Object)msg);
            logRouterlogDomain.setRouterlogReturn(msg);
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            throw new ApiException(this.SYS_CODE + ".sendSaveExSendgoods.msg", msg);
        }
        logRouterlogDomain.setAppmanageOicode(sgSendgoodsDomain.getSendgoodsCode());
        String tenantCode = sgSendgoodsDomain.getTenantCode();
        sgSendgoodsDomain.setMemberCode(this.getTeananMemberCode(tenantCode));
        sgSendgoodsDomain.setMemberName("\u5e73\u53f0");
        try {
            String sendgoodsCode = this.saveSendgoods(sgSendgoodsDomain);
            if (StringUtils.isBlank((String)sendgoodsCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExSendgoods.sendgoodsCode");
                throw new ApiException(this.SYS_CODE + ".sendSaveExSendgoods.sendgoodsCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            logRouterlogDomain.setRouterlogReturn(this.makeSuccessReturn(sendgoodsCode));
            logRouterlogDomain.setRouterlogReturnstate("200");
            logRouterlogDomain.setRouterlogReturnstates("OK");
            this.sendLog(logRouterlogDomain);
            return this.makeSuccessReturn(sendgoodsCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.e", (Throwable)e);
            logRouterlogDomain.setRouterlogReturn(e.getErrMsg());
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            throw new ApiException(this.SYS_CODE + ".sendSaveExSendgoods.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.e1", (Throwable)e);
            logRouterlogDomain.setRouterlogReturn(e.getMessage());
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            throw new ApiException(this.SYS_CODE + ".sendSaveExSendgoods.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExSendgoodsLog(SgSendgoodsLogDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain");
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkSendgoodsLog(sgSendgoodsLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.msg");
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.msg", msg);
        }
        try {
            String sendgoodsLogCode = this.saveSendgoodsLog(sgSendgoodsLogDomain);
            if (StringUtils.isBlank((String)sendgoodsLogCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExOrder.sendgoodsLogCode");
                throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.sendgoodsLogCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(sendgoodsLogCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendQueryExOcContract(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExOcContract.map");
            throw new ApiException(this.SYS_CODE + ".sendQueryExOcContract.map", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExOcContract.msg");
            throw new ApiException(this.SYS_CODE + ".sendQueryExOcContract.msg", msg);
        }
        if (StringUtils.isBlank((String)((String)map.get("childFlag")))) {
            map.put("childFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("goodsProFlag")))) {
            map.put("goodsProFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("sendGoodsFlag")))) {
            map.put("sendGoodsFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("packFlag")))) {
            map.put("packFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("settleFlag")))) {
            map.put("settleFlag", "true");
        }
        return this.makeSuccessReturn(this.queryOrderReDomainPage(map));
    }

    @Override
    public String sendQueryExRefund(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExRefund.map");
            return null;
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExRefund.msg");
            throw new ApiException(this.SYS_CODE + ".sendQueryExRefund.msg", msg);
        }
        if (StringUtils.isBlank((String)((String)map.get("ocContractProFlag")))) {
            map.put("ocContractProFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("ocContractGoodsFlag")))) {
            map.put("ocContractGoodsFlag", "true");
        }
        return this.makeSuccessReturn(this.queryRefundReDoaminPage(map));
    }

    @Override
    public String sendQueryExSgSendgoods(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExSgSendgoods.map");
            return null;
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExSgSendgoods.msg");
            throw new ApiException(this.SYS_CODE + ".sendQueryExSgSendgoods.msg", msg);
        }
        if (StringUtils.isBlank((String)((String)map.get("goodsFlag")))) {
            map.put("goodsFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("goodsProFlag")))) {
            map.put("goodsProFlag", "true");
        }
        return this.makeSuccessReturn(this.querySgSendgoodsPage(map));
    }

    private String checkQueryMap(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExSgSendgoods.map");
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)((String)map.get("tenantCode")))) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (null == map.get("startRow")) {
            msg = msg + "startRow\u4e3a\u7a7a! ";
        }
        if (null == map.get("rows")) {
            msg = msg + "rows\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkContract(OcContractDomain ocContractDomain) {
        QueryResult<OcContractReDomain> qlist;
        if (null == ocContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractDomain.getContractNbillcode())) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getContractType())) {
            msg = msg + "contractType\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isNotBlank((String)ocContractDomain.getContractNbillcode()) && null != (qlist = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode", new Object[]{ocContractDomain.getContractNbillcode(), ocContractDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            msg = msg + "contractNbillcode[" + ocContractDomain.getContractNbillcode() + "]\u91cd\u590d! ";
        }
        if (null == ocContractDomain.getGoodsNum() || ocContractDomain.getGoodsNum().compareTo(BigDecimal.ZERO) <= 0) {
            msg = msg + "goodsNum\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
        }
        if (ListUtil.isEmpty(ocContractDomain.getPackageList())) {
            msg = msg + "packageList\u4e3a\u7a7a! ";
        } else {
            int i = 0;
            for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
                ++i;
                if (ListUtil.isEmpty(ocPackageDomain.getContractGoodsList())) {
                    msg = msg + "packageList\u7b2c" + i + "\u884ccontractGoodsList\u4e3a\u7a7a! ";
                    continue;
                }
                int j = 0;
                for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
                    ++j;
                    if (StringUtils.isBlank((String)ocContractGoodsDomain.getSkuCode()) && StringUtils.isBlank((String)ocContractGoodsDomain.getSkuNo())) {
                        msg = msg + "packageList\u7b2c" + i + "\u884ccontractGoodsList\u7b2c" + j + "\u884cskuCode\u6216skuNo\u90fd\u4e3a\u7a7a! ";
                    }
                    if (null != ocContractGoodsDomain.getGoodsNum() && ocContractGoodsDomain.getGoodsNum().compareTo(BigDecimal.ZERO) > 0) continue;
                    msg = msg + "packageList\u7b2c" + i + "\u884ccontractGoodsList\u7b2c" + j + "\u884cgoodsNum\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
                }
            }
        }
        return msg;
    }

    private String checkQueryContract(String contractNbillcode, String channelCode, String tenantCode) {
        String msg = null;
        if (StringUtils.isBlank((String)contractNbillcode)) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)channelCode)) {
            msg = msg + "channelCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkQueryRefund(String refundNcode, String channelCode, String tenantCode) {
        String msg = null;
        if (StringUtils.isBlank((String)refundNcode)) {
            msg = msg + "refundNcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)channelCode)) {
            msg = msg + "channelCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkSendgoods(SgSendgoodsDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getContractNbillcode())) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkSendgoodsLog(SgSendgoodsLogDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sgSendgoodsLogDomain.getContractNbillcode())) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sgSendgoodsLogDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkRefund(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundOcode()) && StringUtils.isBlank((String)ocRefundDomain.getContractNbillcode())) {
            msg = msg + "refundOcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getMemberBcode())) {
            msg = msg + "\u4e70\u5bb6\u7f16\u7801\u4e3a\u7a7a! ";
        } else {
            UmUserinfo umUserinfo = this.queryUserinfo(ocRefundDomain.getMemberBcode());
            ocRefundDomain.setCustrelCode(ocRefundDomain.getMemberBcode());
            ocRefundDomain.setMemberBcode(umUserinfo.getUserinfoCode());
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getMemberGcode())) {
            msg = msg + "\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a! ";
        }
        if (null == ocRefundDomain.getRefundMoney() || ocRefundDomain.getRefundMoney().compareTo(BigDecimal.ZERO) <= 0) {
            msg = msg + "refundMoney\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
        }
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            msg = msg + "ocRefundGoodsDomainList\u4e3a\u7a7a! ";
        } else {
            int i = 0;
            for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
                ++i;
                if (StringUtils.isBlank((String)ocRefundGoodsDomain.getSkuNo())) {
                    msg = msg + "\u7b2c" + i + "\u884cskuNo\u4e3a\u7a7a! ";
                }
                if (StringUtils.isBlank((String)ocRefundGoodsDomain.getSkuName())) {
                    msg = msg + "\u7b2c" + i + "skuName\u4e3a\u7a7a! ";
                }
                if (null == ocRefundGoodsDomain.getGoodsOrdnum() || ocRefundGoodsDomain.getGoodsOrdnum().compareTo(BigDecimal.ZERO) <= 0) {
                    msg = msg + "\u7b2c" + i + "\u884cgoodsOrdnum\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
                }
                if (null != ocRefundGoodsDomain.getRefundGoodsAmt() && ocRefundGoodsDomain.getRefundGoodsAmt().compareTo(BigDecimal.ZERO) > 0) continue;
                msg = msg + "\u7b2c" + i + "\u884crefundGoodsAmt\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
            }
        }
        return msg;
    }

    protected UmUserinfo queryUserinfo(String userinfoEcode) {
        if (null == userinfoEcode) {
            logger.error(this.SYS_CODE + ".queryUserinfo.userinfoEcode");
            throw new ApiException("userinfoEcode\u53c2\u6570\u4e3a\u7a7a");
        }
        String apiCode = "um.user.queryUserinfoPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoOcode", userinfoEcode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String s = this.internalInvoke(apiCode, paramMap);
        if (StringUtils.isEmpty((String)s)) {
            throw new ApiException("\u67e5\u8be2\u7528\u6237\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(s, QueryResult.class);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)queryResult.getList())) {
            throw new ApiException("\u7528\u6237\u6682\u672a\u67e5\u51fa\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7528\u6237\u7f16\u7801");
        }
        List list = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), UmUserinfo.class);
        return (UmUserinfo)list.get(0);
    }

    private String makeOcRefundDomain(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            return "\u5546\u54c1\u4e3a\u7a7a";
        }
        String msg = "";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", ComConstants.tenantCode);
        paramMap.put("childFlag", "true");
        if (StringUtils.isNotBlank((String)ocRefundDomain.getContractBillcode())) {
            paramMap.put("contractBillcode", ocRefundDomain.getContractBillcode());
            QueryResult<OcContractReDomain> qlist = this.queryOrderReDomainPage(paramMap);
            if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
                logger.error(this.SYS_CODE + ".makeOcRefundDomain.qlist", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()));
                return "\u8ba2\u5355\u4e3a\u7a7a! " + paramMap.toString();
            }
            OcContractReDomain ocContractReDomain = (OcContractReDomain)qlist.getList().get(0);
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocContractReDomain);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".makeOcRefundDomain.copy", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()), (Throwable)e);
                return "\u5f02\u5e38! " + paramMap.toString();
            }
            List<OcContractGoodsDomain> goodsList = ocContractReDomain.getGoodsList();
            if (ListUtil.isEmpty(goodsList)) {
                logger.error(this.SYS_CODE + ".makeOcRefundDomain.goodsList", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()));
                return "\u8ba2\u5355\u5546\u54c1\u4e3a\u7a7a! " + paramMap.toString();
            }
            HashMap<String, OcContractGoodsDomain> contractgoodsMap = new HashMap<String, OcContractGoodsDomain>();
            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                contractgoodsMap.put(ocContractGoodsDomain.getSkuNo(), ocContractGoodsDomain);
            }
            BigDecimal reMoney = BigDecimal.ZERO;
            for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
                BigDecimal goodsOrdnum = ocRefundGoodsDomain.getGoodsOrdnum();
                BigDecimal refundGoodsAmt = ocRefundGoodsDomain.getRefundGoodsAmt();
                OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)contractgoodsMap.get(ocRefundGoodsDomain.getSkuNo());
                if (null == ocContractGoodsDomain) {
                    logger.error(this.SYS_CODE + ".makeOcRefundDomain.ocContractGoodsDomain", (Object)(ocRefundGoodsDomain.getContractGoodsGtype() + "-" + ocRefundGoodsDomain.getSkuNo()));
                    return "\u8ba2\u5355\u5546\u54c1\u5f02\u5e38! " + ocRefundGoodsDomain.getContractGoodsGtype() + "-" + ocRefundGoodsDomain.getSkuNo();
                }
                try {
                    BeanUtils.copyAllPropertys((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ocRefundGoodsDomain.setGoodsOrdnum(goodsOrdnum);
                ocRefundGoodsDomain.setRefundGoodsAmt(refundGoodsAmt);
                reMoney = reMoney.add(refundGoodsAmt);
            }
            ocRefundDomain.setRefundMoney(reMoney);
            if (null == ocRefundDomain.getRefundMoney() || ocRefundDomain.getRefundMoney().compareTo(reMoney) != 0) {
                msg = msg + "\u660e\u7ec6\u91d1\u989d\u4e0e\u6c47\u603b\u91d1\u989d";
            }
        }
        return msg;
    }

    private String makeOcContractDomain(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(ocContractDomain.getPackageList())) {
            return "\u5305\u88f9\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
            ocContractDomain.setMemberCode(this.getTeananMemberCode(ocContractDomain.getTenantCode()));
            ocContractDomain.setMemberName("\u5e73\u53f0");
        }
        List<OcPackageDomain> packageList = ocContractDomain.getPackageList();
        String msg = "";
        String goodsClass = "plat";
        QueryResult<RsSkuDomain> queryResutl = null;
        RsSkuDomain rsSkuDomain = null;
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (OcPackageDomain ocPackageDomain : packageList) {
            List<OcContractGoodsDomain> contractGoodsList = ocPackageDomain.getContractGoodsList();
            if (ListUtil.isEmpty(contractGoodsList)) {
                return "\u5305\u88f9\u91cc\u7684\u5546\u54c1\u4e3a\u7a7a";
            }
            for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
                msg = this.checkOcContractGoodsDomain(ocContractGoodsDomain);
                if (StringUtils.isNotBlank((String)msg)) {
                    return msg;
                }
                if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getSkuCode())) {
                    paramMap.put("skuCode", ocContractGoodsDomain.getSkuCode());
                    paramMap.put("tenantCode", ocContractDomain.getTenantCode());
                    queryResutl = this.queryRsSkuPage(paramMap);
                    if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                        logger.error(this.SYS_CODE + ".makeOcContractDomain.queryResutl1", (Object)(ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                        return "sku\u4e3a\u7a7a! " + paramMap.toString();
                    }
                    rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                } else if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getSkuNo())) {
                    paramMap.put("goodsClass", goodsClass);
                    paramMap.put("skuNo", ocContractGoodsDomain.getSkuNo());
                    paramMap.put("memberCode", ocContractDomain.getMemberCode());
                    paramMap.put("tenantCode", ocContractDomain.getTenantCode());
                    queryResutl = this.queryRsSkuPage(paramMap);
                    if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                        logger.error(this.SYS_CODE + ".makeOcContractDomain.queryResutl2", (Object)(ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                        return "sku\u4e3a\u7a7a! " + paramMap.toString();
                    }
                    rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                }
                rsResourceGoodsReDomain = this.getGoodsByCode(rsSkuDomain.getGoodsCode(), ocContractDomain.getTenantCode());
                if (null == rsResourceGoodsReDomain) {
                    logger.error(this.SYS_CODE + ".makeOcContractDomain.rsResourceGoodsReDomain", (Object)(ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "goods\u4e3a\u7a7a! " + paramMap.toString();
                }
                BigDecimal goodsNum = ocContractGoodsDomain.getGoodsNum();
                BigDecimal goodsWeight = ocContractGoodsDomain.getGoodsWeight();
                try {
                    BeanUtils.copyAllPropertys((Object)ocContractGoodsDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)ocContractGoodsDomain, (Object)rsSkuDomain);
                }
                catch (Exception e) {
                    logger.error(this.SYS_CODE + ".makeOcContractDomain.copysku", (Object)(rsSkuDomain.getGoodsCode() + "=" + ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "\u7cfb\u7edf\u5f02\u5e38! ";
                }
                ocContractGoodsDomain.setGoodsNum(goodsNum);
                ocContractGoodsDomain.setGoodsWeight(goodsWeight);
            }
        }
        return msg;
    }

    private String checkOcContractGoodsDomain(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getSkuNo()) && StringUtils.isBlank((String)ocContractGoodsDomain.getSkuCode())) {
            msg = msg + "skuNo\u548cskuCode\u90fd\u4e3a\u7a7a! ";
        }
        return msg;
    }

    @Override
    public String sendQueryExpress(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExpress.map");
            return null;
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExpress.msg");
            throw new ApiException(this.SYS_CODE + ".sendQueryExpress.msg", msg);
        }
        return this.makeSuccessReturn(this.queryExpressPage(map));
    }

    @Override
    public String sendSaveBusOrderToEsb(Map<String, Object> resStream, String tenantCode) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.resStream", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        String contractBillcode = (String)resStream.get("sendgoodsCode");
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.sendgoodsCode");
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.sendgoodsCode", "\u53c2\u6570\u5f02\u5e38");
        }
        OcContractReDomain orderByCode = this.getOrderByCode(contractBillcode, tenantCode);
        if (null == orderByCode) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.sendgoodsCode", "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        if (2 != orderByCode.getDataState()) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.dataState", "\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
        }
        String expressCode = (String)resStream.get("expressCode");
        if (StringUtils.isBlank((String)expressCode)) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.expressCode", "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
        }
        if (null == resStream.get("packageBillno")) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.packageBillno", "\u8fd0\u5355\u53f7\u4e3a\u7a7a");
        }
        Map<String, Object> ddMap = this.getDdMap(tenantCode, "wmsExpressCode", "wmsExpressCode");
        if (null != ddMap.get(expressCode)) {
            Map map = (Map)ddMap.get(expressCode);
            resStream.putAll(map);
        }
        String code = this.orderNext(contractBillcode, tenantCode, resStream);
        return this.makeSuccessReturn(code);
    }

    public static void main(String[] args) {
        HashMap<String, String> resStream = new HashMap<String, String>();
        resStream.put("expressCode", "12321");
        resStream.put("expressName", "12121121");
        String json = "{\"SFSY-GP\":{\"expressCode\":\"shunfeng\",\"expressName\":\"\u987a\u4e30\u5feb\u9012\"},\"GMSF\":{\"expressCode\":\"shunfeng\",\"expressName\":\"\u987a\u4e30\u5feb\u9012\"},\"3108002701_1011\":{\"expressCode\":\"zhongtongkuaiyun\",\"expressName\":\"\u4e2d\u901a\u5feb\u8fd0\"},\"ZTO\":{\"expressCode\":\"zhongtong\",\"expressName\":\"\u4e2d\u901a\u5feb\u9012\"},\"DBKD\":{\"expressCode\":\"debangkuaidi\",\"expressName\":\"\u5fb7\u90a6\u5feb\u9012\"},\"SXJD\":{\"expressCode\":\"sxjdfreight\",\"expressName\":\"\u987a\u5fc3\u5feb\u6377\"},\"YDKY\":{\"expressCode\":\"yundakuaiyun\",\"expressName\":\"\u97f5\u8fbe\u5feb\u8fd0\"},\"FENGWANG\":{\"expressCode\":\"fengwang\",\"expressName\":\"\u4e30\u7f51\u901f\u8fd0\"}}";
        String expressCode = "GMSF";
        Map jsonToMap = JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (null != jsonToMap.get(expressCode)) {
            Map map = (Map)jsonToMap.get(expressCode);
            resStream.putAll(map);
        }
        System.out.println(JsonUtil.buildNormalBinder().toJson(resStream));
    }

    @Override
    public String sendRefundStateForEsb(Map<String, Object> resStream, String tenantCode) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.resStream", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        String refundCode = (String)resStream.get("refundCode");
        String dataState = (String)resStream.get("dataState");
        if (StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.contractBillcode");
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.refundCode", "\u53c2\u6570\u5f02\u5e38");
        }
        OcRefundReDomain refundByCode = this.getRefundByCode(refundCode, tenantCode);
        if (null == refundByCode) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.refundCode", "\u9000\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        String code = null;
        code = "FULFILLED".equals(dataState) ? this.refundNext(refundCode, tenantCode, resStream) : this.refundBack(refundCode, tenantCode, resStream);
        return this.makeSuccessReturn(code);
    }

    @Override
    public String reviewLogisticsSigning(String sendGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)sendGoodsCode)) {
            throw new ApiException("\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        final HashMap<String, String> querypmap = new HashMap<String, String>();
        querypmap.put("tenantCode", ComConstants.tenantCode);
        querypmap.put("contractObillcode", sendGoodsCode);
        String sendQueryPromotion = "sg.sendgoods.querySendgoodsPage";
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)querypmap));
            }
        };
        SgSendgoods sgSendgoods = null;
        try {
            QueryResult supQueryResult = this.getQueryResutl(sendQueryPromotion, map, SgSendgoods.class);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                logger.error(this.SYS_CODE + ".reviewLogisticsSigning.querypmap", (Object)(JsonUtil.buildNormalBinder().toJson(querypmap) + ": \u67e5\u8be2\u5931\u8d25"));
                throw new ApiException(sendGoodsCode + "\u83b7\u53d6\u4e0d\u5230\u53d1\u8d27\u5355");
            }
            sgSendgoods = (SgSendgoods)supQueryResult.getList().get(0);
            HashMap<String, SgSendgoodsLogDomain> pmap = new HashMap<String, SgSendgoodsLogDomain>();
            String saveSendgoodsLog = "sg.sendgoodsLog.saveSendgoodsLog";
            SgSendgoodsLogDomain sgSendgoodsLogDomain = new SgSendgoodsLogDomain();
            sgSendgoodsLogDomain.setSendgoodsLogName("\u7269\u6d41\u7b7e\u6536");
            sgSendgoodsLogDomain.setSendgoodsLogSendmem("\u7269\u6d41\u7b7e\u6536");
            sgSendgoodsLogDomain.setSendgoodsLogMsg("\u7269\u6d41\u7b7e\u6536");
            Date date = new Date();
            sgSendgoodsLogDomain.setGmtUse(date);
            sgSendgoodsLogDomain.setTenantCode(sgSendgoods.getTenantCode());
            sgSendgoodsLogDomain.setSendgoodsCode(sgSendgoods.getSendgoodsCode());
            pmap.put("sgSendgoodsLogDomain", sgSendgoodsLogDomain);
            try {
                this.getInternalRouter().inInvoke(saveSendgoodsLog, pmap);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(sendGoodsCode + ".reviewLogisticsSigning.pmap", (Object)(JsonUtil.buildNormalBinder().toJson(querypmap) + ": \u66f4\u65b0\u6570\u636e\u5931\u8d25"));
                throw new ApiException(sendGoodsCode + "\u7269\u6d41\u7b7e\u6536\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".reviewLogisticsSigning.querypmap", (Object)(JsonUtil.buildNormalBinder().toJson(querypmap) + ": \u67e5\u8be2\u5931\u8d25"));
            throw new ApiException(sendGoodsCode + "\u7269\u6d41\u7b7e\u6536\u5f02\u5e38");
        }
        return this.makeSuccessReturn(sendGoodsCode + "\u7269\u6d41\u7b7e\u6536\u63a5\u6536\u6210\u529f");
    }

    @Override
    public String deliveryNum(SgSendgoodsDomain sgSendgoodsDomain) {
        logger.error(this.SYS_CODE + ".deliveryNum", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        if (sgSendgoodsDomain == null) {
            logger.error(this.SYS_CODE + ".deliveryNum.isnull");
            throw new ApiException("\u8bf7\u8f93\u5165\u6b63\u786e\u5165\u53c2");
        }
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getSendgoodsCode())) {
            logger.error(this.SYS_CODE + ".deliveryNum.sendgoodsCode.isnull", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
            throw new ApiException("\u8bf7\u8f93\u5165\u53d1\u8d27\u5355\u53f7");
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(sgSendgoodsDomain.getSgSendgoodsGoodsDomainList())) {
            logger.error(this.SYS_CODE + ".deliveryNum.sgSendgoodsGoodsDomainList.isnull", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
            throw new ApiException("\u8bf7\u8f93\u5165\u53d1\u8d27\u8be6\u60c5\u96c6\u5408\u4e3a\u7a7a");
        }
        final HashMap<String, Object> querypmap = new HashMap<String, Object>();
        querypmap.put("tenantCode", ComConstants.tenantCode);
        querypmap.put("sendgoodsCode", sgSendgoodsDomain.getSendgoodsCode());
        querypmap.put("goodsFlag", true);
        String sendgoods = "sg.sendgoods.querySgSendgoodsPageReDomain";
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)querypmap));
            }
        };
        try {
            QueryResult supQueryResult = this.getQueryResutl(sendgoods, map, SgSendgoodsReDomain.class);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                logger.error(this.SYS_CODE + ".deliveryNum.querypmap", (Object)(JsonUtil.buildNormalBinder().toJson(querypmap) + ": \u67e5\u8be2\u5931\u8d25"));
                throw new ApiException("\u6839\u636e" + sgSendgoodsDomain.getSendgoodsCode() + "\u83b7\u53d6\u4e0d\u5230\u53d1\u8d27\u5355");
            }
            SgSendgoodsReDomain sgSendgoodsDbReDomain = (SgSendgoodsReDomain)supQueryResult.getList().get(0);
            if (sgSendgoodsDbReDomain.getDataState() != 0) {
                logger.error(this.SYS_CODE + ".deliveryNum.supQueryResult", (Object)(JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDbReDomain) + ": \u67e5\u8be2\u5931\u8d25"));
                throw new ApiException("\u53d1\u8d27\u5355\u5df2\u7ecf\u4e0d\u662f\u5f85\u53d1\u8d27\u72b6\u6001");
            }
            Map<String, SgSendgoodsGoodsDomain> collectMap = sgSendgoodsDbReDomain.getSgSendgoodsGoodsDomainList().stream().collect(Collectors.toMap(u -> u.getSendgoodsGoodsCode(), u -> u));
            ArrayList<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomains = new ArrayList<SgSendgoodsGoodsDomain>();
            for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
                BigDecimal sendgoodsGoodsCamount;
                if (!collectMap.containsKey(sgSendgoodsGoodsDomain.getSendgoodsGoodsCode())) {
                    throw new ApiException("\u884c\u53f7" + sgSendgoodsGoodsDomain.getSendgoodsGoodsCode() + "\u5bf9\u5e94\u5355\u53f7\u4e0d\u5b58\u5728");
                }
                if (sgSendgoodsGoodsDomain.getSendgoodsGoodsCamount() == null) {
                    throw new ApiException("\u884c\u53f7" + sgSendgoodsGoodsDomain.getSendgoodsGoodsCode() + "\u5bf9\u5e94\u7684\u53d1\u8d27\u6570\u91cf\u4e3a\u7a7a");
                }
                SgSendgoodsGoodsDomain sgSendgoodsGoodsDbDomain = collectMap.get(sgSendgoodsGoodsDomain.getSendgoodsGoodsCode());
                BigDecimal bigDecimal = sendgoodsGoodsCamount = sgSendgoodsGoodsDbDomain.getSendgoodsGoodsCamount() == null ? BigDecimal.ZERO : sgSendgoodsGoodsDbDomain.getSendgoodsGoodsCamount();
                if (sendgoodsGoodsCamount.add(sgSendgoodsGoodsDomain.getSendgoodsGoodsCamount()).compareTo(sgSendgoodsGoodsDbDomain.getGoodsNum()) > 0) {
                    throw new ApiException("\u884c\u53f7" + sgSendgoodsGoodsDomain.getSendgoodsGoodsCode() + "\u53d1\u8d27\u6570\u91cf\u8d85\u8fc7\u5b9e\u9645\u6570\u91cf");
                }
                sgSendgoodsGoodsDbDomain.setSendgoodsGoodsCamount(sgSendgoodsGoodsDomain.getSendgoodsGoodsCamount());
                sgSendgoodsGoodsDbDomain.setGoodsSpec5(sgSendgoodsGoodsDomain.getGoodsSpec5());
                sgSendgoodsGoodsDomains.add(sgSendgoodsGoodsDbDomain);
            }
            sgSendgoodsDbReDomain.setContractNbillcode(sgSendgoodsDomain.getContractNbillcode());
            sgSendgoodsDbReDomain.setSgSendgoodsGoodsDomainList(sgSendgoodsGoodsDomains);
            this.deliverySgNum(sgSendgoodsDbReDomain);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".deliveryNum.querypmap", (Object)(JsonUtil.buildNormalBinder().toJson(querypmap) + ": \u67e5\u8be2\u5931\u8d25"));
            throw new ApiException(e.getMessage());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".deliveryNum.querypmap", (Object)(JsonUtil.buildNormalBinder().toJson(querypmap) + ": \u67e5\u8be2\u5931\u8d25"));
            throw new ApiException("\u53d1\u8d27\u51fa\u5e93\u56de\u4f20\u5931\u8d25");
        }
        return this.makeSuccessReturn("success");
    }
}

