/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.api.ExRsGoodsService;
import com.yqbsoft.laser.service.ext.bus.data.domain.dis.DisChannelReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.EditSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.ExCateGoryDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsBrandDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsClasstreeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsFileDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsRelDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsShopDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsWhDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsPntreeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsPropertiesValueDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecValueDomain;
import com.yqbsoft.laser.service.ext.bus.data.supbase.RsGoodsBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.GoodsParamCheckUtils;
import com.yqbsoft.laser.service.ext.bus.data.util.OkhttpsUtils;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class ExRsGoodsServiceImpl
extends RsGoodsBaseService
implements ExRsGoodsService {
    @Autowired
    OkhttpsUtils okhttpsUtils;

    private void makeUserinfo(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return;
        }
        DisChannelReDomain disChannelReDomain = this.getDisChannel(rsSkuDomain.getChannelCode(), rsSkuDomain.getTenantCode());
        if (null == disChannelReDomain) {
            this.logger.error("busdata.RsGoodsBaseService.makeUserinfo.disChannelReDomain", (Object)(rsSkuDomain.getChannelCode() + "=" + rsSkuDomain.getTenantCode()));
        }
        if (null != disChannelReDomain) {
            rsSkuDomain.setTenantCode(disChannelReDomain.getTenantCode());
            if ("1".equals(disChannelReDomain.getChannelSort()) || "2".equals(disChannelReDomain.getChannelSort())) {
                rsSkuDomain.setMemberCode(disChannelReDomain.getMemberCcode());
                rsSkuDomain.setMemberName(disChannelReDomain.getMemberCname());
                rsSkuDomain.setMemberCcode(disChannelReDomain.getMemberCcode());
                rsSkuDomain.setMemberCname(disChannelReDomain.getMemberCname());
            } else {
                rsSkuDomain.setMemberCode(disChannelReDomain.getMemberCode());
                rsSkuDomain.setMemberName(disChannelReDomain.getMemberName());
                rsSkuDomain.setMemberCcode(disChannelReDomain.getMemberCode());
                rsSkuDomain.setMemberCname(disChannelReDomain.getMemberName());
            }
            rsSkuDomain.setChannelCode(disChannelReDomain.getChannelCode());
            rsSkuDomain.setChannelName(disChannelReDomain.getChannelName());
            rsSkuDomain.setMemberMcode(disChannelReDomain.getMemberMcode());
            rsSkuDomain.setMemberMname(disChannelReDomain.getMemberMname());
            rsSkuDomain.setGoodsClass(disChannelReDomain.getGoodsClass());
        } else {
            rsSkuDomain.setChannelCode(null);
            rsSkuDomain.setChannelName(null);
            rsSkuDomain.setMemberCode(this.getTeananMemberCode(rsSkuDomain.getTenantCode()));
            rsSkuDomain.setMemberCcode(rsSkuDomain.getMemberCode());
            rsSkuDomain.setMemberName(rsSkuDomain.getMemberCode());
            rsSkuDomain.setMemberCname(rsSkuDomain.getMemberCode());
            rsSkuDomain.setMemberMcode(rsSkuDomain.getMemberCode());
            rsSkuDomain.setMemberMname(rsSkuDomain.getMemberCode());
            rsSkuDomain.setGoodsClass("plat");
        }
    }

    private void makeUserinfo(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null == rsResourceGoodsDomain) {
            return;
        }
        this.logger.info("busdata.RsGoodsBaseService.makeUserinfo.disChannelReDomain", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u7b2c\u4e09\u65b9\u63a8\u9001\u5546\u54c1\u6ca1\u6709\u5339\u914d\u5230\u6e20\u9053return"));
        DisChannelReDomain disChannelReDomain = this.getDisChannel(rsResourceGoodsDomain.getChannelCode(), rsResourceGoodsDomain.getTenantCode());
        this.logger.info("busdata.RsGoodsBaseService.makeUserinfo.disChannelReDomain.res", (Object)("\u5546\u54c1:" + JsonUtil.buildNormalBinder().toJson((Object)disChannelReDomain)));
        if (null == disChannelReDomain) {
            this.logger.error("busdata.RsGoodsBaseService.makeUserinfo.disChannelReDomain", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u7b2c\u4e09\u65b9\u63a8\u9001\u5546\u54c1\u6ca1\u6709\u5339\u914d\u5230\u6e20\u9053return"));
        }
        if (null != disChannelReDomain) {
            rsResourceGoodsDomain.setTenantCode(disChannelReDomain.getTenantCode());
            if ("1".equals(disChannelReDomain.getChannelSort()) || "2".equals(disChannelReDomain.getChannelSort())) {
                rsResourceGoodsDomain.setMemberCode(disChannelReDomain.getMemberCcode());
                rsResourceGoodsDomain.setMemberName(disChannelReDomain.getMemberCname());
                rsResourceGoodsDomain.setMemberCcode(disChannelReDomain.getMemberCcode());
                rsResourceGoodsDomain.setMemberCname(disChannelReDomain.getMemberCname());
            } else {
                rsResourceGoodsDomain.setMemberCode(disChannelReDomain.getMemberCode());
                rsResourceGoodsDomain.setMemberName(disChannelReDomain.getMemberName());
                rsResourceGoodsDomain.setMemberCcode(disChannelReDomain.getMemberCode());
                rsResourceGoodsDomain.setMemberCname(disChannelReDomain.getMemberName());
            }
            rsResourceGoodsDomain.setChannelCode(disChannelReDomain.getChannelCode());
            rsResourceGoodsDomain.setChannelName(disChannelReDomain.getChannelName());
            rsResourceGoodsDomain.setMemberMcode(disChannelReDomain.getMemberMcode());
            rsResourceGoodsDomain.setMemberMname(disChannelReDomain.getMemberMname());
            rsResourceGoodsDomain.setGoodsClass(disChannelReDomain.getGoodsClass());
        } else {
            rsResourceGoodsDomain.setChannelCode(null);
            rsResourceGoodsDomain.setChannelName(null);
            rsResourceGoodsDomain.setMemberCode(this.getTeananMemberCode(rsResourceGoodsDomain.getTenantCode()));
            rsResourceGoodsDomain.setMemberCcode(rsResourceGoodsDomain.getMemberCode());
            rsResourceGoodsDomain.setMemberName(rsResourceGoodsDomain.getMemberCode());
            rsResourceGoodsDomain.setMemberCname(rsResourceGoodsDomain.getMemberCode());
            rsResourceGoodsDomain.setMemberMcode(rsResourceGoodsDomain.getMemberCode());
            rsResourceGoodsDomain.setMemberMname(rsResourceGoodsDomain.getMemberCode());
            rsResourceGoodsDomain.setGoodsClass("plat");
        }
    }

    private void setProNull(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null == rsResourceGoodsDomain) {
            return;
        }
        rsResourceGoodsDomain.setGoodsId(null);
        rsResourceGoodsDomain.setGoodsCode(null);
        rsResourceGoodsDomain.setGoodsOldcode(null);
        rsResourceGoodsDomain.setGoodsCodeOld(null);
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSkuDomainList())) {
            for (RsSkuDomain rsSkuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                rsSkuDomain.setSkuId(null);
                rsSkuDomain.setSkuCode(null);
                rsSkuDomain.setSkuCodeOld(null);
                rsSkuDomain.setSkuOldcode(null);
            }
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsGoodsFileDomainList())) {
            for (RsGoodsFileDomain rsGoodsFileDomain : rsResourceGoodsDomain.getRsGoodsFileDomainList()) {
                rsGoodsFileDomain.setGoodsFileId(null);
                rsGoodsFileDomain.setGoodsFileCode(null);
            }
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsGoodsRelDomainList())) {
            for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsDomain.getRsGoodsRelDomainList()) {
                rsGoodsRelDomain.setGoodsRelId(null);
                rsGoodsRelDomain.setGoodsRelCode(null);
            }
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsGoodsShopDomainList())) {
            for (RsGoodsShopDomain rsGoodsShopDomain : rsResourceGoodsDomain.getRsGoodsShopDomainList()) {
                rsGoodsShopDomain.setGoodsShopId(null);
                rsGoodsShopDomain.setGoodsShopCode(null);
            }
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsGoodsWhDomainList())) {
            for (RsGoodsWhDomain rsGoodsWhDomain : rsResourceGoodsDomain.getRsGoodsWhDomainList()) {
                rsGoodsWhDomain.setGoodsWhId(null);
                rsGoodsWhDomain.setGoodsWhCode(null);
            }
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsPropertiesValueDomainList())) {
            for (RsPropertiesValueDomain rsPropertiesValueDomain : rsResourceGoodsDomain.getRsPropertiesValueDomainList()) {
                rsPropertiesValueDomain.setPropertiesValueId(null);
                rsPropertiesValueDomain.setPropertiesValueCode(null);
            }
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSpecValueDomainList())) {
            for (RsSpecValueDomain rsSpecValueDomain : rsResourceGoodsDomain.getRsSpecValueDomainList()) {
                rsSpecValueDomain.setSpecValueId(null);
                rsSpecValueDomain.setSpecValueCode(null);
            }
        }
    }

    @Override
    public String sendUpdateExGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (rsResourceGoodsDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.sendUpdateExGoods.rsResourceGoodsDomain");
            throw new ApiException("busdata.RsGoodsBaseService.sendSaveExGoods.null", "null");
        }
        String msg = GoodsParamCheckUtils.checkGoodsParam(rsResourceGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendUpdateExGoods.msg", (Object)msg);
            throw new ApiException("busdata.RsGoodsBaseService.sendSaveExGoods.msg", msg);
        }
        this.makeUserinfo(rsResourceGoodsDomain);
        this.setProNull(rsResourceGoodsDomain);
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeName())) {
            msg = this.checkPntree(rsResourceGoodsDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                this.logger.error("busdata.RsGoodsBaseService.sendUpdateExGoods.checkPntree.msg");
                throw new ApiException("busdata.RsGoodsBaseService.sendUpdateExGoods.checkPntree.msg", msg);
            }
            this.makeGoodsSpec(rsResourceGoodsDomain);
        }
        if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandName())) && StringUtils.isNotBlank((String)(msg = this.checkBrand(rsResourceGoodsDomain)))) {
            throw new ApiException("busdata.RsGoodsBaseService.sendUpdateExGoods.checkBrand.msg", msg);
        }
        if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeName())) && StringUtils.isNotBlank((String)(msg = this.checkClassTree(rsResourceGoodsDomain)))) {
            throw new ApiException("busdata.RsGoodsBaseService.sendUpdateExGoods.checkClassTree.msg", msg);
        }
        RsResourceGoodsReDomain goodsDomain = this.checkResourceGoods(rsResourceGoodsDomain);
        if (goodsDomain == null) {
            if (rsResourceGoodsDomain.getGoodsNum() == null) {
                rsResourceGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            if (rsResourceGoodsDomain.getPricesetNprice() == null) {
                rsResourceGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            rsResourceGoodsDomain.setGoodsId(null);
            rsResourceGoodsDomain.setGoodsCode(null);
            rsResourceGoodsDomain.setGoodsOldcode(null);
            rsResourceGoodsDomain.setGoodsCodeOld(null);
            rsResourceGoodsDomain.getRsSkuDomainList().stream().forEach(sku -> {
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)sku, (Object)rsResourceGoodsDomain);
                    sku.setSkuId(null);
                    sku.setSkuCode(null);
                    sku.setSkuCodeOld(null);
                    sku.setSkuOldcode(null);
                }
                catch (Exception e) {
                    this.logger.debug("busdata.RsGoodsBaseService.sendUpdateExGoods", (Throwable)e);
                }
            });
            String goodsCode = this.saveEsResourceGoodsDomain(rsResourceGoodsDomain);
            return this.makeSuccessReturn(goodsCode);
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)goodsDomain, (Object)rsResourceGoodsDomain);
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendUpdateExGoods", (Throwable)e);
        }
        goodsDomain.setIsDel(true);
        this.updateEsResourceGoodsDomain(goodsDomain);
        return this.makeSuccessReturn("success");
    }

    @Override
    public String sendSaveExGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (rsResourceGoodsDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.rsResourceGoodsDomain", (Object)"\u63a8\u9001\u5546\u54c1\u6570\u636e\u4e3a\u7a7areturn");
            throw new ApiException("busdata.RsGoodsBaseService.sendSaveExGoods.null", "null");
        }
        this.logger.info("busdata.RsGoodsBaseService.sendSaveExGoods.rsResourceGoodsDomain", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u63a5\u6536\u5230\u7b2c\u4e09\u65b9\u5546\u54c1\u63a8\u9001,\u5f00\u59cb,\u5546\u54c1\u6570\u636e:" + JSONObject.toJSONString((Object)rsResourceGoodsDomain)));
        String msg = GoodsParamCheckUtils.checkGoodsParam(rsResourceGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.msg", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u6570\u636e\u8fc7\u6ee4\u5931\u8d25,msg:" + msg));
            throw new ApiException("busdata.RsGoodsBaseService.sendSaveExGoods.msg", msg);
        }
        this.logger.info("busdata.RsGoodsBaseService.sendSaveExGoods.rsResourceGoodsDomain", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u6570\u636e\u8fc7\u6ee4\u6210\u529f"));
        this.makeUserinfo(rsResourceGoodsDomain);
        this.setProNull(rsResourceGoodsDomain);
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeName())) {
            msg = this.checkPntree(rsResourceGoodsDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.checkPntree", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u68c0\u67e5\u5546\u54c1\u54c1\u7c7b\u5931\u8d25msg:" + msg));
                throw new ApiException("busdata.RsGoodsBaseService.sendSaveExGoods.checkPntree.msg", msg);
            }
            this.makeGoodsSpec(rsResourceGoodsDomain);
        }
        this.logger.info("busdata.RsGoodsBaseService.sendSaveExGoods.rsResourceGoodsDomain", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u68c0\u67e5\u5546\u54c1\u54c1\u7c7b\u6210\u529f"));
        if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandName())) && StringUtils.isNotBlank((String)(msg = this.checkBrand(rsResourceGoodsDomain)))) {
            throw new ApiException("busdata.RsGoodsBaseService.sendSaveExGoods.checkBrand.msg", "\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u68c0\u67e5\u54c1\u724c\u5931\u8d25msg:" + msg);
        }
        this.logger.info("busdata.RsGoodsBaseService.sendSaveExGoods.rsResourceGoodsDomain", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u68c0\u67e5\u54c1\u724c\u6210\u529f"));
        if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeName())) && StringUtils.isNotBlank((String)(msg = this.checkClassTree(rsResourceGoodsDomain)))) {
            throw new ApiException("busdata.RsGoodsBaseService.sendSaveExGoods.checkClassTree.msg", "\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u68c0\u67e5\u540e\u53f0\u5206\u7c7b\u5931\u8d25msg:" + msg);
        }
        this.logger.info("busdata.RsGoodsBaseService.sendSaveExGoods.rsResourceGoodsDomain", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u68c0\u67e5\u540e\u53f0\u5206\u7c7b\u6210\u529f"));
        RsResourceGoodsReDomain goodsDomain = this.checkResourceGoods(rsResourceGoodsDomain);
        if (goodsDomain == null) {
            this.logger.info("busdata.RsGoodsBaseService.sendDelExGoods", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u5546\u54c1\u4e0d\u5b58\u5728\u5f00\u59cb\u65b0\u589e"));
            if (rsResourceGoodsDomain.getGoodsNum() == null) {
                rsResourceGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            if (rsResourceGoodsDomain.getPricesetNprice() == null) {
                rsResourceGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            rsResourceGoodsDomain.setDataState(0);
            rsResourceGoodsDomain.setDataOpbillstate(0);
            rsResourceGoodsDomain.setGoodsId(null);
            rsResourceGoodsDomain.setGoodsCode(null);
            rsResourceGoodsDomain.setGoodsOldcode(null);
            rsResourceGoodsDomain.setGoodsCodeOld(null);
            rsResourceGoodsDomain.getRsSkuDomainList().stream().forEach(sku -> {
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)sku, (Object)rsResourceGoodsDomain);
                    sku.setSkuId(null);
                    sku.setSkuCode(null);
                    sku.setSkuCodeOld(null);
                    sku.setSkuOldcode(null);
                }
                catch (Exception e) {
                    this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",sku\u6570\u636e\u5904\u7406\u5f02\u5e38,sku" + JSONObject.toJSONString((Object)sku) + ",rsResourceGoodsDomain:" + JSONObject.toJSONString((Object)rsResourceGoodsDomain)), (Throwable)e);
                }
            });
            try {
                this.logger.info("busdata.RsGoodsBaseService.sendDelExGoods", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u4fdd\u5b58\u5546\u54c1\u6570\u636ersResourceGoodsDomain:" + JSONObject.toJSONString((Object)rsResourceGoodsDomain)));
                String goodsCode = this.saveEsResourceGoodsDomain(rsResourceGoodsDomain);
                this.logger.info("busdata.RsGoodsBaseService.sendDelExGoods", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u4fdd\u5b58\u5546\u54c1\u6210\u529f:" + goodsCode));
                return this.makeSuccessReturn(goodsCode);
            }
            catch (Exception e) {
                this.logger.error("busdata.RsGoodsBaseService.sendDelExGoods", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",rsResourceGoodsDomain:" + JSONObject.toJSONString((Object)rsResourceGoodsDomain) + ",\u4fdd\u5b58\u6570\u636e\u5f02\u5e38"), (Throwable)e);
                throw new ApiException("busdata.RsGoodsBaseService.sendSaveExGoods.e", "e");
            }
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)goodsDomain, (Object)rsResourceGoodsDomain);
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",goodsDomain" + JSONObject.toJSONString((Object)goodsDomain) + "->rsResourceGoodsDomain:" + JSONObject.toJSONString((Object)rsResourceGoodsDomain) + ",\u7ec4\u88c5\u4fee\u6539\u6570\u636e\u5f02\u5e38"), (Throwable)e);
        }
        goodsDomain.setIsDel(true);
        try {
            this.updateEsResourceGoodsDomain(goodsDomain);
            this.logger.error("busdata.RsGoodsBaseService.sendDelExGoods", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u6570\u636e:" + JSONObject.toJSONString((Object)goodsDomain) + ",\u4fee\u6539\u6570\u636e\u6210\u529f,\u6570\u636e:" + JSONObject.toJSONString((Object)goodsDomain)));
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendDelExGoods", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",\u6570\u636e:" + JSONObject.toJSONString((Object)goodsDomain) + ",\u4fee\u6539\u6570\u636e\u5f02\u5e38"), (Throwable)e);
            throw new ApiException("busdata.RsGoodsBaseService.sendSaveExGoods.e1", "e");
        }
        return this.makeSuccessReturn("success");
    }

    private void saveOrUpdateSkuList(RsResourceGoodsDomain rsResourceGoodsDomain, RsResourceGoodsReDomain goodsDomain, RsSkuDomain skuDomain) {
        Map<String, RsSkuReDomain> rsSkuReDomainMap = goodsDomain.getSkuList().stream().collect(Collectors.toMap(RsSkuDomain::getSkuEocode, s -> s, (k1, k2) -> k1));
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        if (skuDomain == null) {
            RsSkuDomain rsSkuDomain = new RsSkuDomain();
            rsResourceGoodsDomain.getRsSkuDomainList().stream().forEach(sku -> {
                if (rsSkuReDomainMap.containsKey(sku.getSkuEocode())) {
                    try {
                        BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, rsSkuReDomainMap.get(sku.getSkuEocode()));
                        BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, (Object)sku);
                        editSkuDomain.setSkuEdit(false);
                    }
                    catch (Exception e) {
                        this.logger.error("busdata.RsGoodsBaseService.saveOrUpdateSkuList", (Throwable)e);
                    }
                    this.updateRsSkuDomain(editSkuDomain);
                } else {
                    try {
                        BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)rsResourceGoodsDomain);
                        BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, rsSkuReDomainMap.get(sku.getSkuEocode()));
                    }
                    catch (Exception e) {
                        this.logger.error("busdata.RsGoodsBaseService.saveOrUpdateSkuList", (Throwable)e);
                    }
                    this.saveRsSkuDomain(rsSkuDomain);
                }
            });
        } else if (rsSkuReDomainMap.containsKey(skuDomain.getSkuEocode())) {
            try {
                BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, (Object)rsSkuReDomainMap.get(skuDomain.getSkuEocode()));
                BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, (Object)skuDomain);
                editSkuDomain.setSkuEdit(false);
            }
            catch (Exception e) {
                this.logger.error("busdata.RsGoodsBaseService.saveOrUpdateSkuList", (Throwable)e);
            }
            this.updateRsSkuDomain(editSkuDomain);
        } else {
            this.saveRsSkuDomain(skuDomain);
        }
    }

    private void makeGoodsSpec(RsResourceGoodsDomain rsResourceGoodsDomain) {
        String pjson = DisUtil.getMap((String)"DisChannel-pCode", (String)(rsResourceGoodsDomain.getChannelCode() + "-" + rsResourceGoodsDomain.getTenantCode()));
        if (StringUtils.isEmpty((String)pjson)) {
            this.logger.error("busdata.RsGoodsBaseService.sendUpdateExGoods.makeGoodsSpec", (Object)"\u4e0a\u7ea7\u6e20\u9053\u672a\u914d\u7f6e");
            throw new RuntimeException("\u4e0a\u7ea7\u6e20\u9053\u672a\u914d\u7f6e");
        }
        List jsonToList = JsonUtil.buildNormalBinder().getJsonToListByMap(pjson, Object.class);
        String channelCode = String.valueOf(((Map)jsonToList.get(0)).get("channelCode"));
        List<RsSpecGroupDomain> list = this.getRsSpecGroupByPntreeCode(rsResourceGoodsDomain.getPntreeCode(), rsResourceGoodsDomain.getTenantCode(), channelCode);
        if (ListUtil.isEmpty(list)) {
            String specGroupCode = this.saveRsSpecGroup("\u9ed8\u8ba4", rsResourceGoodsDomain.getPntreeCode(), rsResourceGoodsDomain.getTenantCode(), channelCode);
            rsResourceGoodsDomain.getRsSpecValueDomainList().stream().forEach(s -> {
                String specCode = this.saveRsSpec(specGroupCode, s.getSpecName(), rsResourceGoodsDomain.getTenantCode(), channelCode);
                s.setSpecCode(specCode);
                s.setSpecGroupCode(specGroupCode);
                s.setTenantCode(rsResourceGoodsDomain.getTenantCode());
                try {
                    this.saveRsSpecOption(specCode, specGroupCode, s.getSpecValueValue(), rsResourceGoodsDomain.getTenantCode(), channelCode);
                }
                catch (Exception e) {
                    this.logger.info("busdata.RsGoodsBaseService.sendSaveExGoods.rsResourceGoodsDomain.makeGoodsSpec", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + rsResourceGoodsDomain.getChannelCode() + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",group\u5b58\u5728,\u4fdd\u5b58\u89c4\u683c\u5f02\u5e38,\u53c2\u6570:" + specCode + "-" + specGroupCode + "-" + s.getSpecValueValue() + "\u5f02\u5e38\u4fe1\u606f:"), (Throwable)e);
                }
            });
        } else {
            list.stream().forEach(g -> rsResourceGoodsDomain.getRsSpecValueDomainList().stream().forEach(s -> {
                s.setSpecValueId(null);
                s.setSpecValueCode(null);
                QueryResult<RsSpecDomain> rsSpecDomainQueryResult = this.querySpecPageSpecGroupCode(g.getSpecGroupCode(), s.getSpecName(), rsResourceGoodsDomain.getTenantCode());
                if (rsSpecDomainQueryResult == null || ListUtil.isEmpty((Collection)rsSpecDomainQueryResult.getList())) {
                    String specCode = this.saveRsSpec(g.getSpecGroupCode(), s.getSpecName(), rsResourceGoodsDomain.getTenantCode(), channelCode);
                    s.setSpecCode(specCode);
                    try {
                        this.saveRsSpecOption(specCode, g.getSpecGroupCode(), s.getSpecValueValue(), rsResourceGoodsDomain.getTenantCode(), channelCode);
                    }
                    catch (Exception e) {
                        this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.rsResourceGoodsDomain.makeGoodsSpec", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + channelCode + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",group\u4e0d\u5b58\u5728\u4fdd\u5b58\u89c4\u683c\u5f02\u5e38,\u53c2\u6570:" + specCode + "-" + g.getSpecGroupCode() + "-" + s.getSpecValueValue() + "\u5f02\u5e38\u4fe1\u606f:"), (Throwable)e);
                    }
                } else {
                    s.setSpecCode(((RsSpecDomain)rsSpecDomainQueryResult.getList().get(0)).getSpecCode());
                    try {
                        this.saveRsSpecOption(((RsSpecDomain)rsSpecDomainQueryResult.getList().get(0)).getSpecCode(), g.getSpecGroupCode(), s.getSpecValueValue(), rsResourceGoodsDomain.getTenantCode(), channelCode);
                    }
                    catch (Exception e) {
                        this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.rsResourceGoodsDomain.makeGoodsSpec", (Object)("\u5546\u54c1:" + rsResourceGoodsDomain.getGoodsNo() + ",\u6e20\u9053" + channelCode + ",\u79df\u6237" + rsResourceGoodsDomain.getTenantCode() + ",group\u5b58\u5728\u4fdd\u5b58\u89c4\u683c\u5f02\u5e38,\u53c2\u6570:" + s.getSpecCode() + "-" + g.getSpecGroupCode() + "-" + s.getSpecValueValue() + "\u5f02\u5e38\u4fe1\u606f:"), (Throwable)e);
                    }
                }
                s.setSpecGroupCode(g.getSpecGroupCode());
                s.setTenantCode(rsResourceGoodsDomain.getTenantCode());
            }));
        }
    }

    private void makeSkuSpec(RsSkuDomain rsSkuDomain) {
        String pjson = DisUtil.getMap((String)"DisChannel-pCode", (String)(rsSkuDomain.getChannelCode() + "-" + rsSkuDomain.getTenantCode()));
        if (StringUtils.isEmpty((String)pjson)) {
            this.logger.error("busdata.RsGoodsBaseService.sendUpdateExGoods.makeSkuSpec", (Object)"\u4e0a\u7ea7\u6e20\u9053\u672a\u914d\u7f6e");
            throw new RuntimeException("\u4e0a\u7ea7\u6e20\u9053\u672a\u914d\u7f6e");
        }
        List jsonToList = JsonUtil.buildNormalBinder().getJsonToListByMap(pjson, Object.class);
        String channelCode = String.valueOf(((Map)jsonToList.get(0)).get("channelCode"));
        List<RsSpecGroupDomain> list = this.getRsSpecGroupByPntreeCode(rsSkuDomain.getPntreeCode(), rsSkuDomain.getTenantCode(), channelCode);
        list.stream().forEach(g -> rsSkuDomain.getSpecList().stream().forEach(s -> {
            QueryResult<RsSpecDomain> rsSpecDomainQueryResult = this.querySpecPageSpecGroupCode(g.getSpecGroupCode(), s.getSpecName(), rsSkuDomain.getTenantCode());
            if (rsSpecDomainQueryResult == null || ListUtil.isEmpty((Collection)rsSpecDomainQueryResult.getList())) {
                String specCode = this.saveRsSpec(g.getSpecGroupCode(), s.getSpecName(), rsSkuDomain.getTenantCode(), channelCode);
                s.setSpecCode(specCode);
            } else {
                s.setSpecCode(((RsSpecDomain)rsSpecDomainQueryResult.getList().get(0)).getSpecCode());
            }
            s.setSpecGroupCode(g.getSpecGroupCode());
            s.setTenantCode(rsSkuDomain.getTenantCode());
        }));
    }

    private String checkPntree(RsResourceGoodsDomain rsResourceGoodsDomain) {
        RsPntreeDomain rsPntreeDomain = this.getRsPntreeByCodeOrName(rsResourceGoodsDomain.getPntreeCode(), rsResourceGoodsDomain.getPntreeName(), rsResourceGoodsDomain.getTenantCode());
        rsResourceGoodsDomain.setPntreeName(rsResourceGoodsDomain.getPntreeName());
        if (rsPntreeDomain == null) {
            rsPntreeDomain = new RsPntreeDomain();
            rsPntreeDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
            rsPntreeDomain.setPntreeEocode(rsResourceGoodsDomain.getPntreeCode());
            rsPntreeDomain.setPntreeName(rsResourceGoodsDomain.getPntreeName());
            rsPntreeDomain.setPntreeParentcode("-1");
            rsPntreeDomain.setPntreeType("10");
            rsPntreeDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
            rsPntreeDomain.setChannelName(rsResourceGoodsDomain.getChannelName());
            rsResourceGoodsDomain.setPntreeCode(this.saveRsPntreeDomain(rsPntreeDomain));
            return "";
        }
        rsResourceGoodsDomain.setPntreeCode(rsPntreeDomain.getPntreeCode());
        return "";
    }

    private String checkBrand(RsResourceGoodsDomain rsResourceGoodsDomain) {
        rsResourceGoodsDomain.setBrandName(rsResourceGoodsDomain.getBrandName());
        RsBrandDomain rsBrandDomain = null;
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandCode())) {
            rsBrandDomain = this.getBrandByEocode(rsResourceGoodsDomain.getBrandCode(), rsResourceGoodsDomain.getTenantCode());
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandName())) {
            rsBrandDomain = this.getBrandByName(rsResourceGoodsDomain.getBrandName(), rsResourceGoodsDomain.getTenantCode());
        }
        if (rsBrandDomain != null) {
            rsResourceGoodsDomain.setBrandCode(rsBrandDomain.getBrandCode());
        } else {
            rsBrandDomain = new RsBrandDomain();
            rsBrandDomain.setBrandEocode(rsResourceGoodsDomain.getBrandCode());
            rsBrandDomain.setBrandName(rsResourceGoodsDomain.getBrandName());
            rsBrandDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
            rsBrandDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
            rsBrandDomain.setChannelName(rsResourceGoodsDomain.getChannelName());
            rsBrandDomain.setMemberCode(rsResourceGoodsDomain.getMemberCode());
            rsBrandDomain.setMemberName(rsResourceGoodsDomain.getMemberName());
            rsResourceGoodsDomain.setBrandCode(this.saveRsBrand(rsBrandDomain));
        }
        return "";
    }

    public static void main(String[] args) {
        String fullName = "asd/d";
        String[] s = fullName.split("/");
        for (int i = 0; i < s.length; ++i) {
            System.out.println(s[i]);
        }
    }

    private String checkClassTree(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null == rsResourceGoodsDomain) {
            return "";
        }
        QueryResult<RsClasstreeDomain> queryResult = this.getClasstree(rsResourceGoodsDomain.getClasstreeCode(), rsResourceGoodsDomain.getClasstreeName(), "10", rsResourceGoodsDomain.getChannelCode(), rsResourceGoodsDomain.getMemberCode(), rsResourceGoodsDomain.getTenantCode());
        String cCode = "-1";
        if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            rsResourceGoodsDomain.setClasstreeCode(((RsClasstreeDomain)queryResult.getList().get(0)).getClasstreeCode());
        } else {
            String fullName = rsResourceGoodsDomain.getClasstreeFullName();
            if (StringUtils.isNotBlank((String)fullName)) {
                String[] s = fullName.split("/");
                for (int i = 0; i < s.length - 1; ++i) {
                    queryResult = this.getClasstree(null, s[i], "10", rsResourceGoodsDomain.getChannelCode(), rsResourceGoodsDomain.getMemberCode(), rsResourceGoodsDomain.getTenantCode());
                    if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                        cCode = ((RsClasstreeDomain)queryResult.getList().get(0)).getClasstreeCode();
                        continue;
                    }
                    RsClasstreeDomain rsClasstreeDomain = new RsClasstreeDomain();
                    rsClasstreeDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
                    rsClasstreeDomain.setChannelName(rsResourceGoodsDomain.getChannelName());
                    rsClasstreeDomain.setClasstreeEocode(rsResourceGoodsDomain.getClasstreeCode());
                    rsClasstreeDomain.setClasstreeName(rsResourceGoodsDomain.getClasstreeName());
                    rsClasstreeDomain.setClasstreeParentcode(cCode);
                    rsClasstreeDomain.setClasstreeType("10");
                    rsClasstreeDomain.setMemberCode(rsResourceGoodsDomain.getMemberCode());
                    rsClasstreeDomain.setMemberName(rsResourceGoodsDomain.getMemberName());
                    rsClasstreeDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
                    rsClasstreeDomain.setPntreeCode(rsResourceGoodsDomain.getPntreeCode());
                    cCode = this.saveRsClasstree(rsClasstreeDomain);
                }
            }
            RsClasstreeDomain rsClasstreeDomain = new RsClasstreeDomain();
            rsClasstreeDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
            rsClasstreeDomain.setChannelName(rsResourceGoodsDomain.getChannelName());
            rsClasstreeDomain.setClasstreeEocode(rsResourceGoodsDomain.getClasstreeCode());
            rsClasstreeDomain.setClasstreeName(rsResourceGoodsDomain.getClasstreeName());
            rsClasstreeDomain.setClasstreeParentcode(cCode);
            rsClasstreeDomain.setClasstreeType("10");
            rsClasstreeDomain.setMemberCode(rsResourceGoodsDomain.getMemberCode());
            rsClasstreeDomain.setMemberName(rsResourceGoodsDomain.getMemberName());
            rsClasstreeDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
            rsClasstreeDomain.setPntreeCode(rsResourceGoodsDomain.getPntreeCode());
            rsResourceGoodsDomain.setClasstreeCode(this.saveRsClasstree(rsClasstreeDomain));
        }
        return "";
    }

    private QueryResult<RsClasstreeDomain> getClasstree(String classtreeCode, String classtreeName, String ClasstreeType, String channelCode, String memberCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)classtreeCode)) {
            map.put("classtreeCode", classtreeCode);
        }
        if (StringUtils.isNotBlank((String)classtreeName)) {
            map.put("classtreeName", classtreeName);
        }
        map.put("ClasstreeType", ClasstreeType);
        map.put("channelCode", channelCode);
        map.put("memberCode", memberCode);
        map.put("tenantCode", tenantCode);
        QueryResult<RsClasstreeDomain> queryResult = this.queryRsClasstreePage(map);
        return queryResult;
    }

    private String checkClassTreeShop(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode())) {
            map.put("goodsClassCode", rsResourceGoodsDomain.getClasstreeShopcode());
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode())) {
            map.put("goodsClassName", rsResourceGoodsDomain.getClasstreeShopname());
        }
        map.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        QueryResult<RsGoodsClassDomain> queryResult = this.queryRsGoodsClassPage(map);
        if (queryResult == null || !ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            this.logger.error("busdata.RsGoodsBaseService.checkClassTreeShop", (Object)("\u524d\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168==" + rsResourceGoodsDomain.getClasstreeShopcode() + "---" + rsResourceGoodsDomain.getClasstreeShopname()));
            return "\u524d\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168\uff01";
        }
        rsResourceGoodsDomain.setClasstreeShopcode(((RsGoodsClassDomain)queryResult.getList().get(0)).getGoodsClassCode());
        rsResourceGoodsDomain.setClasstreeShopname(((RsGoodsClassDomain)queryResult.getList().get(0)).getGoodsClassName());
        return "";
    }

    private RsResourceGoodsReDomain checkResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null == rsResourceGoodsDomain) {
            return null;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getGoodsEocode())) {
            paramsMap.put("goodsEocode", rsResourceGoodsDomain.getGoodsEocode());
        } else if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getGoodsNo())) {
            paramsMap.put("goodsEocode", rsResourceGoodsDomain.getGoodsNo());
        }
        paramsMap.put("memberCode", rsResourceGoodsDomain.getMemberCcode());
        paramsMap.put("memberCcode", rsResourceGoodsDomain.getMemberCcode());
        paramsMap.put("goodsClass", rsResourceGoodsDomain.getGoodsClass());
        paramsMap.put("channelCode", rsResourceGoodsDomain.getChannelCode());
        paramsMap.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        paramsMap.put("children", "true");
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsDomainQueryResult = this.queryRsResourceGoodsPage(paramsMap);
        if (rsResourceGoodsDomainQueryResult == null || ListUtil.isEmpty((Collection)rsResourceGoodsDomainQueryResult.getList())) {
            return null;
        }
        return (RsResourceGoodsReDomain)rsResourceGoodsDomainQueryResult.getList().get(0);
    }

    @Override
    public String sendSaveExSku(RsSkuDomain rsSkuDomain) {
        if (rsSkuDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExSku.rsSkuDomain");
            return "error";
        }
        String msg = GoodsParamCheckUtils.checkSkuParam(rsSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.msg");
            throw new ApiException("busdata.RsGoodsBaseService.sendSaveExGoods.msg", msg);
        }
        this.makeUserinfo(rsSkuDomain);
        RsResourceGoodsReDomain goodsDomain = this.checkResourceGoodsBySku(rsSkuDomain);
        if (goodsDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.checkResourceGoodsBySku.msg");
            throw new ApiException("busdata.RsGoodsBaseService.checkResourceGoodsBySku.msg", "\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u4e0d\u53ef\u4fdd\u5b58sku\u4fe1\u606f");
        }
        RsSkuDomain skuDomain = new RsSkuDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)skuDomain, (Object)goodsDomain);
            BeanUtils.copyAllPropertysNotNull((Object)skuDomain, (Object)rsSkuDomain);
        }
        catch (Exception e) {
            this.logger.debug("busdata.RsGoodsBaseService.receiveSaveResourceGoods", (Throwable)e);
        }
        this.makeSkuSpec(skuDomain);
        skuDomain.setGoodsNum(rsSkuDomain.getGoodsNum() == null ? BigDecimal.ZERO : rsSkuDomain.getGoodsNum());
        skuDomain.setPricesetNprice(rsSkuDomain.getPricesetNprice() == null ? BigDecimal.ZERO : rsSkuDomain.getPricesetNprice());
        this.saveOrUpdateSkuList(null, goodsDomain, skuDomain);
        return "success";
    }

    private RsResourceGoodsReDomain checkResourceGoodsBySku(RsSkuDomain rsSkuDomain) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("goodsClass", rsSkuDomain.getGoodsClass());
        paramsMap.put("goodsEocode", rsSkuDomain.getGoodsEocode());
        paramsMap.put("tenantCode", rsSkuDomain.getTenantCode());
        paramsMap.put("children", "true");
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsDomainQueryResult = this.queryRsResourceGoodsPage(paramsMap);
        if (rsResourceGoodsDomainQueryResult == null || ListUtil.isEmpty((Collection)rsResourceGoodsDomainQueryResult.getList())) {
            return null;
        }
        return (RsResourceGoodsReDomain)rsResourceGoodsDomainQueryResult.getList().get(0);
    }

    @Override
    public String sendSaveExClass(RsClasstreeDomain rsClasstreeDomain) {
        RsClasstreeDomain classtreeDomain;
        if (rsClasstreeDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExClass.rsClasstreeDomain");
            return "error";
        }
        String msg = GoodsParamCheckUtils.checkClasstreeParam(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExClass.msg");
            throw new ApiException("busdata.RsGoodsBaseService.sendSaveExClass.msg", msg);
        }
        if (!"-1".equals(rsClasstreeDomain.getClasstreeParentcode())) {
            classtreeDomain = this.getRsClasstreeByCode(rsClasstreeDomain.getClasstreeParentcode(), rsClasstreeDomain.getTenantCode());
            if (classtreeDomain == null) {
                throw new ApiException("busdata.RsGoodsBaseService.sendSaveExClass.msg", "\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
            }
            rsClasstreeDomain.setClasstreeParentcode(classtreeDomain.getClasstreeCode());
        }
        if ((classtreeDomain = this.getRsClasstreeByCode(rsClasstreeDomain.getClasstreeEocode(), rsClasstreeDomain.getTenantCode())) == null) {
            String code = this.saveRsClasstree(rsClasstreeDomain);
            return this.makeSuccessReturn(code);
        }
        return this.makeSuccessReturn(classtreeDomain.getClasstreeCode());
    }

    @Override
    public String sendSaveExGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        RsGoodsClassDomain goodsClassDomain;
        if (rsGoodsClassDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoodsClass.rsGoodsClassDomain");
            return "error";
        }
        String msg = GoodsParamCheckUtils.checkClasstreeShopParam(rsGoodsClassDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoodsClass.msg");
            throw new ApiException("busdata.RsGoodsBaseService.sendSaveExClass.msg", msg);
        }
        if (!"-1".equals(rsGoodsClassDomain.getGoodsClassParentcode())) {
            goodsClassDomain = this.getRsGoodsClassByCode(rsGoodsClassDomain.getGoodsClassParentcode(), rsGoodsClassDomain.getTenantCode());
            if (goodsClassDomain == null) {
                throw new ApiException("busdata.RsGoodsBaseService.sendSaveExClass.msg", "\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
            }
            goodsClassDomain.setGoodsClassParentcode(goodsClassDomain.getGoodsClassCode());
        }
        if ((goodsClassDomain = this.getRsGoodsClassByCode(rsGoodsClassDomain.getGoodsClassEocode(), rsGoodsClassDomain.getTenantCode())) == null) {
            String code = this.saveRsGoodsClass(rsGoodsClassDomain);
            return this.makeSuccessReturn(code);
        }
        return this.makeSuccessReturn(goodsClassDomain.getGoodsClassCode());
    }

    @Override
    public RsClasstreeDomain queryExClass(String classtreeEocode, String tenantCode) throws ApiException {
        return this.getRsClasstreeByCode(classtreeEocode, tenantCode);
    }

    @Override
    public RsBrandDomain queryExBrand(String brandEocode, String tenantCode) throws ApiException {
        return this.getBrandByEocode(brandEocode, tenantCode);
    }

    @Override
    public RsGoodsClassDomain queryExGoodsClass(String goodsClassEocode, String tenantCode) throws ApiException {
        return this.getRsGoodsClassByCode(goodsClassEocode, tenantCode);
    }

    @Override
    public RsResourceGoodsReDomain queryResourceGoods(String goodsNo, String goodsClass, String tenantCode) throws ApiException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (null == goodsNo || null == goodsClass || null == tenantCode) {
            return null;
        }
        paramsMap.put("goodsClass", goodsClass);
        paramsMap.put("goodsEocode", goodsNo);
        paramsMap.put("tenantCode", tenantCode);
        paramsMap.put("children", "true");
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsDomainQueryResult = this.queryRsResourceGoodsPage(paramsMap);
        if (rsResourceGoodsDomainQueryResult == null || ListUtil.isEmpty((Collection)rsResourceGoodsDomainQueryResult.getList())) {
            return null;
        }
        return (RsResourceGoodsReDomain)rsResourceGoodsDomainQueryResult.getList().get(0);
    }

    @Override
    public String sendSaveExBrand(RsBrandDomain rsBrandDomain) {
        if (rsBrandDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.rsBrandDomain");
            return "error";
        }
        String msg = GoodsParamCheckUtils.checkBrandParam(rsBrandDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.msg");
            throw new ApiException("busdata.RsGoodsBaseService.sendSaveExClass.msg", msg);
        }
        RsBrandDomain brandDomain = this.getBrandByEocode(rsBrandDomain.getBrandEocode(), rsBrandDomain.getTenantCode());
        if (brandDomain == null) {
            String code = this.saveRsBrand(rsBrandDomain);
            return this.makeSuccessReturn(code);
        }
        return this.makeSuccessReturn(brandDomain.getBrandCode());
    }

    @Override
    public String sendDownExGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        this.makeUserinfo(rsResourceGoodsDomain);
        RsResourceGoodsReDomain goodsDomain = this.checkResourceGoods(rsResourceGoodsDomain);
        if (null == goodsDomain) {
            this.logger.error("busdata.RsGoodsBaseService.sendDownExGoods.goodsDomain");
            return this.makeSuccessReturn("success");
        }
        try {
            this.sendUpdateSoldOutGoods(goodsDomain.getGoodsId());
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendDownExGoods.e", (Throwable)e);
            return this.makeSuccessReturn("success");
        }
        return this.makeSuccessReturn("success");
    }

    @Override
    public String sendDownExSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendDelExGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        this.makeUserinfo(rsResourceGoodsDomain);
        RsResourceGoodsReDomain goodsDomain = this.checkResourceGoods(rsResourceGoodsDomain);
        if (null == goodsDomain) {
            this.logger.error("busdata.RsGoodsBaseService.sendDelExGoods.goodsDomain");
            return this.makeSuccessReturn("success");
        }
        try {
            this.sendDeleteResourceGoodsList(goodsDomain.getGoodsId());
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendDelExGoods.e", (Throwable)e);
            return this.makeSuccessReturn("success");
        }
        return this.makeSuccessReturn("success");
    }

    @Override
    public String sendDelExSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendUpExGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        this.makeUserinfo(rsResourceGoodsDomain);
        RsResourceGoodsReDomain goodsDomain = this.checkResourceGoods(rsResourceGoodsDomain);
        if (null == goodsDomain) {
            this.logger.error("busdata.RsGoodsBaseService.sendUpExGoods.goodsDomain");
            return this.makeSuccessReturn("success");
        }
        try {
            this.sendUpdateShelveGoods(goodsDomain.getGoodsId());
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendUpExGoods.e", (Throwable)e);
            return this.makeSuccessReturn("success");
        }
        return this.makeSuccessReturn("success");
    }

    @Override
    public String sendUpExSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String queryCategory(Map<String, String> map) {
        if (MapUtil.isEmpty(map) || StringUtils.isBlank((String)map.get("tenantCode"))) {
            this.logger.error("busdata.RsGoodsBaseService.queryCategory", (Object)"map is null");
            return null;
        }
        String info = ExRsGoodsServiceImpl.getDdFlag(map.get("tenantCode"), "category", "category");
        if (StringUtils.isBlank((String)info)) {
            this.logger.error("busdata.RsGoodsBaseService.queryCategory", (Object)"info is null");
            return null;
        }
        Map configMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(info, String.class, String.class);
        if (MapUtil.isEmpty((Map)configMap)) {
            this.logger.error("busdata.RsGoodsBaseService.queryCategory", (Object)"configMap is null");
            return null;
        }
        String url = (String)configMap.get("url");
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("haccid", (String)configMap.get("haccid"));
        header.put("hacckey", (String)configMap.get("hacckey"));
        String data = this.okhttpsUtils.doPost(url, "", header, "busdata.exRsGoods.queryCategory");
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("busdata.RsGoodsBaseService.queryCategory", (Object)"data is null");
            return null;
        }
        Map dataMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (EmptyUtil.isEmpty(dataMap.get("code"))) {
            this.logger.error("busdata.RsGoodsBaseService.queryCategory.dataMap", (Object)dataMap);
            return null;
        }
        if (!StringUtils.equals((CharSequence)dataMap.get("code").toString(), (CharSequence)"200")) {
            this.logger.error("busdata.RsGoodsBaseService.queryCategory.dataMap.code", (Object)dataMap);
            return null;
        }
        if (EmptyUtil.isEmpty(dataMap.get("rows"))) {
            this.logger.error("busdata.RsGoodsBaseService.queryCategory.dataMap.rows", (Object)dataMap);
            return null;
        }
        List exCateGoryDomains = JsonUtil.buildNonDefaultBinder().getJsonToList(JsonUtil.getNotDefJsonUtil().toJson(dataMap.get("rows")), ExCateGoryDomain.class);
        if (ListUtil.isEmpty((Collection)exCateGoryDomains)) {
            this.logger.error("busdata.RsGoodsBaseService.queryCategory.dataMap.exCateGoryDomains", (Object)dataMap);
            return null;
        }
        List filteredDomains = exCateGoryDomains.stream().filter(cate -> !"1".equals(cate.getDelFlag())).collect(Collectors.toList());
        Map<String, List<ExCateGoryDomain>> groupedByParentId = filteredDomains.stream().filter(cate -> !"0".equals(cate.getParentId())).collect(Collectors.groupingBy(ExCateGoryDomain::getParentId));
        List parentCategories = filteredDomains.stream().filter(cate -> "0".equals(cate.getParentId())).peek(cate -> cate.setCateGoryDomains(groupedByParentId.getOrDefault(cate.getTypeCode(), Collections.emptyList()))).collect(Collectors.toList());
        return JsonUtil.getNotDefJsonUtil().toJson(parentCategories);
    }
}

