/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.dd.DdFalgSetting;
import com.yqbsoft.laser.service.ext.bus.data.domain.dd.DdFalgSettingDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.dis.DisDgoods;
import com.yqbsoft.laser.service.ext.bus.data.domain.dis.DisDgoodsScopelist;
import com.yqbsoft.laser.service.ext.bus.data.domain.dis.DisDgoodsScopelistDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.log.LogErrorLog;
import com.yqbsoft.laser.service.ext.bus.data.domain.log.LogErrorLogDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.EditSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsBrandDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsClasstreeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsFile;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsFileDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsPntreeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecOption;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecOptionDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecValueDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecValueReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.ResourceGoodsU9;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.rs.RsEsbGoodsRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.rs.RsEsbGoodsResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusRsGoodsService;
import com.yqbsoft.laser.service.ext.bus.data.supbase.RsGoodsBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.GoodsParamCheckUtils;
import com.yqbsoft.laser.service.ext.bus.data.util.SqlServerUtils;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class BusRsGoodsServiceImpl
extends RsGoodsBaseService
implements BusRsGoodsService {
    private String SYS_CODE = "busdata.BusRsGoodsServiceImpl";
    private static final String RESOURCEGOODS_ADD_CODE = "rs.resource.sendSavePassResourceGoodsBatch";
    private static final SupperLogUtil logger = new SupperLogUtil(BusRsGoodsServiceImpl.class);
    private static final String MING_YONG_CHANNEL_NAME = "\u7231\u5eb7\u6c11\u7528";
    private static final String GONG_CHENG_CHANNEL_NAME = "\u7231\u5eb7\u5de5\u7a0b";
    private static final String NUAN_TONAG_CHANNEL_NAME = "\u7231\u5eb7\u6696\u901a";
    private static final String MINYON_GDGOODS_CODE = "61a0e128512b43e8959f28079c34ab73";
    private static final String GONGCHENG_DGOODS_CODE = "86881c98ea8d42c0927bac1b93f201da";
    private static final String NUANTONG_DGOODS_CODE = "86881c98ea8d42c0927bac1b91f201da";
    private static final Map<String, String> channelMap = new HashMap<String, String>(){
        {
            this.put("\u6c11\u7528", BusRsGoodsServiceImpl.MING_YONG_CHANNEL_NAME);
            this.put("\u5de5\u7a0b", BusRsGoodsServiceImpl.GONG_CHENG_CHANNEL_NAME);
            this.put("\u6696\u901a", BusRsGoodsServiceImpl.NUAN_TONAG_CHANNEL_NAME);
        }
    };
    private static ThreadPoolExecutor itemThreadPoolExecutor = new ThreadPoolExecutor(16, 32, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    @Override
    public String sendSaveBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendSaveBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendSaveBusClass(RsClasstreeDomain rsClasstreeDomain) {
        return null;
    }

    @Override
    public String sendSaveBusGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        return null;
    }

    @Override
    public String sendSaveBusBrand(RsBrandDomain rsBrandDomain) {
        return null;
    }

    @Override
    public String checkSkuByESB(String sku, String tenantCode) {
        String esbKey = BusRsGoodsServiceImpl.getDdFlag(tenantCode, "EsbKey", "EsbKey");
        String esbSecret = BusRsGoodsServiceImpl.getDdFlag(tenantCode, "EsbSecret", "EsbSecret");
        String url = BusRsGoodsServiceImpl.getDdFlag(tenantCode, "EsbGoodsUrl", "EsbGoodsUrl");
        Esbfacade esbfacade = new Esbfacade(url, esbKey, esbSecret, null);
        String[] split = sku.split(",");
        RsEsbGoodsRequest rsEsbGoodsRequest = new RsEsbGoodsRequest();
        rsEsbGoodsRequest.setClientsecret(esbSecret);
        rsEsbGoodsRequest.setClientid(esbKey);
        rsEsbGoodsRequest.setHost(url);
        rsEsbGoodsRequest.setIT_MATNR(split);
        RsEsbGoodsResponse ocContractResponse = esbfacade.execute(rsEsbGoodsRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.ocContractResponse");
            return this.makeErrorReturn("-1", ocContractResponse.getDataObj());
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            return this.makeErrorReturn("-1", ocContractResponse.getDataObj());
        }
        return this.makeSuccessReturn(ocContractResponse.getDataObj());
    }

    public static void main1(String[] args) {
        String esbKey = "WYDS-TRMF98BC";
        String esbSecret = "WYDS#@YFD";
        String url = "https://ipaasqas.rifeng.com.cn:31443/298153907928989696/SAP/Z_NRS_003/1.0.0";
        String sku = "";
        Esbfacade esbfacade = new Esbfacade(url, esbKey, esbSecret, null);
        String[] split = sku.split(",");
        RsEsbGoodsRequest rsEsbGoodsRequest = new RsEsbGoodsRequest();
        rsEsbGoodsRequest.setClientsecret(esbSecret);
        rsEsbGoodsRequest.setClientid(esbKey);
        rsEsbGoodsRequest.setHost(url);
        rsEsbGoodsRequest.setIT_MATNR(split);
        RsEsbGoodsResponse ocContractResponse = esbfacade.execute(rsEsbGoodsRequest);
        if (null == ocContractResponse) {
            // empty if block
        }
        System.out.println(ocContractResponse.getDataObj());
    }

    @Override
    public String sendUpBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendUpBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendDownBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendDownBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendSaveExcelBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        block29: {
            String msg;
            logger.info(this.SYS_CODE + ".sendSaveExcelBusGoods.map", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain));
            if (rsResourceGoodsDomain == null) {
                logger.error(this.SYS_CODE + ".sendSaveExcelBusGoods.rsResourceGoodsDomain");
                throw new RuntimeException("\u6570\u636e\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)rsResourceGoodsDomain.getPntreeName())) {
                rsResourceGoodsDomain.setPntreeName(rsResourceGoodsDomain.getPntreeCode());
            }
            rsResourceGoodsDomain.setChannelCode("728296217517314110");
            rsResourceGoodsDomain.setMemberCode("20000210463648");
            rsResourceGoodsDomain.setMemberCcode("20000210463648");
            rsResourceGoodsDomain.setGoodsClass("plat");
            rsResourceGoodsDomain.setGoodsOrigin("0");
            if (StringUtils.isBlank((String)rsResourceGoodsDomain.getGoodsPro())) {
                rsResourceGoodsDomain.setGoodsPro("0");
            }
            rsResourceGoodsDomain.setGoodsType("00");
            if (null == rsResourceGoodsDomain.getDataOpbillstate()) {
                rsResourceGoodsDomain.setDataOpbillstate(0);
            }
            if (StringUtils.isNotBlank((String)(msg = this.checkGoodsParam(rsResourceGoodsDomain)))) {
                logger.error(this.SYS_CODE + ".sendSaveExcelBusGoods.msg" + msg);
                throw new RuntimeException(rsResourceGoodsDomain.getSkuNo() + "\u53c2\u6570\u5f02\u5e38" + msg);
            }
            try {
                Object classTreeMap;
                if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeName())) {
                    msg = this.checkPntree(rsResourceGoodsDomain, rsResourceGoodsDomain.getRsSkuDomainList());
                    if (msg.contains("\u65b0\u589e\u7c7b\u578b\u5931\u8d25")) {
                        logger.error(this.SYS_CODE + ".sendSaveExcelBusGoods.checkPntree.msg" + msg);
                        throw new RuntimeException(rsResourceGoodsDomain.getSkuNo() + "\u65b0\u589e\u7c7b\u578b\u5931\u8d25");
                    }
                    try {
                        this.makeSpec(rsResourceGoodsDomain);
                    }
                    catch (Exception e) {
                        logger.error(this.SYS_CODE + ".sendSaveExcelBusGoods.makeSpec.Exception", (Throwable)e);
                        throw new RuntimeException(rsResourceGoodsDomain.getSkuNo() + "\u6570\u636e\u9519\u8bef");
                    }
                }
                if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandName())) && (msg = this.checkBrandU9(rsResourceGoodsDomain, rsResourceGoodsDomain.getRsSkuDomainList())).contains("\u54c1\u724c")) {
                    logger.error(this.SYS_CODE + ".sendSaveExcelBusGoods.checkBrandU9.Exception", (Object)msg);
                    throw new RuntimeException(rsResourceGoodsDomain.getBrandCode() + "\u54c1\u724c\u65b0\u589e\u5931\u8d25");
                }
                if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeName())) && (msg = this.checkRsClassTree(rsResourceGoodsDomain, rsResourceGoodsDomain.getRsSkuDomainList())).contains("\u5206\u7c7b\u540d\u79f0")) {
                    logger.error(this.SYS_CODE + ".checkRsClassTree.resultClassTree", (Object)("\u65b0\u589e\u540e\u53f0\u5206\u7c7b\u5931\u8d25,rsResourceGoodsDomain\uff1a " + JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain)));
                    throw new RuntimeException(rsResourceGoodsDomain.getClasstreeCode() + "\u5206\u7c7b\u65b0\u589e\u5931\u8d25");
                }
                if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeName())) && (msg = this.checkGoodsClass(rsResourceGoodsDomain, (Map<String, Object>)(classTreeMap = JsonUtil.buildNormalBinder().getJsonToMap(msg, String.class, Object.class)), rsResourceGoodsDomain.getRsSkuDomainList())).contains("\u5206\u7c7b\u540d\u79f0")) {
                    logger.error(this.SYS_CODE + ".checkGoodsClass.msg", (Object)("\u65b0\u589e\u524d\u53f0\u5206\u7c7b\u5931\u8d25,rsResourceGoodsDomain\uff1a " + JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain)));
                    throw new RuntimeException(msg);
                }
                msg = this.checkPriceCategory(rsResourceGoodsDomain);
                if (msg.contains("\u5206\u7c7b")) {
                    logger.error(this.SYS_CODE + ".checkGoodsClass.msg", (Object)("\u65b0\u589e\u4ef7\u683c\u5206\u7c7b\u5931\u8d25,rsResourceGoodsDomain\uff1a " + JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain)));
                    throw new RuntimeException(msg);
                }
                for (RsSkuDomain rsSkuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                    rsSkuDomain.setMemberCcode("20000210463648");
                    if (!StringUtils.isBlank((String)rsSkuDomain.getSkuRemark()) && !StringUtils.isBlank((String)rsSkuDomain.getGoodsWeightstr())) continue;
                }
                RsResourceGoodsReDomain goodsDomain = this.checkResourceGoods(rsResourceGoodsDomain);
                if (goodsDomain == null) {
                    if (rsResourceGoodsDomain.getGoodsNum() == null) {
                        rsResourceGoodsDomain.setGoodsNum(new BigDecimal("999"));
                    }
                    if (rsResourceGoodsDomain.getPricesetNprice() == null) {
                        rsResourceGoodsDomain.setPricesetNprice(new BigDecimal("999"));
                    }
                    try {
                        this.saveEsResourceGoodsDomainU9(rsResourceGoodsDomain);
                        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSkuDomainList())) {
                            for (RsSkuDomain rsSkuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                                for (DisDgoodsScopelistDomain disDgoodsScopelistDomain : rsSkuDomain.getDisDgoodsScopelistDomains()) {
                                    this.saveDgoodsScopelistBatch(disDgoodsScopelistDomain);
                                }
                            }
                        }
                        break block29;
                    }
                    catch (Exception exception) {
                        logger.error(this.SYS_CODE + ".sendSaveExGoodsSpu.rsResourceGoodsDomain.Exception1", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain), (Throwable)exception);
                        throw new RuntimeException(rsResourceGoodsDomain.getSkuNo() + "\u6570\u636e" + rsResourceGoodsDomain.getSkuNo() + "\u6dfb\u52a0\u5f02\u5e38");
                    }
                }
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)goodsDomain, (Object)rsResourceGoodsDomain);
                }
                catch (Exception exception) {
                    logger.error(this.SYS_CODE + ".sendSaveExGoods", (Throwable)exception);
                    throw new RuntimeException("\u590d\u5236\u5546\u54c1\u5bf9\u8c61\u5f02\u5e38");
                }
                List<RsSkuDomain> list = rsResourceGoodsDomain.getRsSkuDomainList();
                for (RsSkuDomain rsSkuDomain : list) {
                    this.saveOrUpdateSkuList(rsResourceGoodsDomain, goodsDomain, rsSkuDomain);
                    for (DisDgoodsScopelistDomain disDgoodsScopelistDomain : rsSkuDomain.getDisDgoodsScopelistDomains()) {
                        this.saveDgoodsScopelistBatch(disDgoodsScopelistDomain);
                    }
                }
            }
            catch (ApiException e) {
                logger.error(this.SYS_CODE + ".sendSaveExGoods.e", (Throwable)e);
                throw new RuntimeException(rsResourceGoodsDomain.getSkuNo() + e.getErrMsg());
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".sendSaveExGoods.e1", (Throwable)e);
                throw new RuntimeException(rsResourceGoodsDomain.getSkuNo() + e.getMessage());
            }
        }
        return this.makeSuccessReturn(rsResourceGoodsDomain.getSkuNo());
    }

    private void addPriceCategory(RsResourceGoodsReDomain goodsDomain, RsSkuDomain rsSkuDomain) throws Exception {
        if (StringUtils.isBlank((String)rsSkuDomain.getSkuRemark()) || StringUtils.isBlank((String)rsSkuDomain.getGoodsWeightstr())) {
            return;
        }
        String msg = this.checkPriceCategory(goodsDomain);
        if ("\u5206\u7c7b".equals(msg)) {
            logger.error(this.SYS_CODE + ".checkGoodsClass.msg", (Object)("\u65b0\u589e\u4ef7\u683c\u5206\u7c7b\u5931\u8d25,rsResourceGoodsDomain\uff1a " + JsonUtil.buildNormalBinder().toJson((Object)goodsDomain)));
            throw new RuntimeException(msg);
        }
    }

    private String checkPriceCategory(RsResourceGoodsDomain rsResourceGoodsDomain) {
        RsClasstreeDomain rsClasstreeDomain = this.buildClassTreeeForPriceCategory(rsResourceGoodsDomain, "-1", "1", "9");
        String msg = GoodsParamCheckUtils.checkClasstreeParam(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExClass.msg");
            return "\u4ef7\u683c\u540e\u53f0\u5206\u7c7b\u6821\u9a8c\u51fa\u9519";
        }
        String code = "";
        RsClasstreeDomain classtreeDomain = this.getRsClasstreeByCode(rsClasstreeDomain.getClasstreeCode(), rsClasstreeDomain.getTenantCode(), rsResourceGoodsDomain.getChannelCode(), "9");
        code = classtreeDomain == null ? this.saveRsClasstree(rsClasstreeDomain) : classtreeDomain.getClasstreeCode();
        return code;
    }

    private void buildSpecValueListForSkuModify(RsResourceGoodsDomain oldRsResourceGoodsReDomain) throws Exception {
        HashMap<String, Object> specParamsMap = new HashMap<String, Object>();
        specParamsMap.put("specValueBillno", oldRsResourceGoodsReDomain.getGoodsCode());
        specParamsMap.put("tenantCode", oldRsResourceGoodsReDomain.getTenantCode());
        specParamsMap.put("startRow", 0);
        specParamsMap.put("rows", 1);
        QueryResult<RsSpecValueReDomain> rsSpecValueReDomainQueryResultOld = this.querySpecValuePage(specParamsMap);
        List<Object> allRsSpecValueDomainList = new ArrayList();
        if (null != rsSpecValueReDomainQueryResultOld && ListUtil.isNotEmpty((Collection)rsSpecValueReDomainQueryResultOld.getList())) {
            List<RsSpecValueDomain> rsSpecValueDomainList = oldRsResourceGoodsReDomain.getRsSpecValueDomainList();
            rsSpecValueDomainList.addAll(rsSpecValueReDomainQueryResultOld.getList());
            allRsSpecValueDomainList = rsSpecValueDomainList;
        }
        if (ListUtil.isNotEmpty(allRsSpecValueDomainList)) {
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("specValueBillno", oldRsResourceGoodsReDomain.getGoodsCode());
            paramsMap.put("tenantCode", oldRsResourceGoodsReDomain.getTenantCode());
            ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
            for (RsSpecValueDomain rsSpecValueDomain : allRsSpecValueDomainList) {
                paramsMap.put("specName", rsSpecValueDomain.getSpecName());
                paramsMap.put("specValueValue", rsSpecValueDomain.getSpecValueValue());
                paramsMap.put("startRow", 0);
                paramsMap.put("rows", 1);
                QueryResult<RsSpecValueReDomain> rsSpecValueReDomainQueryResult = this.checkSpecValue(paramsMap);
                if (null != rsSpecValueReDomainQueryResult && ListUtil.isNotEmpty((Collection)rsSpecValueReDomainQueryResult.getList())) continue;
                rsSpecValueDomain.setSpecValueBillno(oldRsResourceGoodsReDomain.getGoodsCode());
                rsSpecValueDomain.setTenantCode(oldRsResourceGoodsReDomain.getTenantCode());
                rsSpecValueDomain.setSpuCode(oldRsResourceGoodsReDomain.getSpuCode());
                rsSpecValueDomainList.add(rsSpecValueDomain);
            }
            oldRsResourceGoodsReDomain.setRsSpecValueDomainList(rsSpecValueDomainList);
        }
    }

    private void saveSpecValueListForSkuAdd(RsResourceGoodsReDomain goodsDomain, List<RsSpecValueDomain> rsSpecValueDomainList) throws Exception {
        if (ListUtil.isNotEmpty(rsSpecValueDomainList)) {
            ArrayList<RsSpecValueDomain> rsSpecValueDomainListForSkuAdd = new ArrayList<RsSpecValueDomain>();
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("specValueBillno", goodsDomain.getGoodsCode());
            paramsMap.put("tenantCode", goodsDomain.getTenantCode());
            for (RsSpecValueDomain rsSpecValueDomain : rsSpecValueDomainList) {
                paramsMap.put("specCode", rsSpecValueDomain.getSpecCode());
                paramsMap.put("specValueValue", rsSpecValueDomain.getSpecValueValue());
                paramsMap.put("startRow", 0);
                paramsMap.put("rows", 1);
                QueryResult<RsSpecValueReDomain> rsSpecValueReDomainQueryResult = this.checkSpecValue(paramsMap);
                if (null != rsSpecValueReDomainQueryResult && ListUtil.isNotEmpty((Collection)rsSpecValueReDomainQueryResult.getList())) continue;
                rsSpecValueDomain.setSpecValueBillno(goodsDomain.getGoodsCode());
                rsSpecValueDomain.setTenantCode(goodsDomain.getTenantCode());
                rsSpecValueDomain.setSpuCode(goodsDomain.getSpuCode());
                rsSpecValueDomainListForSkuAdd.add(rsSpecValueDomain);
            }
            if (ListUtil.isNotEmpty(rsSpecValueDomainListForSkuAdd)) {
                this.saveSpecValueList(rsSpecValueDomainListForSkuAdd);
            }
        }
    }

    private void saveDgoodsScopelistBatch(final DisDgoodsScopelistDomain disDgoodsScopelistDomain) {
        HashMap<String, Object> batchSaveUpMap = new HashMap<String, Object>(){
            {
                this.put("dgoodsScopelistValue", disDgoodsScopelistDomain.getDgoodsScopelistValue());
                this.put("channelCode", disDgoodsScopelistDomain.getChannelCode());
            }
        };
        HashMap<String, String> batchSaveUpMap1 = new HashMap<String, String>();
        batchSaveUpMap1.put("map", JsonUtil.buildNormalBinder().toJson((Object)batchSaveUpMap));
        QueryResult supQueryResult = this.sendReSupObject("dis.dgoods.queryDgoodsScopelistPage", batchSaveUpMap1, DisDgoodsScopelistDomain.class);
        if (supQueryResult != null && !CollectionUtils.isEmpty((Collection)supQueryResult.getList())) {
            return;
        }
        final ArrayList<DisDgoodsScopelistDomain> list = new ArrayList<DisDgoodsScopelistDomain>();
        list.add(disDgoodsScopelistDomain);
        batchSaveUpMap = new HashMap<String, Object>(){
            {
                this.put("disDgoodsScopelistDomainList", JsonUtil.buildNormalBinder().toJson((Object)list));
            }
        };
        this.internalInvoke("dis.dgoods.saveDgoodsScopelistBatch", batchSaveUpMap);
    }

    private void saveLogError(InternalRouter internalRouter, ResourceGoodsU9 goodsU9, String clientType, String tenantCode, String clientExecuteMethod, String memo) {
        final LogErrorLogDomain logErrorLogDomain = new LogErrorLogDomain();
        logErrorLogDomain.setTenantCode(tenantCode);
        logErrorLogDomain.setUserCode(goodsU9.getItemCode());
        logErrorLogDomain.setClientType(clientType);
        logErrorLogDomain.setClientExecuteMethod("clientExecuteMethod: " + clientExecuteMethod + "errorMsg: " + memo);
        logErrorLogDomain.setErrorLogMessage(JsonUtil.buildNonDefaultBinder().toJson((Object)goodsU9));
        HashMap<String, Object> logMap = new HashMap<String, Object>(){
            {
                this.put("logErrorLogDomain", JsonUtil.buildNormalBinder().toJson((Object)logErrorLogDomain));
            }
        };
        internalRouter.inInvoke("log.log.saveErrorLog", (Map)logMap);
    }

    private String checkGoodsClass(RsResourceGoodsDomain rsResourceGoodsDomain, Map<String, Object> classTreeMap, List<RsSkuDomain> rsSkuDomainList) {
        String oneGoodsClassCode = this.checkAndAddGoodsClass(rsResourceGoodsDomain, "-1", "1", "1", classTreeMap, null);
        if (oneGoodsClassCode.contains("\u5206\u7c7b")) {
            logger.error(this.SYS_CODE + ".checkGoodsClass.oneGoodsClassCode", (Object)("\u65b0\u589e\u4e00\u7ea7\u524d\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getOneClasstreeShopname()));
            return "\u65b0\u589e\u4e00\u7ea7\u524d\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getOneClasstreeShopname();
        }
        oneGoodsClassCode = rsResourceGoodsDomain.getClassificationCode1();
        String twoGoodsClassCode = this.checkAndAddGoodsClass(rsResourceGoodsDomain, oneGoodsClassCode, "1", "2", classTreeMap, null);
        if (twoGoodsClassCode.contains("\u5206\u7c7b")) {
            logger.error(this.SYS_CODE + ".checkGoodsClass.twoGoodsClassCode", (Object)("\u65b0\u589e\u4e8c\u7ea7\u524d\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getSecondClasstreeShopname()));
            return "\u65b0\u589e\u4e8c\u7ea7\u524d\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getSecondClasstreeShopname();
        }
        twoGoodsClassCode = rsResourceGoodsDomain.getClassificationCode2();
        String classtreeShopcode = this.checkAndAddGoodsClass(rsResourceGoodsDomain, twoGoodsClassCode, "0", "3", classTreeMap, rsSkuDomainList);
        if (classtreeShopcode.contains("\u5206\u7c7b")) {
            logger.error(this.SYS_CODE + ".checkGoodsClass.classtreeShopcode", (Object)("\u65b0\u589e\u4e09\u7ea7\u524d\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getClasstreeShopcode()));
            return "\u65b0\u589e\u4e09\u7ea7\u524d\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getClasstreeShopcode();
        }
        return "";
    }

    private String checkAndAddGoodsClass(RsResourceGoodsDomain rsResourceGoodsDomain, String goodsClassParentCode, String goodsClassLast, String level, Map<String, Object> classTreeMap, List<RsSkuDomain> rsSkuDomainList) {
        InternalRouter internalRouter = this.getInternalRouter();
        String channelNames = "\u7231\u5eb7\u6c11\u7528,\u7231\u5eb7\u5de5\u7a0b";
        List<DisDgoods> disDgoods = this.queryDisGoodsPage(rsResourceGoodsDomain.getTenantCode(), channelNames);
        if (null == disDgoods) {
            return "\u524d\u53f0\u5206\u7c7b\u6821\u9a8c\u51fa\u9519,disDgoods is null,\u8bf7\u521d\u59cb\u5316disDgoods\u4fe1\u606f";
        }
        for (DisDgoods disDgoods1 : disDgoods) {
            RsGoodsClassDomain rsGoodsClassDomainByCode;
            RsGoodsClassDomain rsGoodsClassDomain = this.buildGoodsClass(rsResourceGoodsDomain, goodsClassParentCode, goodsClassLast, "0", level, classTreeMap);
            rsGoodsClassDomain.setChannelCode(disDgoods1.getChannelCode());
            rsGoodsClassDomain.setChannelName(disDgoods1.getChannelName());
            if (rsGoodsClassDomain == null) {
                logger.error(this.SYS_CODE + ".checkAndAddGoodsClass.rsGoodsClassDomain");
                return "error";
            }
            String msg = GoodsParamCheckUtils.checkClasstreeShopParam(rsGoodsClassDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                logger.error(this.SYS_CODE + ".sendSaveExClass.msg");
                return "\u524d\u53f0\u5206\u7c7b\u6821\u9a8c\u51fa\u9519";
            }
            if (!"-1".equals(rsGoodsClassDomain.getGoodsClassParentcode()) && (rsGoodsClassDomainByCode = this.getRsGoodsClassByCodeAndChannelCode(rsGoodsClassDomain.getGoodsClassParentcode(), rsGoodsClassDomain.getTenantCode(), rsGoodsClassDomain.getChannelCode())) == null) {
                return "\u524d\u53f0\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\uff01";
            }
            rsGoodsClassDomainByCode = this.getRsGoodsClassByCodeAndChannelCode(rsGoodsClassDomain.getGoodsClassEocode(), rsGoodsClassDomain.getTenantCode(), rsGoodsClassDomain.getChannelCode());
            if (rsGoodsClassDomainByCode != null) continue;
            this.saveRsGoodsClassU9(rsGoodsClassDomain);
        }
        return "";
    }

    private RsGoodsClassDomain buildGoodsClass(RsResourceGoodsDomain rsResourceGoodsDomain, String goodsClassParentCode, String goodsClassLast, String goodsClassType, String level, Map<String, Object> classTreeMap) {
        RsGoodsClassDomain rsGoodsClassDomain = new RsGoodsClassDomain();
        rsGoodsClassDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
        rsGoodsClassDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
        rsGoodsClassDomain.setGoodsClassParentcode(goodsClassParentCode);
        rsGoodsClassDomain.setGoodsClassLast(goodsClassLast);
        rsGoodsClassDomain.setGoodsClassType(goodsClassType);
        if ("1".equals(level)) {
            rsGoodsClassDomain.setGoodsClassName(rsResourceGoodsDomain.getClassificationName1());
            rsGoodsClassDomain.setGoodsClassEocode(rsResourceGoodsDomain.getClassificationCode1());
        } else if ("2".equals(level)) {
            rsGoodsClassDomain.setGoodsClassName(rsResourceGoodsDomain.getClassificationName2());
            rsGoodsClassDomain.setGoodsClassEocode(rsResourceGoodsDomain.getClassificationCode2());
        } else if ("3".equals(level)) {
            rsGoodsClassDomain.setGoodsClassName(rsResourceGoodsDomain.getClasstreeName());
            rsGoodsClassDomain.setGoodsClassEocode(rsResourceGoodsDomain.getClasstreeCode());
        }
        rsGoodsClassDomain.setGoodsClassCode(rsGoodsClassDomain.getGoodsClassEocode());
        rsGoodsClassDomain.setClasstreeCode(rsGoodsClassDomain.getGoodsClassCode());
        rsGoodsClassDomain.setGoodsClassHide("0");
        rsGoodsClassDomain.setGoodsClassType("0");
        return rsGoodsClassDomain;
    }

    private LocalDateTime getInstantTime(Integer instantMins) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime sevenMinutesAgo = now.minusMinutes(instantMins.intValue());
        return sevenMinutesAgo;
    }

    @Override
    public String sendInitialAndBusGoods(String tenantCode, String type, String date) {
        LocalDateTime args = null;
        String sql = null;
        List<Object> resourceGoodsU9 = new ArrayList<ResourceGoodsU9>();
        try {
            if ("init".equals(type)) {
                args = this.getLocalDateTime(date);
                sql = "SELECT\n                    *\n                        FROM\n                        CJ_V_Itemmaster \n                        WHERE\n                        OrgCode = '001' \n                        AND ( Prv18Code IS NOT NULL AND Prv18Name != '' ) \n                        AND ( Prv10Code IS NOT NULL AND Prv10Name != '' ) \n                        AND IsSalesEnable = 1\n                        AND CreatedOn > ? ";
                logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.sql", (Object)sql);
                resourceGoodsU9 = SqlServerUtils.getForU9SkuList(sql, args);
            } else {
                List<ResourceGoodsU9> list;
                sql = "SELECT\n                    *\n                        FROM\n                        CJ_V_Itemmaster \n                        WHERE\n                        OrgCode = '001' \n                        AND ( Prv18Code IS NOT NULL AND Prv18Name != '' ) \n                        AND ( Prv10Code IS NOT NULL AND Prv10Name != '' ) \n                        AND CreatedOn > ? ";
                args = StringUtils.isBlank((String)date) ? this.getInstantTime(1500) : this.getLocalDateTime(date);
                List<ResourceGoodsU9> resourceGoodsU91 = SqlServerUtils.getForU9SkuList(sql, args);
                if (!CollectionUtils.isEmpty(resourceGoodsU91)) {
                    resourceGoodsU9.addAll(resourceGoodsU91);
                }
                if (!CollectionUtils.isEmpty(list = SqlServerUtils.getForU9SkuList(sql = "SELECT\n\t*\n\t\nFROM\n\tCJ_V_Itemmaster \nWHERE\n\tOrgCode = '001' \n\tAND ( Prv18Code IS NOT NULL AND Prv18Name != '' ) \n\tAND ( Prv10Code IS NOT NULL AND Prv10Name != '' ) \n\tAND ModifiedOn > ?", args))) {
                    resourceGoodsU9.addAll(list);
                }
            }
            if (ListUtil.isEmpty(resourceGoodsU9)) {
                logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.queryU9", (Object)"\u67e5\u8be2U9\u5546\u54c1\u6570\u636e\u4e3a\u7a7a");
                return "success";
            }
            for (ResourceGoodsU9 resourceGoodsU92 : resourceGoodsU9) {
                try {
                    this.saveResourceGoods(resourceGoodsU92);
                }
                catch (Exception e) {
                    this.saveLogError(this.getInternalRouter(), resourceGoodsU92, "GOODS", ComConstants.tenantCode, "busdata.busRsGoods.sendInitialAndAddBusGoods", e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.view", (Object)("\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898" + e));
            throw new ApiException("\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
        }
        return "success";
    }

    @Override
    public String sendInitailBusGoodsCompensate(final String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerCompensate.tenantCode", (Object)"tenantCode is null");
            return "tenantCode is null";
        }
        final HashMap<String, Object> logMap = new HashMap<String, Object>(){
            {
                this.put("fuzzy", true);
                this.put("tenantCode", tenantCode);
                this.put("clientType", "GOODS");
                this.put("dataState", 0);
            }
        };
        HashMap<String, Object> logParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)logMap));
            }
        };
        logger.error(this.SYS_CODE + ".sendInitailCustomerCompensate.logParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)logParamMap));
        String logStr = this.internalInvoke("log.log.queryErrorLogPage", logParamMap);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(logStr, SupQueryResult.class);
        List logList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), LogErrorLog.class);
        logger.error(this.SYS_CODE + ".sendInitailCustomerCompensate.logList", (Object)JsonUtil.buildNormalBinder().toJson((Object)logList));
        if (ListUtil.isEmpty((Collection)logList)) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerCompensate.logList", (Object)JsonUtil.buildNormalBinder().toJson((Object)logList));
            return "logList is null\uff0c\u6ca1\u6709\u5f85\u8865\u507f\u7684\u65b0\u589e\u8bb0\u5f55";
        }
        for (LogErrorLog logErrorLog : logList) {
            this.pullSkuBySkuNo(logErrorLog.getUserCode());
            this.updateLogState(logErrorLog, logErrorLog.getDataState(), 4);
        }
        return this.makeSuccessReturn("SUCCESS");
    }

    @Override
    public String pullSkuBySkuNo(String skuNo) {
        if (StringUtils.isBlank((String)skuNo)) {
            logger.error(this.SYS_CODE + ".pullSkuBySkuNo.skuNo", (Object)"skuNo\u4e3a\u7a7a");
            throw new ApiException("skuNo\u4e3a\u7a7a");
        }
        String sql = "SELECT\n\t* \nFROM\n\tCJ_V_Itemmaster \nWHERE\n\tOrgCode = '001' \n\tAND IsSalesEnable = 1 \n\tAND ( Prv18Code IS NOT NULL AND Prv18Name != '' ) \n\tAND ( Prv10Code IS NOT NULL AND Prv10Name != '' ) \n\tAND IsSalesEnable = 1 \n\tAND itemCode = ?;";
        List<Object> resourceGoodsU9 = new ArrayList();
        try {
            resourceGoodsU9 = SqlServerUtils.getForListBySkuNo(sql, skuNo);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".pullSkuBySkuNo.view", (Object)("\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898" + e));
            throw new ApiException("\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
        }
        if (CollectionUtils.isEmpty(resourceGoodsU9)) {
            throw new ApiException("skuNo==" + skuNo + "u9\u89c6\u56fe\u6682\u672a\u67e5\u5230");
        }
        for (ResourceGoodsU9 resourceGoodsU92 : resourceGoodsU9) {
            try {
                this.saveResourceGoods(resourceGoodsU92);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.saveLogError(this.getInternalRouter(), resourceGoodsU92, "GOODS", ComConstants.tenantCode, "busdata.busRsGoods.sendInitialAndAddBusGoods", e.getMessage());
            }
        }
        return "success";
    }

    private void compareSkuInformationAndModify(InternalRouter internalRouter, String tenantCode, RsResourceGoodsDomain rsResourceGoodsDomain, ResourceGoodsU9 resourceGoodsU9) throws Exception {
        this.compareRsResourceGoodsInformationAndModify(rsResourceGoodsDomain, tenantCode, internalRouter);
        this.compareChannelSkuAndModify(rsResourceGoodsDomain, internalRouter, tenantCode);
        this.compareSkuStateAndModify(internalRouter, rsResourceGoodsDomain, resourceGoodsU9);
    }

    private void compareSkuStateAndModify(InternalRouter internalRouter, RsResourceGoodsDomain rsResourceGoodsDomain, ResourceGoodsU9 resourceGoodsU9) throws Exception {
        RsSkuDomain rsSkuDomainBuild = rsResourceGoodsDomain.getRsSkuDomainList().get(0);
        if (this.checkSkuPriceCateGoryAndModify(internalRouter, rsResourceGoodsDomain, rsSkuDomainBuild)) {
            return;
        }
        HashMap<String, Object> skuMap1 = new HashMap<String, Object>();
        skuMap1.put("skuEocode", rsSkuDomainBuild.getSkuEocode());
        skuMap1.put("tenantCode", rsSkuDomainBuild.getTenantCode());
        RsSkuReDomain oldRsSkuReDomain = this.querySkuPage(skuMap1);
        String effective_isEffective = resourceGoodsU9.getEffective_IsEffective();
        Integer oldDataOpbillstate = oldRsSkuReDomain.getDataOpbillstate();
        String goodsSp = oldRsSkuReDomain.getGoodsSp();
        BeanUtils.copyAllPropertysNotNull((Object)oldRsSkuReDomain, (Object)rsSkuDomainBuild);
        this.queryRsGoodsFileForSkuAndSet(oldRsSkuReDomain, internalRouter);
        if ("0".equals(effective_isEffective)) {
            this.updateRsSkuDomainNew(oldRsSkuReDomain);
            if (null != oldDataOpbillstate && oldDataOpbillstate == 1 && null != oldRsSkuReDomain.getDataState() && oldRsSkuReDomain.getDataState() == 2) {
                this.sendUpdateSoldOutBatchSku(oldRsSkuReDomain);
            }
        } else {
            this.updateRsSkuDomainNew(oldRsSkuReDomain);
        }
    }

    private boolean checkSkuPriceCateGoryAndModify(InternalRouter internalRouter, final RsResourceGoodsDomain rsResourceGoodsDomain, RsSkuDomain rsSkuDomainBuild) throws Exception {
        final String skuRemark = rsSkuDomainBuild.getSkuRemark();
        HashMap<String, Object> classTreeMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
                this.put("classtreeEocode", skuRemark);
            }
        };
        QueryResult<RsClasstreeDomain> rsClasstreeDomainQueryResult = this.queryRsClasstreePage((Map<String, Object>)classTreeMap);
        if (null == rsClasstreeDomainQueryResult || ListUtil.isEmpty((Collection)rsClasstreeDomainQueryResult.getList())) {
            return true;
        }
        RsClasstreeDomain rsClasstreeDomain = (RsClasstreeDomain)rsClasstreeDomainQueryResult.getList().get(0);
        if (!rsClasstreeDomain.getClasstreeName().equals(rsSkuDomainBuild.getGoodsWeightstr())) {
            rsClasstreeDomain.setClasstreeName(rsSkuDomainBuild.getGoodsWeightstr());
            this.updateRsClassTree(rsClasstreeDomain, internalRouter);
        }
        return false;
    }

    private void queryRsGoodsFileForSkuAndSet(final RsSkuReDomain oldRsSkuReDomain, InternalRouter internalRouter) {
        final HashMap<String, Object> goodsFileMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", oldRsSkuReDomain.getTenantCode());
                this.put("skuCode", oldRsSkuReDomain.getSkuCode());
            }
        };
        HashMap<String, Object> goodsFileParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)goodsFileMap));
            }
        };
        logger.error(this.SYS_CODE + ".queryRsGoodsFileForSkuAndSet.goodsFileParamMap", (Object)"\u67e5\u8be2rsGoodsFile\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".queryRsGoodsFileForSkuAndSet.goodsFileParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)goodsFileParamMap));
        String goodsFileStr = (String)internalRouter.inInvoke("dis.dgoods.queryDgoodsPage", (Map)goodsFileParamMap);
        logger.error(this.SYS_CODE + ".queryRsGoodsFileForSkuAndSet.disGoodsListStr", (Object)"\u67e5\u8be2rsGoodsFile\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(goodsFileStr, SupQueryResult.class);
        logger.error(this.SYS_CODE + ".queryRsGoodsFileForSkuAndSet.supQueryResult", (Object)JsonUtil.buildNormalBinder().toJson((Object)supQueryResult));
        if (null == supQueryResult) {
            return;
        }
        List goodsFileList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), RsGoodsFile.class);
        logger.error(this.SYS_CODE + ".queryRsGoodsFileForSkuAndSet.goodsFileList", (Object)JsonUtil.buildNormalBinder().toJson((Object)goodsFileList));
        if (null == goodsFileList || ListUtil.isEmpty((Collection)goodsFileList)) {
            return;
        }
        ArrayList<RsGoodsFileDomain> rsGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
        for (RsGoodsFile rsGoodsFile : goodsFileList) {
            RsGoodsFileDomain rsGoodsFileDomain = new RsGoodsFileDomain();
            try {
                BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain, (Object)rsGoodsFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            rsGoodsFileDomainList.add(rsGoodsFileDomain);
        }
        oldRsSkuReDomain.setRsGoodsFileDomainList(rsGoodsFileDomainList);
    }

    private void compareChannelSkuAndModify(RsResourceGoodsDomain rsResourceGoodsDomain, InternalRouter internalRouter, String tenantCode) throws Exception {
        List<DisDgoodsScopelistDomain> newDisDgoodsScopelistDomains;
        RsSkuDomain newSkuDomain = rsResourceGoodsDomain.getRsSkuDomainList().get(0);
        String channelNames = "\u7231\u5eb7\u6c11\u7528,\u7231\u5eb7\u5de5\u7a0b,\u7231\u5eb7\u6696\u901a";
        List<DisDgoods> disDgoods = this.queryDisGoodsPage(tenantCode, channelNames);
        DisDgoods minYongDisGoods = null;
        DisDgoods gongChnegDisGoods = null;
        DisDgoods nuanTongDisGoods = null;
        if (ListUtil.isNotEmpty(disDgoods)) {
            minYongDisGoods = (DisDgoods)disDgoods.stream().filter(item -> item.getChannelName().equals(MING_YONG_CHANNEL_NAME)).collect(Collectors.toList()).get(0);
            gongChnegDisGoods = (DisDgoods)disDgoods.stream().filter(item -> item.getChannelName().equals(GONG_CHENG_CHANNEL_NAME)).collect(Collectors.toList()).get(0);
            nuanTongDisGoods = (DisDgoods)disDgoods.stream().filter(item -> item.getChannelName().equals(NUAN_TONAG_CHANNEL_NAME)).collect(Collectors.toList()).get(0);
        }
        String skuEoCode = newSkuDomain.getSkuEocode();
        String minYongDgoodsCode = MINYON_GDGOODS_CODE;
        String gongChengDgoodsCode = GONGCHENG_DGOODS_CODE;
        String nuanTongDgoodsCode = NUANTONG_DGOODS_CODE;
        List<DisDgoodsScopelist> oldDisDgoodsScopelists = this.queryDgoodsScopelistPageBySkuEocode(tenantCode, internalRouter, skuEoCode);
        boolean oldMinYongFlag = false;
        boolean oldGongChengFlag = false;
        boolean oldNuanTongFlag = false;
        if (null != minYongDisGoods) {
            boolean bl = oldMinYongFlag = oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(minYongDgoodsCode)).collect(Collectors.toList()).size() > 0;
        }
        if (null != gongChnegDisGoods) {
            boolean bl = oldGongChengFlag = oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(gongChengDgoodsCode)).collect(Collectors.toList()).size() > 0;
        }
        if (null != nuanTongDisGoods) {
            oldNuanTongFlag = oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(nuanTongDgoodsCode)).collect(Collectors.toList()).size() > 0;
        }
        boolean newMinYongFlag = (newDisDgoodsScopelistDomains = rsResourceGoodsDomain.getDisDgoodsScopelistDomains()).stream().filter(item -> item.getDgoodsCode().equals(minYongDgoodsCode)).collect(Collectors.toList()).size() > 0;
        boolean newGongChengFlag = newDisDgoodsScopelistDomains.stream().filter(item -> item.getDgoodsCode().equals(gongChengDgoodsCode)).collect(Collectors.toList()).size() > 0;
        boolean newNuanTongFlag = newDisDgoodsScopelistDomains.stream().filter(item -> item.getDgoodsCode().equals(nuanTongDgoodsCode)).collect(Collectors.toList()).size() > 0;
        DisDgoodsScopelist oldMinYongDisDgoodsScopelist = ListUtil.isEmpty((Collection)oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(minYongDgoodsCode)).collect(Collectors.toList())) ? null : (DisDgoodsScopelist)oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(minYongDgoodsCode)).collect(Collectors.toList()).get(0);
        DisDgoodsScopelistDomain newMinYongDisDgoodsScopelist = ListUtil.isEmpty((Collection)newDisDgoodsScopelistDomains.stream().filter(item -> item.getDgoodsCode().equals(minYongDgoodsCode)).collect(Collectors.toList())) ? null : (DisDgoodsScopelistDomain)newDisDgoodsScopelistDomains.stream().filter(item -> item.getDgoodsCode().equals(minYongDgoodsCode)).collect(Collectors.toList()).get(0);
        DisDgoodsScopelist oldGongChneDisDgoodsScopelist = ListUtil.isEmpty((Collection)oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(gongChengDgoodsCode)).collect(Collectors.toList())) ? null : (DisDgoodsScopelist)oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(gongChengDgoodsCode)).collect(Collectors.toList()).get(0);
        DisDgoodsScopelistDomain newGongChneDisDgoodsScopelist = ListUtil.isEmpty((Collection)newDisDgoodsScopelistDomains.stream().filter(item -> item.getDgoodsCode().equals(gongChengDgoodsCode)).collect(Collectors.toList())) ? null : (DisDgoodsScopelistDomain)newDisDgoodsScopelistDomains.stream().filter(item -> item.getDgoodsCode().equals(gongChengDgoodsCode)).collect(Collectors.toList()).get(0);
        DisDgoodsScopelist oldNuanTongDisDgoodsScopelist = ListUtil.isEmpty((Collection)oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(nuanTongDgoodsCode)).collect(Collectors.toList())) ? null : (DisDgoodsScopelist)oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(nuanTongDgoodsCode)).collect(Collectors.toList()).get(0);
        DisDgoodsScopelistDomain newNuanTongDisDgoodsScopelist = ListUtil.isEmpty((Collection)newDisDgoodsScopelistDomains.stream().filter(item -> item.getDgoodsCode().equals(nuanTongDgoodsCode)).collect(Collectors.toList())) ? null : (DisDgoodsScopelistDomain)newDisDgoodsScopelistDomains.stream().filter(item -> item.getDgoodsCode().equals(nuanTongDgoodsCode)).collect(Collectors.toList()).get(0);
        this.compareDisDgoodsScopelist(internalRouter, oldMinYongFlag, newMinYongFlag, oldMinYongDisDgoodsScopelist, newMinYongDisDgoodsScopelist);
        this.compareDisDgoodsScopelist(internalRouter, oldGongChengFlag, newGongChengFlag, oldGongChneDisDgoodsScopelist, newGongChneDisDgoodsScopelist);
        this.compareDisDgoodsScopelist(internalRouter, oldNuanTongFlag, newNuanTongFlag, oldNuanTongDisDgoodsScopelist, newNuanTongDisDgoodsScopelist);
    }

    private void compareDisDgoodsScopelist(InternalRouter internalRouter, boolean oldFlag, boolean newFlag, DisDgoodsScopelist oldDisDgoodsScopelist, DisDgoodsScopelistDomain newDisDgoodsScopelist) throws Exception {
        if (Boolean.compare(oldFlag, newFlag) != 0) {
            if (oldFlag) {
                this.deletDgoodsScopeListByScoplistId(internalRouter, oldDisDgoodsScopelist.getDgoodsScopelistId());
            } else {
                this.saveDgoodsScopeList(internalRouter, newDisDgoodsScopelist);
            }
        } else {
            BeanUtils.copyAllPropertysNotNull((Object)oldDisDgoodsScopelist, (Object)newDisDgoodsScopelist);
            if (null != oldDisDgoodsScopelist) {
                this.updateDgoodsScopeList(internalRouter, oldDisDgoodsScopelist);
            }
        }
    }

    private void updateDgoodsScopeList(InternalRouter internalRouter, final DisDgoodsScopelist oldDisDgoodsScopelist) throws Exception {
        HashMap<String, Object> saveDdFlagParamMap = new HashMap<String, Object>(){
            {
                this.put("disDgoodsScopelistDomain", JsonUtil.buildNormalBinder().toJson((Object)oldDisDgoodsScopelist));
            }
        };
        logger.error(this.SYS_CODE + ".updateDgoodsScopeList", (Object)JsonUtil.buildNormalBinder().toJson((Object)saveDdFlagParamMap));
        logger.error(this.SYS_CODE + ".updateDgoodsScopeList", (Object)"\u4fee\u6539disDgoodsScopelistDomain\u5f00\u59cb");
        internalRouter.inInvoke("is.dgoods.updateDgoodsScopelist", (Map)saveDdFlagParamMap);
        logger.error(this.SYS_CODE + ".updateDgoodsScopeList", (Object)"\u4fee\u6539disDgoodsScopelistDomain\u7ed3\u675f");
    }

    private void saveDgoodsScopeList(InternalRouter internalRouter, final DisDgoodsScopelistDomain disDgoodsScopelistDomain) throws Exception {
        HashMap<String, Object> saveDdFlagParamMap = new HashMap<String, Object>(){
            {
                this.put("disDgoodsScopelistDomain", JsonUtil.buildNormalBinder().toJson((Object)disDgoodsScopelistDomain));
            }
        };
        logger.error(this.SYS_CODE + ".saveDgoodsScopeList", (Object)JsonUtil.buildNormalBinder().toJson((Object)saveDdFlagParamMap));
        logger.error(this.SYS_CODE + ".saveDgoodsScopeList", (Object)"\u4fdd\u5b58disDgoodsScopelistDomain\u5f00\u59cb");
        internalRouter.inInvoke("dis.dgoods.saveDgoodsScopelist", (Map)saveDdFlagParamMap);
        logger.error(this.SYS_CODE + ".saveDgoodsScopeList", (Object)"\u4fdd\u5b58disDgoodsScopelistDomain\u7ed3\u675f");
    }

    private void deletDgoodsScopeListByScoplistId(InternalRouter internalRouter, final Integer dgoodsScopelistId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("dgoodsScopelistId", dgoodsScopelistId);
            }
        };
        internalRouter.inInvoke("dis.dgoods.deleteDgoodsScopelist", (Map)map);
    }

    private void compareRsResourceGoodsInformationAndModify(final RsResourceGoodsDomain newRsResourceGoodsDomain, final String tenantCode, InternalRouter internalRouter) throws Exception {
        HashMap<String, Object> goodsMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", tenantCode);
                this.put("goodsEocode", newRsResourceGoodsDomain.getGoodsEocode());
            }
        };
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsReDomainQueryResult = this.queryRsResourceGoodsPage((Map<String, Object>)goodsMap);
        logger.error(this.SYS_CODE + ".compareRsResourceGoodsInformationAndModify.rsResourceGoodsReDomainQueryResult", (Object)JsonUtil.buildNormalBinder().toJson(rsResourceGoodsReDomainQueryResult));
        if (null == rsResourceGoodsReDomainQueryResult || null == rsResourceGoodsReDomainQueryResult.getList() || ListUtil.isEmpty((Collection)rsResourceGoodsReDomainQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".compareRsResourceGoodsInformationAndModify.rsResourceGoodsReDomainQueryResult.null", (Object)JsonUtil.buildNormalBinder().toJson(rsResourceGoodsReDomainQueryResult));
            return;
        }
        RsResourceGoodsReDomain oldRsResourceGoodsReDomain = (RsResourceGoodsReDomain)rsResourceGoodsReDomainQueryResult.getList().get(0);
        try {
            BeanUtils.copyAllPropertysNotNull((Object)oldRsResourceGoodsReDomain, (Object)newRsResourceGoodsDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        oldRsResourceGoodsReDomain.setRsSkuDomainList(null);
        oldRsResourceGoodsReDomain.setIsDel(true);
        logger.error(this.SYS_CODE + ".compareRsResourceGoodsInformationAndModify.LastOldRsResourceGoodsReDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)oldRsResourceGoodsReDomain));
        this.checkClassTreeAndGoodsClassChanngeAndModify(oldRsResourceGoodsReDomain, tenantCode, internalRouter);
        this.buildSpecValueListForSkuModify(oldRsResourceGoodsReDomain);
        this.updateEsResourceGoodsDomainU9(oldRsResourceGoodsReDomain);
    }

    private void checkClassTreeAndGoodsClassChanngeAndModify(RsResourceGoodsDomain rsResourceGoodsDomain, String tenantCode, InternalRouter internalRouter) throws Exception {
        this.checkClassTreeChangeAndModify(rsResourceGoodsDomain, tenantCode, internalRouter);
    }

    private void checkGoodsClassChangeAndModify(RsResourceGoodsDomain rsResourceGoodsDomain, final String tenantCode, InternalRouter internalRouter) throws Exception {
        RsGoodsClassDomain goodsClassDomain;
        RsGoodsClassDomain secondGoodsClassDomain;
        String classtreeShopcode;
        String secondClasstreeShopcode;
        final String oneClasstreeShopcode = rsResourceGoodsDomain.getOneClasstreeShopcode();
        HashMap<String, Object> goodsClassMap = new HashMap<String, Object>(secondClasstreeShopcode = rsResourceGoodsDomain.getSecondClasstreeShopcode(), classtreeShopcode = rsResourceGoodsDomain.getClasstreeShopcode()){
            final /* synthetic */ String val$secondClasstreeShopcode;
            final /* synthetic */ String val$classtreeShopcode;
            {
                this.val$secondClasstreeShopcode = string3;
                this.val$classtreeShopcode = string4;
                this.put("tenantCode", tenantCode);
                this.put("goodsClassEocode", oneClasstreeShopcode + "," + this.val$secondClasstreeShopcode + "," + this.val$classtreeShopcode);
            }
        };
        QueryResult<RsGoodsClassDomain> rsGoodsClassDomainQueryResult = this.queryRsGoodsClassPage((Map<String, Object>)goodsClassMap);
        if (null == rsGoodsClassDomainQueryResult || ListUtil.isEmpty((Collection)rsGoodsClassDomainQueryResult.getList()) || rsGoodsClassDomainQueryResult.getList().size() != 3) {
            logger.error(this.SYS_CODE + ".checkClassTreeAndGoodsClassChanngeAndModify", (Object)"\u4fee\u6539\u5206\u7c7b\u4fe1\u606f\u65f6\u5019\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u524d\u53f0\u5206\u7c7b!\u6570\u636e\u67e5\u8be2\u9519\u8bef!");
            throw new RuntimeException("\u4fee\u6539\u5206\u7c7b\u4fe1\u606f\u65f6\u5019\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u524d\u53f0\u5206\u7c7b!\u6570\u636e\u67e5\u8be2\u9519\u8bef!");
        }
        List goodsClassList = rsGoodsClassDomainQueryResult.getList();
        RsGoodsClassDomain oneRsGoodsClassDomain = (RsGoodsClassDomain)goodsClassList.stream().filter(item -> item.getGoodsClassParentcode().equals("-1")).collect(Collectors.toList()).get(0);
        if (!oneRsGoodsClassDomain.getGoodsClassName().equals(rsResourceGoodsDomain.getOneClasstreeShopname())) {
            oneRsGoodsClassDomain.setGoodsClassName(rsResourceGoodsDomain.getOneClasstreeShopname());
            this.updateRsGoodsClass(internalRouter, oneRsGoodsClassDomain);
        }
        if (!(secondGoodsClassDomain = (RsGoodsClassDomain)goodsClassList.stream().filter(item -> item.getGoodsClassParentcode().equals(oneRsGoodsClassDomain.getGoodsClassCode())).collect(Collectors.toList()).get(0)).getGoodsClassName().equals(rsResourceGoodsDomain.getSecondClasstreeShopname())) {
            secondGoodsClassDomain.setGoodsClassName(rsResourceGoodsDomain.getSecondClasstreeShopname());
            this.updateRsGoodsClass(internalRouter, secondGoodsClassDomain);
        }
        if (!(goodsClassDomain = (RsGoodsClassDomain)goodsClassList.stream().filter(item -> item.getGoodsClassParentcode().equals(secondGoodsClassDomain.getGoodsClassCode())).collect(Collectors.toList()).get(0)).getGoodsClassName().equals(rsResourceGoodsDomain.getClasstreeShopname())) {
            secondGoodsClassDomain.setGoodsClassName(rsResourceGoodsDomain.getClasstreeShopname());
            this.updateRsGoodsClass(internalRouter, goodsClassDomain);
        }
    }

    private void updateRsGoodsClass(InternalRouter internalRouter, final RsGoodsClassDomain rsGoodsClassDomain) throws Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(){
            {
                this.put("rsGoodsClassDomain", rsGoodsClassDomain);
            }
        };
        internalRouter.inInvoke("rs.goodsClass.updateGoodsClass", (Map)paramMap);
    }

    private void checkClassTreeChangeAndModify(RsResourceGoodsDomain rsResourceGoodsDomain, final String tenantCode, InternalRouter internalRouter) throws Exception {
        RsClasstreeDomain rsClasstreeDomain;
        RsClasstreeDomain secondRsClasstreeDomain;
        String classtreeCode;
        String secondClasstreeCode;
        final String oneClasstreeCode = rsResourceGoodsDomain.getClassificationCode1();
        HashMap<String, Object> classTreeMap = new HashMap<String, Object>(secondClasstreeCode = rsResourceGoodsDomain.getClassificationCode2(), classtreeCode = rsResourceGoodsDomain.getClasstreeCode()){
            final /* synthetic */ String val$secondClasstreeCode;
            final /* synthetic */ String val$classtreeCode;
            {
                this.val$secondClasstreeCode = string3;
                this.val$classtreeCode = string4;
                this.put("tenantCode", tenantCode);
                this.put("classtreeEocode", oneClasstreeCode + "," + this.val$secondClasstreeCode + "," + this.val$classtreeCode);
            }
        };
        QueryResult<RsClasstreeDomain> rsClasstreeDomainQueryResult = this.queryRsClasstreePage((Map<String, Object>)classTreeMap);
        if (null == rsClasstreeDomainQueryResult || ListUtil.isEmpty((Collection)rsClasstreeDomainQueryResult.getList()) || rsClasstreeDomainQueryResult.getList().size() != 3) {
            logger.error(this.SYS_CODE + ".checkClassTreeChangeAndModify.checkClassTreeAndGoodsClassChanngeAndModify", (Object)"\u4fee\u6539\u5206\u7c7b\u4fe1\u606f\u65f6\u5019\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u540e\u53f0\u5206\u7c7b!\u6570\u636e\u67e5\u8be2\u9519\u8bef!");
            throw new RuntimeException("\u4fee\u6539\u5206\u7c7b\u4fe1\u606f\u65f6\u5019\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u540e\u53f0\u5206\u7c7b!\u6570\u636e\u67e5\u8be2\u9519\u8bef!");
        }
        List rsClassTreelist = rsClasstreeDomainQueryResult.getList();
        RsClasstreeDomain oneRsClasstree = (RsClasstreeDomain)rsClassTreelist.stream().filter(item -> item.getClasstreeParentcode().equals("-1")).collect(Collectors.toList()).get(0);
        if (!oneRsClasstree.getClasstreeName().equals(rsResourceGoodsDomain.getClassificationName1())) {
            oneRsClasstree.setClasstreeName(rsResourceGoodsDomain.getClassificationName1());
            this.updateRsClassTree(oneRsClasstree, internalRouter);
        }
        if (!(secondRsClasstreeDomain = (RsClasstreeDomain)rsClassTreelist.stream().filter(item -> item.getClasstreeParentcode().equals(oneRsClasstree.getClasstreeCode())).collect(Collectors.toList()).get(0)).getClasstreeName().equals(rsResourceGoodsDomain.getClassificationName2())) {
            secondRsClasstreeDomain.setClasstreeName(rsResourceGoodsDomain.getClassificationName2());
            this.updateRsClassTree(secondRsClasstreeDomain, internalRouter);
        }
        if (!(rsClasstreeDomain = (RsClasstreeDomain)rsClassTreelist.stream().filter(item -> item.getClasstreeParentcode().equals(secondRsClasstreeDomain.getClasstreeCode())).collect(Collectors.toList()).get(0)).getClasstreeName().equals(rsResourceGoodsDomain.getClasstreeName())) {
            rsClasstreeDomain.setClasstreeName(rsResourceGoodsDomain.getClasstreeName());
            this.updateRsClassTree(rsClasstreeDomain, internalRouter);
        }
    }

    private void updateRsClassTree(final RsClasstreeDomain rsClasstree, InternalRouter internalRouter) throws Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(){
            {
                this.put("rsClasstreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsClasstree));
            }
        };
        internalRouter.inInvoke("rs.rsClasstree.updateClasstree", (Map)paramMap);
    }

    private String getStringlocalDateTimeBy(LocalDateTime time) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(time);
    }

    private void saveResourceGoods(ResourceGoodsU9 resourceGoodsU9) {
        String channelNames = "\u7231\u5eb7\u6c11\u7528,\u7231\u5eb7\u5de5\u7a0b,\u7231\u5eb7\u6696\u901a";
        List<DisDgoods> disDgoods = this.queryDisGoodsPage(ComConstants.tenantCode, channelNames);
        if (null == disDgoods || ListUtil.isEmpty(disDgoods)) {
            logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.saveResourceGoods.queryDisGoodsPage", (Object)"disDgoods is null");
            throw new RuntimeException(channelNames + "disDgoods\u4e3a\u7a7a");
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = this.buildrResourceGoodsDomain(resourceGoodsU9);
        this.buildRsSkuDomainList(resourceGoodsU9, rsResourceGoodsDomain, ComConstants.tenantCode, disDgoods);
        this.sendSaveExcelBusGoods(rsResourceGoodsDomain);
    }

    private List<RsSkuDomain> buildRsSkuDomainList(ResourceGoodsU9 item, RsResourceGoodsDomain rsResourceGoodsDomain, String tenantCode, List<DisDgoods> disDgoods) {
        ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        rsSkuDomain.setPricesetNprice(new BigDecimal("9999999"));
        rsSkuDomain.setGoodsNum(new BigDecimal("999999"));
        rsSkuDomain.setTenantCode(tenantCode);
        rsSkuDomain.setGoodsEocode(rsResourceGoodsDomain.getGoodsEocode());
        rsSkuDomain.setSkuEocode(item.getItemCode());
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)rsResourceGoodsDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        rsSkuDomain.setGoodsShowno(item.getPrv12Name());
        String skuName = item.getSpecs();
        if (StringUtils.isNotBlank((String)item.getPrv16Name())) {
            skuName = skuName + "/" + item.getPrv16Name();
        }
        if (StringUtils.isNotBlank((String)item.getPrv1Name())) {
            rsSkuDomain.setGoodsOrdweight(new BigDecimal(item.getPrv1Name()));
        }
        rsSkuDomain.setSkuName(skuName);
        rsSkuDomain.setSkuNo(item.getItemCode());
        rsSkuDomain.setGoodsShowname(item.getItemName());
        rsSkuDomain.setClasstreeCode(item.getThreeCategoryCode());
        rsSkuDomain.setClasstreeName(item.getThreeCategoryName());
        rsSkuDomain.setPntreeCode(item.getPrv18Code());
        if (StringUtils.isNotBlank((String)item.getWeight()) && StringUtils.isNotBlank((String)item.getWeightUOMName())) {
            rsSkuDomain.setGoodsWeight(new BigDecimal(item.getWeight()));
            rsSkuDomain.setPartsnameWeightunit(item.getWeightUOMName());
        }
        rsSkuDomain.setPntreeName(item.getPrv18Name());
        rsSkuDomain.setPartsnameNumunit(item.getPriceUOMName());
        if (StringUtils.isNotBlank((String)item.getBulkUOMName())) {
            rsSkuDomain.setPartsnameNumunit1(item.getBulkUOMName());
        }
        if (StringUtils.isNotBlank((String)item.getPrv14Name())) {
            rsSkuDomain.setPartsnameWeightunit(item.getPrv14Name());
        }
        if (StringUtils.isNotBlank((String)item.getPrv26Name())) {
            rsSkuDomain.setGoodsAhweight(new BigDecimal(item.getPrv26Name()));
        }
        if (StringUtils.isNotBlank((String)item.getPrv24Name())) {
            rsSkuDomain.setGoodsUnitstr(item.getPrv24Name());
        }
        if (StringUtils.isNotBlank((String)item.getPrv27Name())) {
            rsSkuDomain.setGoodsHangweight(new BigDecimal(item.getPrv27Name()));
        }
        if (StringUtils.isNotBlank((String)item.getPrv25Name())) {
            rsSkuDomain.setGoodsWeightstr(item.getPrv25Name());
        }
        if (StringUtils.isNotBlank((String)item.getPrv28Name())) {
            rsSkuDomain.setGoodsHangnum(new BigDecimal(item.getPrv28Name()));
        }
        rsSkuDomain.setClasstreeShopcode(item.getPriceCategoryCode());
        rsSkuDomain.setClasstreeShopname(item.getPriceCategoryName());
        if ("0".equals(item.getEffective_IsEffective())) {
            rsSkuDomain.setGoodsSale(1);
        } else {
            rsSkuDomain.setGoodsSale(0);
        }
        rsSkuDomain.setGoodsNum(new BigDecimal("999"));
        rsSkuDomain.setGoodsSupplynum(new BigDecimal("999"));
        rsSkuDomain.setChannelCode(ComConstants.channelCode);
        rsSkuDomain.setGoodsClass("plat");
        rsSkuDomain.setMemberCode(ComConstants.membercode);
        rsSkuDomain.setGoodsOneweight(BigDecimal.ONE);
        rsSkuDomain.setGoodsOrigin("0");
        rsSkuDomain.setGoodsPro("0");
        rsSkuDomain.setGoodsType("00");
        rsSkuDomain.setClassificationName1(item.getFirstCategoryName());
        rsSkuDomain.setClassificationCode1(item.getFirstCategoryCode());
        rsSkuDomain.setClassificationCode2(item.getSecondCategoryCode());
        rsSkuDomain.setClassificationName2(item.getSecondCategoryName());
        rsSkuDomain.setMschannelName("0");
        this.buildScopList(rsResourceGoodsDomain, rsSkuDomain, item.getPrv11Name(), disDgoods, rsSkuDomain.getGoodsShowname(), rsSkuDomain.getSkuName());
        rsSkuDomainList.add(rsSkuDomain);
        rsResourceGoodsDomain.setRsSkuDomainList(rsSkuDomainList);
        return rsSkuDomainList;
    }

    private void buildScopList(RsResourceGoodsDomain rsResourceGoodsDomain, RsSkuDomain rsSkuDomain, String prv11Name, List<DisDgoods> disDgoodsList, String goodsShowname, String skuName) {
        String[] split;
        ArrayList<DisDgoodsScopelistDomain> disDgoodsScopelistDomains = new ArrayList<DisDgoodsScopelistDomain>();
        if (StringUtils.isBlank((String)prv11Name)) {
            return;
        }
        for (String channelName : split = prv11Name.split("/")) {
            DisDgoodsScopelistDomain disDgoodsScopelistDomain = new DisDgoodsScopelistDomain();
            String goodsChannelName = "";
            goodsChannelName = channelName.contains("\u6c11\u7528") ? MING_YONG_CHANNEL_NAME : (channelName.contains("\u5de5\u7a0b") ? GONG_CHENG_CHANNEL_NAME : GONG_CHENG_CHANNEL_NAME);
            String finalGoodsChannelName = goodsChannelName;
            DisDgoods disDgoods = (DisDgoods)disDgoodsList.stream().filter(item -> item.getChannelName().equals(finalGoodsChannelName)).collect(Collectors.toList()).get(0);
            if (null == disDgoods) continue;
            try {
                BeanUtils.copyAllPropertys((Object)disDgoodsScopelistDomain, (Object)disDgoods);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            disDgoodsScopelistDomain.setChannelName(channelName);
            disDgoodsScopelistDomain.setDgoodsScopelistCode(this.createUUIDString());
            disDgoodsScopelistDomain.setChannelSort("1");
            disDgoodsScopelistDomain.setChannelType("0");
            disDgoodsScopelistDomain.setDgoodsScopelistType("skuNo");
            disDgoodsScopelistDomain.setDgoodsScopelistValue(rsSkuDomain.getSkuNo());
            disDgoodsScopelistDomain.setDgoodsScopelistValuen(goodsShowname);
            disDgoodsScopelistDomain.setDgoodsScopelistValuename(rsSkuDomain.getSkuEocode());
            disDgoodsScopelistDomain.setDgoodsScopelistDes(skuName);
            disDgoodsScopelistDomain.setDgoodsScopelistTerm("=");
            disDgoodsScopelistDomains.add(disDgoodsScopelistDomain);
        }
        rsSkuDomain.setDisDgoodsScopelistDomains(disDgoodsScopelistDomains);
        rsResourceGoodsDomain.getDisDgoodsScopelistDomains().addAll(rsSkuDomain.getDisDgoodsScopelistDomains());
    }

    private RsResourceGoodsDomain buildrResourceGoodsDomain(ResourceGoodsU9 item) {
        RsSpecOptionDomain rsSpecOptionDomain;
        ArrayList<RsSpecOptionDomain> specOptionDomainList;
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        rsResourceGoodsDomain.setDisDgoodsScopelistDomains(new ArrayList<DisDgoodsScopelistDomain>());
        rsResourceGoodsDomain.setTenantCode(ComConstants.tenantCode);
        if (StringUtils.isNotBlank((String)item.getPrv1Name())) {
            rsResourceGoodsDomain.setGoodsOrdweight(new BigDecimal(item.getPrv1Name()));
        }
        rsResourceGoodsDomain.setGoodsEocode(item.getPrv10Code());
        rsResourceGoodsDomain.setGoodsNo(item.getPrv10Code());
        rsResourceGoodsDomain.setGoodsName(item.getPrv10Name());
        rsResourceGoodsDomain.setBrandCode(item.getPrv8Code());
        rsResourceGoodsDomain.setBrandName(item.getPrv8Name());
        rsResourceGoodsDomain.setGoodsMaterial(item.getPrv9Name());
        rsResourceGoodsDomain.setPntreeCode(item.getFirstCategoryCode());
        rsResourceGoodsDomain.setPntreeName(item.getFirstCategoryName());
        rsResourceGoodsDomain.setClasstreeCode(item.getThreeCategoryCode());
        rsResourceGoodsDomain.setClasstreeName(item.getThreeCategoryName());
        rsResourceGoodsDomain.setClasstreeShopcode(item.getPriceCategoryCode());
        rsResourceGoodsDomain.setClasstreeShopname(item.getPriceCategoryName());
        rsResourceGoodsDomain.setClassificationName1(item.getFirstCategoryName());
        rsResourceGoodsDomain.setClassificationCode1(item.getFirstCategoryCode());
        rsResourceGoodsDomain.setClassificationCode2(item.getSecondCategoryCode());
        rsResourceGoodsDomain.setClassificationName2(item.getSecondCategoryName());
        ArrayList<RsSpecDomain> rsSpecDomainList = new ArrayList<RsSpecDomain>();
        if (StringUtils.isNotBlank((String)item.getPrv16Name())) {
            RsSpecDomain innerSsSpecDomain = new RsSpecDomain();
            innerSsSpecDomain.setSpecName("\u4e2d\u5185\u5c42\u989c\u8272");
            specOptionDomainList = new ArrayList<RsSpecOptionDomain>();
            rsSpecOptionDomain = new RsSpecOptionDomain();
            rsSpecOptionDomain.setSpecOptionName(item.getPrv16Name());
            specOptionDomainList.add(rsSpecOptionDomain);
            innerSsSpecDomain.setSpecOptionList(specOptionDomainList);
            rsSpecDomainList.add(innerSsSpecDomain);
        }
        if (StringUtils.isNotBlank((String)item.getSpecs())) {
            RsSpecDomain specDomain = new RsSpecDomain();
            specDomain.setSpecName("\u578b\u53f7");
            specOptionDomainList = new ArrayList();
            rsSpecOptionDomain = new RsSpecOptionDomain();
            rsSpecOptionDomain.setSpecOptionName(item.getSpecs());
            specOptionDomainList.add(rsSpecOptionDomain);
            specDomain.setSpecOptionList(specOptionDomainList);
            rsSpecDomainList.add(specDomain);
        }
        rsResourceGoodsDomain.setRsSpecDomainList(rsSpecDomainList);
        rsResourceGoodsDomain.setMschannelName("0");
        return rsResourceGoodsDomain;
    }

    private void updateFalgSettingInFoByKey(InternalRouter internalRouter, String modifiedon, Integer flagSettingId) {
        final DdFalgSettingDomain ddFalgSettingDomain = new DdFalgSettingDomain();
        ddFalgSettingDomain.setFlagSettingId(flagSettingId);
        ddFalgSettingDomain.setFlagSettingInfo(modifiedon);
        HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("falgSettingDomain", JsonUtil.buildNormalBinder().toJson((Object)ddFalgSettingDomain));
            }
        };
        internalRouter.inInvoke("dd.falgSetting.updateFalgSetting", (Map)ddflagMap);
    }

    private LocalDateTime getLocalDateTime(String datetimeStr) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return LocalDateTime.parse(datetimeStr, df);
    }

    private void saveDdFlag(InternalRouter internalRouter, String tenantCode, String flagSettingCode, String flagSettingPro, String localTime, String businessFlag) {
        final DdFalgSettingDomain ddFalgSettingDomain = new DdFalgSettingDomain();
        ddFalgSettingDomain.setTenantCode(tenantCode);
        ddFalgSettingDomain.setFlagSettingInfo(localTime);
        ddFalgSettingDomain.setFlagSettingCode(flagSettingCode);
        ddFalgSettingDomain.setFlagSettingScope(flagSettingCode);
        ddFalgSettingDomain.setFlagSettingPro(flagSettingPro);
        if (StringUtils.isNotBlank((String)businessFlag)) {
            ddFalgSettingDomain.setFlagSettingPro1(businessFlag);
        }
        HashMap<String, Object> saveDdFlagParamMap = new HashMap<String, Object>(){
            {
                this.put("falgSettingDomain", JsonUtil.buildNormalBinder().toJson((Object)ddFalgSettingDomain));
            }
        };
        logger.error(this.SYS_CODE + ".saveDdFlag.saveDdFlagParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)saveDdFlagParamMap));
        logger.error(this.SYS_CODE + ".saveDdFlag", (Object)"\u4fdd\u5b58resourceGoodsUpdateBeginTime ddFlag\u5f00\u59cb");
        internalRouter.inInvoke("dd.falgSetting.saveFalgSetting", (Map)saveDdFlagParamMap);
        logger.error(this.SYS_CODE + ".saveDdFlag", (Object)"\u4fdd\u5b58resourceGoodsUpdateBeginTime ddFlag\u7ed3\u675f");
    }

    private String getStringlocalDateTime() {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime time = LocalDateTime.now();
        return df.format(time);
    }

    private List<DisDgoodsScopelist> queryDgoodsScopelistPageBySkuEocode(final String tenantCode, InternalRouter internalRouter, final String skuEoCode) {
        final HashMap<String, Object> disMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", tenantCode);
                this.put("dgoodsScopelistValuename", skuEoCode);
                this.put("fuzzy", true);
            }
        };
        HashMap<String, Object> disGoodsScopelistParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)disMap));
            }
        };
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuEocode.disGoodsParamMap", (Object)"\u67e5\u8be2disGoods\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuEocode.disGoodsParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)disGoodsScopelistParamMap));
        String disGoodsListStr = (String)internalRouter.inInvoke("dis.dgoods.queryDgoodsScopelistPage", (Map)disGoodsScopelistParamMap);
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuEocode", (Object)"\u67e5\u8be2disGoodsScopelist\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(disGoodsListStr, SupQueryResult.class);
        if (null == supQueryResult) {
            return null;
        }
        List disDgoodsScopelist = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DisDgoodsScopelist.class);
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuEocode.DisDgoodsScopelist", (Object)JsonUtil.buildNormalBinder().toJson((Object)disDgoodsScopelist));
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuEocode.DisDgoodsScopelist", (Object)"\u67e5\u8be2disGoodsdisDgoodsScopelist\u7ed3\u675f");
        if (null == disDgoodsScopelist || ListUtil.isEmpty((Collection)disDgoodsScopelist)) {
            return null;
        }
        return disDgoodsScopelist;
    }

    private List<DisDgoodsScopelist> queryDgoodsScopelistPageBySkuEocodeAndChannelName(final String tenantCode, InternalRouter internalRouter, final String skuEoCode, final String channelName) {
        final HashMap<String, Object> disMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", tenantCode);
                this.put("channelName", channelName);
                this.put("dgoodsScopelistValuename", skuEoCode);
                this.put("fuzzy", true);
            }
        };
        HashMap<String, Object> disGoodsScopelistParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)disMap));
            }
        };
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuShowNoAndChannelName.disGoodsParamMap", (Object)"\u67e5\u8be2disGoods\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuShowNoAndChannelName.disGoodsParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)disGoodsScopelistParamMap));
        String disGoodsListStr = (String)internalRouter.inInvoke("dis.dgoods.queryDgoodsScopelistPage", (Map)disGoodsScopelistParamMap);
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuShowNoAndChannelName", (Object)"\u67e5\u8be2disGoodsScopelist\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(disGoodsListStr, SupQueryResult.class);
        if (null == supQueryResult) {
            return null;
        }
        List disDgoodsScopelist = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DisDgoodsScopelist.class);
        logger.error(this.SYS_CODE + ".queryDisGoodsPage.DisDgoodsScopelist", (Object)JsonUtil.buildNormalBinder().toJson((Object)disDgoodsScopelist));
        logger.error(this.SYS_CODE + ".queryDisGoodsPage.DisDgoodsScopelist", (Object)"\u67e5\u8be2disGoodsdisDgoodsScopelist\u7ed3\u675f");
        if (null == disDgoodsScopelist || ListUtil.isEmpty((Collection)disDgoodsScopelist)) {
            return null;
        }
        return disDgoodsScopelist;
    }

    private List<DisDgoods> queryDisGoodsPage(final String tenantCode, final String channelNames) {
        final HashMap<String, Object> disMap = new HashMap<String, Object>(){
            {
                this.put("channelName", channelNames);
                this.put("tenantCode", tenantCode);
            }
        };
        HashMap<String, Object> disGoodsParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)disMap));
            }
        };
        String disGoodsListStr = this.internalInvoke("dis.dgoods.queryDgoodsPage", disGoodsParamMap);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(disGoodsListStr, SupQueryResult.class);
        List disGoodsList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DisDgoods.class);
        return disGoodsList;
    }

    private DdFalgSetting queryDdFlagSetting(final String tenantCode, InternalRouter internalRouter, final String flagSettingCode) {
        final HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("flagSettingCode", flagSettingCode);
                this.put("tenantCode", tenantCode);
            }
        };
        HashMap<String, Object> ddflagParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)ddflagMap));
            }
        };
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.ddflagParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)ddflagParamMap));
        String flagSettingListStr = (String)internalRouter.inInvoke("dd.falgSetting.queryFalgSettingPage", (Map)ddflagParamMap);
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFla\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(flagSettingListStr, SupQueryResult.class);
        List flagSettingList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DdFalgSetting.class);
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.flagSettingList", (Object)JsonUtil.buildNormalBinder().toJson((Object)flagSettingList));
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u7ed3\u675f");
        if (flagSettingList == null) {
            return null;
        }
        return (DdFalgSetting)flagSettingList.get(0);
    }

    public String checkGoodsParam(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null == rsResourceGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getGoodsName())) {
            return "\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getGoodsNo())) {
            return "\u5546\u54c1\u8d27\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getTenantCode())) {
            return "\u79df\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return "";
    }

    private void makeSkuDomain(RsResourceGoodsDomain rsResourceGoodsDomain, RsSkuDomain rsSkuDomain) {
        if (null == rsResourceGoodsDomain || null == rsSkuDomain) {
            logger.debug(this.SYS_CODE + ".makeSkuDomain", (Object)"isnull");
            return;
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)rsResourceGoodsDomain);
        }
        catch (Exception e) {
            logger.debug(this.SYS_CODE + ".makeSkuDomain", (Throwable)e);
            return;
        }
        rsSkuDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
        rsSkuDomain.setGoodsNum(new BigDecimal("999"));
        rsSkuDomain.setGoodsSupplynum(new BigDecimal("999"));
        rsSkuDomain.setGoodsNo(rsResourceGoodsDomain.getGoodsNo());
        rsSkuDomain.setSkuNo(rsResourceGoodsDomain.getSkuNo());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveOrUpdateSkuList(RsResourceGoodsDomain rsResourceGoodsDomain, RsResourceGoodsReDomain goodsDomain, RsSkuDomain skuDomain) throws Exception {
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        HashMap<String, Object> skuMapStr = new HashMap<String, Object>();
        skuMapStr.put("skuNo", skuDomain.getSkuNo());
        skuMapStr.put("tenantCode", skuDomain.getTenantCode());
        skuMapStr.put("channelCode", "728296217517314110");
        RsSkuReDomain rsSkuReDomain = this.querySkuPage(skuMapStr);
        RsSkuDomain rsSkuDomainNew = new RsSkuDomain();
        if (null != rsSkuReDomain) {
            if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSpecValueDomainList())) {
                ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
                HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                paramsMap.put("specValueBillno", goodsDomain.getGoodsCode());
                paramsMap.put("tenantCode", goodsDomain.getTenantCode());
                for (RsSpecValueDomain rsSpecValueDomain : rsResourceGoodsDomain.getRsSpecValueDomainList()) {
                    paramsMap.put("specValueValue", rsSpecValueDomain.getSpecValueValue());
                    paramsMap.put("startRow", 0);
                    paramsMap.put("rows", 1);
                    QueryResult<RsSpecValueReDomain> rsSpecValueReDomainQueryResult = this.checkSpecValue(paramsMap);
                    if (null != rsSpecValueReDomainQueryResult && ListUtil.isNotEmpty((Collection)rsSpecValueReDomainQueryResult.getList())) continue;
                    rsSpecValueDomain.setSpecValueBillno(goodsDomain.getGoodsCode());
                    rsSpecValueDomain.setTenantCode(goodsDomain.getTenantCode());
                    rsSpecValueDomain.setSpuCode(goodsDomain.getSpuCode());
                    rsSpecValueDomainList.add(rsSpecValueDomain);
                }
                if (ListUtil.isNotEmpty(rsSpecValueDomainList)) {
                    this.saveSpecValueList(rsSpecValueDomainList);
                }
            }
            Integer oldDataState = rsSkuReDomain.getDataState();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, (Object)rsSkuReDomain);
                BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomainNew, (Object)rsSkuReDomain);
                BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomainNew, (Object)skuDomain);
                BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, (Object)skuDomain);
                editSkuDomain.setSkuEdit(false);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".saveOrUpdateSkuList3", (Throwable)e);
                throw new ApiException(this.SYS_CODE + ".saveOrUpdateSkuList3", (Throwable)e);
            }
            Integer dataOpbillstate = rsSkuDomainNew.getDataOpbillstate();
            try {
                if (null != dataOpbillstate && dataOpbillstate == 1 && null != oldDataState && oldDataState == 2) {
                    rsSkuDomainNew.setDataOpbillstate(0);
                    this.updateRsSkuDomainNew(rsSkuDomainNew);
                    this.sendUpdateShelveBatchSku(rsSkuReDomain);
                }
                if (null != dataOpbillstate && dataOpbillstate == 0 && null != oldDataState && oldDataState == 2) {
                    rsSkuDomainNew.setDataOpbillstate(1);
                    this.updateRsSkuDomainNew(rsSkuDomainNew);
                    this.sendUpdateSoldOutBatchSku(rsSkuReDomain);
                }
                if (null != dataOpbillstate && dataOpbillstate == 1 && null != oldDataState && oldDataState == 0) {
                    rsSkuDomainNew.setDataOpbillstate(0);
                    this.updateRsSkuDomainNew(rsSkuDomainNew);
                    this.sendUpdateShelveBatchSku(rsSkuReDomain);
                }
                if (null != dataOpbillstate && dataOpbillstate == 0 && null != oldDataState && oldDataState == 0) {
                    rsSkuDomainNew.setDataOpbillstate(1);
                    this.updateRsSkuDomainNew(rsSkuDomainNew);
                    this.sendUpdateSoldOutBatchSku(rsSkuReDomain);
                }
                if (!"1".equals(rsSkuDomainNew.getGoodsSale().toString())) return;
                this.sendUpdateSoldOutBatchSku(rsSkuReDomain);
                return;
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".saveOrUpdateSkuList3.update" + oldDataState, (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSkuReDomain));
                throw new ApiException(this.SYS_CODE + ".saveOrUpdateSkuList3.update", (Throwable)e);
            }
        }
        Integer dataOpbillstate = skuDomain.getDataOpbillstate();
        if (null != dataOpbillstate && dataOpbillstate == 1) {
            skuDomain.setDataOpbillstate(0);
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSpecValueDomainList())) {
            ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("specValueBillno", goodsDomain.getGoodsCode());
            paramsMap.put("tenantCode", goodsDomain.getTenantCode());
            for (RsSpecValueDomain rsSpecValueDomain : rsResourceGoodsDomain.getRsSpecValueDomainList()) {
                paramsMap.put("specValueValue", rsSpecValueDomain.getSpecValueValue());
                paramsMap.put("startRow", 0);
                paramsMap.put("rows", 1);
                QueryResult<RsSpecValueReDomain> rsSpecValueReDomainQueryResult = this.checkSpecValue(paramsMap);
                if (null != rsSpecValueReDomainQueryResult && ListUtil.isNotEmpty((Collection)rsSpecValueReDomainQueryResult.getList())) continue;
                rsSpecValueDomain.setSpecValueBillno(goodsDomain.getGoodsCode());
                rsSpecValueDomain.setTenantCode(goodsDomain.getTenantCode());
                rsSpecValueDomain.setSpuCode(goodsDomain.getSpuCode());
                rsSpecValueDomainList.add(rsSpecValueDomain);
            }
            if (ListUtil.isNotEmpty(rsSpecValueDomainList)) {
                this.saveSpecValueList(rsSpecValueDomainList);
            }
        }
        try {
            skuDomain.setGoodsCode(goodsDomain.getGoodsCode());
            skuDomain.setSpuCode(goodsDomain.getSpuCode());
            this.saveRsSkuDomain(skuDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".saveOrUpdateSkuList5\u3002updateEsResourceGoodsDomain" + JsonUtil.buildNormalBinder().toJson((Object)goodsDomain), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".saveOrUpdateSkuList5\u3002updateEsResourceGoodsDomain", (Throwable)e);
        }
        if (null == dataOpbillstate || dataOpbillstate != 1) return;
        HashMap<String, Object> skuMap1 = new HashMap<String, Object>();
        skuMap1.put("skuNo", skuDomain.getSkuNo());
        skuMap1.put("tenantCode", skuDomain.getTenantCode());
        RsSkuReDomain rsSkuReDomain1 = this.querySkuPage(skuMap1);
        if (null == rsSkuReDomain1) {
            logger.error(this.SYS_CODE + ".saveOrUpdateSkuList5.rsSkuReDomain", skuMap1);
            throw new ApiException(this.SYS_CODE + ".saveOrUpdateSkuList55.rsSkuReDomain");
        }
        if (null != rsSkuReDomain1 && rsSkuReDomain1.getDataOpbillstate() == 0) {
            try {
                this.sendUpdateShelveBatchSku(rsSkuReDomain1);
                return;
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".saveOrUpdateSkuList3.sendUpdateShelveBatchSku", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSkuReDomain));
                throw new ApiException(this.SYS_CODE + ".saveOrUpdateSkuList3.sendUpdateShelveBatchSku", (Throwable)e);
            }
        } else {
            logger.error(this.SYS_CODE + ".saveOrUpdateSkuList3.sendUpdateShelveBatchSku.dataOpbillstate.sku", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSkuReDomain));
        }
    }

    private QueryResult<RsSpecValueReDomain> checkSpecValue(Map<String, Object> paramsMap) {
        QueryResult<RsSpecValueReDomain> rsSpecValueReDomainQueryResult = this.querySpecValuePage(paramsMap);
        if (rsSpecValueReDomainQueryResult == null || ListUtil.isEmpty((Collection)rsSpecValueReDomainQueryResult.getList())) {
            return null;
        }
        return rsSpecValueReDomainQueryResult;
    }

    private void makeSpec(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null == rsResourceGoodsDomain) {
            return;
        }
        String tenantCode = rsResourceGoodsDomain.getTenantCode();
        HashMap<String, String> specGroupMap = new HashMap<String, String>();
        HashMap<String, String> specGroupMapStr = new HashMap<String, String>();
        specGroupMapStr.put("pntreeCode", rsResourceGoodsDomain.getPntreeCode());
        specGroupMapStr.put("tenantCode", tenantCode);
        specGroupMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(specGroupMapStr));
        RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
        QueryResult supQueryResult = this.sendReSupObject("rs.spec.querySpecGroupPage", specGroupMap, RsSpecGroupDomain.class);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            HashMap<String, String> mapStr = new HashMap<String, String>();
            RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
            rsSpecGroupDomain.setPntreeCode(rsResourceGoodsDomain.getPntreeCode());
            rsSpecGroupDomain.setSpecGroupName(rsResourceGoodsDomain.getPntreeName());
            rsSpecGroupDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
            rsSpecGroupDomain.setTenantCode(tenantCode);
            mapStr.put("rsSpecGroupDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecGroupDomain));
            String specGroupCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", mapStr);
            if (StringUtils.isBlank((String)specGroupCode)) {
                logger.error(this.SYS_CODE + ".makeSpec.checkGoods.saveSpecGroup", (Object)("\u89c4\u683c\u7ec4\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01rsSpecGroupDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecGroupDomain)));
                return;
            }
            this.makeRsSpecDomain(rsResourceGoodsDomain, specGroupCode);
        } else {
            RsSpecGroupDomain rsSpecGroup = (RsSpecGroupDomain)supQueryResult.getList().get(0);
            rsSpecValueDomain.setSpecGroupCode(rsSpecGroup.getSpecGroupCode());
            this.makeRsSpecDomain(rsResourceGoodsDomain, rsSpecGroup.getSpecGroupCode());
        }
    }

    public void checkrsSpecOption(RsResourceGoodsDomain rsResourceGoodsDomain, String specGroupCode, String specCode, String specOptionName, String tenantCode, String specName) {
        RsSpecOptionDomain rsSpecOptionDomain;
        RsSpecValueDomain rsSpecValue;
        ArrayList<RsSpecValueDomain> rsSpecValuenList;
        block10: {
            HashMap<String, String> map2 = new HashMap<String, String>();
            HashMap<String, String> specOpMap = new HashMap<String, String>();
            map2.put("specCode", specCode);
            map2.put("specOptionName", specOptionName.trim());
            map2.put("tenantCode", tenantCode);
            specOpMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map2));
            rsSpecValuenList = new ArrayList<RsSpecValueDomain>();
            rsSpecValue = new RsSpecValueDomain();
            List specOpList = this.getQueryResutl("rs.spec.querySpecOptionPage", specOpMap, RsSpecOption.class).getList();
            rsSpecOptionDomain = new RsSpecOptionDomain();
            if (ListUtil.isEmpty((Collection)specOpList)) {
                rsSpecOptionDomain.setSpecGroupCode(specGroupCode);
                rsSpecOptionDomain.setSpecCode(specCode);
                rsSpecOptionDomain.setSpecOptionName(specOptionName.trim());
                rsSpecOptionDomain.setTenantCode(tenantCode);
                rsSpecOptionDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("rsSpecOptionDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecOptionDomain));
                try {
                    String specOptionCode = this.internalInvoke("rs.spec.saveSpecOption", map);
                    if (StringUtils.isBlank((String)specOptionCode)) {
                        logger.error(this.SYS_CODE + ".checkrsSpecOption.specOptionCode", (Object)("specCode:" + specCode + ",\u8bf7\u6c42\u53c2\u6570rsSpecDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain)));
                        return;
                    }
                    break block10;
                }
                catch (Exception e) {
                    logger.error(this.SYS_CODE + ".checkrsSpecOption.\u65b0\u589e\u89c4\u683c\u5c5e\u6027\u503c\u5931\u8d25", (Object)(",\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain)), (Throwable)e);
                    return;
                }
            }
            try {
                BeanUtils.copyAllPropertys((Object)rsSpecOptionDomain, specOpList.get(0));
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".checkrsSpecOption.\u65b0\u589e\u89c4\u683c\u5c5e\u6027\u503c\u5931\u8d251", (Object)(",\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain)), (Throwable)e);
                return;
            }
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSpecValue, (Object)rsSpecOptionDomain);
            rsSpecValue.setSpecValueValue(specOptionName);
            rsSpecValue.setSpecName(specName);
            rsSpecValue.setSpecValueType("0");
            rsSpecValue.setTenantCode(tenantCode);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".checkrsSpecOption.\u65b0\u589e\u89c4\u683c\u5c5e\u6027\u503c\u5931\u8d252", (Object)(",\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain)), (Throwable)e);
            e.printStackTrace();
        }
        rsSpecValuenList.add(rsSpecValue);
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSpecValueDomainList())) {
            rsResourceGoodsDomain.getRsSpecValueDomainList().addAll(rsSpecValuenList);
        } else {
            rsResourceGoodsDomain.setRsSpecValueDomainList(rsSpecValuenList);
        }
    }

    public void makeRsSpecDomain(RsResourceGoodsDomain rsResourceGoodsDomain, String specGroupCode) {
        if (null == rsResourceGoodsDomain || StringUtils.isEmpty((String)specGroupCode)) {
            logger.error(this.SYS_CODE + ".makeRsSpecDomain", (Object)"isnull");
            return;
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSpecDomainList())) {
            for (RsSpecDomain rsSpecDomain : rsResourceGoodsDomain.getRsSpecDomainList()) {
                rsSpecDomain.setSpecGroupCode(specGroupCode);
                QueryResult<RsSpecDomain> rsSpecDomainQueryResult = this.querySpecPageSpecGroupCode(rsSpecDomain.getSpecGroupCode(), rsSpecDomain.getSpecName(), rsResourceGoodsDomain.getTenantCode());
                if (rsSpecDomainQueryResult == null || ListUtil.isEmpty((Collection)rsSpecDomainQueryResult.getList())) {
                    String specCode = this.saveRsSpec(rsSpecDomain.getSpecGroupCode(), rsSpecDomain.getSpecName(), rsResourceGoodsDomain.getTenantCode(), rsResourceGoodsDomain.getChannelCode());
                    if (StringUtils.isBlank((String)specCode)) {
                        logger.error(this.SYS_CODE + ".makeRsSpecDomain.checkGoods.saveSpec", (Object)("specCode:" + specCode + ",\u8bf7\u6c42\u53c2\u6570rsSpecDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecDomain)));
                        return;
                    }
                    if (!ListUtil.isNotEmpty(rsSpecDomain.getSpecOptionList())) continue;
                    for (RsSpecOptionDomain rsSpecOptionDomain : rsSpecDomain.getSpecOptionList()) {
                        if (null == rsSpecOptionDomain) continue;
                        this.checkrsSpecOption(rsResourceGoodsDomain, rsSpecDomain.getSpecGroupCode(), specCode, rsSpecOptionDomain.getSpecOptionName(), rsResourceGoodsDomain.getTenantCode(), rsSpecDomain.getSpecName());
                    }
                    continue;
                }
                rsSpecDomain.setSpecCode(((RsSpecDomain)rsSpecDomainQueryResult.getList().get(0)).getSpecCode());
                if (!ListUtil.isNotEmpty(rsSpecDomain.getSpecOptionList())) continue;
                for (RsSpecOptionDomain rsSpecOptionDomain : rsSpecDomain.getSpecOptionList()) {
                    if (null == rsSpecOptionDomain) continue;
                    this.checkrsSpecOption(rsResourceGoodsDomain, rsSpecDomain.getSpecGroupCode(), rsSpecDomain.getSpecCode(), rsSpecOptionDomain.getSpecOptionName(), rsResourceGoodsDomain.getTenantCode(), rsSpecDomain.getSpecName());
                }
            }
        }
    }

    private String checkPntree(RsResourceGoodsDomain rsResourceGoodsDomain, List<RsSkuDomain> rsSkuDomainList) {
        RsPntreeDomain rsPntreeDomain;
        HashMap<String, String> param = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeName())) {
            param.put("pntreeName", rsResourceGoodsDomain.getPntreeName());
        }
        param.put("pntreeEocode", rsResourceGoodsDomain.getPntreeCode());
        param.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        String pntreeCode = "";
        String pntreeName = rsResourceGoodsDomain.getPntreeName();
        QueryResult queryResult = this.sendReSupObject("rs.pntree.queryPntreePage", paramMap, RsPntreeDomain.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            rsPntreeDomain = new RsPntreeDomain();
            rsPntreeDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
            rsPntreeDomain.setPntreeEocode(rsResourceGoodsDomain.getPntreeCode());
            rsPntreeDomain.setPntreeName(rsResourceGoodsDomain.getPntreeName());
            rsPntreeDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
            pntreeCode = this.saveRsPntreeDomainU9(rsPntreeDomain);
        } else {
            rsPntreeDomain = (RsPntreeDomain)queryResult.getList().get(0);
            pntreeCode = rsPntreeDomain.getPntreeCode();
        }
        rsResourceGoodsDomain.setPntreeCode(pntreeCode);
        rsResourceGoodsDomain.setPntreeName(pntreeName);
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            rsSkuDomain.setPntreeCode(pntreeCode);
            rsSkuDomain.setPntreeName(pntreeName);
        }
        return pntreeCode;
    }

    private String checkBrand(RsResourceGoodsDomain rsResourceGoodsDomain) {
        RsBrandDomain rsBrandDomain = null;
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandCode())) {
            rsBrandDomain = this.getBrandByEocode(rsResourceGoodsDomain.getBrandCode(), rsResourceGoodsDomain.getTenantCode());
        }
        if (rsBrandDomain == null) {
            logger.error(this.SYS_CODE + ".checkBrand", (Object)("\u54c1\u724c\u672a\u7ef4\u62a4\u5168==" + rsResourceGoodsDomain.getBrandCode() + "---" + rsResourceGoodsDomain.getBrandName()));
            return "\u54c1\u724c\u672a\u7ef4\u62a4\u5168\uff01";
        }
        rsResourceGoodsDomain.setBrandCode(rsBrandDomain.getBrandCode());
        rsResourceGoodsDomain.setBrandName(rsBrandDomain.getBrandName());
        return "";
    }

    private String checkBrandU9(RsResourceGoodsDomain rsResourceGoodsDomain, List<RsSkuDomain> rsSkuDomainList) {
        RsBrandDomain rsBrandDomain = null;
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandCode())) {
            rsBrandDomain = this.getBrandByEocode(rsResourceGoodsDomain.getBrandCode(), rsResourceGoodsDomain.getTenantCode());
        }
        String brandCode = "";
        String brandName = rsResourceGoodsDomain.getBrandName();
        if (rsBrandDomain != null) {
            brandCode = rsBrandDomain.getBrandCode();
        } else {
            rsBrandDomain = new RsBrandDomain();
            rsBrandDomain.setBrandEocode(rsResourceGoodsDomain.getBrandCode());
            rsBrandDomain.setBrandName(rsResourceGoodsDomain.getBrandName());
            rsBrandDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
            rsBrandDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
            rsBrandDomain.setChannelName(rsResourceGoodsDomain.getChannelName());
            brandCode = this.saveRsBranU9(rsBrandDomain);
        }
        rsResourceGoodsDomain.setBrandCode(brandCode);
        rsResourceGoodsDomain.setBrandName(brandName);
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            rsSkuDomain.setBrandCode(brandCode);
            rsSkuDomain.setBrandName(brandName);
        }
        return brandCode;
    }

    private String checkClassTree(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode())) {
            map.put("classtreeCode", rsResourceGoodsDomain.getClasstreeCode());
        }
        map.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        QueryResult<RsClasstreeDomain> queryResult = this.queryRsClasstreePage(map);
        String classTreeCode = "";
        if (queryResult == null || !ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            logger.error(this.SYS_CODE + ".checkClassTree", (Object)("\u540e\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168==" + rsResourceGoodsDomain.getClasstreeCode() + "---" + rsResourceGoodsDomain.getClasstreeName()));
            return "\u540e\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168\uff01";
        }
        rsResourceGoodsDomain.setClasstreeCode(((RsClasstreeDomain)queryResult.getList().get(0)).getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(((RsClasstreeDomain)queryResult.getList().get(0)).getClasstreeName());
        return "";
    }

    private String checkRsClassTree(RsResourceGoodsDomain rsResourceGoodsDomain, List<RsSkuDomain> rsSkuDomainList) {
        HashMap<String, String> classtreeMap = new HashMap<String, String>();
        String oneClassTreeCode = this.checkAndAddClassTreeCode(rsResourceGoodsDomain, "-1", "1", "1", null);
        if (oneClassTreeCode.contains("\u5206\u7c7b")) {
            logger.error(this.SYS_CODE + ".checkRsClassTree.oneClassTreeCode", (Object)("\u65b0\u589e\u4e00\u7ea7\u540e\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getClassificationName1()));
            return "\u65b0\u589e\u4e00\u7ea7\u540e\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getClassificationName1();
        }
        classtreeMap.put("oneClassTreeCode", oneClassTreeCode);
        String twoClassTreeCode = this.checkAndAddClassTreeCode(rsResourceGoodsDomain, oneClassTreeCode, "1", "2", null);
        if (twoClassTreeCode.contains("\u5206\u7c7b")) {
            logger.error(this.SYS_CODE + ".checkRsClassTree.twoClassTreeCode", (Object)("\u65b0\u589e\u4e8c\u7ea7\u540e\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getClassificationName2()));
            return "\u65b0\u589e\u4e8c\u7ea7\u540e\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getClassificationName2();
        }
        classtreeMap.put("twoClassTreeCode", twoClassTreeCode);
        String classTreeCode = this.checkAndAddClassTreeCode(rsResourceGoodsDomain, twoClassTreeCode, "0", "3", rsSkuDomainList);
        if (classTreeCode.contains("\u5206\u7c7b")) {
            logger.error(this.SYS_CODE + ".checkRsClassTree.classTreeCode", (Object)("\u65b0\u589e\u4e09\u7ea7\u7ea7\u540e\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getClasstreeCode()));
            return "\u65b0\u589e\u4e09\u7ea7\u7ea7\u540e\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getClasstreeCode();
        }
        classtreeMap.put("classTreeCode", classTreeCode);
        return JsonUtil.buildNonNullBinder().toJson(classtreeMap);
    }

    private String checkAndAddClassTreeCode(RsResourceGoodsDomain rsResourceGoodsDomain, String classTreeParentCode, String classTreeLast, String level, List<RsSkuDomain> rsSkuDomainList) {
        RsClasstreeDomain classtreeDomain;
        RsClasstreeDomain rsClasstreeDomain = this.buildClassTreee(rsResourceGoodsDomain, classTreeParentCode, classTreeLast, "0", level);
        String msg = GoodsParamCheckUtils.checkClasstreeParam(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExClass.msg");
            return "\u540e\u53f0\u5206\u7c7b\u6821\u9a8c\u51fa\u9519";
        }
        if (!"-1".equals(rsClasstreeDomain.getClasstreeParentcode()) && (classtreeDomain = this.getRsClasstreeByCode(rsClasstreeDomain.getClasstreeParentcode(), rsClasstreeDomain.getTenantCode(), rsResourceGoodsDomain.getChannelCode(), "0")) == null) {
            return "\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\uff01";
        }
        String code = "";
        RsClasstreeDomain classtreeDomain2 = this.getRsClasstreeByCode(rsClasstreeDomain.getClasstreeEocode(), rsClasstreeDomain.getTenantCode(), rsResourceGoodsDomain.getChannelCode(), "0");
        code = classtreeDomain2 == null ? this.saveRsClasstree(rsClasstreeDomain) : classtreeDomain2.getClasstreeCode();
        return code;
    }

    private RsClasstreeDomain buildClassTreeeForPriceCategory(RsResourceGoodsDomain rsResourceGoodsDomain, String classtreeParentcode, String classtreeLast, String classtreeType) {
        RsClasstreeDomain rsClasstreeDomain = new RsClasstreeDomain();
        rsClasstreeDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
        rsClasstreeDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
        rsClasstreeDomain.setClasstreeParentcode(classtreeParentcode);
        rsClasstreeDomain.setClasstreeLast(classtreeLast);
        rsClasstreeDomain.setClasstreeType(classtreeType);
        rsClasstreeDomain.setClasstreeName(rsResourceGoodsDomain.getClasstreeShopname());
        rsClasstreeDomain.setClasstreeEocode(rsResourceGoodsDomain.getClasstreeCode());
        rsClasstreeDomain.setClasstreeCode(rsResourceGoodsDomain.getClasstreeShopcode());
        return rsClasstreeDomain;
    }

    private RsClasstreeDomain buildClassTreee(RsResourceGoodsDomain rsResourceGoodsDomain, String classtreeParentcode, String classtreeLast, String classtreeType, String level) {
        RsClasstreeDomain rsClasstreeDomain = new RsClasstreeDomain();
        rsClasstreeDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
        rsClasstreeDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
        rsClasstreeDomain.setClasstreeParentcode(classtreeParentcode);
        rsClasstreeDomain.setClasstreeLast(classtreeLast);
        rsClasstreeDomain.setClasstreeType(classtreeType);
        if ("1".equals(level)) {
            rsClasstreeDomain.setClasstreeName(rsResourceGoodsDomain.getClassificationName1());
            rsClasstreeDomain.setClasstreeEocode(rsResourceGoodsDomain.getClassificationCode1());
        } else if ("2".equals(level)) {
            rsClasstreeDomain.setClasstreeName(rsResourceGoodsDomain.getClassificationName2());
            rsClasstreeDomain.setClasstreeEocode(rsResourceGoodsDomain.getClassificationCode2());
        } else if ("3".equals(level)) {
            rsClasstreeDomain.setClasstreeEocode(rsResourceGoodsDomain.getClasstreeCode());
            rsClasstreeDomain.setClasstreeName(rsResourceGoodsDomain.getClasstreeName());
        }
        rsClasstreeDomain.setClasstreeCode(rsClasstreeDomain.getClasstreeEocode());
        rsClasstreeDomain.setMemberCode("20000210463648");
        return rsClasstreeDomain;
    }

    private RsResourceGoodsReDomain checkResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("goodsClass", rsResourceGoodsDomain.getGoodsClass());
        paramsMap.put("goodsEocode", rsResourceGoodsDomain.getGoodsEocode());
        paramsMap.put("channelCode", rsResourceGoodsDomain.getChannelCode());
        paramsMap.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        paramsMap.put("startRow", 0);
        paramsMap.put("rows", 1);
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsDomainQueryResult = this.queryRsResourceGoodsPage(paramsMap);
        if (rsResourceGoodsDomainQueryResult == null || ListUtil.isEmpty((Collection)rsResourceGoodsDomainQueryResult.getList())) {
            return null;
        }
        return (RsResourceGoodsReDomain)rsResourceGoodsDomainQueryResult.getList().get(0);
    }

    protected String saveNewEsResourceGoodsDomain(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null == rsResourceGoodsDomain) {
            logger.error(this.SYS_CODE + ".saveNewEsResourceGoodsDomain.rsResourceGoodsDomain");
            return null;
        }
        HashMap<String, String> goodsparamMap = new HashMap<String, String>();
        ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
        goodsList.add(rsResourceGoodsDomain);
        goodsparamMap.put("goodsList", JsonUtil.buildNormalBinder().toJson(goodsList));
        return this.internalInvoke(RESOURCEGOODS_ADD_CODE, goodsparamMap);
    }

    public static void main(String[] args) {
    }

    public UmUserinfoDomainBean getPlatCode(String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoQuality", "plat");
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl("um.user.queryUserinfoPage", invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            logger.error(this.SYS_CODE + ".getPlatCode", (Object)((Object)invokeMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }
}

