/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.inv.AccessTokenResponse;
import com.yqbsoft.laser.service.ext.bus.data.domain.inv.Content;
import com.yqbsoft.laser.service.ext.bus.data.domain.inv.InvInvlist;
import com.yqbsoft.laser.service.ext.bus.data.domain.inv.InvInvlistGoods;
import com.yqbsoft.laser.service.ext.bus.data.domain.inv.InvUserinv;
import com.yqbsoft.laser.service.ext.bus.data.domain.inv.InvoiceDetail;
import com.yqbsoft.laser.service.ext.bus.data.domain.inv.Order;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.inv.EsbInvoiceRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.inv.EsbInvoiceResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusInvoiceService;
import com.yqbsoft.laser.service.ext.bus.data.service.impl.BusUserServiceImpl;
import com.yqbsoft.laser.service.ext.bus.data.supbase.InvoiceBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.OkhttpsUtils;
import com.yqbsoft.laser.service.ext.bus.data.util.SignHelper;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

public class BusInvoiceServiceImpl
extends InvoiceBaseService
implements BusInvoiceService {
    private String SYS_CODE = "busdata.BusEsbServiceImpl";
    private static final String NuonuoTaxnum = "NuonuoTaxnum";
    private static final String NuonuoAppKey = "NuonuoAppKey";
    private static final String NuonuoAppSecret = "NuonuoAppSecret";
    private static final String EsbKey = "EsbKey";
    private static final String EsbSecret = "EsbSecret";
    private static final String NuonuoUrl = "NuonuoUrl";
    private static final String NuonuoClerk = "NuonuoClerk";
    private static final String NuonuoSalerTel = "NuonuoSalerTel";
    private static final String NuonuoSalerAddress = "NuonuoSalerAddress";
    private static final String NuonuoTaxRate = "NuonuoTaxRate";
    private static final String NuonuoPushMode = "NuonuoPushMode";
    private static final String NuonuoExtensionNumber = "NuonuoExtensionNumber";
    private static final String NuonuoInvoiceLine = "NuonuoInvoiceLine";
    private static final String strDateFormat = "yyyy-MM-dd HH:mm:ss";
    private static final SupperLogUtil logger = new SupperLogUtil(BusInvoiceServiceImpl.class);
    @Autowired
    Esbfacade esbfacade;
    @Autowired
    OkhttpsUtils okhttpsUtils;

    @Override
    public String sendInvoice(InvInvlist invInvlist) {
        logger.error(this.SYS_CODE + ".sendInvoice.invInvlist", (Object)JsonUtil.buildNormalBinder().toJson((Object)invInvlist));
        if (null == invInvlist) {
            logger.error(this.SYS_CODE + ".sendInvoice.invInvlist.null");
            return null;
        }
        List<InvInvlistGoods> invInvlistGoodsList = this.queryInvlistGoodsPage(invInvlist.getTenantCode(), invInvlist.getInvlistCode());
        if (ListUtil.isEmpty(invInvlistGoodsList)) {
            logger.error(this.SYS_CODE + ".sendInvoice.invInvlistGoodsList.null", (Object)(invInvlist.getTenantCode() + "=======" + invInvlist.getInvlistCode()));
            return null;
        }
        logger.error(this.SYS_CODE + ".sendInvoice.invInvlistGoodsList", (Object)JsonUtil.buildNormalBinder().toJson(invInvlistGoodsList));
        String taxnum = BusInvoiceServiceImpl.getDdFlag(invInvlist.getTenantCode(), NuonuoTaxnum, NuonuoTaxnum);
        String appKey = BusInvoiceServiceImpl.getDdFlag(invInvlist.getTenantCode(), NuonuoAppKey, NuonuoAppKey);
        String appSecret = BusInvoiceServiceImpl.getDdFlag(invInvlist.getTenantCode(), NuonuoAppSecret, NuonuoAppSecret);
        String esbKey = BusInvoiceServiceImpl.getDdFlag(invInvlist.getTenantCode(), EsbKey, EsbKey);
        String esbSecret = BusInvoiceServiceImpl.getDdFlag(invInvlist.getTenantCode(), EsbSecret, EsbSecret);
        String url = BusInvoiceServiceImpl.getDdFlag(invInvlist.getTenantCode(), NuonuoUrl, NuonuoUrl);
        String clerk = BusInvoiceServiceImpl.getDdFlag(invInvlist.getTenantCode(), NuonuoClerk, NuonuoClerk);
        String salerTel = BusInvoiceServiceImpl.getDdFlag(invInvlist.getTenantCode(), NuonuoSalerTel, NuonuoSalerTel);
        String salerAddress = BusInvoiceServiceImpl.getDdFlag(invInvlist.getTenantCode(), NuonuoSalerAddress, NuonuoSalerAddress);
        String taxRate = BusInvoiceServiceImpl.getDdFlag(invInvlist.getTenantCode(), NuonuoTaxRate, NuonuoTaxRate);
        String pushMode = BusInvoiceServiceImpl.getDdFlag(invInvlist.getTenantCode(), NuonuoPushMode, NuonuoPushMode);
        String extensionNumber = BusInvoiceServiceImpl.getDdFlag(invInvlist.getTenantCode(), NuonuoExtensionNumber, NuonuoExtensionNumber);
        String invoiceLine = BusInvoiceServiceImpl.getDdFlag(invInvlist.getTenantCode(), NuonuoInvoiceLine, NuonuoInvoiceLine);
        BigDecimal add = new BigDecimal(1).add(new BigDecimal(taxRate));
        InvUserinv invUserinv = this.getUserinvByCode(invInvlist.getTenantCode(), invInvlist.getUserinvCode());
        logger.error(this.SYS_CODE + ".sendInvoice.invUserinv", (Object)JsonUtil.buildNormalBinder().toJson((Object)invUserinv));
        Content content = new Content();
        Order order = new Order();
        if (StringUtils.isNotBlank((String)extensionNumber)) {
            order.setExtensionNumber(extensionNumber);
        }
        order.setBuyerName(invUserinv.getUserinvMember());
        order.setBuyerTaxNum(invUserinv.getUserinvNo());
        if (StringUtils.isNotBlank((String)invUserinv.getUserinvBankname()) && StringUtils.isNotBlank((String)invUserinv.getUserinvBankno())) {
            order.setBuyerAccount(invUserinv.getUserinvBankname() + invUserinv.getUserinvBankno());
        }
        String buyerAddress = "";
        if (StringUtils.isNotBlank((String)invUserinv.getProvinceName())) {
            buyerAddress = buyerAddress + invUserinv.getProvinceName();
        }
        if (StringUtils.isNotBlank((String)invUserinv.getCityName())) {
            buyerAddress = buyerAddress + invUserinv.getCityName();
        }
        if (StringUtils.isNotBlank((String)invUserinv.getAreaName())) {
            buyerAddress = buyerAddress + invUserinv.getAreaName();
        }
        if (StringUtils.isNotBlank((String)invUserinv.getRoadName())) {
            buyerAddress = buyerAddress + invUserinv.getRoadName();
        }
        if (StringUtils.isNotBlank((String)invUserinv.getUserinvUadd())) {
            buyerAddress = buyerAddress + invUserinv.getUserinvUadd();
        }
        order.setBuyerAddress(buyerAddress);
        order.setBuyerTel(invUserinv.getUserinvPhone());
        order.setSalerTaxNum(taxnum);
        order.setSalerTel(salerTel);
        order.setSalerAddress(salerAddress);
        order.setOrderNo(invInvlist.getInvlistOpcode());
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(strDateFormat);
        order.setInvoiceDate(sdf.format(date));
        order.setClerk(clerk);
        order.setBuyerPhone(invUserinv.getUserinvUphone());
        order.setEmail(invUserinv.getUserinvUeamil());
        order.setInvoiceType("1");
        order.setTerminalNumber("");
        if (StringUtils.isNotBlank((String)pushMode) && (pushMode.equals("1") || pushMode.equals("2")) && StringUtils.isNotBlank((String)order.getBuyerPhone())) {
            order.setPushMode(pushMode);
        }
        if (StringUtils.isNotBlank((String)pushMode) && (pushMode.equals("0") || pushMode.equals("2")) && StringUtils.isNotBlank((String)order.getEmail())) {
            order.setPushMode(pushMode);
        }
        ArrayList<InvoiceDetail> invoiceDetail = new ArrayList<InvoiceDetail>();
        for (InvInvlistGoods invInvlistGoods : invInvlistGoodsList) {
            InvoiceDetail invoiceDetail1 = new InvoiceDetail();
            invoiceDetail1.setGoodsName(invInvlistGoods.getGoodsName());
            BigDecimal taxExcludedAmount = invInvlistGoods.getContractGoodsMoney();
            invoiceDetail1.setPrice(String.valueOf(taxExcludedAmount.divide(invInvlistGoods.getGoodsNum(), 2, 4)));
            invoiceDetail1.setNum(String.valueOf(invInvlistGoods.getGoodsNum()));
            invoiceDetail1.setTaxRate(taxRate);
            invoiceDetail1.setWithTaxFlag("1");
            invoiceDetail.add(invoiceDetail1);
        }
        OcContractReDomain orderByCode = this.getOrderByCode(invInvlist.getInvlistOpcode(), invInvlist.getTenantCode());
        if (null != orderByCode && null != orderByCode.getGoodsLogmoney() && orderByCode.getGoodsLogmoney().compareTo(BigDecimal.ZERO) > 0) {
            InvoiceDetail invoiceDetail1 = new InvoiceDetail();
            invoiceDetail1.setGoodsName("\u4ef7\u5916\u8d39\u7528");
            BigDecimal taxExcludedAmount = orderByCode.getGoodsLogmoney();
            invoiceDetail1.setPrice(String.valueOf(taxExcludedAmount));
            invoiceDetail1.setNum("1");
            invoiceDetail1.setTaxRate(taxRate);
            invoiceDetail1.setWithTaxFlag("1");
            invoiceDetail.add(invoiceDetail1);
        }
        order.setInvoiceDetail(invoiceDetail);
        content.setOrder(order);
        String contentJson = JsonUtil.buildNormalBinder().toJson((Object)content);
        logger.error(this.SYS_CODE + ".sendInvoice.content:", (Object)contentJson);
        EsbInvoiceRequest ocInvoiceRequest = new EsbInvoiceRequest();
        ocInvoiceRequest.setAppKey(appKey);
        ocInvoiceRequest.setClientsecret(esbSecret);
        ocInvoiceRequest.setClientid(esbKey);
        ocInvoiceRequest.setHost(url);
        ocInvoiceRequest.setAppSecret(appSecret);
        ocInvoiceRequest.setTaxnum(taxnum);
        ocInvoiceRequest.setContentJson(contentJson);
        EsbInvoiceResponse ocContractResponse = this.esbfacade.execute(ocInvoiceRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.ocContractResponse");
            return "error";
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendInvoice.ocContractResponse", (Object)ocContractResponse.getMsg());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("invlistDatastr", ocContractResponse.getDataObj());
            this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), 4, 0, map);
            return ocContractResponse.getMsg();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invlistDatastr", ocContractResponse.getDataObj());
        this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), 1, 0, map);
        return "success";
    }

    @Override
    public String sendInvoiceToU9(InvInvlist invInvlist) throws ApiException {
        QueryResult supQueryResult;
        if (ObjectUtils.isEmpty((Object)invInvlist)) {
            throw new ApiException("invInvlist\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)invInvlist.getUserinvType())) {
            throw new ApiException("userinvType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.info(this.SYS_CODE + ".sendInvoiceToU9", (Object)JsonUtil.buildNormalBinder().toJson((Object)invInvlist));
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        String url = BusInvoiceServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9Domain", "AkanU9Domain") + "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
        dataMap.put("cust", "AKan");
        dataMap.put("aPIType", "SaleInvoice_Crate");
        ArrayList paramList = new ArrayList();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("IMSKey", invInvlist.getInvlistCode());
        if ("1".equals(invInvlist.getUserinvType()) || "3".equals(invInvlist.getUserinvType())) {
            param.put("Type", "1");
        } else if ("2".equals(invInvlist.getUserinvType()) || "4".equals(invInvlist.getUserinvType())) {
            param.put("Type", "0");
        } else {
            throw new ApiException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u53d1\u7968\u7c7b\u578b");
        }
        param.put("BusinessDate", new SimpleDateFormat("yyyy-MM-dd").format(invInvlist.getGmtCreate()));
        param.put("AccountCode", invInvlist.getInvlistBankno());
        param.put("RecBkAccount", invInvlist.getInvlistOcode1());
        param.put("IsRedInvoice", "0");
        if ("SgSendgoods".equals(invInvlist.getInvlistOptype())) {
            final HashMap<String, String> querypmap = new HashMap<String, String>();
            querypmap.put("tenantCode", ComConstants.tenantCode);
            querypmap.put("sendgoodsCode", invInvlist.getInvlistOpcode());
            String sendgoods = "sg.sendgoods.querySgSendgoodsPageReDomain";
            HashMap<String, Object> map = new HashMap<String, Object>(){
                {
                    this.put("map", JsonUtil.buildNormalBinder().toJson((Object)querypmap));
                }
            };
            supQueryResult = this.getQueryResutl(sendgoods, map, SgSendgoodsReDomain.class);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                logger.error(this.SYS_CODE + ".deliveryNum.querypmap", (Object)(JsonUtil.buildNormalBinder().toJson(querypmap) + ": \u67e5\u8be2\u5931\u8d25"));
                throw new ApiException("\u6839\u636e" + invInvlist.getInvlistOpcode() + "\u83b7\u53d6\u4e0d\u5230\u53d1\u8d27\u5355");
            }
        } else {
            throw new ApiException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6765\u6e90\u5355\u636e\u7c7b\u578b");
        }
        SgSendgoodsReDomain sgSendgoodsReDomain = (SgSendgoodsReDomain)supQueryResult.getList().get(0);
        Map<String, String> context = BusUserServiceImpl.getAdminContextMap(sgSendgoodsReDomain.getMemberGcode().substring(0, 3), BusInvoiceServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9EntCode", "AkanU9EntCode"));
        dataMap.put("context", context);
        param.put("SrcDocNo", sgSendgoodsReDomain.getContractNbillcode());
        param.put("SrcType", "1");
        ArrayList subLineDTOS = new ArrayList();
        List<InvInvlistGoods> invInvlistGoodsList = this.queryInvlistGoodsPage(invInvlist.getTenantCode(), invInvlist.getInvlistCode());
        if (ListUtil.isEmpty(invInvlistGoodsList)) {
            logger.error(this.SYS_CODE + ".sendInvoiceToU9.invInvlistGoodsList.null", (Object)(invInvlist.getTenantCode() + "=======" + invInvlist.getInvlistCode()));
            throw new ApiException(this.SYS_CODE + ".sendInvoiceToU9.invInvlistGoodsList.null");
        }
        for (InvInvlistGoods invInvlistGoods : invInvlistGoodsList) {
            HashMap<String, Object> subLine = new HashMap<String, Object>();
            subLine.put("IMSLineKey", invInvlistGoods.getInvlistGoodsCode());
            subLine.put("SrcLineNo", invInvlistGoods.getGoodsSpec5());
            subLine.put("Money", invInvlistGoods.getContractGoodsMoney());
            subLine.put("Qty", invInvlistGoods.getGoodsCamount());
            subLineDTOS.add(subLine);
        }
        param.put("SubLineDTOS", subLineDTOS);
        paramList.add(param);
        dataMap.put("paramList", paramList);
        System.out.println(dataMap);
        Map<String, String> header = BusInvoiceServiceImpl.getStringStringMap(invInvlist.getTenantCode());
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(dataMap), header, "busdata.busInvoice.sendInvoiceToU9", invInvlist.getInvlistCode(), "\u53d1\u7968\u7533\u8bf7\u63a5\u53e3->u9");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendInvoiceToU9.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(header), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendInvoiceToU9.ex1", (Throwable)e);
        }
        Long startTime = System.currentTimeMillis();
        logger.error(this.SYS_CODE + ".sendInvoiceToU9.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(dataMap) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendInvoiceToU9.returnResultsMap" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendInvoiceToU9.ex2");
        }
        Object code = returnResultsMap.get("d");
        if (null != code) {
            String dStr = JsonUtil.buildNormalBinder().toJson(code);
            List list = JsonUtil.buildNormalBinder().getJsonToList(dStr, Map.class);
            Map returnResultsObjMap = (Map)list.get(0);
            String code1 = (String)returnResultsObjMap.get("Flag");
            if ("True".equals(code1)) {
                String message = (String)returnResultsObjMap.get("Message");
                return message;
            }
            logger.error(this.SYS_CODE + ".sendInvoiceToU9.code" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".sendInvoiceToU9.ex3");
        }
        logger.error(this.SYS_CODE + ".sendInvoiceToU9.code.1" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendInvoiceToU9.ex4");
    }

    private static Map<String, String> getStringStringMap(String tenantCode) {
        String hacckey;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("haccid", "256");
        header.put("hacckey", "97269a9502214c11bcf91b33a15c71c6");
        String haccid = BusInvoiceServiceImpl.getddFlag(tenantCode, "haccid", "haccid");
        if (StringUtils.isNotBlank((String)haccid)) {
            header.put("haccid", haccid);
        }
        if (StringUtils.isNotBlank((String)(hacckey = BusInvoiceServiceImpl.getddFlag(tenantCode, "hacckey", "hacckey")))) {
            header.put("hacckey", hacckey);
        }
        return header;
    }

    protected static String getddFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    @Override
    public String sendPromotionReviewToOa(InvInvlist invInvlist) throws ApiException {
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String accessInvoiceFromYongyou(String invoiceCode) throws ApiException {
        String accessToken = null;
        try {
            accessToken = this.getAccessTokenFromYongyou();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("slfphm", invoiceCode);
        params.put("taxpdf", "1");
        String requestUrl = BusInvoiceServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanYongyouDomain", "AkanYongyouDomain") + "/iuap-api-gateway" + "/yonbip/tax/output-tax/api/einvoice/getbsfile";
        HashMap<String, String> heads = new HashMap<String, String>();
        requestUrl = requestUrl + "?access_token=" + accessToken;
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(requestUrl, JsonUtil.buildNormalBinder().toJson(params), heads, "busdata.busInvoice.accessInvoiceFromYongyou", invoiceCode, "\u53d1\u7968\u83b7\u53d6->\u7a0e\u52a1\u4e91");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".accessInvoiceFromYongyou.isnull" + requestUrl, (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".accessInvoiceFromYongyou.data" + data + "url" + requestUrl);
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".accessInvoiceFromYongyou.returnResultsMap" + requestUrl, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            String code1 = (String)code;
            if ("200".equals(code1)) {
                String base64File;
                String dataJson = JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data"));
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(dataJson, String.class, Object.class);
                if (returnResultsMap1 == null || (base64File = (String)returnResultsMap1.get("taxpdf")) == null) return "";
                return base64File;
            }
            logger.error(this.SYS_CODE + ".accessInvoiceFromYongyou.code" + requestUrl, (Object)returnResultsMap.toString());
            return null;
        }
        logger.error(this.SYS_CODE + ".accessInvoiceFromYongyou.code.1" + requestUrl, (Object)returnResultsMap.toString());
        return null;
    }

    public String getAccessTokenFromYongyou() throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        String appsecret;
        if (SupDisUtil.get((String)"YY_accessToken") != null) {
            return SupDisUtil.get((String)"YY_accessToken");
        }
        String appKey = BusInvoiceServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanYongyouAppkey", "AkanYongyouAppkey");
        AccessTokenResponse response = this.requestForAccessTokenV2FromYongyou(appKey, appsecret = BusInvoiceServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanYongyouAppsecret", "AkanYongyouAppsecret"));
        if (response != null && response.getAccessToken() != null) {
            long expire = response.getExpire();
            SupDisUtil.set((String)"YY_accessToken", (String)response.getAccessToken(), (int)Math.toIntExact(expire));
        }
        logger.info("\u6210\u529f\u83b7\u5f97\u8bbf\u95ee\u4ee4\u724c: appkey: " + appKey + ", access_token: " + response.getAccessToken() + ", expire in: " + response.getExpire());
        return response.getAccessToken();
    }

    public AccessTokenResponse requestForAccessTokenV2FromYongyou(String appKey, String appSecret) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appKey", appKey);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        String signature = SignHelper.sign(params, appSecret);
        params.put("signature", signature);
        String requestUrl = BusInvoiceServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanYongyouDomain", "AkanYongyouDomain") + "/iuap-api-auth/open-auth" + "/selfAppAuth/getAccessToken";
        HashMap<String, String> heads = new HashMap<String, String>();
        String param = "";
        param = param + "appKey=" + (String)params.get("appKey") + "&timestamp=" + (String)params.get("timestamp") + "&signature=" + (String)params.get("signature");
        String data = null;
        try {
            data = OkhttpsUtils.doGet(requestUrl, param, heads);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".requestForAccessTokenV2FromYongyou.isnull" + requestUrl, (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".requestForAccessTokenV2FromYongyou.data" + data + "url" + requestUrl);
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".requestForAccessTokenV2FromYongyou.returnResultsMap" + requestUrl, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            String code1 = (String)code;
            if ("00000".equals(code1)) {
                String dataJson = JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data"));
                AccessTokenResponse accessTokenResponse = (AccessTokenResponse)JsonUtil.buildNonDefaultBinder().getJsonToObject(dataJson, AccessTokenResponse.class);
                System.out.println(accessTokenResponse);
                return accessTokenResponse;
            }
            logger.error(this.SYS_CODE + ".requestForAccessTokenV2FromYongyou.code" + requestUrl, (Object)returnResultsMap.toString());
            return null;
        }
        logger.error(this.SYS_CODE + ".requestForAccessTokenV2FromYongyou.code.1" + requestUrl, (Object)returnResultsMap.toString());
        return null;
    }
}

