/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.nbcb.sdk.OpenSDK;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.chengpu.CpEmployee;
import com.yqbsoft.laser.service.ext.bus.data.domain.chengpu.CpEmployeeRes;
import com.yqbsoft.laser.service.ext.bus.data.domain.chengpu.CpOrgRes;
import com.yqbsoft.laser.service.ext.bus.data.domain.chengpu.CpPositionRes;
import com.yqbsoft.laser.service.ext.bus.data.domain.cp.CpRechargeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.cp.CpRechargeFromU9Domain;
import com.yqbsoft.laser.service.ext.bus.data.domain.dd.DdFalgSetting;
import com.yqbsoft.laser.service.ext.bus.data.domain.dd.DdFalgSettingDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.log.LogErrorLog;
import com.yqbsoft.laser.service.ext.bus.data.domain.log.LogErrorLogDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.PteBalancelist;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.PteBalancelistOp;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.PteBalanceop;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.PteBalanceopGoods;
import com.yqbsoft.laser.service.ext.bus.data.domain.org.OrgEmployee;
import com.yqbsoft.laser.service.ext.bus.data.domain.org.OrgEmployeeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sms.ResultModel;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.Customer;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.EmployeeInfo;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUser;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserDomainBean;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfo;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoDomainBeanA;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoapply;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoapplyDomain;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.um.UmUserinfoRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.um.UmUserinfoResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusUserService;
import com.yqbsoft.laser.service.ext.bus.data.supbase.UserinfoBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.OkhttpsUtils;
import com.yqbsoft.laser.service.ext.bus.data.util.SqlServerUtils;
import com.yqbsoft.laser.service.ext.bus.data.util.UserInfo;
import com.yqbsoft.laser.service.ext.bus.data.util.WordToPdfAndBase64;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.AES;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.GZIPUtils;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.HttpClient;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.HttpRequest;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.HttpRequestBytes;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.HttpRequestParams;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.HttpResponseBytes;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.HttpResponseBytesPraser;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.HttpResultCode;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.HttpsRequestBytes;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.SmsResponse;
import com.yqbsoft.laser.service.ext.bus.data.ymsms.SmsSingleRequest;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class BusUserServiceImpl
extends UserinfoBaseService
implements BusUserService {
    private String SYS_CODE = "busdata.BusUserServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusUserServiceImpl.class);
    private String ddcode = "user";
    @Autowired
    RestTempfacade restTempfacade;
    @Autowired
    OkhttpsUtils okhttpsUtils;
    private static ThreadPoolExecutor userThreadPoolExecutor = new ThreadPoolExecutor(16, 32, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private static ThreadPoolExecutor userCompensateThreadPoolExecutor = new ThreadPoolExecutor(16, 32, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    @Override
    public String sendSaveBusUserinfo(UmUserinfoReDomain umUserinfo, UmUserReDomain umUser, String optype) {
        if (null == umUserinfo) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfo");
            return "error";
        }
        String tenantCode = umUserinfo.getTenantCode();
        String url = umUserinfo.getWebSiteUrl();
        if (StringUtils.isNotBlank((String)url)) {
            if (url.indexOf("http") != 0) {
                url = "http://" + url;
            }
            url = url + "/laserEr/http/post/{apiCode}/1.0/" + tenantCode + "/utf-8/shangshu";
            umUserinfo.setWebSiteUrl(url);
        }
        UmUserinfoRequest umUserinfoRequest = new UmUserinfoRequest();
        umUserinfoRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        umUserinfoRequest.setOrgTenantCode(umUserinfo.getTenantCode());
        String t = this.getTenantCodeBuUrl(umUserinfoRequest.getHost());
        if (StringUtils.isNotBlank((String)t)) {
            umUserinfo.setTenantCode(t);
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoRequest, (Object)umUserinfo);
            if (StringUtils.isBlank((String)t)) {
                umUserinfoRequest.setTenantCode(umUserinfoRequest.getToTenantCode());
            }
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.e", (Throwable)e);
            return "error";
        }
        UmUserinfoResponse umUserinfoResponse = this.restTempfacade.execute(umUserinfoRequest);
        if (null == umUserinfoResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse");
            return "error";
        }
        if (!umUserinfoResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse", (Object)umUserinfoResponse.getMsg());
            return umUserinfoResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusUserinfoSeal(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSeal.umUserinfo");
            return "error";
        }
        String url = BusUserServiceImpl.getDdFlag(umUserinfo.getTenantCode(), "UserinfoSeal", "UserinfoSeal");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("companyName", umUserinfo.getUserinfoCompname());
        map.put("generateMode", umUserinfo.getUserinfoCert1No());
        map.put("sealImage", umUserinfo.getUserinfoRemark());
        map.put("sealName", umUser.getUserName());
        map.put("sealType", umUserinfo.getUserinfoCert2No());
        map.put("userId", umUserinfo.getUserinfoOpcode1());
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
        map.put("sealAttribute", map1);
        map1.put("centralGraphic", "star");
        map1.put("centralGraphicSize", 60);
        map1.put("mainFont", umUserinfo.getUserinfoCompname());
        map1.put("mainFontSize", 22);
        map1.put("mainFontSpace", 22.0);
        map1.put("mainFontMargin", 4);
        map1.put("sealColor", "red");
        map1.put("sealSize", "300*300");
        map1.put("sealTemplate", BusUserServiceImpl.getMessage(umUserinfo.getUserinfoCert2No()));
        map1.put("titleFont", "\u5370\u7ae0\u6807\u9898");
        map1.put("titleFontSize", 16);
        map1.put("titleFontSpace", 8.0);
        map1.put("titleFontMargin", 54);
        map1.put("viceFont", "1BJ00000A01");
        map1.put("viceFontSize", 22);
        map1.put("viceFontSpace", 22.0);
        map1.put("viceFontMargin", 3);
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header, "busdata.exUser.sendSaveBusUserinfoSeal");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSeal.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSeal.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSeal.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Object sealId;
                HashMap<String, Object> mapStr = new HashMap<String, Object>();
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                if (MapUtil.isNotEmpty((Map)returnResultsMap1) && null != (sealId = returnResultsMap1.get("sealId"))) {
                    mapStr.put("userinfoOpcode2", sealId);
                }
                mapStr.put("userinfoCode", umUserinfo.getUserinfoCode());
                mapStr.put("userinfoCert2Url", "1");
                this.sendOpenUserinfo(mapStr);
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSeal.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSeal.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendQueryBusUserinfoSeal(String tenantCode, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSeal", (Object)tenantCode);
            throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfoSeal.ex");
        }
        String url = BusUserServiceImpl.getDdFlag(tenantCode, "UserinfoSeal", "UserinfoSeal");
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSeal.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (StringUtils.isBlank((String)url)) {
            throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfoSeal.ex");
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        Long startTime = System.currentTimeMillis();
        String data = "{\"total\":1,\"rows\":null,\"data\":[{\"sealId\":1676,\"userId\":2893,\"platformCode\":\"HBIS_TY\",\"sealType\":\"qyht\",\"generateMode\":\"autogeneration\",\"sealName\":\"18721632233\",\"companyName\":\"\u6587\u78ca\",\"bucketName\":\"qz-obs\",\"sealImageKey\":\"202411121207030312473262310\",\"sealImage\":\"https://qz-obs.obs.cn-north-4.myhuaweicloud.com:443/202411121207030312473262310\"}],\"code\":200,\"msg\":\"\u67e5\u8be2\u6210\u529f\"}";
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSeal.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSeal.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfoSeal.ex2");
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return returnResultsMap.get("data").toString();
            }
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSeal.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfoSeal.ex3");
        }
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSeal.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfoSeal.ex4");
    }

    @Override
    public String sendUpdateBusUserinfoSeal(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoSeal.umUserinfo");
            return "error";
        }
        String url = BusUserServiceImpl.getDdFlag(umUserinfo.getTenantCode(), "UserinfoSeal", "UserinfoSeal");
        logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoSeal.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("sealId", umUserinfo.getUserinfoOpcode1());
        map.put("companyName", umUserinfo.getUserinfoCompname());
        map.put("generateMode", umUserinfo.getUserinfoCert1No());
        map.put("sealImage", umUserinfo.getUserinfoRemark());
        map.put("sealName", umUser.getUserName());
        map.put("sealType", umUserinfo.getUserinfoCert2No());
        map.put("userId", umUserinfo.getUserinfoOpcode1());
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
        map.put("sealAttribute", map1);
        map1.put("centralGraphic", "star");
        map1.put("centralGraphicSize", 60);
        map1.put("mainFont", umUserinfo.getUserinfoCompname());
        map1.put("mainFontSize", 22);
        map1.put("mainFontSpace", 22.0);
        map1.put("mainFontMargin", 4);
        map1.put("sealColor", "red");
        map1.put("titleFont", "\u5370\u7ae0\u6807\u9898");
        map1.put("titleFontSize", 16);
        map1.put("titleFontSpace", 8.0);
        map1.put("titleFontMargin", 54);
        map1.put("viceFont", "1BJ00000A01");
        map1.put("viceFontSize", 22);
        map1.put("viceFontSpace", 22.0);
        map1.put("viceFontMargin", 3);
        String data = null;
        try {
            data = OkhttpsUtils.doPut(url, JsonUtil.buildNormalBinder().toJson(map), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoSeal.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoSeal.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoSeal.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoSeal.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoSeal.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendDeleteBusUserinfoSeal(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSeal.umUserinfo");
            return "error";
        }
        String url = BusUserServiceImpl.getDdFlag(umUserinfo.getTenantCode(), "UserinfoSeal", "UserinfoSeal");
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSeal.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("sealId", "");
        String param = "";
        param = param + "sealId=" + map.get("sealId");
        url = url + param;
        String data = null;
        try {
            data = OkhttpsUtils.doDelete(url, null, header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSeal.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSeal.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSeal.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Object sealId;
                HashMap<String, Object> mapStr = new HashMap<String, Object>();
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                if (MapUtil.isNotEmpty((Map)returnResultsMap1) && null != (sealId = returnResultsMap1.get("sealId"))) {
                    mapStr.put("userinfoOpcode2", sealId);
                }
                mapStr.put("userinfoCode", umUserinfo.getUserinfoCode());
                mapStr.put("userinfoCert2Url", "1");
                this.sendOpenUserinfo(mapStr);
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSeal.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSeal.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendSaveBusUserinfoTransactor(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.umUserinfo", (Object)(JsonUtil.buildNormalBinder().toJson((Object)umUserinfo) + "umUser" + JsonUtil.buildNormalBinder().toJson((Object)umUser)));
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.umUserinfo");
            return "error";
        }
        String url = BusUserServiceImpl.getDdFlag(umUserinfo.getTenantCode(), "Transactor", "Transactor");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("userId", umUserinfo.getUserinfoOpcode1());
        map.put("transactorName", umUser.getUserName());
        map.put("identTypeCode", umUser.getUserQq());
        map.put("identNo", umUser.getUserImgurl());
        map.put("email", umUser.getUserEmial());
        map.put("mobilePhone", umUser.getUserPhone());
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header, "busdata.exUser.sendSaveBusUserinfoTransactor");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Object transactorId;
                HashMap<String, Object> mapStr = new HashMap<String, Object>();
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                if (MapUtil.isNotEmpty((Map)returnResultsMap1) && null != (transactorId = returnResultsMap1.get("transactorId"))) {
                    umUser.setUserCacode(transactorId.toString());
                    mapStr.put("userCacode", transactorId);
                    mapStr.put("userCode", umUser.getUserCode());
                }
                this.sendOpenUser(mapStr);
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendDeleteBusUserinfoTransactor(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.umUserinfo", (Object)(JsonUtil.buildNormalBinder().toJson((Object)umUserinfo) + "umUser" + JsonUtil.buildNormalBinder().toJson((Object)umUser)));
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.umUserinfo");
            return "error";
        }
        String url = BusUserServiceImpl.getDdFlag(umUserinfo.getTenantCode(), "DeleteTransactor", "DeleteTransactor");
        url = url + "/" + umUser.getUserCacode();
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        String data = null;
        try {
            data = OkhttpsUtils.doDelete(url, null, header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.isnull" + url, (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.data" + data + "url" + url, (Object)("startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.returnResultsMap" + url + data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.code" + url, (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.code.1" + url, (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendQueryBusUserinfoTransactor(String tenantCode, Map<String, Object> map) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSeal", (Object)tenantCode);
            throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfoSeal.ex");
        }
        String url = BusUserServiceImpl.getDdFlag(tenantCode, "Transactor", "Transactor");
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoTransactor.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        Long startTime = System.currentTimeMillis();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", map.get("userId"));
        map1.put("transactorId", map.get("transactorId"));
        String param = "";
        param = param + "userId=" + map1.get("userId");
        if (null != map1.get("transactorId")) {
            param = param + "&transactorId=" + map1.get("transactorId");
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        String data = null;
        try {
            data = OkhttpsUtils.doGet(url, param, header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoTransactor.isnull" + url, (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoTransactor.data" + data + "url" + url, (Object)("startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoTransactor.returnResultsMap" + url, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Object transactorId;
                HashMap<String, Object> mapStr = new HashMap<String, Object>();
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                if (!MapUtil.isNotEmpty((Map)returnResultsMap1) || null != (transactorId = returnResultsMap1.get("transactorId"))) {
                    // empty if block
                }
                this.sendOpenUser(mapStr);
                return JsonUtil.buildNonNullBinder().toJson((Object)returnResultsMap1);
            }
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoTransactor.code" + url, (Object)returnResultsMap.toString());
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoTransactor.code.1" + url, (Object)returnResultsMap.toString());
        return null;
    }

    @Override
    public String sendSaveBusUserinfoSealAuthority(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSealAuthority.umUserinfo");
            return "error";
        }
        String url = BusUserServiceImpl.getDdFlag(umUserinfo.getTenantCode(), "SealAuthority", "SealAuthority");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("expireTime", BusUserServiceImpl.getDate());
        map.put("sealId", umUserinfo.getUserinfoOpcode2());
        map.put("transactorId", umUser.getUserCacode());
        map.put("userId", umUserinfo.getUserinfoOpcode1());
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header, "busdata.exUser.sendSaveBusUserinfoSealAuthority");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSealAuthority.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSealAuthority.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSealAuthority.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSealAuthority.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSealAuthority.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendQueryBusUserinfoSealAuthority(String tenantCode, Map<String, Object> map) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority", (Object)tenantCode);
            throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority.ex");
        }
        String url = BusUserServiceImpl.getDdFlag(tenantCode, "SealAuthority", "SealAuthority");
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        Long startTime = System.currentTimeMillis();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("pageNum", map.get("pageNum"));
        map1.put("pageSize", map.get("pageSize"));
        map1.put("sealId", map.get("sealId"));
        map1.put("authStatus", map.get("authStatus"));
        String param = "";
        param = param + "pageNum=" + map1.get("pageNum") + "&pageSize=" + map1.get("pageSize") + "&sealId=" + map1.get("sealId") + "&authStatus=" + map1.get("authStatus");
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        String data = null;
        try {
            data = OkhttpsUtils.doGet(url, param, header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority.isnull" + url, (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority.data" + data + "url" + url, (Object)("startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority.returnResultsMap" + url, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                return JsonUtil.buildNonNullBinder().toJson((Object)returnResultsMap1);
            }
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority.code" + url, (Object)returnResultsMap.toString());
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority.code.1" + url, (Object)returnResultsMap.toString());
        return null;
    }

    @Override
    public String sendDeleteBusUserinfoSealAuthority(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSealAuthority.umUserinfo");
            return "error";
        }
        String url = BusUserServiceImpl.getDdFlag(umUserinfo.getTenantCode(), "SealAuthority", "SealAuthority");
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSealAuthority.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("sealId", umUserinfo.getUserinfoOpcode2());
        map.put("transactorId", umUser.getUserCacode());
        map.put("userId", umUserinfo.getUserinfoOpcode1());
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        String param = "";
        param = param + "sealId=" + map.get("sealId") + "&transactorId=" + map.get("transactorId") + "&userId=" + map.get("userId");
        url = url + param;
        String data = null;
        try {
            data = OkhttpsUtils.doDelete(url, null, header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSealAuthority.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSealAuthority.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSealAuthority.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSealAuthority.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSealAuthority.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendSaveBusUserRegisterEnterpriseNew(UmUserinfo umUserinfo, UmUser umUser, String optype) throws ApiException {
        logger.error(this.SYS_CODE + ".sendSaveBusUserRegisterEnterpriseNew.umUserinfo", (Object)(JsonUtil.buildNormalBinder().toJson((Object)umUserinfo) + "umUser" + JsonUtil.buildNormalBinder().toJson((Object)umUser)));
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserRegisterEnterprise.umUserinfo");
            return "error";
        }
        String url = BusUserServiceImpl.getDdFlag(umUserinfo.getTenantCode(), "Enterprise", "Enterprise");
        logger.error(this.SYS_CODE + ".sendSaveBusUserRegisterEnterprise.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("userName", umUserinfo.getUserinfoCompname());
        map.put("identTypeCode", umUserinfo.getUserinfoCert1No());
        map.put("identNo", umUserinfo.getUserinfoCert2No());
        map.put("email", umUserinfo.getUserinfoEmail());
        map.put("mobilePhone", umUserinfo.getUserinfoPhone());
        map.put("landlinePhone", umUserinfo.getUserinfoTel());
        map.put("authMode", umUserinfo.getMschannelName());
        map.put("transactorName", umUser.getUserName());
        map.put("transactorIdentTypeCode", umUser.getUserQq());
        map.put("transactorIdentNo", umUser.getUserImgurl());
        map.put("transactorAddress", umUserinfo.getCompanyAddress());
        map.put("notSendPwd", umUserinfo.getMschannelCode());
        String data = null;
        try {
            Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header, "busdata.exUser.sendSaveBusUserRegisterEnterpriseNew");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoRegisterPerson.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoRegisterPerson.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoRegisterPerson.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Object userId;
                HashMap<String, Object> mapStr = new HashMap<String, Object>();
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                if (MapUtil.isNotEmpty((Map)returnResultsMap1) && null != (userId = returnResultsMap1.get("userId"))) {
                    umUserinfo.setUserinfoOpcode1(userId.toString());
                    mapStr.put("userinfoOpcode1", userId);
                }
                mapStr.put("userinfoCode", umUserinfo.getUserinfoCode());
                mapStr.put("userinfoCert1Url", "1");
                this.sendOpenUserinfo(mapStr);
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                map1.put("userinfoSignCode", umUserinfo.getUserinfoOcode());
                map1.put("userinfoSignOcode", umUserinfo.getUserinfoOpcode1());
                map1.put("tenantCode", umUserinfo.getTenantCode());
                this.userinfoSignBuyOcode(map1);
                if ("company".equals(umUserinfo.getUserinfoQuality())) {
                    this.sendSaveBusUserinfoSeal(umUserinfo, umUser, optype);
                }
                if ("merchant".equals(umUserinfo.getUserinfoQuality())) {
                    this.sendSaveBusUserinfoByMerchantSeal(umUserinfo, umUser, optype);
                }
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoRegisterPerson.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoRegisterPerson.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendSaveBusUserUpdateContact(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.umUserinfo", (Object)(JsonUtil.buildNormalBinder().toJson((Object)umUserinfo) + "umUser" + JsonUtil.buildNormalBinder().toJson((Object)umUser)));
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.umUserinfo");
            return "error";
        }
        String url = BusUserServiceImpl.getDdFlag(umUserinfo.getTenantCode(), "Contact", "Contact");
        logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("userId", umUserinfo.getUserinfoOpcode1());
        map.put("email", umUserinfo.getUserinfoEmail());
        map.put("mobilePhone", umUserinfo.getUserinfoPhone());
        String data = null;
        try {
            Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header, "busdata.exUser.sendSaveBusUserUpdateContact");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendUpdateBusUserinfoTransactor(UmUserinfo umUserinfo, UmUser umUser, String optype) throws ApiException {
        logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.umUserinfo", (Object)(JsonUtil.buildNormalBinder().toJson((Object)umUserinfo) + "umUser" + JsonUtil.buildNormalBinder().toJson((Object)umUser)));
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.umUserinfo");
            return "error";
        }
        String url = BusUserServiceImpl.getDdFlag(umUserinfo.getTenantCode(), "UpdateEnterprise", "UpdateEnterprise");
        logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("email", umUser.getUserEmial());
        map.put("mobilePhone", umUser.getUserPhone());
        map.put("transactorId", umUser.getUserCode());
        String data = null;
        try {
            Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header, "busdata.exUser.sendUpdateBusUserinfoTransactor");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    public String sendSaveBusUserinfoByMerchantSeal(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoByMerchantSeal.umUserinfo");
            return "error";
        }
        String url = BusUserServiceImpl.getDdFlag(umUserinfo.getTenantCode(), "UserinfoSeal", "UserinfoSeal");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("companyName", umUserinfo.getUserinfoCompname());
        map.put("generateMode", "autogeneration");
        map.put("sealImage", "");
        map.put("sealName", umUser.getUserName());
        map.put("sealType", "qyht");
        map.put("userId", umUserinfo.getUserinfoOpcode1());
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
        map.put("sealAttribute", map1);
        map1.put("centralGraphic", "star");
        map1.put("centralGraphicSize", 60);
        map1.put("mainFont", umUserinfo.getUserinfoCompname());
        map1.put("mainFontSize", 22);
        map1.put("mainFontSpace", 22.0);
        map1.put("mainFontMargin", 4);
        map1.put("sealColor", "red");
        map1.put("sealSize", "300*300");
        if ("merchant".equals(umUserinfo.getUserinfoQuality())) {
            map1.put("sealTemplate", "circle");
        } else {
            map1.put("sealTemplate", "circle");
        }
        map1.put("titleFont", "\u5370\u7ae0\u6807\u9898");
        map1.put("titleFontSize", 16);
        map1.put("titleFontSpace", 8.0);
        map1.put("titleFontMargin", 54);
        map1.put("viceFont", "1BJ00000A01");
        map1.put("viceFontSize", 22);
        map1.put("viceFontSpace", 22.0);
        map1.put("viceFontMargin", 3);
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header, "busdata.exUser.sendSaveBusUserRegisterEnterpriseNew");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoByMerchantSeal.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoByMerchantSeal.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoByMerchantSeal.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Object sealId;
                HashMap<String, Object> mapStr = new HashMap<String, Object>();
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                if (MapUtil.isNotEmpty((Map)returnResultsMap1) && null != (sealId = returnResultsMap1.get("sealId"))) {
                    mapStr.put("userinfoOpcode2", sealId);
                    umUserinfo.setUserinfoOpcode2(sealId.toString());
                }
                mapStr.put("userinfoCode", umUserinfo.getUserinfoCode());
                mapStr.put("userinfoCert2Url", "1");
                this.sendOpenUserinfo(mapStr);
                this.sendSaveBusUserinfoTransactor(umUserinfo, umUser, optype);
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoByMerchantSeal.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoByMerchantSeal.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    private static Map<String, String> getStringStringMap(String tenantCode) {
        String hacckey;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("haccid", "256");
        header.put("hacckey", "97269a9502214c11bcf91b33a15c71c6");
        String haccid = BusUserServiceImpl.getddFlag(tenantCode, "haccid", "haccid");
        if (StringUtils.isNotBlank((String)haccid)) {
            header.put("haccid", haccid);
        }
        if (StringUtils.isNotBlank((String)(hacckey = BusUserServiceImpl.getddFlag(tenantCode, "hacckey", "hacckey")))) {
            header.put("hacckey", hacckey);
        }
        return header;
    }

    @Override
    public String sendSaveBusUserinfoImmediateSignature(String tenantCode, Map<String, Object> map1) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || MapUtil.isEmpty(map1)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature", null);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.ex");
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        String url = BusUserServiceImpl.getDdFlag(tenantCode.toString(), "ImmediateSignature", "ImmediateSignature");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map1));
        if (StringUtils.isBlank((String)url)) {
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.ex");
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("userId", map1.get("userId"));
        map.put("sealId", map1.get("sealId"));
        map.put("transactorId", map1.get("transactorId"));
        map.put("projectCode", map1.get("projectCode"));
        map.put("keyword", map1.get("keyword"));
        map.put("offsetX", map1.get("offsetX"));
        map.put("offsetY", map1.get("offsetY"));
        map.put("imageWidth", map1.get("imageWidth"));
        map.put("imageHeight", map1.get("imageHeight"));
        map.put("contractName", map1.get("contractName"));
        map.put("contractNo", map1.get("contractNo"));
        PteBalancelist pteBalancelist = null;
        String base64EncodedPdf = null;
        if (null != map1.get("projectCode")) {
            pteBalancelist = this.getPteBalancelist(map1.get("projectCode").toString(), tenantCode);
            if (null == pteBalancelist) {
                logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.projectCode", (Object)map1.get("projectCode").toString());
                throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignatureProjectCode.ex");
            }
            HashMap<String, Object> mapStr = new HashMap<String, Object>();
            mapStr.put("balancelistCode", pteBalancelist.getBalancelistCode());
            mapStr.put("tenantCode", pteBalancelist.getTenantCode());
            ArrayList<PteBalanceopGoods> listGoods = new ArrayList<PteBalanceopGoods>();
            QueryResult<PteBalancelistOp> pteBalancelistOps = this.querypteBalancelistOpPage(mapStr);
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.pteBalancelistOps", mapStr);
            if (pteBalancelistOps != null && ListUtil.isNotEmpty((Collection)pteBalancelistOps.getList())) {
                for (PteBalancelistOp pteBalancelistOp : pteBalancelistOps.getList()) {
                    PteBalanceop balanceopByCode = this.getBalanceopByCode(pteBalancelistOp.getBalanceopCode(), pteBalancelistOp.getTenantCode());
                    logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.balanceopByCode", (Object)(pteBalancelistOp.getBalanceopCode() + "tenantCode" + pteBalancelistOp.getTenantCode()));
                    if (null == balanceopByCode) continue;
                    HashMap<String, Object> mapStr1 = new HashMap<String, Object>();
                    mapStr1.put("tenantCode", balanceopByCode.getTenantCode());
                    mapStr1.put("contractBillcode", balanceopByCode.getBusinessOrder());
                    QueryResult<PteBalanceopGoods> pteBalanceopGoodsQueryResult = this.queryBalanceopGoodsPage(mapStr1);
                    logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.pteBalanceopGoodsQueryResult", mapStr1);
                    if (pteBalanceopGoodsQueryResult == null || !ListUtil.isNotEmpty((Collection)pteBalanceopGoodsQueryResult.getList())) continue;
                    for (PteBalanceopGoods pteBalanceopGoods1 : pteBalanceopGoodsQueryResult.getList()) {
                        listGoods.add(pteBalanceopGoods1);
                    }
                }
            }
            if (ListUtil.isEmpty(listGoods)) {
                logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.listGoods.1", (Object)JsonUtil.buildNormalBinder().toJson(map1));
                throw new ApiException(this.SYS_CODE + ".listGoods.1.ex");
            }
            Date now = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            BigDecimal sumMoeny = BigDecimal.ZERO;
            BigDecimal suiMoeny = BigDecimal.ZERO;
            BigDecimal rate = BigDecimal.ZERO;
            int i = 1;
            ArrayList<UserInfo> userList = new ArrayList<UserInfo>();
            for (PteBalanceopGoods pteBalanceopGoods : listGoods) {
                UserInfo userInfo = new UserInfo();
                Integer j = i++;
                userInfo.setId(j.toString());
                userInfo.setName(pteBalanceopGoods.getGoodsName());
                if (null == pteBalanceopGoods.getGoodsCamount()) {
                    pteBalanceopGoods.setGoodsCamount(BigDecimal.ZERO);
                }
                userInfo.setNumber(pteBalanceopGoods.getGoodsCamount().setScale(2, RoundingMode.UP).toString());
                if (null == pteBalanceopGoods.getPricesetNprice()) {
                    pteBalanceopGoods.setPricesetNprice(BigDecimal.ZERO);
                }
                userInfo.setPrice(pteBalanceopGoods.getPricesetNprice().setScale(2, RoundingMode.UP).toString());
                if (null == pteBalanceopGoods.getPricesetInsideprice()) {
                    pteBalanceopGoods.setPricesetInsideprice(BigDecimal.ZERO);
                }
                BigDecimal sumPriceTax = pteBalanceopGoods.getPricesetNprice().subtract(pteBalanceopGoods.getPricesetNprice().multiply(pteBalanceopGoods.getPricesetInsideprice()).multiply(new BigDecimal("0.01")).setScale(2, RoundingMode.UP));
                userInfo.setPriceIncludingTax(sumPriceTax.toString());
                if (null == pteBalanceopGoods.getContractGoodsMoney()) {
                    pteBalanceopGoods.setContractGoodsMoney(BigDecimal.ZERO);
                }
                userInfo.setAmount(pteBalanceopGoods.getContractGoodsMoney().setScale(2, RoundingMode.UP).toString());
                if (null == pteBalanceopGoods.getPricesetInsideprice()) {
                    pteBalanceopGoods.setPricesetInsideprice(BigDecimal.ZERO);
                }
                BigDecimal sums = pteBalanceopGoods.getContractGoodsMoney().subtract(pteBalanceopGoods.getContractGoodsMoney().multiply(pteBalanceopGoods.getPricesetInsideprice()).multiply(new BigDecimal("0.01")).setScale(2, RoundingMode.UP));
                userInfo.setAmountIncludingTax(sums.toString());
                userInfo.setDeliveryTime(sdf.format(now));
                userInfo.setOrderNumber(pteBalanceopGoods.getContractBillcode());
                userInfo.setMaterialCode(pteBalanceopGoods.getSkuNo());
                if (StringUtils.isBlank((String)pteBalanceopGoods.getContractGoodsRemark())) {
                    pteBalanceopGoods.setContractGoodsRemark("\u6682\u65e0");
                }
                userInfo.setContractGoodsRemark(pteBalanceopGoods.getContractGoodsRemark());
                sumMoeny = sumMoeny.add(pteBalanceopGoods.getContractGoodsMoney());
                suiMoeny = suiMoeny.add(sums);
                rate = suiMoeny.divide(sumMoeny, 2, 4);
                userInfo.setRate(pteBalanceopGoods.getPricesetInsideprice().setScale(2, RoundingMode.UP).toString());
                userList.add(userInfo);
            }
            HashMap<String, Object> templateParam = new HashMap<String, Object>(5);
            templateParam.put("date", LocalDate.now());
            templateParam.put("total", userList.size());
            templateParam.put("userList", userList);
            templateParam.put("businessOrderno", map1.get("projectCode"));
            templateParam.put("sellers", pteBalancelist.getMemberName());
            templateParam.put("buyers", pteBalancelist.getMemberBname());
            templateParam.put("dateOfSigning", sdf.format(now));
            templateParam.put("totalAmount", sumMoeny.toString());
            templateParam.put("totalAmountIncludingTax", suiMoeny.toString());
            templateParam.put("totalAmountUpper", ComConstants.toChinese(sumMoeny.toString()));
            templateParam.put("totalAmountUpperTax", ComConstants.toChinese(suiMoeny.toString()));
            templateParam.put("seller", map1.get("seller"));
            templateParam.put("domicile1", map1.get("domicile1"));
            templateParam.put("representative", map1.get("representative"));
            templateParam.put("agent1", map1.get("agent1"));
            templateParam.put("phone1", map1.get("phone1"));
            templateParam.put("buyer", map1.get("buyer"));
            templateParam.put("domicile2", map1.get("domicile2"));
            templateParam.put("head", map1.get("head"));
            templateParam.put("agent2", map1.get("agent2"));
            templateParam.put("phone2", map1.get("phone2"));
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.listGoods.listGoods", (Object)JsonUtil.buildNormalBinder().toJson(listGoods));
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.listGoods.templateParam", (Object)JsonUtil.buildNormalBinder().toJson(templateParam));
            try {
                base64EncodedPdf = WordToPdfAndBase64.generate(templateParam, tenantCode);
            }
            catch (Exception e) {
                throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignaturebase64EncodedPdf.1.ex", (Throwable)e);
            }
        } else {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.projectCode.1", (Object)JsonUtil.buildNormalBinder().toJson(map1));
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignatureProjectCode.1.ex");
        }
        map.put("contractFile", "data:application/pdf;base64," + base64EncodedPdf);
        map.put("crossPageStyle", map1.get("crossPageStyle"));
        map.put("offsetCoordY", map1.get("offsetCoordY"));
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header, "busdata.exUser.sendSaveBusUserinfoImmediateSignature");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.ex", (Throwable)e);
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature2.ex");
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature3.ex");
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature4.ex");
    }

    @Override
    public String sendSaveBusUserinfoNonImmediateSignature(UmUserinfoReDomain umUserinfo, UmUserReDomain umUser) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoNonImmediateSignature.umUserinfo");
            return "error";
        }
        String url = "https://testinterfacem.hbisscm.com/inf/internal/v1/contract/nonImmediateSignature";
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("contractNo", "");
        map.put("userId", "");
        map.put("sealId", "");
        map.put("transactorId", "");
        map.put("projectCode", "");
        map.put("keyword", "");
        map.put("offsetX", null);
        map.put("offsetY", null);
        map.put("imageWidth", null);
        map.put("imageHeight", null);
        map.put("contractName", null);
        map.put("contractNo", null);
        map.put("contractFile", null);
        map.put("crossPageStyle", null);
        map.put("offsetCoordY", null);
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header, "busdata.exUser.sendSaveBusUserinfoNonImmediateSignature");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoNonImmediateSignature.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoNonImmediateSignature.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoNonImmediateSignature.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return returnResultsMap.get("data").toString();
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoNonImmediateSignature.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoNonImmediateSignature.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendSaveBusUserinfoBuyUploadContract(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.map", null);
            throw new ApiException(this.SYS_CODE + ".delBalancelistModelByCode.ex");
        }
        Object tenantCode = map.get("tenantCode");
        if (null == tenantCode) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.tenantCode", null);
            return "error";
        }
        String url = BusUserServiceImpl.getDdFlag(tenantCode.toString(), "UploadContract", "UploadContract");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (StringUtils.isBlank((String)url)) {
            // empty if block
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode.toString());
        Long startTime = System.currentTimeMillis();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", map.get("userId"));
        map1.put("transactorId", map.get("transactorId"));
        map1.put("projectCode", map.get("projectCode"));
        map1.put("sealId", map.get("sealId"));
        map1.put("contractName", map.get("contractName"));
        map1.put("contractNo", map.get("contractNo"));
        map1.put("contractFile", map.get("contractFile"));
        map1.put("isProxySign", map.get("isProxySign"));
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map1), header, "busdata.exUser.sendSaveBusUserinfoBuyUploadContract");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return returnResultsMap.get("data").toString();
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendSaveBusUserinfoBuyDownloadContract(String tenantCode, String contractNo, String userId, Map<String, Object> map) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNo) || StringUtils.isBlank((String)userId)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract", (Object)(tenantCode + "contractNo" + contractNo + "userId" + userId));
            return null;
        }
        String url = BusUserServiceImpl.getDdFlag(tenantCode, "DownloadContract", "DownloadContract");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        Long startTime = System.currentTimeMillis();
        url = url + "/" + userId + "/" + contractNo;
        String data = null;
        try {
            data = OkhttpsUtils.doGet(url, null, header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return returnResultsMap.get("data").toString();
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return null;
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return null;
    }

    protected static String getddFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    @Override
    public String sendSaveBusUserinfoBuySendVerificationCode(String tenantCode, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract", (Object)tenantCode);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.ex");
        }
        String url = BusUserServiceImpl.getDdFlag(tenantCode, "SendVerificationCode", "SendVerificationCode");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (StringUtils.isBlank((String)url)) {
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.ex");
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        Long startTime = System.currentTimeMillis();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", map.get("userId"));
        map1.put("transactorId", map.get("transactorId"));
        map1.put("projectCode", map.get("projectCode"));
        map1.put("sealId", map.get("sealId"));
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map1), header, "busdata.exUser.sendSaveBusUserinfoBuySendVerificationCode");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.ex.1", (Throwable)e);
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.ex.2");
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.ex.3");
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.ex.4");
    }

    @Override
    public String sendSaveBusUserinfoBuyConfirmVerificationCode(String tenantCode, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode", (Object)tenantCode);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.ex");
        }
        String url = BusUserServiceImpl.getDdFlag(tenantCode, "ConfirmVerificationCode", "ConfirmVerificationCode");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (StringUtils.isBlank((String)url)) {
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.ex");
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        Long startTime = System.currentTimeMillis();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", map.get("userId"));
        map1.put("transactorId", map.get("transactorId"));
        map1.put("projectCode", map.get("projectCode"));
        map1.put("checkCode", map.get("checkCode"));
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map1), header, "busdata.exUser.sendSaveBusUserinfoBuyConfirmVerificationCode");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.ex1", (Throwable)e);
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.ex2");
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.ex3");
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.ex4");
    }

    @Override
    public String sendQueryBusUserinfo(String tenantCode, Map<String, Object> map) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfo", (Object)tenantCode);
            throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfo.ex");
        }
        String url = BusUserServiceImpl.getDdFlag(tenantCode, "Userinfo", "Userinfo");
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfo.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        Long startTime = System.currentTimeMillis();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", map.get("userId"));
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        String data = null;
        try {
            data = OkhttpsUtils.doGet(url, map.toString().substring(1, map.toString().length() - 1), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfo.isnull" + url, (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfo.data" + data + "url" + url, (Object)("startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfo.returnResultsMap" + url, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                return JsonUtil.buildNonNullBinder().toJson((Object)returnResultsMap1);
            }
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfo.code" + url, (Object)returnResultsMap.toString());
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfo.code.1" + url, (Object)returnResultsMap.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendInitailCustomerAndAdd(String tenantCode) {
        String localDateTime = this.getStringlocalDateTime();
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.tenantCode", (Object)"\u79df\u6237\u4e3a\u7a7a");
            throw new ApiException("\u79df\u6237\u4e3a\u7a7a,\u4e0d\u80fd\u521d\u59cb\u5316");
        }
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.localDateTime", (Object)localDateTime);
        InternalRouter internalRouter = this.getInternalRouter();
        if (null == internalRouter) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.internalRouter", (Object)"internalRouter is null");
            throw new ApiException("internalRouter is null");
        }
        DdFalgSetting ddFalgSetting = this.queryDdFlagSetting(tenantCode, internalRouter, "InitailCustomerAndAdd");
        if (null == ddFalgSetting) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.ddFalgSetting", (Object)"ddFalgSetting is null");
            throw new ApiException("ddFalgSetting is null");
        }
        Integer flagSettingId = ddFalgSetting.getFlagSettingId();
        String flagSettingInfo = ddFalgSetting.getFlagSettingInfo();
        logger.error(this.SYS_CODE + ".updateCustomer.flagSettingInfo", (Object)flagSettingInfo);
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.flagSettingInfo", (Object)flagSettingInfo);
        boolean initialUser = true;
        LocalDateTime args = null;
        String sql = "SELECT * from  CJ_V_Customer org  \nWHERE org.OrgCode = '001'  and prv10Name is not null and prv10Name != ''   \nORDER BY org.CreatedOn asc";
        if (StringUtils.isNotBlank((String)flagSettingInfo)) {
            sql = "SELECT * from  CJ_V_Customer org  \nWHERE org.OrgCode = '001'  and prv10Name is not null and prv10Name != ''  AND org.CreatedOn > ?\nORDER BY org.CreatedOn asc";
            args = this.getLocalDateTime(flagSettingInfo);
            initialUser = false;
        }
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.sql", (Object)sql);
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.args", (Object)args);
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.initialUser", (Object)initialUser);
        List<Customer> customerListFromU9 = null;
        try {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.queryU9", (Object)"\u67e5\u8be2U9\u5ba2\u6237\u6570\u636e\u5f00\u59cb");
            customerListFromU9 = SqlServerUtils.getForList(Customer.class, sql, args);
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.queryU9", (Object)"\u67e5\u8be2U9\u5ba2\u6237\u6570\u636e\u7ed3\u675f");
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.customerListFromU9.size", (Object)customerListFromU9.size());
            if (ListUtil.isEmpty(customerListFromU9)) {
                logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.queryU9", (Object)"\u67e5\u8be2U9\u5ba2\u6237\u6570\u636e\u4e3a\u7a7a");
                throw new ApiException("\u6ca1\u6709\u65b0\u589e\u7684\u5ba2\u6237\u4fe1\u606f");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.view", (Object)"\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
            throw new ApiException("\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
        }
        for (Customer customer : customerListFromU9) {
            try {
                this.saveUserinfo(tenantCode, internalRouter, customer);
                logger.info(this.SYS_CODE + ".sendInitailCustomerAndAdd.saveUserinfo", (Object)("\u4fdd\u5b58\u7528\u6237\u6210\u529f,\u5ba2\u6237\u7f16\u7801\uff1a" + customer.getCustCode()));
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.saveUserinfo", (Object)("\u4fdd\u5b58\u7528\u6237\u5931\u8d25,\u5ba2\u6237\u7f16\u7801\uff1a" + customer.getCustCode()));
            }
        }
        Customer lastCreateCustomer = customerListFromU9.get(customerListFromU9.size() - 1);
        try {
            this.updateFalgSettingInFoByKey(internalRouter, "InitailCustomerAndAdd", tenantCode, lastCreateCustomer.getCreatedOn(), flagSettingId);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.updateFalgSettingInFoByKey", (Object)"\u66f4\u65b0\u5f02\u5e38");
        }
        finally {
            userThreadPoolExecutor.shutdownNow();
        }
        return "Success";
    }

    private void saveDdFlag(InternalRouter internalRouter, String tenantCode, String flagSettingCode, String flagSettingPro, String localTime, String businessFlag) {
        final DdFalgSettingDomain ddFalgSettingDomain = new DdFalgSettingDomain();
        ddFalgSettingDomain.setTenantCode(tenantCode);
        ddFalgSettingDomain.setFlagSettingInfo(localTime);
        ddFalgSettingDomain.setFlagSettingCode(flagSettingCode);
        ddFalgSettingDomain.setFlagSettingScope(flagSettingCode);
        ddFalgSettingDomain.setFlagSettingPro(flagSettingPro);
        if (StringUtils.isNotBlank((String)businessFlag)) {
            ddFalgSettingDomain.setFlagSettingPro1(businessFlag);
        }
        HashMap<String, Object> saveDdFlagParamMap = new HashMap<String, Object>(){
            {
                this.put("falgSettingDomain", JsonUtil.buildNormalBinder().toJson((Object)ddFalgSettingDomain));
            }
        };
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.saveDdFlag.saveDdFlagParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)saveDdFlagParamMap));
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.saveDdFlag", (Object)"\u4fdd\u5b58customerUpdateBeginTime ddFlag\u5f00\u59cb");
        internalRouter.inInvoke("dd.falgSetting.saveFalgSetting", (Map)saveDdFlagParamMap);
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.saveDdFlag", (Object)"\u4fdd\u5b58customerUpdateBeginTime ddFlag\u7ed3\u675f");
    }

    @Override
    public String sendInitailCustomerCompensate(final String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.tenantCode", (Object)"tenantCode is null");
            return "tenantCode is null";
        }
        InternalRouter internalRouter = this.getInternalRouter();
        if (null == internalRouter) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerCompensate.internalRouter", (Object)"internalRouter is null");
            return "internalRouter is null";
        }
        final HashMap<String, Object> logMap = new HashMap<String, Object>(){
            {
                this.put("fuzzy", true);
                this.put("tenantCode", tenantCode);
                this.put("clientExecuteMethod", "busdata.exUser.sendInitailCustomerCompensate");
                this.put("dataState", 0);
            }
        };
        HashMap<String, Object> logParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)logMap));
            }
        };
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.logParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)logParamMap));
        String logStr = (String)internalRouter.inInvoke("log.log.queryErrorLogPage", (Map)logParamMap);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(logStr, SupQueryResult.class);
        List logList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), LogErrorLog.class);
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.logList", (Object)JsonUtil.buildNormalBinder().toJson((Object)logList));
        if (ListUtil.isEmpty((Collection)logList)) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.logList", (Object)JsonUtil.buildNormalBinder().toJson((Object)logList));
            return "logList is null\uff0c\u6ca1\u6709\u5f85\u8865\u507f\u7684\u65b0\u589e\u8bb0\u5f55";
        }
        for (LogErrorLog logErrorLog : logList) {
            Customer customer = (Customer)JsonUtil.buildNormalBinder().getJsonToObject(logErrorLog.getErrorLogMessage(), Customer.class);
            if ("customerInitialUserinfo".equals(logErrorLog.getClientType())) {
                this.saveUserinfo(tenantCode, internalRouter, customer);
            } else {
                UmUser umUser = this.getUmUser(customer, tenantCode, internalRouter);
                this.saveUserinfoApplyList(internalRouter, customer, umUser.getUserPcode(), tenantCode);
            }
            this.updateLogState(internalRouter, logErrorLog, logErrorLog.getDataState(), 4);
        }
        return null;
    }

    @Override
    public String sendUpdateCustomer(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".updateCustomer.tenantCode", (Object)"tenantCode is null");
            return "tenantCode is null";
        }
        InternalRouter internalRouter = this.getInternalRouter();
        if (null == internalRouter) {
            logger.error(this.SYS_CODE + ".updateCustomer.internalRouter", (Object)"internalRouter is null");
            return "internalRouter is null";
        }
        DdFalgSetting ddFalgSetting = this.queryDdFlagSetting(tenantCode, internalRouter, "customerUpdateBeginTime");
        if (null == ddFalgSetting) {
            logger.error(this.SYS_CODE + ".updateCustomer.ddFalgSetting", (Object)"ddFalgSetting is null");
            return "ddFalgSetting is null";
        }
        Integer flagSettingId = ddFalgSetting.getFlagSettingId();
        String flagSettingInfo = ddFalgSetting.getFlagSettingInfo();
        logger.error(this.SYS_CODE + ".updateCustomer.flagSettingInfo", (Object)flagSettingInfo);
        if (StringUtils.isBlank((String)flagSettingInfo)) {
            logger.error(this.SYS_CODE + ".updateCustomer.internalRouter", (Object)"flagSettingInfo is null ");
        }
        List<Customer> customerListFromU9 = null;
        try {
            logger.error(this.SYS_CODE + ".updateCustomer.queryU9", (Object)"\u67e5\u8be2U9\u5ba2\u6237\u6570\u636e\u5f00\u59cb");
            customerListFromU9 = SqlServerUtils.getForList(Customer.class, "SELECT * from  CJ_V_Customer org  \nWHERE org.OrgCode = '001'  and prv10Name is not null and prv10Name != ''  \n AND org.ModifiedOn > org.CreatedOn AND org.ModifiedOn >= ?\nORDER BY cust.ModifiedOn asc", this.getLocalDateTime(flagSettingInfo));
            logger.error(this.SYS_CODE + ".updateCustomer.queryU9", (Object)"\u67e5\u8be2U9\u5ba2\u6237\u6570\u636e\u7ed3\u675f");
            logger.error(this.SYS_CODE + ".updateCustomer.customerListFromU9.size", (Object)customerListFromU9.size());
            if (ListUtil.isEmpty(customerListFromU9)) {
                logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.queryU9", (Object)"\u6ca1\u6709\u4fee\u6539\u7684\u5ba2\u6237\u4fe1\u606f");
                return "\u6ca1\u6709\u4fee\u6539\u7684\u5ba2\u6237\u4fe1\u606f";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".updateCustomer.view", (Object)"\u4fee\u6539\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
            return "\u4fee\u6539\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898";
        }
        String modifiedon = "";
        logger.error(this.SYS_CODE + ".updateCustomer.modifiedon", (Object)modifiedon);
        for (Customer customer : customerListFromU9) {
            try {
                modifiedon = customer.getModifiedOn();
                UmUser umUser = this.getUmUser(customer, tenantCode, internalRouter);
                if (null == umUser) {
                    logger.error(this.SYS_CODE + ".updateCustomer.modifiedon.null=umUser", (Object)modifiedon);
                    logger.error(this.SYS_CODE + ".updateCustomer.lastModifyUse.null=umUser", (Object)JsonUtil.buildNormalBinder().toJson((Object)customer));
                    this.updateFalgSettingInFoByKey(internalRouter, "customerUpdateBeginTime", tenantCode, modifiedon, flagSettingId);
                    logger.error(this.SYS_CODE + ".updateCustomer.customer.null=umUser", (Object)("\u672a\u63d2\u5165customer:" + JsonUtil.buildNormalBinder().toJson((Object)customer) + ",\u4e0d\u80fd\u505a\u4fee\u6539"));
                    return "\u672a\u63d2\u5165customer: " + customer.getCustCode() + ",\u4e0d\u80fd\u505a\u4fee\u6539";
                }
                this.compareUserAndUserinfoApply(internalRouter, tenantCode, customer, umUser);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".updateCustomer.modifiedon.e", (Object)modifiedon);
                logger.error(this.SYS_CODE + ".updateCustomer.lastModifyUse.e", (Object)JsonUtil.buildNormalBinder().toJson((Object)customer));
                logger.error(this.SYS_CODE + ".updateCustomer.customer.e", (Object)("\u6bd4\u8f83\u51fa\u9519:" + JsonUtil.buildNormalBinder().toJson((Object)customer)));
                this.updateFalgSettingInFoByKey(internalRouter, "customerUpdateBeginTime", tenantCode, modifiedon, flagSettingId);
                return "\u6bd4\u8f83\u51fa\u9519: " + customer.getCustCode();
            }
        }
        LocalDateTime localDateTime = this.getLocalDateTime(modifiedon);
        LocalDateTime localDateTimePlus1N = localDateTime.plusSeconds(1L);
        logger.error(this.SYS_CODE + ".updateCustomer.localDateTime", (Object)localDateTime);
        logger.error(this.SYS_CODE + ".updateCustomer.localDateTimePlus1N", (Object)localDateTimePlus1N);
        this.updateFalgSettingInFoByKey(internalRouter, "customerUpdateBeginTime", tenantCode, this.getStringlocalDateTimeBy(localDateTimePlus1N), flagSettingId);
        return "SUCCESS";
    }

    private void compareUserAndUserinfoApply(InternalRouter internalRouter, String tenantCode, Customer customer, UmUser umUser) throws Exception {
        this.compareUserAndUserinfo(internalRouter, tenantCode, customer, umUser);
        this.saveUserinfoApplyList(internalRouter, customer, umUser.getUserPcode(), tenantCode);
    }

    private void compareAndUpdateUserinfoApply(UmUserinfoapply umUserinfoapply, UmUserinfoapplyDomain mingYongApplyU, InternalRouter internalRouter, String tenantCode) throws Exception {
        if (umUserinfoapply.getUserinfoSort().equals(mingYongApplyU.getUserinfoSort())) {
            return;
        }
        final UmUserinfoapplyDomain umUserinfoapplyDomain = new UmUserinfoapplyDomain();
        umUserinfoapplyDomain.setTenantCode(tenantCode);
        umUserinfoapplyDomain.setUserinfoapplyId(umUserinfoapply.getUserinfoapplyId());
        umUserinfoapplyDomain.setUserinfoChannelname(mingYongApplyU.getUserinfoChannelname());
        umUserinfoapplyDomain.setUserinfoChannelcode(mingYongApplyU.getUserinfoChannelcode());
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("umUserinfoapplyDomain", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoapplyDomain));
            }
        };
        internalRouter.inInvoke("um.umUserinfoapply.updateUserinfoapply", (Map)map);
    }

    public void saveUserinfoApply(final UmUserinfoapplyDomain umUserinfoapplyDomain, InternalRouter internalRouter) throws Exception {
        HashMap<String, Object> apSaveUpMap = new HashMap<String, Object>(){
            {
                this.put("umUserinfoapplyDomain", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoapplyDomain));
            }
        };
        try {
            internalRouter.inInvoke("um.umUserinfoapply.saveUserinfoapply", (Map)apSaveUpMap);
            logger.error(this.SYS_CODE + ".sendUpdateCustomer.saveUserinfoAndUser.saveUserinfoApply", (Object)(JsonUtil.buildNormalBinder().toJson((Object)umUserinfoapplyDomain) + ": \u63d2\u5165\u5931\u8d25"));
        }
        catch (Exception e) {
            throw new RuntimeException("\u4fdd\u5b58\u7528\u6237\u8d44\u8d28\u4fe1\u606f\u5ba1\u6838\u5931\u8d25");
        }
    }

    private void compareUserAndUserinfo(InternalRouter internalRouter, String tenantCode, Customer customer, UmUser umUser) {
        final UmUserinfoDomainBeanA umUserDomainBean = this.buildUpdateDomainBean(internalRouter, umUser, customer, tenantCode);
        HashMap<String, Object> updateUserinfoParamMap = new HashMap<String, Object>(){
            {
                this.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
            }
        };
        logger.error(this.SYS_CODE + ".compareUserAndUserinfo.updateUserinfo", (Object)"\u66f4\u6539\u7528\u6237\u4fe1\u606f\u5f00\u59cb");
        internalRouter.inInvoke("um.userbase.updateUserinfo", (Map)updateUserinfoParamMap);
        logger.error(this.SYS_CODE + ".compareUserAndUserinfo.updateUserinfoParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)updateUserinfoParamMap));
        logger.error(this.SYS_CODE + ".compareUserAndUserinfo.updateUserinfo", (Object)"\u66f4\u6539\u7528\u6237\u4fe1\u606f\u7ed3\u675f");
    }

    private UmUserinfoDomainBeanA buildUpdateDomainBean(InternalRouter internalRouter, UmUser umUser, Customer customer, final String tenantCode) {
        final String userinfoCode = umUser.getUserPcode();
        HashMap<String, Object> userParamMap = new HashMap<String, Object>(){
            {
                this.put("userinfoCode", userinfoCode);
                this.put("tenantCode", tenantCode);
            }
        };
        String userinfoStr = (String)internalRouter.inInvoke("um.user.getUserinfoByUserCode", (Map)userParamMap);
        UmUserinfo umuserInfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(userinfoStr, UmUserinfo.class);
        if (null == umuserInfo) {
            logger.error(this.SYS_CODE + ".compareUserAndUserinfo.buildUpdateDomainBean.e", (Object)("\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f:" + userinfoCode));
            return null;
        }
        UmUserinfoDomainBeanA UmUserinfoDomainBean2 = new UmUserinfoDomainBeanA();
        try {
            BeanUtils.copyAllPropertys((Object)UmUserinfoDomainBean2, (Object)umuserInfo);
            BeanUtils.copyAllPropertys((Object)UmUserinfoDomainBean2, (Object)umUser);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Integer userinfoFeestatus = umuserInfo.getUserinfoFeestatus();
        if (userinfoFeestatus == 1) {
            UmUserinfoDomainBean2.setUserinfoFeestatus(1);
        }
        if (customer.isEffective_IsEffective()) {
            UmUserinfoDomainBean2.setDataState(0);
        } else {
            UmUserinfoDomainBean2.setDataState(-1);
        }
        return UmUserinfoDomainBean2;
    }

    private List<UmUserinfoapply> queryUserinfoApply(InternalRouter internalRouter, final String tenantCode, final Customer customer) throws Exception {
        final HashMap<String, Object> applyMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", tenantCode);
                this.put("userinfoInvite", customer.getCustCode());
            }
        };
        HashMap<String, Object> applyParmMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)applyMap));
            }
        };
        String applyStr = (String)internalRouter.inInvoke("um.umUserinfoapply.queryUserinfoapplyPage", (Map)applyParmMap);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(applyStr, SupQueryResult.class);
        List applyList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), UmUserinfoapply.class);
        return applyList;
    }

    private DdFalgSetting queryDdFlagSettingBySettingCodeAndInfo(final String tenantCode, InternalRouter internalRouter, final String flagSettingCode, final String flagSettingInfo) {
        final HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("flagSettingCode", flagSettingCode);
                this.put("flagSettingInfo", flagSettingInfo);
                this.put("tenantCode", tenantCode);
            }
        };
        HashMap<String, Object> ddflagParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)ddflagMap));
            }
        };
        logger.error(this.SYS_CODE + ".queryDdFlagSettingBySettingCodeAndInfo.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".queryDdFlagSettingBySettingCodeAndInfo.ddflagParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)ddflagParamMap));
        String flagSettingListStr = (String)internalRouter.inInvoke("dd.falgSetting.queryFalgSettingPage", (Map)ddflagParamMap);
        logger.error(this.SYS_CODE + ".queryDdFlagSettingBySettingCodeAndInfo.querDdFlag", (Object)"\u67e5\u8be2ddFla\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(flagSettingListStr, SupQueryResult.class);
        List flagSettingList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DdFalgSetting.class);
        logger.error(this.SYS_CODE + ".queryDdFlagSettingBySettingCodeAndInfo.flagSettingList", (Object)JsonUtil.buildNormalBinder().toJson((Object)flagSettingList));
        logger.error(this.SYS_CODE + ".queryDdFlagSettingBySettingCodeAndInfo.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u7ed3\u675f");
        return (DdFalgSetting)flagSettingList.get(0);
    }

    private DdFalgSetting queryDdFlagSetting(final String tenantCode, InternalRouter internalRouter, final String flagSettingCode) {
        final HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("flagSettingCode", flagSettingCode);
                this.put("tenantCode", tenantCode);
            }
        };
        HashMap<String, Object> ddflagParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)ddflagMap));
            }
        };
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.ddflagParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)ddflagParamMap));
        String flagSettingListStr = (String)internalRouter.inInvoke("dd.falgSetting.queryFalgSettingPage", (Map)ddflagParamMap);
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFla\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(flagSettingListStr, SupQueryResult.class);
        List flagSettingList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DdFalgSetting.class);
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.flagSettingList", (Object)JsonUtil.buildNormalBinder().toJson((Object)flagSettingList));
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u7ed3\u675f");
        return (DdFalgSetting)flagSettingList.get(0);
    }

    private String querDdFlagSettingInfo(final String tenantCode, InternalRouter internalRouter, final String flagSettingCode) {
        final HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("flagSettingCode", flagSettingCode);
                this.put("tenantCode", tenantCode);
            }
        };
        HashMap<String, Object> ddflagParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)ddflagMap));
            }
        };
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.ddflagParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)ddflagParamMap));
        String initialFlag = (String)internalRouter.inInvoke("dd.falgSetting.getFalgSettingByCode", (Map)ddflagParamMap);
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u7ed3\u675f");
        Map initialFlagMap = JsonUtil.buildNormalBinder().getJsonToMap(initialFlag, String.class, Object.class);
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.initialFlagMap", (Object)initialFlagMap);
        String flagSettingInfo = (String)initialFlagMap.get("FLAG_SETTING_INFO");
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.flagSettingInfo", (Object)flagSettingInfo);
        if (MapUtil.isNotEmpty((Map)initialFlagMap) && StringUtils.isNotBlank((String)flagSettingInfo)) {
            return flagSettingInfo;
        }
        return "error get flagSettingInfo";
    }

    private void updateLogState(InternalRouter internalRouter, final LogErrorLog logErrorLog, final Integer oldDataState, final Integer dataState) {
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("logErrorId", logErrorLog.getLogErrorId());
                this.put("dataState", dataState);
                this.put("oldDataState", oldDataState);
            }
        };
        internalRouter.inInvoke("log.log.updateErrorLogState", (Map)map);
    }

    private UmUser getUmUser(Customer customer, final String tenantCode, InternalRouter internalRouter) {
        final String userOcode = customer.getCustCode();
        final HashMap<String, Object> userMap = new HashMap<String, Object>(){
            {
                this.put("userOcode", userOcode);
                this.put("tenantCode", tenantCode);
            }
        };
        HashMap<String, Object> userParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)userMap));
            }
        };
        String userStr = (String)internalRouter.inInvoke("um.user.getUserByUserOcode", (Map)userParamMap);
        UmUser umUser = (UmUser)JsonUtil.buildNormalBinder().getJsonToObject(userStr, UmUser.class);
        return umUser;
    }

    private void saveUserinfo(String tenantCode, InternalRouter internalRouter, Customer customer) {
        UmUser umUser = this.getUmUser(customer, tenantCode, internalRouter);
        if (null == umUser) {
            this.saveUserinfoAndUserApply(internalRouter, customer, tenantCode);
        } else {
            this.saveUserinfoApplyList(internalRouter, customer, umUser.getUserPcode(), tenantCode);
        }
    }

    private void updateFalgSettingInFoByKey(InternalRouter internalRouter, String flagSettingCode, String tenantCode, String modifiedon, Integer flagSettingId) {
        final DdFalgSettingDomain ddFalgSettingDomain = new DdFalgSettingDomain();
        ddFalgSettingDomain.setFlagSettingId(flagSettingId);
        ddFalgSettingDomain.setFlagSettingCode(flagSettingCode);
        ddFalgSettingDomain.setTenantCode(tenantCode);
        ddFalgSettingDomain.setFlagSettingInfo(modifiedon);
        HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("falgSettingDomain", JsonUtil.buildNormalBinder().toJson((Object)ddFalgSettingDomain));
            }
        };
        internalRouter.inInvoke("dd.falgSetting.updateFalgSetting", (Map)ddflagMap);
    }

    private void updateFalgSetting(InternalRouter internalRouter, Map<String, Object> initialFlagMap, String tenantCode, String localDateTime) {
        final DdFalgSettingDomain ddFalgSettingDomain = new DdFalgSettingDomain();
        ddFalgSettingDomain.setFlagSettingCode((String)initialFlagMap.get("FLAG_SETTING_CODE"));
        ddFalgSettingDomain.setTenantCode(tenantCode);
        ddFalgSettingDomain.setFlagSettingInfo(localDateTime);
        HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("falgSettingDomain", JsonUtil.buildNormalBinder().toJson((Object)ddFalgSettingDomain));
            }
        };
        internalRouter.inInvoke("dd.falgSetting.updateFalgSetting", (Map)ddflagMap);
    }

    private void saveUserinfoAndUserApply(InternalRouter internalRouter, Customer customer, String tenantCode) {
        final UmUserDomainBean umUserDomainBean = this.buildUmUserDomainBean(customer, tenantCode);
        HashMap<String, Object> userMap = new HashMap<String, Object>(){
            {
                this.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
            }
        };
        String userinfoCode = null;
        try {
            userinfoCode = (String)internalRouter.inInvoke("um.user.sendOpenUserinfo", (Map)userMap);
            this.saveUserinfoApplyList(internalRouter, customer, userinfoCode, tenantCode);
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.saveUserinfoAndUser.userinfoCode", (Object)userinfoCode);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.saveUserinfoAndUser.customer", (Object)(JsonUtil.buildNormalBinder().toJson((Object)customer) + ": \u63d2\u5165\u5931\u8d25"));
            this.saveLogError(internalRouter, customer, "customerInitialUserinfo", tenantCode, "busdata.exUser.sendInitailCustomerCompensate", e.getMessage());
            return;
        }
    }

    private UmUserDomainBean buildUmUserDomainBean(Customer customer, String tenantCode) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setTenantCode(tenantCode);
        umUserDomainBean.setUserAdd(true);
        if (!customer.isEffective_IsEffective()) {
            umUserDomainBean.setDataState(-1);
        }
        String prv9Name = customer.getPrv9Name();
        umUserDomainBean.setUserinfoQuality("dealer");
        umUserDomainBean.setUserOcode(customer.getCustCode());
        umUserDomainBean.setUserinfoOcode(customer.getCustCode());
        umUserDomainBean.setUserinfoCompname(customer.getCustName());
        umUserDomainBean.setCompanyShortname(customer.getCustShortName());
        umUserDomainBean.setUserPhone(customer.getPrv5Name());
        umUserDomainBean.setUserName(customer.getCustCode());
        if (StringUtils.isBlank((String)umUserDomainBean.getUserPhone())) {
            umUserDomainBean.setUserPhone(umUserDomainBean.getUserName());
        }
        umUserDomainBean.setUserinfoCertNo(customer.getStateTaxNo());
        umUserDomainBean.setUserinfoCon(customer.getPrv5Name());
        umUserDomainBean.setUserinfoConPhone(customer.getPrv5Name());
        umUserDomainBean.setUserPwsswd("123456");
        umUserDomainBean.setUserinfoParentCode("20000210463648");
        return umUserDomainBean;
    }

    private void saveLogErrorExt(InternalRouter internalRouter, Customer customer, String errorType, String tenantCode, String clientExecuteMethod, String memo, String orgNameSpilt, String orgCodeSpilt) {
        final LogErrorLogDomain logErrorLogDomain = new LogErrorLogDomain();
        logErrorLogDomain.setTenantCode(tenantCode);
        logErrorLogDomain.setUserCode(customer.getCustCode());
        logErrorLogDomain.setErrorType(errorType);
        logErrorLogDomain.setClientExecuteMethod("clientExecuteMethod: " + clientExecuteMethod + "errorMsg: " + memo.substring(0, 150));
        if (StringUtils.isNotBlank((String)orgNameSpilt) && StringUtils.isNotBlank((String)orgCodeSpilt)) {
            logErrorLogDomain.setErrorLogMessage(JsonUtil.buildNonDefaultBinder().toJson((Object)customer) + "|" + orgNameSpilt + "|" + orgCodeSpilt);
        } else {
            logErrorLogDomain.setErrorLogMessage(JsonUtil.buildNonDefaultBinder().toJson((Object)customer));
        }
        HashMap<String, Object> logMap = new HashMap<String, Object>(){
            {
                this.put("logErrorLogDomain", logErrorLogDomain);
            }
        };
        internalRouter.inInvoke("log.log.saveErrorLog", (Map)logMap);
    }

    private void saveLogError(InternalRouter internalRouter, Customer customer, String clientType, String tenantCode, String clientExecuteMethod, String memo) {
        final LogErrorLogDomain logErrorLogDomain = new LogErrorLogDomain();
        logErrorLogDomain.setTenantCode(tenantCode);
        logErrorLogDomain.setUserCode(customer.getCustCode());
        logErrorLogDomain.setClientType(clientType);
        logErrorLogDomain.setClientExecuteMethod("clientExecuteMethod: " + clientExecuteMethod + "errorMsg: " + memo);
        logErrorLogDomain.setErrorLogMessage(JsonUtil.buildNonDefaultBinder().toJson((Object)customer));
        HashMap<String, Object> logMap = new HashMap<String, Object>(){
            {
                this.put("logErrorLogDomain", JsonUtil.buildNormalBinder().toJson((Object)logErrorLogDomain));
            }
        };
        try {
            internalRouter.inInvoke("log.log.saveErrorLog", (Map)logMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<UmUserinfoapplyDomain> saveUserinfoApplyList(InternalRouter internalRouter, Customer customer, String userinfoCode, String tenantCode) {
        ArrayList<UmUserinfoapplyDomain> batchSaveUpList = new ArrayList<UmUserinfoapplyDomain>();
        String prv10Name = customer.getPrv10Name();
        if (StringUtils.isBlank((String)prv10Name)) {
            this.saveLogError(internalRouter, customer, "\u6e20\u9053\u7f3a\u5931", tenantCode, "busdata.exUser.sendInitailCustomerCompensate", "\u6e20\u9053\u7f3a\u5931");
            return null;
        }
        List<Object> applyList = new ArrayList();
        try {
            applyList = this.queryUserinfoApply(internalRouter, tenantCode, customer);
        }
        catch (Exception e) {
            this.saveLogError(internalRouter, customer, "\u6e20\u9053\u67e5\u8be2\u5931\u8d25", tenantCode, "busdata.exUser.sendInitailCustomerCompensate", "\u6e20\u9053\u67e5\u8be2\u5931\u8d25");
            throw new RuntimeException(e);
        }
        Map<String, UmUserinfoapply> applyMap = applyList.stream().collect(Collectors.toMap(UmUserinfoapply::getUserinfoDischannelname, apply -> apply));
        String[] split = customer.getPrv10Name().trim().split("[,\u3001]");
        UmUserinfoapplyDomain mingYongApply = null;
        UmUserinfoapplyDomain gongChengApply = null;
        for (String s : split) {
            String contractPartA = s;
            DdFalgSetting ddFalgSetting = this.queryDdFlagSettingBySettingCodeAndInfo(tenantCode, internalRouter, "ContractPartA", contractPartA);
            if ("\u6c11\u7528".equals(ddFalgSetting.getFlagSettingPro()) && mingYongApply == null && applyMap.get("\u6c11\u7528") == null) {
                mingYongApply = this.buildMinYongApply(customer, tenantCode, userinfoCode, contractPartA, ddFalgSetting);
                continue;
            }
            if (!"\u5de5\u7a0b".equals(ddFalgSetting.getFlagSettingPro()) || applyMap.get("\u5de5\u7a0b") != null) continue;
            gongChengApply = this.buildGongchengApply(customer, tenantCode, userinfoCode, contractPartA, ddFalgSetting);
        }
        if (null != mingYongApply) {
            mingYongApply.setUserinfoParentCode("20000210463648");
            batchSaveUpList.add(mingYongApply);
        }
        if (null != gongChengApply) {
            gongChengApply.setUserinfoParentCode("20000210463648");
            batchSaveUpList.add(gongChengApply);
        }
        final ArrayList<UmUserinfoapplyDomain> finalBatchSaveUpList = batchSaveUpList;
        HashMap<String, Object> batchSaveUpMap = new HashMap<String, Object>(){
            {
                this.put("umUserinfoapplyDomainList", JsonUtil.buildNormalBinder().toJson((Object)finalBatchSaveUpList));
            }
        };
        try {
            internalRouter.inInvoke("um.umUserinfoapply.saveUserinfoapplyBatch", (Map)batchSaveUpMap);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.saveUserinfoAndUser.finalBatchSaveUpList", (Object)(JsonUtil.buildNormalBinder().toJson(finalBatchSaveUpList) + ": \u63d2\u5165\u5931\u8d25"));
            this.saveLogError(internalRouter, customer, "customerInitialUserinfoApply", tenantCode, "busdata.exUser.sendInitailCustomerCompensate", e.getMessage());
        }
        return batchSaveUpList;
    }

    private UmUserinfoapplyDomain buildGongchengApply(Customer customer, String tenantCode, String userinfoCode, String orgCode, DdFalgSetting ddFalgSetting) {
        UmUserinfoapplyDomain umUserinfoapplyDomain = new UmUserinfoapplyDomain();
        umUserinfoapplyDomain.setTenantCode(tenantCode);
        umUserinfoapplyDomain.setUserinfoCompname(customer.getCustName());
        umUserinfoapplyDomain.setUserinfoInvite(customer.getCustCode());
        umUserinfoapplyDomain.setUserinfoCode(userinfoCode);
        umUserinfoapplyDomain.setQualityCode("dealer");
        umUserinfoapplyDomain.setQualityCode("\u7ecf\u9500\u5546");
        umUserinfoapplyDomain.setUserNickname(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserPhone(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserinfoDischannelname("\u5de5\u7a0b");
        umUserinfoapplyDomain.setUserinfoChannelname(ddFalgSetting.getFlagSettingPro1());
        umUserinfoapplyDomain.setUserinfoChannelcode(orgCode);
        umUserinfoapplyDomain.setDepartCode(customer.getPrv15Code());
        umUserinfoapplyDomain.setDepartName(customer.getPrv15Name());
        umUserinfoapplyDomain.setUserinfoDischannelcode(ddFalgSetting.getChannelCode());
        umUserinfoapplyDomain.setUserinfoSort(orgCode);
        return umUserinfoapplyDomain;
    }

    private UmUserinfoapplyDomain buildMinYongApply(Customer customer, String tenantCode, String userinfoCode, String orgCode, DdFalgSetting ddFalgSetting) {
        UmUserinfoapplyDomain umUserinfoapplyDomain = new UmUserinfoapplyDomain();
        umUserinfoapplyDomain.setTenantCode(tenantCode);
        umUserinfoapplyDomain.setUserinfoCompname(customer.getCustName());
        umUserinfoapplyDomain.setUserinfoInvite(customer.getCustCode());
        umUserinfoapplyDomain.setUserinfoCode(userinfoCode);
        umUserinfoapplyDomain.setQualityCode("dealer");
        umUserinfoapplyDomain.setQualityCode("\u7ecf\u9500\u5546");
        umUserinfoapplyDomain.setUserNickname(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserPhone(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserinfoDischannelname("\u6c11\u7528");
        umUserinfoapplyDomain.setUserinfoChannelname(ddFalgSetting.getFlagSettingPro1());
        umUserinfoapplyDomain.setUserinfoChannelcode(orgCode);
        umUserinfoapplyDomain.setDepartCode(customer.getPrv15Code());
        umUserinfoapplyDomain.setDepartName(customer.getPrv15Name());
        umUserinfoapplyDomain.setUserinfoDischannelcode(ddFalgSetting.getChannelCode());
        umUserinfoapplyDomain.setUserinfoSort(orgCode);
        return umUserinfoapplyDomain;
    }

    private List<UmUserinfoapplyDomain> buildUserinfoApplySignal(Customer customer, String userinfoCode, String tenantCode) {
        ArrayList<UmUserinfoapplyDomain> upList = new ArrayList<UmUserinfoapplyDomain>();
        UmUserinfoapplyDomain umUserinfoapplyDomain = new UmUserinfoapplyDomain();
        upList.add(umUserinfoapplyDomain);
        umUserinfoapplyDomain.setTenantCode(tenantCode);
        umUserinfoapplyDomain.setUserinfoCompname(customer.getCustName());
        umUserinfoapplyDomain.setUserinfoInvite(customer.getCustCode());
        umUserinfoapplyDomain.setUserinfoCode(userinfoCode);
        umUserinfoapplyDomain.setQualityCode("dealer");
        umUserinfoapplyDomain.setQualityCode("\u7ecf\u9500\u5546");
        umUserinfoapplyDomain.setUserNickname(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserPhone(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserinfoChannelname(customer.getOrgName());
        umUserinfoapplyDomain.setUserinfoChannelcode(customer.getOrgCode());
        umUserinfoapplyDomain.setDepartCode(customer.getPrv11Code());
        umUserinfoapplyDomain.setDepartName(customer.getPrv11Name());
        if (StringUtils.isNotBlank((String)customer.getPrv1Code())) {
            umUserinfoapplyDomain.setUserinfoDischannelcode(customer.getPrv1Name());
            umUserinfoapplyDomain.setUserinfoParentCode(customer.getPrv9Code());
            umUserinfoapplyDomain.setUserinfoParentName(customer.getPrv9Name());
        } else {
            umUserinfoapplyDomain.setUserinfoDischannelcode(customer.getPrv13Name());
        }
        return upList;
    }

    private List<UmUserinfoapplyDomain> buildUserinfoApplyTwo(Customer customer, String userinfoCode, String tenantCode) {
        ArrayList<UmUserinfoapplyDomain> upList = new ArrayList<UmUserinfoapplyDomain>();
        UmUserinfoapplyDomain umUserinfoapplyDomain = new UmUserinfoapplyDomain();
        upList.add(umUserinfoapplyDomain);
        umUserinfoapplyDomain.setTenantCode(tenantCode);
        umUserinfoapplyDomain.setUserinfoCompname(customer.getCustName());
        umUserinfoapplyDomain.setUserinfoInvite(customer.getCustCode());
        umUserinfoapplyDomain.setUserinfoCode(userinfoCode);
        umUserinfoapplyDomain.setQualityCode("dealer");
        umUserinfoapplyDomain.setQualityCode("\u7ecf\u9500\u5546");
        umUserinfoapplyDomain.setUserNickname(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserPhone(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserinfoParentCode(customer.getPrv9Code());
        umUserinfoapplyDomain.setUserinfoParentName(customer.getPrv9Name());
        UmUserinfoapplyDomain umUserinfoapplyDomain1 = new UmUserinfoapplyDomain();
        upList.add(umUserinfoapplyDomain1);
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoapplyDomain1, (Object)umUserinfoapplyDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] orgNameSplit = customer.getOrgName().split(",");
        String[] orgCodeSplit = customer.getOrgCode().split(",");
        String[] prv11CodeSplit = customer.getPrv11Code().split(",");
        String[] prv11NameSplit = customer.getPrv11Name().split(",");
        umUserinfoapplyDomain.setUserinfoDischannelcode(customer.getPrv1Name());
        umUserinfoapplyDomain.setUserinfoChannelname(orgNameSplit[0]);
        umUserinfoapplyDomain.setUserinfoChannelcode(orgCodeSplit[0]);
        umUserinfoapplyDomain.setDepartCode(prv11CodeSplit[0]);
        umUserinfoapplyDomain.setDepartName(prv11NameSplit[0]);
        umUserinfoapplyDomain1.setUserinfoDischannelcode(customer.getPrv13Name());
        umUserinfoapplyDomain1.setUserinfoChannelname(orgNameSplit[1]);
        umUserinfoapplyDomain1.setUserinfoChannelcode(orgCodeSplit[1]);
        umUserinfoapplyDomain1.setDepartCode(prv11CodeSplit[1]);
        umUserinfoapplyDomain1.setDepartName(prv11NameSplit[1]);
        return upList;
    }

    private String getStringlocalDateTimeBy(LocalDateTime time) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(time);
    }

    private String getStringlocalDateTime() {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime time = LocalDateTime.now();
        return df.format(time);
    }

    private LocalDateTime getLocalDateTime(String datetimeStr) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return LocalDateTime.parse(datetimeStr, df);
    }

    @Override
    public String sendSaveBusUserinfoBuyPreviewSeal(String tenantCode, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal", (Object)tenantCode);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.ex");
        }
        String url = BusUserServiceImpl.getDdFlag(tenantCode, "PreviewSeal", "PreviewSeal");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (StringUtils.isBlank((String)url)) {
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.ex");
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        Long startTime = System.currentTimeMillis();
        String data = "{\"msg\":\"\u64cd\u4f5c\u6210\u529f\",\"code\":200,\"data\":{\"sealImageContent\":\"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\",\"imageExtension\":\"png\"}}\n";
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.ex2");
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return returnResultsMap.get("data").toString();
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.ex3");
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.ex4");
    }

    private static Date getDate() {
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(1, 10);
        Date dateAfterTenYears = calendar.getTime();
        return dateAfterTenYears;
    }

    public static String getMessage(String code) {
        switch (code) {
            case "qyht": {
                return "circle";
            }
            case "qygz": {
                return "circle";
            }
            case "qyfr": {
                return "square";
            }
        }
        return code;
    }

    public static void main222(String[] args) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("haccid", "256");
        header.put("hacckey", "97269a9502214c11bcf91b33a15c71c6");
        Long startTime = System.currentTimeMillis();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", "1");
        String data = null;
        String url = "https://testinterfacem.hbisscm.com/inf/internal/v1/user/queryUserInfo  ";
        url = url + "?" + JsonUtil.buildNormalBinder().toJson(map);
        System.out.println(url);
        data = OkhttpsUtils.doGet(url, JsonUtil.buildNormalBinder().toJson(map), header);
    }

    private String checkCpRechargeDomainParameter(CpRechargeDomain cpRechargeDomain) {
        if (StringUtils.isEmpty((String)cpRechargeDomain.getRechargeType())) {
            return "\u7968\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtils.isEmpty((Object)cpRechargeDomain.getGmtCreate())) {
            return "\u6536\u6b3e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtils.isEmpty((Object)cpRechargeDomain.getRechargeMoney())) {
            return "\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtils.isEmpty((Object)cpRechargeDomain.getRechargeMode())) {
            return "\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if ("1".equals(cpRechargeDomain.getRechargeMode()) && ObjectUtils.isEmpty((Object)cpRechargeDomain.getReceipt())) {
            return "\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u94f6\u884c\u8f6c\u8d26\u65f6\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!"1".equals(cpRechargeDomain.getRechargeType()) && !"2".equals(cpRechargeDomain.getRechargeType())) {
            return "\u6839\u636e\u7968\u636e\u7c7b\u578b\u3010" + cpRechargeDomain.getRechargeType() + "\u3011\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u63a5\u53e3\u5730\u5740\uff0c\u8bf7\u68c0\u67e5!";
        }
        return null;
    }

    @Override
    public String sendRecharge(CpRechargeDomain cpRechargeDomain) throws ApiException {
        HashMap<String, Object> param;
        ArrayList paramList;
        Map<String, String> context;
        String msg = this.checkCpRechargeDomainParameter(cpRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendRecharge.msg", (Object)msg);
            throw new ApiException(msg);
        }
        logger.info(this.SYS_CODE + ".sendRecharge", (Object)JsonUtil.buildNormalBinder().toJson((Object)cpRechargeDomain));
        String url = "";
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if ("1".equals(cpRechargeDomain.getRechargeType())) {
            url = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9Domain", "AkanU9Domain") + "/U9/RestServices/Cust.Akan.U9.APISV.ICust_AkanSV.svc/Do";
            dataMap = new HashMap();
            context = BusUserServiceImpl.getContextMap(cpRechargeDomain.getOrganizationalCode(), BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9EntCode", "AkanU9EntCode"));
            dataMap.put("context", context);
            dataMap.put("aPIType", "Voucher_Create");
            paramList = new ArrayList();
            param = new HashMap<String, Object>();
            param.put("Key", cpRechargeDomain.getRechargeCode());
            param.put("BusinessDate", new SimpleDateFormat("yyyy-MM-dd").format(cpRechargeDomain.getGmtCreate()));
            param.put("Qty", "0");
            param.put("Prv1", cpRechargeDomain.getReceiveNo());
            param.put("Prv2", cpRechargeDomain.getRechargeCategory());
            param.put("VoucherSourceMethod", "0");
            param.put("MainSOB", cpRechargeDomain.getOrganizationalCode());
            param.put("DocType", "01");
            ArrayList lineDTO = new ArrayList();
            HashMap<String, Object> line1 = new HashMap<String, Object>();
            line1.put("Account", "51010601|0|0|0|0|0|0|0|0|0|0|0|01002");
            line1.put("EnteredCr", "0");
            line1.put("AccountedDr", cpRechargeDomain.getAmountMoney());
            line1.put("Abstracts", cpRechargeDomain.getAmountMoney());
            lineDTO.add(line1);
            param.put("LineDTO", lineDTO);
            paramList.add(param);
            dataMap.put("paramList", paramList);
        } else if ("2".equals(cpRechargeDomain.getRechargeType())) {
            dataMap = new HashMap();
            context = BusUserServiceImpl.getContextMap(cpRechargeDomain.getOrganizationalCode(), BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9EntCode", "AkanU9EntCode"));
            dataMap.put("context", context);
            dataMap.put("cust", "AKan");
            url = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9Domain", "AkanU9Domain") + "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
            dataMap.put("aPIType", "RecAR_Create");
            paramList = new ArrayList();
            param = new HashMap();
            param.put("IMSKey", cpRechargeDomain.getRechargeId());
            param.put("IMSLineKey", cpRechargeDomain.getRechargeId());
            String docType = "";
            if ("1".equals(cpRechargeDomain.getRechargeType())) {
                docType = "001";
            } else if ("2".equals(cpRechargeDomain.getRechargeType())) {
                docType = "002";
            }
            param.put("DocType", docType);
            param.put("BusinessDate", new SimpleDateFormat("yyyy-MM-dd").format(cpRechargeDomain.getGmtCreate()));
            param.put("CustCode", cpRechargeDomain.getUserinfoCode());
            param.put("SettlementMethod", cpRechargeDomain.getRechargeMode());
            param.put("RecBkAccount", cpRechargeDomain.getReceipt());
            param.put("NoteNo", cpRechargeDomain.getRechargeOpcode6());
            param.put("Prv4", cpRechargeDomain.getRechargeOpcode1());
            param.put("Prv3", cpRechargeDomain.getReceiveNo());
            ArrayList subLineDTOS = new ArrayList();
            HashMap<String, Object> subLine = new HashMap<String, Object>();
            subLine.put("Money", cpRechargeDomain.getAmountMoney());
            subLine.put("Property", cpRechargeDomain.getRechargeOpcode2());
            subLine.put("SettlementFee", cpRechargeDomain.getBankcommissionMoney());
            subLineDTOS.add(subLine);
            param.put("SubLineDTOS", subLineDTOS);
            paramList.add(param);
            dataMap.put("paramList", paramList);
        }
        System.out.println(dataMap);
        if (StringUtils.isBlank((String)url)) {
            throw new ApiException(this.SYS_CODE + ".sendRecharge.ex", "\u6839\u636e\u7968\u636e\u7c7b\u578b\u3010" + cpRechargeDomain.getRechargeType() + "\u3011\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u63a5\u53e3\u5730\u5740\uff0c\u8bf7\u68c0\u67e5!");
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(cpRechargeDomain.getTenantCode());
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(dataMap), header, "busdata.exUser.sendRecharge");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendRecharge.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(header), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendRecharge.ex1", (Throwable)e);
        }
        Long startTime = System.currentTimeMillis();
        logger.error(this.SYS_CODE + ".sendRecharge.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(dataMap) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendRecharge.returnResultsMap" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendRecharge.ex2");
        }
        Object code = returnResultsMap.get("d");
        if (null != code) {
            String dStr = JsonUtil.buildNormalBinder().toJson(code);
            List list = JsonUtil.buildNormalBinder().getJsonToList(dStr, Map.class);
            Map returnResultsObjMap = (Map)list.get(0);
            String code1 = (String)returnResultsObjMap.get("Flag");
            if ("True".equals(code1)) {
                String docNo = (String)returnResultsObjMap.get("DocNo");
                String apiCode = "cp.recharge.updateRecharge";
                CpRechargeDomain cpRechargeUpdateDomain = new CpRechargeDomain();
                cpRechargeUpdateDomain.setRechargeId(cpRechargeDomain.getRechargeId());
                cpRechargeUpdateDomain.setRechargeOpcode(docNo);
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("cpRechargeDomain", JsonUtil.buildNormalBinder().toJson((Object)cpRechargeUpdateDomain));
                String returnCode = "";
                try {
                    returnCode = this.internalInvoke(apiCode, paramMap);
                }
                catch (Exception e) {
                    logger.error(this.SYS_CODE + ".cp.recharge.saveRecharge.param", (Object)JsonUtil.buildNormalBinder().toJson(paramMap), (Throwable)e);
                    throw new ApiException("saveCpRecharge\u4fdd\u5b58\u5145\u503c\u6d41\u6c34\u5931\u8d25");
                }
                return returnCode;
            }
            logger.error(this.SYS_CODE + ".sendRecharge.code" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".sendRecharge.ex3");
        }
        logger.error(this.SYS_CODE + ".sendRecharge.code.1" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendRecharge.ex4");
    }

    @Override
    public String sendDelRecharge(CpRechargeDomain cpRechargeDomain) throws ApiException {
        if (ObjectUtils.isEmpty((Object)cpRechargeDomain)) {
            throw new ApiException("cpRechargeDomain\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)cpRechargeDomain.getRechargeOpcode())) {
            throw new ApiException("rechargeOpcode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.info(this.SYS_CODE + ".sendDelRecharge", (Object)JsonUtil.buildNormalBinder().toJson((Object)cpRechargeDomain));
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        String url = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9Domain", "AkanU9Domain") + "/U9/RestServices/UFIDA.U9.Cust.CAIJAI.CAIJAIU9SV.ICAIJAIU9SV.svc/Do";
        dataMap = new HashMap();
        Map<String, String> context = BusUserServiceImpl.getContextMap(cpRechargeDomain.getOrganizationalCode(), BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanU9EntCode", "AkanU9EntCode"));
        dataMap.put("context", context);
        dataMap.put("aPIType", "RecAR_Delete");
        ArrayList paramList = new ArrayList();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("DocNo", cpRechargeDomain.getRechargeOpcode());
        paramList.add(param);
        dataMap.put("paramList", paramList);
        System.out.println(dataMap);
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(cpRechargeDomain.getTenantCode());
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(dataMap), header, "busdata.exUser.sendDelRecharge");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendDelRecharge.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(header), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendDelRecharge.ex1", (Throwable)e);
        }
        Long startTime = System.currentTimeMillis();
        logger.error(this.SYS_CODE + ".sendDelRecharge.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(dataMap) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendDelRecharge.returnResultsMap" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendDelRecharge.ex2");
        }
        Object code = returnResultsMap.get("d");
        if (null != code) {
            String dStr = JsonUtil.buildNormalBinder().toJson(code);
            List list = JsonUtil.buildNormalBinder().getJsonToList(dStr, Map.class);
            Map returnResultsObjMap = (Map)list.get(0);
            String code1 = (String)returnResultsObjMap.get("Flag");
            if ("True".equals(code1)) {
                String message = (String)returnResultsObjMap.get("Message");
                return message;
            }
            logger.error(this.SYS_CODE + ".sendDelRecharge.code" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".sendDelRecharge.ex3");
        }
        logger.error(this.SYS_CODE + ".sendDelRecharge.code.1" + url + "dataMap" + JsonUtil.buildNormalBinder().toJson(dataMap), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendDelRecharge.ex4");
    }

    public static Map<String, String> getContextMap(String OrgCode, String entCode) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("CultureName", "zh-CN");
        context.put("OrgCode", OrgCode);
        context.put("UserCode", "AKAN000083");
        context.put("EntCode", entCode);
        return context;
    }

    @Override
    public String sendCjReFundInfo(String payDate) throws ApiException {
        if (StringUtils.isBlank((String)payDate)) {
            logger.error(this.SYS_CODE + ".sendCjReFundInfo.payDate", (Object)"payDate is null");
            throw new ApiException("payDate is null");
        }
        InternalRouter internalRouter = this.getInternalRouter();
        if (null == internalRouter) {
            logger.error(this.SYS_CODE + ".sendCjReFundInfo.internalRouter", (Object)"internalRouter is null");
            return "internalRouter is null";
        }
        boolean initialFlag = false;
        List<CpRechargeFromU9Domain> refundinfoFromU9 = null;
        try {
            refundinfoFromU9 = this.queryCjReFundInfoFromU9("SELECT\n\tCreatedBy rechargeUname,\n\tCreatedOn ,\n\tPayDate gmtCreate,\n\tDocNo rechargeOpcode,\n\tCust_Code userinfoCode,\n\tCust_Name userinfoName,\n\tOrg_Code organizationalCode,\n\tOrg_Name organizationalName,\n\tMoney_FCMoney rechargeMoney,\n\tSettlementFee_FCMoney bankcommissionMoney,\n\tTotalMoney_FCMoney amountMoney,\n\tPayProperty rechargeOpcode2,\n\tMemo \nFROM\n\tCJ_V_ReFundInfo \n\twhere PayDate >= ? ", initialFlag, payDate);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".sendCjReFundInfo.CJ_V_ReFundInfo", (Object)("\u89c6\u56fe\u6709\u95ee\u9898+e: " + e));
            throw new ApiException("sql is error");
        }
        if (ListUtil.isNotEmpty(refundinfoFromU9)) {
            this.saveCpRecharge(refundinfoFromU9);
            logger.info(this.SYS_CODE + ".sendCjReFundInfo.refundinfoFromU9===>", JSON.toJSON(refundinfoFromU9));
        }
        return this.makeSuccessReturn("\u9000\u6b3e\u5230\u5ba2\u6237\u94f6\u884c\u5361\u62c9\u53d6\u6210\u529f!");
    }

    @Override
    public String sendCjCjFundAdjustment(String accrueDate) throws ApiException {
        if (StringUtils.isBlank((String)accrueDate)) {
            logger.error(this.SYS_CODE + ".sendCjCjFundAdjustment.accrueDate", (Object)"accrueDate is null");
            throw new ApiException("payDate is null");
        }
        InternalRouter internalRouter = this.getInternalRouter();
        if (null == internalRouter) {
            logger.error(this.SYS_CODE + ".sendCjCjFundAdjustment.internalRouter", (Object)"internalRouter is null");
            return "internalRouter is null";
        }
        String tenantCode = "";
        boolean initialFlag = false;
        List<CpRechargeFromU9Domain> fundAdjustmentFromU9 = null;
        try {
            fundAdjustmentFromU9 = this.queryCjCjFundAdjustmentFromU9("SELECT\n\tAccrueDate gmtCreate,\n\tCurrency_Code ddTypeCurrency,\n\tCurrency_Name,\n\tARFCMoney_TotalMoney rechargeMoney,\n\tTypeName rechargeType,\n\tAccrueCust_Code userinfoCode,\n\tAccrueCust_Name userinfoName,\n\tOrg_Code organizationalCode,\n\tOrg_Name organizationalName,\n\tMemo rechargeOpcode4,\n\tCreatedBy  rechargeUname\nFROM\n\tCJ_V_FundAdjustment\n\twhere AccrueDate >= ? \n", initialFlag, accrueDate);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".sendCjCjFundAdjustment.CJ_V_FundAdjustment", (Object)("\u89c6\u56fe\u6709\u95ee\u9898+e: " + e));
            throw new ApiException("sql is error");
        }
        if (ListUtil.isNotEmpty(fundAdjustmentFromU9)) {
            this.saveCpRecharge(fundAdjustmentFromU9);
        }
        return this.makeSuccessReturn("\u8d44\u91d1\u8c03\u6574\u62c9\u53d6\u6210\u529f!");
    }

    protected String saveCpRecharge(List<CpRechargeFromU9Domain> cpRechargeDomainList) {
        if (null == cpRechargeDomainList) {
            logger.error(this.SYS_CODE + ".saveCpRecharge.cpRechargeDomainList");
            throw new ApiException("cpRechargeDomainList\u53c2\u6570\u4e3a\u7a7a");
        }
        String apiCode = "cp.recharge.saveRecharge";
        for (CpRechargeFromU9Domain cpRechargeFromU9Domain : cpRechargeDomainList) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("cpRechargeDomain", JsonUtil.buildNormalBinder().toJson((Object)this.checkCpRechargeFromU9Domain(cpRechargeFromU9Domain)));
            String code = "";
            try {
                code = this.internalInvoke(apiCode, paramMap);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".cp.recharge.saveRecharge.param", (Object)JsonUtil.buildNormalBinder().toJson(paramMap), (Throwable)e);
                throw new ApiException("saveCpRecharge\u4fdd\u5b58\u5145\u503c\u6d41\u6c34\u5931\u8d25");
            }
            System.out.println(code);
        }
        return "success";
    }

    private CpRechargeFromU9Domain checkCpRechargeFromU9Domain(CpRechargeFromU9Domain cpRechargeFromU9Domain) {
        cpRechargeFromU9Domain.setTenantCode(ComConstants.tenantCode);
        cpRechargeFromU9Domain.setFaccountId("20010010011000021039739401101011");
        cpRechargeFromU9Domain.setFchannelCode("sunbaojin");
        cpRechargeFromU9Domain.setRechargeType("1");
        return cpRechargeFromU9Domain;
    }

    private List<CpRechargeFromU9Domain> queryCjReFundInfoFromU9(String sql, boolean initialFlag, Object ... args) throws Exception {
        List<CpRechargeFromU9Domain> queryResult = null;
        String returnMsg = initialFlag ? "\u521d\u59cb\u5316\u89c6\u56fe\u4e3a\u7a7a" : "\u65b0\u589e\u6216\u8005\u4fee\u6539\u89c6\u56fe\u4e3a\u7a7a";
        try {
            queryResult = SqlServerUtils.getForList(CpRechargeFromU9Domain.class, sql, args);
            logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.queryU9", (Object)"\u67e5\u8be2U9\u5e93\u5b58\u6570\u636e\u7ed3\u675f");
            logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.whs.size", (Object)queryResult.size());
            if (ListUtil.isEmpty(queryResult)) {
                logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.queryU9", (Object)"\u67e5\u8be2U9\u5e93\u5b58\u6570\u636e\u4e3a\u7a7a");
                throw new RuntimeException(returnMsg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.view", (Object)"\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
            throw new RuntimeException("\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
        }
        return queryResult;
    }

    private List<CpRechargeFromU9Domain> queryCjCjFundAdjustmentFromU9(String sql, boolean initialFlag, Object ... args) throws Exception {
        List<CpRechargeFromU9Domain> queryResult = null;
        String returnMsg = initialFlag ? "\u521d\u59cb\u5316\u89c6\u56fe\u4e3a\u7a7a" : "\u65b0\u589e\u6216\u8005\u4fee\u6539\u89c6\u56fe\u4e3a\u7a7a";
        try {
            queryResult = SqlServerUtils.getForList(CpRechargeFromU9Domain.class, sql, args);
            logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.queryU9", (Object)"\u67e5\u8be2U9\u5e93\u5b58\u6570\u636e\u7ed3\u675f");
            logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.whs.size", (Object)queryResult.size());
            if (ListUtil.isEmpty(queryResult)) {
                logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.queryU9", (Object)"\u67e5\u8be2U9\u5e93\u5b58\u6570\u636e\u4e3a\u7a7a");
                throw new RuntimeException(returnMsg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.view", (Object)"\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
            throw new RuntimeException("\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
        }
        return queryResult;
    }

    @Override
    public String sendSmsByYimai(Map<String, Object> paramMap) throws ApiException {
        if (MapUtil.isEmpty(paramMap)) {
            throw new ApiException(this.SYS_CODE + ".sendSmsByYimai.paramMap\u53c2\u6570\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)paramMap.get("accessKeyId"))) {
            throw new ApiException(this.SYS_CODE + ".sendSmsByYimai.accessKeyId\u53c2\u6570\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)paramMap.get("accessKeySecret"))) {
            throw new ApiException(this.SYS_CODE + ".sendSmsByYimai.accessKeySecret\u53c2\u6570\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)paramMap.get("content"))) {
            throw new ApiException(this.SYS_CODE + ".sendSmsByYimai.content\u53c2\u6570\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)paramMap.get("phone"))) {
            throw new ApiException(this.SYS_CODE + ".sendSmsByYimai.phone\u53c2\u6570\u4e3a\u7a7a");
        }
        String appId = (String)paramMap.get("accessKeyId");
        String secretKey = (String)paramMap.get("accessKeySecret");
        String content = (String)paramMap.get("content");
        String phone = (String)paramMap.get("phone");
        String host = "http://www.btom.cn:8080";
        String algorithm = "AES/ECB/PKCS5Padding";
        String encode = "UTF-8";
        boolean isGizp = true;
        String smsId = this.setSingleSms(appId, secretKey, host, algorithm, content, UUID.randomUUID().toString(), null, phone, isGizp, encode);
        return smsId;
    }

    private String setSingleSms(String appId, String secretKey, String host, String algorithm, String content, String customSmsId, String extendCode, String mobile, boolean isGzip, String encode) {
        SmsResponse response;
        System.out.println("=============begin setSingleSms==================");
        SmsSingleRequest pamars = new SmsSingleRequest();
        pamars.setContent(content);
        pamars.setCustomSmsId(customSmsId);
        pamars.setMobile(mobile);
        ResultModel result = BusUserServiceImpl.request(appId, secretKey, algorithm, pamars, host + "/inter/sendSingleSMS", isGzip, encode);
        System.out.println("result code :" + result.getCode());
        String smsId = "";
        if ("SUCCESS".equals(result.getCode()) && (response = (SmsResponse)JsonUtil.buildNormalBinder().getJsonToObject(result.getResult(), SmsResponse.class)) != null) {
            smsId = response.getSmsId();
            System.out.println("data : " + response.getMobile() + "," + response.getSmsId() + "," + response.getCustomSmsId());
        }
        System.out.println("=============end setSingleSms==================");
        return smsId;
    }

    public static ResultModel request(String appId, String secretKey, String algorithm, Object content, String url, boolean isGzip, String encode) {
        HashMap<String, String> headers = new HashMap<String, String>();
        HttpRequest request = null;
        try {
            headers.put("appId", appId);
            headers.put("encode", encode);
            String requestJson = JsonUtil.buildNormalBinder().toJson(content);
            System.out.println("result json: " + requestJson);
            byte[] bytes = requestJson.getBytes(encode);
            System.out.println("request data size : " + bytes.length);
            if (isGzip) {
                headers.put("gzip", "on");
                bytes = GZIPUtils.compress(bytes);
                System.out.println("request data size [com]: " + bytes.length);
            }
            byte[] parambytes = AES.encrypt(bytes, secretKey.getBytes(), algorithm);
            System.out.println("request data size [en] : " + parambytes.length);
            HttpRequestParams<byte[]> params = new HttpRequestParams<byte[]>();
            params.setCharSet("UTF-8");
            params.setMethod("POST");
            params.setHeaders(headers);
            params.setParams(parambytes);
            params.setUrl(url);
            request = url.startsWith("https://") ? new HttpsRequestBytes(params, null) : new HttpRequestBytes(params);
        }
        catch (Exception e) {
            System.out.println("\u52a0\u5bc6\u5f02\u5e38");
            e.printStackTrace();
        }
        HttpClient client = new HttpClient();
        String code = null;
        String result = null;
        try {
            HttpResponseBytes res = client.service(request, new HttpResponseBytesPraser());
            if (res == null) {
                System.out.println("\u8bf7\u6c42\u63a5\u53e3\u5f02\u5e38");
                return new ResultModel(code, result);
            }
            if (res.getResultCode().equals((Object)HttpResultCode.SUCCESS)) {
                if (res.getHttpCode() == 200) {
                    code = res.getHeaders().get("result");
                    if (code.equals("SUCCESS")) {
                        byte[] data = (byte[])res.getResult();
                        System.out.println("response data size [en and com] : " + data.length);
                        data = AES.decrypt(data, secretKey.getBytes(), algorithm);
                        if (isGzip) {
                            data = GZIPUtils.decompress(data);
                        }
                        System.out.println("response data size : " + data.length);
                        result = new String(data, encode);
                        System.out.println("response json: " + result);
                    }
                } else {
                    System.out.println("\u8bf7\u6c42\u63a5\u53e3\u5f02\u5e38,\u8bf7\u6c42\u7801:" + res.getHttpCode());
                }
            } else {
                System.out.println("\u8bf7\u6c42\u63a5\u53e3\u7f51\u7edc\u5f02\u5e38:" + res.getResultCode().getCode());
            }
        }
        catch (Exception e) {
            System.out.println("\u89e3\u6790\u5931\u8d25");
            e.printStackTrace();
        }
        ResultModel re = new ResultModel(code, result);
        return re;
    }

    @Override
    public String sendCpRechargeForNingbo(Map<String, Object> paramMap) throws ApiException {
        if (MapUtil.isEmpty(paramMap)) {
            throw new ApiException(this.SYS_CODE + ".sendSmsByYimai.paramMap\u53c2\u6570\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)paramMap.get("accessKeyId"))) {
            throw new ApiException(this.SYS_CODE + ".sendSmsByYimai.accessKeyId\u53c2\u6570\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)paramMap.get("accessKeySecret"))) {
            throw new ApiException(this.SYS_CODE + ".sendSmsByYimai.accessKeySecret\u53c2\u6570\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)paramMap.get("content"))) {
            throw new ApiException(this.SYS_CODE + ".sendSmsByYimai.content\u53c2\u6570\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)paramMap.get("phone"))) {
            throw new ApiException(this.SYS_CODE + ".sendSmsByYimai.phone\u53c2\u6570\u4e3a\u7a7a");
        }
        String appkey = "54b3e05c-7983-4e6c-8920-f9ab8a0004a6";
        String serviceID = "queryAccount";
        String dataJson = "{\"Data\":{\"beginDate\":\"2021-04-26\",\"bankAccList\":[\"10551101040008228\",\"80010122000023281\",\"75150122000020213\",\"8112001012300545662\",\"802000070389888\n\"],\"endDate\":\"2021-04-26\",\"custId\":\"9000077749\",\"pageSize\":\"5\",\"currentPage\":\"1\",\"queryType\":\"0\"}}";
        String res = null;
        try {
            res = OpenSDK.send((String)appkey, (String)serviceID, (String)dataJson);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "";
    }

    public String cpMd5(long timestamp) {
        String akanEhrSecretCode = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanEhrSecretCode", "AkanEhrSecretCode");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("Code", "");
        map.put("SignDateTime", timestamp + "");
        map.put("secretCode", akanEhrSecretCode);
        String jsonString = JSONObject.toJSONString(map);
        String md5Hash = BusUserServiceImpl.calculateMD5(jsonString);
        return md5Hash;
    }

    private static String calculateMD5(String input) {
        try {
            MessageDigest md = null;
            md = MessageDigest.getInstance("MD5");
            byte[] hashBytes = md.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm not found", e);
        }
    }

    private List<CpEmployee> queryCpEmployees() {
        String ehrEmployeesUrl = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanEhrUrl", "AkanEhrUrl") + "/api/employees";
        long timestamp = System.currentTimeMillis() / 1000L;
        String sign = this.cpMd5(timestamp);
        String param = "?SignDateTime=" + timestamp + "&Sign=" + sign;
        String data = null;
        try {
            data = ((cn.hutool.http.HttpRequest)cn.hutool.http.HttpRequest.get((String)(ehrEmployeesUrl + param)).header("Content-Type", "application/json")).timeout(200000).setConnectionTimeout(200000).setReadTimeout(200000).execute().body();
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".queryEmployeesFormEHR.isnull" + ehrEmployeesUrl, (Throwable)e);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u5458\u5de5\u4fe1\u606f\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)data)) {
            logger.error(this.SYS_CODE + ".queryEmployeesFormEHR.dataisnull" + ehrEmployeesUrl, (Object)param);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u5458\u5de5\u4fe1\u606f\u5931\u8d251");
        }
        CpEmployeeRes cpEmployeeRes = (CpEmployeeRes)JsonUtil.buildNonDefaultBinder().getJsonToObject(data, CpEmployeeRes.class);
        if (!"200".equals(cpEmployeeRes.getStatus())) {
            logger.error(this.SYS_CODE + ".queryEmployeesFormEHR.status.ERROR" + ehrEmployeesUrl, (Object)data);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u5458\u5de5\u4fe1\u606f\u5931\u8d252");
        }
        List<CpEmployee> list = new ArrayList<CpEmployee>();
        if (cpEmployeeRes.getData() != null && !CollectionUtils.isEmpty(cpEmployeeRes.getData().getEmployees())) {
            list = cpEmployeeRes.getData().getEmployees();
        }
        return list;
    }

    private Map<String, String> queryCpPosition() {
        String ehrEmployeesUrl = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanEhrUrl", "AkanEhrUrl") + "/api/positions";
        long timestamp = System.currentTimeMillis() / 1000L;
        String sign = this.cpMd5(timestamp);
        String param = "?SignDateTime=" + timestamp + "&Sign=" + sign;
        String data = null;
        try {
            data = ((cn.hutool.http.HttpRequest)cn.hutool.http.HttpRequest.get((String)(ehrEmployeesUrl + param)).header("Content-Type", "application/json")).timeout(200000).setConnectionTimeout(200000).setReadTimeout(200000).execute().body();
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".queryCpPosition.isnull" + ehrEmployeesUrl, (Throwable)e);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)data)) {
            logger.error(this.SYS_CODE + ".queryCpPosition.dataisnull" + ehrEmployeesUrl, (Object)param);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
        CpPositionRes cpPositionRes = (CpPositionRes)JsonUtil.buildNonDefaultBinder().getJsonToObject(data, CpPositionRes.class);
        if (!"200".equals(cpPositionRes.getStatus())) {
            logger.error(this.SYS_CODE + ".queryCpPosition.status.ERROR" + ehrEmployeesUrl, (Object)data);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u5931\u8d252");
        }
        Map<String, String> map = new HashMap<String, String>();
        if (cpPositionRes.getData() != null && !CollectionUtils.isEmpty(cpPositionRes.getData().getPositions())) {
            map = cpPositionRes.getData().getPositions().stream().collect(Collectors.toMap(u -> u.getCode(), u -> u.getName()));
        }
        return map;
    }

    private Map<String, String> queryCpOrg() {
        String ehrEmployeesUrl = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "AkanEhrUrl", "AkanEhrUrl") + "/api/organizations";
        long timestamp = System.currentTimeMillis() / 1000L;
        String sign = this.cpMd5(timestamp);
        String param = "SignDateTime=" + timestamp + "&Sign=" + sign;
        String data = null;
        try {
            data = ((cn.hutool.http.HttpRequest)cn.hutool.http.HttpRequest.get((String)(ehrEmployeesUrl + param)).header("Content-Type", "application/json")).timeout(200000).setConnectionTimeout(200000).setReadTimeout(200000).execute().body();
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".queryCpOrg.isnull" + ehrEmployeesUrl, (Throwable)e);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)data)) {
            logger.error(this.SYS_CODE + ".queryCpOrg.dataisnull" + ehrEmployeesUrl, (Object)param);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d251");
        }
        CpOrgRes cpOrgRes = (CpOrgRes)JsonUtil.buildNonDefaultBinder().getJsonToObject(data, CpOrgRes.class);
        if (!"200".equals(cpOrgRes.getStatus())) {
            logger.error(this.SYS_CODE + ".queryCpOrg.status.ERROR" + ehrEmployeesUrl, (Object)data);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d252");
        }
        Map<String, String> map = new HashMap<String, String>();
        if (cpOrgRes.getData() != null && !CollectionUtils.isEmpty(cpOrgRes.getData().getOrganizations())) {
            map = cpOrgRes.getData().getOrganizations().stream().collect(Collectors.toMap(u -> u.getCode(), u -> u.getName()));
        }
        return map;
    }

    @Override
    public String queryEmployeesFormEHR(String tenantCode) throws ApiException {
        List<CpEmployee> employeeList = this.queryCpEmployees();
        if (CollectionUtils.isEmpty(employeeList)) {
            throw new ApiException(this.SYS_CODE + "\u5458\u5de5\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Map<String, String> positionMap = this.queryCpPosition();
        Map<String, String> orgMap = this.queryCpOrg();
        CpEmployee employeeInfo = employeeList.get(0);
        OrgEmployeeDomain orgEmployeeDomain = new OrgEmployeeDomain();
        orgEmployeeDomain.setEmployeeOcode(employeeInfo.getCode());
        orgEmployeeDomain.setEmployeeName(employeeInfo.getName());
        orgEmployeeDomain.setEmployeePhone(employeeInfo.getTelephone());
        orgEmployeeDomain.setEmployeeRole(orgMap.get(employeeInfo.getOrg_code()));
        orgEmployeeDomain.setPositionName(positionMap.get(employeeInfo.getPosition_code()));
        orgEmployeeDomain.setEmployeeShortcode(employeeInfo.getWechat_id());
        orgEmployeeDomain.setTenantCode(tenantCode);
        if ("1".equals(employeeInfo.getEhr_status())) {
            orgEmployeeDomain.setDataState("0");
        } else {
            orgEmployeeDomain.setDataState("-1");
        }
        String sendOrgEmployeeDomain = "org.ChannelsendBase.sendSaveEmployee";
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("orgEmployeeDomain", JsonUtil.buildNormalBinder().toJson((Object)orgEmployeeDomain));
        try {
            this.getInternalRouter().inInvoke(sendOrgEmployeeDomain, pmap);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(employeeInfo.getCode() + ".addEmployeeInfo.pmap", (Object)(JsonUtil.buildNormalBinder().toJson(pmap) + ": \u65b0\u589e\u5458\u5de5\u6570\u636e\u5931\u8d25"));
            throw new ApiException(employeeInfo.getCode() + "\u65b0\u589e\u5458\u5de5\u6570\u636e\u5931\u8d25");
        }
        return "success";
    }

    public String addEmployeeInfo(EmployeeInfo employeeInfo) throws ApiException {
        if (StringUtils.isBlank((String)employeeInfo.getCode())) {
            throw new ApiException("\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)employeeInfo.getName())) {
            throw new ApiException("\u771f\u5b9e\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)employeeInfo.getEhrStatus())) {
            throw new ApiException("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"1".equals(employeeInfo.getEhrStatus()) && !"-1".equals(employeeInfo.getEhrStatus())) {
            throw new ApiException("\u72b6\u6001\u503c\u5f02\u5e38");
        }
        QueryResult<OrgEmployee> qlist = this.queryEmployeePagePage(this.getQueryMapParam("employeeOcode", new Object[]{employeeInfo.getCode()}));
        logger.error("qlist", (Object)JsonUtil.buildNormalBinder().toJson(qlist));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            throw new ApiException(employeeInfo.getCode() + "\u5458\u5de5\u4fe1\u606f\u5df2\u5b58\u5728");
        }
        OrgEmployeeDomain orgEmployeeDomain = new OrgEmployeeDomain();
        orgEmployeeDomain.setEmployeeOcode(employeeInfo.getCode());
        orgEmployeeDomain.setEmployeeName(employeeInfo.getName());
        orgEmployeeDomain.setEmployeePhone(employeeInfo.getTelePhone());
        orgEmployeeDomain.setEmployeeRole(employeeInfo.getOrgName());
        orgEmployeeDomain.setPositionName(employeeInfo.getPositionName());
        orgEmployeeDomain.setEmployeeShortcode(employeeInfo.getWechatID());
        orgEmployeeDomain.setTenantCode(ComConstants.tenantCode);
        if ("1".equals(employeeInfo.getEhrStatus())) {
            orgEmployeeDomain.setDataState("0");
        } else {
            orgEmployeeDomain.setDataState("-1");
        }
        String sendOrgEmployeeDomain = "org.ChannelsendBase.sendSaveEmployee";
        HashMap<String, OrgEmployeeDomain> pmap = new HashMap<String, OrgEmployeeDomain>();
        pmap.put("orgEmployeeDomain", orgEmployeeDomain);
        try {
            this.getInternalRouter().inInvoke(sendOrgEmployeeDomain, pmap);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(employeeInfo.getCode() + ".addEmployeeInfo.pmap", (Object)(JsonUtil.buildNormalBinder().toJson(pmap) + ": \u65b0\u589e\u5458\u5de5\u6570\u636e\u5931\u8d25"));
            throw new ApiException(employeeInfo.getCode() + "\u65b0\u589e\u5458\u5de5\u6570\u636e\u5931\u8d25");
        }
        return this.makeSuccessReturn(employeeInfo.getCode() + "\u65b0\u589e\u5458\u5de5\u6570\u636e\u6210\u529f");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> queryOrganizationsFormEHR(String tenantCode) throws ApiException {
        HashMap<String, String> resultMap = null;
        String ehrOrganizationsUrl = BusUserServiceImpl.getDdFlag(tenantCode, "AkanEhrUrl", "AkanEhrUrl") + "/api/organizations";
        String param = "todo";
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        String data = null;
        try {
            data = OkhttpsUtils.doGet(ehrOrganizationsUrl, param, header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".queryOrganizationsFormEHR.isnull" + ehrOrganizationsUrl, (Throwable)e);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25");
        }
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".queryOrganizationsFormEHR.returnResultsMap" + ehrOrganizationsUrl, (Object)data);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25");
        }
        Object code = returnResultsMap.get("message");
        if (null == code) {
            logger.error(this.SYS_CODE + ".queryOrganizationsFormEHR.code.1" + ehrOrganizationsUrl, (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25");
        }
        String code1 = (String)code;
        if (!"success".equals(code1)) {
            logger.error(this.SYS_CODE + ".queryOrganizationsFormEHR.code" + ehrOrganizationsUrl, (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25");
        }
        Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
        if (MapUtil.isNotEmpty((Map)returnResultsMap1)) {
            Object organizations = returnResultsMap1.get("Organizations");
            List organizationsList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(organizations), Map.class);
            if (ListUtil.isNotEmpty((Collection)organizationsList)) {
                resultMap = new HashMap<String, String>();
                for (Map map : organizationsList) {
                    resultMap.put((String)map.get("code"), (String)map.get("name"));
                }
            }
        }
        return resultMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> queryPositionsFormEHR(String tenantCode) throws ApiException {
        HashMap<String, String> resultMap = null;
        String ehrPositionsUrl = BusUserServiceImpl.getDdFlag(tenantCode, "AkanEhrUrl", "AkanEhrUrl") + "/api/positions";
        String param = "todo";
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        String data = null;
        try {
            data = OkhttpsUtils.doGet(ehrPositionsUrl, param, header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".queryPositionsFormEHR.isnull" + ehrPositionsUrl, (Throwable)e);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".queryPositionsFormEHR.returnResultsMap" + ehrPositionsUrl, (Object)data);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
        Object code = returnResultsMap.get("message");
        if (null == code) {
            logger.error(this.SYS_CODE + ".queryPositionsFormEHR.code.1" + ehrPositionsUrl, (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
        String code1 = (String)code;
        if (!"success".equals(code1)) {
            logger.error(this.SYS_CODE + ".queryPositionsFormEHR.code" + ehrPositionsUrl, (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
        Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
        if (MapUtil.isNotEmpty((Map)returnResultsMap1)) {
            Object positions = returnResultsMap1.get("Positions");
            List positionsList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(positions), Map.class);
            if (ListUtil.isNotEmpty((Collection)positionsList)) {
                resultMap = new HashMap<String, String>();
                for (Map map : positionsList) {
                    resultMap.put((String)map.get("code"), (String)map.get("name"));
                }
            }
        }
        return resultMap;
    }

    private String getTOaToken() throws Exception {
        return null;
    }

    public static String encrypt(String plainText) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        String fwAppSecret = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "FwSPK", "FwSPK");
        cipher.init(1, BusUserServiceImpl.getPublicKey(fwAppSecret));
        byte[] encryptedBytes = cipher.doFinal(plainText.getBytes());
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public static PublicKey getPublicKey(String publicKeyBase64) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(publicKeyBase64);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(keySpec);
    }

    @Override
    public String createWorkFlowToFw(Map<String, Object> paramMap) throws ApiException {
        String token = this.queryTokenFormFw();
        paramMap.put("token", token);
        return this.createPromitionToFw(paramMap);
    }

    private String createPromitionToFw(Map<String, Object> map) {
        String fwSpkUrl = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "FwUrl", "FwUrl") + "/api/workflow/paService/doCreateRequest";
        String fwAppId = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "FwAppId", "FwAppId");
        String userId = "";
        try {
            userId = BusUserServiceImpl.encrypt(String.valueOf(map.get("userId")));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".createPromitionToFw.rsafwSpkUrl::" + fwSpkUrl + "fwAppId:::" + fwAppId, (Throwable)e);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u6cdb\u5fae\u521b\u5efa\u52a0\u5bc6\u5931\u8d25");
        }
        String data = null;
        try {
            Map<Object, Object> dataMap = new HashMap();
            dataMap = "1".equals(map.get("type")) ? this.createPromition(map) : this.createCp(map);
            dataMap.put("requestName", map.get("requestName"));
            data = ((cn.hutool.http.HttpRequest)((cn.hutool.http.HttpRequest)((cn.hutool.http.HttpRequest)((cn.hutool.http.HttpRequest)cn.hutool.http.HttpRequest.post((String)fwSpkUrl).header("appid", fwAppId)).header("token", String.valueOf(map.get("token")))).header("userid", userId)).header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8")).form(dataMap).timeout(20000).execute().body();
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".createPromitionToFw.isnullfwSpkUrl::" + fwSpkUrl + "fwAppId:::" + fwAppId, (Throwable)e);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u6cdb\u5fae\u521b\u5efa\u6d41\u7a0b\u5931\u8d25");
        }
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, String.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".createPromitionToFw.returnResultsMapfwSpkUrl::" + fwSpkUrl + "fwAppId:::" + fwAppId, (Object)data);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u6cdb\u5fae\u521b\u5efa\u6d41\u7a0b\u5931\u8d25\u8fd4\u56de\u4e3a\u7a7a");
        }
        String code = (String)returnResultsMap.get("code");
        if (!"SUCCESS".equals(code)) {
            logger.error(this.SYS_CODE + ".createPromitionToFw.returnResultsMapfwSpkUrl::" + fwSpkUrl + "fwAppId:::" + fwAppId, (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u6cdb\u5fae\u521b\u5efa\u6d41\u7a0b\u5931\u8d25\u8fd4\u56decode\u4e0d\u4e3aSUCCESS");
        }
        Map sunReturnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap((String)returnResultsMap.get("data"), String.class, String.class);
        return (String)sunReturnResultsMap.get("requestid");
    }

    private Map<String, Object> createCp(Map<String, Object> map) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        String cpFlowId = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "FwCpflowId", "FwCpflowId");
        dataMap.put("workflowId", cpFlowId);
        ArrayList sunList = new ArrayList();
        HashMap<String, Object> sqrMap = new HashMap<String, Object>();
        sqrMap.put("fieldName", "sqr");
        sqrMap.put("fieldValue", map.get("sqr"));
        sunList.add(sqrMap);
        HashMap<String, Object> sqbmMap = new HashMap<String, Object>();
        sqbmMap.put("fieldName", "sqbm");
        sqbmMap.put("fieldValue", map.get("sqbm"));
        sunList.add(sqbmMap);
        HashMap<String, Object> sqrqMap = new HashMap<String, Object>();
        sqrqMap.put("fieldName", "sqrq");
        sqrqMap.put("fieldValue", map.get("sqrq"));
        sunList.add(sqrqMap);
        HashMap<String, Object> sqfbMap = new HashMap<String, Object>();
        sqfbMap.put("fieldName", "sqfb");
        sqfbMap.put("fieldValue", map.get("sqfb"));
        sunList.add(sqfbMap);
        HashMap<String, Object> lcbhMap = new HashMap<String, Object>();
        lcbhMap.put("fieldName", "lcbh");
        lcbhMap.put("fieldValue", map.get("lcbh"));
        sunList.add(lcbhMap);
        HashMap<String, Object> sfyhtMap = new HashMap<String, Object>();
        sfyhtMap.put("fieldName", "sfyht");
        sfyhtMap.put("fieldValue", map.get("sfyht"));
        sunList.add(sfyhtMap);
        HashMap<String, Object> qdMap = new HashMap<String, Object>();
        qdMap.put("fieldName", "qd");
        qdMap.put("fieldValue", map.get("qd"));
        sunList.add(qdMap);
        HashMap<String, Object> xyjeyMap = new HashMap<String, Object>();
        xyjeyMap.put("fieldName", "xyjey");
        xyjeyMap.put("fieldValue", map.get("xyjey"));
        sunList.add(xyjeyMap);
        HashMap<String, Object> omsljMap = new HashMap<String, Object>();
        omsljMap.put("fieldName", "omslj");
        omsljMap.put("fieldValue", map.get("omslj"));
        sunList.add(omsljMap);
        HashMap<String, Object> bzMap = new HashMap<String, Object>();
        bzMap.put("fieldName", "bz");
        bzMap.put("fieldValue", map.get("bz"));
        sunList.add(bzMap);
        dataMap.put("mainData", JsonUtil.buildNormalBinder().toJson(sunList));
        return dataMap;
    }

    private Map<String, Object> createPromition(Map<String, Object> map) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        String promitionFlowId = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "FwPromitionflowId", "FwPromitionflowId");
        dataMap.put("workflowId", promitionFlowId);
        ArrayList sunList = new ArrayList();
        HashMap<String, Object> sqrMap = new HashMap<String, Object>();
        sqrMap.put("fieldName", "sqr");
        sqrMap.put("fieldValue", map.get("sqr"));
        sunList.add(sqrMap);
        HashMap<String, Object> sqbmMap = new HashMap<String, Object>();
        sqbmMap.put("fieldName", "sqbm");
        sqbmMap.put("fieldValue", map.get("sqbm"));
        sunList.add(sqbmMap);
        HashMap<String, Object> sqrqMap = new HashMap<String, Object>();
        sqrqMap.put("fieldName", "sqrq");
        sqrqMap.put("fieldValue", map.get("sqrq"));
        sunList.add(sqrqMap);
        HashMap<String, Object> szqyMap = new HashMap<String, Object>();
        szqyMap.put("fieldName", "szqy");
        szqyMap.put("fieldValue", map.get("szqy"));
        sunList.add(szqyMap);
        HashMap<String, Object> sqszdqMap = new HashMap<String, Object>();
        sqszdqMap.put("fieldName", "sqszdq");
        sqszdqMap.put("fieldValue", map.get("sqszdq"));
        sunList.add(sqszdqMap);
        HashMap<String, Object> lxMap = new HashMap<String, Object>();
        lxMap.put("fieldName", "lx");
        lxMap.put("fieldValue", map.get("lx"));
        sunList.add(lxMap);
        HashMap<String, Object> fyfwMap = new HashMap<String, Object>();
        fyfwMap.put("fieldName", "fyfw");
        fyfwMap.put("fieldValue", map.get("fyfw"));
        sunList.add(fyfwMap);
        HashMap<String, Object> omsljMap = new HashMap<String, Object>();
        omsljMap.put("fieldName", "omslj");
        omsljMap.put("fieldValue", map.get("omslj"));
        sunList.add(omsljMap);
        HashMap<String, Object> bzMap = new HashMap<String, Object>();
        bzMap.put("fieldName", "bz");
        bzMap.put("fieldValue", map.get("bz"));
        sunList.add(bzMap);
        dataMap.put("mainData", JsonUtil.buildNormalBinder().toJson(sunList));
        return dataMap;
    }

    private String queryTokenFormFw() {
        String fwSpkUrl = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "FwUrl", "FwUrl") + "/api/ec/dev/auth/applytoken";
        String fwAppId = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "FwAppId", "FwAppId");
        String fwAppSecret = BusUserServiceImpl.getDdFlag(ComConstants.tenantCode, "FwAppSecret", "FwAppSecret");
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("appid", fwAppId);
        try {
            fwAppSecret = BusUserServiceImpl.encrypt(fwAppSecret);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".queryTokenFormFw.rsafwSpkUrl::" + fwSpkUrl + "fwAppId:::" + fwAppId, (Throwable)e);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u6cdb\u5fae\u521b\u5efaappid\u52a0\u5bc6\u5931\u8d25");
        }
        header.put("secret", fwAppSecret);
        String data = null;
        try {
            data = ((cn.hutool.http.HttpRequest)((cn.hutool.http.HttpRequest)cn.hutool.http.HttpRequest.post((String)fwSpkUrl).header("appid", fwAppId)).header("secret", fwAppSecret)).form(new HashMap()).timeout(20000).execute().body();
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".queryApkFormFw.isnullfwSpkUrl::" + fwSpkUrl + "fwAppId:::" + fwAppId, (Throwable)e);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u6cdb\u5faeapk\u5931\u8d25");
        }
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, String.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".queryApkFormFw.returnResultsMapfwSpkUrl::" + fwSpkUrl + "fwAppId:::" + fwAppId, (Object)data);
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u6cdb\u5faeapk\u5931\u8d25\u8fd4\u56de\u4e3a\u7a7a");
        }
        String code = (String)returnResultsMap.get("code");
        if (!"0".equals(code)) {
            logger.error(this.SYS_CODE + ".queryApkFormFw.returnResultsMapfwSpkUrl::" + fwSpkUrl + "fwAppId:::" + fwAppId, (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + "\u83b7\u53d6\u6cdb\u5faeapk\u5931\u8d25\u8fd4\u56decode\u4e0d\u4e3a0");
        }
        return (String)returnResultsMap.get("token");
    }
}

