/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.api.ExStoreService;
import com.yqbsoft.laser.service.ext.bus.data.common.LogRouterlogDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.WhQoh;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.WhStoreSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhOpstoreDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhOpstoreReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhWarehouseDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhWarehouseReDomain;
import com.yqbsoft.laser.service.ext.bus.data.supbase.StoreBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.SqlServerUtils;
import com.yqbsoft.laser.service.ext.bus.data.util.StringConvertUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class ExStoreServiceImpl
extends StoreBaseService
implements ExStoreService {
    private String SYS_CODE = "busdata.ExStoreServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(ExStoreServiceImpl.class);

    @Override
    public String sendSaveExWarehouse(WhWarehouseDomain whWarehouseDomain) {
        if (null == whWarehouseDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.whWarehouseDomain");
            throw new ApiException(this.SYS_CODE + ".sendSaveExWarehouse.whWarehouseDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkWarehouse(whWarehouseDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.msg");
            throw new ApiException(this.SYS_CODE + ".sendSaveExWarehouse.msg", msg);
        }
        String tenantCode = whWarehouseDomain.getTenantCode();
        whWarehouseDomain.setMemberCode(this.getTeananMemberCode(tenantCode));
        whWarehouseDomain.setMemberName("\u5e73\u53f0");
        try {
            String warehouseCode = this.saveWarehouse(whWarehouseDomain);
            if (StringUtils.isBlank((String)warehouseCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExWarehouse.warehouseCode");
                throw new ApiException(this.SYS_CODE + ".sendSaveExWarehouse.warehouseCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(warehouseCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.e", (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveExWarehouse.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.e1", (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveExWarehouse.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExOpstore(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain");
            throw new ApiException("whOpstoreDomain\u53c2\u6570\u4e3a\u7a7a");
        }
        whOpstoreDomain.setTenantCode(ComConstants.tenantCode);
        whOpstoreDomain.setChannelCode(ComConstants.channelCode);
        whOpstoreDomain.setStoreGoodsBtype(ComConstants.storeGoodsBtype_d);
        whOpstoreDomain.setStoreType(ComConstants.storeType_1);
        String msg = this.checkOpstore(whOpstoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.checkOpstore");
            throw new ApiException(msg);
        }
        try {
            msg = this.makeWhOpstoreDomain(whOpstoreDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                logger.error(this.SYS_CODE + ".sendSaveExOpstore.makeWhOpstoreDomain", (Object)msg);
                throw new ApiException(msg);
            }
            String opstoreCode = this.sendSaveOpstore(whOpstoreDomain);
            if (StringUtils.isBlank((String)opstoreCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExOpstore.opstoreCode");
                throw new ApiException("\u4fdd\u5b58\u5f02\u5e38");
            }
            return opstoreCode;
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.e", (Throwable)e);
            throw new ApiException(e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.e1", (Throwable)e);
            throw new ApiException(e.getMessage());
        }
    }

    @Override
    public WhWarehouseReDomain queryExOpstore(String warehouseCode, String warehouseOcode, String tenantCode) {
        return this.getWarehouse(warehouseCode, warehouseOcode, tenantCode);
    }

    private LocalDateTime getLocalDateTime(String datetimeStr) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return (LocalDateTime)df.parse(datetimeStr);
    }

    private String getStringlocalDateTime() {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime time = LocalDateTime.now();
        return df.format(time);
    }

    private LocalDateTime getInstantTime(Integer instantMins) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime sevenMinutesAgo = now.minusMinutes(instantMins.intValue());
        return sevenMinutesAgo;
    }

    @Override
    public String sendSaveBusOpstoreU9(String businessType) {
        if (StringUtils.isBlank((String)businessType)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.businessType", (Object)"businessType is null");
            throw new ApiException("businessType is null");
        }
        InternalRouter internalRouter = this.getInternalRouter();
        if (null == internalRouter) {
            logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.internalRouter", (Object)"internalRouter is null");
            return "internalRouter is null";
        }
        String tenantCode = "";
        LocalDateTime args = null;
        boolean initialFlag = false;
        List<WhQoh> whsFromU9 = null;
        if ("1".equals(businessType)) {
            initialFlag = true;
            try {
                whsFromU9 = this.queryStockFromU9("SELECT * from CJ_V_WhQoh t1 where t1.OrgCode = '101'  and CAST(t1.storeQty as FLOAT) > 0   and t1.ItemInfo_ItemCode ='101190321-008'", initialFlag, args);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.whsFromU9", (Object)("\u89c6\u56fe\u6709\u95ee\u9898+e: " + e));
                throw new ApiException("sql is error");
            }
        }
        if (!initialFlag) {
            args = this.getInstantTime(8);
            try {
                whsFromU9 = this.queryStockFromU9("SELECT * from CJ_V_WhQoh t1 where t1.OrgCode = '101'   and t1.CreatedOn >= ? ", initialFlag, args);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.whsFromU9", (Object)("\u89c6\u56fe\u6709\u95ee\u9898add +e: " + e));
                throw new ApiException("sql is error");
            }
            List<Object> whsFromU9Update = new ArrayList();
            try {
                whsFromU9Update = this.queryStockFromU9("SELECT * from CJ_V_WhQoh t1 where t1.OrgCode = '101'  and t1.ModifiedOn >= ? ", initialFlag, args);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.whsFromU9", (Object)("\u89c6\u56fe\u6709\u95ee\u9898update +e: " + e));
                throw new ApiException("sql is error");
            }
            if (ListUtil.isNotEmpty(whsFromU9Update)) {
                if (ListUtil.isNotEmpty(whsFromU9)) {
                    whsFromU9Update.addAll(whsFromU9);
                }
            } else {
                whsFromU9Update = whsFromU9;
            }
            whsFromU9 = whsFromU9Update;
        }
        if (ListUtil.isNotEmpty(whsFromU9)) {
            this.saveOrUpdate(whsFromU9);
        }
        return this.makeSuccessReturn("\u5e93\u5b58\u6539\u53d8\u6210\u529f!");
    }

    private void saveOrUpdate(List<WhQoh> whsFromU9) {
        List<WhOpstoreDomain> whOpstoreDomainList = this.makeWhOpstoreDomain1(whsFromU9, "0", ComConstants.storeGoodsBtype_t);
        if (ListUtil.isEmpty(whOpstoreDomainList)) {
            logger.error(this.SYS_CODE + ".timingStock.whOpstoreDomainList", (Object)"makeWhOpstoreDomain is null\uff0c\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u5e93\u5b58\u6570\u636e");
            throw new ApiException("makeWhOpstoreDomain is nul");
        }
        final HashMap<String, ArrayList<WhOpstoreDomain>> savemap = new HashMap<String, ArrayList<WhOpstoreDomain>>();
        ArrayList<WhOpstoreSkuDomain> whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
        for (int j = 0; j < whOpstoreDomainList.size(); ++j) {
            String group = String.valueOf(j / 25);
            ArrayList<WhOpstoreDomain> savewhOpstoreDomainList = (ArrayList<WhOpstoreDomain>)savemap.get(group);
            if (null == savewhOpstoreDomainList) {
                savewhOpstoreDomainList = new ArrayList<WhOpstoreDomain>();
                savemap.put(group, savewhOpstoreDomainList);
            }
            savewhOpstoreDomainList.add(whOpstoreDomainList.get(j));
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomainList.get(j).getWhOpstoreGoodsDomainList()) {
                whOpstoreSkuDomainList.addAll(whOpstoreGoodsDomain.getWhOpstoreSkuDomainList());
            }
        }
        for (final String key : savemap.keySet()) {
            HashMap<String, Object> sendMap = new HashMap<String, Object>(){
                {
                    this.put("whOpstoreDomainList", JsonUtil.buildNormalBinder().toJson(savemap.get(key)));
                }
            };
            try {
                this.internalInvoke("wh.whStoreGoodsBase.sendSaveOpstoreBatchForAikang", sendMap);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".timingStock.sendSaveOpstoreBatch.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)sendMap), (Throwable)e);
                throw new ApiException("SYS_CODE + \".timingStock.sendSaveOpstoreBatch.error:" + e.getMessage());
            }
        }
    }

    private List<WhOpstoreDomain> makeWhOpstoreDomain1(List<WhQoh> whsFromU9, String storeGoodsType, String storeGoodsBtype) {
        if (ListUtil.isEmpty(whsFromU9)) {
            return null;
        }
        HashMap<String, WhWarehouseReDomain> whWarehouseReDomainMap = new HashMap<String, WhWarehouseReDomain>();
        ArrayList<WhOpstoreDomain> whOpstoreDomains = new ArrayList<WhOpstoreDomain>();
        for (final WhQoh whQoh : whsFromU9) {
            BigDecimal goodsNum = BigDecimal.ZERO;
            if (!StringUtils.isEmpty((String)whQoh.getStoreQty())) {
                goodsNum = new BigDecimal(whQoh.getStoreQty());
            }
            WhWarehouseReDomain whWarehouseDomain = null;
            if (whWarehouseReDomainMap.get(whQoh.getWhCode()) == null) {
                whWarehouseDomain = this.getWarehouseByCode(whQoh.getWhCode(), ComConstants.tenantCode);
                if (null == whWarehouseDomain) {
                    throw new ApiException(whQoh.getWhCode() + "whWarehouseDomain is null");
                }
                whWarehouseReDomainMap.put(whQoh.getWhCode(), whWarehouseDomain);
            } else {
                whWarehouseDomain = (WhWarehouseReDomain)whWarehouseReDomainMap.get(whQoh.getWhCode());
            }
            final WhWarehouseReDomain finalWhWarehouseDomain = whWarehouseDomain;
            HashMap<String, Object> queryMap = new HashMap<String, Object>(){
                {
                    this.put("warehouseCode", finalWhWarehouseDomain.getWarehouseCode());
                    this.put("skuNo", whQoh.getItemInfo_ItemCode());
                    this.put("tenantCode", ComConstants.tenantCode);
                }
            };
            QueryResult<WhStoreSkuDomain> queryWhSku = this.queryWhSku((Map<String, Object>)queryMap);
            if (queryWhSku != null && queryWhSku.getList() != null && queryWhSku.getList().size() > 0) {
                BigDecimal stockGoodsNum = ((WhStoreSkuDomain)queryWhSku.getList().get(0)).getGoodsNum();
                if (null == stockGoodsNum) {
                    stockGoodsNum = BigDecimal.ZERO;
                }
                if (stockGoodsNum.compareTo(goodsNum) == 0) continue;
            }
            ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
            WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
            whOpstoreDomain.setMemberBcode(whWarehouseDomain.getWarehouseMobile());
            whOpstoreDomain.setWarehouseCode(whWarehouseDomain.getWarehouseCode());
            whOpstoreDomain.setWarehouseName(whWarehouseDomain.getWarehouseName());
            whOpstoreDomain.setGoodsNum(goodsNum);
            whOpstoreDomain.setStoreGoodsBtype(storeGoodsBtype);
            whOpstoreDomain.setStoreGoodsType(storeGoodsType);
            whOpstoreDomain.setStoreType("0");
            whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
            whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
            ArrayList<WhOpstoreSkuDomain> whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
            WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
            whOpstoreGoodsDomain.setWarehouseCode(whWarehouseDomain.getWarehouseCode());
            whOpstoreGoodsDomain.setWarehouseName(whWarehouseDomain.getWarehouseName());
            this.assWhOpstoreSkuDomain(whQoh, whOpstoreSkuDomainList, whOpstoreDomain, whOpstoreGoodsDomain, "1");
            whOpstoreGoodsDomain.setOpstoreDir("1");
            whOpstoreGoodsDomain.setStoreType("0");
            whOpstoreGoodsDomain.setStoreGoodsType("0");
            whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
            whOpstoreGoodsDomain.setPartsnameNumunit1("0");
            whOpstoreGoodsDomainList.add(whOpstoreGoodsDomain);
            whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
            whOpstoreDomains.add(whOpstoreDomain);
        }
        return whOpstoreDomains;
    }

    private void assWhOpstoreSkuDomain(WhQoh whQoh, List<WhOpstoreSkuDomain> whOpstoreSkuDomainList, WhOpstoreDomain whOpstoreDomain, WhOpstoreGoodsDomain whOpstoreGoodsDomain, String opStoreDir) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuNo", whQoh.getItemInfo_ItemCode());
        map.put("tenantCode", ComConstants.tenantCode);
        map.put("channelCode", ComConstants.channelCode);
        QueryResult<RsSkuDomain> rsSkuDomainQueryResult = this.queryRsSkuPage(map);
        if (rsSkuDomainQueryResult == null || CollectionUtils.isEmpty((Collection)rsSkuDomainQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".assWhOpstoreSkuDomain.queryRsSkuPage.param", map);
            return;
        }
        RsSkuDomain rsSkuDomain = (RsSkuDomain)rsSkuDomainQueryResult.getList().get(0);
        whOpstoreGoodsDomain.setMemberBcode(rsSkuDomain.getMemberBcode());
        whOpstoreGoodsDomain.setGoodsNo(rsSkuDomain.getGoodsNo());
        whOpstoreGoodsDomain.setGoodsEocode(rsSkuDomain.getGoodsEocode());
        whOpstoreGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        if (null == whQoh || null == whOpstoreDomain || null == whOpstoreGoodsDomain) {
            return;
        }
        if (null == whOpstoreDomain.getGoodsNum()) {
            whOpstoreDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreDomain.getGoodsWeight()) {
            whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == whOpstoreDomain.getGoodsAmt()) {
            whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsNum()) {
            whOpstoreGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsWeight()) {
            whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        WhOpstoreSkuDomain whOpstoreSkuDomain = new WhOpstoreSkuDomain();
        whOpstoreSkuDomain.setMemberBcode(rsSkuDomain.getMemberBcode());
        whOpstoreSkuDomain.setWarehouseCode(whOpstoreGoodsDomain.getWarehouseCode());
        whOpstoreSkuDomain.setWarehouseName(whOpstoreGoodsDomain.getWarehouseName());
        whOpstoreSkuDomain.setGoodsNum(StringConvertUtil.getBigDecimal(whQoh.getStoreQty()));
        whOpstoreSkuDomain.setClasstreeCode(rsSkuDomain.getClasstreeCode());
        whOpstoreSkuDomain.setClasstreeName(rsSkuDomain.getClasstreeName());
        whOpstoreSkuDomain.setGoodsNo(rsSkuDomain.getGoodsNo());
        whOpstoreSkuDomain.setGoodsCode(rsSkuDomain.getGoodsCode());
        whOpstoreSkuDomain.setSkuEocode(rsSkuDomain.getSkuEocode());
        whOpstoreSkuDomain.setGoodsEocode(rsSkuDomain.getGoodsEocode());
        whOpstoreSkuDomain.setSpuCode(rsSkuDomain.getSpuCode());
        whOpstoreSkuDomain.setSkuNo(rsSkuDomain.getSkuNo());
        whOpstoreSkuDomain.setSkuCode(rsSkuDomain.getSkuCode());
        whOpstoreSkuDomain.setSkuName(rsSkuDomain.getSkuName());
        whOpstoreSkuDomain.setOperatorCode(rsSkuDomain.getMschannelName());
        whOpstoreSkuDomain.setWarehouseCode(whOpstoreGoodsDomain.getWarehouseCode());
        whOpstoreSkuDomain.setWarehouseName(whOpstoreGoodsDomain.getWarehouseName());
        whOpstoreSkuDomain.setMemberCode(rsSkuDomain.getMemberCode());
        whOpstoreSkuDomain.setMemberName(rsSkuDomain.getMemberName());
        whOpstoreSkuDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
        whOpstoreSkuDomain.setChannelCode(rsSkuDomain.getChannelCode());
        whOpstoreSkuDomain.setChannelName(rsSkuDomain.getChannelName());
        whOpstoreSkuDomain.setStoreType("0");
        whOpstoreGoodsDomain.setStoreType("0");
        whOpstoreDomain.setChannelCode(whOpstoreSkuDomain.getChannelCode());
        whOpstoreDomain.setChannelName(whOpstoreSkuDomain.getChannelName());
        whOpstoreDomain.setMemberMcode(whOpstoreSkuDomain.getMemberCode());
        whOpstoreDomain.setMemberMname(whOpstoreSkuDomain.getMemberName());
        whOpstoreDomain.setMemberCode(ComConstants.membercode);
        whOpstoreDomain.setMemberName(ComConstants.membername);
        whOpstoreDomain.setTenantCode(ComConstants.tenantCode);
        if (null == whOpstoreSkuDomain.getGoodsNum()) {
            whOpstoreSkuDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreSkuDomain.getGoodsWeight()) {
            whOpstoreSkuDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsNum()) {
            whOpstoreGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsWeight()) {
            whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        whOpstoreDomain.setGoodsNum(whOpstoreDomain.getGoodsNum().add(whOpstoreSkuDomain.getGoodsNum()));
        whOpstoreDomain.setGoodsWeight(whOpstoreDomain.getGoodsWeight().add(whOpstoreSkuDomain.getGoodsWeight()));
        whOpstoreGoodsDomain.setGoodsNum(whOpstoreGoodsDomain.getGoodsNum().add(whOpstoreSkuDomain.getGoodsNum()));
        whOpstoreGoodsDomain.setGoodsWeight(whOpstoreGoodsDomain.getGoodsWeight().add(whOpstoreSkuDomain.getGoodsWeight()));
        whOpstoreGoodsDomain.setMemberCode(ComConstants.membercode);
        whOpstoreGoodsDomain.setMemberName(ComConstants.membername);
        whOpstoreGoodsDomain.setTenantCode(ComConstants.tenantCode);
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("goodsNo", rsSkuDomain.getGoodsNo());
        map1.put("tenantCode", ComConstants.tenantCode);
        map1.put("channelCode", ComConstants.channelCode);
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsReDomainQueryResult = this.queryRsResourceGoodsPage(map1);
        if (rsSkuDomainQueryResult == null || CollectionUtils.isEmpty((Collection)rsResourceGoodsReDomainQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".assWhOpstoreSkuDomain.rsResourceGoodsReDomainQueryResult.param", map);
            return;
        }
        RsResourceGoodsReDomain rsResourceGoods = (RsResourceGoodsReDomain)rsResourceGoodsReDomainQueryResult.getList().get(0);
        whOpstoreGoodsDomain.setClasstreeCode(rsResourceGoods.getClasstreeCode());
        whOpstoreGoodsDomain.setClasstreeName(rsResourceGoods.getClasstreeName());
        whOpstoreGoodsDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
        whOpstoreGoodsDomain.setGoodsNo(rsResourceGoods.getGoodsNo());
        whOpstoreGoodsDomain.setSpuCode(rsResourceGoods.getSpuCode());
        whOpstoreGoodsDomain.setGoodsProperty1(rsResourceGoods.getGoodsProperty1());
        whOpstoreGoodsDomain.setGoodsProperty2(rsResourceGoods.getGoodsProperty2());
        whOpstoreGoodsDomain.setGoodsProperty3(rsResourceGoods.getGoodsProperty3());
        whOpstoreGoodsDomain.setGoodsEocode(rsResourceGoods.getGoodsEocode());
        whOpstoreGoodsDomain.setMemberCode(rsResourceGoods.getMemberCode());
        whOpstoreGoodsDomain.setMemberName(rsResourceGoods.getMemberName());
        whOpstoreSkuDomain.setMemberCode(ComConstants.membercode);
        whOpstoreSkuDomain.setMemberName(ComConstants.membername);
        whOpstoreSkuDomain.setTenantCode(ComConstants.tenantCode);
        whOpstoreSkuDomain.setMemberBcode(whOpstoreGoodsDomain.getMemberBcode());
        whOpstoreSkuDomain.setGoodsWeightstr(whQoh.getLotInfo_LotCode());
        whOpstoreSkuDomain.setPartsnameNumunit1("0");
        whOpstoreSkuDomainList.add(whOpstoreSkuDomain);
    }

    private void queryWhStoreSkuAndUpate(InternalRouter internalRouter, WhQoh whQoh) throws Exception {
        WhStoreSkuDomain whStoreSkuDomainOld = this.queryWhStoreSkuDomain(internalRouter, whQoh);
        WhStoreSkuDomain whStoreSkuDomainNew = this.buildWhStoreSku(whQoh);
        boolean isUpdate = false;
        if (null == whStoreSkuDomainOld) {
            this.saveWhStoreSkuDomain(internalRouter, whStoreSkuDomainNew);
        } else {
            this.updateWhStoreSkuDomain(internalRouter, whStoreSkuDomainOld, whStoreSkuDomainNew, isUpdate);
            if (isUpdate) {
                this.saveLogRouterLog(internalRouter, whStoreSkuDomainOld, whStoreSkuDomainNew);
            }
        }
    }

    private void updateWhStoreSkuDomain(InternalRouter internalRouter, final WhStoreSkuDomain whStoreSkuDomainOld, WhStoreSkuDomain whStoreSkuDomainNew, boolean isUpdate) throws Exception {
        if (whStoreSkuDomainOld.getGoodsSupplynum().compareTo(whStoreSkuDomainNew.getGoodsSupplynum()) != 0) {
            isUpdate = true;
            BigDecimal oldGoodsSupplynum = whStoreSkuDomainOld.getGoodsSupplynum();
            whStoreSkuDomainOld.setGoodsSupplynum(whStoreSkuDomainNew.getGoodsSupplynum());
            HashMap<String, Object> map = new HashMap<String, Object>(){
                {
                    this.put("rsStoreSkuDomain", JsonUtil.buildNormalBinder().toJson((Object)whStoreSkuDomainOld));
                }
            };
            logger.error(this.SYS_CODE + ".updateWhStoreSkuDomain\u3002\u4fee\u6539\u5e93\u5b58\u5f00\u59cb", (Object)JsonUtil.buildNormalBinder().toJson((Object)whStoreSkuDomainOld));
            internalRouter.inInvoke("wh.whStoreGoods.updateStoreSku", (Map)map);
            logger.error(this.SYS_CODE + ".updateWhStoreSkuDomain.\u4fee\u6539\u5e93\u5b58\u7ed3\u675f");
            whStoreSkuDomainOld.setGoodsSupplynum(oldGoodsSupplynum);
        }
    }

    private QueryResult<WhStoreSkuDomain> queryWhSku(final Map<String, Object> queryMap) {
        HashMap<String, Object> sendMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)queryMap));
            }
        };
        QueryResult queryResutl = this.getQueryResutl("wh.whStoreGoods.queryStoreSkuPage", sendMap, WhStoreSkuDomain.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            logger.error(this.SYS_CODE + ".queryWhSku.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)sendMap));
            return null;
        }
        return queryResutl;
    }

    private WhStoreSkuDomain queryWhStoreSkuDomain(InternalRouter internalRouter, WhQoh whQoh) {
        final HashMap<String, String> whStoreMap = new HashMap<String, String>();
        if (null != whQoh.getItemInfo_ItemCode()) {
            whStoreMap.put("skuNo", whQoh.getItemInfo_ItemCode());
        }
        if (null != whQoh.getWhCode()) {
            whStoreMap.put("warehouseCode2", whQoh.getWhCode());
        }
        HashMap<String, Object> whStoreParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)whStoreMap));
            }
        };
        logger.error(this.SYS_CODE + ".queryWhStoreSkuDomain", (Object)"\u67e5\u8be2storeSku\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".queryWhStoreSkuDomain.whStoreParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)whStoreParamMap));
        String storeSkuListStr = (String)internalRouter.inInvoke("wh.whStoreGoods.queryStoreSkuPage", (Map)whStoreParamMap);
        logger.error(this.SYS_CODE + ".queryWhStoreSkuDomain", (Object)"\u67e5\u8be2storeSku\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(storeSkuListStr, SupQueryResult.class);
        if (null == supQueryResult) {
            logger.error(this.SYS_CODE + ".supQueryResult", (Object)"supQueryResult is null");
            return null;
        }
        List storeSkuList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), WhStoreSkuDomain.class);
        if (null == storeSkuList || ListUtil.isEmpty((Collection)storeSkuList)) {
            logger.error(this.SYS_CODE + ".storeSkuList", (Object)"storeSkuList is null");
            return null;
        }
        logger.error(this.SYS_CODE + ".queryWhStoreSkuDomain.storeSkuList", (Object)JsonUtil.buildNormalBinder().toJson((Object)storeSkuList));
        logger.error(this.SYS_CODE + ".queryWhStoreSkuDomain...", (Object)"\u67e5\u8be2storeSku\u7ed3\u675f");
        return (WhStoreSkuDomain)storeSkuList.get(0);
    }

    private void saveLogRouterLog(InternalRouter internalRouter, WhStoreSkuDomain oldWhStoreDomain, WhStoreSkuDomain newWhStoreDomain) throws Exception {
        final LogRouterlogDomain logRouterlogDomain = new LogRouterlogDomain();
        logRouterlogDomain.setTenantCode(oldWhStoreDomain.getTenantCode());
        logRouterlogDomain.setRouterType("5");
        logRouterlogDomain.setRouterlogMessage("oldWhStoreDomain " + JsonUtil.buildNormalBinder().toJson((Object)oldWhStoreDomain) + " | newWhStoreDomain\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)newWhStoreDomain));
        HashMap<String, Object> batchSaveUpMap = new HashMap<String, Object>(){
            {
                this.put("logRouterlogDomain", JsonUtil.buildNormalBinder().toJson((Object)logRouterlogDomain));
            }
        };
        logger.error(this.SYS_CODE + ".saveLogRouterLog", (Object)("saveLogRouterLog logRouterlogDomain: " + JsonUtil.buildNormalBinder().toJson((Object)logRouterlogDomain)));
        internalRouter.inInvoke("log.logRouterlog.saveRouterlog", (Map)batchSaveUpMap);
        logger.error(this.SYS_CODE + ".saveLogRouterLog", (Object)"saveLogRouterLog\u7ed3\u675f");
    }

    private void saveWhStoreSkuDomain(InternalRouter internalRouter, final WhStoreSkuDomain whStoreSkuDomain) throws Exception {
        HashMap<String, Object> whSkuMap = new HashMap<String, Object>(){
            {
                this.put("rsStoreSkuDomain", JsonUtil.buildNormalBinder().toJson((Object)whStoreSkuDomain));
            }
        };
        logger.error(this.SYS_CODE + ".saveWhStoreSkuDomain", (Object)("\u4fdd\u5b58saveRsStoreSkuDomain\u5f00\u59cb rsStoreSkuDomain: " + JsonUtil.buildNormalBinder().toJson((Object)whStoreSkuDomain)));
        internalRouter.inInvoke("wh.whStoreGoods.saveStoreSku", (Map)whSkuMap);
        logger.error(this.SYS_CODE + ".saveWhStoreSkuDomain", (Object)"\u4fdd\u5b58saveRsStoreSkuDomain\u7ed3\u675f");
    }

    private WhStoreSkuDomain buildWhStoreSku(final WhQoh whQoh) throws Exception {
        final String tenantCode = "728243877368496147";
        HashMap<String, Object> skuMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", tenantCode);
                this.put("skuEocode", whQoh.getItemInfo_ItemCode());
            }
        };
        QueryResult<RsSkuDomain> rsSkuDomainQueryResult = this.queryRsSkuPage((Map<String, Object>)skuMap);
        logger.error(this.SYS_CODE + ".buildWhStoreSku.rsSkuDomainQueryResult", (Object)JsonUtil.buildNormalBinder().toJson(rsSkuDomainQueryResult));
        if (null == rsSkuDomainQueryResult || ListUtil.isEmpty((Collection)rsSkuDomainQueryResult.getList())) {
            throw new RuntimeException("sku is null skuEocde: " + whQoh.getItemInfo_ItemCode());
        }
        final RsSkuDomain rsSkuDomain = (RsSkuDomain)rsSkuDomainQueryResult.getList().get(0);
        HashMap<String, Object> goodsMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", tenantCode);
                this.put("goodsEocode", rsSkuDomain.getGoodsEocode());
            }
        };
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsReDomainQueryResult = this.queryRsResourceGoodsPage((Map<String, Object>)goodsMap);
        logger.error(this.SYS_CODE + ".buildWhStoreSku.rsResourceGoodsReDomainQueryResult", (Object)JsonUtil.buildNormalBinder().toJson(rsResourceGoodsReDomainQueryResult));
        if (null == rsResourceGoodsReDomainQueryResult || ListUtil.isEmpty((Collection)rsResourceGoodsReDomainQueryResult.getList())) {
            throw new RuntimeException("goods is null goodsEocode: " + rsSkuDomain.getGoodsEocode());
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)rsResourceGoodsReDomainQueryResult.getList().get(0);
        WhStoreSkuDomain whStoreSkuDomain = new WhStoreSkuDomain();
        BeanUtils.copyAllPropertysNotNull((Object)whStoreSkuDomain, (Object)rsSkuDomain);
        BeanUtils.copyAllPropertysNotNull((Object)whStoreSkuDomain, (Object)rsResourceGoodsReDomain);
        whStoreSkuDomain.setTenantCode(tenantCode);
        whStoreSkuDomain.setSkuNo(whQoh.getItemInfo_ItemCode());
        whStoreSkuDomain.setSkuName(whQoh.getItemInfo_ItemName());
        whStoreSkuDomain.setWarehouseName(whQoh.getWhName());
        whStoreSkuDomain.setWarehouseCode2(whQoh.getWhCode());
        whStoreSkuDomain.setGoodsSupplynum(new BigDecimal(whQoh.getStoreQty()));
        return whStoreSkuDomain;
    }

    protected QueryResult<RsResourceGoodsReDomain> queryRsResourceGoodsPage(Map<String, Object> map) {
        if (null == map) {
            logger.error(this.SYS_CODE + ".queryRsResourceGoodsPage.map");
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject("rs.resourceGoods.queryResourceGoodsPage", paramMap, RsResourceGoodsReDomain.class);
    }

    private List<WhQoh> queryStockFromU9(String sql, boolean initialFlag, Object ... args) throws Exception {
        List<WhQoh> whs = null;
        String returnMsg = initialFlag ? "\u521d\u59cb\u5316\u67e5\u8be2\u5e93\u5b58\u89c6\u56fe\u4e3a\u7a7a" : "\u65b0\u589e\u6216\u8005\u4fee\u6539\u67e5\u8be2\u89c6\u56fe\u4e3a\u7a7a";
        try {
            whs = SqlServerUtils.getForList(WhQoh.class, sql, args);
            logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.queryU9", (Object)"\u67e5\u8be2U9\u5e93\u5b58\u6570\u636e\u7ed3\u675f");
            logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.whs.size", (Object)whs.size());
            if (ListUtil.isEmpty(whs)) {
                logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.queryU9", (Object)"\u67e5\u8be2U9\u5e93\u5b58\u6570\u636e\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.view", (Object)"\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
            throw new RuntimeException("\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
        }
        return whs;
    }

    @Override
    public String sendSaveExOpstoreByEsb(Map<String, Object> resStream, String tenantCode) {
        logger.error(this.SYS_CODE + ".sendSaveExOpstoreByEsb.map", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        logger.error(this.SYS_CODE + ".sendSaveExOpstoreByEsb.tenantCode", (Object)tenantCode);
        if (MapUtil.isEmpty(resStream)) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain");
            throw new ApiException(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        WhOpstoreDomain whOpstoreDomain = (WhOpstoreDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), WhOpstoreDomain.class);
        if (null == whOpstoreDomain || StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain");
            throw new ApiException(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain", "\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isNotBlank((String)whOpstoreDomain.getOpstoreCode())) {
            whOpstoreDomain.setOpstoreNcode(whOpstoreDomain.getOpstoreCode());
            whOpstoreDomain.setOpstoreCode(null);
        }
        whOpstoreDomain.setTenantCode(tenantCode);
        if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsType())) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain.storeGoodsType", "\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreSkuDomainList())) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain", "whOpstoreSkuDomainList\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreOcode", whOpstoreDomain.getOpstoreOcode());
        QueryResult<WhOpstoreReDomain> queryResult = this.queryOpstorePage(map);
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOpstore.opstoreOcode", "\u6570\u636e\u5df2\u7ecf\u5b58\u5728");
        }
        for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreDomain.getWhOpstoreSkuDomainList()) {
            if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                throw new ApiException(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain.whOpstoreSkuDomainList.skuNo", "skuNo\u53c2\u6570\u4e3a\u7a7a");
            }
            if (null == whOpstoreSkuDomain.getGoodsNum()) {
                throw new ApiException(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain.whOpstoreSkuDomainList.goodsNum", "goodsNum\u53c2\u6570\u4e3a\u7a7a");
            }
            whOpstoreSkuDomain.setTenantCode(tenantCode);
            whOpstoreSkuDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
        }
        String code = this.sendSaveOpstoreTwo(whOpstoreDomain);
        return this.makeSuccessReturn(code);
    }

    private String makeWhOpstoreDomain(WhOpstoreDomain whOpstoreDomain) {
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList;
        if (null == whOpstoreDomain) {
            logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whOpstoreDomain");
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        HashMap<String, WhWarehouseReDomain> waMap = new HashMap<String, WhWarehouseReDomain>();
        HashMap<String, WhWarehouseReDomain> owaMap = new HashMap<String, WhWarehouseReDomain>();
        WhWarehouseReDomain whWarehouseReDomain = this.getWarehouse(whOpstoreDomain.getWarehouseCode(), whOpstoreDomain.getWarehouseOcode(), whOpstoreDomain.getTenantCode());
        owaMap.put(whWarehouseReDomain.getWarehouseOcode(), whWarehouseReDomain);
        waMap.put(whWarehouseReDomain.getWarehouseCode(), whWarehouseReDomain);
        whOpstoreDomain.setWarehouseCode(whWarehouseReDomain.getWarehouseCode());
        whOpstoreDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
        if (StringUtils.isBlank((String)whOpstoreDomain.getMemberCode())) {
            whOpstoreDomain.setMemberCode(whWarehouseReDomain.getMemberCode());
            whOpstoreDomain.setMemberName(whWarehouseReDomain.getMemberName());
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getMemberMcode())) {
            UmUserinfoReDomain umUserinfoReDomain = this.getUserinfoByCode(whOpstoreDomain.getMemberCode(), whOpstoreDomain.getTenantCode());
            if (null == umUserinfoReDomain) {
                logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.umUserinfoReDomain", (Object)(whOpstoreDomain.getMemberCode() + "=" + whOpstoreDomain.getTenantCode()));
                return "\u8f6c\u6362\u7528\u6237\u4e3a\u7a7a";
            }
            whOpstoreDomain.setMemberMcode(umUserinfoReDomain.getUserinfoParentCode());
            whOpstoreDomain.setMemberMname(umUserinfoReDomain.getUserinfoParentName());
        }
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whOpstoreGoodsDomainList", (Object)(whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode()));
            return "whOpstoreGoodsDomainList\u4e3a\u7a7a! ";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String goodsClass = "plat";
        QueryResult<RsSkuDomain> queryResutl = null;
        RsSkuDomain rsSkuDomain = null;
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            BigDecimal goodsNum;
            String warehouseCode;
            whWarehouseReDomain = StringUtils.isBlank((String)whOpstoreGoodsDomain.getWarehouseCode()) ? (WhWarehouseReDomain)owaMap.get(whOpstoreGoodsDomain.getWarehouseOcode()) : (WhWarehouseReDomain)waMap.get(whOpstoreGoodsDomain.getWarehouseCode());
            if (null == whWarehouseReDomain) {
                whWarehouseReDomain = this.getWarehouse(whOpstoreGoodsDomain.getWarehouseCode(), whOpstoreGoodsDomain.getWarehouseOcode(), whOpstoreDomain.getTenantCode());
                if (null == whWarehouseReDomain) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whWarehouseReDomain", (Object)(whOpstoreGoodsDomain.getWarehouseOcode() + "=" + whOpstoreGoodsDomain.getWarehouseCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "\u4ed3\u5e93\u4ee3\u7801\u5f02\u5e38! ";
                }
                owaMap.put(whWarehouseReDomain.getWarehouseOcode(), whWarehouseReDomain);
                waMap.put(whWarehouseReDomain.getWarehouseCode(), whWarehouseReDomain);
            }
            whOpstoreGoodsDomain.setStoreGoodsBtype(whOpstoreDomain.getStoreGoodsBtype());
            whOpstoreGoodsDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
            whOpstoreGoodsDomain.setWarehouseCode(whWarehouseReDomain.getWarehouseCode());
            whOpstoreGoodsDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whOpstoreSkuDomainList", (Object)(whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode()));
                return "whOpstoreSkuDomainList\u4e3a\u7a7a! ";
            }
            if (whOpstoreDomain.getStoreGoodsType().equals(ComConstants.storeGoodsType_3)) {
                whOpstoreGoodsDomain.setOpstoreDir("0");
            } else if (whOpstoreDomain.getStoreGoodsType().equals(ComConstants.storeGoodsType_4) || whOpstoreDomain.getStoreGoodsType().equals(ComConstants.storeGoodsType_20)) {
                whOpstoreGoodsDomain.setOpstoreDir("1");
            }
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                paramMap.put("skuNo", whOpstoreSkuDomain.getSkuNo());
                paramMap.put("channelCode", ComConstants.channelCode);
                paramMap.put("tenantCode", whOpstoreDomain.getTenantCode());
                queryResutl = this.queryRsSkuPage(paramMap);
                if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.queryResutl", (Object)(whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "sku\u4e3a\u7a7a! " + paramMap.toString();
                }
                rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                rsResourceGoodsReDomain = this.getGoodsByCode(rsSkuDomain.getGoodsCode(), whOpstoreDomain.getTenantCode());
                if (null == rsResourceGoodsReDomain) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.rsResourceGoodsReDomain", (Object)(rsSkuDomain.getGoodsCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "goods\u4e3a\u7a7a! " + paramMap.toString();
                }
                warehouseCode = whOpstoreSkuDomain.getWarehouseCode();
                goodsNum = whOpstoreSkuDomain.getGoodsNum();
                try {
                    BeanUtils.copyAllPropertys((Object)whOpstoreSkuDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)whOpstoreSkuDomain, (Object)rsSkuDomain);
                }
                catch (Exception e) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.copysku", (Object)(rsSkuDomain.getGoodsCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "\u7cfb\u7edf\u5f02\u5e38! ";
                }
                whOpstoreSkuDomain.setStoreGoodsBtype(whOpstoreDomain.getStoreGoodsBtype());
                whOpstoreSkuDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
                whOpstoreSkuDomain.setWarehouseCode(whOpstoreGoodsDomain.getWarehouseCode());
                whOpstoreSkuDomain.setWarehouseName(whOpstoreGoodsDomain.getWarehouseName());
                if (whOpstoreDomain.getStoreGoodsType().equals("3")) {
                    whOpstoreSkuDomain.setOpstoreDir("0");
                } else if (whOpstoreDomain.getStoreGoodsType().equals("4") || whOpstoreDomain.getStoreGoodsType().equals("20")) {
                    whOpstoreSkuDomain.setOpstoreDir("1");
                }
                whOpstoreSkuDomain.setGoodsNum(goodsNum);
            }
            warehouseCode = whOpstoreGoodsDomain.getWarehouseCode();
            String warehouseName = whOpstoreGoodsDomain.getWarehouseName();
            goodsNum = whOpstoreGoodsDomain.getGoodsNum();
            try {
                BeanUtils.copyAllPropertys((Object)whOpstoreGoodsDomain, rsResourceGoodsReDomain);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.copyspu", (Object)(rsSkuDomain.getGoodsCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                return "\u7cfb\u7edf\u5f02\u5e38! ";
            }
            whOpstoreGoodsDomain.setWarehouseCode(warehouseCode);
            whOpstoreGoodsDomain.setWarehouseName(warehouseName);
            whOpstoreGoodsDomain.setGoodsNum(goodsNum);
        }
        return null;
    }

    private WhWarehouseReDomain getWarehouse(String warehouseCode, String warehouseOcode, String tenantCode) {
        WhWarehouseReDomain whWarehouseReDomain;
        if (StringUtils.isBlank((String)warehouseCode)) {
            Map map = this.getQueryMapParam("warehouseOcode", new Object[]{warehouseOcode, tenantCode});
            QueryResult<WhWarehouseReDomain> qwh = this.queryWarehousePage(map);
            if (null == qwh || ListUtil.isEmpty((Collection)qwh.getList())) {
                logger.error(this.SYS_CODE + ".getWarehouse.getWarehouseCode", (Object)map);
                throw new ApiException("\u8f6c\u6362\u4ed3\u5e93\u4e3a\u7a7a");
            }
            if (qwh.getList().size() > 1) {
                logger.error(this.SYS_CODE + ".getWarehouse.qwh", (Object)map);
                throw new ApiException("\u8f6c\u6362\u4ed3\u5e93\u5f02\u5e38");
            }
            whWarehouseReDomain = (WhWarehouseReDomain)qwh.getList().get(0);
        } else {
            whWarehouseReDomain = this.getWarehouseByCode(warehouseCode, tenantCode);
            if (null == whWarehouseReDomain) {
                logger.error(this.SYS_CODE + ".getWarehouse.whWarehouseReDomain", (Object)(warehouseCode + "=" + tenantCode));
                throw new ApiException("\u8f6c\u6362\u4ed3\u5e93\u4e3a\u7a7a");
            }
        }
        return whWarehouseReDomain;
    }

    private String checkOpstore(WhOpstoreDomain whOpstoreDomain) {
        QueryResult<WhOpstoreReDomain> qwh;
        if (null == whOpstoreDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
            msg = msg + "warehouseCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getStoreWhlocal())) {
            msg = msg + "storeWhlocal\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
            msg = msg + "opstoreOcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseName())) {
            msg = msg + "warehouseName\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsType())) {
            msg = msg + "storeGoodsType\u4e3a\u7a7a! ";
        } else if (!"3,4,20".contains(whOpstoreDomain.getStoreGoodsType())) {
            msg = msg + "storeGoodsType\u5f02\u5e38[" + whOpstoreDomain.getStoreGoodsType() + "]! ";
        }
        if (StringUtils.isNotBlank((String)whOpstoreDomain.getOpstoreOcode()) && null != (qwh = this.queryOpstorePage(this.getQueryMapParam("opstoreOcode,tenantCode", new Object[]{whOpstoreDomain.getOpstoreOcode(), whOpstoreDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qwh.getList())) {
            msg = msg + "opstoreOcode[" + whOpstoreDomain.getOpstoreOcode() + "]\u91cd\u590d! ";
            return msg;
        }
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            msg = msg + "whOpstoreGoodsDomainList\u4e3a\u7a7a! ";
            return msg;
        }
        int i = 0;
        int j = 0;
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            ++i;
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsNo())) {
                msg = msg + "\u7b2c" + i + "\u884cgoodsNo\u4e3a\u7a7a! ";
            }
            if (null == whOpstoreGoodsDomain.getGoodsNum()) {
                msg = msg + "\u7b2c" + i + "\u884cgoodsNum\u4e3a\u7a7a! ";
            }
            whOpstoreGoodsDomain.setTenantCode(whOpstoreGoodsDomain.getTenantCode());
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                msg = msg + "\u7b2c" + i + "\u884cwhOpstoreSkuDomainList\u4e3a\u7a7a! ";
                return msg;
            }
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                ++j;
                whOpstoreSkuDomain.setTenantCode(whOpstoreGoodsDomain.getTenantCode());
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cskuNo\u4e3a\u7a7a! ";
                }
                if (null != whOpstoreSkuDomain.getGoodsNum()) continue;
                msg = msg + "\u7b2c" + i + "-" + j + "\u884cgoodsNum\u4e3a\u7a7a! ";
            }
        }
        return msg;
    }

    private String checkWarehouse(WhWarehouseDomain whWarehouseDomain) {
        QueryResult<WhWarehouseReDomain> qlist;
        if (null == whWarehouseDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whWarehouseDomain.getWarehouseOcode())) {
            msg = msg + "warehouseOcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whWarehouseDomain.getWarehouseName())) {
            msg = msg + "warehouseName\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whWarehouseDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isNotBlank((String)whWarehouseDomain.getWarehouseOcode()) && null != (qlist = this.queryWarehousePage(this.getQueryMapParam("warehouseOcode,tenantCode", new Object[]{whWarehouseDomain.getWarehouseOcode(), whWarehouseDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            msg = msg + "warehouseOcode[" + whWarehouseDomain.getWarehouseOcode() + "]\u91cd\u590d! ";
        }
        return msg;
    }
}

