/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data;

import com.yqbsoft.laser.service.tool.util.StringUtils;

public class ComConstants {
    public static final String SYS_CODE = "busdata";
    public static final String success = "success";
    public static final String error = "error";
    private static final String[] NUMBERS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] IUNIT = new String[]{"\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] DUNIT = new String[]{"\u89d2", "\u5206", "\u5398"};

    public static String toChinese(String str) {
        String decimalStr;
        String integerStr;
        if (StringUtils.isBlank((String)str) || !str.matches("(-)?[\\d]*(.)?[\\d]*")) {
            return "\u62b1\u6b49\uff0c\u8bf7\u8f93\u5165\u6570\u5b57\uff01";
        }
        if ("0".equals(str) || "0.00".equals(str) || "0.0".equals(str)) {
            return "\u96f6\u5143";
        }
        boolean flag = false;
        if (str.startsWith("-")) {
            flag = true;
            str = str.replaceAll("-", "");
        }
        if ((str = str.replaceAll(",", "")).indexOf(".") > 0) {
            integerStr = str.substring(0, str.indexOf("."));
            decimalStr = str.substring(str.indexOf(".") + 1);
        } else if (str.indexOf(".") == 0) {
            integerStr = "";
            decimalStr = str.substring(1);
        } else {
            integerStr = str;
            decimalStr = "";
        }
        if (integerStr.length() > IUNIT.length) {
            return "\u8d85\u51fa\u8ba1\u7b97\u80fd\u529b\uff01";
        }
        int[] integers = ComConstants.toIntArray(integerStr);
        if (integers.length > 1 && integers[0] == 0) {
            return "\u62b1\u6b49\uff0c\u8f93\u5165\u6570\u5b57\u4e0d\u7b26\u5408\u8981\u6c42\uff01";
        }
        boolean isWan = ComConstants.isWan5(integerStr);
        int[] decimals = ComConstants.toIntArray(decimalStr);
        String result = ComConstants.getChineseInteger(integers, isWan) + ComConstants.getChineseDecimal(decimals);
        if (flag) {
            return "\u8d1f" + result;
        }
        return result;
    }

    private static int[] toIntArray(String number) {
        int[] array = new int[number.length()];
        for (int i = 0; i < number.length(); ++i) {
            array[i] = Integer.parseInt(number.substring(i, i + 1));
        }
        return array;
    }

    public static String getChineseInteger(int[] integers, boolean isWan) {
        StringBuffer chineseInteger = new StringBuffer("");
        int length = integers.length;
        if (length == 1 && integers[0] == 0) {
            return "";
        }
        for (int i = 0; i < length; ++i) {
            String key = "";
            if (integers[i] == 0) {
                if (length - i == 13) {
                    key = IUNIT[4];
                } else if (length - i == 9) {
                    key = IUNIT[8];
                } else if (length - i == 5 && isWan) {
                    key = IUNIT[4];
                } else if (length - i == 1) {
                    key = IUNIT[0];
                }
                if (length - i > 1 && integers[i + 1] != 0) {
                    key = key + NUMBERS[0];
                }
            }
            chineseInteger.append(integers[i] == 0 ? key : NUMBERS[integers[i]] + IUNIT[length - i - 1]);
        }
        return chineseInteger.toString();
    }

    private static String getChineseDecimal(int[] decimals) {
        StringBuffer chineseDecimal = new StringBuffer("");
        for (int i = 0; i < decimals.length && i != 3; ++i) {
            chineseDecimal.append(decimals[i] == 0 ? "" : NUMBERS[decimals[i]] + DUNIT[i]);
        }
        return chineseDecimal.toString();
    }

    private static boolean isWan5(String integerStr) {
        int length = integerStr.length();
        if (length > 4) {
            String subInteger = "";
            subInteger = length > 8 ? integerStr.substring(length - 8, length - 4) : integerStr.substring(0, length - 4);
            return Integer.parseInt(subInteger) > 0;
        }
        return false;
    }

    public static void main(String[] args) {
        String number = "12.56";
        System.out.println(number + ": " + ComConstants.toChinese(number));
        number = "1234567890563886.123";
        System.out.println(number + ": " + ComConstants.toChinese(number));
    }
}

