/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.dd.DdFalgSetting;
import com.yqbsoft.laser.service.ext.bus.data.domain.dd.DdFalgSettingDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.log.LogErrorLog;
import com.yqbsoft.laser.service.ext.bus.data.domain.log.LogErrorLogDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.PteBalancelist;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.PteBalancelistOp;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.PteBalanceop;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.PteBalanceopGoods;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.Customer;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUser;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserDomainBean;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfo;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoDomainBeanA;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoapply;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoapplyDomain;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.um.UmUserinfoRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.um.UmUserinfoResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusUserService;
import com.yqbsoft.laser.service.ext.bus.data.supbase.UserinfoBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.OkhttpsUtils;
import com.yqbsoft.laser.service.ext.bus.data.util.SqlServerUtils;
import com.yqbsoft.laser.service.ext.bus.data.util.UserInfo;
import com.yqbsoft.laser.service.ext.bus.data.util.WordToPdfAndBase64;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class BusUserServiceImpl
extends UserinfoBaseService
implements BusUserService {
    private String SYS_CODE = "busdata.BusUserServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusUserServiceImpl.class);
    private String ddcode = "user";
    @Autowired
    RestTempfacade restTempfacade;
    private static ThreadPoolExecutor userThreadPoolExecutor = new ThreadPoolExecutor(16, 32, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private static ThreadPoolExecutor userCompensateThreadPoolExecutor = new ThreadPoolExecutor(16, 32, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    @Override
    public String sendSaveBusUserinfo(UmUserinfoReDomain umUserinfo, UmUserReDomain umUser, String optype) {
        if (null == umUserinfo) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfo");
            return "error";
        }
        String tenantCode = umUserinfo.getTenantCode();
        String url = umUserinfo.getWebSiteUrl();
        if (StringUtils.isNotBlank((String)url)) {
            if (url.indexOf("http") != 0) {
                url = "http://" + url;
            }
            url = url + "/laserEr/http/post/{apiCode}/1.0/" + tenantCode + "/utf-8/shangshu";
            umUserinfo.setWebSiteUrl(url);
        }
        UmUserinfoRequest umUserinfoRequest = new UmUserinfoRequest();
        umUserinfoRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        umUserinfoRequest.setOrgTenantCode(umUserinfo.getTenantCode());
        String t = this.getTenantCodeBuUrl(umUserinfoRequest.getHost());
        if (StringUtils.isNotBlank((String)t)) {
            umUserinfo.setTenantCode(t);
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoRequest, (Object)umUserinfo);
            if (StringUtils.isBlank((String)t)) {
                umUserinfoRequest.setTenantCode(umUserinfoRequest.getToTenantCode());
            }
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.e", (Throwable)e);
            return "error";
        }
        UmUserinfoResponse umUserinfoResponse = this.restTempfacade.execute(umUserinfoRequest);
        if (null == umUserinfoResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse");
            return "error";
        }
        if (!umUserinfoResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse", (Object)umUserinfoResponse.getMsg());
            return umUserinfoResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusUserinfoSeal(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSeal.umUserinfo");
            return "error";
        }
        String url = this.getDdFlag(umUserinfo.getTenantCode(), "UserinfoSeal", "UserinfoSeal");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("companyName", umUserinfo.getUserinfoCompname());
        map.put("generateMode", umUserinfo.getUserinfoCert1No());
        map.put("sealImage", umUserinfo.getUserinfoRemark());
        map.put("sealName", umUser.getUserName());
        map.put("sealType", umUserinfo.getUserinfoCert2No());
        map.put("userId", umUserinfo.getUserinfoOpcode1());
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
        map.put("sealAttribute", map1);
        map1.put("centralGraphic", "star");
        map1.put("centralGraphicSize", 60);
        map1.put("mainFont", umUserinfo.getUserinfoCompname());
        map1.put("mainFontSize", 22);
        map1.put("mainFontSpace", 22.0);
        map1.put("mainFontMargin", 4);
        map1.put("sealColor", "red");
        map1.put("sealSize", "300*300");
        map1.put("sealTemplate", BusUserServiceImpl.getMessage(umUserinfo.getUserinfoCert2No()));
        map1.put("titleFont", "\u5370\u7ae0\u6807\u9898");
        map1.put("titleFontSize", 16);
        map1.put("titleFontSpace", 8.0);
        map1.put("titleFontMargin", 54);
        map1.put("viceFont", "1BJ00000A01");
        map1.put("viceFontSize", 22);
        map1.put("viceFontSpace", 22.0);
        map1.put("viceFontMargin", 3);
        String data = null;
        try {
            data = OkhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSeal.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSeal.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSeal.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Object sealId;
                HashMap<String, Object> mapStr = new HashMap<String, Object>();
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                if (MapUtil.isNotEmpty((Map)returnResultsMap1) && null != (sealId = returnResultsMap1.get("sealId"))) {
                    mapStr.put("userinfoOpcode2", sealId);
                }
                mapStr.put("userinfoCode", umUserinfo.getUserinfoCode());
                mapStr.put("userinfoCert2Url", "1");
                this.sendOpenUserinfo(mapStr);
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSeal.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSeal.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendQueryBusUserinfoSeal(String tenantCode, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSeal", (Object)tenantCode);
            throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfoSeal.ex");
        }
        String url = this.getDdFlag(tenantCode, "UserinfoSeal", "UserinfoSeal");
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSeal.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (StringUtils.isBlank((String)url)) {
            throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfoSeal.ex");
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        Long startTime = System.currentTimeMillis();
        String data = "{\"total\":1,\"rows\":null,\"data\":[{\"sealId\":1676,\"userId\":2893,\"platformCode\":\"HBIS_TY\",\"sealType\":\"qyht\",\"generateMode\":\"autogeneration\",\"sealName\":\"18721632233\",\"companyName\":\"\u6587\u78ca\",\"bucketName\":\"qz-obs\",\"sealImageKey\":\"202411121207030312473262310\",\"sealImage\":\"https://qz-obs.obs.cn-north-4.myhuaweicloud.com:443/202411121207030312473262310\"}],\"code\":200,\"msg\":\"\u67e5\u8be2\u6210\u529f\"}";
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSeal.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSeal.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfoSeal.ex2");
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return returnResultsMap.get("data").toString();
            }
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSeal.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfoSeal.ex3");
        }
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSeal.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfoSeal.ex4");
    }

    @Override
    public String sendUpdateBusUserinfoSeal(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoSeal.umUserinfo");
            return "error";
        }
        String url = this.getDdFlag(umUserinfo.getTenantCode(), "UserinfoSeal", "UserinfoSeal");
        logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoSeal.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("sealId", umUserinfo.getUserinfoOpcode1());
        map.put("companyName", umUserinfo.getUserinfoCompname());
        map.put("generateMode", umUserinfo.getUserinfoCert1No());
        map.put("sealImage", umUserinfo.getUserinfoRemark());
        map.put("sealName", umUser.getUserName());
        map.put("sealType", umUserinfo.getUserinfoCert2No());
        map.put("userId", umUserinfo.getUserinfoOpcode1());
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
        map.put("sealAttribute", map1);
        map1.put("centralGraphic", "star");
        map1.put("centralGraphicSize", 60);
        map1.put("mainFont", umUserinfo.getUserinfoCompname());
        map1.put("mainFontSize", 22);
        map1.put("mainFontSpace", 22.0);
        map1.put("mainFontMargin", 4);
        map1.put("sealColor", "red");
        map1.put("titleFont", "\u5370\u7ae0\u6807\u9898");
        map1.put("titleFontSize", 16);
        map1.put("titleFontSpace", 8.0);
        map1.put("titleFontMargin", 54);
        map1.put("viceFont", "1BJ00000A01");
        map1.put("viceFontSize", 22);
        map1.put("viceFontSpace", 22.0);
        map1.put("viceFontMargin", 3);
        String data = null;
        try {
            data = OkhttpsUtils.doPut(url, JsonUtil.buildNormalBinder().toJson(map), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoSeal.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoSeal.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoSeal.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoSeal.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoSeal.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendDeleteBusUserinfoSeal(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSeal.umUserinfo");
            return "error";
        }
        String url = this.getDdFlag(umUserinfo.getTenantCode(), "UserinfoSeal", "UserinfoSeal");
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSeal.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("sealId", "");
        String param = "";
        param = param + "sealId=" + map.get("sealId");
        url = url + param;
        String data = null;
        try {
            data = OkhttpsUtils.doDelete(url, null, header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSeal.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSeal.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSeal.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Object sealId;
                HashMap<String, Object> mapStr = new HashMap<String, Object>();
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                if (MapUtil.isNotEmpty((Map)returnResultsMap1) && null != (sealId = returnResultsMap1.get("sealId"))) {
                    mapStr.put("userinfoOpcode2", sealId);
                }
                mapStr.put("userinfoCode", umUserinfo.getUserinfoCode());
                mapStr.put("userinfoCert2Url", "1");
                this.sendOpenUserinfo(mapStr);
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSeal.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSeal.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendSaveBusUserinfoTransactor(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.umUserinfo", (Object)(JsonUtil.buildNormalBinder().toJson((Object)umUserinfo) + "umUser" + JsonUtil.buildNormalBinder().toJson((Object)umUser)));
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.umUserinfo");
            return "error";
        }
        String url = this.getDdFlag(umUserinfo.getTenantCode(), "Transactor", "Transactor");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("userId", umUserinfo.getUserinfoOpcode1());
        map.put("transactorName", umUser.getUserName());
        map.put("identTypeCode", umUser.getUserQq());
        map.put("identNo", umUser.getUserImgurl());
        map.put("email", umUser.getUserEmial());
        map.put("mobilePhone", umUser.getUserPhone());
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        String data = null;
        try {
            data = OkhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Object transactorId;
                HashMap<String, Object> mapStr = new HashMap<String, Object>();
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                if (MapUtil.isNotEmpty((Map)returnResultsMap1) && null != (transactorId = returnResultsMap1.get("transactorId"))) {
                    umUser.setUserCacode(transactorId.toString());
                    mapStr.put("userCacode", transactorId);
                    mapStr.put("userCode", umUser.getUserCode());
                }
                this.sendOpenUser(mapStr);
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendDeleteBusUserinfoTransactor(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.umUserinfo", (Object)(JsonUtil.buildNormalBinder().toJson((Object)umUserinfo) + "umUser" + JsonUtil.buildNormalBinder().toJson((Object)umUser)));
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.umUserinfo");
            return "error";
        }
        String url = this.getDdFlag(umUserinfo.getTenantCode(), "DeleteTransactor", "DeleteTransactor");
        url = url + "/" + umUser.getUserCacode();
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        String data = null;
        try {
            data = OkhttpsUtils.doDelete(url, null, header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.isnull" + url, (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.data" + data + "url" + url, (Object)("startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.returnResultsMap" + url + data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.code" + url, (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoTransactor.code.1" + url, (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendQueryBusUserinfoTransactor(String tenantCode, Map<String, Object> map) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSeal", (Object)tenantCode);
            throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfoSeal.ex");
        }
        String url = this.getDdFlag(tenantCode, "Transactor", "Transactor");
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoTransactor.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        Long startTime = System.currentTimeMillis();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", map.get("userId"));
        map1.put("transactorId", map.get("transactorId"));
        String param = "";
        param = param + "userId=" + map1.get("userId");
        if (null != map1.get("transactorId")) {
            param = param + "&transactorId=" + map1.get("transactorId");
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        String data = null;
        try {
            data = OkhttpsUtils.doGet(url, param, header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoTransactor.isnull" + url, (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoTransactor.data" + data + "url" + url, (Object)("startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoTransactor.returnResultsMap" + url, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Object transactorId;
                HashMap<String, Object> mapStr = new HashMap<String, Object>();
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                if (!MapUtil.isNotEmpty((Map)returnResultsMap1) || null != (transactorId = returnResultsMap1.get("transactorId"))) {
                    // empty if block
                }
                this.sendOpenUser(mapStr);
                return JsonUtil.buildNonNullBinder().toJson((Object)returnResultsMap1);
            }
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoTransactor.code" + url, (Object)returnResultsMap.toString());
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoTransactor.code.1" + url, (Object)returnResultsMap.toString());
        return null;
    }

    @Override
    public String sendSaveBusUserinfoSealAuthority(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSealAuthority.umUserinfo");
            return "error";
        }
        String url = this.getDdFlag(umUserinfo.getTenantCode(), "SealAuthority", "SealAuthority");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("expireTime", BusUserServiceImpl.getDate());
        map.put("sealId", umUserinfo.getUserinfoOpcode2());
        map.put("transactorId", umUser.getUserCacode());
        map.put("userId", umUserinfo.getUserinfoOpcode1());
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        String data = null;
        try {
            data = OkhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSealAuthority.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSealAuthority.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSealAuthority.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSealAuthority.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoSealAuthority.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendQueryBusUserinfoSealAuthority(String tenantCode, Map<String, Object> map) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority", (Object)tenantCode);
            throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority.ex");
        }
        String url = this.getDdFlag(tenantCode, "SealAuthority", "SealAuthority");
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        Long startTime = System.currentTimeMillis();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("pageNum", map.get("pageNum"));
        map1.put("pageSize", map.get("pageSize"));
        map1.put("sealId", map.get("sealId"));
        map1.put("authStatus", map.get("authStatus"));
        String param = "";
        param = param + "pageNum=" + map1.get("pageNum") + "&pageSize=" + map1.get("pageSize") + "&sealId=" + map1.get("sealId") + "&authStatus=" + map1.get("authStatus");
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        String data = null;
        try {
            data = OkhttpsUtils.doGet(url, param, header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority.isnull" + url, (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority.data" + data + "url" + url, (Object)("startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority.returnResultsMap" + url, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                return JsonUtil.buildNonNullBinder().toJson((Object)returnResultsMap1);
            }
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority.code" + url, (Object)returnResultsMap.toString());
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfoSealAuthority.code.1" + url, (Object)returnResultsMap.toString());
        return null;
    }

    @Override
    public String sendDeleteBusUserinfoSealAuthority(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSealAuthority.umUserinfo");
            return "error";
        }
        String url = this.getDdFlag(umUserinfo.getTenantCode(), "SealAuthority", "SealAuthority");
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSealAuthority.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("sealId", umUserinfo.getUserinfoOpcode2());
        map.put("transactorId", umUser.getUserCacode());
        map.put("userId", umUserinfo.getUserinfoOpcode1());
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        String param = "";
        param = param + "sealId=" + map.get("sealId") + "&transactorId=" + map.get("transactorId") + "&userId=" + map.get("userId");
        url = url + param;
        String data = null;
        try {
            data = OkhttpsUtils.doDelete(url, null, header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSealAuthority.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSealAuthority.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSealAuthority.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSealAuthority.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendDeleteBusUserinfoSealAuthority.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendSaveBusUserRegisterEnterpriseNew(UmUserinfo umUserinfo, UmUser umUser, String optype) throws ApiException {
        logger.error(this.SYS_CODE + ".sendSaveBusUserRegisterEnterpriseNew.umUserinfo", (Object)(JsonUtil.buildNormalBinder().toJson((Object)umUserinfo) + "umUser" + JsonUtil.buildNormalBinder().toJson((Object)umUser)));
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserRegisterEnterprise.umUserinfo");
            return "error";
        }
        String url = this.getDdFlag(umUserinfo.getTenantCode(), "Enterprise", "Enterprise");
        logger.error(this.SYS_CODE + ".sendSaveBusUserRegisterEnterprise.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("userName", umUserinfo.getUserinfoCompname());
        map.put("identTypeCode", umUserinfo.getUserinfoCert1No());
        map.put("identNo", umUserinfo.getUserinfoCert2No());
        map.put("email", umUserinfo.getUserinfoEmail());
        map.put("mobilePhone", umUserinfo.getUserinfoPhone());
        map.put("landlinePhone", umUserinfo.getUserinfoTel());
        map.put("authMode", umUserinfo.getMschannelName());
        map.put("transactorName", umUser.getUserName());
        map.put("transactorIdentTypeCode", umUser.getUserQq());
        map.put("transactorIdentNo", umUser.getUserImgurl());
        map.put("transactorAddress", umUserinfo.getCompanyAddress());
        map.put("notSendPwd", umUserinfo.getMschannelCode());
        String data = null;
        try {
            Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
            data = OkhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoRegisterPerson.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoRegisterPerson.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoRegisterPerson.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Object userId;
                HashMap<String, Object> mapStr = new HashMap<String, Object>();
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                if (MapUtil.isNotEmpty((Map)returnResultsMap1) && null != (userId = returnResultsMap1.get("userId"))) {
                    umUserinfo.setUserinfoOpcode1(userId.toString());
                    mapStr.put("userinfoOpcode1", userId);
                }
                mapStr.put("userinfoCode", umUserinfo.getUserinfoCode());
                mapStr.put("userinfoCert1Url", "1");
                this.sendOpenUserinfo(mapStr);
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                map1.put("userinfoSignCode", umUserinfo.getUserinfoOcode());
                map1.put("userinfoSignOcode", umUserinfo.getUserinfoOpcode1());
                map1.put("tenantCode", umUserinfo.getTenantCode());
                this.userinfoSignBuyOcode(map1);
                if ("company".equals(umUserinfo.getUserinfoQuality())) {
                    this.sendSaveBusUserinfoSeal(umUserinfo, umUser, optype);
                }
                if ("merchant".equals(umUserinfo.getUserinfoQuality())) {
                    this.sendSaveBusUserinfoByMerchantSeal(umUserinfo, umUser, optype);
                }
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoRegisterPerson.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoRegisterPerson.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendSaveBusUserUpdateContact(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.umUserinfo", (Object)(JsonUtil.buildNormalBinder().toJson((Object)umUserinfo) + "umUser" + JsonUtil.buildNormalBinder().toJson((Object)umUser)));
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.umUserinfo");
            return "error";
        }
        String url = this.getDdFlag(umUserinfo.getTenantCode(), "Contact", "Contact");
        logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("userId", umUserinfo.getUserinfoOpcode1());
        map.put("email", umUserinfo.getUserinfoEmail());
        map.put("mobilePhone", umUserinfo.getUserinfoPhone());
        String data = null;
        try {
            Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
            data = OkhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserUpdateContact.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendUpdateBusUserinfoTransactor(UmUserinfo umUserinfo, UmUser umUser, String optype) throws ApiException {
        logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.umUserinfo", (Object)(JsonUtil.buildNormalBinder().toJson((Object)umUserinfo) + "umUser" + JsonUtil.buildNormalBinder().toJson((Object)umUser)));
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.umUserinfo");
            return "error";
        }
        String url = this.getDdFlag(umUserinfo.getTenantCode(), "UpdateEnterprise", "UpdateEnterprise");
        logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("email", umUser.getUserEmial());
        map.put("mobilePhone", umUser.getUserPhone());
        map.put("transactorId", umUser.getUserCode());
        String data = null;
        try {
            Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
            data = OkhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendUpdateBusUserinfoTransactor.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    public String sendSaveBusUserinfoByMerchantSeal(UmUserinfo umUserinfo, UmUser umUser, String optype) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoByMerchantSeal.umUserinfo");
            return "error";
        }
        String url = this.getDdFlag(umUserinfo.getTenantCode(), "UserinfoSeal", "UserinfoSeal");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoTransactor.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return "error";
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("companyName", umUserinfo.getUserinfoCompname());
        map.put("generateMode", "autogeneration");
        map.put("sealImage", "");
        map.put("sealName", umUser.getUserName());
        map.put("sealType", "qyht");
        map.put("userId", umUserinfo.getUserinfoOpcode1());
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
        map.put("sealAttribute", map1);
        map1.put("centralGraphic", "star");
        map1.put("centralGraphicSize", 60);
        map1.put("mainFont", umUserinfo.getUserinfoCompname());
        map1.put("mainFontSize", 22);
        map1.put("mainFontSpace", 22.0);
        map1.put("mainFontMargin", 4);
        map1.put("sealColor", "red");
        map1.put("sealSize", "300*300");
        if ("merchant".equals(umUserinfo.getUserinfoQuality())) {
            map1.put("sealTemplate", "circle");
        } else {
            map1.put("sealTemplate", "circle");
        }
        map1.put("titleFont", "\u5370\u7ae0\u6807\u9898");
        map1.put("titleFontSize", 16);
        map1.put("titleFontSpace", 8.0);
        map1.put("titleFontMargin", 54);
        map1.put("viceFont", "1BJ00000A01");
        map1.put("viceFontSize", 22);
        map1.put("viceFontSpace", 22.0);
        map1.put("viceFontMargin", 3);
        String data = null;
        try {
            data = OkhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoByMerchantSeal.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoByMerchantSeal.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoByMerchantSeal.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Object sealId;
                HashMap<String, Object> mapStr = new HashMap<String, Object>();
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                if (MapUtil.isNotEmpty((Map)returnResultsMap1) && null != (sealId = returnResultsMap1.get("sealId"))) {
                    mapStr.put("userinfoOpcode2", sealId);
                    umUserinfo.setUserinfoOpcode2(sealId.toString());
                }
                mapStr.put("userinfoCode", umUserinfo.getUserinfoCode());
                mapStr.put("userinfoCert2Url", "1");
                this.sendOpenUserinfo(mapStr);
                this.sendSaveBusUserinfoTransactor(umUserinfo, umUser, optype);
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoByMerchantSeal.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoByMerchantSeal.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    private static Map<String, String> getStringStringMap(String tenantCode) {
        String hacckey;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("haccid", "256");
        header.put("hacckey", "97269a9502214c11bcf91b33a15c71c6");
        String haccid = BusUserServiceImpl.getddFlag(tenantCode, "haccid", "haccid");
        if (StringUtils.isNotBlank((String)haccid)) {
            header.put("haccid", haccid);
        }
        if (StringUtils.isNotBlank((String)(hacckey = BusUserServiceImpl.getddFlag(tenantCode, "hacckey", "hacckey")))) {
            header.put("hacckey", hacckey);
        }
        return header;
    }

    @Override
    public String sendSaveBusUserinfoImmediateSignature(String tenantCode, Map<String, Object> map1) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || MapUtil.isEmpty(map1)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature", null);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.ex");
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        String url = this.getDdFlag(tenantCode.toString(), "ImmediateSignature", "ImmediateSignature");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map1));
        if (StringUtils.isBlank((String)url)) {
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.ex");
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("userId", map1.get("userId"));
        map.put("sealId", map1.get("sealId"));
        map.put("transactorId", map1.get("transactorId"));
        map.put("projectCode", map1.get("projectCode"));
        map.put("keyword", map1.get("keyword"));
        map.put("offsetX", map1.get("offsetX"));
        map.put("offsetY", map1.get("offsetY"));
        map.put("imageWidth", map1.get("imageWidth"));
        map.put("imageHeight", map1.get("imageHeight"));
        map.put("contractName", map1.get("contractName"));
        map.put("contractNo", map1.get("contractNo"));
        PteBalancelist pteBalancelist = null;
        String base64EncodedPdf = null;
        if (null != map1.get("projectCode")) {
            pteBalancelist = this.getPteBalancelist(map1.get("projectCode").toString(), tenantCode);
            if (null == pteBalancelist) {
                logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.projectCode", (Object)map1.get("projectCode").toString());
                throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignatureProjectCode.ex");
            }
            HashMap<String, Object> mapStr = new HashMap<String, Object>();
            mapStr.put("balancelistCode", pteBalancelist.getBalancelistCode());
            mapStr.put("tenantCode", pteBalancelist.getTenantCode());
            ArrayList<PteBalanceopGoods> listGoods = new ArrayList<PteBalanceopGoods>();
            QueryResult<PteBalancelistOp> pteBalancelistOps = this.querypteBalancelistOpPage(mapStr);
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.pteBalancelistOps", mapStr);
            if (pteBalancelistOps != null && ListUtil.isNotEmpty((Collection)pteBalancelistOps.getList())) {
                for (PteBalancelistOp pteBalancelistOp : pteBalancelistOps.getList()) {
                    PteBalanceop balanceopByCode = this.getBalanceopByCode(pteBalancelistOp.getBalanceopCode(), pteBalancelistOp.getTenantCode());
                    logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.balanceopByCode", (Object)(pteBalancelistOp.getBalanceopCode() + "tenantCode" + pteBalancelistOp.getTenantCode()));
                    if (null == balanceopByCode) continue;
                    HashMap<String, Object> mapStr1 = new HashMap<String, Object>();
                    mapStr1.put("tenantCode", balanceopByCode.getTenantCode());
                    mapStr1.put("contractBillcode", balanceopByCode.getBusinessOrder());
                    QueryResult<PteBalanceopGoods> pteBalanceopGoodsQueryResult = this.queryBalanceopGoodsPage(mapStr1);
                    logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.pteBalanceopGoodsQueryResult", mapStr1);
                    if (pteBalanceopGoodsQueryResult == null || !ListUtil.isNotEmpty((Collection)pteBalanceopGoodsQueryResult.getList())) continue;
                    for (PteBalanceopGoods pteBalanceopGoods1 : pteBalanceopGoodsQueryResult.getList()) {
                        listGoods.add(pteBalanceopGoods1);
                    }
                }
            }
            if (ListUtil.isEmpty(listGoods)) {
                logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.listGoods.1", (Object)JsonUtil.buildNormalBinder().toJson(map1));
                throw new ApiException(this.SYS_CODE + ".listGoods.1.ex");
            }
            Date now = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            BigDecimal sumMoeny = BigDecimal.ZERO;
            BigDecimal suiMoeny = BigDecimal.ZERO;
            BigDecimal rate = BigDecimal.ZERO;
            int i = 1;
            ArrayList<UserInfo> userList = new ArrayList<UserInfo>();
            for (PteBalanceopGoods pteBalanceopGoods : listGoods) {
                UserInfo userInfo = new UserInfo();
                Integer j = i++;
                userInfo.setId(j.toString());
                userInfo.setName(pteBalanceopGoods.getGoodsName());
                if (null == pteBalanceopGoods.getGoodsCamount()) {
                    pteBalanceopGoods.setGoodsCamount(BigDecimal.ZERO);
                }
                userInfo.setNumber(pteBalanceopGoods.getGoodsCamount().setScale(2, RoundingMode.UP).toString());
                if (null == pteBalanceopGoods.getPricesetNprice()) {
                    pteBalanceopGoods.setPricesetNprice(BigDecimal.ZERO);
                }
                userInfo.setPrice(pteBalanceopGoods.getPricesetNprice().setScale(2, RoundingMode.UP).toString());
                if (null == pteBalanceopGoods.getPricesetInsideprice()) {
                    pteBalanceopGoods.setPricesetInsideprice(BigDecimal.ZERO);
                }
                BigDecimal sumPriceTax = pteBalanceopGoods.getPricesetNprice().subtract(pteBalanceopGoods.getPricesetNprice().multiply(pteBalanceopGoods.getPricesetInsideprice()).multiply(new BigDecimal("0.01")).setScale(2, RoundingMode.UP));
                userInfo.setPriceIncludingTax(sumPriceTax.toString());
                if (null == pteBalanceopGoods.getContractGoodsMoney()) {
                    pteBalanceopGoods.setContractGoodsMoney(BigDecimal.ZERO);
                }
                userInfo.setAmount(pteBalanceopGoods.getContractGoodsMoney().setScale(2, RoundingMode.UP).toString());
                if (null == pteBalanceopGoods.getPricesetInsideprice()) {
                    pteBalanceopGoods.setPricesetInsideprice(BigDecimal.ZERO);
                }
                BigDecimal sums = pteBalanceopGoods.getContractGoodsMoney().subtract(pteBalanceopGoods.getContractGoodsMoney().multiply(pteBalanceopGoods.getPricesetInsideprice()).multiply(new BigDecimal("0.01")).setScale(2, RoundingMode.UP));
                userInfo.setAmountIncludingTax(sums.toString());
                userInfo.setDeliveryTime(sdf.format(now));
                userInfo.setOrderNumber(pteBalanceopGoods.getContractBillcode());
                userInfo.setMaterialCode(pteBalanceopGoods.getSkuNo());
                if (StringUtils.isBlank((String)pteBalanceopGoods.getContractGoodsRemark())) {
                    pteBalanceopGoods.setContractGoodsRemark("\u6682\u65e0");
                }
                userInfo.setContractGoodsRemark(pteBalanceopGoods.getContractGoodsRemark());
                sumMoeny = sumMoeny.add(pteBalanceopGoods.getContractGoodsMoney());
                suiMoeny = suiMoeny.add(sums);
                rate = suiMoeny.divide(sumMoeny, 2, 4);
                userInfo.setRate(pteBalanceopGoods.getPricesetInsideprice().setScale(2, RoundingMode.UP).toString());
                userList.add(userInfo);
            }
            HashMap<String, Object> templateParam = new HashMap<String, Object>(5);
            templateParam.put("date", LocalDate.now());
            templateParam.put("total", userList.size());
            templateParam.put("userList", userList);
            templateParam.put("businessOrderno", map1.get("projectCode"));
            templateParam.put("sellers", pteBalancelist.getMemberName());
            templateParam.put("buyers", pteBalancelist.getMemberBname());
            templateParam.put("dateOfSigning", sdf.format(now));
            templateParam.put("totalAmount", sumMoeny.toString());
            templateParam.put("totalAmountIncludingTax", suiMoeny.toString());
            templateParam.put("totalAmountUpper", ComConstants.toChinese(sumMoeny.toString()));
            templateParam.put("totalAmountUpperTax", ComConstants.toChinese(suiMoeny.toString()));
            templateParam.put("seller", map1.get("seller"));
            templateParam.put("domicile1", map1.get("domicile1"));
            templateParam.put("representative", map1.get("representative"));
            templateParam.put("agent1", map1.get("agent1"));
            templateParam.put("phone1", map1.get("phone1"));
            templateParam.put("buyer", map1.get("buyer"));
            templateParam.put("domicile2", map1.get("domicile2"));
            templateParam.put("head", map1.get("head"));
            templateParam.put("agent2", map1.get("agent2"));
            templateParam.put("phone2", map1.get("phone2"));
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.listGoods.listGoods", (Object)JsonUtil.buildNormalBinder().toJson(listGoods));
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.listGoods.templateParam", (Object)JsonUtil.buildNormalBinder().toJson(templateParam));
            try {
                base64EncodedPdf = WordToPdfAndBase64.generate(templateParam, tenantCode);
            }
            catch (Exception e) {
                throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignaturebase64EncodedPdf.1.ex", (Throwable)e);
            }
        } else {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.projectCode.1", (Object)JsonUtil.buildNormalBinder().toJson(map1));
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignatureProjectCode.1.ex");
        }
        map.put("contractFile", "data:application/pdf;base64," + base64EncodedPdf);
        map.put("crossPageStyle", map1.get("crossPageStyle"));
        map.put("offsetCoordY", map1.get("offsetCoordY"));
        String data = null;
        try {
            data = OkhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.ex", (Throwable)e);
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature2.ex");
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature3.ex");
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoImmediateSignature4.ex");
    }

    @Override
    public String sendSaveBusUserinfoNonImmediateSignature(UmUserinfoReDomain umUserinfo, UmUserReDomain umUser) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoNonImmediateSignature.umUserinfo");
            return "error";
        }
        String url = "https://testinterfacem.hbisscm.com/inf/internal/v1/contract/nonImmediateSignature";
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(umUserinfo.getTenantCode());
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("contractNo", "");
        map.put("userId", "");
        map.put("sealId", "");
        map.put("transactorId", "");
        map.put("projectCode", "");
        map.put("keyword", "");
        map.put("offsetX", null);
        map.put("offsetY", null);
        map.put("imageWidth", null);
        map.put("imageHeight", null);
        map.put("contractName", null);
        map.put("contractNo", null);
        map.put("contractFile", null);
        map.put("crossPageStyle", null);
        map.put("offsetCoordY", null);
        String data = null;
        try {
            data = OkhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoNonImmediateSignature.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoNonImmediateSignature.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoNonImmediateSignature.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return returnResultsMap.get("data").toString();
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoNonImmediateSignature.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoNonImmediateSignature.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendSaveBusUserinfoBuyUploadContract(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.map", null);
            throw new ApiException(this.SYS_CODE + ".delBalancelistModelByCode.ex");
        }
        Object tenantCode = map.get("tenantCode");
        if (null == tenantCode) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.tenantCode", null);
            return "error";
        }
        String url = this.getDdFlag(tenantCode.toString(), "UploadContract", "UploadContract");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (StringUtils.isBlank((String)url)) {
            // empty if block
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode.toString());
        Long startTime = System.currentTimeMillis();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", map.get("userId"));
        map1.put("transactorId", map.get("transactorId"));
        map1.put("projectCode", map.get("projectCode"));
        map1.put("sealId", map.get("sealId"));
        map1.put("contractName", map.get("contractName"));
        map1.put("contractNo", map.get("contractNo"));
        map1.put("contractFile", map.get("contractFile"));
        map1.put("isProxySign", map.get("isProxySign"));
        String data = null;
        try {
            data = OkhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map1), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return returnResultsMap.get("data").toString();
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyUploadContract.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendSaveBusUserinfoBuyDownloadContract(String tenantCode, String contractNo, String userId, Map<String, Object> map) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNo) || StringUtils.isBlank((String)userId)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract", (Object)(tenantCode + "contractNo" + contractNo + "userId" + userId));
            return null;
        }
        String url = this.getDdFlag(tenantCode, "DownloadContract", "DownloadContract");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        Long startTime = System.currentTimeMillis();
        url = url + "/" + userId + "/" + contractNo;
        String data = null;
        try {
            data = OkhttpsUtils.doGet(url, null, header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return returnResultsMap.get("data").toString();
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            return null;
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return null;
    }

    protected static String getddFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    @Override
    public String sendSaveBusUserinfoBuySendVerificationCode(String tenantCode, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyDownloadContract", (Object)tenantCode);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.ex");
        }
        String url = this.getDdFlag(tenantCode, "SendVerificationCode", "SendVerificationCode");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (StringUtils.isBlank((String)url)) {
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.ex");
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        Long startTime = System.currentTimeMillis();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", map.get("userId"));
        map1.put("transactorId", map.get("transactorId"));
        map1.put("projectCode", map.get("projectCode"));
        map1.put("sealId", map.get("sealId"));
        String data = null;
        try {
            data = OkhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map1), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.ex.1", (Throwable)e);
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.ex.2");
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.ex.3");
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuySendVerificationCode.ex.4");
    }

    @Override
    public String sendSaveBusUserinfoBuyConfirmVerificationCode(String tenantCode, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode", (Object)tenantCode);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.ex");
        }
        String url = this.getDdFlag(tenantCode, "ConfirmVerificationCode", "ConfirmVerificationCode");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (StringUtils.isBlank((String)url)) {
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.ex");
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        Long startTime = System.currentTimeMillis();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", map.get("userId"));
        map1.put("transactorId", map.get("transactorId"));
        map1.put("projectCode", map.get("projectCode"));
        map1.put("checkCode", map.get("checkCode"));
        String data = null;
        try {
            data = OkhttpsUtils.doPost(url, JsonUtil.buildNormalBinder().toJson(map1), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.ex1", (Throwable)e);
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.ex2");
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.ex3");
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyConfirmVerificationCode.ex4");
    }

    @Override
    public String sendQueryBusUserinfo(String tenantCode, Map<String, Object> map) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfo", (Object)tenantCode);
            throw new ApiException(this.SYS_CODE + ".sendQueryBusUserinfo.ex");
        }
        String url = this.getDdFlag(tenantCode, "Userinfo", "Userinfo");
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfo.url", (Object)url);
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        Long startTime = System.currentTimeMillis();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", map.get("userId"));
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        String data = null;
        try {
            data = OkhttpsUtils.doGet(url, map.toString().substring(1, map.toString().length() - 1), header);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfo.isnull" + url, (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfo.data" + data + "url" + url, (Object)("startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfo.returnResultsMap" + url, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
                return JsonUtil.buildNonNullBinder().toJson((Object)returnResultsMap1);
            }
            logger.error(this.SYS_CODE + ".sendQueryBusUserinfo.code" + url, (Object)returnResultsMap.toString());
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryBusUserinfo.code.1" + url, (Object)returnResultsMap.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendInitailCustomerAndAdd(String tenantCode) {
        String localDateTime = this.getStringlocalDateTime();
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.tenantCode", (Object)"\u79df\u6237\u4e3a\u7a7a");
            return "\u79df\u6237\u4e3a\u7a7a,\u4e0d\u80fd\u521d\u59cb\u5316";
        }
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.localDateTime", (Object)localDateTime);
        InternalRouter internalRouter = this.getInternalRouter();
        if (null == internalRouter) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.internalRouter", (Object)"internalRouter is null");
            return "internalRouter is null";
        }
        DdFalgSetting ddFalgSetting = this.queryDdFlagSetting(tenantCode, internalRouter, "InitailCustomerAndAdd");
        if (null == ddFalgSetting) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.ddFalgSetting", (Object)"ddFalgSetting is null");
            return "ddFalgSetting is null";
        }
        Integer flagSettingId = ddFalgSetting.getFlagSettingId();
        String flagSettingInfo = ddFalgSetting.getFlagSettingInfo();
        logger.error(this.SYS_CODE + ".updateCustomer.flagSettingInfo", (Object)flagSettingInfo);
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.flagSettingInfo", (Object)flagSettingInfo);
        boolean initialUser = true;
        LocalDateTime args = null;
        String sql = "select  TOP 1 \n    cust.CreatedOn,\n\tcust.ModifiedOn,\n\tcase when relation.ToOrg>0 then relation.ToOrg else org.ID end ParentOrgID,\n\torg.ID OrgID,\n\torg.Code OrgCode,\n\torgTrl.Name OrgName,\n\tsupplyOrg.Code SupplyOrgCode,\n\tsupplyOrgTrl.Name SupplyOrgName,\n\tcust.ID CustID,\n\tcust.Code CustCode,\n\tcustTrl.Name CustName,\n\tcust.ShortName CustShortName,\n\tcust.SearchCode SearchCode,\n\tcustCategory.ID CustCategoryID,\n\tcustCategory.Code CustCategoryCode,\n\tcustCategoryTrl.Name CustCategoryName,\n\tcust.TradeCategory,\n\tcontact.Code ContactCode,\n\tcontactTrl.Name ContactName,\n\tlocation.Code LocationCode,\n\tlocationTrl.Name LocationName,\n\tprovinceTrl.Name Province,\n\tcityTrl.Name City,\n\tcurrency.Code CurrencyCode,\n\tcurrencyTrl.Name CurrencuName,\n\tcust.PriceListID,--\u4ef7\u8868ID\n\tcust.PriceListCode,\n\tcust.PriceListName,\n\ttax.Code TaxCode,\n\ttaxTrl.Name TaxName,\n\tcust.StateTaxNo,\n\tcust.Effective_IsEffective,\n\tcust.Effective_EffectiveDate,\n\tcust.Effective_DisableDate,\n\tdefineValue1.Code Prv1Code,--\u5730\u57df\u7f16\u7801\n\tdefineValue1Trl.Name Prv1Name,--\u5730\u57df\u540d\u79f0\n\tdefineValue2.Code Prv2Code,--\u5927\u533a\u7f16\u7801\n\tdefineValue2Trl.Name Prv2Name,--\u5927\u533a\u540d\u79f0\n\tdefineValue3.Code Prv3Code,--\u533a\u57df\u7f16\u7801\n\tdefineValue3Trl.Name Prv3Name,--\u533a\u57df\u540d\u79f0\n\t'' Prv4Code,\n\tcust.DescFlexField_PrivateDescSeg4 Prv4Name,--\u8054\u7cfb\u4eba\n\t'' Prv5Code,\n\tcust.DescFlexField_PrivateDescSeg5 Prv5Name,--\u8054\u7cfb\u7535\u8bdd\n\t'' Prv6Code,\n\tcust.DescFlexField_PrivateDescSeg6 Prv6Name,--\u6536\u8d27\u5730\u5740\n\t'' Prv7Code,\n\tcust.DescFlexField_PrivateDescSeg7 Prv7Name,--\u5907\u6ce8\n\tdefineValue4.Code Prv8Code,--\u7701\u4efd\u7f16\u7801\n\tdefineValue4Trl.Name Prv8Name,--\u7701\u4efd\u540d\u79f0\n\tdefineValue5.Code Prv9Code,--\u7ecf\u9500\u5546\u7f16\u7801\n\tdefineValue5Trl.Name Prv9Name,--\u7ecf\u9500\u5546\u540d\u79f0\n\t'' Prv10Code,\n\tcust.DescFlexField_PrivateDescSeg10 Prv10Name,--\u5408\u540c\u7532\u65b9\n\tdefineValue6.Code Prv11Code,--\u5c0f\u7ec4\u7f16\u7801\n\tdefineValue6Trl.Name Prv11Name,--\u5c0f\u7ec4\u540d\u79f0\n\t'' Prv12Code,\n\tcust.DescFlexField_PrivateDescSeg12 Prv12Name,--\u5ba2\u6237\u4fd7\u79f0\n\tdefineValue7.Code Prv13Code,--\u5730\u57df2\u7f16\u7801\n\tdefineValue7Trl.Name Prv13Name,--\u5730\u57df2\u540d\u79f0\n\tdefineValue8.Code Prv14Code,--\u5927\u533a2\u7f16\u7801\n\tdefineValue8Trl.Name Prv14Name,--\u5927\u533a2\u540d\u79f0\n\tdefineValue9.Code Prv15Code,--\u533a\u57df2\u7f16\u7801\n\tdefineValue9Trl.Name Prv15Name,--\u533a\u57df2\u540d\u79f0\n\tdefineValue10.Code Prv16Code,--\u9ed8\u8ba4\u6536\u8d27\u7701\u7f16\u7801\n\tdefineValue10Trl.Name Prv16Name,--\u9ed8\u8ba4\u6536\u8d27\u7701\u540d\u79f0\n\tdefineValue11.Code Prv17Code,--\u9ed8\u8ba4\u6536\u8d27\u5e02\u7f16\u7801\n\tdefineValue11Trl.Name Prv17Name,--\u9ed8\u8ba4\u6536\u8d27\u5e02\u540d\u79f0\n\t'' Prv18Code,\n\tcust.DescFlexField_PrivateDescSeg18 Prv18Name,--\u9ed8\u8ba4\u53d1\u8d27\u5730\u5740\n\tdefineValue12.Code Prv19Code,--\u6e20\u9053\u7f16\u7801\n\tdefineValue12Trl.Name Prv19Name,--\u6e20\u9053\u540d\u79f0\n\t'' Prv20Code,\n\tcust.DescFlexField_PrivateDescSeg20 Prv20Name,\n\t'' Prv21Code,\n\tcust.DescFlexField_PrivateDescSeg21 Prv21Name,\n\t'' Prv22Code,\n\tcust.DescFlexField_PrivateDescSeg22 Prv22Name,\n\t'' Prv23Code,\n\tcust.DescFlexField_PrivateDescSeg23 Prv23Name,\n\t'' Prv24Code,\n\tcust.DescFlexField_PrivateDescSeg24 Prv24Name,\n\t'' Prv25Code,\n\tcust.DescFlexField_PrivateDescSeg25 Prv25Name,\n\t'' Prv26Code,\n\tcust.DescFlexField_PrivateDescSeg26 Prv26Name,\n\t'' Prv27Code,\n\tcust.DescFlexField_PrivateDescSeg27 Prv27Name,\n\t'' Prv28Code,\n\tcust.DescFlexField_PrivateDescSeg28 Prv28Name,\n\t'' Prv29Code,\n\tcust.DescFlexField_PrivateDescSeg29 Prv29Name,\n\t'' Prv30Code,\n\tcust.DescFlexField_PrivateDescSeg30 Prv30Name\nfrom CBO_Customer cust\nleft join CBO_Customer_Trl custTrl on cust.ID=custTrl.ID\nleft join Base_Organization org on cust.Org=org.ID\nleft join Base_Organization_Trl orgTrl on cust.Org=org.ID and org.ID=orgTrl.ID and orgTrl.SysMLFlag='zh-CN'\nleft join Base_Organization supplyOrg on cust.SupplyOrg=supplyOrg.ID\nleft join Base_Organization_Trl supplyOrgTrl on cust.SupplyOrg=supplyOrgTrl.ID and supplyOrg.ID=supplyOrgTrl.ID and supplyOrgTrl.SysMLFlag='zh-CN'\nleft join CBO_OrgBusinessRelation relation on cust.Org=relation.FromOrg and BusinessRelationType=00\n--left join Base_Organization parentOrg on relation.ToOrg=parentOrg.ID\n--left join Base_Organization_Trl parentOrgTrl on parentOrg.ID=parentOrgTrl.ID and parentOrgTrl.SysMLFlag='zh-CN'\nleft join CBO_CustomerCategory custCategory on cust.CustomerCategory=custCategory.ID\nleft join CBO_CustomerCategory_Trl custCategoryTrl on cust.CustomerCategory=custCategoryTrl.ID and custCategory.ID=custCategoryTrl.ID and custCategoryTrl.SysMLFlag='zh-CN'\nleft join Base_Contact contact on cust.DefaultContact=contact.ID\nleft join Base_Contact_Trl contactTrl on cust.DefaultContact=contactTrl.ID and contact.ID=contactTrl.ID and contactTrl.SysMLFlag='zh-CN'\nleft join Base_Location location on cust.OfficialLocation=location.ID\nleft join Base_Location_Trl locationTrl on location.ID=locationTrl.ID and locationTrl.ID=cust.OfficialLocation and locationTrl.SysMLFlag='zh-CN'\nleft join Base_Province_Trl provinceTrl on location.Province=provinceTrl.ID and provinceTrl.SysMLFlag='zh-CN'\nleft join Base_City_Trl cityTrl on location.City=cityTrl.ID and cityTrl.SysMLFlag='zh-CN'\nleft join Base_Currency currency on cust.TradeCurrency=currency.ID\nleft join Base_Currency_Trl currencyTrl on cust.TradeCurrency=currencyTrl.ID and currency.ID=currencyTrl.ID and currencyTrl.SysMLFlag='zh-CN'\nleft join CBO_TaxSchedule tax on cust.TaxSchedule=tax.ID\nleft join CBO_TaxSchedule_Trl taxTrl on cust.TaxSchedule=taxTrl.ID and tax.ID=taxTrl.ID and taxTrl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet1 on valueSet1.Code='Z008'--\u5730\u57df\nleft join Base_DefineValue defineValue1 on valueSet1.ID=defineValue1.ValueSetDef and defineValue1.Code=cust.DescFlexField_PrivateDescSeg1\nleft join Base_DefineValue_Trl defineValue1Trl on defineValue1.ID=defineValue1Trl.ID and defineValue1Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet2 on valueSet2.Code='Z015'--\u5927\u533a\nleft join Base_DefineValue defineValue2 on valueSet2.ID=defineValue2.ValueSetDef and defineValue2.Code=cust.DescFlexField_PrivateDescSeg2\nleft join Base_DefineValue_Trl defineValue2Trl on defineValue2.ID=defineValue2Trl.ID and defineValue2Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet3 on valueSet3.Code='Z009'--\u533a\u57df\nleft join Base_DefineValue defineValue3 on valueSet3.ID=defineValue3.ValueSetDef and defineValue3.Code=cust.DescFlexField_PrivateDescSeg3\nleft join Base_DefineValue_Trl defineValue3Trl on defineValue3.ID=defineValue3Trl.ID and defineValue3Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet4 on valueSet4.Code='Z028'--\u7701\u4efd\nleft join Base_DefineValue defineValue4 on valueSet4.ID=defineValue4.ValueSetDef and defineValue4.Code=cust.DescFlexField_PrivateDescSeg8\nleft join Base_DefineValue_Trl defineValue4Trl on defineValue4.ID=defineValue4Trl.ID and defineValue4Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet5 on valueSet5.Code='Z001'--\u7ecf\u9500\u5546\nleft join Base_DefineValue defineValue5 on valueSet5.ID=defineValue5.ValueSetDef and defineValue5.Code=cust.DescFlexField_PrivateDescSeg9\nleft join Base_DefineValue_Trl defineValue5Trl on defineValue5.ID=defineValue5Trl.ID and defineValue5Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet6 on valueSet6.Code='Z030'--\u5c0f\u7ec4\nleft join Base_DefineValue defineValue6 on valueSet6.ID=defineValue6.ValueSetDef and defineValue6.Code=cust.DescFlexField_PrivateDescSeg11\nleft join Base_DefineValue_Trl defineValue6Trl on defineValue6.ID=defineValue6Trl.ID and defineValue6Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet7 on valueSet7.Code='Z008'--\u5730\u57df2\nleft join Base_DefineValue defineValue7 on valueSet7.ID=defineValue7.ValueSetDef and defineValue7.Code=cust.DescFlexField_PrivateDescSeg13\nleft join Base_DefineValue_Trl defineValue7Trl on defineValue7.ID=defineValue7Trl.ID and defineValue7Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet8 on valueSet8.Code='Z015'--\u5927\u533a2\nleft join Base_DefineValue defineValue8 on valueSet8.ID=defineValue8.ValueSetDef and defineValue8.Code=cust.DescFlexField_PrivateDescSeg14\nleft join Base_DefineValue_Trl defineValue8Trl on defineValue8.ID=defineValue8Trl.ID and defineValue8Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet9 on valueSet9.Code='Z009'--\u533a\u57df2\nleft join Base_DefineValue defineValue9 on valueSet9.ID=defineValue9.ValueSetDef and defineValue9.Code=cust.DescFlexField_PrivateDescSeg15\nleft join Base_DefineValue_Trl defineValue9Trl on defineValue9.ID=defineValue9Trl.ID and defineValue9Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet10 on valueSet10.Code='Z046'--\u9ed8\u8ba4\u6536\u8d27\u7701\nleft join Base_DefineValue defineValue10 on valueSet10.ID=defineValue10.ValueSetDef and defineValue10.Code=cust.DescFlexField_PrivateDescSeg16\nleft join Base_DefineValue_Trl defineValue10Trl on defineValue10.ID=defineValue10Trl.ID and defineValue10Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet11 on valueSet11.Code='Z047'--\u9ed8\u8ba4\u6536\u8d27\u5e02\nleft join Base_DefineValue defineValue11 on valueSet11.ID=defineValue11.ValueSetDef and defineValue11.Code=cust.DescFlexField_PrivateDescSeg17\nleft join Base_DefineValue_Trl defineValue11Trl on defineValue11.ID=defineValue11Trl.ID and defineValue11Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet12 on valueSet12.Code='Z045'--\u6e20\u9053\nleft join Base_DefineValue defineValue12 on valueSet12.ID=defineValue12.ValueSetDef and defineValue12.Code=cust.DescFlexField_PrivateDescSeg19\nleft join Base_DefineValue_Trl defineValue12Trl on defineValue12.ID=defineValue12Trl.ID and defineValue12Trl.SysMLFlag='zh-CN' \nWHERE org.Code = '001'\nORDER BY cust.CreatedOn asc";
        if (StringUtils.isNotBlank((String)flagSettingInfo)) {
            sql = "select \n    cust.CreatedOn,\n\tcust.ModifiedOn,\n\tcase when relation.ToOrg>0 then relation.ToOrg else org.ID end ParentOrgID,\n\torg.ID OrgID,\n\torg.Code OrgCode,\n\torgTrl.Name OrgName,\n\tsupplyOrg.Code SupplyOrgCode,\n\tsupplyOrgTrl.Name SupplyOrgName,\n\tcust.ID CustID,\n\tcust.Code CustCode,\n\tcustTrl.Name CustName,\n\tcust.ShortName CustShortName,\n\tcust.SearchCode SearchCode,\n\tcustCategory.ID CustCategoryID,\n\tcustCategory.Code CustCategoryCode,\n\tcustCategoryTrl.Name CustCategoryName,\n\tcust.TradeCategory,\n\tcontact.Code ContactCode,\n\tcontactTrl.Name ContactName,\n\tlocation.Code LocationCode,\n\tlocationTrl.Name LocationName,\n\tprovinceTrl.Name Province,\n\tcityTrl.Name City,\n\tcurrency.Code CurrencyCode,\n\tcurrencyTrl.Name CurrencuName,\n\tcust.PriceListID,--\u4ef7\u8868ID\n\tcust.PriceListCode,\n\tcust.PriceListName,\n\ttax.Code TaxCode,\n\ttaxTrl.Name TaxName,\n\tcust.StateTaxNo,\n\tcust.Effective_IsEffective,\n\tcust.Effective_EffectiveDate,\n\tcust.Effective_DisableDate,\n\tdefineValue1.Code Prv1Code,--\u5730\u57df\u7f16\u7801\n\tdefineValue1Trl.Name Prv1Name,--\u5730\u57df\u540d\u79f0\n\tdefineValue2.Code Prv2Code,--\u5927\u533a\u7f16\u7801\n\tdefineValue2Trl.Name Prv2Name,--\u5927\u533a\u540d\u79f0\n\tdefineValue3.Code Prv3Code,--\u533a\u57df\u7f16\u7801\n\tdefineValue3Trl.Name Prv3Name,--\u533a\u57df\u540d\u79f0\n\t'' Prv4Code,\n\tcust.DescFlexField_PrivateDescSeg4 Prv4Name,--\u8054\u7cfb\u4eba\n\t'' Prv5Code,\n\tcust.DescFlexField_PrivateDescSeg5 Prv5Name,--\u8054\u7cfb\u7535\u8bdd\n\t'' Prv6Code,\n\tcust.DescFlexField_PrivateDescSeg6 Prv6Name,--\u6536\u8d27\u5730\u5740\n\t'' Prv7Code,\n\tcust.DescFlexField_PrivateDescSeg7 Prv7Name,--\u5907\u6ce8\n\tdefineValue4.Code Prv8Code,--\u7701\u4efd\u7f16\u7801\n\tdefineValue4Trl.Name Prv8Name,--\u7701\u4efd\u540d\u79f0\n\tdefineValue5.Code Prv9Code,--\u7ecf\u9500\u5546\u7f16\u7801\n\tdefineValue5Trl.Name Prv9Name,--\u7ecf\u9500\u5546\u540d\u79f0\n\t'' Prv10Code,\n\tcust.DescFlexField_PrivateDescSeg10 Prv10Name,--\u5408\u540c\u7532\u65b9\n\tdefineValue6.Code Prv11Code,--\u5c0f\u7ec4\u7f16\u7801\n\tdefineValue6Trl.Name Prv11Name,--\u5c0f\u7ec4\u540d\u79f0\n\t'' Prv12Code,\n\tcust.DescFlexField_PrivateDescSeg12 Prv12Name,--\u5ba2\u6237\u4fd7\u79f0\n\tdefineValue7.Code Prv13Code,--\u5730\u57df2\u7f16\u7801\n\tdefineValue7Trl.Name Prv13Name,--\u5730\u57df2\u540d\u79f0\n\tdefineValue8.Code Prv14Code,--\u5927\u533a2\u7f16\u7801\n\tdefineValue8Trl.Name Prv14Name,--\u5927\u533a2\u540d\u79f0\n\tdefineValue9.Code Prv15Code,--\u533a\u57df2\u7f16\u7801\n\tdefineValue9Trl.Name Prv15Name,--\u533a\u57df2\u540d\u79f0\n\tdefineValue10.Code Prv16Code,--\u9ed8\u8ba4\u6536\u8d27\u7701\u7f16\u7801\n\tdefineValue10Trl.Name Prv16Name,--\u9ed8\u8ba4\u6536\u8d27\u7701\u540d\u79f0\n\tdefineValue11.Code Prv17Code,--\u9ed8\u8ba4\u6536\u8d27\u5e02\u7f16\u7801\n\tdefineValue11Trl.Name Prv17Name,--\u9ed8\u8ba4\u6536\u8d27\u5e02\u540d\u79f0\n\t'' Prv18Code,\n\tcust.DescFlexField_PrivateDescSeg18 Prv18Name,--\u9ed8\u8ba4\u53d1\u8d27\u5730\u5740\n\tdefineValue12.Code Prv19Code,--\u6e20\u9053\u7f16\u7801\n\tdefineValue12Trl.Name Prv19Name,--\u6e20\u9053\u540d\u79f0\n\t'' Prv20Code,\n\tcust.DescFlexField_PrivateDescSeg20 Prv20Name,\n\t'' Prv21Code,\n\tcust.DescFlexField_PrivateDescSeg21 Prv21Name,\n\t'' Prv22Code,\n\tcust.DescFlexField_PrivateDescSeg22 Prv22Name,\n\t'' Prv23Code,\n\tcust.DescFlexField_PrivateDescSeg23 Prv23Name,\n\t'' Prv24Code,\n\tcust.DescFlexField_PrivateDescSeg24 Prv24Name,\n\t'' Prv25Code,\n\tcust.DescFlexField_PrivateDescSeg25 Prv25Name,\n\t'' Prv26Code,\n\tcust.DescFlexField_PrivateDescSeg26 Prv26Name,\n\t'' Prv27Code,\n\tcust.DescFlexField_PrivateDescSeg27 Prv27Name,\n\t'' Prv28Code,\n\tcust.DescFlexField_PrivateDescSeg28 Prv28Name,\n\t'' Prv29Code,\n\tcust.DescFlexField_PrivateDescSeg29 Prv29Name,\n\t'' Prv30Code,\n\tcust.DescFlexField_PrivateDescSeg30 Prv30Name\nfrom CBO_Customer cust\nleft join CBO_Customer_Trl custTrl on cust.ID=custTrl.ID\nleft join Base_Organization org on cust.Org=org.ID\nleft join Base_Organization_Trl orgTrl on cust.Org=org.ID and org.ID=orgTrl.ID and orgTrl.SysMLFlag='zh-CN'\nleft join Base_Organization supplyOrg on cust.SupplyOrg=supplyOrg.ID\nleft join Base_Organization_Trl supplyOrgTrl on cust.SupplyOrg=supplyOrgTrl.ID and supplyOrg.ID=supplyOrgTrl.ID and supplyOrgTrl.SysMLFlag='zh-CN'\nleft join CBO_OrgBusinessRelation relation on cust.Org=relation.FromOrg and BusinessRelationType=00\n--left join Base_Organization parentOrg on relation.ToOrg=parentOrg.ID\n--left join Base_Organization_Trl parentOrgTrl on parentOrg.ID=parentOrgTrl.ID and parentOrgTrl.SysMLFlag='zh-CN'\nleft join CBO_CustomerCategory custCategory on cust.CustomerCategory=custCategory.ID\nleft join CBO_CustomerCategory_Trl custCategoryTrl on cust.CustomerCategory=custCategoryTrl.ID and custCategory.ID=custCategoryTrl.ID and custCategoryTrl.SysMLFlag='zh-CN'\nleft join Base_Contact contact on cust.DefaultContact=contact.ID\nleft join Base_Contact_Trl contactTrl on cust.DefaultContact=contactTrl.ID and contact.ID=contactTrl.ID and contactTrl.SysMLFlag='zh-CN'\nleft join Base_Location location on cust.OfficialLocation=location.ID\nleft join Base_Location_Trl locationTrl on location.ID=locationTrl.ID and locationTrl.ID=cust.OfficialLocation and locationTrl.SysMLFlag='zh-CN'\nleft join Base_Province_Trl provinceTrl on location.Province=provinceTrl.ID and provinceTrl.SysMLFlag='zh-CN'\nleft join Base_City_Trl cityTrl on location.City=cityTrl.ID and cityTrl.SysMLFlag='zh-CN'\nleft join Base_Currency currency on cust.TradeCurrency=currency.ID\nleft join Base_Currency_Trl currencyTrl on cust.TradeCurrency=currencyTrl.ID and currency.ID=currencyTrl.ID and currencyTrl.SysMLFlag='zh-CN'\nleft join CBO_TaxSchedule tax on cust.TaxSchedule=tax.ID\nleft join CBO_TaxSchedule_Trl taxTrl on cust.TaxSchedule=taxTrl.ID and tax.ID=taxTrl.ID and taxTrl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet1 on valueSet1.Code='Z008'--\u5730\u57df\nleft join Base_DefineValue defineValue1 on valueSet1.ID=defineValue1.ValueSetDef and defineValue1.Code=cust.DescFlexField_PrivateDescSeg1\nleft join Base_DefineValue_Trl defineValue1Trl on defineValue1.ID=defineValue1Trl.ID and defineValue1Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet2 on valueSet2.Code='Z015'--\u5927\u533a\nleft join Base_DefineValue defineValue2 on valueSet2.ID=defineValue2.ValueSetDef and defineValue2.Code=cust.DescFlexField_PrivateDescSeg2\nleft join Base_DefineValue_Trl defineValue2Trl on defineValue2.ID=defineValue2Trl.ID and defineValue2Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet3 on valueSet3.Code='Z009'--\u533a\u57df\nleft join Base_DefineValue defineValue3 on valueSet3.ID=defineValue3.ValueSetDef and defineValue3.Code=cust.DescFlexField_PrivateDescSeg3\nleft join Base_DefineValue_Trl defineValue3Trl on defineValue3.ID=defineValue3Trl.ID and defineValue3Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet4 on valueSet4.Code='Z028'--\u7701\u4efd\nleft join Base_DefineValue defineValue4 on valueSet4.ID=defineValue4.ValueSetDef and defineValue4.Code=cust.DescFlexField_PrivateDescSeg8\nleft join Base_DefineValue_Trl defineValue4Trl on defineValue4.ID=defineValue4Trl.ID and defineValue4Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet5 on valueSet5.Code='Z001'--\u7ecf\u9500\u5546\nleft join Base_DefineValue defineValue5 on valueSet5.ID=defineValue5.ValueSetDef and defineValue5.Code=cust.DescFlexField_PrivateDescSeg9\nleft join Base_DefineValue_Trl defineValue5Trl on defineValue5.ID=defineValue5Trl.ID and defineValue5Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet6 on valueSet6.Code='Z030'--\u5c0f\u7ec4\nleft join Base_DefineValue defineValue6 on valueSet6.ID=defineValue6.ValueSetDef and defineValue6.Code=cust.DescFlexField_PrivateDescSeg11\nleft join Base_DefineValue_Trl defineValue6Trl on defineValue6.ID=defineValue6Trl.ID and defineValue6Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet7 on valueSet7.Code='Z008'--\u5730\u57df2\nleft join Base_DefineValue defineValue7 on valueSet7.ID=defineValue7.ValueSetDef and defineValue7.Code=cust.DescFlexField_PrivateDescSeg13\nleft join Base_DefineValue_Trl defineValue7Trl on defineValue7.ID=defineValue7Trl.ID and defineValue7Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet8 on valueSet8.Code='Z015'--\u5927\u533a2\nleft join Base_DefineValue defineValue8 on valueSet8.ID=defineValue8.ValueSetDef and defineValue8.Code=cust.DescFlexField_PrivateDescSeg14\nleft join Base_DefineValue_Trl defineValue8Trl on defineValue8.ID=defineValue8Trl.ID and defineValue8Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet9 on valueSet9.Code='Z009'--\u533a\u57df2\nleft join Base_DefineValue defineValue9 on valueSet9.ID=defineValue9.ValueSetDef and defineValue9.Code=cust.DescFlexField_PrivateDescSeg15\nleft join Base_DefineValue_Trl defineValue9Trl on defineValue9.ID=defineValue9Trl.ID and defineValue9Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet10 on valueSet10.Code='Z046'--\u9ed8\u8ba4\u6536\u8d27\u7701\nleft join Base_DefineValue defineValue10 on valueSet10.ID=defineValue10.ValueSetDef and defineValue10.Code=cust.DescFlexField_PrivateDescSeg16\nleft join Base_DefineValue_Trl defineValue10Trl on defineValue10.ID=defineValue10Trl.ID and defineValue10Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet11 on valueSet11.Code='Z047'--\u9ed8\u8ba4\u6536\u8d27\u5e02\nleft join Base_DefineValue defineValue11 on valueSet11.ID=defineValue11.ValueSetDef and defineValue11.Code=cust.DescFlexField_PrivateDescSeg17\nleft join Base_DefineValue_Trl defineValue11Trl on defineValue11.ID=defineValue11Trl.ID and defineValue11Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet12 on valueSet12.Code='Z045'--\u6e20\u9053\nleft join Base_DefineValue defineValue12 on valueSet12.ID=defineValue12.ValueSetDef and defineValue12.Code=cust.DescFlexField_PrivateDescSeg19\nleft join Base_DefineValue_Trl defineValue12Trl on defineValue12.ID=defineValue12Trl.ID and defineValue12Trl.SysMLFlag='zh-CN' \nWHERE org.Code = '001' AND cust.CreatedOn > ?\nORDER BY cust.CreatedOn asc";
            args = this.getLocalDateTime(flagSettingInfo);
            initialUser = false;
        }
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.sql", (Object)sql);
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.args", (Object)args);
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.initialUser", (Object)initialUser);
        List<Customer> customerListFromU9 = null;
        try {
            if (initialUser) {
                this.saveDdFlag(internalRouter, tenantCode, "customerUpdateBeginTime", "\u5ba2\u6237\u4fee\u6539\u8d77\u59cb\u65f6\u95f4", localDateTime, null);
            }
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.queryU9", (Object)"\u67e5\u8be2U9\u5ba2\u6237\u6570\u636e\u5f00\u59cb");
            customerListFromU9 = SqlServerUtils.getForList(Customer.class, sql, args);
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.queryU9", (Object)"\u67e5\u8be2U9\u5ba2\u6237\u6570\u636e\u7ed3\u675f");
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.customerListFromU9.size", (Object)customerListFromU9.size());
            if (ListUtil.isEmpty(customerListFromU9)) {
                logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.queryU9", (Object)"\u67e5\u8be2U9\u5ba2\u6237\u6570\u636e\u4e3a\u7a7a");
                return "\u6ca1\u6709\u65b0\u589e\u7684\u5ba2\u6237\u4fe1\u606f";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.view", (Object)"\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
            return "\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898";
        }
        for (Customer customer : customerListFromU9) {
            this.saveUserinfo(tenantCode, internalRouter, customer);
        }
        Customer lastCreateCustomer = customerListFromU9.get(customerListFromU9.size() - 1);
        try {
            this.updateFalgSettingInFoByKey(internalRouter, "InitailCustomerAndAdd", tenantCode, lastCreateCustomer.getCreatedOn(), flagSettingId);
        }
        finally {
            userThreadPoolExecutor.shutdownNow();
        }
        return "Success";
    }

    private void saveDdFlag(InternalRouter internalRouter, String tenantCode, String flagSettingCode, String flagSettingPro, String localTime, String businessFlag) {
        final DdFalgSettingDomain ddFalgSettingDomain = new DdFalgSettingDomain();
        ddFalgSettingDomain.setTenantCode(tenantCode);
        ddFalgSettingDomain.setFlagSettingInfo(localTime);
        ddFalgSettingDomain.setFlagSettingCode(flagSettingCode);
        ddFalgSettingDomain.setFlagSettingScope(flagSettingCode);
        ddFalgSettingDomain.setFlagSettingPro(flagSettingPro);
        if (StringUtils.isNotBlank((String)businessFlag)) {
            ddFalgSettingDomain.setFlagSettingPro1(businessFlag);
        }
        HashMap<String, Object> saveDdFlagParamMap = new HashMap<String, Object>(){
            {
                this.put("falgSettingDomain", JsonUtil.buildNormalBinder().toJson((Object)ddFalgSettingDomain));
            }
        };
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.saveDdFlag.saveDdFlagParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)saveDdFlagParamMap));
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.saveDdFlag", (Object)"\u4fdd\u5b58customerUpdateBeginTime ddFlag\u5f00\u59cb");
        internalRouter.inInvoke("dd.falgSetting.saveFalgSetting", (Map)saveDdFlagParamMap);
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.saveDdFlag", (Object)"\u4fdd\u5b58customerUpdateBeginTime ddFlag\u7ed3\u675f");
    }

    @Override
    public String sendInitailCustomerCompensate(final String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.tenantCode", (Object)"tenantCode is null");
            return "tenantCode is null";
        }
        InternalRouter internalRouter = this.getInternalRouter();
        if (null == internalRouter) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerCompensate.internalRouter", (Object)"internalRouter is null");
            return "internalRouter is null";
        }
        final HashMap<String, Object> logMap = new HashMap<String, Object>(){
            {
                this.put("fuzzy", true);
                this.put("tenantCode", tenantCode);
                this.put("clientExecuteMethod", "busdata.exUser.sendInitailCustomerCompensate");
                this.put("dataState", 0);
            }
        };
        HashMap<String, Object> logParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)logMap));
            }
        };
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.logParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)logParamMap));
        String logStr = (String)internalRouter.inInvoke("log.log.queryErrorLogPage", (Map)logParamMap);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(logStr, SupQueryResult.class);
        List logList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), LogErrorLog.class);
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.logList", (Object)JsonUtil.buildNormalBinder().toJson((Object)logList));
        if (ListUtil.isEmpty((Collection)logList)) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.logList", (Object)JsonUtil.buildNormalBinder().toJson((Object)logList));
            return "logList is null\uff0c\u6ca1\u6709\u5f85\u8865\u507f\u7684\u65b0\u589e\u8bb0\u5f55";
        }
        for (LogErrorLog logErrorLog : logList) {
            Customer customer = (Customer)JsonUtil.buildNonDefaultBinder().getJsonToObject(logErrorLog.getErrorLogMessage(), Customer.class);
            if ("customerInitialUserinfo".equals(logErrorLog.getErrorType())) {
                this.saveUserinfo(tenantCode, internalRouter, customer);
            } else {
                UmUser umUser = this.getUmUser(customer, tenantCode, internalRouter);
                this.saveUserinfoApplyList(internalRouter, customer, umUser.getUserPcode(), tenantCode);
            }
            this.updateLogState(internalRouter, logErrorLog, logErrorLog.getDataState(), 4);
        }
        return null;
    }

    @Override
    public String sendUpdateCustomer(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".updateCustomer.tenantCode", (Object)"tenantCode is null");
            return "tenantCode is null";
        }
        InternalRouter internalRouter = this.getInternalRouter();
        if (null == internalRouter) {
            logger.error(this.SYS_CODE + ".updateCustomer.internalRouter", (Object)"internalRouter is null");
            return "internalRouter is null";
        }
        DdFalgSetting ddFalgSetting = this.queryDdFlagSetting(tenantCode, internalRouter, "customerUpdateBeginTime");
        if (null == ddFalgSetting) {
            logger.error(this.SYS_CODE + ".updateCustomer.ddFalgSetting", (Object)"ddFalgSetting is null");
            return "ddFalgSetting is null";
        }
        Integer flagSettingId = ddFalgSetting.getFlagSettingId();
        String flagSettingInfo = ddFalgSetting.getFlagSettingInfo();
        logger.error(this.SYS_CODE + ".updateCustomer.flagSettingInfo", (Object)flagSettingInfo);
        if (StringUtils.isBlank((String)flagSettingInfo)) {
            logger.error(this.SYS_CODE + ".updateCustomer.internalRouter", (Object)"flagSettingInfo is null ");
        }
        List<Customer> customerListFromU9 = null;
        try {
            logger.error(this.SYS_CODE + ".updateCustomer.queryU9", (Object)"\u67e5\u8be2U9\u5ba2\u6237\u6570\u636e\u5f00\u59cb");
            customerListFromU9 = SqlServerUtils.getForList(Customer.class, "select \n    cust.CreatedOn,\n\tcust.ModifiedOn,\n\tcase when relation.ToOrg>0 then relation.ToOrg else org.ID end ParentOrgID,\n\torg.ID OrgID,\n\torg.Code OrgCode,\n\torgTrl.Name OrgName,\n\tsupplyOrg.Code SupplyOrgCode,\n\tsupplyOrgTrl.Name SupplyOrgName,\n\tcust.ID CustID,\n\tcust.Code CustCode,\n\tcustTrl.Name CustName,\n\tcust.ShortName CustShortName,\n\tcust.SearchCode SearchCode,\n\tcustCategory.ID CustCategoryID,\n\tcustCategory.Code CustCategoryCode,\n\tcustCategoryTrl.Name CustCategoryName,\n\tcust.TradeCategory,\n\tcontact.Code ContactCode,\n\tcontactTrl.Name ContactName,\n\tlocation.Code LocationCode,\n\tlocationTrl.Name LocationName,\n\tprovinceTrl.Name Province,\n\tcityTrl.Name City,\n\tcurrency.Code CurrencyCode,\n\tcurrencyTrl.Name CurrencuName,\n\tcust.PriceListID,--\u4ef7\u8868ID\n\tcust.PriceListCode,\n\tcust.PriceListName,\n\ttax.Code TaxCode,\n\ttaxTrl.Name TaxName,\n\tcust.StateTaxNo,\n\tcust.Effective_IsEffective,\n\tcust.Effective_EffectiveDate,\n\tcust.Effective_DisableDate,\n\tdefineValue1.Code Prv1Code,--\u5730\u57df\u7f16\u7801\n\tdefineValue1Trl.Name Prv1Name,--\u5730\u57df\u540d\u79f0\n\tdefineValue2.Code Prv2Code,--\u5927\u533a\u7f16\u7801\n\tdefineValue2Trl.Name Prv2Name,--\u5927\u533a\u540d\u79f0\n\tdefineValue3.Code Prv3Code,--\u533a\u57df\u7f16\u7801\n\tdefineValue3Trl.Name Prv3Name,--\u533a\u57df\u540d\u79f0\n\t'' Prv4Code,\n\tcust.DescFlexField_PrivateDescSeg4 Prv4Name,--\u8054\u7cfb\u4eba\n\t'' Prv5Code,\n\tcust.DescFlexField_PrivateDescSeg5 Prv5Name,--\u8054\u7cfb\u7535\u8bdd\n\t'' Prv6Code,\n\tcust.DescFlexField_PrivateDescSeg6 Prv6Name,--\u6536\u8d27\u5730\u5740\n\t'' Prv7Code,\n\tcust.DescFlexField_PrivateDescSeg7 Prv7Name,--\u5907\u6ce8\n\tdefineValue4.Code Prv8Code,--\u7701\u4efd\u7f16\u7801\n\tdefineValue4Trl.Name Prv8Name,--\u7701\u4efd\u540d\u79f0\n\tdefineValue5.Code Prv9Code,--\u7ecf\u9500\u5546\u7f16\u7801\n\tdefineValue5Trl.Name Prv9Name,--\u7ecf\u9500\u5546\u540d\u79f0\n\t'' Prv10Code,\n\tcust.DescFlexField_PrivateDescSeg10 Prv10Name,--\u5408\u540c\u7532\u65b9\n\tdefineValue6.Code Prv11Code,--\u5c0f\u7ec4\u7f16\u7801\n\tdefineValue6Trl.Name Prv11Name,--\u5c0f\u7ec4\u540d\u79f0\n\t'' Prv12Code,\n\tcust.DescFlexField_PrivateDescSeg12 Prv12Name,--\u5ba2\u6237\u4fd7\u79f0\n\tdefineValue7.Code Prv13Code,--\u5730\u57df2\u7f16\u7801\n\tdefineValue7Trl.Name Prv13Name,--\u5730\u57df2\u540d\u79f0\n\tdefineValue8.Code Prv14Code,--\u5927\u533a2\u7f16\u7801\n\tdefineValue8Trl.Name Prv14Name,--\u5927\u533a2\u540d\u79f0\n\tdefineValue9.Code Prv15Code,--\u533a\u57df2\u7f16\u7801\n\tdefineValue9Trl.Name Prv15Name,--\u533a\u57df2\u540d\u79f0\n\tdefineValue10.Code Prv16Code,--\u9ed8\u8ba4\u6536\u8d27\u7701\u7f16\u7801\n\tdefineValue10Trl.Name Prv16Name,--\u9ed8\u8ba4\u6536\u8d27\u7701\u540d\u79f0\n\tdefineValue11.Code Prv17Code,--\u9ed8\u8ba4\u6536\u8d27\u5e02\u7f16\u7801\n\tdefineValue11Trl.Name Prv17Name,--\u9ed8\u8ba4\u6536\u8d27\u5e02\u540d\u79f0\n\t'' Prv18Code,\n\tcust.DescFlexField_PrivateDescSeg18 Prv18Name,--\u9ed8\u8ba4\u53d1\u8d27\u5730\u5740\n\tdefineValue12.Code Prv19Code,--\u6e20\u9053\u7f16\u7801\n\tdefineValue12Trl.Name Prv19Name,--\u6e20\u9053\u540d\u79f0\n\t'' Prv20Code,\n\tcust.DescFlexField_PrivateDescSeg20 Prv20Name,\n\t'' Prv21Code,\n\tcust.DescFlexField_PrivateDescSeg21 Prv21Name,\n\t'' Prv22Code,\n\tcust.DescFlexField_PrivateDescSeg22 Prv22Name,\n\t'' Prv23Code,\n\tcust.DescFlexField_PrivateDescSeg23 Prv23Name,\n\t'' Prv24Code,\n\tcust.DescFlexField_PrivateDescSeg24 Prv24Name,\n\t'' Prv25Code,\n\tcust.DescFlexField_PrivateDescSeg25 Prv25Name,\n\t'' Prv26Code,\n\tcust.DescFlexField_PrivateDescSeg26 Prv26Name,\n\t'' Prv27Code,\n\tcust.DescFlexField_PrivateDescSeg27 Prv27Name,\n\t'' Prv28Code,\n\tcust.DescFlexField_PrivateDescSeg28 Prv28Name,\n\t'' Prv29Code,\n\tcust.DescFlexField_PrivateDescSeg29 Prv29Name,\n\t'' Prv30Code,\n\tcust.DescFlexField_PrivateDescSeg30 Prv30Name\nfrom CBO_Customer cust\nleft join CBO_Customer_Trl custTrl on cust.ID=custTrl.ID\nleft join Base_Organization org on cust.Org=org.ID\nleft join Base_Organization_Trl orgTrl on cust.Org=org.ID and org.ID=orgTrl.ID and orgTrl.SysMLFlag='zh-CN'\nleft join Base_Organization supplyOrg on cust.SupplyOrg=supplyOrg.ID\nleft join Base_Organization_Trl supplyOrgTrl on cust.SupplyOrg=supplyOrgTrl.ID and supplyOrg.ID=supplyOrgTrl.ID and supplyOrgTrl.SysMLFlag='zh-CN'\nleft join CBO_OrgBusinessRelation relation on cust.Org=relation.FromOrg and BusinessRelationType=00\n--left join Base_Organization parentOrg on relation.ToOrg=parentOrg.ID\n--left join Base_Organization_Trl parentOrgTrl on parentOrg.ID=parentOrgTrl.ID and parentOrgTrl.SysMLFlag='zh-CN'\nleft join CBO_CustomerCategory custCategory on cust.CustomerCategory=custCategory.ID\nleft join CBO_CustomerCategory_Trl custCategoryTrl on cust.CustomerCategory=custCategoryTrl.ID and custCategory.ID=custCategoryTrl.ID and custCategoryTrl.SysMLFlag='zh-CN'\nleft join Base_Contact contact on cust.DefaultContact=contact.ID\nleft join Base_Contact_Trl contactTrl on cust.DefaultContact=contactTrl.ID and contact.ID=contactTrl.ID and contactTrl.SysMLFlag='zh-CN'\nleft join Base_Location location on cust.OfficialLocation=location.ID\nleft join Base_Location_Trl locationTrl on location.ID=locationTrl.ID and locationTrl.ID=cust.OfficialLocation and locationTrl.SysMLFlag='zh-CN'\nleft join Base_Province_Trl provinceTrl on location.Province=provinceTrl.ID and provinceTrl.SysMLFlag='zh-CN'\nleft join Base_City_Trl cityTrl on location.City=cityTrl.ID and cityTrl.SysMLFlag='zh-CN'\nleft join Base_Currency currency on cust.TradeCurrency=currency.ID\nleft join Base_Currency_Trl currencyTrl on cust.TradeCurrency=currencyTrl.ID and currency.ID=currencyTrl.ID and currencyTrl.SysMLFlag='zh-CN'\nleft join CBO_TaxSchedule tax on cust.TaxSchedule=tax.ID\nleft join CBO_TaxSchedule_Trl taxTrl on cust.TaxSchedule=taxTrl.ID and tax.ID=taxTrl.ID and taxTrl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet1 on valueSet1.Code='Z008'--\u5730\u57df\nleft join Base_DefineValue defineValue1 on valueSet1.ID=defineValue1.ValueSetDef and defineValue1.Code=cust.DescFlexField_PrivateDescSeg1\nleft join Base_DefineValue_Trl defineValue1Trl on defineValue1.ID=defineValue1Trl.ID and defineValue1Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet2 on valueSet2.Code='Z015'--\u5927\u533a\nleft join Base_DefineValue defineValue2 on valueSet2.ID=defineValue2.ValueSetDef and defineValue2.Code=cust.DescFlexField_PrivateDescSeg2\nleft join Base_DefineValue_Trl defineValue2Trl on defineValue2.ID=defineValue2Trl.ID and defineValue2Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet3 on valueSet3.Code='Z009'--\u533a\u57df\nleft join Base_DefineValue defineValue3 on valueSet3.ID=defineValue3.ValueSetDef and defineValue3.Code=cust.DescFlexField_PrivateDescSeg3\nleft join Base_DefineValue_Trl defineValue3Trl on defineValue3.ID=defineValue3Trl.ID and defineValue3Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet4 on valueSet4.Code='Z028'--\u7701\u4efd\nleft join Base_DefineValue defineValue4 on valueSet4.ID=defineValue4.ValueSetDef and defineValue4.Code=cust.DescFlexField_PrivateDescSeg8\nleft join Base_DefineValue_Trl defineValue4Trl on defineValue4.ID=defineValue4Trl.ID and defineValue4Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet5 on valueSet5.Code='Z001'--\u7ecf\u9500\u5546\nleft join Base_DefineValue defineValue5 on valueSet5.ID=defineValue5.ValueSetDef and defineValue5.Code=cust.DescFlexField_PrivateDescSeg9\nleft join Base_DefineValue_Trl defineValue5Trl on defineValue5.ID=defineValue5Trl.ID and defineValue5Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet6 on valueSet6.Code='Z030'--\u5c0f\u7ec4\nleft join Base_DefineValue defineValue6 on valueSet6.ID=defineValue6.ValueSetDef and defineValue6.Code=cust.DescFlexField_PrivateDescSeg11\nleft join Base_DefineValue_Trl defineValue6Trl on defineValue6.ID=defineValue6Trl.ID and defineValue6Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet7 on valueSet7.Code='Z008'--\u5730\u57df2\nleft join Base_DefineValue defineValue7 on valueSet7.ID=defineValue7.ValueSetDef and defineValue7.Code=cust.DescFlexField_PrivateDescSeg13\nleft join Base_DefineValue_Trl defineValue7Trl on defineValue7.ID=defineValue7Trl.ID and defineValue7Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet8 on valueSet8.Code='Z015'--\u5927\u533a2\nleft join Base_DefineValue defineValue8 on valueSet8.ID=defineValue8.ValueSetDef and defineValue8.Code=cust.DescFlexField_PrivateDescSeg14\nleft join Base_DefineValue_Trl defineValue8Trl on defineValue8.ID=defineValue8Trl.ID and defineValue8Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet9 on valueSet9.Code='Z009'--\u533a\u57df2\nleft join Base_DefineValue defineValue9 on valueSet9.ID=defineValue9.ValueSetDef and defineValue9.Code=cust.DescFlexField_PrivateDescSeg15\nleft join Base_DefineValue_Trl defineValue9Trl on defineValue9.ID=defineValue9Trl.ID and defineValue9Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet10 on valueSet10.Code='Z046'--\u9ed8\u8ba4\u6536\u8d27\u7701\nleft join Base_DefineValue defineValue10 on valueSet10.ID=defineValue10.ValueSetDef and defineValue10.Code=cust.DescFlexField_PrivateDescSeg16\nleft join Base_DefineValue_Trl defineValue10Trl on defineValue10.ID=defineValue10Trl.ID and defineValue10Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet11 on valueSet11.Code='Z047'--\u9ed8\u8ba4\u6536\u8d27\u5e02\nleft join Base_DefineValue defineValue11 on valueSet11.ID=defineValue11.ValueSetDef and defineValue11.Code=cust.DescFlexField_PrivateDescSeg17\nleft join Base_DefineValue_Trl defineValue11Trl on defineValue11.ID=defineValue11Trl.ID and defineValue11Trl.SysMLFlag='zh-CN'\nleft join Base_ValueSetDef valueSet12 on valueSet12.Code='Z045'--\u6e20\u9053\nleft join Base_DefineValue defineValue12 on valueSet12.ID=defineValue12.ValueSetDef and defineValue12.Code=cust.DescFlexField_PrivateDescSeg19\nleft join Base_DefineValue_Trl defineValue12Trl on defineValue12.ID=defineValue12Trl.ID and defineValue12Trl.SysMLFlag='zh-CN' \nWHERE cust.ModifiedOn > cust.CreatedOn AND cust.ModifiedOn >= ?\nORDER BY cust.ModifiedOn asc", this.getLocalDateTime(flagSettingInfo));
            logger.error(this.SYS_CODE + ".updateCustomer.queryU9", (Object)"\u67e5\u8be2U9\u5ba2\u6237\u6570\u636e\u7ed3\u675f");
            logger.error(this.SYS_CODE + ".updateCustomer.customerListFromU9.size", (Object)customerListFromU9.size());
            if (ListUtil.isEmpty(customerListFromU9)) {
                logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.queryU9", (Object)"\u6ca1\u6709\u4fee\u6539\u7684\u5ba2\u6237\u4fe1\u606f");
                return "\u6ca1\u6709\u4fee\u6539\u7684\u5ba2\u6237\u4fe1\u606f";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".updateCustomer.view", (Object)"\u4fee\u6539\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
            return "\u4fee\u6539\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898";
        }
        String modifiedon = "";
        logger.error(this.SYS_CODE + ".updateCustomer.modifiedon", (Object)modifiedon);
        for (Customer customer : customerListFromU9) {
            try {
                modifiedon = customer.getModifiedOn();
                UmUser umUser = this.getUmUser(customer, tenantCode, internalRouter);
                if (null == umUser) {
                    logger.error(this.SYS_CODE + ".updateCustomer.modifiedon.null=umUser", (Object)modifiedon);
                    logger.error(this.SYS_CODE + ".updateCustomer.lastModifyUse.null=umUser", (Object)JsonUtil.buildNormalBinder().toJson((Object)customer));
                    this.updateFalgSettingInFoByKey(internalRouter, "customerUpdateBeginTime", tenantCode, modifiedon, flagSettingId);
                    logger.error(this.SYS_CODE + ".updateCustomer.customer.null=umUser", (Object)("\u672a\u63d2\u5165customer:" + JsonUtil.buildNormalBinder().toJson((Object)customer) + ",\u4e0d\u80fd\u505a\u4fee\u6539"));
                    return "\u672a\u63d2\u5165customer: " + customer.getCustCode() + ",\u4e0d\u80fd\u505a\u4fee\u6539";
                }
                this.compareUserAndUserinfoApply(internalRouter, tenantCode, customer, umUser);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".updateCustomer.modifiedon.e", (Object)modifiedon);
                logger.error(this.SYS_CODE + ".updateCustomer.lastModifyUse.e", (Object)JsonUtil.buildNormalBinder().toJson((Object)customer));
                logger.error(this.SYS_CODE + ".updateCustomer.customer.e", (Object)("\u6bd4\u8f83\u51fa\u9519:" + JsonUtil.buildNormalBinder().toJson((Object)customer)));
                this.updateFalgSettingInFoByKey(internalRouter, "customerUpdateBeginTime", tenantCode, modifiedon, flagSettingId);
                return "\u6bd4\u8f83\u51fa\u9519: " + customer.getCustCode();
            }
        }
        LocalDateTime localDateTime = this.getLocalDateTime(modifiedon);
        LocalDateTime localDateTimePlus1N = localDateTime.plusNanos(1L);
        logger.error(this.SYS_CODE + ".updateCustomer.localDateTime", (Object)localDateTime);
        logger.error(this.SYS_CODE + ".updateCustomer.localDateTimePlus1N", (Object)localDateTimePlus1N);
        this.updateFalgSettingInFoByKey(internalRouter, "customerUpdateBeginTime", tenantCode, this.getStringlocalDateTimeBy(localDateTimePlus1N), flagSettingId);
        return "SUCCESS";
    }

    private void compareUserAndUserinfoApply(InternalRouter internalRouter, String tenantCode, Customer customer, UmUser umUser) throws Exception {
        this.compareUserAndUserinfo(internalRouter, tenantCode, customer, umUser);
        List<UmUserinfoapply> applyList = this.queryUserinfoApply(internalRouter, tenantCode, customer);
        boolean minYong = false;
        boolean gongCheng = false;
        UmUserinfoapply umUserinfoapplyMinYong = null;
        UmUserinfoapply umUserinfoapplGongCheng = null;
        for (UmUserinfoapply umUserinfoapply : applyList) {
            if (umUserinfoapply.getUserinfoDischannelname().equals("\u6c11\u7528")) {
                minYong = true;
                umUserinfoapplyMinYong = umUserinfoapply;
                continue;
            }
            if (!umUserinfoapply.getUserinfoDischannelname().equals("\u5de5\u7a0b")) continue;
            gongCheng = true;
            umUserinfoapplGongCheng = umUserinfoapply;
        }
        String prv10Name = customer.getPrv10Name();
        String[] split = prv10Name.split(",");
        UmUserinfoapplyDomain mingYongApplyU = null;
        UmUserinfoapplyDomain gongChengApplyU = null;
        boolean minYongU = false;
        boolean gongChengU = false;
        if (split.length == 1) {
            DdFalgSetting ddFalgSetting = this.queryDdFlagSettingBySettingCodeAndInfo(tenantCode, internalRouter, "ContractPartA", prv10Name);
            if ("\u6c11\u7528".equals(ddFalgSetting.getFlagSettingPro())) {
                mingYongApplyU = this.buildMinYongApply(customer, tenantCode, umUser.getUserPcode(), prv10Name, ddFalgSetting.getFlagSettingPro1());
                minYongU = true;
            } else if ("\u5de5\u7a0b".equals(ddFalgSetting.getFlagSettingPro())) {
                gongChengApplyU = this.buildGongchengApply(customer, tenantCode, umUser.getUserPcode(), prv10Name, ddFalgSetting.getFlagSettingPro1());
                gongChengU = true;
            }
        } else {
            String s = split[0];
            String s1 = split[1];
            final DdFalgSetting ddFalgSetting = this.queryDdFlagSettingBySettingCodeAndInfo(tenantCode, internalRouter, "ContractPartA", s);
            final DdFalgSetting ddFalgSetting1 = this.queryDdFlagSettingBySettingCodeAndInfo(tenantCode, internalRouter, "ContractPartA", s1);
            ArrayList<DdFalgSetting> listSetting = new ArrayList<DdFalgSetting>(){
                {
                    this.add(ddFalgSetting);
                    this.add(ddFalgSetting1);
                }
            };
            minYongU = true;
            gongChengU = true;
            DdFalgSetting mingYongFlag = listSetting.stream().filter(item -> "\u6c11\u7528".equals(item.getFlagSettingPro())).findFirst().get();
            DdFalgSetting gongChengFlag = listSetting.stream().filter(item -> "\u5de5\u7a0b".equals(item.getFlagSettingInfo())).findFirst().get();
            mingYongApplyU = this.buildMinYongApply(customer, tenantCode, umUser.getUserPcode(), mingYongFlag.getFlagSettingInfo(), mingYongFlag.getFlagSettingPro1());
            gongChengApplyU = this.buildGongchengApply(customer, tenantCode, umUser.getUserPcode(), gongChengFlag.getFlagSettingInfo(), gongChengFlag.getFlagSettingPro1());
        }
        if (Boolean.compare(minYong, minYongU) == 0 && Boolean.compare(gongCheng, gongChengU) == 0) {
            if (null != umUserinfoapplyMinYong) {
                this.compareAndUpdateUserinfoApply(umUserinfoapplyMinYong, mingYongApplyU, internalRouter, tenantCode);
            }
            if (null != umUserinfoapplGongCheng) {
                this.compareAndUpdateUserinfoApply(umUserinfoapplGongCheng, gongChengApplyU, internalRouter, tenantCode);
            }
            return;
        }
        if (minYong != minYongU || gongCheng != gongChengU) {
            if (!minYong && minYongU) {
                this.saveUserinfoApply(mingYongApplyU, internalRouter);
            }
            if (!gongCheng && gongChengU) {
                this.saveUserinfoApply(gongChengApplyU, internalRouter);
            }
        }
    }

    private void compareAndUpdateUserinfoApply(UmUserinfoapply umUserinfoapply, UmUserinfoapplyDomain mingYongApplyU, InternalRouter internalRouter, String tenantCode) throws Exception {
        if (umUserinfoapply.getUserinfoSort().equals(mingYongApplyU.getUserinfoSort())) {
            return;
        }
        final UmUserinfoapplyDomain umUserinfoapplyDomain = new UmUserinfoapplyDomain();
        umUserinfoapplyDomain.setTenantCode(tenantCode);
        umUserinfoapplyDomain.setUserinfoapplyId(umUserinfoapply.getUserinfoapplyId());
        umUserinfoapplyDomain.setUserinfoChannelname(mingYongApplyU.getUserinfoChannelname());
        umUserinfoapplyDomain.setUserinfoChannelcode(mingYongApplyU.getUserinfoChannelcode());
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("umUserinfoapplyDomain", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoapplyDomain));
            }
        };
        internalRouter.inInvoke("um.umUserinfoapply.updateUserinfoapply", (Map)map);
    }

    public void saveUserinfoApply(final UmUserinfoapplyDomain umUserinfoapplyDomain, InternalRouter internalRouter) throws Exception {
        HashMap<String, Object> apSaveUpMap = new HashMap<String, Object>(){
            {
                this.put("umUserinfoapplyDomain", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoapplyDomain));
            }
        };
        try {
            internalRouter.inInvoke("um.umUserinfoapply.saveUserinfoapply", (Map)apSaveUpMap);
            logger.error(this.SYS_CODE + ".sendUpdateCustomer.saveUserinfoAndUser.saveUserinfoApply", (Object)(JsonUtil.buildNormalBinder().toJson((Object)umUserinfoapplyDomain) + ": \u63d2\u5165\u5931\u8d25"));
        }
        catch (Exception e) {
            throw new RuntimeException("\u4fdd\u5b58\u7528\u6237\u8d44\u8d28\u4fe1\u606f\u5ba1\u6838\u5931\u8d25");
        }
    }

    private void compareUserAndUserinfo(InternalRouter internalRouter, String tenantCode, Customer customer, UmUser umUser) {
        final UmUserinfoDomainBeanA umUserDomainBean = this.buildUpdateDomainBean(internalRouter, umUser, customer, tenantCode);
        HashMap<String, Object> updateUserinfoParamMap = new HashMap<String, Object>(){
            {
                this.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
            }
        };
        logger.error(this.SYS_CODE + ".compareUserAndUserinfo.updateUserinfo", (Object)"\u66f4\u6539\u7528\u6237\u4fe1\u606f\u5f00\u59cb");
        internalRouter.inInvoke("um.userbase.updateUserinfo", (Map)updateUserinfoParamMap);
        logger.error(this.SYS_CODE + ".compareUserAndUserinfo.updateUserinfoParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)updateUserinfoParamMap));
        logger.error(this.SYS_CODE + ".compareUserAndUserinfo.updateUserinfo", (Object)"\u66f4\u6539\u7528\u6237\u4fe1\u606f\u7ed3\u675f");
    }

    private UmUserinfoDomainBeanA buildUpdateDomainBean(InternalRouter internalRouter, UmUser umUser, Customer customer, final String tenantCode) {
        final String userinfoCode = umUser.getUserPcode();
        HashMap<String, Object> userParamMap = new HashMap<String, Object>(){
            {
                this.put("userinfoCode", userinfoCode);
                this.put("tenantCode", tenantCode);
            }
        };
        String userinfoStr = (String)internalRouter.inInvoke("um.user.getUserinfoByUserCode", (Map)userParamMap);
        UmUserinfo umuserInfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(userinfoStr, UmUserinfo.class);
        if (null == umuserInfo) {
            logger.error(this.SYS_CODE + ".compareUserAndUserinfo.buildUpdateDomainBean.e", (Object)("\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f:" + userinfoCode));
            return null;
        }
        UmUserinfoDomainBeanA UmUserinfoDomainBean2 = new UmUserinfoDomainBeanA();
        try {
            BeanUtils.copyAllPropertys((Object)UmUserinfoDomainBean2, (Object)umuserInfo);
            BeanUtils.copyAllPropertys((Object)UmUserinfoDomainBean2, (Object)umUser);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Integer userinfoFeestatus = umuserInfo.getUserinfoFeestatus();
        if (userinfoFeestatus == 1) {
            UmUserinfoDomainBean2.setUserinfoFeestatus(1);
        }
        if (customer.isEffective_IsEffective()) {
            UmUserinfoDomainBean2.setDataState(0);
        } else {
            UmUserinfoDomainBean2.setDataState(-1);
        }
        return UmUserinfoDomainBean2;
    }

    private List<UmUserinfoapply> queryUserinfoApply(InternalRouter internalRouter, final String tenantCode, final Customer customer) throws Exception {
        final HashMap<String, Object> applyMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", tenantCode);
                this.put("userinfoInvite", customer.getCustCode());
            }
        };
        HashMap<String, Object> applyParmMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)applyMap));
            }
        };
        String applyStr = (String)internalRouter.inInvoke("um.umUserinfoapply.queryUserinfoapplyPage", (Map)applyParmMap);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(applyStr, SupQueryResult.class);
        List applyList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), UmUserinfoapply.class);
        return applyList;
    }

    private DdFalgSetting queryDdFlagSettingBySettingCodeAndInfo(final String tenantCode, InternalRouter internalRouter, final String flagSettingCode, final String flagSettingInfo) {
        final HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("flagSettingCode", flagSettingCode);
                this.put("flagSettingInfo", flagSettingInfo);
                this.put("tenantCode", tenantCode);
            }
        };
        HashMap<String, Object> ddflagParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)ddflagMap));
            }
        };
        logger.error(this.SYS_CODE + ".queryDdFlagSettingBySettingCodeAndInfo.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".queryDdFlagSettingBySettingCodeAndInfo.ddflagParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)ddflagParamMap));
        String flagSettingListStr = (String)internalRouter.inInvoke("dd.falgSetting.queryFalgSettingPage", (Map)ddflagParamMap);
        logger.error(this.SYS_CODE + ".queryDdFlagSettingBySettingCodeAndInfo.querDdFlag", (Object)"\u67e5\u8be2ddFla\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(flagSettingListStr, SupQueryResult.class);
        List flagSettingList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DdFalgSetting.class);
        logger.error(this.SYS_CODE + ".queryDdFlagSettingBySettingCodeAndInfo.flagSettingList", (Object)JsonUtil.buildNormalBinder().toJson((Object)flagSettingList));
        logger.error(this.SYS_CODE + ".queryDdFlagSettingBySettingCodeAndInfo.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u7ed3\u675f");
        return (DdFalgSetting)flagSettingList.get(0);
    }

    private DdFalgSetting queryDdFlagSetting(final String tenantCode, InternalRouter internalRouter, final String flagSettingCode) {
        final HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("flagSettingCode", flagSettingCode);
                this.put("tenantCode", tenantCode);
            }
        };
        HashMap<String, Object> ddflagParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)ddflagMap));
            }
        };
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.ddflagParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)ddflagParamMap));
        String flagSettingListStr = (String)internalRouter.inInvoke("dd.falgSetting.queryFalgSettingPage", (Map)ddflagParamMap);
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFla\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(flagSettingListStr, SupQueryResult.class);
        List flagSettingList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DdFalgSetting.class);
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.flagSettingList", (Object)JsonUtil.buildNormalBinder().toJson((Object)flagSettingList));
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u7ed3\u675f");
        return (DdFalgSetting)flagSettingList.get(0);
    }

    private String querDdFlagSettingInfo(final String tenantCode, InternalRouter internalRouter, final String flagSettingCode) {
        final HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("flagSettingCode", flagSettingCode);
                this.put("tenantCode", tenantCode);
            }
        };
        HashMap<String, Object> ddflagParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)ddflagMap));
            }
        };
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.ddflagParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)ddflagParamMap));
        String initialFlag = (String)internalRouter.inInvoke("dd.falgSetting.getFalgSettingByCode", (Map)ddflagParamMap);
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u7ed3\u675f");
        Map initialFlagMap = JsonUtil.buildNormalBinder().getJsonToMap(initialFlag, String.class, Object.class);
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.initialFlagMap", (Object)initialFlagMap);
        String flagSettingInfo = (String)initialFlagMap.get("FLAG_SETTING_INFO");
        logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.flagSettingInfo", (Object)flagSettingInfo);
        if (MapUtil.isNotEmpty((Map)initialFlagMap) && StringUtils.isNotBlank((String)flagSettingInfo)) {
            return flagSettingInfo;
        }
        return "error get flagSettingInfo";
    }

    private void updateLogState(InternalRouter internalRouter, final LogErrorLog logErrorLog, final Integer oldDataState, final Integer dataState) {
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("logErrorId", logErrorLog.getLogErrorId());
                this.put("dataState", dataState);
                this.put("oldDataState", oldDataState);
            }
        };
        internalRouter.inInvoke("log.log.updateErrorLogState", (Map)map);
    }

    private UmUser getUmUser(Customer customer, final String tenantCode, InternalRouter internalRouter) {
        final String userOcode = customer.getCustCode();
        final HashMap<String, Object> userMap = new HashMap<String, Object>(){
            {
                this.put("userOcode", userOcode);
                this.put("tenantCode", tenantCode);
            }
        };
        HashMap<String, Object> userParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)userMap));
            }
        };
        String userStr = (String)internalRouter.inInvoke("um.user.getUserByUserOcode", (Map)userParamMap);
        UmUser umUser = (UmUser)JsonUtil.buildNormalBinder().getJsonToObject(userStr, UmUser.class);
        return umUser;
    }

    private void saveUserinfo(String tenantCode, InternalRouter internalRouter, Customer customer) {
        UmUser umUser = this.getUmUser(customer, tenantCode, internalRouter);
        if (null == umUser) {
            this.saveUserinfoAndUserApply(internalRouter, customer, tenantCode);
        } else {
            this.saveUserinfoApplyList(internalRouter, customer, umUser.getUserPcode(), tenantCode);
        }
    }

    private void updateFalgSettingInFoByKey(InternalRouter internalRouter, String flagSettingCode, String tenantCode, String modifiedon, Integer flagSettingId) {
        final DdFalgSettingDomain ddFalgSettingDomain = new DdFalgSettingDomain();
        ddFalgSettingDomain.setFlagSettingId(flagSettingId);
        ddFalgSettingDomain.setFlagSettingCode(flagSettingCode);
        ddFalgSettingDomain.setTenantCode(tenantCode);
        ddFalgSettingDomain.setFlagSettingInfo(modifiedon);
        HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("falgSettingDomain", JsonUtil.buildNormalBinder().toJson((Object)ddFalgSettingDomain));
            }
        };
        internalRouter.inInvoke("dd.falgSetting.updateFalgSetting", (Map)ddflagMap);
    }

    private void updateFalgSetting(InternalRouter internalRouter, Map<String, Object> initialFlagMap, String tenantCode, String localDateTime) {
        final DdFalgSettingDomain ddFalgSettingDomain = new DdFalgSettingDomain();
        ddFalgSettingDomain.setFlagSettingCode((String)initialFlagMap.get("FLAG_SETTING_CODE"));
        ddFalgSettingDomain.setTenantCode(tenantCode);
        ddFalgSettingDomain.setFlagSettingInfo(localDateTime);
        HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("falgSettingDomain", JsonUtil.buildNormalBinder().toJson((Object)ddFalgSettingDomain));
            }
        };
        internalRouter.inInvoke("dd.falgSetting.updateFalgSetting", (Map)ddflagMap);
    }

    private void saveUserinfoAndUserApply(InternalRouter internalRouter, Customer customer, String tenantCode) {
        final UmUserDomainBean umUserDomainBean = this.buildUmUserDomainBean(customer, tenantCode);
        HashMap<String, Object> userMap = new HashMap<String, Object>(){
            {
                this.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
            }
        };
        String userinfoCode = null;
        try {
            userinfoCode = (String)internalRouter.inInvoke("um.userbase.saveOpenUserinfo", (Map)userMap);
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.saveUserinfoAndUser.userinfoCode", (Object)userinfoCode);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.saveUserinfoAndUser.customer", (Object)(JsonUtil.buildNormalBinder().toJson((Object)customer) + ": \u63d2\u5165\u5931\u8d25"));
            this.saveLogError(internalRouter, customer, "customerInitialUserinfo", tenantCode, "busdata.exUser.sendInitailCustomerCompensate", e.getMessage());
            return;
        }
        this.saveUserinfoApplyList(internalRouter, customer, userinfoCode, tenantCode);
    }

    private UmUserDomainBean buildUmUserDomainBean(Customer customer, String tenantCode) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setTenantCode(tenantCode);
        umUserDomainBean.setUserAdd(true);
        if (!customer.isEffective_IsEffective()) {
            umUserDomainBean.setDataState(-1);
        }
        String prv9Name = customer.getPrv9Name();
        umUserDomainBean.setUserinfoQuality("dealer");
        umUserDomainBean.setUserOcode(customer.getCustCode());
        umUserDomainBean.setUserinfoOcode(customer.getCustCode());
        umUserDomainBean.setUserinfoCompname(customer.getCustName());
        umUserDomainBean.setCompanyShortname(customer.getCustShortName());
        umUserDomainBean.setUserPhone(customer.getPrv5Name());
        umUserDomainBean.setUserName(customer.getCustCode());
        umUserDomainBean.setUserinfoCertNo(customer.getStateTaxNo());
        umUserDomainBean.setUserinfoCon(customer.getPrv5Name());
        umUserDomainBean.setUserinfoConPhone(customer.getPrv5Name());
        umUserDomainBean.setUserPwsswd("123456");
        return umUserDomainBean;
    }

    private void saveLogErrorExt(InternalRouter internalRouter, Customer customer, String errorType, String tenantCode, String clientExecuteMethod, String memo, String orgNameSpilt, String orgCodeSpilt) {
        final LogErrorLogDomain logErrorLogDomain = new LogErrorLogDomain();
        logErrorLogDomain.setTenantCode(tenantCode);
        logErrorLogDomain.setUserCode(customer.getCustCode());
        logErrorLogDomain.setErrorType(errorType);
        logErrorLogDomain.setClientExecuteMethod("clientExecuteMethod: " + clientExecuteMethod + "errorMsg: " + memo.substring(0, 150));
        if (StringUtils.isNotBlank((String)orgNameSpilt) && StringUtils.isNotBlank((String)orgCodeSpilt)) {
            logErrorLogDomain.setErrorLogMessage(JsonUtil.buildNonDefaultBinder().toJson((Object)customer) + "|" + orgNameSpilt + "|" + orgCodeSpilt);
        } else {
            logErrorLogDomain.setErrorLogMessage(JsonUtil.buildNonDefaultBinder().toJson((Object)customer));
        }
        HashMap<String, Object> logMap = new HashMap<String, Object>(){
            {
                this.put("logErrorLogDomain", logErrorLogDomain);
            }
        };
        internalRouter.inInvoke("log.log.saveErrorLog", (Map)logMap);
    }

    private void saveLogError(InternalRouter internalRouter, Customer customer, String errorType, String tenantCode, String clientExecuteMethod, String memo) {
        final LogErrorLogDomain logErrorLogDomain = new LogErrorLogDomain();
        logErrorLogDomain.setTenantCode(tenantCode);
        logErrorLogDomain.setUserCode(customer.getCustCode());
        logErrorLogDomain.setErrorType(errorType);
        logErrorLogDomain.setClientExecuteMethod("clientExecuteMethod: " + clientExecuteMethod + "errorMsg: " + memo.substring(0, 50));
        logErrorLogDomain.setErrorLogMessage(JsonUtil.buildNonDefaultBinder().toJson((Object)customer));
        HashMap<String, Object> logMap = new HashMap<String, Object>(){
            {
                this.put("logErrorLogDomain", JsonUtil.buildNormalBinder().toJson((Object)logErrorLogDomain));
            }
        };
        internalRouter.inInvoke("log.log.saveErrorLog", (Map)logMap);
    }

    private List<UmUserinfoapplyDomain> saveUserinfoApplyList(InternalRouter internalRouter, Customer customer, String userinfoCode, String tenantCode) {
        ArrayList<UmUserinfoapplyDomain> batchSaveUpList = new ArrayList<UmUserinfoapplyDomain>();
        String prv10Name = customer.getPrv10Name();
        if (StringUtils.isBlank((String)prv10Name)) {
            return null;
        }
        String[] split = prv10Name.split(",");
        UmUserinfoapplyDomain mingYongApply = null;
        UmUserinfoapplyDomain gongChengApply = null;
        if (split.length == 1) {
            String contractPartA = split[0];
            DdFalgSetting ddFalgSetting = this.queryDdFlagSettingBySettingCodeAndInfo(tenantCode, internalRouter, "ContractPartA", contractPartA);
            if ("\u6c11\u7528".equals(ddFalgSetting.getFlagSettingPro())) {
                mingYongApply = this.buildMinYongApply(customer, tenantCode, userinfoCode, prv10Name, ddFalgSetting.getFlagSettingPro1());
            } else if ("\u5de5\u7a0b".equals(ddFalgSetting.getFlagSettingPro())) {
                gongChengApply = this.buildGongchengApply(customer, tenantCode, userinfoCode, prv10Name, ddFalgSetting.getFlagSettingPro1());
            }
        } else {
            String s = split[0];
            String s1 = split[1];
            final DdFalgSetting ddFalgSetting = this.queryDdFlagSettingBySettingCodeAndInfo(tenantCode, internalRouter, "ContractPartA", s);
            final DdFalgSetting ddFalgSetting1 = this.queryDdFlagSettingBySettingCodeAndInfo(tenantCode, internalRouter, "ContractPartA", s1);
            ArrayList<DdFalgSetting> listSetting = new ArrayList<DdFalgSetting>(){
                {
                    this.add(ddFalgSetting);
                    this.add(ddFalgSetting1);
                }
            };
            DdFalgSetting mingYongDdFlag = listSetting.stream().filter(item -> "\u6c11\u7528".equals(item.getFlagSettingPro())).findFirst().get();
            DdFalgSetting gongChengDdFlag = listSetting.stream().filter(item -> "\u5de5\u7a0b".equals(item.getFlagSettingPro())).findFirst().get();
            mingYongApply = this.buildMinYongApply(customer, tenantCode, userinfoCode, mingYongDdFlag.getFlagSettingInfo(), mingYongDdFlag.getFlagSettingPro1());
            gongChengApply = this.buildGongchengApply(customer, tenantCode, userinfoCode, gongChengDdFlag.getFlagSettingInfo(), gongChengDdFlag.getFlagSettingPro1());
        }
        if (null != mingYongApply) {
            batchSaveUpList.add(mingYongApply);
        }
        if (null != gongChengApply) {
            batchSaveUpList.add(gongChengApply);
        }
        final ArrayList<UmUserinfoapplyDomain> finalBatchSaveUpList = batchSaveUpList;
        HashMap<String, Object> batchSaveUpMap = new HashMap<String, Object>(){
            {
                this.put("umUserinfoapplyDomainList", JsonUtil.buildNormalBinder().toJson((Object)finalBatchSaveUpList));
            }
        };
        try {
            internalRouter.inInvoke("um.umUserinfoapply.saveUserinfoapplyBatch", (Map)batchSaveUpMap);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.saveUserinfoAndUser.finalBatchSaveUpList", (Object)(JsonUtil.buildNormalBinder().toJson(finalBatchSaveUpList) + ": \u63d2\u5165\u5931\u8d25"));
            this.saveLogError(internalRouter, customer, tenantCode, "customerInitialUserinfoApply", "busdata.exUser.sendInitailCustomerCompensate", e.getMessage());
        }
        return batchSaveUpList;
    }

    private UmUserinfoapplyDomain buildGongchengApply(Customer customer, String tenantCode, String userinfoCode, String orgCode, String orgName) {
        UmUserinfoapplyDomain umUserinfoapplyDomain = new UmUserinfoapplyDomain();
        umUserinfoapplyDomain.setTenantCode(tenantCode);
        umUserinfoapplyDomain.setUserinfoCompname(customer.getCustName());
        umUserinfoapplyDomain.setUserinfoInvite(customer.getCustCode());
        umUserinfoapplyDomain.setUserinfoCode(userinfoCode);
        umUserinfoapplyDomain.setQualityCode("dealer");
        umUserinfoapplyDomain.setQualityCode("\u7ecf\u9500\u5546");
        umUserinfoapplyDomain.setUserNickname(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserPhone(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserinfoDischannelname("\u6c11\u7528");
        umUserinfoapplyDomain.setUserinfoChannelname(orgName);
        umUserinfoapplyDomain.setUserinfoChannelcode(orgCode);
        umUserinfoapplyDomain.setDepartCode(customer.getPrv15Code());
        umUserinfoapplyDomain.setDepartName(customer.getPrv15Name());
        umUserinfoapplyDomain.setUserinfoDischannelcode(customer.getPrv1Name());
        umUserinfoapplyDomain.setUserinfoSort(orgCode);
        return umUserinfoapplyDomain;
    }

    private UmUserinfoapplyDomain buildMinYongApply(Customer customer, String tenantCode, String userinfoCode, String orgCode, String orgName) {
        UmUserinfoapplyDomain umUserinfoapplyDomain = new UmUserinfoapplyDomain();
        umUserinfoapplyDomain.setTenantCode(tenantCode);
        umUserinfoapplyDomain.setUserinfoCompname(customer.getCustName());
        umUserinfoapplyDomain.setUserinfoInvite(customer.getCustCode());
        umUserinfoapplyDomain.setUserinfoCode(userinfoCode);
        umUserinfoapplyDomain.setQualityCode("dealer");
        umUserinfoapplyDomain.setQualityCode("\u7ecf\u9500\u5546");
        umUserinfoapplyDomain.setUserNickname(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserPhone(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserinfoDischannelname("\u6c11\u7528");
        umUserinfoapplyDomain.setUserinfoChannelname(orgName);
        umUserinfoapplyDomain.setUserinfoChannelcode(orgCode);
        umUserinfoapplyDomain.setDepartCode(customer.getPrv11Code());
        umUserinfoapplyDomain.setDepartName(customer.getPrv11Name());
        umUserinfoapplyDomain.setUserinfoDischannelcode(customer.getPrv1Name());
        umUserinfoapplyDomain.setUserinfoSort(orgCode);
        return umUserinfoapplyDomain;
    }

    private List<UmUserinfoapplyDomain> buildUserinfoApplySignal(Customer customer, String userinfoCode, String tenantCode) {
        ArrayList<UmUserinfoapplyDomain> upList = new ArrayList<UmUserinfoapplyDomain>();
        UmUserinfoapplyDomain umUserinfoapplyDomain = new UmUserinfoapplyDomain();
        upList.add(umUserinfoapplyDomain);
        umUserinfoapplyDomain.setTenantCode(tenantCode);
        umUserinfoapplyDomain.setUserinfoCompname(customer.getCustName());
        umUserinfoapplyDomain.setUserinfoInvite(customer.getCustCode());
        umUserinfoapplyDomain.setUserinfoCode(userinfoCode);
        umUserinfoapplyDomain.setQualityCode("dealer");
        umUserinfoapplyDomain.setQualityCode("\u7ecf\u9500\u5546");
        umUserinfoapplyDomain.setUserNickname(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserPhone(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserinfoChannelname(customer.getOrgName());
        umUserinfoapplyDomain.setUserinfoChannelcode(customer.getOrgCode());
        umUserinfoapplyDomain.setDepartCode(customer.getPrv11Code());
        umUserinfoapplyDomain.setDepartName(customer.getPrv11Name());
        if (StringUtils.isNotBlank((String)customer.getPrv1Code())) {
            umUserinfoapplyDomain.setUserinfoDischannelcode(customer.getPrv1Name());
            umUserinfoapplyDomain.setUserinfoParentCode(customer.getPrv9Code());
            umUserinfoapplyDomain.setUserinfoParentName(customer.getPrv9Name());
        } else {
            umUserinfoapplyDomain.setUserinfoDischannelcode(customer.getPrv13Name());
        }
        return upList;
    }

    private List<UmUserinfoapplyDomain> buildUserinfoApplyTwo(Customer customer, String userinfoCode, String tenantCode) {
        ArrayList<UmUserinfoapplyDomain> upList = new ArrayList<UmUserinfoapplyDomain>();
        UmUserinfoapplyDomain umUserinfoapplyDomain = new UmUserinfoapplyDomain();
        upList.add(umUserinfoapplyDomain);
        umUserinfoapplyDomain.setTenantCode(tenantCode);
        umUserinfoapplyDomain.setUserinfoCompname(customer.getCustName());
        umUserinfoapplyDomain.setUserinfoInvite(customer.getCustCode());
        umUserinfoapplyDomain.setUserinfoCode(userinfoCode);
        umUserinfoapplyDomain.setQualityCode("dealer");
        umUserinfoapplyDomain.setQualityCode("\u7ecf\u9500\u5546");
        umUserinfoapplyDomain.setUserNickname(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserPhone(customer.getPrv5Name());
        umUserinfoapplyDomain.setUserinfoParentCode(customer.getPrv9Code());
        umUserinfoapplyDomain.setUserinfoParentName(customer.getPrv9Name());
        UmUserinfoapplyDomain umUserinfoapplyDomain1 = new UmUserinfoapplyDomain();
        upList.add(umUserinfoapplyDomain1);
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoapplyDomain1, (Object)umUserinfoapplyDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] orgNameSplit = customer.getOrgName().split(",");
        String[] orgCodeSplit = customer.getOrgCode().split(",");
        String[] prv11CodeSplit = customer.getPrv11Code().split(",");
        String[] prv11NameSplit = customer.getPrv11Name().split(",");
        umUserinfoapplyDomain.setUserinfoDischannelcode(customer.getPrv1Name());
        umUserinfoapplyDomain.setUserinfoChannelname(orgNameSplit[0]);
        umUserinfoapplyDomain.setUserinfoChannelcode(orgCodeSplit[0]);
        umUserinfoapplyDomain.setDepartCode(prv11CodeSplit[0]);
        umUserinfoapplyDomain.setDepartName(prv11NameSplit[0]);
        umUserinfoapplyDomain1.setUserinfoDischannelcode(customer.getPrv13Name());
        umUserinfoapplyDomain1.setUserinfoChannelname(orgNameSplit[1]);
        umUserinfoapplyDomain1.setUserinfoChannelcode(orgCodeSplit[1]);
        umUserinfoapplyDomain1.setDepartCode(prv11CodeSplit[1]);
        umUserinfoapplyDomain1.setDepartName(prv11NameSplit[1]);
        return upList;
    }

    private String getStringlocalDateTimeBy(LocalDateTime time) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(time);
    }

    private String getStringlocalDateTime() {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime time = LocalDateTime.now();
        return df.format(time);
    }

    private LocalDateTime getLocalDateTime(String datetimeStr) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return LocalDateTime.parse(datetimeStr, df);
    }

    @Override
    public String sendSaveBusUserinfoBuyPreviewSeal(String tenantCode, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal", (Object)tenantCode);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.ex");
        }
        String url = this.getDdFlag(tenantCode, "PreviewSeal", "PreviewSeal");
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (StringUtils.isBlank((String)url)) {
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.ex");
        }
        Map<String, String> header = BusUserServiceImpl.getStringStringMap(tenantCode);
        Long startTime = System.currentTimeMillis();
        String data = "{\"msg\":\"\u64cd\u4f5c\u6210\u529f\",\"code\":200,\"data\":{\"sealImageContent\":\"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\",\"imageExtension\":\"png\"}}\n";
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.ex2");
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            Integer code1 = (Integer)code;
            if (code1 == 200) {
                return returnResultsMap.get("data").toString();
            }
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
            throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.ex3");
        }
        logger.error(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.code.1" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        throw new ApiException(this.SYS_CODE + ".sendSaveBusUserinfoBuyPreviewSeal.ex4");
    }

    private static Date getDate() {
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(1, 10);
        Date dateAfterTenYears = calendar.getTime();
        return dateAfterTenYears;
    }

    public static String getMessage(String code) {
        switch (code) {
            case "qyht": {
                return "circle";
            }
            case "qygz": {
                return "circle";
            }
            case "qyfr": {
                return "square";
            }
        }
        return code;
    }

    public static void main222(String[] args) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("haccid", "256");
        header.put("hacckey", "97269a9502214c11bcf91b33a15c71c6");
        Long startTime = System.currentTimeMillis();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", "1");
        String data = null;
        String url = "https://testinterfacem.hbisscm.com/inf/internal/v1/user/queryUserInfo  ";
        url = url + "?" + JsonUtil.buildNormalBinder().toJson(map);
        System.out.println(url);
        data = OkhttpsUtils.doGet(url, JsonUtil.buildNormalBinder().toJson(map), header);
    }

    public static void main(String[] args) {
    }
}

