/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.util;

import com.yqbsoft.laser.service.ext.bus.data.util.OKHttpClientBuilder;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkhttpsUtils {
    private static OkHttpClient getClient() {
        OkHttpClient okHttpClient = OKHttpClientBuilder.buildOKHttpClient().connectTimeout(60000L, TimeUnit.SECONDS).readTimeout(60000L, TimeUnit.SECONDS).writeTimeout(60000L, TimeUnit.SECONDS).build();
        return okHttpClient;
    }

    private static Request getRequest(String url, Map<String, String> header) throws MalformedURLException {
        Request.Builder builder = OkhttpsUtils.getBuilder(header);
        return builder.url(url).build();
    }

    private static Request.Builder getBuilder(Map<String, String> header) {
        Request.Builder builder = new Request.Builder();
        builder.addHeader("accept", "application/json").addHeader("connection", "Keep-Alive").addHeader("Content-Type", "application/json;charset=UTF-8");
        if (header != null && header.entrySet().size() > 0) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return builder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String doGet(String url, String param, Map<String, String> header) {
        if (param != null) {
            url = url + "?" + param;
        }
        String result = null;
        try {
            OkHttpClient okHttpClient = OkhttpsUtils.getClient();
            Request request = OkhttpsUtils.getRequest(url, header);
            Response response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                ResponseBody body = response.body();
                if (body == null) throw new IOException("response body is null");
                return body.string();
            }
            response.close();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("GET\u8bf7\u6c42\u5f02\u5e38,url = " + url + ";" + e.getMessage());
        }
    }

    public static Response doGetResponst(String url, String param, Map<String, String> header) {
        if (param != null) {
            url = url + "?" + param;
        }
        Response result = null;
        try {
            OkHttpClient okHttpClient = OkhttpsUtils.getClient();
            Request request = OkhttpsUtils.getRequest(url, header);
            Response response = okHttpClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new RuntimeException("GET\u8bf7\u6c42\u5f02\u5e38,url = " + url + ";" + e.getMessage());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String doPost(String url, String param, Map<String, String> header) {
        OkHttpClient okHttpClient = OkhttpsUtils.getClient();
        Request.Builder builder = OkhttpsUtils.getBuilder(header);
        String result = null;
        try {
            MediaType mediaType = MediaType.parse((String)"application/json;charset=UTF-8");
            if (header != null && !StringUtils.isEmpty((String)header.get("Content-Type"))) {
                mediaType = MediaType.parse((String)header.get("Content-Type"));
            }
            RequestBody requestBody = RequestBody.create((MediaType)mediaType, (byte[])param.getBytes("UTF-8"));
            builder.post(requestBody);
            Request request = builder.url(url).build();
            Response response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                ResponseBody body = response.body();
                if (body == null) throw new IOException("response body is null");
                return body.string();
            }
            response.close();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("POST\u8bf7\u6c42\u5f02\u5e38,url = " + url + ";" + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String doDelete(String url, String param, Map<String, String> header) {
        OkHttpClient okHttpClient = OkhttpsUtils.getClient();
        Request.Builder builder = OkhttpsUtils.getBuilder(header);
        String result = null;
        try {
            if (param != null) {
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=UTF-8"), (byte[])param.getBytes("UTF-8"));
                builder.delete(requestBody);
            } else {
                builder.delete();
            }
            Request request = builder.url(url).build();
            Response response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                ResponseBody body = response.body();
                if (body == null) throw new IOException("response body is null");
                return body.string();
            }
            response.close();
            return result;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String doPut(String url, String param, Map<String, String> header) {
        OkHttpClient okHttpClient = OkhttpsUtils.getClient();
        Request.Builder builder = OkhttpsUtils.getBuilder(header);
        String result = null;
        try {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=UTF-8"), (byte[])param.getBytes("UTF-8"));
            builder.put(requestBody);
            Request request = builder.url(url).build();
            Response response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                ResponseBody body = response.body();
                if (body == null) throw new IOException("response body is null");
                return body.string();
            }
            response.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("haccid", "256");
        header.put("hacckey", "97269a9502214c11bcf91b33a15c71c6");
        String s = "{\n    \"companyName\": \"test\",\n    \"generateMode\": \"autogeneration\",\n    \"sealAttribute\": {\n        \"centralGraphic\": \"star\",\n        \"mainFont\":\"\u5370\u7ae0\u4e3b\u5b57\",\n        \"sealColor\": \"red\",\n        \"sealSize\": \"200*300\",\n        \"sealTemplate\": \"ELLIPSE\",\n        \"titleFont\": \"\u5370\u7ae0\u6807\u9898\"\n    },\n    \"sealImage\": \"\",\n    \"sealName\": \"\u5370\u7ae0\u540d\u79f0\",\n    \"sealType\": \"qygz\",\n    \"sealId\": 25\n}";
        String data = null;
        String url = "https://testinterfacem.hbisscm.com/inf/internal/v1/seal";
        try {
            data = OkhttpsUtils.doPut(url, s, header);
            System.out.println(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

