/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.domain.dd.DdFalgSetting;
import com.yqbsoft.laser.service.ext.bus.data.domain.dd.DdFalgSettingDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.dis.DisDgoods;
import com.yqbsoft.laser.service.ext.bus.data.domain.dis.DisDgoodsScopelist;
import com.yqbsoft.laser.service.ext.bus.data.domain.dis.DisDgoodsScopelistDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.log.LogErrorLog;
import com.yqbsoft.laser.service.ext.bus.data.domain.log.LogErrorLogDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.EditSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsBrandDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsClasstreeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsFile;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsFileDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsPntreeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecOption;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecOptionDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecValueDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSpecValueReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.GoodsCategory;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.ResourceGoodsU9;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.rs.RsEsbGoodsRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.rs.RsEsbGoodsResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusRsGoodsService;
import com.yqbsoft.laser.service.ext.bus.data.supbase.RsGoodsBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.GoodsParamCheckUtils;
import com.yqbsoft.laser.service.ext.bus.data.util.SqlServerUtils;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class BusRsGoodsServiceImpl
extends RsGoodsBaseService
implements BusRsGoodsService {
    private String SYS_CODE = "busdata.BusRsGoodsServiceImpl";
    private static final String RESOURCEGOODS_ADD_CODE = "rs.resource.sendSavePassResourceGoodsBatch";
    private static final SupperLogUtil logger = new SupperLogUtil(BusRsGoodsServiceImpl.class);
    private static final String MING_YONG_CHANNEL_NAME = "\u7231\u5eb7\u6c11\u7528";
    private static final String GONG_CHENG_CHANNEL_NAME = "\u7231\u5eb7\u5de5\u7a0b";
    private static final String NUAN_TONAG_CHANNEL_NAME = "\u7231\u5eb7\u6696\u901a";
    private static final Map<String, String> channelMap = new HashMap<String, String>(){
        {
            this.put("\u6c11\u7528", BusRsGoodsServiceImpl.MING_YONG_CHANNEL_NAME);
            this.put("\u5de5\u7a0b", BusRsGoodsServiceImpl.GONG_CHENG_CHANNEL_NAME);
            this.put("\u6696\u901a", BusRsGoodsServiceImpl.NUAN_TONAG_CHANNEL_NAME);
        }
    };
    private static ThreadPoolExecutor itemThreadPoolExecutor = new ThreadPoolExecutor(16, 32, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    @Override
    public String sendSaveBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendSaveBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendSaveBusClass(RsClasstreeDomain rsClasstreeDomain) {
        return null;
    }

    @Override
    public String sendSaveBusGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        return null;
    }

    @Override
    public String sendSaveBusBrand(RsBrandDomain rsBrandDomain) {
        return null;
    }

    @Override
    public String checkSkuByESB(String sku, String tenantCode) {
        String esbKey = this.getDdFlag(tenantCode, "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(tenantCode, "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(tenantCode, "EsbGoodsUrl", "EsbGoodsUrl");
        Esbfacade esbfacade = new Esbfacade(url, esbKey, esbSecret, null);
        String[] split = sku.split(",");
        RsEsbGoodsRequest rsEsbGoodsRequest = new RsEsbGoodsRequest();
        rsEsbGoodsRequest.setClientsecret(esbSecret);
        rsEsbGoodsRequest.setClientid(esbKey);
        rsEsbGoodsRequest.setHost(url);
        rsEsbGoodsRequest.setIT_MATNR(split);
        RsEsbGoodsResponse ocContractResponse = esbfacade.execute(rsEsbGoodsRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.ocContractResponse");
            return this.makeErrorReturn("-1", ocContractResponse.getDataObj());
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            return this.makeErrorReturn("-1", ocContractResponse.getDataObj());
        }
        return this.makeSuccessReturn(ocContractResponse.getDataObj());
    }

    public static void main1(String[] args) {
        String esbKey = "WYDS-TRMF98BC";
        String esbSecret = "WYDS#@YFD";
        String url = "https://ipaasqas.rifeng.com.cn:31443/298153907928989696/SAP/Z_NRS_003/1.0.0";
        String sku = "";
        Esbfacade esbfacade = new Esbfacade(url, esbKey, esbSecret, null);
        String[] split = sku.split(",");
        RsEsbGoodsRequest rsEsbGoodsRequest = new RsEsbGoodsRequest();
        rsEsbGoodsRequest.setClientsecret(esbSecret);
        rsEsbGoodsRequest.setClientid(esbKey);
        rsEsbGoodsRequest.setHost(url);
        rsEsbGoodsRequest.setIT_MATNR(split);
        RsEsbGoodsResponse ocContractResponse = esbfacade.execute(rsEsbGoodsRequest);
        if (null == ocContractResponse) {
            // empty if block
        }
        System.out.println(ocContractResponse.getDataObj());
    }

    @Override
    public String sendUpBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendUpBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendDownBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendDownBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendSaveExcelBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        block25: {
            String msg;
            logger.info(this.SYS_CODE + ".sendSaveExcelBusGoods.map", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain));
            if (rsResourceGoodsDomain == null) {
                logger.error(this.SYS_CODE + ".sendSaveExcelBusGoods.rsResourceGoodsDomain");
                return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)rsResourceGoodsDomain.getPntreeName())) {
                rsResourceGoodsDomain.setPntreeName(rsResourceGoodsDomain.getPntreeCode());
            }
            rsResourceGoodsDomain.setChannelCode("728296217517314110");
            rsResourceGoodsDomain.setMemberCode("20000210463648");
            rsResourceGoodsDomain.setGoodsClass("plat");
            rsResourceGoodsDomain.setGoodsOrigin("0");
            if (StringUtils.isBlank((String)rsResourceGoodsDomain.getGoodsPro())) {
                rsResourceGoodsDomain.setGoodsPro("0");
            }
            rsResourceGoodsDomain.setGoodsType("00");
            if (null == rsResourceGoodsDomain.getDataOpbillstate()) {
                rsResourceGoodsDomain.setDataOpbillstate(0);
            }
            if (StringUtils.isNotBlank((String)(msg = this.checkGoodsParam(rsResourceGoodsDomain)))) {
                logger.error(this.SYS_CODE + ".sendSaveExcelBusGoods.msg" + msg);
                return this.makeErrorReturn(rsResourceGoodsDomain.getSkuNo(), "\u53c2\u6570\u5f02\u5e38" + msg);
            }
            try {
                if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeName())) {
                    msg = this.checkPntree(rsResourceGoodsDomain, rsResourceGoodsDomain.getRsSkuDomainList());
                    if (msg.contains("\u65b0\u589e\u7c7b\u578b\u5931\u8d25")) {
                        logger.error(this.SYS_CODE + ".sendSaveExcelBusGoods.checkPntree.msg" + msg);
                        return this.makeErrorReturn(rsResourceGoodsDomain.getSkuNo(), "\u65b0\u589e\u7c7b\u578b\u5931\u8d25");
                    }
                    try {
                        this.makeSpec(rsResourceGoodsDomain);
                    }
                    catch (Exception e) {
                        logger.error(this.SYS_CODE + ".sendSaveExcelBusGoods.makeSpec.Exception", (Throwable)e);
                        return this.makeErrorReturn(rsResourceGoodsDomain.getSkuNo(), "\u6570\u636e\u9519\u8bef");
                    }
                }
                if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandName())) && (msg = this.checkBrandU9(rsResourceGoodsDomain, rsResourceGoodsDomain.getRsSkuDomainList())).contains("\u54c1\u724c")) {
                    logger.error(this.SYS_CODE + ".sendSaveExcelBusGoods.checkBrandU9.Exception", (Object)msg);
                    return this.makeErrorReturn(rsResourceGoodsDomain.getBrandCode(), "\u54c1\u724c\u65b0\u589e\u5931\u8d25");
                }
                if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeName())) && (msg = this.checkRsClassTree(rsResourceGoodsDomain, rsResourceGoodsDomain.getRsSkuDomainList())).contains("\u5206\u7c7b\u540d\u79f0")) {
                    logger.error(this.SYS_CODE + ".checkRsClassTree.resultClassTree", (Object)("\u65b0\u589e\u540e\u53f0\u5206\u7c7b\u5931\u8d25,rsResourceGoodsDomain\uff1a " + JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain)));
                    return msg;
                }
                for (RsSkuDomain rsSkuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                    if (StringUtils.isBlank((String)rsSkuDomain.getSkuRemark()) || StringUtils.isBlank((String)rsSkuDomain.getGoodsWeightstr()) || !"\u5206\u7c7b".equals(msg = this.checkPriceCategory(rsResourceGoodsDomain, rsSkuDomain))) continue;
                    logger.error(this.SYS_CODE + ".checkGoodsClass.msg", (Object)("\u65b0\u589e\u4ef7\u683c\u5206\u7c7b\u5931\u8d25,rsResourceGoodsDomain\uff1a " + JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain)));
                    return msg;
                }
                List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsDomain.getRsSkuDomainList();
                RsResourceGoodsReDomain goodsDomain = this.checkResourceGoods(rsResourceGoodsDomain);
                if (goodsDomain == null) {
                    if (rsResourceGoodsDomain.getGoodsNum() == null) {
                        rsResourceGoodsDomain.setGoodsNum(new BigDecimal("999"));
                    }
                    if (rsResourceGoodsDomain.getPricesetNprice() == null) {
                        rsResourceGoodsDomain.setPricesetNprice(new BigDecimal("999"));
                    }
                    try {
                        this.saveEsResourceGoodsDomainU9(rsResourceGoodsDomain);
                        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getDisDgoodsScopelistDomains())) {
                            this.saveDgoodsScopelistBatch(rsResourceGoodsDomain.getDisDgoodsScopelistDomains(), this.getInternalRouter());
                        }
                        break block25;
                    }
                    catch (Exception e) {
                        logger.error(this.SYS_CODE + ".sendSaveExGoodsSpu.rsResourceGoodsDomain.Exception1", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain), (Throwable)e);
                        this.saveLogError(this.getInternalRouter(), rsResourceGoodsDomain, "itemInitialA", rsResourceGoodsDomain.getTenantCode(), "busdata.busRsGoods.sendInitialAndAddBusGoods", e.getMessage());
                        return this.makeErrorReturn(rsResourceGoodsDomain.getSkuNo(), "\u6570\u636e" + rsResourceGoodsDomain.getSkuNo() + "\u6dfb\u52a0\u5f02\u5e38");
                    }
                }
                try {
                    for (final RsSkuDomain rsSkuDomain : rsSkuDomainList) {
                        HashMap<String, Object> skuMap = new HashMap<String, Object>(){
                            {
                                this.put("tenantCode", rsSkuDomain.getTenantCode());
                                this.put("skuEocode", rsSkuDomain.getSkuEocode());
                            }
                        };
                        QueryResult<RsSkuDomain> rsSkuDomainQueryResult = this.queryRsSkuPage((Map<String, Object>)skuMap);
                        if (null == rsSkuDomainQueryResult || ListUtil.isEmpty((Collection)rsSkuDomainQueryResult.getList())) {
                            this.saveSpecValueListForSkuAdd(goodsDomain, rsResourceGoodsDomain.getRsSpecValueDomainList());
                            rsSkuDomain.setSpuCode(goodsDomain.getSpuCode());
                            rsSkuDomain.setGoodsCode(goodsDomain.getGoodsCode());
                            rsSkuDomain.setGoodsShowno(goodsDomain.getGoodsShowno());
                            rsSkuDomain.setGoodsClass(goodsDomain.getGoodsClass());
                            rsSkuDomain.setMemberCode(goodsDomain.getMemberCode());
                            rsSkuDomain.setMemberCode(goodsDomain.getMemberCode());
                            rsSkuDomain.setGoodsOneweight(goodsDomain.getGoodsOneweight());
                            rsSkuDomain.setGoodsOneweight(goodsDomain.getGoodsOneweight());
                            rsSkuDomain.setGoodsOrigin(goodsDomain.getGoodsOrigin());
                            rsSkuDomain.setGoodsPro(goodsDomain.getGoodsPro());
                            rsSkuDomain.setChannelCode(goodsDomain.getChannelCode());
                            rsSkuDomain.setGoodsType(goodsDomain.getGoodsType());
                            this.saveRsSkuDomain(rsSkuDomain);
                            this.saveDgoodsScoplist(rsSkuDomain);
                            continue;
                        }
                        this.saveDgoodsScoplist(rsSkuDomain);
                    }
                }
                catch (Exception e) {
                    logger.error(this.SYS_CODE + ".sendSaveExGoodsSpu.rsResourceGoodsDomain.Exception2", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain), (Throwable)e);
                    this.saveLogError(this.getInternalRouter(), rsResourceGoodsDomain, "itemInitialB", rsResourceGoodsDomain.getTenantCode(), "busdata.busRsGoods.sendInitialAndAddBusGoods", e.getMessage());
                    return this.makeErrorReturn(rsResourceGoodsDomain.getSkuNo(), "\u6570\u636e" + rsResourceGoodsDomain.getSkuNo() + "\u6dfb\u52a0\u5f02\u5e38");
                }
            }
            catch (ApiException e) {
                logger.error(this.SYS_CODE + ".sendSaveExGoods.e", (Throwable)e);
                return this.makeErrorReturn(rsResourceGoodsDomain.getSkuNo(), e.getErrMsg());
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".sendSaveExGoods.e1", (Throwable)e);
                return this.makeErrorReturn(rsResourceGoodsDomain.getSkuNo(), e.getMessage());
            }
        }
        return this.makeSuccessReturn(rsResourceGoodsDomain.getSkuNo());
    }

    private void addPriceCategory(RsResourceGoodsReDomain goodsDomain, RsSkuDomain rsSkuDomain) throws Exception {
        if (StringUtils.isBlank((String)rsSkuDomain.getSkuRemark()) || StringUtils.isBlank((String)rsSkuDomain.getGoodsWeightstr())) {
            return;
        }
        String msg = this.checkPriceCategory(goodsDomain, rsSkuDomain);
        if ("\u5206\u7c7b".equals(msg)) {
            logger.error(this.SYS_CODE + ".checkGoodsClass.msg", (Object)("\u65b0\u589e\u4ef7\u683c\u5206\u7c7b\u5931\u8d25,rsResourceGoodsDomain\uff1a " + JsonUtil.buildNormalBinder().toJson((Object)goodsDomain)));
            throw new RuntimeException(msg);
        }
    }

    private String checkPriceCategory(RsResourceGoodsDomain rsResourceGoodsDomain, RsSkuDomain rsSkuDomain) {
        RsClasstreeDomain rsClasstreeDomain = this.buildClassTreeeForPriceCategory(rsResourceGoodsDomain, rsSkuDomain, "-1", "1", "9");
        String msg = GoodsParamCheckUtils.checkClasstreeParam(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExClass.msg");
            return "\u4ef7\u683c\u540e\u53f0\u5206\u7c7b\u6821\u9a8c\u51fa\u9519";
        }
        String code = "";
        String name = rsClasstreeDomain.getClasstreeName();
        RsClasstreeDomain classtreeDomain = this.getRsClasstreeByCode(rsClasstreeDomain.getClasstreeEocode(), rsClasstreeDomain.getTenantCode());
        if (classtreeDomain == null) {
            rsClasstreeDomain.setClasstreeCode(null);
            code = this.saveRsClasstree(rsClasstreeDomain);
        } else {
            code = classtreeDomain.getClasstreeCode();
        }
        rsSkuDomain.setSkuRemark(name);
        rsSkuDomain.setGoodsWeightstr(code);
        return "";
    }

    private void saveDgoodsScoplist(RsSkuDomain rsSkuDomain) throws Exception {
        List<DisDgoodsScopelistDomain> disDgoodsScopelistDomains = rsSkuDomain.getDisDgoodsScopelistDomains();
        if (ListUtil.isNotEmpty(disDgoodsScopelistDomains)) {
            for (final DisDgoodsScopelistDomain disDgoodsScopelistDomain : disDgoodsScopelistDomains) {
                List<DisDgoodsScopelist> disDgoodsScopelists = this.queryDgoodsScopelistPageBySkuEocodeAndChannelName(disDgoodsScopelistDomain.getTenantCode(), this.getInternalRouter(), rsSkuDomain.getSkuEocode(), disDgoodsScopelistDomain.getChannelName());
                if (null != disDgoodsScopelists) continue;
                ArrayList<DisDgoodsScopelistDomain> disDgoodsScopelistDomainsLast = new ArrayList<DisDgoodsScopelistDomain>(){
                    {
                        this.add(disDgoodsScopelistDomain);
                    }
                };
                this.saveDgoodsScopelistBatch((List<DisDgoodsScopelistDomain>)disDgoodsScopelistDomainsLast, this.getInternalRouter());
            }
        }
    }

    private void buildSpecValueListForSkuModify(RsResourceGoodsDomain oldRsResourceGoodsReDomain, RsResourceGoodsDomain newRsResourceGoodsDomain) throws Exception {
        List<RsSpecValueDomain> allRsSpecValueDomainList;
        HashMap<String, Object> specParamsMap = new HashMap<String, Object>();
        specParamsMap.put("specValueBillno", oldRsResourceGoodsReDomain.getGoodsCode());
        specParamsMap.put("tenantCode", oldRsResourceGoodsReDomain.getTenantCode());
        specParamsMap.put("startRow", 0);
        specParamsMap.put("rows", 1);
        QueryResult<RsSpecValueReDomain> rsSpecValueReDomainQueryResultOld = this.querySpecValuePage(specParamsMap);
        if (null != rsSpecValueReDomainQueryResultOld && ListUtil.isNotEmpty((Collection)rsSpecValueReDomainQueryResultOld.getList())) {
            oldRsResourceGoodsReDomain.getRsSpecValueDomainList().addAll(newRsResourceGoodsDomain.getRsSpecValueDomainList());
        }
        if (ListUtil.isNotEmpty(allRsSpecValueDomainList = oldRsResourceGoodsReDomain.getRsSpecValueDomainList())) {
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("specValueBillno", oldRsResourceGoodsReDomain.getGoodsCode());
            paramsMap.put("tenantCode", oldRsResourceGoodsReDomain.getTenantCode());
            ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
            for (RsSpecValueDomain rsSpecValueDomain : allRsSpecValueDomainList) {
                paramsMap.put("specName", rsSpecValueDomain.getSpecName());
                paramsMap.put("specValueValue", rsSpecValueDomain.getSpecValueValue());
                paramsMap.put("startRow", 0);
                paramsMap.put("rows", 1);
                QueryResult<RsSpecValueReDomain> rsSpecValueReDomainQueryResult = this.checkSpecValue(paramsMap);
                if (null != rsSpecValueReDomainQueryResult && ListUtil.isNotEmpty((Collection)rsSpecValueReDomainQueryResult.getList())) continue;
                rsSpecValueDomain.setSpecValueBillno(oldRsResourceGoodsReDomain.getGoodsCode());
                rsSpecValueDomain.setTenantCode(oldRsResourceGoodsReDomain.getTenantCode());
                rsSpecValueDomain.setSpuCode(oldRsResourceGoodsReDomain.getSpuCode());
                rsSpecValueDomainList.add(rsSpecValueDomain);
            }
            oldRsResourceGoodsReDomain.setRsSpecValueDomainList(rsSpecValueDomainList);
        }
    }

    private void saveSpecValueListForSkuAdd(RsResourceGoodsReDomain goodsDomain, List<RsSpecValueDomain> rsSpecValueDomainList) throws Exception {
        if (ListUtil.isNotEmpty(rsSpecValueDomainList)) {
            ArrayList<RsSpecValueDomain> rsSpecValueDomainListForSkuAdd = new ArrayList<RsSpecValueDomain>();
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("specValueBillno", goodsDomain.getGoodsCode());
            paramsMap.put("tenantCode", goodsDomain.getTenantCode());
            for (RsSpecValueDomain rsSpecValueDomain : rsSpecValueDomainList) {
                paramsMap.put("specCode", rsSpecValueDomain.getSpecCode());
                paramsMap.put("specValueValue", rsSpecValueDomain.getSpecValueValue());
                paramsMap.put("startRow", 0);
                paramsMap.put("rows", 1);
                QueryResult<RsSpecValueReDomain> rsSpecValueReDomainQueryResult = this.checkSpecValue(paramsMap);
                if (null != rsSpecValueReDomainQueryResult && ListUtil.isNotEmpty((Collection)rsSpecValueReDomainQueryResult.getList())) continue;
                rsSpecValueDomain.setSpecValueBillno(goodsDomain.getGoodsCode());
                rsSpecValueDomain.setTenantCode(goodsDomain.getTenantCode());
                rsSpecValueDomain.setSpuCode(goodsDomain.getSpuCode());
                rsSpecValueDomainListForSkuAdd.add(rsSpecValueDomain);
            }
            if (ListUtil.isNotEmpty(rsSpecValueDomainListForSkuAdd)) {
                this.saveSpecValueList(rsSpecValueDomainListForSkuAdd);
            }
        }
    }

    private void saveDgoodsScopelistBatch(final List<DisDgoodsScopelistDomain> disDgoodsScopelistDomains, InternalRouter internalRouter) throws Exception {
        if (ListUtil.isEmpty(disDgoodsScopelistDomains)) {
            return;
        }
        HashMap<String, Object> batchSaveUpMap = new HashMap<String, Object>(){
            {
                this.put("disDgoodsScopelistDomainList", JsonUtil.buildNormalBinder().toJson((Object)disDgoodsScopelistDomains));
            }
        };
        internalRouter.inInvoke("dis.dgoods.saveDgoodsScopelistBatch", (Map)batchSaveUpMap);
    }

    private void saveLogError(InternalRouter internalRouter, RsResourceGoodsDomain rsResourceGoodsDomain, String clientType, String tenantCode, String clientExecuteMethod, String memo) {
        final LogErrorLogDomain logErrorLogDomain = new LogErrorLogDomain();
        logErrorLogDomain.setTenantCode(tenantCode);
        logErrorLogDomain.setUserCode(rsResourceGoodsDomain.getGoodsEocode());
        logErrorLogDomain.setClientType(clientType);
        logErrorLogDomain.setClientExecuteMethod("clientExecuteMethod: " + clientExecuteMethod + "errorMsg: " + memo);
        logErrorLogDomain.setErrorLogMessage(JsonUtil.buildNonDefaultBinder().toJson((Object)rsResourceGoodsDomain));
        HashMap<String, Object> logMap = new HashMap<String, Object>(){
            {
                this.put("logErrorLogDomain", JsonUtil.buildNormalBinder().toJson((Object)logErrorLogDomain));
            }
        };
        internalRouter.inInvoke("log.log.saveErrorLog", (Map)logMap);
    }

    private String checkGoodsClass(RsResourceGoodsDomain rsResourceGoodsDomain, Map<String, Object> classTreeMap, List<RsSkuDomain> rsSkuDomainList) {
        String oneGoodsClassCode = this.checkAndAddGoodsClass(rsResourceGoodsDomain, "-1", "1", "1", classTreeMap, null);
        if (oneGoodsClassCode.contains("\u5206\u7c7b")) {
            logger.error(this.SYS_CODE + ".checkGoodsClass.oneGoodsClassCode", (Object)("\u65b0\u589e\u4e00\u7ea7\u524d\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getOneClasstreeShopname()));
            return "\u65b0\u589e\u4e00\u7ea7\u524d\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getOneClasstreeShopname();
        }
        String twoGoodsClassCode = this.checkAndAddGoodsClass(rsResourceGoodsDomain, oneGoodsClassCode, "1", "2", classTreeMap, null);
        if (twoGoodsClassCode.contains("\u5206\u7c7b")) {
            logger.error(this.SYS_CODE + ".checkGoodsClass.twoGoodsClassCode", (Object)("\u65b0\u589e\u4e8c\u7ea7\u524d\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getSecondClasstreeShopname()));
            return "\u65b0\u589e\u4e8c\u7ea7\u524d\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getSecondClasstreeShopname();
        }
        String classtreeShopcode = this.checkAndAddGoodsClass(rsResourceGoodsDomain, twoGoodsClassCode, "0", "3", classTreeMap, rsSkuDomainList);
        if (classtreeShopcode.contains("\u5206\u7c7b")) {
            logger.error(this.SYS_CODE + ".checkGoodsClass.classtreeShopcode", (Object)("\u65b0\u589e\u4e09\u7ea7\u524d\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getClasstreeShopcode()));
            return "\u65b0\u589e\u4e09\u7ea7\u524d\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getClasstreeShopcode();
        }
        return "";
    }

    private String checkAndAddGoodsClass(RsResourceGoodsDomain rsResourceGoodsDomain, String goodsClassParentCode, String goodsClassLast, String level, Map<String, Object> classTreeMap, List<RsSkuDomain> rsSkuDomainList) {
        RsGoodsClassDomain rsGoodsClassDomainByCode;
        RsGoodsClassDomain rsGoodsClassDomain = this.buildGoodsClass(rsResourceGoodsDomain, goodsClassParentCode, goodsClassLast, "0", level, classTreeMap);
        if (rsGoodsClassDomain == null) {
            logger.error(this.SYS_CODE + ".checkAndAddGoodsClass.rsGoodsClassDomain");
            return "error";
        }
        String msg = GoodsParamCheckUtils.checkClasstreeShopParam(rsGoodsClassDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExClass.msg");
            return "\u524d\u53f0\u5206\u7c7b\u6821\u9a8c\u51fa\u9519";
        }
        if (!"-1".equals(rsGoodsClassDomain.getGoodsClassParentcode()) && (rsGoodsClassDomainByCode = this.getRsGoodsClassByCode(rsGoodsClassDomain.getGoodsClassParentcode(), rsGoodsClassDomain.getTenantCode())) == null) {
            return "\u524d\u53f0\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\uff01";
        }
        String code = "";
        String name = rsGoodsClassDomain.getGoodsClassName();
        RsGoodsClassDomain rsGoodsClassDomainByCode2 = this.getRsGoodsClassByCode(rsGoodsClassDomain.getGoodsClassEocode(), rsGoodsClassDomain.getTenantCode());
        if (rsGoodsClassDomainByCode2 == null) {
            rsGoodsClassDomain.setGoodsClassCode(null);
            code = this.saveRsGoodsClassU9(rsGoodsClassDomain);
        } else {
            code = rsGoodsClassDomainByCode2.getGoodsClassCode();
        }
        if (null != rsSkuDomainList) {
            rsResourceGoodsDomain.setClasstreeShopcode(code);
            rsResourceGoodsDomain.setClasstreeShopname(name);
            for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
                rsSkuDomain.setClasstreeShopcode(code);
                rsSkuDomain.setClasstreeShopname(name);
            }
        }
        return code;
    }

    private RsGoodsClassDomain buildGoodsClass(RsResourceGoodsDomain rsResourceGoodsDomain, String goodsClassParentCode, String goodsClassLast, String goodsClassType, String level, Map<String, Object> classTreeMap) {
        RsGoodsClassDomain rsGoodsClassDomain = new RsGoodsClassDomain();
        rsGoodsClassDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
        rsGoodsClassDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
        rsGoodsClassDomain.setGoodsClassParentcode(goodsClassParentCode);
        rsGoodsClassDomain.setGoodsClassLast(goodsClassLast);
        rsGoodsClassDomain.setGoodsClassType(goodsClassType);
        if ("1".equals(level)) {
            rsGoodsClassDomain.setGoodsClassName(rsResourceGoodsDomain.getOneClasstreeShopname());
            rsGoodsClassDomain.setGoodsClassEocode(rsResourceGoodsDomain.getOneClasstreeShopcode());
            rsGoodsClassDomain.setClasstreeCode((String)classTreeMap.get("oneClassTreeCode"));
        } else if ("2".equals(level)) {
            rsGoodsClassDomain.setGoodsClassName(rsResourceGoodsDomain.getSecondClasstreeShopname());
            rsGoodsClassDomain.setGoodsClassEocode(rsResourceGoodsDomain.getSecondClasstreeShopcode());
            rsGoodsClassDomain.setClasstreeCode((String)classTreeMap.get("twoClassTreeCode"));
        } else if ("3".equals(level)) {
            rsGoodsClassDomain.setGoodsClassName(rsResourceGoodsDomain.getClasstreeCode());
            rsGoodsClassDomain.setGoodsClassEocode(rsResourceGoodsDomain.getClasstreeShopcode());
            rsGoodsClassDomain.setClasstreeCode((String)classTreeMap.get("classTreeCode"));
        }
        return rsGoodsClassDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendInitialAndBusGoods(String tenantCode) {
        String localDateTime = this.getStringlocalDateTime();
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.tenantCode", (Object)"\u79df\u6237\u4e3a\u7a7a");
            return "\u79df\u6237\u4e3a\u7a7a,\u4e0d\u80fd\u521d\u59cb\u5316";
        }
        logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.localDateTime", (Object)localDateTime);
        InternalRouter internalRouter = this.getInternalRouter();
        if (null == internalRouter) {
            logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.internalRouter", (Object)"internalRouter is null");
            return "internalRouter is null";
        }
        DdFalgSetting ddFalgSetting = this.queryDdFlagSetting(tenantCode, internalRouter, "InitailResourceGoodsAndAdd");
        if (null == ddFalgSetting) {
            logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.ddFalgSetting", (Object)"ddFalgSetting is null");
            return "ddFalgSetting is null";
        }
        Integer flagSettingId = ddFalgSetting.getFlagSettingId();
        String flagSettingInfo = ddFalgSetting.getFlagSettingInfo();
        logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.flagSettingId", (Object)flagSettingId);
        logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.flagSettingInfo", (Object)flagSettingInfo);
        boolean initialCustomer = true;
        LocalDateTime args = null;
        String sql = "SELECT Top 9  i.CreatedOn, /*\u521b\u5efa\u65e5\u671f*/ i.ModifiedOn, /*\u4fee\u6539\u65e5\u671f*/ b.Code OrgCode, /* \u7ec4\u7ec7\u7f16\u7801,*/ bTrl.Name OrgName, \n                /* \u7ec4\u7ec7\u540d\u79f0,*/ CASE WHEN defineValue1. LEVEL = 0 THEN defineValue1.Code ELSE CASE WHEN defineValue2. LEVEL = 0\n                 THEN defineValue2.Code ELSE defineValue3.Code END END FirstCategoryCode, \n                /*\u4e00\u7ea7\u5206\u7c7b\u7f16\u7801*/ CASE WHEN defineValue1. LEVEL = 0 THEN defineValue1Trl.Name ELSE CASE WHEN defineValue2. LEVEL\n                 = 0 THEN defineValue2Trl.Name ELSE defineValue3Trl.Name END END FirstCategoryName, \n                /*\u4e00\u7ea7\u5206\u7c7b\u540d\u79f0*/ CASE WHEN defineValue2. LEVEL = 1 THEN defineValue2.Code ELSE CASE WHEN defineValue3. LEVEL\n                 = 1 THEN defineValue3.Code ELSE '' END END SecondCategoryCode, \n                /*\u4e8c\u7ea7\u5206\u7c7b\u7f16\u7801*/ CASE WHEN defineValue2. LEVEL = 1 THEN defineValue2Trl.Name ELSE CASE WHEN defineValue3. LEVEL\n                 = 1 THEN defineValue3Trl.Name ELSE '' END END SecondCategoryName, \n                /*\u4e8c\u7ea7\u5206\u7c7b\u540d\u79f0*/ CASE WHEN defineValue3. LEVEL = 2 THEN defineValue3.Code ELSE '' END ThreeCategoryCode, \n                /*\u4e09\u7ea7\u5206\u7c7b\u7f16\u7801*/ CASE WHEN defineValue3. LEVEL = 2 THEN defineValue3Trl.Name ELSE '' END ThreeCategoryName, \n                /*\u4e09\u7ea7\u5206\u7c7b\u540d\u79f0*/ category.Code CategoryCode, /* \u5206\u7c7b\u7f16\u7801,*/ categoryTrl.Name CategoryName, \n                /*\u5206\u7c7b\u540d\u79f0,*/ assetCategory.Code AssetCategoryCode, /*\u8d22\u52a1\u5206\u7c7b\u7f16\u7801*/ assetCategoryTrl.Name AssetCategoryName, \n                /*\u8d22\u52a1\u5206\u7c7b\u540d\u79f0*/ costCategory.Code CostCategoryCode, /*\u6210\u672c\u5206\u7c7b\u7f16\u7801*/ costCategoryTrl.Name CostCategoryName, \n                /*\u6210\u672c\u5206\u7c7b\u540d\u79f0*/ creditCategory.Code CreditCategoryCode, \n                /*\u4fe1\u7528\u5206\u7c7b\u7f16\u7801*/ creditCategoryTrl.Name CreditCategoryName, \n                /*\u4fe1\u7528\u5206\u7c7b\u540d\u79f0*/ MRPCategory.Code MRPCategoryCode, /*MRP\u5206\u7c7b\u7f16\u7801*/ MRPCategoryTrl.Name MRPCategoryName, \n                /*MRP\u5206\u7c7b\u540d\u79f0*/ priceCategory.Code PriceCategoryCode, /*\u4ef7\u683c\u5206\u7c7b\u7f16\u7801*/ priceCategoryTrl.Name PriceCategoryName, \n                /*\u4ef7\u683c\u5206\u7c7b\u540d\u79f0*/ productionCategory.Code ProductionCategoryCode, \n                /*\u751f\u4ea7\u5206\u7c7b\u7f16\u7801*/ productionCategoryTrl.Name ProductionCategoryName, \n                /*\u751f\u4ea7\u5206\u7c7b\u540d\u79f0*/ purchaseCategory.Code PurchaseCategoryCode, \n                /*\u91c7\u8d2d\u5206\u7c7b\u7f16\u7801*/ purchaseCategoryTrl.Name PurchaseCategoryName, \n                /*\u91c7\u8d2d\u5206\u7c7b\u540d\u79f0*/ saleCategory.Code SaleCategoryCode, /*\u9500\u552e\u5206\u7c7b\u7f16\u7801*/ saleCategoryTrl.Name SaleCategoryName, \n                /*\u9500\u552e\u5206\u7c7b\u540d\u79f0*/ stockCategory.Code StockCategoryCode, \n                /*\u5e93\u5b58\u5206\u7c7b\u7f16\u7801*/ stockCategoryTrl.Name StockCategoryName, /*\u5e93\u5b58\u5206\u7c7b\u540d\u79f0*/ priceUOM.Code PriceUOMCode, \n                priceUOMTrl.Name PriceUOMName, i.Code ItemCode, /*\u6599\u53f7,*/ i.Name ItemName, /*\u54c1\u540d,*/ SPECS Specs, \n                /*\u89c4\u683c,*/ Code1 ItemCode1, /*\u53c2\u8003\u6599\u53f71,*/ Code2 ItemCode2, /*\u53c2\u8003\u6599\u53f72,*/ iTrl.Description Description, \n                /*\u63cf\u8ff0,*/ ItemFormAttribute AttributeValue, /*\u6599\u54c1\u5f62\u6001\u5c5e\u6027\u503c,*/ enumvalueTrl.Name AttributeName, \n                /*\u6599\u54c1\u5f62\u6001\u5c5e\u6027\u540d\u79f0,*/ IsInventoryEnable, /* \u53ef\u5e93\u5b58\u4ea4\u6613,*/ IsPurchaseEnable, /* \u53ef\u91c7\u8d2d,*/ IsSalesEnable, \n                /* \u53ef\u9500\u552e,*/ IsBuildEnable, /* \u53ef\u751f\u4ea7,*/ IsOutsideOperationEnable, /* \u53ef\u59d4\u5916,*/ IsMRPEnable, /* \u53efMRP,*/ IsBOMEnable, \n                /* \u53efNOM,*/ IsMFGConfigEnable, /* \u53ef\u9009\u914d,*/ IsVMIEnable, /* VMI\u6599\u54c1,*/ IsTrademark, /* \u5382\u724c\u7ba1\u7406,*/ s.Code MfgCode, \n                /*\u5382\u724c\u7f16\u7801,*/ sTrl.Name MfgName, /*\u5382\u724c\u540d\u79f0*/ w.Code WHCode, /*\u5b58\u50a8\u5730\u70b9\u7f16\u7801,*/ wTrl.Name WHName, \n                /*\u5b58\u50a8\u5730\u70b9\u540d\u79f0,*/ c.Code CurrencyCode, /*\u5e01\u79cd\u7f16\u7801,*/ cTrl.Name CurrencyName, /*\u5e01\u79cd\u540d\u79f0,*/ i.RefrenceCost CostPrice, \n                /*\u6210\u672c\u5355\u4ef7*/ i.Effective_EffectiveDate, /*\u751f\u6548\u65e5\u671f*/ i.Effective_DisableDate, /*\u5931\u6548\u65e5\u671f*/ inv.SafetyStockType, \n                /*\u5b89\u5168\u5b58\u91cf\u6cd5*/ inv.SafetyStockPeriod, /*\u5b89\u5168\u5e93\u5b58\u671f*/ inv.SafetyStockQty, /*\u5b89\u5168\u5e93\u5b58\u91cf*/ inv.SafetyStockRate, \n                /*\u5b89\u5168\u5e93\u5b58\u91cf\u767e\u5206\u6bd4*/ i.DescFlexField_PubDescSeg21, /*\u91c7\u8d2d\u6807\u51c6\u4ef7*/ i.DescFlexField_PubDescSeg29, \n                /*\u5317\u65b9\u5355\u91cd*/ i.DescFlexField_PubDescSeg30, '' Prv1Code, i.DescFlexField_PrivateDescSeg1 Prv1Name, '' Prv2Code, \n                i.DescFlexField_PrivateDescSeg2 Prv2Name, '' Prv3Code, i.DescFlexField_PrivateDescSeg3 Prv3Name, '' Prv4Code, \n                i.DescFlexField_PrivateDescSeg4 Prv4Name, '' Prv5Code, i.DescFlexField_PrivateDescSeg5 Prv5Name, '' Prv6Code, \n                i.DescFlexField_PrivateDescSeg6 Prv6Name, '' Prv7Code, i.DescFlexField_PrivateDescSeg7 Prv7Name, \n                /*\u5357\u65b9\u5206\u7c7b3*/ defineValue4.Code Prv8Code, /*\u54c1\u724c\u7f16\u7801*/ defineValue4Trl.Name Prv8Name, '' Prv9Code, \n                i.DescFlexField_PrivateDescSeg9 Prv9Name, /*\u6750\u8d28*/ defineValue5.Code Prv10Code, \n                /*SPU\u5206\u7c7b\u7f16\u7801\uff08\u539f\u4ef7\u683c\u5206\u7c7b\u4e2d\u7c7b\u7f16\u7801\uff09*/ defineValue5Trl.Name Prv10Name, /*SPU\u5206\u7c7b\u540d\u79f0\uff08\u539f\u4ef7\u683c\u5206\u7c7b\u4e2d\u7c7b\u540d\u79f0\uff09*/ defineValue6.Code Prv11Code, \n                /*\u6e20\u9053\u7f16\u7801*/ defineValue6Trl.Name Prv11Name, '' Prv12Code, i.DescFlexField_PrivateDescSeg12 Prv12Name, \n                '' Prv13Code, i.DescFlexField_PrivateDescSeg13 Prv13Name, '' Prv14Code, \n                i.DescFlexField_PrivateDescSeg14 Prv14Name, '' Prv15Code, i.DescFlexField_PrivateDescSeg15 Prv15Name, \n                '' Prv16Code, i.DescFlexField_PrivateDescSeg16 Prv16Name, '' Prv17Code, \n                i.DescFlexField_PrivateDescSeg17 Prv17Name, '' Prv18Code, i.DescFlexField_PrivateDescSeg18 Prv18Name, \n                '' Prv19Code, i.DescFlexField_PrivateDescSeg19 Prv19Name, '' Prv20Code, \n                i.DescFlexField_PrivateDescSeg20 Prv20Name, '' Prv21Code, i.DescFlexField_PrivateDescSeg21 Prv21Name, \n                '' Prv22Code, i.DescFlexField_PrivateDescSeg22 Prv22Name, '' Prv23Code, \n                i.DescFlexField_PrivateDescSeg23 Prv23Name, '' Prv24Code, i.DescFlexField_PrivateDescSeg24 Prv24Name, \n                '' Prv25Code, i.DescFlexField_PrivateDescSeg25 Prv25Name, '' Prv26Code, \n                i.DescFlexField_PrivateDescSeg26 Prv26Name, '' Prv27Code, i.DescFlexField_PrivateDescSeg27 Prv27Name, \n                '' Prv28Code, i.DescFlexField_PrivateDescSeg28 Prv28Name, '' Prv29Code, \n                i.DescFlexField_PrivateDescSeg29 Prv29Name, '' Prv30Code, i.DescFlexField_PrivateDescSeg30 Prv30Name, \n                i.Weight, /*\u91cd\u91cf*/ i.ItemBulk/*\u4f53\u79ef*/,i.Effective_IsEffective,/*\u542f\u7528\u7981\u7528\u72b6\u6001*/\n\t\t\t\ti.ID ItemID,/*\u6599\u54c1ID*/saleCategory.ID SaleCategoryID,/*\u9500\u552e\u5206\u7c7bID*/weightUOM.Code WeightUOMCode,/*\u5e93\u5b58\u5355\u4f4d\u7f16\u7801*/\n\t\t\t\tweightUOMTrl.Name WeightUOMName,/*\u5e93\u5b58\u5355\u4f4d\u540d\u79f0*/bulkUOM.Code BulkUOMCode,/*\u5e93\u5b58\u5355\u4f4d\u7f16\u7801*/\n\t\t\t\tbulkUOMTrl.Name BulkUOMName/*\u5e93\u5b58\u5355\u4f4d\u540d\u79f0*/\n/*\u4f53\u79ef*/ FROM CBO_ItemMaster i LEFT JOIN\n                CBO_ItemMaster_Trl iTrl ON i.ID = iTrl.ID AND iTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_InventoryInfo inv ON i.InventoryInfo = inv.ID LEFT JOIN\n                CBO_Category category ON category.ID = i.MainItemCategory LEFT JOIN\n                CBO_Category_Trl categoryTrl ON categoryTrl.ID = i.MainItemCategory AND category.ID = categoryTrl.ID AND \n                categoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category assetCategory ON assetCategory.ID = i.AssetCategory /*\u8d22\u52a1\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl assetCategoryTrl ON assetCategoryTrl.ID = i.AssetCategory AND \n                assetCategory.ID = assetCategoryTrl.ID AND assetCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category costCategory ON costCategory.ID = i.CostCategory /*\u6210\u672c\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl costCategoryTrl ON costCategoryTrl.ID = i.CostCategory AND \n                costCategory.ID = costCategoryTrl.ID AND costCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category creditCategory ON creditCategory.ID = i.CreditCategory /*\u4fe1\u7528\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl creditCategoryTrl ON creditCategoryTrl.ID = i.CreditCategory AND \n                creditCategory.ID = creditCategoryTrl.ID AND creditCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category MRPCategory ON MRPCategory.ID = i.MRPCategory /*MRP\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl MRPCategoryTrl ON MRPCategoryTrl.ID = i.MRPCategory AND \n                MRPCategory.ID = MRPCategoryTrl.ID AND MRPCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category priceCategory ON priceCategory.ID = i.PriceCategory /*\u4ef7\u683c\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl priceCategoryTrl ON priceCategoryTrl.ID = i.PriceCategory AND \n                priceCategory.ID = priceCategoryTrl.ID AND priceCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category productionCategory ON productionCategory.ID = i.ProductionCategory /*\u751f\u4ea7\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl productionCategoryTrl ON productionCategoryTrl.ID = i.ProductionCategory AND \n                productionCategory.ID = productionCategoryTrl.ID AND productionCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category purchaseCategory ON purchaseCategory.ID = i.PurchaseCategory /*\u91c7\u8d2d\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl purchaseCategoryTrl ON purchaseCategoryTrl.ID = i.PurchaseCategory AND \n                purchaseCategory.ID = purchaseCategoryTrl.ID AND purchaseCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category saleCategory ON saleCategory.ID = i.SaleCategory /*\u9500\u552e\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl saleCategoryTrl ON saleCategoryTrl.ID = i.SaleCategory AND \n                saleCategory.ID = saleCategoryTrl.ID AND saleCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category stockCategory ON stockCategory.ID = i.StockCategory /*\u5e93\u5b58\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl stockCategoryTrl ON stockCategoryTrl.ID = i.StockCategory AND \n                stockCategory.ID = stockCategoryTrl.ID AND stockCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                UBF_Sys_ExtEnumType enumtype ON enumtype.Code = 'UFIDA.U9.CBO.SCM.Item.ItemTypeAttributeEnum' LEFT JOIN\n                UBF_Sys_ExtEnumValue enumvalue ON enumvalue.ExtEnumTypeUID = enumtype.UID AND \n                enumvalue.EValue = i.ItemFormAttribute LEFT JOIN\n                UBF_Sys_ExtEnumValue_Trl enumvalueTrl ON enumvalueTrl.ID = enumvalue.ID AND \n                enumvalueTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_Organization b ON i.Org = b.ID LEFT JOIN\n                Base_Organization_Trl bTrl ON i.Org = bTrl.ID AND b.ID = bTrl.ID AND bTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Supplier s ON i.TradeMark = s.ID LEFT JOIN\n                CBO_Supplier_Trl sTrl ON i.TradeMark = sTrl.ID AND sTrl.ID = s.ID LEFT JOIN\n                CBO_Wh w ON inv.Warehouse = w.id LEFT JOIN\n                CBO_Wh_Trl wTrl ON inv.Warehouse = wTrl.id AND w.ID = wTrl.ID AND wTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_Currency c ON i.CostCurrency = c.ID LEFT JOIN\n                Base_Currency_Trl cTrl ON i.CostCurrency = cTrl.ID AND c.ID = cTrl.ID AND cTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_KeyFlexFieldStru keyFlexStru ON category.KeyFlexFieldStru = keyFlexStru.ID LEFT JOIN\n                Base_KeyFlexSegment keyFlex ON keyFlex.KeyFlexFieldStru = keyFlexStru.ID LEFT JOIN\n                Base_ValueSetDef valueSet ON valueSet.ID = keyFlex.ValueSetDef LEFT JOIN\n                Base_DefineValue defineValue3 ON defineValue3.ValueSetDef = valueSet.ID AND \n                defineValue3.Code = category.Code /*\u672b\u7ea7\u5206\u7c7b*/ LEFT JOIN\n                Base_DefineValue_Trl defineValue3Trl ON defineValue3.ID = defineValue3Trl.ID AND \n                defineValue3Trl.SysMLFlag = 'zh-CN' /*\u672b\u7ea7\u5206\u7c7b*/ LEFT JOIN\n                Base_DefineValue defineValue2 ON defineValue3.ParentNode = defineValue2.ID /*\u4e8c\u7ea7\u5206\u7c7b*/ LEFT JOIN\n                Base_DefineValue_Trl defineValue2Trl ON defineValue3.ParentNode = defineValue2Trl.ID AND \n                defineValue2.ID = defineValue2Trl.ID AND defineValue2Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_DefineValue defineValue1 ON defineValue2.ParentNode = defineValue1.ID /*\u4e8c\u7ea7\u5206\u7c7b*/ LEFT JOIN\n                Base_DefineValue_Trl defineValue1Trl ON defineValue2.ParentNode = defineValue1Trl.ID AND \n                defineValue1.ID = defineValue1Trl.ID AND defineValue1Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_ValueSetDef valueSet4 ON valueSet4.Code = 'Z033' /*\u54c1\u724c*/ LEFT JOIN\n                Base_DefineValue defineValue4 ON valueSet4.ID = defineValue4.ValueSetDef AND \n                defineValue4.Code = i.DescFlexField_PrivateDescSeg8 LEFT JOIN\n                Base_DefineValue_Trl defineValue4Trl ON defineValue4.ID = defineValue4Trl.ID AND \n                defineValue4Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_ValueSetDef valueSet5 ON valueSet5.Code = 'Z044' /*SPU\u5206\u7c7b\uff08\u539f\u4ef7\u683c\u5206\u7c7b\u4e2d\u7c7b\uff09*/ LEFT JOIN\n                Base_DefineValue defineValue5 ON valueSet5.ID = defineValue5.ValueSetDef AND \n                defineValue5.Code = i.DescFlexField_PrivateDescSeg10 LEFT JOIN\n                Base_DefineValue_Trl defineValue5Trl ON defineValue5.ID = defineValue5Trl.ID AND \n                defineValue5Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_ValueSetDef valueSet6 ON valueSet6.Code = 'Z045' /*\u6e20\u9053*/ LEFT JOIN\n                Base_DefineValue defineValue6 ON valueSet6.ID = defineValue6.ValueSetDef AND \n                defineValue6.Code = i.DescFlexField_PrivateDescSeg11 LEFT JOIN\n                Base_DefineValue_Trl defineValue6Trl ON defineValue6.ID = defineValue6Trl.ID AND \n                defineValue6Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_UOM priceUOM ON priceUOM.ID = i.PriceUOM LEFT JOIN\n                Base_UOM_Trl priceUOMTrl ON priceUOM.ID = priceUOMTrl.ID AND priceUOMTrl.SysMLFlag = 'zh-CN'\n\t\t\t\tLEFT JOIN\n                Base_UOM weightUOM ON weightUOM.ID = i.WeightUom LEFT JOIN\n                Base_UOM_Trl weightUOMTrl ON weightUOM.ID = weightUOMTrl.ID AND weightUOMTrl.SysMLFlag = 'zh-CN'\n\t\t\t\tLEFT JOIN\n                Base_UOM bulkUOM ON bulkUOM.ID = i.BulkUom LEFT JOIN\n                Base_UOM_Trl bulkUOMTrl ON bulkUOM.ID = bulkUOMTrl.ID AND bulkUOMTrl.SysMLFlag = 'zh-CN'\nWHERE   b.Code = '001' AND IsSalesEnable = 1 ORDER BY i.CreatedOn asc";
        if (StringUtils.isNotBlank((String)flagSettingInfo)) {
            sql = "SELECT   i.CreatedOn, /*\u521b\u5efa\u65e5\u671f*/ i.ModifiedOn, /*\u4fee\u6539\u65e5\u671f*/ b.Code OrgCode, /* \u7ec4\u7ec7\u7f16\u7801,*/ bTrl.Name OrgName, \n                /* \u7ec4\u7ec7\u540d\u79f0,*/ CASE WHEN defineValue1. LEVEL = 0 THEN defineValue1.Code ELSE CASE WHEN defineValue2. LEVEL = 0\n                 THEN defineValue2.Code ELSE defineValue3.Code END END FirstCategoryCode, \n                /*\u4e00\u7ea7\u5206\u7c7b\u7f16\u7801*/ CASE WHEN defineValue1. LEVEL = 0 THEN defineValue1Trl.Name ELSE CASE WHEN defineValue2. LEVEL\n                 = 0 THEN defineValue2Trl.Name ELSE defineValue3Trl.Name END END FirstCategoryName, \n                /*\u4e00\u7ea7\u5206\u7c7b\u540d\u79f0*/ CASE WHEN defineValue2. LEVEL = 1 THEN defineValue2.Code ELSE CASE WHEN defineValue3. LEVEL\n                 = 1 THEN defineValue3.Code ELSE '' END END SecondCategoryCode, \n                /*\u4e8c\u7ea7\u5206\u7c7b\u7f16\u7801*/ CASE WHEN defineValue2. LEVEL = 1 THEN defineValue2Trl.Name ELSE CASE WHEN defineValue3. LEVEL\n                 = 1 THEN defineValue3Trl.Name ELSE '' END END SecondCategoryName, \n                /*\u4e8c\u7ea7\u5206\u7c7b\u540d\u79f0*/ CASE WHEN defineValue3. LEVEL = 2 THEN defineValue3.Code ELSE '' END ThreeCategoryCode, \n                /*\u4e09\u7ea7\u5206\u7c7b\u7f16\u7801*/ CASE WHEN defineValue3. LEVEL = 2 THEN defineValue3Trl.Name ELSE '' END ThreeCategoryName, \n                /*\u4e09\u7ea7\u5206\u7c7b\u540d\u79f0*/ category.Code CategoryCode, /* \u5206\u7c7b\u7f16\u7801,*/ categoryTrl.Name CategoryName, \n                /*\u5206\u7c7b\u540d\u79f0,*/ assetCategory.Code AssetCategoryCode, /*\u8d22\u52a1\u5206\u7c7b\u7f16\u7801*/ assetCategoryTrl.Name AssetCategoryName, \n                /*\u8d22\u52a1\u5206\u7c7b\u540d\u79f0*/ costCategory.Code CostCategoryCode, /*\u6210\u672c\u5206\u7c7b\u7f16\u7801*/ costCategoryTrl.Name CostCategoryName, \n                /*\u6210\u672c\u5206\u7c7b\u540d\u79f0*/ creditCategory.Code CreditCategoryCode, \n                /*\u4fe1\u7528\u5206\u7c7b\u7f16\u7801*/ creditCategoryTrl.Name CreditCategoryName, \n                /*\u4fe1\u7528\u5206\u7c7b\u540d\u79f0*/ MRPCategory.Code MRPCategoryCode, /*MRP\u5206\u7c7b\u7f16\u7801*/ MRPCategoryTrl.Name MRPCategoryName, \n                /*MRP\u5206\u7c7b\u540d\u79f0*/ priceCategory.Code PriceCategoryCode, /*\u4ef7\u683c\u5206\u7c7b\u7f16\u7801*/ priceCategoryTrl.Name PriceCategoryName, \n                /*\u4ef7\u683c\u5206\u7c7b\u540d\u79f0*/ productionCategory.Code ProductionCategoryCode, \n                /*\u751f\u4ea7\u5206\u7c7b\u7f16\u7801*/ productionCategoryTrl.Name ProductionCategoryName, \n                /*\u751f\u4ea7\u5206\u7c7b\u540d\u79f0*/ purchaseCategory.Code PurchaseCategoryCode, \n                /*\u91c7\u8d2d\u5206\u7c7b\u7f16\u7801*/ purchaseCategoryTrl.Name PurchaseCategoryName, \n                /*\u91c7\u8d2d\u5206\u7c7b\u540d\u79f0*/ saleCategory.Code SaleCategoryCode, /*\u9500\u552e\u5206\u7c7b\u7f16\u7801*/ saleCategoryTrl.Name SaleCategoryName, \n                /*\u9500\u552e\u5206\u7c7b\u540d\u79f0*/ stockCategory.Code StockCategoryCode, \n                /*\u5e93\u5b58\u5206\u7c7b\u7f16\u7801*/ stockCategoryTrl.Name StockCategoryName, /*\u5e93\u5b58\u5206\u7c7b\u540d\u79f0*/ priceUOM.Code PriceUOMCode, \n                priceUOMTrl.Name PriceUOMName, i.Code ItemCode, /*\u6599\u53f7,*/ i.Name ItemName, /*\u54c1\u540d,*/ SPECS Specs, \n                /*\u89c4\u683c,*/ Code1 ItemCode1, /*\u53c2\u8003\u6599\u53f71,*/ Code2 ItemCode2, /*\u53c2\u8003\u6599\u53f72,*/ iTrl.Description Description, \n                /*\u63cf\u8ff0,*/ ItemFormAttribute AttributeValue, /*\u6599\u54c1\u5f62\u6001\u5c5e\u6027\u503c,*/ enumvalueTrl.Name AttributeName, \n                /*\u6599\u54c1\u5f62\u6001\u5c5e\u6027\u540d\u79f0,*/ IsInventoryEnable, /* \u53ef\u5e93\u5b58\u4ea4\u6613,*/ IsPurchaseEnable, /* \u53ef\u91c7\u8d2d,*/ IsSalesEnable, \n                /* \u53ef\u9500\u552e,*/ IsBuildEnable, /* \u53ef\u751f\u4ea7,*/ IsOutsideOperationEnable, /* \u53ef\u59d4\u5916,*/ IsMRPEnable, /* \u53efMRP,*/ IsBOMEnable, \n                /* \u53efNOM,*/ IsMFGConfigEnable, /* \u53ef\u9009\u914d,*/ IsVMIEnable, /* VMI\u6599\u54c1,*/ IsTrademark, /* \u5382\u724c\u7ba1\u7406,*/ s.Code MfgCode, \n                /*\u5382\u724c\u7f16\u7801,*/ sTrl.Name MfgName, /*\u5382\u724c\u540d\u79f0*/ w.Code WHCode, /*\u5b58\u50a8\u5730\u70b9\u7f16\u7801,*/ wTrl.Name WHName, \n                /*\u5b58\u50a8\u5730\u70b9\u540d\u79f0,*/ c.Code CurrencyCode, /*\u5e01\u79cd\u7f16\u7801,*/ cTrl.Name CurrencyName, /*\u5e01\u79cd\u540d\u79f0,*/ i.RefrenceCost CostPrice, \n                /*\u6210\u672c\u5355\u4ef7*/ i.Effective_EffectiveDate, /*\u751f\u6548\u65e5\u671f*/ i.Effective_DisableDate, /*\u5931\u6548\u65e5\u671f*/ inv.SafetyStockType, \n                /*\u5b89\u5168\u5b58\u91cf\u6cd5*/ inv.SafetyStockPeriod, /*\u5b89\u5168\u5e93\u5b58\u671f*/ inv.SafetyStockQty, /*\u5b89\u5168\u5e93\u5b58\u91cf*/ inv.SafetyStockRate, \n                /*\u5b89\u5168\u5e93\u5b58\u91cf\u767e\u5206\u6bd4*/ i.DescFlexField_PubDescSeg21, /*\u91c7\u8d2d\u6807\u51c6\u4ef7*/ i.DescFlexField_PubDescSeg29, \n                /*\u5317\u65b9\u5355\u91cd*/ i.DescFlexField_PubDescSeg30, '' Prv1Code, i.DescFlexField_PrivateDescSeg1 Prv1Name, '' Prv2Code, \n                i.DescFlexField_PrivateDescSeg2 Prv2Name, '' Prv3Code, i.DescFlexField_PrivateDescSeg3 Prv3Name, '' Prv4Code, \n                i.DescFlexField_PrivateDescSeg4 Prv4Name, '' Prv5Code, i.DescFlexField_PrivateDescSeg5 Prv5Name, '' Prv6Code, \n                i.DescFlexField_PrivateDescSeg6 Prv6Name, '' Prv7Code, i.DescFlexField_PrivateDescSeg7 Prv7Name, \n                /*\u5357\u65b9\u5206\u7c7b3*/ defineValue4.Code Prv8Code, /*\u54c1\u724c\u7f16\u7801*/ defineValue4Trl.Name Prv8Name, '' Prv9Code, \n                i.DescFlexField_PrivateDescSeg9 Prv9Name, /*\u6750\u8d28*/ defineValue5.Code Prv10Code, \n                /*SPU\u5206\u7c7b\u7f16\u7801\uff08\u539f\u4ef7\u683c\u5206\u7c7b\u4e2d\u7c7b\u7f16\u7801\uff09*/ defineValue5Trl.Name Prv10Name, /*SPU\u5206\u7c7b\u540d\u79f0\uff08\u539f\u4ef7\u683c\u5206\u7c7b\u4e2d\u7c7b\u540d\u79f0\uff09*/ defineValue6.Code Prv11Code, \n                /*\u6e20\u9053\u7f16\u7801*/ defineValue6Trl.Name Prv11Name, '' Prv12Code, i.DescFlexField_PrivateDescSeg12 Prv12Name, \n                '' Prv13Code, i.DescFlexField_PrivateDescSeg13 Prv13Name, '' Prv14Code, \n                i.DescFlexField_PrivateDescSeg14 Prv14Name, '' Prv15Code, i.DescFlexField_PrivateDescSeg15 Prv15Name, \n                '' Prv16Code, i.DescFlexField_PrivateDescSeg16 Prv16Name, '' Prv17Code, \n                i.DescFlexField_PrivateDescSeg17 Prv17Name, '' Prv18Code, i.DescFlexField_PrivateDescSeg18 Prv18Name, \n                '' Prv19Code, i.DescFlexField_PrivateDescSeg19 Prv19Name, '' Prv20Code, \n                i.DescFlexField_PrivateDescSeg20 Prv20Name, '' Prv21Code, i.DescFlexField_PrivateDescSeg21 Prv21Name, \n                '' Prv22Code, i.DescFlexField_PrivateDescSeg22 Prv22Name, '' Prv23Code, \n                i.DescFlexField_PrivateDescSeg23 Prv23Name, '' Prv24Code, i.DescFlexField_PrivateDescSeg24 Prv24Name, \n                '' Prv25Code, i.DescFlexField_PrivateDescSeg25 Prv25Name, '' Prv26Code, \n                i.DescFlexField_PrivateDescSeg26 Prv26Name, '' Prv27Code, i.DescFlexField_PrivateDescSeg27 Prv27Name, \n                '' Prv28Code, i.DescFlexField_PrivateDescSeg28 Prv28Name, '' Prv29Code, \n                i.DescFlexField_PrivateDescSeg29 Prv29Name, '' Prv30Code, i.DescFlexField_PrivateDescSeg30 Prv30Name, \n                i.Weight, /*\u91cd\u91cf*/ i.ItemBulk/*\u4f53\u79ef*/,i.Effective_IsEffective,/*\u542f\u7528\u7981\u7528\u72b6\u6001*/\n\t\t\t\ti.ID ItemID,/*\u6599\u54c1ID*/saleCategory.ID SaleCategoryID,/*\u9500\u552e\u5206\u7c7bID*/weightUOM.Code WeightUOMCode,/*\u5e93\u5b58\u5355\u4f4d\u7f16\u7801*/\n\t\t\t\tweightUOMTrl.Name WeightUOMName,/*\u5e93\u5b58\u5355\u4f4d\u540d\u79f0*/bulkUOM.Code BulkUOMCode,/*\u5e93\u5b58\u5355\u4f4d\u7f16\u7801*/\n\t\t\t\tbulkUOMTrl.Name BulkUOMName/*\u5e93\u5b58\u5355\u4f4d\u540d\u79f0*/\n/*\u4f53\u79ef*/ FROM CBO_ItemMaster i LEFT JOIN\n                CBO_ItemMaster_Trl iTrl ON i.ID = iTrl.ID AND iTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_InventoryInfo inv ON i.InventoryInfo = inv.ID LEFT JOIN\n                CBO_Category category ON category.ID = i.MainItemCategory LEFT JOIN\n                CBO_Category_Trl categoryTrl ON categoryTrl.ID = i.MainItemCategory AND category.ID = categoryTrl.ID AND \n                categoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category assetCategory ON assetCategory.ID = i.AssetCategory /*\u8d22\u52a1\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl assetCategoryTrl ON assetCategoryTrl.ID = i.AssetCategory AND \n                assetCategory.ID = assetCategoryTrl.ID AND assetCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category costCategory ON costCategory.ID = i.CostCategory /*\u6210\u672c\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl costCategoryTrl ON costCategoryTrl.ID = i.CostCategory AND \n                costCategory.ID = costCategoryTrl.ID AND costCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category creditCategory ON creditCategory.ID = i.CreditCategory /*\u4fe1\u7528\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl creditCategoryTrl ON creditCategoryTrl.ID = i.CreditCategory AND \n                creditCategory.ID = creditCategoryTrl.ID AND creditCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category MRPCategory ON MRPCategory.ID = i.MRPCategory /*MRP\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl MRPCategoryTrl ON MRPCategoryTrl.ID = i.MRPCategory AND \n                MRPCategory.ID = MRPCategoryTrl.ID AND MRPCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category priceCategory ON priceCategory.ID = i.PriceCategory /*\u4ef7\u683c\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl priceCategoryTrl ON priceCategoryTrl.ID = i.PriceCategory AND \n                priceCategory.ID = priceCategoryTrl.ID AND priceCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category productionCategory ON productionCategory.ID = i.ProductionCategory /*\u751f\u4ea7\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl productionCategoryTrl ON productionCategoryTrl.ID = i.ProductionCategory AND \n                productionCategory.ID = productionCategoryTrl.ID AND productionCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category purchaseCategory ON purchaseCategory.ID = i.PurchaseCategory /*\u91c7\u8d2d\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl purchaseCategoryTrl ON purchaseCategoryTrl.ID = i.PurchaseCategory AND \n                purchaseCategory.ID = purchaseCategoryTrl.ID AND purchaseCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category saleCategory ON saleCategory.ID = i.SaleCategory /*\u9500\u552e\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl saleCategoryTrl ON saleCategoryTrl.ID = i.SaleCategory AND \n                saleCategory.ID = saleCategoryTrl.ID AND saleCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category stockCategory ON stockCategory.ID = i.StockCategory /*\u5e93\u5b58\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl stockCategoryTrl ON stockCategoryTrl.ID = i.StockCategory AND \n                stockCategory.ID = stockCategoryTrl.ID AND stockCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                UBF_Sys_ExtEnumType enumtype ON enumtype.Code = 'UFIDA.U9.CBO.SCM.Item.ItemTypeAttributeEnum' LEFT JOIN\n                UBF_Sys_ExtEnumValue enumvalue ON enumvalue.ExtEnumTypeUID = enumtype.UID AND \n                enumvalue.EValue = i.ItemFormAttribute LEFT JOIN\n                UBF_Sys_ExtEnumValue_Trl enumvalueTrl ON enumvalueTrl.ID = enumvalue.ID AND \n                enumvalueTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_Organization b ON i.Org = b.ID LEFT JOIN\n                Base_Organization_Trl bTrl ON i.Org = bTrl.ID AND b.ID = bTrl.ID AND bTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Supplier s ON i.TradeMark = s.ID LEFT JOIN\n                CBO_Supplier_Trl sTrl ON i.TradeMark = sTrl.ID AND sTrl.ID = s.ID LEFT JOIN\n                CBO_Wh w ON inv.Warehouse = w.id LEFT JOIN\n                CBO_Wh_Trl wTrl ON inv.Warehouse = wTrl.id AND w.ID = wTrl.ID AND wTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_Currency c ON i.CostCurrency = c.ID LEFT JOIN\n                Base_Currency_Trl cTrl ON i.CostCurrency = cTrl.ID AND c.ID = cTrl.ID AND cTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_KeyFlexFieldStru keyFlexStru ON category.KeyFlexFieldStru = keyFlexStru.ID LEFT JOIN\n                Base_KeyFlexSegment keyFlex ON keyFlex.KeyFlexFieldStru = keyFlexStru.ID LEFT JOIN\n                Base_ValueSetDef valueSet ON valueSet.ID = keyFlex.ValueSetDef LEFT JOIN\n                Base_DefineValue defineValue3 ON defineValue3.ValueSetDef = valueSet.ID AND \n                defineValue3.Code = category.Code /*\u672b\u7ea7\u5206\u7c7b*/ LEFT JOIN\n                Base_DefineValue_Trl defineValue3Trl ON defineValue3.ID = defineValue3Trl.ID AND \n                defineValue3Trl.SysMLFlag = 'zh-CN' /*\u672b\u7ea7\u5206\u7c7b*/ LEFT JOIN\n                Base_DefineValue defineValue2 ON defineValue3.ParentNode = defineValue2.ID /*\u4e8c\u7ea7\u5206\u7c7b*/ LEFT JOIN\n                Base_DefineValue_Trl defineValue2Trl ON defineValue3.ParentNode = defineValue2Trl.ID AND \n                defineValue2.ID = defineValue2Trl.ID AND defineValue2Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_DefineValue defineValue1 ON defineValue2.ParentNode = defineValue1.ID /*\u4e8c\u7ea7\u5206\u7c7b*/ LEFT JOIN\n                Base_DefineValue_Trl defineValue1Trl ON defineValue2.ParentNode = defineValue1Trl.ID AND \n                defineValue1.ID = defineValue1Trl.ID AND defineValue1Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_ValueSetDef valueSet4 ON valueSet4.Code = 'Z033' /*\u54c1\u724c*/ LEFT JOIN\n                Base_DefineValue defineValue4 ON valueSet4.ID = defineValue4.ValueSetDef AND \n                defineValue4.Code = i.DescFlexField_PrivateDescSeg8 LEFT JOIN\n                Base_DefineValue_Trl defineValue4Trl ON defineValue4.ID = defineValue4Trl.ID AND \n                defineValue4Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_ValueSetDef valueSet5 ON valueSet5.Code = 'Z044' /*SPU\u5206\u7c7b\uff08\u539f\u4ef7\u683c\u5206\u7c7b\u4e2d\u7c7b\uff09*/ LEFT JOIN\n                Base_DefineValue defineValue5 ON valueSet5.ID = defineValue5.ValueSetDef AND \n                defineValue5.Code = i.DescFlexField_PrivateDescSeg10 LEFT JOIN\n                Base_DefineValue_Trl defineValue5Trl ON defineValue5.ID = defineValue5Trl.ID AND \n                defineValue5Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_ValueSetDef valueSet6 ON valueSet6.Code = 'Z045' /*\u6e20\u9053*/ LEFT JOIN\n                Base_DefineValue defineValue6 ON valueSet6.ID = defineValue6.ValueSetDef AND \n                defineValue6.Code = i.DescFlexField_PrivateDescSeg11 LEFT JOIN\n                Base_DefineValue_Trl defineValue6Trl ON defineValue6.ID = defineValue6Trl.ID AND \n                defineValue6Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_UOM priceUOM ON priceUOM.ID = i.PriceUOM LEFT JOIN\n                Base_UOM_Trl priceUOMTrl ON priceUOM.ID = priceUOMTrl.ID AND priceUOMTrl.SysMLFlag = 'zh-CN'\n\t\t\t\tLEFT JOIN\n                Base_UOM weightUOM ON weightUOM.ID = i.WeightUom LEFT JOIN\n                Base_UOM_Trl weightUOMTrl ON weightUOM.ID = weightUOMTrl.ID AND weightUOMTrl.SysMLFlag = 'zh-CN'\n\t\t\t\tLEFT JOIN\n                Base_UOM bulkUOM ON bulkUOM.ID = i.BulkUom LEFT JOIN\n                Base_UOM_Trl bulkUOMTrl ON bulkUOM.ID = bulkUOMTrl.ID AND bulkUOMTrl.SysMLFlag = 'zh-CN'\nWHERE   b.Code = '001' AND IsSalesEnable = 1 AND  i.CreatedOn > ?  ORDER BY i.CreatedOn asc";
            args = this.getLocalDateTime(flagSettingInfo);
            initialCustomer = false;
        }
        logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.sql", (Object)sql);
        List<ResourceGoodsU9> resourceGoodsU9 = null;
        try {
            if (initialCustomer) {
                this.saveDdFlag(internalRouter, tenantCode, "resourceGoodsUpdateBeginTime", "\u5546\u54c1\u4fee\u6539\u8d77\u59cb\u65f6\u95f4", localDateTime, null);
            }
            logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.queryU9", (Object)"\u67e5\u8be2U9\u5546\u54c1\u6570\u636e\u5f00\u59cb");
            resourceGoodsU9 = SqlServerUtils.getForList(ResourceGoodsU9.class, sql, args);
            logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.queryU9", (Object)"\u67e5\u8be2U9\u5546\u54c1\u6570\u636e\u7ed3\u675f");
            logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.resourceGoodsU9.size", (Object)resourceGoodsU9.size());
            if (ListUtil.isEmpty(resourceGoodsU9)) {
                logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.queryU9", (Object)"\u67e5\u8be2U9\u5546\u54c1\u6570\u636e\u4e3a\u7a7a");
                return "\u6ca1\u6709\u65b0\u589e\u7684\u5546\u54c1\u4fe1\u606f";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".sendInitialAndAddBusGoods.view", (Object)"\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
            return "\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898";
        }
        Map<String, List<ResourceGoodsU9>> spuMap = resourceGoodsU9.stream().collect(Collectors.groupingBy(ResourceGoodsU9::getPrv10Code));
        Iterator<String> iterator = spuMap.keySet().iterator();
        while (iterator.hasNext()) {
            this.saveResourceGoods(spuMap.get(iterator.next()), tenantCode, null, internalRouter);
        }
        ResourceGoodsU9 lastCreateItem = resourceGoodsU9.get(resourceGoodsU9.size() - 1);
        try {
            this.updateFalgSettingInFoByKey(internalRouter, "InitailResourceGoodsAndAdd", tenantCode, lastCreateItem.getCreatedOn(), flagSettingId);
        }
        finally {
            itemThreadPoolExecutor.shutdownNow();
        }
        return this.makeSuccessReturn("SUCCESS");
    }

    @Override
    public String sendInitailBusGoodsCompensate(final String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerCompensate.tenantCode", (Object)"tenantCode is null");
            return "tenantCode is null";
        }
        InternalRouter internalRouter = this.getInternalRouter();
        if (null == internalRouter) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerCompensate.internalRouter", (Object)"internalRouter is null");
            return "internalRouter is null";
        }
        final HashMap<String, Object> logMap = new HashMap<String, Object>(){
            {
                this.put("fuzzy", true);
                this.put("tenantCode", tenantCode);
                this.put("clientExecuteMethod", "busdata.busRsGoods.sendInitialAndAddBusGoods");
                this.put("dataState", 0);
            }
        };
        HashMap<String, Object> logParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)logMap));
            }
        };
        logger.error(this.SYS_CODE + ".sendInitailCustomerCompensate.logParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)logParamMap));
        String logStr = (String)internalRouter.inInvoke("log.log.queryErrorLogPage", (Map)logParamMap);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(logStr, SupQueryResult.class);
        List logList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), LogErrorLog.class);
        logger.error(this.SYS_CODE + ".sendInitailCustomerCompensate.logList", (Object)JsonUtil.buildNormalBinder().toJson((Object)logList));
        if (ListUtil.isEmpty((Collection)logList)) {
            logger.error(this.SYS_CODE + ".sendInitailCustomerCompensate.logList", (Object)JsonUtil.buildNormalBinder().toJson((Object)logList));
            return "logList is null\uff0c\u6ca1\u6709\u5f85\u8865\u507f\u7684\u65b0\u589e\u8bb0\u5f55";
        }
        Iterator iterator = logList.iterator();
        if (iterator.hasNext()) {
            LogErrorLog logErrorLog = (LogErrorLog)iterator.next();
            RsResourceGoodsDomain rsResourceGoodsDomain = (RsResourceGoodsDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(logErrorLog.getErrorLogMessage(), RsResourceGoodsDomain.class);
            try {
                this.sendSaveExcelBusGoods(rsResourceGoodsDomain);
                this.updateLogState(internalRouter, logErrorLog, logErrorLog.getDataState(), 4);
                return this.makeSuccessReturn(rsResourceGoodsDomain.getSkuNo());
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".sendSaveExGoodsSpu.rsResourceGoodsDomain.Exception", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain), (Throwable)e);
                this.updateLogState(internalRouter, logErrorLog, logErrorLog.getDataState(), 4);
                return this.makeErrorReturn(rsResourceGoodsDomain.getSkuNo(), "\u6570\u636e" + rsResourceGoodsDomain.getSkuNo() + "\u6dfb\u52a0\u5f02\u5e38");
            }
        }
        return this.makeSuccessReturn("SUCCESS");
    }

    @Override
    public String sendUpdateBusGoods(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendUpdateBusGoods.tenantCode", (Object)"tenantCode is null");
            return "tenantCode is null";
        }
        InternalRouter internalRouter = this.getInternalRouter();
        if (null == internalRouter) {
            logger.error(this.SYS_CODE + ".sendUpdateBusGoods.internalRouter", (Object)"internalRouter is null");
            return "internalRouter is null";
        }
        DdFalgSetting ddFalgSetting = this.queryDdFlagSetting(tenantCode, internalRouter, "resourceGoodsUpdateBeginTime");
        if (null == ddFalgSetting) {
            logger.error(this.SYS_CODE + ".sendUpdateBusGoods.ddFalgSetting", (Object)"ddFalgSetting is null");
            return "ddFalgSetting is null";
        }
        Integer flagSettingId = ddFalgSetting.getFlagSettingId();
        String flagSettingInfo = ddFalgSetting.getFlagSettingInfo();
        logger.error(this.SYS_CODE + ".sendUpdateBusGoods.flagSettingInfo", (Object)flagSettingInfo);
        if (StringUtils.isBlank((String)flagSettingInfo)) {
            logger.error(this.SYS_CODE + ".sendUpdateBusGoods.internalRouter", (Object)"flagSettingInfo is null ");
        }
        List<ResourceGoodsU9> rsResourceGoodsListFromU9 = null;
        try {
            logger.error(this.SYS_CODE + ".sendUpdateBusGoods.queryU9", (Object)"\u67e5\u8be2U9\u5ba2\u6237\u6570\u636e\u5f00\u59cb");
            rsResourceGoodsListFromU9 = SqlServerUtils.getForList(ResourceGoodsU9.class, "SELECT   i.CreatedOn, /*\u521b\u5efa\u65e5\u671f*/ i.ModifiedOn, /*\u4fee\u6539\u65e5\u671f*/ b.Code OrgCode, /* \u7ec4\u7ec7\u7f16\u7801,*/ bTrl.Name OrgName, \n                /* \u7ec4\u7ec7\u540d\u79f0,*/ CASE WHEN defineValue1. LEVEL = 0 THEN defineValue1.Code ELSE CASE WHEN defineValue2. LEVEL = 0\n                 THEN defineValue2.Code ELSE defineValue3.Code END END FirstCategoryCode, \n                /*\u4e00\u7ea7\u5206\u7c7b\u7f16\u7801*/ CASE WHEN defineValue1. LEVEL = 0 THEN defineValue1Trl.Name ELSE CASE WHEN defineValue2. LEVEL\n                 = 0 THEN defineValue2Trl.Name ELSE defineValue3Trl.Name END END FirstCategoryName, \n                /*\u4e00\u7ea7\u5206\u7c7b\u540d\u79f0*/ CASE WHEN defineValue2. LEVEL = 1 THEN defineValue2.Code ELSE CASE WHEN defineValue3. LEVEL\n                 = 1 THEN defineValue3.Code ELSE '' END END SecondCategoryCode, \n                /*\u4e8c\u7ea7\u5206\u7c7b\u7f16\u7801*/ CASE WHEN defineValue2. LEVEL = 1 THEN defineValue2Trl.Name ELSE CASE WHEN defineValue3. LEVEL\n                 = 1 THEN defineValue3Trl.Name ELSE '' END END SecondCategoryName, \n                /*\u4e8c\u7ea7\u5206\u7c7b\u540d\u79f0*/ CASE WHEN defineValue3. LEVEL = 2 THEN defineValue3.Code ELSE '' END ThreeCategoryCode, \n                /*\u4e09\u7ea7\u5206\u7c7b\u7f16\u7801*/ CASE WHEN defineValue3. LEVEL = 2 THEN defineValue3Trl.Name ELSE '' END ThreeCategoryName, \n                /*\u4e09\u7ea7\u5206\u7c7b\u540d\u79f0*/ category.Code CategoryCode, /* \u5206\u7c7b\u7f16\u7801,*/ categoryTrl.Name CategoryName, \n                /*\u5206\u7c7b\u540d\u79f0,*/ assetCategory.Code AssetCategoryCode, /*\u8d22\u52a1\u5206\u7c7b\u7f16\u7801*/ assetCategoryTrl.Name AssetCategoryName, \n                /*\u8d22\u52a1\u5206\u7c7b\u540d\u79f0*/ costCategory.Code CostCategoryCode, /*\u6210\u672c\u5206\u7c7b\u7f16\u7801*/ costCategoryTrl.Name CostCategoryName, \n                /*\u6210\u672c\u5206\u7c7b\u540d\u79f0*/ creditCategory.Code CreditCategoryCode, \n                /*\u4fe1\u7528\u5206\u7c7b\u7f16\u7801*/ creditCategoryTrl.Name CreditCategoryName, \n                /*\u4fe1\u7528\u5206\u7c7b\u540d\u79f0*/ MRPCategory.Code MRPCategoryCode, /*MRP\u5206\u7c7b\u7f16\u7801*/ MRPCategoryTrl.Name MRPCategoryName, \n                /*MRP\u5206\u7c7b\u540d\u79f0*/ priceCategory.Code PriceCategoryCode, /*\u4ef7\u683c\u5206\u7c7b\u7f16\u7801*/ priceCategoryTrl.Name PriceCategoryName, \n                /*\u4ef7\u683c\u5206\u7c7b\u540d\u79f0*/ productionCategory.Code ProductionCategoryCode, \n                /*\u751f\u4ea7\u5206\u7c7b\u7f16\u7801*/ productionCategoryTrl.Name ProductionCategoryName, \n                /*\u751f\u4ea7\u5206\u7c7b\u540d\u79f0*/ purchaseCategory.Code PurchaseCategoryCode, \n                /*\u91c7\u8d2d\u5206\u7c7b\u7f16\u7801*/ purchaseCategoryTrl.Name PurchaseCategoryName, \n                /*\u91c7\u8d2d\u5206\u7c7b\u540d\u79f0*/ saleCategory.Code SaleCategoryCode, /*\u9500\u552e\u5206\u7c7b\u7f16\u7801*/ saleCategoryTrl.Name SaleCategoryName, \n                /*\u9500\u552e\u5206\u7c7b\u540d\u79f0*/ stockCategory.Code StockCategoryCode, \n                /*\u5e93\u5b58\u5206\u7c7b\u7f16\u7801*/ stockCategoryTrl.Name StockCategoryName, /*\u5e93\u5b58\u5206\u7c7b\u540d\u79f0*/ priceUOM.Code PriceUOMCode, \n                priceUOMTrl.Name PriceUOMName, i.Code ItemCode, /*\u6599\u53f7,*/ i.Name ItemName, /*\u54c1\u540d,*/ SPECS Specs, \n                /*\u89c4\u683c,*/ Code1 ItemCode1, /*\u53c2\u8003\u6599\u53f71,*/ Code2 ItemCode2, /*\u53c2\u8003\u6599\u53f72,*/ iTrl.Description Description, \n                /*\u63cf\u8ff0,*/ ItemFormAttribute AttributeValue, /*\u6599\u54c1\u5f62\u6001\u5c5e\u6027\u503c,*/ enumvalueTrl.Name AttributeName, \n                /*\u6599\u54c1\u5f62\u6001\u5c5e\u6027\u540d\u79f0,*/ IsInventoryEnable, /* \u53ef\u5e93\u5b58\u4ea4\u6613,*/ IsPurchaseEnable, /* \u53ef\u91c7\u8d2d,*/ IsSalesEnable, \n                /* \u53ef\u9500\u552e,*/ IsBuildEnable, /* \u53ef\u751f\u4ea7,*/ IsOutsideOperationEnable, /* \u53ef\u59d4\u5916,*/ IsMRPEnable, /* \u53efMRP,*/ IsBOMEnable, \n                /* \u53efNOM,*/ IsMFGConfigEnable, /* \u53ef\u9009\u914d,*/ IsVMIEnable, /* VMI\u6599\u54c1,*/ IsTrademark, /* \u5382\u724c\u7ba1\u7406,*/ s.Code MfgCode, \n                /*\u5382\u724c\u7f16\u7801,*/ sTrl.Name MfgName, /*\u5382\u724c\u540d\u79f0*/ w.Code WHCode, /*\u5b58\u50a8\u5730\u70b9\u7f16\u7801,*/ wTrl.Name WHName, \n                /*\u5b58\u50a8\u5730\u70b9\u540d\u79f0,*/ c.Code CurrencyCode, /*\u5e01\u79cd\u7f16\u7801,*/ cTrl.Name CurrencyName, /*\u5e01\u79cd\u540d\u79f0,*/ i.RefrenceCost CostPrice, \n                /*\u6210\u672c\u5355\u4ef7*/ i.Effective_EffectiveDate, /*\u751f\u6548\u65e5\u671f*/ i.Effective_DisableDate, /*\u5931\u6548\u65e5\u671f*/ inv.SafetyStockType, \n                /*\u5b89\u5168\u5b58\u91cf\u6cd5*/ inv.SafetyStockPeriod, /*\u5b89\u5168\u5e93\u5b58\u671f*/ inv.SafetyStockQty, /*\u5b89\u5168\u5e93\u5b58\u91cf*/ inv.SafetyStockRate, \n                /*\u5b89\u5168\u5e93\u5b58\u91cf\u767e\u5206\u6bd4*/ i.DescFlexField_PubDescSeg21, /*\u91c7\u8d2d\u6807\u51c6\u4ef7*/ i.DescFlexField_PubDescSeg29, \n                /*\u5317\u65b9\u5355\u91cd*/ i.DescFlexField_PubDescSeg30, '' Prv1Code, i.DescFlexField_PrivateDescSeg1 Prv1Name, '' Prv2Code, \n                i.DescFlexField_PrivateDescSeg2 Prv2Name, '' Prv3Code, i.DescFlexField_PrivateDescSeg3 Prv3Name, '' Prv4Code, \n                i.DescFlexField_PrivateDescSeg4 Prv4Name, '' Prv5Code, i.DescFlexField_PrivateDescSeg5 Prv5Name, '' Prv6Code, \n                i.DescFlexField_PrivateDescSeg6 Prv6Name, '' Prv7Code, i.DescFlexField_PrivateDescSeg7 Prv7Name, \n                /*\u5357\u65b9\u5206\u7c7b3*/ defineValue4.Code Prv8Code, /*\u54c1\u724c\u7f16\u7801*/ defineValue4Trl.Name Prv8Name, '' Prv9Code, \n                i.DescFlexField_PrivateDescSeg9 Prv9Name, /*\u6750\u8d28*/ defineValue5.Code Prv10Code, \n                /*SPU\u5206\u7c7b\u7f16\u7801\uff08\u539f\u4ef7\u683c\u5206\u7c7b\u4e2d\u7c7b\u7f16\u7801\uff09*/ defineValue5Trl.Name Prv10Name, /*SPU\u5206\u7c7b\u540d\u79f0\uff08\u539f\u4ef7\u683c\u5206\u7c7b\u4e2d\u7c7b\u540d\u79f0\uff09*/ defineValue6.Code Prv11Code, \n                /*\u6e20\u9053\u7f16\u7801*/ defineValue6Trl.Name Prv11Name, '' Prv12Code, i.DescFlexField_PrivateDescSeg12 Prv12Name, \n                '' Prv13Code, i.DescFlexField_PrivateDescSeg13 Prv13Name, '' Prv14Code, \n                i.DescFlexField_PrivateDescSeg14 Prv14Name, '' Prv15Code, i.DescFlexField_PrivateDescSeg15 Prv15Name, \n                '' Prv16Code, i.DescFlexField_PrivateDescSeg16 Prv16Name, '' Prv17Code, \n                i.DescFlexField_PrivateDescSeg17 Prv17Name, '' Prv18Code, i.DescFlexField_PrivateDescSeg18 Prv18Name, \n                '' Prv19Code, i.DescFlexField_PrivateDescSeg19 Prv19Name, '' Prv20Code, \n                i.DescFlexField_PrivateDescSeg20 Prv20Name, '' Prv21Code, i.DescFlexField_PrivateDescSeg21 Prv21Name, \n                '' Prv22Code, i.DescFlexField_PrivateDescSeg22 Prv22Name, '' Prv23Code, \n                i.DescFlexField_PrivateDescSeg23 Prv23Name, '' Prv24Code, i.DescFlexField_PrivateDescSeg24 Prv24Name, \n                '' Prv25Code, i.DescFlexField_PrivateDescSeg25 Prv25Name, '' Prv26Code, \n                i.DescFlexField_PrivateDescSeg26 Prv26Name, '' Prv27Code, i.DescFlexField_PrivateDescSeg27 Prv27Name, \n                '' Prv28Code, i.DescFlexField_PrivateDescSeg28 Prv28Name, '' Prv29Code, \n                i.DescFlexField_PrivateDescSeg29 Prv29Name, '' Prv30Code, i.DescFlexField_PrivateDescSeg30 Prv30Name, \n                i.Weight, /*\u91cd\u91cf*/ i.ItemBulk/*\u4f53\u79ef*/,i.Effective_IsEffective,/*\u542f\u7528\u7981\u7528\u72b6\u6001*/\n\t\t\t\ti.ID ItemID,/*\u6599\u54c1ID*/saleCategory.ID SaleCategoryID,/*\u9500\u552e\u5206\u7c7bID*/weightUOM.Code WeightUOMCode,/*\u5e93\u5b58\u5355\u4f4d\u7f16\u7801*/\n\t\t\t\tweightUOMTrl.Name WeightUOMName,/*\u5e93\u5b58\u5355\u4f4d\u540d\u79f0*/bulkUOM.Code BulkUOMCode,/*\u5e93\u5b58\u5355\u4f4d\u7f16\u7801*/\n\t\t\t\tbulkUOMTrl.Name BulkUOMName/*\u5e93\u5b58\u5355\u4f4d\u540d\u79f0*/\n/*\u4f53\u79ef*/ FROM CBO_ItemMaster i LEFT JOIN\n                CBO_ItemMaster_Trl iTrl ON i.ID = iTrl.ID AND iTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_InventoryInfo inv ON i.InventoryInfo = inv.ID LEFT JOIN\n                CBO_Category category ON category.ID = i.MainItemCategory LEFT JOIN\n                CBO_Category_Trl categoryTrl ON categoryTrl.ID = i.MainItemCategory AND category.ID = categoryTrl.ID AND \n                categoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category assetCategory ON assetCategory.ID = i.AssetCategory /*\u8d22\u52a1\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl assetCategoryTrl ON assetCategoryTrl.ID = i.AssetCategory AND \n                assetCategory.ID = assetCategoryTrl.ID AND assetCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category costCategory ON costCategory.ID = i.CostCategory /*\u6210\u672c\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl costCategoryTrl ON costCategoryTrl.ID = i.CostCategory AND \n                costCategory.ID = costCategoryTrl.ID AND costCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category creditCategory ON creditCategory.ID = i.CreditCategory /*\u4fe1\u7528\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl creditCategoryTrl ON creditCategoryTrl.ID = i.CreditCategory AND \n                creditCategory.ID = creditCategoryTrl.ID AND creditCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category MRPCategory ON MRPCategory.ID = i.MRPCategory /*MRP\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl MRPCategoryTrl ON MRPCategoryTrl.ID = i.MRPCategory AND \n                MRPCategory.ID = MRPCategoryTrl.ID AND MRPCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category priceCategory ON priceCategory.ID = i.PriceCategory /*\u4ef7\u683c\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl priceCategoryTrl ON priceCategoryTrl.ID = i.PriceCategory AND \n                priceCategory.ID = priceCategoryTrl.ID AND priceCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category productionCategory ON productionCategory.ID = i.ProductionCategory /*\u751f\u4ea7\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl productionCategoryTrl ON productionCategoryTrl.ID = i.ProductionCategory AND \n                productionCategory.ID = productionCategoryTrl.ID AND productionCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category purchaseCategory ON purchaseCategory.ID = i.PurchaseCategory /*\u91c7\u8d2d\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl purchaseCategoryTrl ON purchaseCategoryTrl.ID = i.PurchaseCategory AND \n                purchaseCategory.ID = purchaseCategoryTrl.ID AND purchaseCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category saleCategory ON saleCategory.ID = i.SaleCategory /*\u9500\u552e\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl saleCategoryTrl ON saleCategoryTrl.ID = i.SaleCategory AND \n                saleCategory.ID = saleCategoryTrl.ID AND saleCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Category stockCategory ON stockCategory.ID = i.StockCategory /*\u5e93\u5b58\u5206\u7c7b*/ LEFT JOIN\n                CBO_Category_Trl stockCategoryTrl ON stockCategoryTrl.ID = i.StockCategory AND \n                stockCategory.ID = stockCategoryTrl.ID AND stockCategoryTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                UBF_Sys_ExtEnumType enumtype ON enumtype.Code = 'UFIDA.U9.CBO.SCM.Item.ItemTypeAttributeEnum' LEFT JOIN\n                UBF_Sys_ExtEnumValue enumvalue ON enumvalue.ExtEnumTypeUID = enumtype.UID AND \n                enumvalue.EValue = i.ItemFormAttribute LEFT JOIN\n                UBF_Sys_ExtEnumValue_Trl enumvalueTrl ON enumvalueTrl.ID = enumvalue.ID AND \n                enumvalueTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_Organization b ON i.Org = b.ID LEFT JOIN\n                Base_Organization_Trl bTrl ON i.Org = bTrl.ID AND b.ID = bTrl.ID AND bTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                CBO_Supplier s ON i.TradeMark = s.ID LEFT JOIN\n                CBO_Supplier_Trl sTrl ON i.TradeMark = sTrl.ID AND sTrl.ID = s.ID LEFT JOIN\n                CBO_Wh w ON inv.Warehouse = w.id LEFT JOIN\n                CBO_Wh_Trl wTrl ON inv.Warehouse = wTrl.id AND w.ID = wTrl.ID AND wTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_Currency c ON i.CostCurrency = c.ID LEFT JOIN\n                Base_Currency_Trl cTrl ON i.CostCurrency = cTrl.ID AND c.ID = cTrl.ID AND cTrl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_KeyFlexFieldStru keyFlexStru ON category.KeyFlexFieldStru = keyFlexStru.ID LEFT JOIN\n                Base_KeyFlexSegment keyFlex ON keyFlex.KeyFlexFieldStru = keyFlexStru.ID LEFT JOIN\n                Base_ValueSetDef valueSet ON valueSet.ID = keyFlex.ValueSetDef LEFT JOIN\n                Base_DefineValue defineValue3 ON defineValue3.ValueSetDef = valueSet.ID AND \n                defineValue3.Code = category.Code /*\u672b\u7ea7\u5206\u7c7b*/ LEFT JOIN\n                Base_DefineValue_Trl defineValue3Trl ON defineValue3.ID = defineValue3Trl.ID AND \n                defineValue3Trl.SysMLFlag = 'zh-CN' /*\u672b\u7ea7\u5206\u7c7b*/ LEFT JOIN\n                Base_DefineValue defineValue2 ON defineValue3.ParentNode = defineValue2.ID /*\u4e8c\u7ea7\u5206\u7c7b*/ LEFT JOIN\n                Base_DefineValue_Trl defineValue2Trl ON defineValue3.ParentNode = defineValue2Trl.ID AND \n                defineValue2.ID = defineValue2Trl.ID AND defineValue2Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_DefineValue defineValue1 ON defineValue2.ParentNode = defineValue1.ID /*\u4e8c\u7ea7\u5206\u7c7b*/ LEFT JOIN\n                Base_DefineValue_Trl defineValue1Trl ON defineValue2.ParentNode = defineValue1Trl.ID AND \n                defineValue1.ID = defineValue1Trl.ID AND defineValue1Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_ValueSetDef valueSet4 ON valueSet4.Code = 'Z033' /*\u54c1\u724c*/ LEFT JOIN\n                Base_DefineValue defineValue4 ON valueSet4.ID = defineValue4.ValueSetDef AND \n                defineValue4.Code = i.DescFlexField_PrivateDescSeg8 LEFT JOIN\n                Base_DefineValue_Trl defineValue4Trl ON defineValue4.ID = defineValue4Trl.ID AND \n                defineValue4Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_ValueSetDef valueSet5 ON valueSet5.Code = 'Z044' /*SPU\u5206\u7c7b\uff08\u539f\u4ef7\u683c\u5206\u7c7b\u4e2d\u7c7b\uff09*/ LEFT JOIN\n                Base_DefineValue defineValue5 ON valueSet5.ID = defineValue5.ValueSetDef AND \n                defineValue5.Code = i.DescFlexField_PrivateDescSeg10 LEFT JOIN\n                Base_DefineValue_Trl defineValue5Trl ON defineValue5.ID = defineValue5Trl.ID AND \n                defineValue5Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_ValueSetDef valueSet6 ON valueSet6.Code = 'Z045' /*\u6e20\u9053*/ LEFT JOIN\n                Base_DefineValue defineValue6 ON valueSet6.ID = defineValue6.ValueSetDef AND \n                defineValue6.Code = i.DescFlexField_PrivateDescSeg11 LEFT JOIN\n                Base_DefineValue_Trl defineValue6Trl ON defineValue6.ID = defineValue6Trl.ID AND \n                defineValue6Trl.SysMLFlag = 'zh-CN' LEFT JOIN\n                Base_UOM priceUOM ON priceUOM.ID = i.PriceUOM LEFT JOIN\n                Base_UOM_Trl priceUOMTrl ON priceUOM.ID = priceUOMTrl.ID AND priceUOMTrl.SysMLFlag = 'zh-CN'\n\t\t\t\tLEFT JOIN\n                Base_UOM weightUOM ON weightUOM.ID = i.WeightUom LEFT JOIN\n                Base_UOM_Trl weightUOMTrl ON weightUOM.ID = weightUOMTrl.ID AND weightUOMTrl.SysMLFlag = 'zh-CN'\n\t\t\t\tLEFT JOIN\n                Base_UOM bulkUOM ON bulkUOM.ID = i.BulkUom LEFT JOIN\n                Base_UOM_Trl bulkUOMTrl ON bulkUOM.ID = bulkUOMTrl.ID AND bulkUOMTrl.SysMLFlag = 'zh-CN'\nWHERE   b.Code = '001' AND IsSalesEnable = 1 AND i.ModifiedOn > i.CreatedOn AND i.ModifiedOn >= ? ORDER BY i.CreatedOn asc", this.getLocalDateTime(flagSettingInfo));
            logger.error(this.SYS_CODE + ".sendUpdateBusGoods.queryU9", (Object)"\u67e5\u8be2U9\u5ba2\u6237\u6570\u636e\u7ed3\u675f");
            logger.error(this.SYS_CODE + ".sendUpdateBusGoods.customerListFromU9.size", (Object)rsResourceGoodsListFromU9.size());
            if (ListUtil.isEmpty(rsResourceGoodsListFromU9)) {
                logger.error(this.SYS_CODE + ".sendInitailCustomerAndAdd.queryU9", (Object)"\u6ca1\u6709\u4fee\u6539\u7684\u5546\u54c1\u4fe1\u606f");
                return "\u6ca1\u6709\u4fee\u6539\u7684\u5546\u54c1\u4fe1\u606f";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".sendUpdateBusGoods.view", (Object)"\u4fee\u6539\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898");
            return "\u4fee\u6539\u67e5\u8be2\u89c6\u56fe\u6709\u95ee\u9898";
        }
        String modifiedon = "";
        logger.error(this.SYS_CODE + ".sendUpdateBusGoods.modifiedon", (Object)modifiedon);
        for (final ResourceGoodsU9 resourceGoodsU9 : rsResourceGoodsListFromU9) {
            RsResourceGoodsReDomain goodsDomain = null;
            try {
                modifiedon = resourceGoodsU9.getModifiedOn();
                ArrayList<ResourceGoodsU9> resourceGoodsU9s = new ArrayList<ResourceGoodsU9>(){
                    {
                        this.add(resourceGoodsU9);
                    }
                };
                RsResourceGoodsDomain rsResourceGoodsDomain = this.buildrResourceGoodsDomainForModify((List<ResourceGoodsU9>)resourceGoodsU9s, tenantCode, null);
                goodsDomain = this.checkResourceGoods(rsResourceGoodsDomain);
                if (goodsDomain == null) {
                    logger.error(this.SYS_CODE + ".sendUpdateBusGoods.modifiedon.null=goodsDomain", (Object)modifiedon);
                    logger.error(this.SYS_CODE + ".sendUpdateBusGoods.lastModi.null=goodsDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)goodsDomain));
                    this.updateFalgSettingInFoByKey(internalRouter, "resourceGoodsUpdateBeginTime", tenantCode, modifiedon, flagSettingId);
                    logger.error(this.SYS_CODE + ".sendUpdateBusGoods.goodsDomain.null=goodsDomain", (Object)("\u672a\u63d2\u5165resourceGoodsU9:" + JsonUtil.buildNormalBinder().toJson((Object)resourceGoodsU9) + ",\u4e0d\u80fd\u505a\u4fee\u6539"));
                    return "\u672a\u63d2\u5165goodsDomain: " + goodsDomain.getGoodsEocode() + ",\u4e0d\u80fd\u505a\u4fee\u6539";
                }
                String channelNames = "\u7231\u5eb7\u6c11\u7528,\u7231\u5eb7\u5de5\u7a0b,\u7231\u5eb7\u6696\u901a";
                List<DisDgoods> disDgoods = this.queryDisGoodsPage(tenantCode, internalRouter, channelNames);
                if (null == disDgoods) {
                    return this.makeErrorReturn("disDgoods is null,\u8bf7\u521d\u59cb\u5316disDgoods\u4fe1\u606f");
                }
                this.buildRsSkuDomainListForModify(resourceGoodsU9, rsResourceGoodsDomain, tenantCode, disDgoods);
                this.compareSkuInformationAndModify(internalRouter, tenantCode, rsResourceGoodsDomain, resourceGoodsU9);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".sendUpdateBusGoods.modifiedon.e", (Object)modifiedon);
                logger.error(this.SYS_CODE + ".sendUpdateBusGoods.lastModifyUse.e", (Object)JsonUtil.buildNormalBinder().toJson((Object)resourceGoodsU9));
                logger.error(this.SYS_CODE + ".sendUpdateBusGoods.customer.e", (Object)("\u6bd4\u8f83\u51fa\u9519:" + JsonUtil.buildNormalBinder().toJson((Object)goodsDomain)));
                this.updateFalgSettingInFoByKey(internalRouter, "resourceGoodsUpdateBeginTime", tenantCode, modifiedon, flagSettingId);
                return "\u6bd4\u8f83\u51fa\u9519: " + goodsDomain.getGoodsEocode();
            }
        }
        LocalDateTime localDateTime = this.getLocalDateTime(modifiedon);
        LocalDateTime localDateTimePlus1N = localDateTime.plusNanos(1L);
        logger.error(this.SYS_CODE + ".sendUpdateBusGoods.localDateTime", (Object)localDateTime);
        logger.error(this.SYS_CODE + ".sendUpdateBusGoods.localDateTimePlus1N", (Object)localDateTimePlus1N);
        this.updateFalgSettingInFoByKey(internalRouter, "resourceGoodsUpdateBeginTime", tenantCode, this.getStringlocalDateTimeBy(localDateTimePlus1N), flagSettingId);
        return this.makeSuccessReturn("SUCCESS");
    }

    private void compareSkuInformationAndModify(InternalRouter internalRouter, String tenantCode, RsResourceGoodsDomain rsResourceGoodsDomain, ResourceGoodsU9 resourceGoodsU9) throws Exception {
        this.compareRsResourceGoodsInformationAndModify(rsResourceGoodsDomain, tenantCode, internalRouter);
        this.compareChannelSkuAndModify(rsResourceGoodsDomain, internalRouter, tenantCode);
        this.compareSkuStateAndModify(internalRouter, rsResourceGoodsDomain, resourceGoodsU9);
    }

    private void compareSkuStateAndModify(InternalRouter internalRouter, RsResourceGoodsDomain rsResourceGoodsDomain, ResourceGoodsU9 resourceGoodsU9) throws Exception {
        RsSkuDomain rsSkuDomainBuild = rsResourceGoodsDomain.getRsSkuDomainList().get(0);
        if (this.checkSkuPriceCateGoryAndModify(internalRouter, rsResourceGoodsDomain, rsSkuDomainBuild)) {
            return;
        }
        HashMap<String, Object> skuMap1 = new HashMap<String, Object>();
        skuMap1.put("skuEocode", rsSkuDomainBuild.getSkuEocode());
        skuMap1.put("tenantCode", rsSkuDomainBuild.getTenantCode());
        RsSkuReDomain oldRsSkuReDomain = this.querySkuPage(skuMap1);
        Boolean effective_isEffective = resourceGoodsU9.getEffective_IsEffective();
        Integer oldDataOpbillstate = oldRsSkuReDomain.getDataOpbillstate();
        String goodsSp = oldRsSkuReDomain.getGoodsSp();
        BeanUtils.copyAllPropertysNotNull((Object)oldRsSkuReDomain, (Object)rsSkuDomainBuild);
        this.queryRsGoodsFileForSkuAndSet(oldRsSkuReDomain, internalRouter);
        if (!effective_isEffective.booleanValue()) {
            this.updateRsSkuDomainNew(oldRsSkuReDomain);
            if (null != oldDataOpbillstate && oldDataOpbillstate == 1 && null != oldRsSkuReDomain.getDataState() && oldRsSkuReDomain.getDataState() == 2) {
                this.sendUpdateSoldOutBatchSku(oldRsSkuReDomain);
            }
        } else {
            this.updateRsSkuDomainNew(oldRsSkuReDomain);
        }
    }

    private boolean checkSkuPriceCateGoryAndModify(InternalRouter internalRouter, final RsResourceGoodsDomain rsResourceGoodsDomain, RsSkuDomain rsSkuDomainBuild) throws Exception {
        final String skuRemark = rsSkuDomainBuild.getSkuRemark();
        HashMap<String, Object> classTreeMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
                this.put("classtreeEocode", skuRemark);
            }
        };
        QueryResult<RsClasstreeDomain> rsClasstreeDomainQueryResult = this.queryRsClasstreePage((Map<String, Object>)classTreeMap);
        if (null == rsClasstreeDomainQueryResult || ListUtil.isEmpty((Collection)rsClasstreeDomainQueryResult.getList())) {
            return true;
        }
        RsClasstreeDomain rsClasstreeDomain = (RsClasstreeDomain)rsClasstreeDomainQueryResult.getList().get(0);
        if (!rsClasstreeDomain.getClasstreeName().equals(rsSkuDomainBuild.getGoodsWeightstr())) {
            rsClasstreeDomain.setClasstreeName(rsSkuDomainBuild.getGoodsWeightstr());
            this.updateRsClassTree(rsClasstreeDomain, internalRouter);
        }
        return false;
    }

    private void queryRsGoodsFileForSkuAndSet(final RsSkuReDomain oldRsSkuReDomain, InternalRouter internalRouter) {
        final HashMap<String, Object> goodsFileMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", oldRsSkuReDomain.getTenantCode());
                this.put("skuCode", oldRsSkuReDomain.getSkuCode());
            }
        };
        HashMap<String, Object> goodsFileParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)goodsFileMap));
            }
        };
        logger.error(this.SYS_CODE + ".queryRsGoodsFileForSkuAndSet.goodsFileParamMap", (Object)"\u67e5\u8be2rsGoodsFile\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".queryRsGoodsFileForSkuAndSet.goodsFileParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)goodsFileParamMap));
        String goodsFileStr = (String)internalRouter.inInvoke("dis.dgoods.queryDgoodsPage", (Map)goodsFileParamMap);
        logger.error(this.SYS_CODE + ".queryRsGoodsFileForSkuAndSet.disGoodsListStr", (Object)"\u67e5\u8be2rsGoodsFile\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(goodsFileStr, SupQueryResult.class);
        logger.error(this.SYS_CODE + ".queryRsGoodsFileForSkuAndSet.supQueryResult", (Object)JsonUtil.buildNormalBinder().toJson((Object)supQueryResult));
        if (null == supQueryResult) {
            return;
        }
        List goodsFileList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), RsGoodsFile.class);
        logger.error(this.SYS_CODE + ".queryRsGoodsFileForSkuAndSet.goodsFileList", (Object)JsonUtil.buildNormalBinder().toJson((Object)goodsFileList));
        if (null == goodsFileList || ListUtil.isEmpty((Collection)goodsFileList)) {
            return;
        }
        ArrayList<RsGoodsFileDomain> rsGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
        for (RsGoodsFile rsGoodsFile : goodsFileList) {
            RsGoodsFileDomain rsGoodsFileDomain = new RsGoodsFileDomain();
            try {
                BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain, (Object)rsGoodsFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            rsGoodsFileDomainList.add(rsGoodsFileDomain);
        }
        oldRsSkuReDomain.setRsGoodsFileDomainList(rsGoodsFileDomainList);
    }

    private void compareChannelSkuAndModify(RsResourceGoodsDomain rsResourceGoodsDomain, InternalRouter internalRouter, String tenantCode) throws Exception {
        RsSkuDomain newSkuDomain = rsResourceGoodsDomain.getRsSkuDomainList().get(0);
        String channelNames = "\u7231\u5eb7\u6c11\u7528,\u7231\u5eb7\u5de5\u7a0b,\u7231\u5eb7\u6696\u901a";
        List<DisDgoods> disDgoods = this.queryDisGoodsPage(tenantCode, internalRouter, channelNames);
        DisDgoods minYongDisGoods = (DisDgoods)disDgoods.stream().filter(item -> item.getChannelName().equals(MING_YONG_CHANNEL_NAME)).collect(Collectors.toList()).get(0);
        DisDgoods gongChnegDisGoods = (DisDgoods)disDgoods.stream().filter(item -> item.getChannelName().equals(GONG_CHENG_CHANNEL_NAME)).collect(Collectors.toList()).get(0);
        DisDgoods nuanTongDisGoods = (DisDgoods)disDgoods.stream().filter(item -> item.getChannelName().equals(NUAN_TONAG_CHANNEL_NAME)).collect(Collectors.toList()).get(0);
        String minYongDgoodCode = minYongDisGoods.getDgoodsCode();
        String gongChnegDgoodCode = gongChnegDisGoods.getDgoodsCode();
        String nuanTongDgoodCode = nuanTongDisGoods.getDgoodsCode();
        String skuEoCode = newSkuDomain.getSkuEocode();
        List<DisDgoodsScopelist> oldDisDgoodsScopelists = this.queryDgoodsScopelistPageBySkuEocode(tenantCode, internalRouter, skuEoCode);
        boolean oldMinYongFlag = oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(minYongDgoodCode)).collect(Collectors.toList()).size() > 0;
        boolean oldGongChengFlag = oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(gongChnegDgoodCode)).collect(Collectors.toList()).size() > 0;
        boolean oldNuanTongFlag = oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(nuanTongDgoodCode)).collect(Collectors.toList()).size() > 0;
        List<DisDgoodsScopelistDomain> newDisDgoodsScopelistDomains = rsResourceGoodsDomain.getDisDgoodsScopelistDomains();
        boolean newMinYongFlag = newDisDgoodsScopelistDomains.stream().filter(item -> item.getDgoodsCode().equals(minYongDgoodCode)).collect(Collectors.toList()).size() > 0;
        boolean newGongChengFlag = newDisDgoodsScopelistDomains.stream().filter(item -> item.getDgoodsCode().equals(gongChnegDgoodCode)).collect(Collectors.toList()).size() > 0;
        boolean newNuanTongFlag = newDisDgoodsScopelistDomains.stream().filter(item -> item.getDgoodsCode().equals(nuanTongDgoodCode)).collect(Collectors.toList()).size() > 0;
        DisDgoodsScopelist oldMinYongDisDgoodsScopelist = (DisDgoodsScopelist)oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(minYongDgoodCode)).collect(Collectors.toList()).get(0);
        DisDgoodsScopelistDomain newMinYongDisDgoodsScopelist = (DisDgoodsScopelistDomain)newDisDgoodsScopelistDomains.stream().filter(item -> item.getDgoodsCode().equals(minYongDgoodCode)).collect(Collectors.toList()).get(0);
        DisDgoodsScopelist oldGongChneDisDgoodsScopelist = (DisDgoodsScopelist)oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(gongChnegDgoodCode)).collect(Collectors.toList()).get(0);
        DisDgoodsScopelistDomain newGongChneDisDgoodsScopelist = (DisDgoodsScopelistDomain)newDisDgoodsScopelistDomains.stream().filter(item -> item.getDgoodsCode().equals(gongChnegDgoodCode)).collect(Collectors.toList()).get(0);
        DisDgoodsScopelist oldNuanTongDisDgoodsScopelist = (DisDgoodsScopelist)oldDisDgoodsScopelists.stream().filter(item -> item.getDgoodsCode().equals(nuanTongDgoodCode)).collect(Collectors.toList()).get(0);
        DisDgoodsScopelistDomain newNuanTongDisDgoodsScopelist = (DisDgoodsScopelistDomain)newDisDgoodsScopelistDomains.stream().filter(item -> item.getDgoodsCode().equals(nuanTongDgoodCode)).collect(Collectors.toList()).get(0);
        this.compareDisDgoodsScopelist(internalRouter, oldMinYongFlag, newMinYongFlag, oldMinYongDisDgoodsScopelist, newMinYongDisDgoodsScopelist);
        this.compareDisDgoodsScopelist(internalRouter, oldGongChengFlag, newGongChengFlag, oldGongChneDisDgoodsScopelist, newGongChneDisDgoodsScopelist);
        this.compareDisDgoodsScopelist(internalRouter, oldNuanTongFlag, newNuanTongFlag, oldNuanTongDisDgoodsScopelist, newNuanTongDisDgoodsScopelist);
    }

    private void compareDisDgoodsScopelist(InternalRouter internalRouter, boolean oldFlag, boolean newFlag, DisDgoodsScopelist oldDisDgoodsScopelist, DisDgoodsScopelistDomain newDisDgoodsScopelist) throws Exception {
        if (Boolean.compare(oldFlag, newFlag) != 0) {
            if (oldFlag) {
                this.deletDgoodsScopeListByScoplistId(internalRouter, oldDisDgoodsScopelist.getDgoodsScopelistId());
            } else {
                this.saveDgoodsScopeList(internalRouter, newDisDgoodsScopelist);
            }
        } else {
            BeanUtils.copyAllPropertysNotNull((Object)oldDisDgoodsScopelist, (Object)newDisDgoodsScopelist);
            this.updateDgoodsScopeList(internalRouter, oldDisDgoodsScopelist);
        }
    }

    private void updateDgoodsScopeList(InternalRouter internalRouter, final DisDgoodsScopelist oldDisDgoodsScopelist) throws Exception {
        HashMap<String, Object> saveDdFlagParamMap = new HashMap<String, Object>(){
            {
                this.put("disDgoodsScopelistDomain", JsonUtil.buildNormalBinder().toJson((Object)oldDisDgoodsScopelist));
            }
        };
        logger.error(this.SYS_CODE + ".updateDgoodsScopeList", (Object)JsonUtil.buildNormalBinder().toJson((Object)saveDdFlagParamMap));
        logger.error(this.SYS_CODE + ".updateDgoodsScopeList", (Object)"\u4fee\u6539disDgoodsScopelistDomain\u5f00\u59cb");
        internalRouter.inInvoke("is.dgoods.updateDgoodsScopelist", (Map)saveDdFlagParamMap);
        logger.error(this.SYS_CODE + ".updateDgoodsScopeList", (Object)"\u4fee\u6539disDgoodsScopelistDomain\u7ed3\u675f");
    }

    private void saveDgoodsScopeList(InternalRouter internalRouter, final DisDgoodsScopelistDomain disDgoodsScopelistDomain) throws Exception {
        HashMap<String, Object> saveDdFlagParamMap = new HashMap<String, Object>(){
            {
                this.put("disDgoodsScopelistDomain", JsonUtil.buildNormalBinder().toJson((Object)disDgoodsScopelistDomain));
            }
        };
        logger.error(this.SYS_CODE + ".saveDgoodsScopeList", (Object)JsonUtil.buildNormalBinder().toJson((Object)saveDdFlagParamMap));
        logger.error(this.SYS_CODE + ".saveDgoodsScopeList", (Object)"\u4fdd\u5b58disDgoodsScopelistDomain\u5f00\u59cb");
        internalRouter.inInvoke("dis.dgoods.saveDgoodsScopelist", (Map)saveDdFlagParamMap);
        logger.error(this.SYS_CODE + ".saveDgoodsScopeList", (Object)"\u4fdd\u5b58disDgoodsScopelistDomain\u7ed3\u675f");
    }

    private void deletDgoodsScopeListByScoplistId(InternalRouter internalRouter, final Integer dgoodsScopelistId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("dgoodsScopelistId", dgoodsScopelistId);
            }
        };
        internalRouter.inInvoke("dis.dgoods.deleteDgoodsScopelist", (Map)map);
    }

    private void compareRsResourceGoodsInformationAndModify(final RsResourceGoodsDomain newRsResourceGoodsDomain, final String tenantCode, InternalRouter internalRouter) throws Exception {
        HashMap<String, Object> goodsMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", tenantCode);
                this.put("goodsEocode", newRsResourceGoodsDomain.getGoodsEocode());
            }
        };
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsReDomainQueryResult = this.queryRsResourceGoodsPage((Map<String, Object>)goodsMap);
        logger.error(this.SYS_CODE + ".compareRsResourceGoodsInformationAndModify.rsResourceGoodsReDomainQueryResult", (Object)JsonUtil.buildNormalBinder().toJson(rsResourceGoodsReDomainQueryResult));
        if (null == rsResourceGoodsReDomainQueryResult || null == rsResourceGoodsReDomainQueryResult.getList() || ListUtil.isEmpty((Collection)rsResourceGoodsReDomainQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".compareRsResourceGoodsInformationAndModify.rsResourceGoodsReDomainQueryResult.null", (Object)JsonUtil.buildNormalBinder().toJson(rsResourceGoodsReDomainQueryResult));
            return;
        }
        RsResourceGoodsReDomain oldRsResourceGoodsReDomain = (RsResourceGoodsReDomain)rsResourceGoodsReDomainQueryResult.getList().get(0);
        try {
            BeanUtils.copyAllPropertysNotNull((Object)oldRsResourceGoodsReDomain, (Object)newRsResourceGoodsDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        oldRsResourceGoodsReDomain.setRsSkuDomainList(null);
        oldRsResourceGoodsReDomain.setIsDel(true);
        logger.error(this.SYS_CODE + ".compareRsResourceGoodsInformationAndModify.LastOldRsResourceGoodsReDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)oldRsResourceGoodsReDomain));
        this.checkClassTreeAndGoodsClassChanngeAndModify(oldRsResourceGoodsReDomain, tenantCode, internalRouter);
        this.buildSpecValueListForSkuModify(oldRsResourceGoodsReDomain, newRsResourceGoodsDomain);
        this.updateEsResourceGoodsDomainU9(oldRsResourceGoodsReDomain);
    }

    private void buildRsSkuDomainListForModify(ResourceGoodsU9 item, RsResourceGoodsDomain rsResourceGoodsDomain, String tenantCode, List<DisDgoods> newdisDgoods) {
        ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        rsSkuDomain.setTenantCode(tenantCode);
        rsSkuDomain.setGoodsEocode(rsResourceGoodsDomain.getGoodsEocode());
        rsSkuDomain.setSkuEocode(item.getItemCode());
        rsSkuDomain.setPricesetNprice(new BigDecimal("9999999"));
        rsSkuDomain.setGoodsNum(new BigDecimal("999999"));
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)rsResourceGoodsDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String skuName = item.getSpecs();
        if (StringUtils.isNotBlank((String)item.getPrv12Name())) {
            skuName = skuName + "/" + item.getPrv12Name();
        }
        if (StringUtils.isNotBlank((String)item.getPrv16Name())) {
            skuName = skuName + "/" + item.getPrv16Name();
        }
        rsSkuDomain.setSkuNo(item.getItemCode());
        rsSkuDomain.setSkuName(skuName);
        rsSkuDomain.setGoodsShowname(item.getItemName());
        rsSkuDomain.setClasstreeCode(item.getPrv18Code());
        rsSkuDomain.setClasstreeName(item.getPrv18Name());
        rsSkuDomain.setPntreeCode(item.getPrv18Code());
        rsSkuDomain.setPntreeName(item.getPrv18Name());
        rsSkuDomain.setPartsnameNumunit(item.getPriceUOMName());
        rsSkuDomain.setSkuRemark(item.getPriceCategoryCode());
        rsSkuDomain.setGoodsWeightstr(item.getPriceCategoryName());
        if (StringUtils.isNotBlank((String)item.getWeight()) && StringUtils.isNotBlank((String)item.getWeightUOMName())) {
            rsSkuDomain.setPartsnameWeightunit(item.getWeight() + " " + item.getWeightUOMName());
        }
        if (StringUtils.isNotBlank((String)item.getItemBulk()) && StringUtils.isNotBlank((String)item.getBulkUOMName())) {
            rsSkuDomain.setPartsnameNumunit1(item.getItemBulk() + " " + item.getBulkUOMName());
        }
        if (StringUtils.isNotBlank((String)item.getPrv26Name()) && StringUtils.isNotBlank((String)item.getPriceUOMName()) && StringUtils.isNotBlank((String)item.getPrv14Name())) {
            rsSkuDomain.setPartsnameNumunit(item.getPrv26Name() + item.getPriceUOMName() + " / " + item.getPrv14Name());
        }
        if (StringUtils.isNotBlank((String)item.getPrv27Name()) && StringUtils.isNotBlank((String)item.getPriceUOMName()) && StringUtils.isNotBlank((String)item.getPrv24Name())) {
            rsSkuDomain.setSkuBarcode(item.getPrv27Name() + item.getPriceUOMName() + " / " + item.getPrv24Name());
        }
        if (StringUtils.isNotBlank((String)item.getPrv28Name()) && StringUtils.isNotBlank((String)item.getPriceUOMName()) && StringUtils.isNotBlank((String)item.getPrv25Name())) {
            rsSkuDomain.setGoodsUnitstr(item.getPrv28Name() + item.getPriceUOMName() + " / " + item.getPrv25Name());
        }
        if (!item.getEffective_IsEffective().booleanValue()) {
            rsSkuDomain.setGoodsSale(1);
        } else {
            rsSkuDomain.setGoodsSale(0);
        }
        this.buildScopList(rsResourceGoodsDomain, rsSkuDomain, item.getPrv11Name(), newdisDgoods, rsSkuDomain.getGoodsShowname(), rsSkuDomain.getSkuName());
        rsSkuDomainList.add(rsSkuDomain);
        rsResourceGoodsDomain.setRsSkuDomainList(rsSkuDomainList);
    }

    private RsResourceGoodsDomain buildrResourceGoodsDomainForModify(List<ResourceGoodsU9> skus, String tenantCode, Object o) {
        List specList;
        List innerColorSpec;
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        ResourceGoodsU9 item = skus.get(0);
        rsResourceGoodsDomain.setDisDgoodsScopelistDomains(new ArrayList<DisDgoodsScopelistDomain>());
        rsResourceGoodsDomain.setTenantCode(tenantCode);
        rsResourceGoodsDomain.setGoodsEocode(item.getPrv10Code());
        rsResourceGoodsDomain.setGoodsNo(this.createUUIDString());
        rsResourceGoodsDomain.setGoodsName(item.getPrv10Name());
        rsResourceGoodsDomain.setBrandCode(item.getPrv8Code());
        rsResourceGoodsDomain.setBrandName(item.getPrv8Name());
        rsResourceGoodsDomain.setPntreeCode(item.getFirstCategoryCode());
        rsResourceGoodsDomain.setPntreeCode(item.getFirstCategoryName());
        rsResourceGoodsDomain.setClasstreeCode(item.getPrv18Code());
        rsResourceGoodsDomain.setClasstreeName(item.getPrv18Name());
        rsResourceGoodsDomain.setOneClasstreeCode(item.getFirstCategoryCode());
        rsResourceGoodsDomain.setOneClasstreeName(item.getFirstCategoryName());
        rsResourceGoodsDomain.setSecondClasstreeCode(item.getSecondCategoryCode());
        rsResourceGoodsDomain.setSecondClasstreeName(item.getSecondCategoryName());
        ArrayList<RsSpecDomain> rsSpecDomainList = new ArrayList<RsSpecDomain>();
        List colorSpec = skus.stream().map(ResourceGoodsU9::getPrv12Name).distinct().collect(Collectors.toList());
        if (null != colorSpec && colorSpec.size() != 0) {
            RsSpecDomain rsSpecDomain = new RsSpecDomain();
            rsSpecDomain.setSpecName("\u989c\u8272");
            rsSpecDomainList.add(rsSpecDomain);
            ArrayList<RsSpecOptionDomain> specOptionDomainList = new ArrayList<RsSpecOptionDomain>();
            for (Object specName : colorSpec) {
                RsSpecOptionDomain rsSpecOptionDomain = new RsSpecOptionDomain();
                specOptionDomainList.add(rsSpecOptionDomain);
                rsSpecOptionDomain.setSpecOptionName((String)specName);
            }
            rsSpecDomain.setSpecOptionList(specOptionDomainList);
        }
        if (null != (innerColorSpec = skus.stream().map(ResourceGoodsU9::getPrv16Name).distinct().collect(Collectors.toList())) && innerColorSpec.size() != 0) {
            RsSpecDomain innerSsSpecDomain = new RsSpecDomain();
            innerSsSpecDomain.setSpecName("\u4e2d\u5185\u5c42\u989c\u8272");
            rsSpecDomainList.add(innerSsSpecDomain);
            ArrayList<RsSpecOptionDomain> specOptionDomainList = new ArrayList<RsSpecOptionDomain>();
            for (String specName : innerColorSpec) {
                RsSpecOptionDomain rsSpecOptionDomain = new RsSpecOptionDomain();
                specOptionDomainList.add(rsSpecOptionDomain);
                rsSpecOptionDomain.setSpecOptionName(specName);
            }
            innerSsSpecDomain.setSpecOptionList(specOptionDomainList);
        }
        if (null != (specList = skus.stream().filter(a -> StringUtils.isNotBlank((String)a.getSpecs())).map(ResourceGoodsU9::getSpecs).distinct().collect(Collectors.toList())) && specList.size() != 0) {
            RsSpecDomain specDomain = new RsSpecDomain();
            specDomain.setSpecName("\u578b\u53f7");
            rsSpecDomainList.add(specDomain);
            ArrayList<RsSpecOptionDomain> specOptionDomainList = new ArrayList<RsSpecOptionDomain>();
            for (String specName : specList) {
                RsSpecOptionDomain rsSpecOptionDomain = new RsSpecOptionDomain();
                specOptionDomainList.add(rsSpecOptionDomain);
                rsSpecOptionDomain.setSpecOptionName(specName);
            }
            specDomain.setSpecOptionList(specOptionDomainList);
        }
        rsResourceGoodsDomain.setRsSpecDomainList(rsSpecDomainList);
        this.makeSpec(rsResourceGoodsDomain);
        return rsResourceGoodsDomain;
    }

    private void checkClassTreeAndGoodsClassChanngeAndModify(RsResourceGoodsDomain rsResourceGoodsDomain, String tenantCode, InternalRouter internalRouter) throws Exception {
        this.checkClassTreeChangeAndModify(rsResourceGoodsDomain, tenantCode, internalRouter);
    }

    private void checkGoodsClassChangeAndModify(RsResourceGoodsDomain rsResourceGoodsDomain, final String tenantCode, InternalRouter internalRouter) throws Exception {
        RsGoodsClassDomain goodsClassDomain;
        RsGoodsClassDomain secondGoodsClassDomain;
        String classtreeShopcode;
        String secondClasstreeShopcode;
        final String oneClasstreeShopcode = rsResourceGoodsDomain.getOneClasstreeShopcode();
        HashMap<String, Object> goodsClassMap = new HashMap<String, Object>(secondClasstreeShopcode = rsResourceGoodsDomain.getSecondClasstreeShopcode(), classtreeShopcode = rsResourceGoodsDomain.getClasstreeShopcode()){
            final /* synthetic */ String val$secondClasstreeShopcode;
            final /* synthetic */ String val$classtreeShopcode;
            {
                this.val$secondClasstreeShopcode = string3;
                this.val$classtreeShopcode = string4;
                this.put("tenantCode", tenantCode);
                this.put("goodsClassEocode", oneClasstreeShopcode + "," + this.val$secondClasstreeShopcode + "," + this.val$classtreeShopcode);
            }
        };
        QueryResult<RsGoodsClassDomain> rsGoodsClassDomainQueryResult = this.queryRsGoodsClassPage((Map<String, Object>)goodsClassMap);
        if (null == rsGoodsClassDomainQueryResult || ListUtil.isEmpty((Collection)rsGoodsClassDomainQueryResult.getList()) || rsGoodsClassDomainQueryResult.getList().size() != 3) {
            logger.error(this.SYS_CODE + ".checkClassTreeAndGoodsClassChanngeAndModify", (Object)"\u4fee\u6539\u5206\u7c7b\u4fe1\u606f\u65f6\u5019\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u524d\u53f0\u5206\u7c7b!\u6570\u636e\u67e5\u8be2\u9519\u8bef!");
            throw new RuntimeException("\u4fee\u6539\u5206\u7c7b\u4fe1\u606f\u65f6\u5019\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u524d\u53f0\u5206\u7c7b!\u6570\u636e\u67e5\u8be2\u9519\u8bef!");
        }
        List goodsClassList = rsGoodsClassDomainQueryResult.getList();
        RsGoodsClassDomain oneRsGoodsClassDomain = (RsGoodsClassDomain)goodsClassList.stream().filter(item -> item.getGoodsClassParentcode().equals("-1")).collect(Collectors.toList()).get(0);
        if (!oneRsGoodsClassDomain.getGoodsClassName().equals(rsResourceGoodsDomain.getOneClasstreeShopname())) {
            oneRsGoodsClassDomain.setGoodsClassName(rsResourceGoodsDomain.getOneClasstreeShopname());
            this.updateRsGoodsClass(internalRouter, oneRsGoodsClassDomain);
        }
        if (!(secondGoodsClassDomain = (RsGoodsClassDomain)goodsClassList.stream().filter(item -> item.getGoodsClassParentcode().equals(oneRsGoodsClassDomain.getGoodsClassCode())).collect(Collectors.toList()).get(0)).getGoodsClassName().equals(rsResourceGoodsDomain.getSecondClasstreeShopname())) {
            secondGoodsClassDomain.setGoodsClassName(rsResourceGoodsDomain.getSecondClasstreeShopname());
            this.updateRsGoodsClass(internalRouter, secondGoodsClassDomain);
        }
        if (!(goodsClassDomain = (RsGoodsClassDomain)goodsClassList.stream().filter(item -> item.getGoodsClassParentcode().equals(secondGoodsClassDomain.getGoodsClassCode())).collect(Collectors.toList()).get(0)).getGoodsClassName().equals(rsResourceGoodsDomain.getClasstreeShopname())) {
            secondGoodsClassDomain.setGoodsClassName(rsResourceGoodsDomain.getClasstreeShopname());
            this.updateRsGoodsClass(internalRouter, goodsClassDomain);
        }
    }

    private void updateRsGoodsClass(InternalRouter internalRouter, final RsGoodsClassDomain rsGoodsClassDomain) throws Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(){
            {
                this.put("rsGoodsClassDomain", rsGoodsClassDomain);
            }
        };
        internalRouter.inInvoke("rs.goodsClass.updateGoodsClass", (Map)paramMap);
    }

    private void checkClassTreeChangeAndModify(RsResourceGoodsDomain rsResourceGoodsDomain, final String tenantCode, InternalRouter internalRouter) throws Exception {
        RsClasstreeDomain rsClasstreeDomain;
        RsClasstreeDomain secondRsClasstreeDomain;
        String classtreeCode;
        String secondClasstreeCode;
        final String oneClasstreeCode = rsResourceGoodsDomain.getOneClasstreeCode();
        HashMap<String, Object> classTreeMap = new HashMap<String, Object>(secondClasstreeCode = rsResourceGoodsDomain.getSecondClasstreeCode(), classtreeCode = rsResourceGoodsDomain.getClasstreeCode()){
            final /* synthetic */ String val$secondClasstreeCode;
            final /* synthetic */ String val$classtreeCode;
            {
                this.val$secondClasstreeCode = string3;
                this.val$classtreeCode = string4;
                this.put("tenantCode", tenantCode);
                this.put("classtreeEocode", oneClasstreeCode + "," + this.val$secondClasstreeCode + "," + this.val$classtreeCode);
            }
        };
        QueryResult<RsClasstreeDomain> rsClasstreeDomainQueryResult = this.queryRsClasstreePage((Map<String, Object>)classTreeMap);
        if (null == rsClasstreeDomainQueryResult || ListUtil.isEmpty((Collection)rsClasstreeDomainQueryResult.getList()) || rsClasstreeDomainQueryResult.getList().size() != 3) {
            logger.error(this.SYS_CODE + ".checkClassTreeChangeAndModify.checkClassTreeAndGoodsClassChanngeAndModify", (Object)"\u4fee\u6539\u5206\u7c7b\u4fe1\u606f\u65f6\u5019\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u540e\u53f0\u5206\u7c7b!\u6570\u636e\u67e5\u8be2\u9519\u8bef!");
            throw new RuntimeException("\u4fee\u6539\u5206\u7c7b\u4fe1\u606f\u65f6\u5019\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u540e\u53f0\u5206\u7c7b!\u6570\u636e\u67e5\u8be2\u9519\u8bef!");
        }
        List rsClassTreelist = rsClasstreeDomainQueryResult.getList();
        RsClasstreeDomain oneRsClasstree = (RsClasstreeDomain)rsClassTreelist.stream().filter(item -> item.getClasstreeParentcode().equals("-1")).collect(Collectors.toList()).get(0);
        if (!oneRsClasstree.getClasstreeName().equals(rsResourceGoodsDomain.getOneClasstreeName())) {
            oneRsClasstree.setClasstreeName(rsResourceGoodsDomain.getOneClasstreeName());
            this.updateRsClassTree(oneRsClasstree, internalRouter);
        }
        if (!(secondRsClasstreeDomain = (RsClasstreeDomain)rsClassTreelist.stream().filter(item -> item.getClasstreeParentcode().equals(oneRsClasstree.getClasstreeCode())).collect(Collectors.toList()).get(0)).getClasstreeName().equals(rsResourceGoodsDomain.getSecondClasstreeName())) {
            secondRsClasstreeDomain.setClasstreeName(rsResourceGoodsDomain.getSecondClasstreeName());
            this.updateRsClassTree(secondRsClasstreeDomain, internalRouter);
        }
        if (!(rsClasstreeDomain = (RsClasstreeDomain)rsClassTreelist.stream().filter(item -> item.getClasstreeParentcode().equals(secondRsClasstreeDomain.getClasstreeCode())).collect(Collectors.toList()).get(0)).getClasstreeName().equals(rsResourceGoodsDomain.getClasstreeName())) {
            rsClasstreeDomain.setClasstreeName(rsResourceGoodsDomain.getClasstreeName());
            this.updateRsClassTree(rsClasstreeDomain, internalRouter);
        }
    }

    private void updateRsClassTree(final RsClasstreeDomain rsClasstree, InternalRouter internalRouter) throws Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(){
            {
                this.put("rsClasstreeDomain", rsClasstree);
            }
        };
        internalRouter.inInvoke("rs.rsClasstree.updateClasstree", (Map)paramMap);
    }

    private String getStringlocalDateTimeBy(LocalDateTime time) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(time);
    }

    private void updateLogState(InternalRouter internalRouter, final LogErrorLog logErrorLog, final Integer oldDataState, final Integer dataState) {
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("logErrorId", logErrorLog.getLogErrorId());
                this.put("dataState", dataState);
                this.put("oldDataState", oldDataState);
            }
        };
        internalRouter.inInvoke("log.log.updateErrorLogState", (Map)map);
    }

    private void saveResourceGoods(List<ResourceGoodsU9> skus, String tenantCode, List<GoodsCategory> goodsCategoryList, InternalRouter internalRouter) {
        String channelNames = "\u7231\u5eb7\u6c11\u7528,\u7231\u5eb7\u5de5\u7a0b,\u7231\u5eb7\u6696\u901a";
        List<DisDgoods> disDgoods = this.queryDisGoodsPage(tenantCode, internalRouter, channelNames);
        RsResourceGoodsDomain rsResourceGoodsDomain = this.buildrResourceGoodsDomain(skus, tenantCode, goodsCategoryList);
        this.buildRsSkuDomainList(skus, rsResourceGoodsDomain, tenantCode, disDgoods);
        this.sendSaveExcelBusGoods(rsResourceGoodsDomain);
    }

    private List<RsSkuDomain> buildRsSkuDomainList(List<ResourceGoodsU9> skus, RsResourceGoodsDomain rsResourceGoodsDomain, String tenantCode, List<DisDgoods> disDgoods) {
        ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
        for (ResourceGoodsU9 item : skus) {
            RsSkuDomain rsSkuDomain = new RsSkuDomain();
            rsSkuDomain.setPricesetNprice(new BigDecimal("9999999"));
            rsSkuDomain.setGoodsNum(new BigDecimal("999999"));
            rsSkuDomain.setTenantCode(tenantCode);
            rsSkuDomain.setGoodsEocode(rsResourceGoodsDomain.getGoodsEocode());
            rsSkuDomain.setSkuEocode(item.getItemCode());
            try {
                BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)rsResourceGoodsDomain);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String skuName = item.getSpecs();
            if (StringUtils.isNotBlank((String)item.getPrv12Name())) {
                skuName = skuName + "/" + item.getPrv12Name();
            }
            if (StringUtils.isNotBlank((String)item.getPrv16Name())) {
                skuName = skuName + "/" + item.getPrv16Name();
            }
            rsSkuDomain.setSkuNo(item.getItemCode());
            rsSkuDomain.setSkuName(skuName);
            rsSkuDomain.setGoodsShowname(item.getItemName());
            rsSkuDomain.setClasstreeCode(item.getPrv18Code());
            rsSkuDomain.setClasstreeName(item.getPrv18Name());
            rsSkuDomain.setPntreeCode(item.getPrv18Code());
            if (StringUtils.isNotBlank((String)item.getWeight()) && StringUtils.isNotBlank((String)item.getWeightUOMName())) {
                rsSkuDomain.setPartsnameWeightunit(item.getWeight() + " " + item.getWeightUOMName());
            }
            rsSkuDomain.setPntreeName(item.getPrv18Name());
            rsSkuDomain.setPartsnameNumunit(item.getPriceUOMName());
            if (StringUtils.isNotBlank((String)item.getItemBulk()) && StringUtils.isNotBlank((String)item.getBulkUOMName())) {
                rsSkuDomain.setPartsnameNumunit1(item.getItemBulk() + " " + item.getBulkUOMName());
            }
            if (StringUtils.isNotBlank((String)item.getPrv26Name()) && StringUtils.isNotBlank((String)item.getPriceUOMName()) && StringUtils.isNotBlank((String)item.getPrv14Name())) {
                rsSkuDomain.setPartsnameNumunit(item.getPrv26Name() + item.getPriceUOMName() + " / " + item.getPrv14Name());
            }
            if (StringUtils.isNotBlank((String)item.getPrv27Name()) && StringUtils.isNotBlank((String)item.getPriceUOMName()) && StringUtils.isNotBlank((String)item.getPrv24Name())) {
                rsSkuDomain.setSkuBarcode(item.getPrv27Name() + item.getPriceUOMName() + " / " + item.getPrv24Name());
            }
            if (StringUtils.isNotBlank((String)item.getPrv28Name()) && StringUtils.isNotBlank((String)item.getPriceUOMName()) && StringUtils.isNotBlank((String)item.getPrv25Name())) {
                rsSkuDomain.setGoodsUnitstr(item.getPrv28Name() + item.getPriceUOMName() + " / " + item.getPrv25Name());
            }
            rsSkuDomain.setSkuRemark(item.getPriceCategoryCode());
            rsSkuDomain.setGoodsWeightstr(item.getPriceCategoryName());
            if (!item.getEffective_IsEffective().booleanValue()) {
                rsSkuDomain.setGoodsSale(1);
            } else {
                rsSkuDomain.setGoodsSale(0);
            }
            rsSkuDomain.setGoodsNum(new BigDecimal("999"));
            rsSkuDomain.setGoodsSupplynum(new BigDecimal("999"));
            this.buildScopList(rsResourceGoodsDomain, rsSkuDomain, item.getPrv11Name(), disDgoods, rsSkuDomain.getGoodsShowname(), rsSkuDomain.getSkuName());
            rsSkuDomainList.add(rsSkuDomain);
        }
        rsResourceGoodsDomain.setRsSkuDomainList(rsSkuDomainList);
        return rsSkuDomainList;
    }

    private void buildScopList(RsResourceGoodsDomain rsResourceGoodsDomain, RsSkuDomain rsSkuDomain, String prv11Name, List<DisDgoods> disDgoodsList, String goodsShowname, String skuName) {
        String[] split;
        ArrayList<DisDgoodsScopelistDomain> disDgoodsScopelistDomains = new ArrayList<DisDgoodsScopelistDomain>();
        if (StringUtils.isBlank((String)prv11Name)) {
            return;
        }
        for (String channelName : split = prv11Name.split("/")) {
            DisDgoodsScopelistDomain disDgoodsScopelistDomain = new DisDgoodsScopelistDomain();
            DisDgoods disDgoods = (DisDgoods)disDgoodsList.stream().filter(item -> item.getChannelName().equals(channelMap.get(channelName))).collect(Collectors.toList()).get(0);
            if (null == disDgoods) continue;
            try {
                BeanUtils.copyAllPropertys((Object)disDgoodsScopelistDomain, (Object)disDgoods);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            disDgoodsScopelistDomain.setDgoodsScopelistCode(this.createUUIDString());
            disDgoodsScopelistDomain.setChannelSort("1");
            disDgoodsScopelistDomain.setChannelType("0");
            disDgoodsScopelistDomain.setDgoodsScopelistType("skuNo");
            disDgoodsScopelistDomain.setDgoodsScopelistValue(goodsShowname);
            disDgoodsScopelistDomain.setDgoodsScopelistValuen(goodsShowname);
            disDgoodsScopelistDomain.setDgoodsScopelistValuename(rsSkuDomain.getSkuEocode());
            disDgoodsScopelistDomain.setDgoodsScopelistDes(skuName);
            disDgoodsScopelistDomain.setDgoodsScopelistTerm("=");
            disDgoodsScopelistDomains.add(disDgoodsScopelistDomain);
        }
        rsSkuDomain.setDisDgoodsScopelistDomains(disDgoodsScopelistDomains);
        rsResourceGoodsDomain.getDisDgoodsScopelistDomains().addAll(rsSkuDomain.getDisDgoodsScopelistDomains());
    }

    private RsResourceGoodsDomain buildrResourceGoodsDomain(List<ResourceGoodsU9> skus, String tenantCode, List<GoodsCategory> goodsCategoryList) {
        List specList;
        List innerColorSpec;
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        ResourceGoodsU9 item = skus.get(0);
        rsResourceGoodsDomain.setDisDgoodsScopelistDomains(new ArrayList<DisDgoodsScopelistDomain>());
        rsResourceGoodsDomain.setTenantCode(tenantCode);
        rsResourceGoodsDomain.setGoodsEocode(item.getPrv10Code());
        rsResourceGoodsDomain.setGoodsNo(item.getPrv10Code());
        rsResourceGoodsDomain.setGoodsName(item.getPrv10Name());
        rsResourceGoodsDomain.setBrandCode(item.getPrv8Code());
        rsResourceGoodsDomain.setBrandName(item.getPrv8Name());
        rsResourceGoodsDomain.setGoodsMaterial(item.getPrv9Name());
        rsResourceGoodsDomain.setPntreeCode(item.getFirstCategoryCode());
        rsResourceGoodsDomain.setPntreeCode(item.getFirstCategoryName());
        rsResourceGoodsDomain.setClasstreeCode(item.getPrv18Code());
        rsResourceGoodsDomain.setClasstreeCode(item.getPrv18Name());
        rsResourceGoodsDomain.setClasstreeName(item.getPrv18Name());
        rsResourceGoodsDomain.setOneClasstreeCode(item.getFirstCategoryCode());
        rsResourceGoodsDomain.setOneClasstreeName(item.getFirstCategoryName());
        rsResourceGoodsDomain.setSecondClasstreeCode(item.getSecondCategoryCode());
        rsResourceGoodsDomain.setSecondClasstreeName(item.getSecondCategoryName());
        ArrayList<RsSpecDomain> rsSpecDomainList = new ArrayList<RsSpecDomain>();
        List colorSpec = skus.stream().filter(a -> StringUtils.isNotBlank((String)a.getPrv12Name())).map(ResourceGoodsU9::getPrv12Name).distinct().collect(Collectors.toList());
        if (null != colorSpec && colorSpec.size() != 0) {
            RsSpecDomain rsSpecDomain = new RsSpecDomain();
            rsSpecDomain.setSpecName("\u989c\u8272");
            rsSpecDomainList.add(rsSpecDomain);
            ArrayList<RsSpecOptionDomain> specOptionDomainList = new ArrayList<RsSpecOptionDomain>();
            for (Object specName : colorSpec) {
                RsSpecOptionDomain rsSpecOptionDomain = new RsSpecOptionDomain();
                specOptionDomainList.add(rsSpecOptionDomain);
                rsSpecOptionDomain.setSpecOptionName((String)specName);
            }
            rsSpecDomain.setSpecOptionList(specOptionDomainList);
        }
        if (null != (innerColorSpec = skus.stream().filter(a -> StringUtils.isNotBlank((String)a.getPrv16Name())).map(ResourceGoodsU9::getPrv16Name).distinct().collect(Collectors.toList())) && innerColorSpec.size() != 0) {
            RsSpecDomain innerSsSpecDomain = new RsSpecDomain();
            innerSsSpecDomain.setSpecName("\u4e2d\u5185\u5c42\u989c\u8272");
            rsSpecDomainList.add(innerSsSpecDomain);
            ArrayList<RsSpecOptionDomain> specOptionDomainList = new ArrayList<RsSpecOptionDomain>();
            for (String specName : innerColorSpec) {
                RsSpecOptionDomain rsSpecOptionDomain = new RsSpecOptionDomain();
                specOptionDomainList.add(rsSpecOptionDomain);
                rsSpecOptionDomain.setSpecOptionName(specName);
            }
            innerSsSpecDomain.setSpecOptionList(specOptionDomainList);
        }
        if (null != (specList = skus.stream().filter(a -> StringUtils.isNotBlank((String)a.getSpecs())).map(ResourceGoodsU9::getSpecs).distinct().collect(Collectors.toList())) && specList.size() != 0) {
            RsSpecDomain specDomain = new RsSpecDomain();
            specDomain.setSpecName("\u578b\u53f7");
            rsSpecDomainList.add(specDomain);
            ArrayList<RsSpecOptionDomain> specOptionDomainList = new ArrayList<RsSpecOptionDomain>();
            for (String specName : specList) {
                RsSpecOptionDomain rsSpecOptionDomain = new RsSpecOptionDomain();
                specOptionDomainList.add(rsSpecOptionDomain);
                rsSpecOptionDomain.setSpecOptionName(specName);
            }
            specDomain.setSpecOptionList(specOptionDomainList);
        }
        rsResourceGoodsDomain.setRsSpecDomainList(rsSpecDomainList);
        return rsResourceGoodsDomain;
    }

    private void updateFalgSettingInFoByKey(InternalRouter internalRouter, String flagSettingCode, String tenantCode, String modifiedon, Integer flagSettingId) {
        final DdFalgSettingDomain ddFalgSettingDomain = new DdFalgSettingDomain();
        ddFalgSettingDomain.setFlagSettingId(flagSettingId);
        ddFalgSettingDomain.setFlagSettingCode(flagSettingCode);
        ddFalgSettingDomain.setTenantCode(tenantCode);
        ddFalgSettingDomain.setFlagSettingInfo(modifiedon);
        HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("falgSettingDomain", JsonUtil.buildNormalBinder().toJson((Object)ddFalgSettingDomain));
            }
        };
        internalRouter.inInvoke("dd.falgSetting.updateFalgSetting", (Map)ddflagMap);
    }

    private LocalDateTime getLocalDateTime(String datetimeStr) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return LocalDateTime.parse(datetimeStr, df);
    }

    private void saveDdFlag(InternalRouter internalRouter, String tenantCode, String flagSettingCode, String flagSettingPro, String localTime, String businessFlag) {
        final DdFalgSettingDomain ddFalgSettingDomain = new DdFalgSettingDomain();
        ddFalgSettingDomain.setTenantCode(tenantCode);
        ddFalgSettingDomain.setFlagSettingInfo(localTime);
        ddFalgSettingDomain.setFlagSettingCode(flagSettingCode);
        ddFalgSettingDomain.setFlagSettingScope(flagSettingCode);
        ddFalgSettingDomain.setFlagSettingPro(flagSettingPro);
        if (StringUtils.isNotBlank((String)businessFlag)) {
            ddFalgSettingDomain.setFlagSettingPro1(businessFlag);
        }
        HashMap<String, Object> saveDdFlagParamMap = new HashMap<String, Object>(){
            {
                this.put("falgSettingDomain", JsonUtil.buildNormalBinder().toJson((Object)ddFalgSettingDomain));
            }
        };
        logger.error(this.SYS_CODE + ".saveDdFlag.saveDdFlagParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)saveDdFlagParamMap));
        logger.error(this.SYS_CODE + ".saveDdFlag", (Object)"\u4fdd\u5b58resourceGoodsUpdateBeginTime ddFlag\u5f00\u59cb");
        internalRouter.inInvoke("dd.falgSetting.saveFalgSetting", (Map)saveDdFlagParamMap);
        logger.error(this.SYS_CODE + ".saveDdFlag", (Object)"\u4fdd\u5b58resourceGoodsUpdateBeginTime ddFlag\u7ed3\u675f");
    }

    private String getStringlocalDateTime() {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime time = LocalDateTime.now();
        return df.format(time);
    }

    private List<DisDgoodsScopelist> queryDgoodsScopelistPageBySkuEocode(final String tenantCode, InternalRouter internalRouter, final String skuEoCode) {
        final HashMap<String, Object> disMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", tenantCode);
                this.put("dgoodsScopelistValuename", skuEoCode);
                this.put("fuzzy", true);
            }
        };
        HashMap<String, Object> disGoodsScopelistParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)disMap));
            }
        };
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuEocode.disGoodsParamMap", (Object)"\u67e5\u8be2disGoods\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuEocode.disGoodsParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)disGoodsScopelistParamMap));
        String disGoodsListStr = (String)internalRouter.inInvoke("dis.dgoods.queryDgoodsScopelistPage", (Map)disGoodsScopelistParamMap);
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuEocode", (Object)"\u67e5\u8be2disGoodsScopelist\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(disGoodsListStr, SupQueryResult.class);
        if (null == supQueryResult) {
            return null;
        }
        List disDgoodsScopelist = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DisDgoodsScopelist.class);
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuEocode.DisDgoodsScopelist", (Object)JsonUtil.buildNormalBinder().toJson((Object)disDgoodsScopelist));
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuEocode.DisDgoodsScopelist", (Object)"\u67e5\u8be2disGoodsdisDgoodsScopelist\u7ed3\u675f");
        if (null == disDgoodsScopelist || ListUtil.isEmpty((Collection)disDgoodsScopelist)) {
            return null;
        }
        return disDgoodsScopelist;
    }

    private List<DisDgoodsScopelist> queryDgoodsScopelistPageBySkuEocodeAndChannelName(final String tenantCode, InternalRouter internalRouter, final String skuEoCode, final String channelName) {
        final HashMap<String, Object> disMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", tenantCode);
                this.put("channelName", channelName);
                this.put("dgoodsScopelistValuename", skuEoCode);
                this.put("fuzzy", true);
            }
        };
        HashMap<String, Object> disGoodsScopelistParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)disMap));
            }
        };
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuShowNoAndChannelName.disGoodsParamMap", (Object)"\u67e5\u8be2disGoods\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuShowNoAndChannelName.disGoodsParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)disGoodsScopelistParamMap));
        String disGoodsListStr = (String)internalRouter.inInvoke("dis.dgoods.queryDgoodsScopelistPage", (Map)disGoodsScopelistParamMap);
        logger.error(this.SYS_CODE + ".queryDgoodsScopelistPageBySkuShowNoAndChannelName", (Object)"\u67e5\u8be2disGoodsScopelist\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(disGoodsListStr, SupQueryResult.class);
        if (null == supQueryResult) {
            return null;
        }
        List disDgoodsScopelist = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DisDgoodsScopelist.class);
        logger.error(this.SYS_CODE + ".queryDisGoodsPage.DisDgoodsScopelist", (Object)JsonUtil.buildNormalBinder().toJson((Object)disDgoodsScopelist));
        logger.error(this.SYS_CODE + ".queryDisGoodsPage.DisDgoodsScopelist", (Object)"\u67e5\u8be2disGoodsdisDgoodsScopelist\u7ed3\u675f");
        if (null == disDgoodsScopelist || ListUtil.isEmpty((Collection)disDgoodsScopelist)) {
            return null;
        }
        return disDgoodsScopelist;
    }

    private List<DisDgoods> queryDisGoodsPage(final String tenantCode, InternalRouter internalRouter, final String channelNames) {
        final HashMap<String, Object> disMap = new HashMap<String, Object>(){
            {
                this.put("channelName", channelNames);
                this.put("tenantCode", tenantCode);
            }
        };
        HashMap<String, Object> disGoodsParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)disMap));
            }
        };
        logger.error(this.SYS_CODE + ".queryDisGoodsPage.disGoodsParamMap", (Object)"\u67e5\u8be2disGoods\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".queryDisGoodsPage.disGoodsParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)disGoodsParamMap));
        String disGoodsListStr = (String)internalRouter.inInvoke("dis.dgoods.queryDgoodsPage", (Map)disGoodsParamMap);
        logger.error(this.SYS_CODE + ".queryDisGoodsPage.queryDisGoodsPage", (Object)"\u67e5\u8be2disGoods\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(disGoodsListStr, SupQueryResult.class);
        List disGoodsList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DisDgoods.class);
        logger.error(this.SYS_CODE + ".queryDisGoodsPage.disGoodsList", (Object)JsonUtil.buildNormalBinder().toJson((Object)disGoodsList));
        logger.error(this.SYS_CODE + ".queryDisGoodsPage.disGoodsList", (Object)"\u67e5\u8be2disGoods\u7ed3\u675f");
        return disGoodsList;
    }

    private DdFalgSetting queryDdFlagSetting(final String tenantCode, InternalRouter internalRouter, final String flagSettingCode) {
        final HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("flagSettingCode", flagSettingCode);
                this.put("tenantCode", tenantCode);
            }
        };
        HashMap<String, Object> ddflagParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)ddflagMap));
            }
        };
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.ddflagParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)ddflagParamMap));
        String flagSettingListStr = (String)internalRouter.inInvoke("dd.falgSetting.queryFalgSettingPage", (Map)ddflagParamMap);
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFla\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(flagSettingListStr, SupQueryResult.class);
        List flagSettingList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DdFalgSetting.class);
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.flagSettingList", (Object)JsonUtil.buildNormalBinder().toJson((Object)flagSettingList));
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u7ed3\u675f");
        return (DdFalgSetting)flagSettingList.get(0);
    }

    public String checkGoodsParam(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null == rsResourceGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getGoodsName())) {
            return "\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getGoodsNo())) {
            return "\u5546\u54c1\u8d27\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getTenantCode())) {
            return "\u79df\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return "";
    }

    private void makeSkuDomain(RsResourceGoodsDomain rsResourceGoodsDomain, RsSkuDomain rsSkuDomain) {
        if (null == rsResourceGoodsDomain || null == rsSkuDomain) {
            logger.debug(this.SYS_CODE + ".makeSkuDomain", (Object)"isnull");
            return;
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)rsResourceGoodsDomain);
        }
        catch (Exception e) {
            logger.debug(this.SYS_CODE + ".makeSkuDomain", (Throwable)e);
            return;
        }
        rsSkuDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
        rsSkuDomain.setGoodsNum(new BigDecimal("999"));
        rsSkuDomain.setGoodsSupplynum(new BigDecimal("999"));
        rsSkuDomain.setGoodsNo(rsResourceGoodsDomain.getGoodsNo());
        rsSkuDomain.setSkuNo(rsResourceGoodsDomain.getSkuNo());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveOrUpdateSkuList(RsResourceGoodsDomain rsResourceGoodsDomain, RsResourceGoodsReDomain goodsDomain, RsSkuDomain skuDomain) throws Exception {
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        HashMap<String, Object> skuMapStr = new HashMap<String, Object>();
        skuMapStr.put("skuNo", skuDomain.getSkuNo());
        skuMapStr.put("tenantCode", skuDomain.getTenantCode());
        RsSkuReDomain rsSkuReDomain = this.querySkuPage(skuMapStr);
        RsSkuDomain rsSkuDomainNew = new RsSkuDomain();
        if (null != rsSkuReDomain) {
            if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSpecValueDomainList())) {
                ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
                HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                paramsMap.put("specValueBillno", goodsDomain.getGoodsCode());
                paramsMap.put("tenantCode", goodsDomain.getTenantCode());
                for (RsSpecValueDomain rsSpecValueDomain : rsResourceGoodsDomain.getRsSpecValueDomainList()) {
                    paramsMap.put("specValueValue", rsSpecValueDomain.getSpecValueValue());
                    paramsMap.put("startRow", 0);
                    paramsMap.put("rows", 1);
                    QueryResult<RsSpecValueReDomain> rsSpecValueReDomainQueryResult = this.checkSpecValue(paramsMap);
                    if (null != rsSpecValueReDomainQueryResult && ListUtil.isNotEmpty((Collection)rsSpecValueReDomainQueryResult.getList())) continue;
                    rsSpecValueDomain.setSpecValueBillno(goodsDomain.getGoodsCode());
                    rsSpecValueDomain.setTenantCode(goodsDomain.getTenantCode());
                    rsSpecValueDomain.setSpuCode(goodsDomain.getSpuCode());
                    rsSpecValueDomainList.add(rsSpecValueDomain);
                }
                if (ListUtil.isNotEmpty(rsSpecValueDomainList)) {
                    this.saveSpecValueList(rsSpecValueDomainList);
                }
            }
            Integer oldDataState = rsSkuReDomain.getDataState();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, (Object)rsSkuReDomain);
                BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomainNew, (Object)rsSkuReDomain);
                BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomainNew, (Object)skuDomain);
                BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, (Object)skuDomain);
                editSkuDomain.setSkuEdit(false);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".saveOrUpdateSkuList3", (Throwable)e);
                throw new ApiException(this.SYS_CODE + ".saveOrUpdateSkuList3", (Throwable)e);
            }
            Integer dataOpbillstate = rsSkuDomainNew.getDataOpbillstate();
            try {
                if (null != dataOpbillstate && dataOpbillstate == 1 && null != oldDataState && oldDataState == 2) {
                    rsSkuDomainNew.setDataOpbillstate(0);
                    this.updateRsSkuDomainNew(rsSkuDomainNew);
                    this.sendUpdateShelveBatchSku(rsSkuReDomain);
                }
                if (null != dataOpbillstate && dataOpbillstate == 0 && null != oldDataState && oldDataState == 2) {
                    rsSkuDomainNew.setDataOpbillstate(1);
                    this.updateRsSkuDomainNew(rsSkuDomainNew);
                    this.sendUpdateSoldOutBatchSku(rsSkuReDomain);
                }
                if (null == dataOpbillstate || dataOpbillstate != 1 || null == oldDataState || oldDataState != 0) return;
                rsSkuDomainNew.setDataOpbillstate(0);
                this.updateRsSkuDomainNew(rsSkuDomainNew);
                this.sendUpdateShelveBatchSku(rsSkuReDomain);
                return;
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".saveOrUpdateSkuList3.update" + oldDataState, (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSkuReDomain));
                throw new ApiException(this.SYS_CODE + ".saveOrUpdateSkuList3.update", (Throwable)e);
            }
        }
        Integer dataOpbillstate = skuDomain.getDataOpbillstate();
        if (null != dataOpbillstate && dataOpbillstate == 1) {
            skuDomain.setDataOpbillstate(0);
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSpecValueDomainList())) {
            ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("specValueBillno", goodsDomain.getGoodsCode());
            paramsMap.put("tenantCode", goodsDomain.getTenantCode());
            for (RsSpecValueDomain rsSpecValueDomain : rsResourceGoodsDomain.getRsSpecValueDomainList()) {
                paramsMap.put("specValueValue", rsSpecValueDomain.getSpecValueValue());
                paramsMap.put("startRow", 0);
                paramsMap.put("rows", 1);
                QueryResult<RsSpecValueReDomain> rsSpecValueReDomainQueryResult = this.checkSpecValue(paramsMap);
                if (null != rsSpecValueReDomainQueryResult && ListUtil.isNotEmpty((Collection)rsSpecValueReDomainQueryResult.getList())) continue;
                rsSpecValueDomain.setSpecValueBillno(goodsDomain.getGoodsCode());
                rsSpecValueDomain.setTenantCode(goodsDomain.getTenantCode());
                rsSpecValueDomain.setSpuCode(goodsDomain.getSpuCode());
                rsSpecValueDomainList.add(rsSpecValueDomain);
            }
            if (ListUtil.isNotEmpty(rsSpecValueDomainList)) {
                this.saveSpecValueList(rsSpecValueDomainList);
            }
        }
        try {
            skuDomain.setGoodsCode(goodsDomain.getGoodsCode());
            skuDomain.setSpuCode(goodsDomain.getSpuCode());
            this.saveRsSkuDomain(skuDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".saveOrUpdateSkuList5\u3002updateEsResourceGoodsDomain" + JsonUtil.buildNormalBinder().toJson((Object)goodsDomain), (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".saveOrUpdateSkuList5\u3002updateEsResourceGoodsDomain", (Throwable)e);
        }
        if (null == dataOpbillstate || dataOpbillstate != 1) return;
        HashMap<String, Object> skuMap1 = new HashMap<String, Object>();
        skuMap1.put("skuNo", skuDomain.getSkuNo());
        skuMap1.put("tenantCode", skuDomain.getTenantCode());
        RsSkuReDomain rsSkuReDomain1 = this.querySkuPage(skuMap1);
        if (null == rsSkuReDomain1) {
            logger.error(this.SYS_CODE + ".saveOrUpdateSkuList5.rsSkuReDomain", skuMap1);
            throw new ApiException(this.SYS_CODE + ".saveOrUpdateSkuList55.rsSkuReDomain");
        }
        if (null != rsSkuReDomain1 && rsSkuReDomain1.getDataOpbillstate() == 0) {
            try {
                this.sendUpdateShelveBatchSku(rsSkuReDomain1);
                return;
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".saveOrUpdateSkuList3.sendUpdateShelveBatchSku", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSkuReDomain));
                throw new ApiException(this.SYS_CODE + ".saveOrUpdateSkuList3.sendUpdateShelveBatchSku", (Throwable)e);
            }
        } else {
            logger.error(this.SYS_CODE + ".saveOrUpdateSkuList3.sendUpdateShelveBatchSku.dataOpbillstate.sku", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSkuReDomain));
        }
    }

    private QueryResult<RsSpecValueReDomain> checkSpecValue(Map<String, Object> paramsMap) {
        QueryResult<RsSpecValueReDomain> rsSpecValueReDomainQueryResult = this.querySpecValuePage(paramsMap);
        if (rsSpecValueReDomainQueryResult == null || ListUtil.isEmpty((Collection)rsSpecValueReDomainQueryResult.getList())) {
            return null;
        }
        return rsSpecValueReDomainQueryResult;
    }

    private void makeSpec(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null == rsResourceGoodsDomain) {
            return;
        }
        String tenantCode = rsResourceGoodsDomain.getTenantCode();
        HashMap<String, String> specGroupMap = new HashMap<String, String>();
        HashMap<String, String> specGroupMapStr = new HashMap<String, String>();
        specGroupMapStr.put("pntreeCode", rsResourceGoodsDomain.getPntreeCode());
        specGroupMapStr.put("tenantCode", tenantCode);
        specGroupMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(specGroupMapStr));
        RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
        QueryResult supQueryResult = this.sendReSupObject("rs.spec.querySpecGroupPage", specGroupMap, RsSpecGroupDomain.class);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            HashMap<String, String> mapStr = new HashMap<String, String>();
            RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
            rsSpecGroupDomain.setPntreeCode(rsResourceGoodsDomain.getPntreeCode());
            rsSpecGroupDomain.setSpecGroupName(rsResourceGoodsDomain.getPntreeName());
            rsSpecGroupDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
            rsSpecGroupDomain.setTenantCode(tenantCode);
            mapStr.put("rsSpecGroupDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecGroupDomain));
            String specGroupCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", mapStr);
            if (StringUtils.isBlank((String)specGroupCode)) {
                logger.error(this.SYS_CODE + ".makeSpec.checkGoods.saveSpecGroup", (Object)("\u89c4\u683c\u7ec4\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01rsSpecGroupDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecGroupDomain)));
                return;
            }
            this.makeRsSpecDomain(rsResourceGoodsDomain, specGroupCode);
        } else {
            RsSpecGroupDomain rsSpecGroup = (RsSpecGroupDomain)supQueryResult.getList().get(0);
            rsSpecValueDomain.setSpecGroupCode(rsSpecGroup.getSpecGroupCode());
            this.makeRsSpecDomain(rsResourceGoodsDomain, rsSpecGroup.getSpecGroupCode());
        }
    }

    public void checkrsSpecOption(RsResourceGoodsDomain rsResourceGoodsDomain, String specGroupCode, String specCode, String specOptionName, String tenantCode, String specName) {
        RsSpecOptionDomain rsSpecOptionDomain;
        RsSpecValueDomain rsSpecValue;
        ArrayList<RsSpecValueDomain> rsSpecValuenList;
        block10: {
            HashMap<String, String> map2 = new HashMap<String, String>();
            HashMap<String, String> specOpMap = new HashMap<String, String>();
            map2.put("specCode", specCode);
            map2.put("specOptionName", specOptionName);
            map2.put("tenantCode", tenantCode);
            specOpMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map2));
            rsSpecValuenList = new ArrayList<RsSpecValueDomain>();
            rsSpecValue = new RsSpecValueDomain();
            List specOpList = this.getQueryResutl("rs.spec.querySpecOptionPage", specOpMap, RsSpecOption.class).getList();
            rsSpecOptionDomain = new RsSpecOptionDomain();
            if (ListUtil.isEmpty((Collection)specOpList)) {
                rsSpecOptionDomain.setSpecGroupCode(specGroupCode);
                rsSpecOptionDomain.setSpecCode(specCode);
                rsSpecOptionDomain.setSpecOptionName(specOptionName);
                rsSpecOptionDomain.setTenantCode(tenantCode);
                rsSpecOptionDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("rsSpecOptionDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecOptionDomain));
                try {
                    String specOptionCode = this.internalInvoke("rs.spec.saveSpecOption", map);
                    if (StringUtils.isBlank((String)specOptionCode)) {
                        logger.error(this.SYS_CODE + ".checkrsSpecOption.specOptionCode", (Object)("specCode:" + specCode + ",\u8bf7\u6c42\u53c2\u6570rsSpecDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain)));
                        return;
                    }
                    break block10;
                }
                catch (Exception e) {
                    logger.error(this.SYS_CODE + ".checkrsSpecOption.\u65b0\u589e\u89c4\u683c\u5c5e\u6027\u503c\u5931\u8d25", (Object)(",\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain)), (Throwable)e);
                    return;
                }
            }
            try {
                BeanUtils.copyAllPropertys((Object)rsSpecOptionDomain, specOpList.get(0));
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".checkrsSpecOption.\u65b0\u589e\u89c4\u683c\u5c5e\u6027\u503c\u5931\u8d251", (Object)(",\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain)), (Throwable)e);
                return;
            }
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSpecValue, (Object)rsSpecOptionDomain);
            rsSpecValue.setSpecValueValue(specOptionName);
            rsSpecValue.setSpecName(specName);
            rsSpecValue.setSpecValueType("0");
            rsSpecValue.setTenantCode(tenantCode);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".checkrsSpecOption.\u65b0\u589e\u89c4\u683c\u5c5e\u6027\u503c\u5931\u8d252", (Object)(",\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain)), (Throwable)e);
            e.printStackTrace();
        }
        rsSpecValuenList.add(rsSpecValue);
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSpecValueDomainList())) {
            rsResourceGoodsDomain.getRsSpecValueDomainList().addAll(rsSpecValuenList);
        } else {
            rsResourceGoodsDomain.setRsSpecValueDomainList(rsSpecValuenList);
        }
    }

    public void makeRsSpecDomain(RsResourceGoodsDomain rsResourceGoodsDomain, String specGroupCode) {
        if (null == rsResourceGoodsDomain || StringUtils.isEmpty((String)specGroupCode)) {
            logger.error(this.SYS_CODE + ".makeRsSpecDomain", (Object)"isnull");
            return;
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSpecDomainList())) {
            for (RsSpecDomain rsSpecDomain : rsResourceGoodsDomain.getRsSpecDomainList()) {
                rsSpecDomain.setSpecGroupCode(specGroupCode);
                QueryResult<RsSpecDomain> rsSpecDomainQueryResult = this.querySpecPageSpecGroupCode(rsSpecDomain.getSpecGroupCode(), rsSpecDomain.getSpecName(), rsResourceGoodsDomain.getTenantCode());
                if (rsSpecDomainQueryResult == null || ListUtil.isEmpty((Collection)rsSpecDomainQueryResult.getList())) {
                    String specCode = this.saveRsSpec(rsSpecDomain.getSpecGroupCode(), rsSpecDomain.getSpecName(), rsResourceGoodsDomain.getTenantCode(), rsResourceGoodsDomain.getChannelCode());
                    if (StringUtils.isBlank((String)specCode)) {
                        logger.error(this.SYS_CODE + ".makeRsSpecDomain.checkGoods.saveSpec", (Object)("specCode:" + specCode + ",\u8bf7\u6c42\u53c2\u6570rsSpecDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecDomain)));
                        return;
                    }
                    if (!ListUtil.isNotEmpty(rsSpecDomain.getSpecOptionList())) continue;
                    for (RsSpecOptionDomain rsSpecOptionDomain : rsSpecDomain.getSpecOptionList()) {
                        if (null == rsSpecOptionDomain) continue;
                        this.checkrsSpecOption(rsResourceGoodsDomain, rsSpecDomain.getSpecGroupCode(), specCode, rsSpecOptionDomain.getSpecOptionName(), rsResourceGoodsDomain.getTenantCode(), rsSpecDomain.getSpecName());
                    }
                    continue;
                }
                rsSpecDomain.setSpecCode(((RsSpecDomain)rsSpecDomainQueryResult.getList().get(0)).getSpecCode());
                if (!ListUtil.isNotEmpty(rsSpecDomain.getSpecOptionList())) continue;
                for (RsSpecOptionDomain rsSpecOptionDomain : rsSpecDomain.getSpecOptionList()) {
                    if (null == rsSpecOptionDomain) continue;
                    this.checkrsSpecOption(rsResourceGoodsDomain, rsSpecDomain.getSpecGroupCode(), rsSpecDomain.getSpecCode(), rsSpecOptionDomain.getSpecOptionName(), rsResourceGoodsDomain.getTenantCode(), rsSpecDomain.getSpecName());
                }
            }
        }
    }

    private String checkPntree(RsResourceGoodsDomain rsResourceGoodsDomain, List<RsSkuDomain> rsSkuDomainList) {
        RsPntreeDomain rsPntreeDomain;
        HashMap<String, String> param = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeName())) {
            param.put("pntreeName", rsResourceGoodsDomain.getPntreeName());
        }
        param.put("pntreeEocode", rsResourceGoodsDomain.getPntreeCode());
        param.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        String pntreeCode = "";
        String pntreeName = rsResourceGoodsDomain.getPntreeName();
        QueryResult queryResult = this.sendReSupObject("rs.pntree.queryPntreePage", paramMap, RsPntreeDomain.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            rsPntreeDomain = new RsPntreeDomain();
            rsPntreeDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
            rsPntreeDomain.setPntreeEocode(rsResourceGoodsDomain.getPntreeCode());
            rsPntreeDomain.setPntreeName(rsResourceGoodsDomain.getPntreeName());
            rsPntreeDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
            pntreeCode = this.saveRsPntreeDomainU9(rsPntreeDomain);
        } else {
            rsPntreeDomain = (RsPntreeDomain)queryResult.getList().get(0);
            pntreeCode = rsPntreeDomain.getPntreeCode();
        }
        rsResourceGoodsDomain.setPntreeCode(pntreeCode);
        rsResourceGoodsDomain.setPntreeName(pntreeName);
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            rsSkuDomain.setPntreeCode(pntreeCode);
            rsSkuDomain.setPntreeName(pntreeName);
        }
        return pntreeCode;
    }

    private String checkBrand(RsResourceGoodsDomain rsResourceGoodsDomain) {
        RsBrandDomain rsBrandDomain = null;
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandCode())) {
            rsBrandDomain = this.getBrandByEocode(rsResourceGoodsDomain.getBrandCode(), rsResourceGoodsDomain.getTenantCode());
        }
        if (rsBrandDomain == null) {
            logger.error(this.SYS_CODE + ".checkBrand", (Object)("\u54c1\u724c\u672a\u7ef4\u62a4\u5168==" + rsResourceGoodsDomain.getBrandCode() + "---" + rsResourceGoodsDomain.getBrandName()));
            return "\u54c1\u724c\u672a\u7ef4\u62a4\u5168\uff01";
        }
        rsResourceGoodsDomain.setBrandCode(rsBrandDomain.getBrandCode());
        rsResourceGoodsDomain.setBrandName(rsBrandDomain.getBrandName());
        return "";
    }

    private String checkBrandU9(RsResourceGoodsDomain rsResourceGoodsDomain, List<RsSkuDomain> rsSkuDomainList) {
        RsBrandDomain rsBrandDomain = null;
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandCode())) {
            rsBrandDomain = this.getBrandByEocode(rsResourceGoodsDomain.getBrandCode(), rsResourceGoodsDomain.getTenantCode());
        }
        String brandCode = "";
        String brandName = rsResourceGoodsDomain.getBrandName();
        if (rsBrandDomain != null) {
            brandCode = rsBrandDomain.getBrandCode();
        } else {
            rsBrandDomain = new RsBrandDomain();
            rsBrandDomain.setBrandEocode(rsResourceGoodsDomain.getBrandCode());
            rsBrandDomain.setBrandName(rsResourceGoodsDomain.getBrandName());
            rsBrandDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
            rsBrandDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
            rsBrandDomain.setChannelName(rsResourceGoodsDomain.getChannelName());
            brandCode = this.saveRsBranU9(rsBrandDomain);
        }
        rsResourceGoodsDomain.setBrandCode(brandCode);
        rsResourceGoodsDomain.setBrandName(brandName);
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            rsSkuDomain.setBrandCode(brandCode);
            rsSkuDomain.setBrandName(brandName);
        }
        return brandCode;
    }

    private String checkClassTree(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode())) {
            map.put("classtreeCode", rsResourceGoodsDomain.getClasstreeCode());
        }
        map.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        QueryResult<RsClasstreeDomain> queryResult = this.queryRsClasstreePage(map);
        String classTreeCode = "";
        if (queryResult == null || !ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            logger.error(this.SYS_CODE + ".checkClassTree", (Object)("\u540e\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168==" + rsResourceGoodsDomain.getClasstreeCode() + "---" + rsResourceGoodsDomain.getClasstreeName()));
            return "\u540e\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168\uff01";
        }
        rsResourceGoodsDomain.setClasstreeCode(((RsClasstreeDomain)queryResult.getList().get(0)).getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(((RsClasstreeDomain)queryResult.getList().get(0)).getClasstreeName());
        return "";
    }

    private String checkRsClassTree(RsResourceGoodsDomain rsResourceGoodsDomain, List<RsSkuDomain> rsSkuDomainList) {
        HashMap<String, String> classtreeMap = new HashMap<String, String>();
        String oneClassTreeCode = this.checkAndAddClassTreeCode(rsResourceGoodsDomain, "-1", "1", "1", null);
        if (oneClassTreeCode.contains("\u5206\u7c7b")) {
            logger.error(this.SYS_CODE + ".checkRsClassTree.oneClassTreeCode", (Object)("\u65b0\u589e\u4e00\u7ea7\u540e\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getOneClasstreeName()));
            return "\u65b0\u589e\u4e00\u7ea7\u540e\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getOneClasstreeName();
        }
        classtreeMap.put("oneClassTreeCode", oneClassTreeCode);
        String twoClassTreeCode = this.checkAndAddClassTreeCode(rsResourceGoodsDomain, oneClassTreeCode, "1", "2", null);
        if (twoClassTreeCode.contains("\u5206\u7c7b")) {
            logger.error(this.SYS_CODE + ".checkRsClassTree.twoClassTreeCode", (Object)("\u65b0\u589e\u4e8c\u7ea7\u540e\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getSecondClasstreeName()));
            return "\u65b0\u589e\u4e8c\u7ea7\u540e\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getSecondClasstreeName();
        }
        classtreeMap.put("twoClassTreeCode", twoClassTreeCode);
        String classTreeCode = this.checkAndAddClassTreeCode(rsResourceGoodsDomain, twoClassTreeCode, "0", "3", rsSkuDomainList);
        if (classTreeCode.contains("\u5206\u7c7b")) {
            logger.error(this.SYS_CODE + ".checkRsClassTree.classTreeCode", (Object)("\u65b0\u589e\u4e09\u7ea7\u7ea7\u540e\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getClasstreeCode()));
            return "\u65b0\u589e\u4e09\u7ea7\u7ea7\u540e\u53f0\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u540d\u79f0\uff1a" + rsResourceGoodsDomain.getClasstreeCode();
        }
        classtreeMap.put("classTreeCode", classTreeCode);
        return JsonUtil.buildNonNullBinder().toJson(classtreeMap);
    }

    private String checkAndAddClassTreeCode(RsResourceGoodsDomain rsResourceGoodsDomain, String classTreeParentCode, String classTreeLast, String level, List<RsSkuDomain> rsSkuDomainList) {
        RsClasstreeDomain classtreeDomain;
        RsClasstreeDomain rsClasstreeDomain = this.buildClassTreee(rsResourceGoodsDomain, classTreeParentCode, classTreeLast, "0", level);
        String msg = GoodsParamCheckUtils.checkClasstreeParam(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExClass.msg");
            return "\u540e\u53f0\u5206\u7c7b\u6821\u9a8c\u51fa\u9519";
        }
        if (!"-1".equals(rsClasstreeDomain.getClasstreeParentcode()) && (classtreeDomain = this.getRsClasstreeByCodeU(rsClasstreeDomain.getClasstreeParentcode(), rsClasstreeDomain.getTenantCode())) == null) {
            return "\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\uff01";
        }
        String code = "";
        String name = rsClasstreeDomain.getClasstreeName();
        RsClasstreeDomain classtreeDomain2 = this.getRsClasstreeByCode(rsClasstreeDomain.getClasstreeEocode(), rsClasstreeDomain.getTenantCode());
        if (classtreeDomain2 == null) {
            rsClasstreeDomain.setClasstreeCode(null);
            code = this.saveRsClasstree(rsClasstreeDomain);
        } else {
            code = classtreeDomain2.getClasstreeCode();
        }
        if (null != rsSkuDomainList) {
            rsResourceGoodsDomain.setClasstreeCode(code);
            rsResourceGoodsDomain.setClasstreeName(name);
            for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
                rsSkuDomain.setClasstreeCode(code);
                rsSkuDomain.setClasstreeName(name);
            }
        }
        return code;
    }

    private RsClasstreeDomain buildClassTreeeForPriceCategory(RsResourceGoodsDomain rsResourceGoodsDomain, RsSkuDomain rsSkuDomain, String classtreeParentcode, String classtreeLast, String classtreeType) {
        RsClasstreeDomain rsClasstreeDomain = new RsClasstreeDomain();
        rsClasstreeDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
        rsClasstreeDomain.setClasstreeParentcode(classtreeParentcode);
        rsClasstreeDomain.setClasstreeLast(classtreeLast);
        rsClasstreeDomain.setClasstreeType(classtreeType);
        rsClasstreeDomain.setClasstreeName(rsSkuDomain.getGoodsWeightstr());
        rsClasstreeDomain.setClasstreeEocode(rsSkuDomain.getSkuRemark());
        return rsClasstreeDomain;
    }

    private RsClasstreeDomain buildClassTreee(RsResourceGoodsDomain rsResourceGoodsDomain, String classtreeParentcode, String classtreeLast, String classtreeType, String level) {
        RsClasstreeDomain rsClasstreeDomain = new RsClasstreeDomain();
        rsClasstreeDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
        rsClasstreeDomain.setClasstreeParentcode(classtreeParentcode);
        rsClasstreeDomain.setClasstreeLast(classtreeLast);
        rsClasstreeDomain.setClasstreeType(classtreeType);
        if ("1".equals(level)) {
            rsClasstreeDomain.setClasstreeName(rsResourceGoodsDomain.getOneClasstreeName());
            rsClasstreeDomain.setClasstreeEocode(rsResourceGoodsDomain.getOneClasstreeCode());
        } else if ("2".equals(level)) {
            rsClasstreeDomain.setClasstreeName(rsResourceGoodsDomain.getSecondClasstreeName());
            rsClasstreeDomain.setClasstreeEocode(rsResourceGoodsDomain.getSecondClasstreeCode());
        } else if ("3".equals(level)) {
            rsClasstreeDomain.setClasstreeEocode(rsResourceGoodsDomain.getClasstreeCode());
            rsClasstreeDomain.setClasstreeName(rsResourceGoodsDomain.getClasstreeName());
        }
        return rsClasstreeDomain;
    }

    private RsResourceGoodsReDomain checkResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("goodsClass", rsResourceGoodsDomain.getGoodsClass());
        paramsMap.put("goodsEocode", rsResourceGoodsDomain.getGoodsEocode());
        paramsMap.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        paramsMap.put("startRow", 0);
        paramsMap.put("rows", 1);
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsDomainQueryResult = this.queryRsResourceGoodsPage(paramsMap);
        if (rsResourceGoodsDomainQueryResult == null || ListUtil.isEmpty((Collection)rsResourceGoodsDomainQueryResult.getList())) {
            return null;
        }
        return (RsResourceGoodsReDomain)rsResourceGoodsDomainQueryResult.getList().get(0);
    }

    protected String saveNewEsResourceGoodsDomain(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null == rsResourceGoodsDomain) {
            logger.error(this.SYS_CODE + ".saveNewEsResourceGoodsDomain.rsResourceGoodsDomain");
            return null;
        }
        HashMap<String, String> goodsparamMap = new HashMap<String, String>();
        ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
        goodsList.add(rsResourceGoodsDomain);
        goodsparamMap.put("goodsList", JsonUtil.buildNormalBinder().toJson(goodsList));
        return this.internalInvoke(RESOURCEGOODS_ADD_CODE, goodsparamMap);
    }

    public static void main(String[] args) {
    }

    public UmUserinfoDomainBean getPlatCode(String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoQuality", "plat");
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl("um.user.queryUserinfoPage", invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            logger.error(this.SYS_CODE + ".getPlatCode", (Object)((Object)invokeMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }
}

