/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import cn.hutool.core.lang.Console;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.inv.AccessTokenResponse;
import com.yqbsoft.laser.service.ext.bus.data.domain.inv.Content;
import com.yqbsoft.laser.service.ext.bus.data.domain.inv.InvInvlist;
import com.yqbsoft.laser.service.ext.bus.data.domain.inv.InvInvlistGoods;
import com.yqbsoft.laser.service.ext.bus.data.domain.inv.InvUserinv;
import com.yqbsoft.laser.service.ext.bus.data.domain.inv.InvoiceDetail;
import com.yqbsoft.laser.service.ext.bus.data.domain.inv.Order;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.inv.EsbInvoiceRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.inv.EsbInvoiceResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusInvoiceService;
import com.yqbsoft.laser.service.ext.bus.data.supbase.InvoiceBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.OkhttpsUtils;
import com.yqbsoft.laser.service.ext.bus.data.util.SignHelper;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import org.springframework.beans.factory.annotation.Autowired;

public class BusInvoiceServiceImpl
extends InvoiceBaseService
implements BusInvoiceService {
    private String SYS_CODE = "busdata.BusEsbServiceImpl";
    private static final String NuonuoTaxnum = "NuonuoTaxnum";
    private static final String NuonuoAppKey = "NuonuoAppKey";
    private static final String NuonuoAppSecret = "NuonuoAppSecret";
    private static final String EsbKey = "EsbKey";
    private static final String EsbSecret = "EsbSecret";
    private static final String NuonuoUrl = "NuonuoUrl";
    private static final String NuonuoClerk = "NuonuoClerk";
    private static final String NuonuoSalerTel = "NuonuoSalerTel";
    private static final String NuonuoSalerAddress = "NuonuoSalerAddress";
    private static final String NuonuoTaxRate = "NuonuoTaxRate";
    private static final String NuonuoPushMode = "NuonuoPushMode";
    private static final String NuonuoExtensionNumber = "NuonuoExtensionNumber";
    private static final String NuonuoInvoiceLine = "NuonuoInvoiceLine";
    private static final String strDateFormat = "yyyy-MM-dd HH:mm:ss";
    private static final SupperLogUtil logger = new SupperLogUtil(BusInvoiceServiceImpl.class);
    @Autowired
    Esbfacade esbfacade;
    @Autowired
    OkhttpsUtils okhttpsUtils;

    @Override
    public String sendInvoice(InvInvlist invInvlist) {
        logger.error(this.SYS_CODE + ".sendInvoice.invInvlist", (Object)JsonUtil.buildNormalBinder().toJson((Object)invInvlist));
        if (null == invInvlist) {
            logger.error(this.SYS_CODE + ".sendInvoice.invInvlist.null");
            return null;
        }
        List<InvInvlistGoods> invInvlistGoodsList = this.queryInvlistGoodsPage(invInvlist.getTenantCode(), invInvlist.getInvlistCode());
        if (ListUtil.isEmpty(invInvlistGoodsList)) {
            logger.error(this.SYS_CODE + ".sendInvoice.invInvlistGoodsList.null", (Object)(invInvlist.getTenantCode() + "=======" + invInvlist.getInvlistCode()));
            return null;
        }
        logger.error(this.SYS_CODE + ".sendInvoice.invInvlistGoodsList", (Object)JsonUtil.buildNormalBinder().toJson(invInvlistGoodsList));
        String taxnum = this.getDdFlag(invInvlist.getTenantCode(), NuonuoTaxnum, NuonuoTaxnum);
        String appKey = this.getDdFlag(invInvlist.getTenantCode(), NuonuoAppKey, NuonuoAppKey);
        String appSecret = this.getDdFlag(invInvlist.getTenantCode(), NuonuoAppSecret, NuonuoAppSecret);
        String esbKey = this.getDdFlag(invInvlist.getTenantCode(), EsbKey, EsbKey);
        String esbSecret = this.getDdFlag(invInvlist.getTenantCode(), EsbSecret, EsbSecret);
        String url = this.getDdFlag(invInvlist.getTenantCode(), NuonuoUrl, NuonuoUrl);
        String clerk = this.getDdFlag(invInvlist.getTenantCode(), NuonuoClerk, NuonuoClerk);
        String salerTel = this.getDdFlag(invInvlist.getTenantCode(), NuonuoSalerTel, NuonuoSalerTel);
        String salerAddress = this.getDdFlag(invInvlist.getTenantCode(), NuonuoSalerAddress, NuonuoSalerAddress);
        String taxRate = this.getDdFlag(invInvlist.getTenantCode(), NuonuoTaxRate, NuonuoTaxRate);
        String pushMode = this.getDdFlag(invInvlist.getTenantCode(), NuonuoPushMode, NuonuoPushMode);
        String extensionNumber = this.getDdFlag(invInvlist.getTenantCode(), NuonuoExtensionNumber, NuonuoExtensionNumber);
        String invoiceLine = this.getDdFlag(invInvlist.getTenantCode(), NuonuoInvoiceLine, NuonuoInvoiceLine);
        BigDecimal add = new BigDecimal(1).add(new BigDecimal(taxRate));
        InvUserinv invUserinv = this.getUserinvByCode(invInvlist.getTenantCode(), invInvlist.getUserinvCode());
        logger.error(this.SYS_CODE + ".sendInvoice.invUserinv", (Object)JsonUtil.buildNormalBinder().toJson((Object)invUserinv));
        Content content = new Content();
        Order order = new Order();
        if (StringUtils.isNotBlank((String)extensionNumber)) {
            order.setExtensionNumber(extensionNumber);
        }
        order.setBuyerName(invUserinv.getUserinvMember());
        order.setBuyerTaxNum(invUserinv.getUserinvNo());
        if (StringUtils.isNotBlank((String)invUserinv.getUserinvBankname()) && StringUtils.isNotBlank((String)invUserinv.getUserinvBankno())) {
            order.setBuyerAccount(invUserinv.getUserinvBankname() + invUserinv.getUserinvBankno());
        }
        String buyerAddress = "";
        if (StringUtils.isNotBlank((String)invUserinv.getProvinceName())) {
            buyerAddress = buyerAddress + invUserinv.getProvinceName();
        }
        if (StringUtils.isNotBlank((String)invUserinv.getCityName())) {
            buyerAddress = buyerAddress + invUserinv.getCityName();
        }
        if (StringUtils.isNotBlank((String)invUserinv.getAreaName())) {
            buyerAddress = buyerAddress + invUserinv.getAreaName();
        }
        if (StringUtils.isNotBlank((String)invUserinv.getRoadName())) {
            buyerAddress = buyerAddress + invUserinv.getRoadName();
        }
        if (StringUtils.isNotBlank((String)invUserinv.getUserinvUadd())) {
            buyerAddress = buyerAddress + invUserinv.getUserinvUadd();
        }
        order.setBuyerAddress(buyerAddress);
        order.setBuyerTel(invUserinv.getUserinvPhone());
        order.setSalerTaxNum(taxnum);
        order.setSalerTel(salerTel);
        order.setSalerAddress(salerAddress);
        order.setOrderNo(invInvlist.getInvlistOpcode());
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(strDateFormat);
        order.setInvoiceDate(sdf.format(date));
        order.setClerk(clerk);
        order.setBuyerPhone(invUserinv.getUserinvUphone());
        order.setEmail(invUserinv.getUserinvUeamil());
        order.setInvoiceType("1");
        order.setTerminalNumber("");
        if (StringUtils.isNotBlank((String)pushMode) && (pushMode.equals("1") || pushMode.equals("2")) && StringUtils.isNotBlank((String)order.getBuyerPhone())) {
            order.setPushMode(pushMode);
        }
        if (StringUtils.isNotBlank((String)pushMode) && (pushMode.equals("0") || pushMode.equals("2")) && StringUtils.isNotBlank((String)order.getEmail())) {
            order.setPushMode(pushMode);
        }
        ArrayList<InvoiceDetail> invoiceDetail = new ArrayList<InvoiceDetail>();
        for (InvInvlistGoods invInvlistGoods : invInvlistGoodsList) {
            InvoiceDetail invoiceDetail1 = new InvoiceDetail();
            invoiceDetail1.setGoodsName(invInvlistGoods.getGoodsName());
            BigDecimal taxExcludedAmount = invInvlistGoods.getContractGoodsMoney();
            invoiceDetail1.setPrice(String.valueOf(taxExcludedAmount.divide(invInvlistGoods.getGoodsNum(), 2, 4)));
            invoiceDetail1.setNum(String.valueOf(invInvlistGoods.getGoodsNum()));
            invoiceDetail1.setTaxRate(taxRate);
            invoiceDetail1.setWithTaxFlag("1");
            invoiceDetail.add(invoiceDetail1);
        }
        OcContractReDomain orderByCode = this.getOrderByCode(invInvlist.getInvlistOpcode(), invInvlist.getTenantCode());
        if (null != orderByCode && null != orderByCode.getGoodsLogmoney() && orderByCode.getGoodsLogmoney().compareTo(BigDecimal.ZERO) > 0) {
            InvoiceDetail invoiceDetail1 = new InvoiceDetail();
            invoiceDetail1.setGoodsName("\u4ef7\u5916\u8d39\u7528");
            BigDecimal taxExcludedAmount = orderByCode.getGoodsLogmoney();
            invoiceDetail1.setPrice(String.valueOf(taxExcludedAmount));
            invoiceDetail1.setNum("1");
            invoiceDetail1.setTaxRate(taxRate);
            invoiceDetail1.setWithTaxFlag("1");
            invoiceDetail.add(invoiceDetail1);
        }
        order.setInvoiceDetail(invoiceDetail);
        content.setOrder(order);
        String contentJson = JsonUtil.buildNormalBinder().toJson((Object)content);
        logger.error(this.SYS_CODE + ".sendInvoice.content:", (Object)contentJson);
        EsbInvoiceRequest ocInvoiceRequest = new EsbInvoiceRequest();
        ocInvoiceRequest.setAppKey(appKey);
        ocInvoiceRequest.setClientsecret(esbSecret);
        ocInvoiceRequest.setClientid(esbKey);
        ocInvoiceRequest.setHost(url);
        ocInvoiceRequest.setAppSecret(appSecret);
        ocInvoiceRequest.setTaxnum(taxnum);
        ocInvoiceRequest.setContentJson(contentJson);
        EsbInvoiceResponse ocContractResponse = this.esbfacade.execute(ocInvoiceRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.ocContractResponse");
            return "error";
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendInvoice.ocContractResponse", (Object)ocContractResponse.getMsg());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("invlistDatastr", ocContractResponse.getDataObj());
            this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), 4, 0, map);
            return ocContractResponse.getMsg();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invlistDatastr", ocContractResponse.getDataObj());
        this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), 1, 0, map);
        return "success";
    }

    @Override
    public String sendPromotionReviewToOa(InvInvlist invInvlist) throws ApiException {
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String accessInvoiceFromYongyou(String invoiceCode) throws ApiException {
        String accessToken = null;
        try {
            accessToken = this.getAccessTokenFromYongyou();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("slfphm", invoiceCode);
        params.put("taxpdf", "1");
        String requestUrl = this.getDdFlag(ComConstants.tenantCode, "AkanYongyouDomain", "AkanYongyouDomain") + "/iuap-api-gateway" + "/yonbip/tax/output-tax/api/einvoice/getbsfile";
        HashMap<String, String> heads = new HashMap<String, String>();
        requestUrl = requestUrl + "?access_token=" + accessToken;
        String data = null;
        try {
            data = this.okhttpsUtils.doPost(requestUrl, JsonUtil.buildNormalBinder().toJson(params), heads, "busdata.busInvoice.accessInvoiceFromYongyou");
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".accessInvoiceFromYongyou.isnull" + requestUrl, (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".accessInvoiceFromYongyou.data" + data + "url" + requestUrl);
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".accessInvoiceFromYongyou.returnResultsMap" + requestUrl, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            String code1 = (String)code;
            if ("200".equals(code1)) {
                String base64File;
                String dataJson = JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data"));
                Map returnResultsMap1 = JsonUtil.buildNonDefaultBinder().getJsonToMap(dataJson, String.class, Object.class);
                if (returnResultsMap1 == null || (base64File = (String)returnResultsMap1.get("taxpdf")) == null) return "";
                return base64File;
            }
            logger.error(this.SYS_CODE + ".accessInvoiceFromYongyou.code" + requestUrl, (Object)returnResultsMap.toString());
            return null;
        }
        logger.error(this.SYS_CODE + ".accessInvoiceFromYongyou.code.1" + requestUrl, (Object)returnResultsMap.toString());
        return null;
    }

    public String getAccessTokenFromYongyou() throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        String appsecret;
        if (SupDisUtil.get((String)"YY_accessToken") != null) {
            return SupDisUtil.get((String)"YY_accessToken");
        }
        String appKey = this.getDdFlag(ComConstants.tenantCode, "AkanYongyouAppkey", "AkanYongyouAppkey");
        AccessTokenResponse response = this.requestForAccessTokenV2FromYongyou(appKey, appsecret = this.getDdFlag(ComConstants.tenantCode, "AkanYongyouAppsecret", "AkanYongyouAppsecret"));
        if (response != null && response.getAccessToken() != null) {
            long expire = response.getExpire();
            SupDisUtil.set((String)"YY_accessToken", (String)response.getAccessToken(), (int)Math.toIntExact(expire));
        }
        logger.info("\u6210\u529f\u83b7\u5f97\u8bbf\u95ee\u4ee4\u724c: appkey: " + appKey + ", access_token: " + response.getAccessToken() + ", expire in: " + response.getExpire());
        return response.getAccessToken();
    }

    public AccessTokenResponse requestForAccessTokenV2FromYongyou(String appKey, String appSecret) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appKey", appKey);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        String signature = SignHelper.sign(params, appSecret);
        params.put("signature", signature);
        String requestUrl = this.getDdFlag(ComConstants.tenantCode, "AkanYongyouDomain", "AkanYongyouDomain") + "/iuap-api-auth/open-auth" + "/selfAppAuth/getAccessToken";
        HashMap<String, String> heads = new HashMap<String, String>();
        String param = "";
        param = param + "appKey=" + (String)params.get("appKey") + "&timestamp=" + (String)params.get("timestamp") + "&signature=" + (String)params.get("signature");
        String data = null;
        try {
            data = OkhttpsUtils.doGet(requestUrl, param, heads);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".requestForAccessTokenV2FromYongyou.isnull" + requestUrl, (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".requestForAccessTokenV2FromYongyou.data" + data + "url" + requestUrl);
        Map returnResultsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".requestForAccessTokenV2FromYongyou.returnResultsMap" + requestUrl, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code) {
            String code1 = (String)code;
            if ("00000".equals(code1)) {
                String dataJson = JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data"));
                AccessTokenResponse accessTokenResponse = (AccessTokenResponse)JsonUtil.buildNonDefaultBinder().getJsonToObject(dataJson, AccessTokenResponse.class);
                System.out.println(accessTokenResponse);
                return accessTokenResponse;
            }
            logger.error(this.SYS_CODE + ".requestForAccessTokenV2FromYongyou.code" + requestUrl, (Object)returnResultsMap.toString());
            return null;
        }
        logger.error(this.SYS_CODE + ".requestForAccessTokenV2FromYongyou.code.1" + requestUrl, (Object)returnResultsMap.toString());
        return null;
    }

    private String getTOaToken() throws Exception {
        HashMap<String, String> heads = new HashMap<String, String>();
        String secret = BusInvoiceServiceImpl.encrypt("0e6439cc-9f84-42b0-a676-fefcb6587b7d");
        heads.put("appid", "0e6439cc-9f84-42b0-a676-fefcb6587b7d");
        heads.put("secret", secret);
        String data = null;
        try {
            JSONObject res;
            data = ((HttpRequest)((HttpRequest)HttpRequest.post((String)"http://58.247.90.118:8090/api/ec/dev/auth/applytoken").header("appid", "0e6439cc-9f84-42b0-a676-fefcb6587b7d")).header("secret", secret)).form(new HashMap()).timeout(20000).execute().body();
            Console.log((Object)data);
            if (data != null && "true".equals((res = JSON.parseObject((String)data)).getString("status"))) {
                return res.getString("token");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApiException(".sendRecharge.ex1", (Throwable)e);
        }
        return null;
    }

    public static String encrypt(String plainText) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, BusInvoiceServiceImpl.getPublicKey("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA7A+ULq+P6UYXPb/8Xf8Qip/XghaopLBFgRoVovAjufp29L/jYZZyhVhYM5LYq+TaDVaIIYYJELxYABKoITwDR5dvPMJCr9X98ezleaAULtWGF1QwXhGBdTdMru7o8oQ8clMGAlUCemd7jo5uLaeiE8cX4dWM2HendMCZTeL5lHTzK5u1SkkGbdNip7u2CcPd6WgDiqMTV/3CFcha2tg4SyUkxepF6TiNEc4F9fBXUJsyeSJ5V4gVDMHrtnuEy15uz5lE1bZYLcbrYneMLiZvrFeenL5bpGJmdBKAZKoGszKxp1YU3kw7Dzur7OYufXN+CpwG+Aai7tsIe1HnAG/WEQIDAQAB"));
        byte[] encryptedBytes = cipher.doFinal(plainText.getBytes());
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public static PublicKey getPublicKey(String publicKeyBase64) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(publicKeyBase64);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(keySpec);
    }
}

