/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.asd.facade.http;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RequestUtils {
    static RestTemplate restTemplate;
    private static Object lock;

    public static String postForEntity(String url, MediaType mediaType, Map<String, Object> paramMap, Map<String, String> apiHeader) throws IOException {
        String response;
        HttpHeaders headers = RequestUtils.getHttpHeaders();
        headers.setContentType(mediaType);
        if (MapUtil.isNotEmpty(apiHeader)) {
            for (String string : apiHeader.keySet()) {
                headers.add(string, apiHeader.get(string));
            }
        }
        LinkedMultiValueMap postParameters = new LinkedMultiValueMap();
        if (MapUtil.isNotEmpty(paramMap)) {
            for (String headerKey : paramMap.keySet()) {
                postParameters.add((Object)headerKey, paramMap.get(headerKey));
            }
        }
        HttpEntity httpEntity = new HttpEntity((Object)postParameters, (MultiValueMap)headers);
        try {
            response = (String)RequestUtils.getRestTemplate().postForEntity(url, (Object)httpEntity, String.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            throw new ApiException("RequestUtils.postForEntity", url, (Throwable)e);
        }
        return response;
    }

    public static Map<String, Object> getForEntity(String url, MediaType mediaType, Map<String, Object> paramMap, Map<String, String> apiHeader) {
        HttpHeaders headers = RequestUtils.getHttpHeaders();
        headers.setContentType(mediaType);
        if (MapUtil.isNotEmpty(apiHeader)) {
            for (String string : apiHeader.keySet()) {
                headers.add(string, apiHeader.get(string));
            }
        }
        LinkedMultiValueMap postParameters = new LinkedMultiValueMap();
        if (MapUtil.isNotEmpty(paramMap)) {
            for (String headerKey : paramMap.keySet()) {
                postParameters.add((Object)headerKey, paramMap.get(headerKey));
            }
        }
        HttpEntity httpEntity = new HttpEntity((Object)postParameters, (MultiValueMap)headers);
        Map response = (Map)RequestUtils.getRestTemplate().postForEntity(url, (Object)httpEntity, Map.class, new Object[0]).getBody();
        return response;
    }

    public static void setRestTemplate(RestTemplate restTemplate) {
        RequestUtils.restTemplate = restTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RestTemplate getRestTemplate() {
        if (null == restTemplate) {
            Object object = lock;
            synchronized (object) {
                if (null == restTemplate) {
                    RequestUtils.setRestTemplate(new RestTemplate(RequestUtils.httpRequestFactory()));
                }
            }
        }
        return restTemplate;
    }

    public static ClientHttpRequestFactory httpRequestFactory() {
        return new HttpComponentsClientHttpRequestFactory(RequestUtils.httpClient());
    }

    public static HttpClient httpClient() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(600L, TimeUnit.SECONDS);
        connectionManager.setMaxTotal(3000);
        connectionManager.setDefaultMaxPerRoute(1000);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(50000).setConnectTimeout(10000).setConnectionRequestTimeout(10000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy()).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(3, true)).build();
    }

    public static HttpHeaders getHttpHeaders() {
        return new HttpHeaders();
    }

    static {
        lock = new Object();
    }
}

