/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.asd.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.asd.domain.dis.DisChannelReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.oc.OcContractDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.oc.OcContractproDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.rs.RsGoodsRelReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.sg.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.sg.SgSendgoodsLogReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.sg.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.sg.SgSendgoodsSettlDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.um.UmAddressReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.wh.WhGoodsBean;
import com.yqbsoft.laser.service.ext.channel.asd.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.channel.asd.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.inv.GoodsStockRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.oc.OcContractRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.oc.OcEsbContractRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.oc.OcRefundRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.oc.OcSapContractRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.ro.RoRetailOrderRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.sg.SgSendgoodsLogRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.sg.SgSendgoodsRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.wh.WhFreightFeeRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.wh.WhStockStateFeeRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.inv.GoodsStockResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.oc.EsbContractResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.oc.OcRefundResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.oc.SapContractResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.ro.RoRetailOrderResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.sg.SgSendgoodsLogResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.sg.SgSendgoodsResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.wh.WhFreightFeeResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.wh.WhStockStateResponse;
import com.yqbsoft.laser.service.ext.channel.asd.service.BusOrderService;
import com.yqbsoft.laser.service.ext.channel.asd.supbase.OrderBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BusOrderServiceImpl
extends OrderBaseService
implements BusOrderService {
    private String SYS_CODE = "asddata.BusOrderServiceImpl";
    private String SYS_CODE_YZ = "asddata.BusOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusOrderServiceImpl.class);
    private String ddcode = "order";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusOrder(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractDomain");
            return "error";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        OcContractRequest ocContractRequest = new OcContractRequest();
        ocContractRequest.init(this.getDdMap(tenantCode, this.ddcode, "asddata"));
        this.makeOcContractReDomain(ocContractDomain);
        ocContractRequest.setOrgTenantCode(ocContractDomain.getTenantCode());
        String t = this.getTenantCodeBuUrl(ocContractRequest.getHost());
        if (StringUtils.isNotBlank((String)t)) {
            ocContractDomain.setTenantCode(t);
        }
        ocContractRequest.getSendMap().put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        logger.info(this.SYS_CODE + ".sendSaveExGoods.req", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        String s = this.restTempfacade.internalInvoke("app.exOrder.sendSaveExOrder", paramMap);
        logger.info(this.SYS_CODE + ".sendSaveExGoods.res", (Object)s);
        return "success";
    }

    @Override
    public String getFreight(List<WhGoodsBean> whGoodsBeanList, String areaStr, String memberCode, String tenantCode) throws ApiException {
        if (ListUtil.isEmpty(whGoodsBeanList) || StringUtils.isBlank((String)areaStr) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getFreight.param");
            return "error";
        }
        WhFreightFeeRequest whFreightFeeRequest = new WhFreightFeeRequest();
        whFreightFeeRequest.init(this.getDdMap(tenantCode, this.ddcode, "asddata"));
        whFreightFeeRequest.setOrgTenantCode(tenantCode);
        String t = this.getTenantCodeBuUrl(whFreightFeeRequest.getHost());
        if (StringUtils.isBlank((String)t)) {
            t = tenantCode;
        }
        whFreightFeeRequest.getSendMap().put("whGoodsBeanList", JsonUtil.buildNormalBinder().toJson(whGoodsBeanList));
        whFreightFeeRequest.getSendMap().put("areaStr", areaStr);
        whFreightFeeRequest.getSendMap().put("memberCode", memberCode);
        whFreightFeeRequest.getSendMap().put("tenantCode", tenantCode);
        WhFreightFeeResponse whFreightFeeResponse = this.restTempfacade.execute(whFreightFeeRequest);
        if (null == whFreightFeeResponse) {
            logger.error(this.SYS_CODE + ".getFreight.whFreightFeeResponse");
            return "error";
        }
        if (!whFreightFeeResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".getFreight.whFreightFeeResponsemsg", (Object)whFreightFeeResponse.getMsg());
            return whFreightFeeResponse.getMsg();
        }
        return whFreightFeeResponse.getFreightFee().toString();
    }

    @Override
    public List<WhGoodsBean> getNewStockById(List<WhGoodsBean> whGoodsBeanList, String areaStr, String memberCode, String tenantCode) throws ApiException {
        if (ListUtil.isEmpty(whGoodsBeanList) || StringUtils.isBlank((String)areaStr) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getNewStockById.param");
            return null;
        }
        WhStockStateFeeRequest whStockStateFeeRequest = new WhStockStateFeeRequest();
        whStockStateFeeRequest.init(this.getDdMap(tenantCode, this.ddcode, "asddata"));
        whStockStateFeeRequest.setOrgTenantCode(tenantCode);
        String t = this.getTenantCodeBuUrl(whStockStateFeeRequest.getHost());
        if (StringUtils.isBlank((String)t)) {
            t = tenantCode;
        }
        whStockStateFeeRequest.getSendMap().put("whGoodsBeanList", JsonUtil.buildNormalBinder().toJson(whGoodsBeanList));
        whStockStateFeeRequest.getSendMap().put("areaStr", areaStr);
        whStockStateFeeRequest.getSendMap().put("memberCode", memberCode);
        whStockStateFeeRequest.getSendMap().put("tenantCode", tenantCode);
        WhStockStateResponse whStockStateResponse = this.restTempfacade.execute(whStockStateFeeRequest);
        if (null == whStockStateResponse) {
            logger.error(this.SYS_CODE + ".getNewStockById.whStockStateResponse");
            return null;
        }
        if (!whStockStateResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".getNewStockById.whStockStateResponse", (Object)whStockStateResponse.getMsg());
            return null;
        }
        return whStockStateResponse.getWhGoodsBeanList();
    }

    @Override
    public String getRetailOrderList(String access_token, String biz_Content, String PageIndex) {
        if (StringUtils.isBlank((String)access_token) || StringUtils.isBlank((String)biz_Content) || StringUtils.isBlank((String)PageIndex)) {
            logger.error(this.SYS_CODE_YZ + ".getRetailOrderList.param");
            return null;
        }
        WhStockStateFeeRequest whStockStateFeeRequest = new WhStockStateFeeRequest();
        whStockStateFeeRequest.init(this.getDdMap("732452492612382786", this.ddcode, "asddata"));
        String method = this.getDdFlag("732452492612382786", "GetYZOrderList", "GetYZOrderList");
        if (StringUtils.isBlank((String)method)) {
            logger.error(null, (Object)(this.SYS_CODE_YZ + ".getRetailOrderList.\u7f13\u5b58\u8bfb\u53d6\u914d\u7f6e\u5931\u8d25.method"));
            method = "RetailExt.GetOrderList";
        }
        Esbfacade invoicefacade = new Esbfacade("", null, null, null);
        RoRetailOrderRequest retailOrderRequest = new RoRetailOrderRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        retailOrderRequest.setBizcontent(biz_Content);
        retailOrderRequest.setMap(map);
        retailOrderRequest.setOutsideApiUrl(method);
        retailOrderRequest.setClientid(null);
        retailOrderRequest.setClientsecret(null);
        RoRetailOrderResponse retailOrderResponse = invoicefacade.executeDoGet(retailOrderRequest);
        if (null == retailOrderResponse) {
            logger.error(this.SYS_CODE_YZ + ".getRetailOrderList.retailOrderResponse");
            return "error";
        }
        Map<String, Object> dataObjMap = retailOrderResponse.getDataObjMap();
        String httpCacheCode = (String)dataObjMap.get("HttpCacheCode");
        if (StringUtils.isBlank((String)httpCacheCode)) {
            logger.error(this.SYS_CODE_YZ + ".getRetailOrderList.api.param2");
            return this.makeErrorReturn((String)dataObjMap.get("errcode"), (String)dataObjMap.get("errmsg"));
        }
        String method_page = this.getDdFlag("732452492612382786", "GetYZCachePage", "GetYZCachePage");
        if (StringUtils.isBlank((String)method_page)) {
            logger.error(null, (Object)(this.SYS_CODE_YZ + ".getRetailOrderList.\u7f13\u5b58\u8bfb\u53d6\u914d\u7f6e\u5931\u8d25.method_page"));
            method_page = "VipCardExt.GetHttpCachePageData";
        }
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("HttpCacheCode", httpCacheCode);
        content.put("PageIndex", PageIndex);
        retailOrderRequest.setBizcontent(JsonUtil.buildNormalBinder().toJson(content));
        retailOrderRequest.setOutsideApiUrl(method_page);
        retailOrderResponse = invoicefacade.executeDoGet(retailOrderRequest);
        if (null == retailOrderResponse) {
            logger.error(this.SYS_CODE_YZ + ".getRetailOrderList.retailOrderResponse");
            return "error";
        }
        return retailOrderResponse.getMsg();
    }

    @Override
    public String sendCancelRetailOrder(SgSendgoodsReDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE_YZ + ".sendCancelRetailOrder", (Object)"isnull");
            return "error";
        }
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getTenantCode())) {
            logger.error(sgSendgoodsDomain.getTenantCode(), (Object)(this.SYS_CODE_YZ + ".sendCancelRetailOrder.params.TenantCode\u4e3a\u7a7a"));
            return this.makeErrorReturn(sgSendgoodsDomain.getTenantCode(), "\u53c2\u6570\u6709\u8bef");
        }
        WhStockStateFeeRequest whStockStateFeeRequest = new WhStockStateFeeRequest();
        whStockStateFeeRequest.init(this.getDdMap(sgSendgoodsDomain.getTenantCode(), this.ddcode, "asddata"));
        String method = this.getDdFlag(sgSendgoodsDomain.getTenantCode(), "sendCancelRetailOrder", "cancelRetailOrder");
        if (StringUtils.isBlank((String)method)) {
            logger.error(null, (Object)(this.SYS_CODE_YZ + ".sendCancelRetailOrder.\u7f13\u5b58\u8bfb\u53d6\u914d\u7f6e\u5931\u8d25.method"));
            method = "RetailExt.CancelOrder";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String format = simpleDateFormat.format(sgSendgoodsDomain.getGmtCreate());
        params.put("fOptDateStr", format);
        params.put("fInnerBillNo", sgSendgoodsDomain.getContractBillcode());
        params.put("fPayGUID", sgSendgoodsDomain.getContractBillcode());
        Esbfacade invoicefacade = new Esbfacade("", null, null, null);
        RoRetailOrderRequest retailOrderRequest = new RoRetailOrderRequest();
        retailOrderRequest.setBizcontent(JsonUtil.buildNormalBinder().toJson(params));
        retailOrderRequest.setOutsideApiUrl(method);
        RoRetailOrderResponse retailOrderResponse = invoicefacade.executeDoGet(retailOrderRequest);
        if (null == retailOrderResponse) {
            logger.error(this.SYS_CODE_YZ + ".sendCancelRetailOrder.retailOrderResponse");
            return "error";
        }
        return retailOrderResponse.getMsg();
    }

    @Override
    public String sendSaveRetailOrder(SgSendgoodsReDomain sgSendgoodsDomain) {
        List<SgSendgoodsGoodsDomain> goodsList;
        if (sgSendgoodsDomain == null) {
            logger.error(this.SYS_CODE + ".sendSaveRetailOrder.params");
            return this.makeErrorReturn(null, "\u53c2\u6570\u4e3a\u7a7a");
        }
        logger.error(this.SYS_CODE + ".sgSendgoodsDomain.", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        Esbfacade invoicefacade = new Esbfacade("", null, null, null);
        WhStockStateFeeRequest whStockStateFeeRequest = new WhStockStateFeeRequest();
        whStockStateFeeRequest.init(this.getDdMap(sgSendgoodsDomain.getTenantCode(), this.ddcode, "asddata"));
        String method = this.getDdFlag(sgSendgoodsDomain.getTenantCode(), "sendSaveRetailOrder", "sendSaveRetailOrder");
        if (StringUtils.isBlank((String)method)) {
            logger.error(this.SYS_CODE_YZ + ".insertRetailOrder.\u7f13\u5b58\u8bfb\u53d6\u914d\u7f6e\u5931\u8d25.method");
            method = "RetailExt.sendSaveRetailOrder";
        }
        RoRetailOrderRequest retailOrderRequest = new RoRetailOrderRequest();
        HashMap<String, Object> biz_Content = new HashMap<String, Object>();
        biz_Content.put("fBillNo", sgSendgoodsDomain.getContractBillcode());
        if (null != sgSendgoodsDomain.getSendgoodsVaildate()) {
            biz_Content.put("fOptDateTime", sgSendgoodsDomain.getSendgoodsVaildate());
        }
        if (null != sgSendgoodsDomain.getSendgoodsSddate()) {
            biz_Content.put("fDistillTime", sgSendgoodsDomain.getSendgoodsSddate());
        }
        biz_Content.put("fDeliverMode", sgSendgoodsDomain.getContractPumode());
        biz_Content.put("fShopNo", sgSendgoodsDomain.getMemberBname());
        biz_Content.put("fReserveShopNo", sgSendgoodsDomain.getMemberBcode());
        biz_Content.put("fAddress", sgSendgoodsDomain.getGoodsReceiptArrdess());
        biz_Content.put("fClientName", sgSendgoodsDomain.getMemberBname());
        biz_Content.put("fPhone", sgSendgoodsDomain.getGoodsReceiptPhone());
        biz_Content.put("fState", sgSendgoodsDomain.getDataState());
        biz_Content.put("fAssistSign", sgSendgoodsDomain.getDataOpnextbillstate());
        biz_Content.put("fSourceType", sgSendgoodsDomain.getGoodsClass());
        if (null != sgSendgoodsDomain.getDataBmoney()) {
            biz_Content.put("fPayMoney", sgSendgoodsDomain.getDataBmoney());
        }
        biz_Content.put("fPayModeNo", sgSendgoodsDomain.getFaccountName());
        List<SgSendgoodsSettlDomain> settlList = sgSendgoodsDomain.getSgSendgoodsSettlDomainList();
        if (null != settlList) {
            ArrayList list = new ArrayList();
            for (SgSendgoodsSettlDomain ocContractSettlDomain : settlList) {
                HashMap<String, Object> map_s = new HashMap<String, Object>();
                if (null != ocContractSettlDomain.getContractSettlPmoney()) {
                    map_s.put("fPayMoney", ocContractSettlDomain.getContractSettlPmoney());
                }
                if (null != ocContractSettlDomain.getContractSettlBlance()) {
                    map_s.put("fPayModeNo", ocContractSettlDomain.getContractSettlBlance());
                }
                list.add(map_s);
            }
            biz_Content.put("fPayMoneyList", JsonUtil.buildNormalBinder().toJson(list));
        } else {
            logger.error(this.SYS_CODE_YZ + ".sendSaveRetailOrder.fPayMoneyList\u4e3a\u7a7a");
        }
        biz_Content.put("fRemark", sgSendgoodsDomain.getSendgoodsRemark());
        if (null != sgSendgoodsDomain.getGoodsLogmoney()) {
            biz_Content.put("fPostFee", sgSendgoodsDomain.getGoodsLogmoney());
        }
        if (null != sgSendgoodsDomain.getMemberBcode()) {
            biz_Content.put("fVipId", sgSendgoodsDomain.getMemberBcode());
        }
        if (null != (goodsList = sgSendgoodsDomain.getSgSendgoodsGoodsDomainList())) {
            ArrayList list = new ArrayList();
            for (SgSendgoodsGoodsDomain ocContractGoodsDomain : goodsList) {
                HashMap<String, Object> ocContractGoodsMap = new HashMap<String, Object>();
                if (null != ocContractGoodsDomain.getSkuBarcode()) {
                    ocContractGoodsMap.put("fBarCode", ocContractGoodsDomain.getSkuBarcode());
                }
                if (null != ocContractGoodsDomain.getSkuCode()) {
                    ocContractGoodsMap.put("fInvId", ocContractGoodsDomain.getSkuCode());
                }
                if (null != ocContractGoodsDomain.getSkuNo()) {
                    ocContractGoodsMap.put("fInvNo", ocContractGoodsDomain.getSkuNo());
                }
                if (null != ocContractGoodsDomain.getGoodsCamount()) {
                    ocContractGoodsMap.put("fBillQty", ocContractGoodsDomain.getGoodsCamount());
                }
                if (null != ocContractGoodsDomain.getPricesetNprice()) {
                    ocContractGoodsMap.put("fMoney", ocContractGoodsDomain.getPricesetNprice());
                }
                if (null != ocContractGoodsDomain.getPricesetNprice()) {
                    ocContractGoodsMap.put("fStdSprice", ocContractGoodsDomain.getPricesetNprice());
                }
                if (null != ocContractGoodsDomain.getPartsnameNumunit()) {
                    ocContractGoodsMap.put("fUnitName", ocContractGoodsDomain.getPartsnameNumunit());
                }
                if (null != ocContractGoodsDomain.getGoodsRemark()) {
                    ocContractGoodsMap.put("fLineRemark", ocContractGoodsDomain.getGoodsRemark());
                }
                if (null != ocContractGoodsDomain.getContractGoodsMoney()) {
                    ocContractGoodsMap.put("fDiscount_amount", ocContractGoodsDomain.getContractGoodsMoney());
                }
                list.add(ocContractGoodsMap);
            }
            biz_Content.put("details", list);
        }
        if (biz_Content == null) {
            logger.error(this.SYS_CODE_YZ + ".\u53c2\u6570\u8f6c\u5316\u9519\u8bef.sendSaveRetailOrder.OcContractGoodsDomain");
            return "error";
        }
        retailOrderRequest.setBizcontent(JsonUtil.buildNormalBinder().toJson(biz_Content));
        retailOrderRequest.setOutsideApiUrl(method);
        RoRetailOrderResponse retailOrderResponse = invoicefacade.executeDoGet(retailOrderRequest);
        if (null == retailOrderResponse) {
            logger.error(this.SYS_CODE_YZ + ".insertRetailOrder.retailOrderResponse");
            return "error";
        }
        return retailOrderResponse.getMsg();
    }

    @Override
    public String sendUpdateOrderState(SgSendgoodsReDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE_YZ + ".UpdateOrderState.retailOrderResponse", (Object)"isnull");
            return "error";
        }
        HashMap<String, Object> biz_Content = new HashMap<String, Object>();
        WhStockStateFeeRequest whStockStateFeeRequest = new WhStockStateFeeRequest();
        whStockStateFeeRequest.init(this.getDdMap(sgSendgoodsDomain.getTenantCode(), this.ddcode, "asddata"));
        String method = this.getDdFlag(sgSendgoodsDomain.getTenantCode(), "UpdateOrderState", "UpdateOrderState");
        if (StringUtils.isBlank((String)method)) {
            logger.error(null, (Object)(this.SYS_CODE_YZ + ".UpdateOrderState.\u7f13\u5b58\u8bfb\u53d6\u914d\u7f6e\u5931\u8d25.method"));
            method = "RetailExt.sendUpdateOrderState";
        }
        if (null == sgSendgoodsDomain.getContractBillcode()) {
            logger.error(null, (Object)(this.SYS_CODE_YZ + ".sendUpdateOrderState.ContractBillcode\u4e3a\u7a7a"));
            return this.makeErrorReturn(null, "\u53c2\u6570\u9519\u8bef\uff01");
        }
        biz_Content.put("fInnerBillNo", sgSendgoodsDomain.getContractBillcode());
        if (null == sgSendgoodsDomain.getDataState()) {
            logger.error(null, (Object)(this.SYS_CODE_YZ + ".sendUpdateOrderState.DataState\u4e3a\u7a7a"));
            return this.makeErrorReturn(null, "\u53c2\u6570\u9519\u8bef\uff01");
        }
        biz_Content.put("fState", sgSendgoodsDomain.getDataState());
        if (null == sgSendgoodsDomain.getGmtCreate()) {
            logger.error(null, (Object)(this.SYS_CODE_YZ + ".sendUpdateOrderState.DataState\u4e3a\u7a7a"));
            return this.makeErrorReturn(null, "\u53c2\u6570\u9519\u8bef\uff01");
        }
        biz_Content.put("fOptDateStr", sgSendgoodsDomain.getGmtCreate());
        Esbfacade invoicefacade = new Esbfacade("", null, null, null);
        RoRetailOrderRequest retailOrderRequest = new RoRetailOrderRequest();
        retailOrderRequest.setBizcontent(JsonUtil.buildNormalBinder().toJson(biz_Content));
        retailOrderRequest.setOutsideApiUrl(method);
        RoRetailOrderResponse retailOrderResponse = invoicefacade.executeDoGet(retailOrderRequest);
        if (null == retailOrderResponse) {
            logger.error(this.SYS_CODE_YZ + ".sendUpdateOrderState.retailOrderResponse", null);
            return "error";
        }
        return "success";
    }

    @Override
    public String getGoodsStock(String access_token, String biz_Content) {
        if (StringUtils.isBlank((String)access_token) || StringUtils.isBlank((String)biz_Content)) {
            logger.error(this.SYS_CODE_YZ + ".getGoodsStock.param");
            return null;
        }
        Esbfacade invoicefacade = new Esbfacade("", null, null, null);
        WhStockStateFeeRequest whStockStateFeeRequest = new WhStockStateFeeRequest();
        whStockStateFeeRequest.init(this.getDdMap("732452492612382786", this.ddcode, "asddata"));
        String method = this.getDdFlag("732452492612382786", "getGoodsStock", "getGoodsStock");
        if (StringUtils.isBlank((String)method)) {
            logger.error(null, (Object)(this.SYS_CODE_YZ + ".getGoodsStock.\u7f13\u5b58\u8bfb\u53d6\u914d\u7f6e\u5931\u8d25.method"));
            method = "VipCardParty3.qryStock";
        }
        GoodsStockRequest goodsStockRequest = new GoodsStockRequest();
        HashMap map = new HashMap();
        goodsStockRequest.setBizcontent(biz_Content);
        goodsStockRequest.setOutsideApiUrl(method);
        GoodsStockResponse goodsStockResponse = invoicefacade.executeDoGet(goodsStockRequest);
        if (null == goodsStockResponse) {
            logger.error(this.SYS_CODE_YZ + ".getGoodsStock.goodsStockResponse");
            return "error";
        }
        return goodsStockResponse.getMsg();
    }

    private void makeOcContractReDomain(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return;
        }
        String memberCcode = ocContractDomain.getMemberCcode();
        if (StringUtils.isBlank((String)memberCcode)) {
            return;
        }
        DisChannelReDomain disChannelReDomain = this.getDisChannelByMemberCcode(memberCcode, ocContractDomain.getTenantCode());
        if (null == disChannelReDomain) {
            return;
        }
        ocContractDomain.setChannelCode(disChannelReDomain.getChannelOcode());
    }

    @Override
    public String sendSaveBusRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund.ocRefundDomain");
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        OcRefundRequest ocRefundRequest = new OcRefundRequest();
        ocRefundRequest.init(this.getDdMap(tenantCode, this.ddcode, "asddata"));
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundRequest, (Object)ocRefundDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.e", (Object)e);
            return "error";
        }
        OcRefundResponse ocRefundResponse = this.restTempfacade.execute(ocRefundRequest);
        if (null == ocRefundResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse");
            return "error";
        }
        if (!ocRefundResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse", (Object)ocRefundResponse.getMsg());
            return ocRefundResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoods.sgSendgoodsDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsDomain.getTenantCode();
        SgSendgoodsRequest sgSendgoodsRequest = new SgSendgoodsRequest();
        sgSendgoodsRequest.init(this.getDdMap(tenantCode, this.ddcode, "asddata"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsRequest, (Object)sgSendgoodsDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Object)e);
            return "error";
        }
        SgSendgoodsResponse sgSendgoodsResponse = this.restTempfacade.execute(sgSendgoodsRequest);
        if (null == sgSendgoodsResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse");
            return "error";
        }
        if (!sgSendgoodsResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse", (Object)sgSendgoodsResponse.getMsg());
            return sgSendgoodsResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoodsLog(SgSendgoodsLogReDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsLogDomain.getTenantCode();
        SgSendgoodsLogRequest sgSendgoodsLogRequest = new SgSendgoodsLogRequest();
        sgSendgoodsLogRequest.init(this.getDdMap(tenantCode, this.ddcode, "asddata"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsLogRequest, (Object)sgSendgoodsLogDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.e", (Object)e);
            return "error";
        }
        SgSendgoodsLogResponse sgSendgoodsLogResponse = this.restTempfacade.execute(sgSendgoodsLogRequest);
        if (null == sgSendgoodsLogResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse");
            return "error";
        }
        if (!sgSendgoodsLogResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse", (Object)sgSendgoodsLogResponse.getMsg());
            return sgSendgoodsLogResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefundToEsb(OcRefundReDomain ocRefundDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusRefundToEsb.ocRefundDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbRefundUrl", "EsbRefundUrl");
        String EsbWarehouseCode = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, String> entryOrder = new HashMap<String, String>();
        entryOrder.put("entryOrderCode", ocRefundDomain.getRefundCode());
        entryOrder.put("orderType", "THRK");
        entryOrder.put("warehouseCode", EsbWarehouseCode);
        entryOrder.put("ownerCode", EsbOwnerCode);
        HashMap orderLines = new HashMap();
        ArrayList orderLineList = new ArrayList();
        List<OcRefundGoodsDomain> refundGoodsList = ocRefundDomain.getOcRefundGoodsDomainList();
        for (OcRefundGoodsDomain goods : refundGoodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocRefundDomain.getTenantCode());
                relmap.put("goodsCode", goods.getGoodsCode());
                relmap.put("goodsRelType", "3");
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("itemCode", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ownerCode", EsbOwnerCode);
                    orderLine.put("itemName", rsGoodsRelReDomain.getGoodsName());
                    orderLine.put("planQty", goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum()));
                    orderLineList.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("ownerCode", EsbOwnerCode);
            orderLine.put("itemName", goods.getGoodsName());
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getRefundGoodsNum());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("entryOrder", entryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefundConfirmToEsb(OcRefundReDomain ocRefundDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusRefundConfirmToEsb.ocRefundDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String KUNNR = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String NAME1 = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbNAME1", "EsbNAME1");
        String LGORT = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocSapContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcRefundGoodsDomain> ocRefundGoodsList = ocRefundDomain.getOcRefundGoodsDomainList();
        String date = BusOrderServiceImpl.getDate();
        int POSEX = 0;
        for (OcRefundGoodsDomain goods : ocRefundGoodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocRefundDomain.getTenantCode());
                relmap.put("goodsCode", goods.getGoodsCode());
                relmap.put("goodsRelType", "3");
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendSaveBusRefundConfirmToEsb.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("BSTKD", ocRefundDomain.getRefundCode());
                    orderLine.put("POSEX", ++POSEX);
                    orderLine.put("AUART", "ZG02");
                    orderLine.put("KUNNR", KUNNR);
                    orderLine.put("NAME1", NAME1);
                    orderLine.put("FKDAT", date);
                    orderLine.put("MATNR", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ARKTX", rsGoodsRelReDomain.getGoodsName());
                    BigDecimal multiply = goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum());
                    orderLine.put("KWMENG", multiply);
                    orderLine.put("ACTPR", rsGoodsRelReDomain.getPricesetNprice());
                    orderLine.put("WRBTR", rsGoodsRelReDomain.getPricesetNprice().multiply(multiply));
                    orderLine.put("WERKS", WERKS);
                    orderLine.put("LGORT", LGORT);
                    list.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocRefundDomain.getRefundCode());
            orderLine.put("POSEX", ++POSEX);
            orderLine.put("AUART", "ZG02");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocSapContractRequest.setMap(map);
        ocSapContractRequest.setClientsecret(esbSecret);
        ocSapContractRequest.setClientid(esbKey);
        ocSapContractRequest.setHost(url);
        SapContractResponse sapContractResponse = invoicefacade.execute(ocSapContractRequest);
        if (null == sapContractResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefundConfirmToEsb.esbContractResponse");
            return "error";
        }
        if (!sapContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainToEsb(OcContractReDomain ocContractDomain) {
        String[] split;
        logger.error(this.SYS_CODE + ".sendContractDomainToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOrderUrl", "EsbOrderUrl");
        String EsbWarehouseCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        String EsbSourcePlatformCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSourcePlatformCode", "EsbSourcePlatformCode");
        String EsbLogisticsCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbLogisticsCode", "EsbLogisticsCode");
        String EsbShopNick = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbShopNick", "EsbShopNick");
        String EsbSenderInfo = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSenderInfo", "EsbSenderInfo");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, Object> deliveryOrder = new HashMap<String, Object>();
        deliveryOrder.put("deliveryOrderCode", ocContractDomain.getContractBillcode());
        deliveryOrder.put("orderType", "XSDD");
        deliveryOrder.put("warehouseCode", EsbWarehouseCode);
        deliveryOrder.put("ownerCode", EsbOwnerCode);
        deliveryOrder.put("sourcePlatformCode", EsbSourcePlatformCode);
        deliveryOrder.put("logisticsCode", EsbLogisticsCode);
        deliveryOrder.put("shopNick", EsbShopNick);
        HashMap orderLines = new HashMap();
        Map senderInfo = new HashMap();
        if (StringUtils.isNotBlank((String)EsbSenderInfo)) {
            senderInfo = (Map)JsonUtil.buildNormalBinder().getJsonToMap(EsbSenderInfo, String.class, Object.class);
            deliveryOrder.put("senderInfo", senderInfo);
        }
        HashMap<String, String> receiverInfo = new HashMap<String, String>();
        receiverInfo.put("name", ocContractDomain.getGoodsReceiptMem());
        receiverInfo.put("mobile", ocContractDomain.getGoodsReceiptPhone());
        if (ListUtil.isNotEmpty(ocContractDomain.getOcContractproDomainList())) {
            for (OcContractproDomain ocContractproDomain : ocContractDomain.getOcContractproDomainList()) {
                String[] umAddressReDomain;
                if (!"address".equals(ocContractproDomain.getContractproKey()) || null == (umAddressReDomain = (UmAddressReDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContractproDomain.getContractproValue(), UmAddressReDomain.class))) continue;
                receiverInfo.put("province", umAddressReDomain.getProvinceName());
                receiverInfo.put("city", umAddressReDomain.getCityName());
                String detailAddress = "";
                if (StringUtils.isNotBlank((String)umAddressReDomain.getProvinceName())) {
                    detailAddress = umAddressReDomain.getProvinceName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getCityName())) {
                    detailAddress = detailAddress + umAddressReDomain.getCityName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getAreaName())) {
                    detailAddress = detailAddress + umAddressReDomain.getAreaName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getRoadName())) {
                    detailAddress = detailAddress + umAddressReDomain.getRoadName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getAddressDetail())) {
                    detailAddress = detailAddress + umAddressReDomain.getAddressDetail();
                }
                receiverInfo.put("detailAddress", detailAddress);
            }
        }
        if (null == receiverInfo.get("detailAddress") && (split = ocContractDomain.getGoodsReceiptArrdess().split(",")).length > 3) {
            receiverInfo.put("province", split[0]);
            receiverInfo.put("city", split[1]);
            String detailAddress = "";
            for (String str : split) {
                detailAddress = detailAddress + str;
            }
            receiverInfo.put("detailAddress", detailAddress);
        }
        deliveryOrder.put("receiverInfo", receiverInfo);
        ArrayList orderLineList = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain goods : goodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocContractDomain.getTenantCode());
                relmap.put("goodsCode", goods.getGoodsCode());
                relmap.put("goodsRelType", "3");
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("itemCode", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("planQty", goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum()));
                    orderLineList.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getGoodsCamount());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("deliveryOrder", deliveryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    public static void main(String[] args) {
        String esbKey = "WYDS-TRMF98BC";
        String esbSecret = "WYDS#@YFD";
        String url = "https://ipaasqas.rifeng.com.cn:31443/298153907928989696/CWMS/stockoutCreate/1.0.0";
        String EsbWarehouseCode = "RFJL";
        String EsbOwnerCode = "RIFENG";
        String EsbSourcePlatformCode = "B2C";
        String EsbLogisticsCode = "B2C";
        String EsbShopNick = "B2C";
        String EsbSenderInfo = "";
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setGoodsReceiptArrdess("\u9655\u897f,\u5b9d\u9e21\u5e02,\u9648\u4ed3\u533a,\u78fb\u6eaa\u9547,\u6d4b\u8bd5");
        ocContractDomain.setGoodsReceiptMem("\u6d4b\u8bd5\u7528\u6237");
        ocContractDomain.setGoodsReceiptPhone("15515425755");
        ocContractDomain.setContractBillcode("DS2022081515040000002");
        ArrayList<OcContractGoodsDomain> goodsDomains = new ArrayList<OcContractGoodsDomain>();
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        ocContractGoodsDomain.setSkuNo("RF20220804001");
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        goodsDomains.add(ocContractGoodsDomain);
        ocContractDomain.setGoodsList(goodsDomains);
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, Object> deliveryOrder = new HashMap<String, Object>();
        deliveryOrder.put("deliveryOrderCode", ocContractDomain.getContractBillcode());
        deliveryOrder.put("orderType", "XSDD");
        deliveryOrder.put("warehouseCode", EsbWarehouseCode);
        deliveryOrder.put("ownerCode", EsbOwnerCode);
        deliveryOrder.put("sourcePlatformCode", EsbSourcePlatformCode);
        deliveryOrder.put("logisticsCode", EsbLogisticsCode);
        deliveryOrder.put("shopNick", EsbShopNick);
        HashMap orderLines = new HashMap();
        Map senderInfo = new HashMap();
        if (StringUtils.isNotBlank((String)EsbSenderInfo)) {
            senderInfo = (Map)JsonUtil.buildNormalBinder().getJsonToMap(EsbSenderInfo, String.class, Object.class);
            deliveryOrder.put("senderInfo", senderInfo);
        }
        HashMap<String, String> receiverInfo = new HashMap<String, String>();
        receiverInfo.put("name", ocContractDomain.getGoodsReceiptMem());
        receiverInfo.put("mobile", ocContractDomain.getGoodsReceiptPhone());
        String[] split = ocContractDomain.getGoodsReceiptArrdess().split(",");
        if (split.length > 3) {
            receiverInfo.put("province", split[0]);
            receiverInfo.put("city", split[1]);
            String detailAddress = "";
            for (String str : split) {
                detailAddress = detailAddress + str;
            }
            receiverInfo.put("detailAddress", detailAddress);
        }
        deliveryOrder.put("receiverInfo", receiverInfo);
        ArrayList orderLineList = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getGoodsCamount());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("deliveryOrder", deliveryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        System.out.println(JsonUtil.buildNormalBinder().toJson(map));
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (esbContractResponse.getSuccess().booleanValue()) {
            System.out.println("success");
        } else {
            System.out.println("error");
        }
    }

    @Override
    public String sendContractDomainEndToEsb(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendContractDomainEndToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOderCancelUrl", "EsbOderCancelUrl");
        String EsbWarehouseCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("warehouseCode", EsbWarehouseCode);
        request.put("ownerCode", EsbOwnerCode);
        request.put("orderCode", ocContractDomain.getContractBillcode());
        request.put("orderType", "XSDD");
        request.put("cancelType", "out");
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    private static String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyMMdd");
        return df.format(new Date());
    }

    @Override
    public String sendContractDomainConfirmToEsb(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendContractDomainConfirmToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String KUNNR = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String NAME1 = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbNAME1", "EsbNAME1");
        String LGORT = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocEsbContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        int POSEX = 0;
        for (OcContractGoodsDomain goods : goodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocContractDomain.getTenantCode());
                relmap.put("goodsCode", goods.getGoodsCode());
                relmap.put("goodsRelType", "3");
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
                    orderLine.put("POSEX", ++POSEX);
                    orderLine.put("AUART", "ZG01");
                    orderLine.put("KUNNR", KUNNR);
                    orderLine.put("NAME1", NAME1);
                    orderLine.put("FKDAT", date);
                    orderLine.put("MATNR", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ARKTX", rsGoodsRelReDomain.getGoodsName());
                    BigDecimal multiply = goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum());
                    orderLine.put("KWMENG", multiply);
                    orderLine.put("ACTPR", rsGoodsRelReDomain.getPricesetNprice());
                    orderLine.put("WRBTR", rsGoodsRelReDomain.getPricesetNprice().multiply(multiply));
                    orderLine.put("WERKS", WERKS);
                    orderLine.put("LGORT", LGORT);
                    list.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
            orderLine.put("POSEX", ++POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        SapContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }
}

