/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.asd.service.impl;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.asd.ComConstants;
import com.yqbsoft.laser.service.ext.channel.asd.domain.pos.PosStoreDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.pos.PosStoreGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.um.UmUserinfoDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.wh.WhOpstoreDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.wh.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.wh.WhOpstoreReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.wh.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.wh.WhWarehouseReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.channel.asd.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.wh.TokenRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.wh.WhOpstoreRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.wh.WhStoregoodsNumRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.wh.WhStoregoodsRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.wh.WhWarehouseRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.wh.TokenResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.wh.WhOpstoreResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.wh.WhStoregoodsNumResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.wh.WhStoregoodsResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.wh.WhWarehouseResponse;
import com.yqbsoft.laser.service.ext.channel.asd.service.BusStoreService;
import com.yqbsoft.laser.service.ext.channel.asd.supbase.StoreBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BusStoreServiceImpl
extends StoreBaseService
implements BusStoreService {
    private String SYS_CODE = "asddata.BusStoreServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusStoreServiceImpl.class);
    private String ddcode = "store";
    @Autowired
    RestTempfacade restTempfacade;
    @Autowired
    Esbfacade esbfacade;

    @Override
    public String sendSaveBusWarehouse(WhWarehouseReDomain whWarehouseDomain) {
        if (null == whWarehouseDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseDomain");
            return "error";
        }
        String tenantCode = whWarehouseDomain.getTenantCode();
        WhWarehouseRequest whWarehouseRequest = new WhWarehouseRequest();
        whWarehouseRequest.init(this.getDdMap(tenantCode, this.ddcode, "asddata"));
        try {
            BeanUtils.copyAllPropertys((Object)whWarehouseRequest, (Object)whWarehouseDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Throwable)e);
            return "error";
        }
        WhWarehouseResponse whWarehouseResponse = this.restTempfacade.execute(whWarehouseRequest);
        if (null == whWarehouseResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseResponse");
            return "error";
        }
        if (!whWarehouseResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseResponse", (Object)whWarehouseResponse.getMsg());
            return whWarehouseResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusOpstore(WhOpstoreReDomain whOpstoreReDomain) {
        if (null == whOpstoreReDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOpstore.WhWarehouseDomain");
            return "error";
        }
        String tenantCode = whOpstoreReDomain.getTenantCode();
        WhOpstoreRequest whOpstoreRequest = new WhOpstoreRequest();
        whOpstoreRequest.init(this.getDdMap(tenantCode, this.ddcode, "asddata"));
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreRequest, (Object)whOpstoreReDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.e", (Object)e);
            return "error";
        }
        WhOpstoreResponse whOpstoreResponse = this.restTempfacade.execute(whOpstoreRequest);
        if (null == whOpstoreResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.whOpstoreResponse");
            return "error";
        }
        if (!whOpstoreResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.whOpstoreResponse", (Object)whOpstoreResponse.getMsg());
            return whOpstoreResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendPullStoreGoods(String tenantCode, String filialeNo, String optDateStr) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendPullStoreGoods.tenantCode");
            return "error";
        }
        HashMap<String, Object> umMap = new HashMap<String, Object>();
        umMap.put("tenantCode", tenantCode);
        umMap.put("userinfoQuality", "store");
        umMap.put("fuzzy", true);
        if (StringUtils.isNotBlank((String)filialeNo)) {
            umMap.put("userinfoOcode", filialeNo);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(umMap));
        QueryResult userinfoQueryResult = this.getQueryResutl("um.userbase.queryUserinfoPage", map, UmUserinfoDomain.class);
        logger.error("userinfoQueryResult======", (Object)JsonUtil.buildNormalBinder().toJson((Object)userinfoQueryResult));
        if (EmptyUtil.isEmpty((Object)userinfoQueryResult) || ListUtil.isEmpty((Collection)userinfoQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".sendPullStoreGoods.userinfoQueryResult.null:", map);
            return "error";
        }
        WhStoregoodsRequest whOpstoreReDomain = new WhStoregoodsRequest();
        ArrayList<String> umList = new ArrayList<String>();
        for (UmUserinfoDomain umUserinfoDomain : userinfoQueryResult.getList()) {
            if (StringUtils.isBlank((String)umUserinfoDomain.getUserinfoOcode())) {
                logger.error(this.SYS_CODE + ".sendPullStoreGoods.userinfoQueryResult.null:", (Object)umUserinfoDomain.getUserinfoCode());
                continue;
            }
            this.createStore(umUserinfoDomain, whOpstoreReDomain, optDateStr, umList);
        }
        if (ListUtil.isNotEmpty(umList)) {
            logger.error(this.SYS_CODE + ".sendPullStoreGoods.umList", (Object)JsonUtil.getNotDefJsonUtil().toJson(umList));
            return JsonUtil.getNotDefJsonUtil().toJson(umList);
        }
        return "success";
    }

    public String createStore(final UmUserinfoDomain umUserinfoDomain, WhStoregoodsRequest whOpstoreReDomain, String optDateStr, List<String> umList) {
        if (null == umUserinfoDomain) {
            logger.info(this.SYS_CODE + ".createStore.umUserinfoDomain");
            return "error";
        }
        whOpstoreReDomain.setMap((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("shopNo", umUserinfoDomain.getUserinfoOcode());
            }
        });
        whOpstoreReDomain.setTenantCode(umUserinfoDomain.getTenantCode());
        whOpstoreReDomain.init(this.getDdMap(umUserinfoDomain.getTenantCode(), ComConstants.AND_APPKEY, ComConstants.AND_APPKEY));
        String host = this.getDdFlag(umUserinfoDomain.getTenantCode(), ComConstants.AND_QRYSTORK, ComConstants.AND_QRYSTORK);
        if (StringUtils.isBlank((String)host)) {
            logger.info(this.SYS_CODE + ".createStore.umUserinfoDomain", (Object)"method is null");
            return "error";
        }
        whOpstoreReDomain.setHost(host);
        whOpstoreReDomain.setOrgTenantCode(umUserinfoDomain.getTenantCode());
        WhStoregoodsResponse whStoregoodsResponse = null;
        try {
            whStoregoodsResponse = this.esbfacade.executeDoGet(whOpstoreReDomain);
        }
        catch (Exception e) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.error(this.SYS_CODE + ".createStore.whStoregoodsResponse.e", (Throwable)e);
            return "error";
        }
        if (null == whStoregoodsResponse) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.info(this.SYS_CODE + ".createStore.whStoregoodsResponse.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain));
            return "error";
        }
        if (!whStoregoodsResponse.getSuccess().booleanValue()) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.info(this.SYS_CODE + ".createStore.whOpstoreResponse", (Object)("msg:" + whStoregoodsResponse.getMsg() + "whOpstoreReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain)));
            return "error";
        }
        if (EmptyUtil.isEmpty((Object)whStoregoodsResponse.getDataObj())) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.info(this.SYS_CODE + ".createStore.dataObj", (Object)("msg:" + whStoregoodsResponse.getMsg() + "whOpstoreReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain)));
            return "error";
        }
        PosStoreDomain posStoreDomain = (PosStoreDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(whStoregoodsResponse.getDataObj(), PosStoreDomain.class);
        if (EmptyUtil.isEmpty((Object)posStoreDomain) || ListUtil.isEmpty(posStoreDomain.getData())) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.error(this.SYS_CODE + ".createStore.posStoreGoodsDomainwhStoregoodsResponse", (Object)("whStoregoodsResponse:" + JsonUtil.buildNonDefaultBinder().toJson((Object)whStoregoodsResponse)));
            return "error";
        }
        logger.error("\u63a5\u53d7\u6570\u636e\u4e3a" + posStoreDomain.getData().size() + "\u6761");
        this.makeWhOpstoreDomainstockRelease(posStoreDomain.getData(), umUserinfoDomain, "0", umUserinfoDomain.getTenantCode());
        return "success";
    }

    private void makeWhOpstoreDomainstockRelease(List<PosStoreGoodsDomain> posStoreGoodsDomainList, UmUserinfoDomain umUserinfoDomain, String type, String tenantCode) {
        if (ListUtil.isEmpty(posStoreGoodsDomainList)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> parm = new HashMap<String, String>();
        for (PosStoreGoodsDomain posStoreGoodsDomain : posStoreGoodsDomainList) {
            if (StringUtils.isBlank((String)posStoreGoodsDomain.getFmaterielNo()) || StringUtils.isBlank((String)posStoreGoodsDomain.getFfinalQty()) || StringUtils.isBlank((String)posStoreGoodsDomain.getFfilialeNo())) {
                logger.error(this.SYS_CODE + ".createStore.makeWhOpstoreDomainstockRelease.posStoreGoodsDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)posStoreGoodsDomain));
                continue;
            }
            map.clear();
            parm.clear();
            if (StringUtils.equals((CharSequence)"1", (CharSequence)type)) {
                map.put("userinfoOcode", posStoreGoodsDomain.getFfilialeNo());
                map.put("tenantCode", tenantCode);
                parm.put("map", JsonUtil.buildNormalBinder().toJson(map));
                logger.info("mapparm====", parm);
                QueryResult userinfoQueryResult = this.getQueryResutl("um.userbase.queryUserinfoPage", parm, UmUserinfoDomain.class);
                if (EmptyUtil.isEmpty((Object)userinfoQueryResult) || ListUtil.isEmpty((Collection)userinfoQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendPullUpdateGoodsNum.userinfoQueryResult.null:", map);
                    continue;
                }
                if (userinfoQueryResult.getList().size() > 1) {
                    logger.error(this.SYS_CODE + ".userinfoQueryResult.size()!=1:", map);
                    continue;
                }
                umUserinfoDomain = (UmUserinfoDomain)userinfoQueryResult.getList().get(0);
            }
            WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
            whOpstoreDomain.setStoreGoodsBtype("0");
            whOpstoreDomain.setStoreGoodsType("0");
            whOpstoreDomain.setStoreType("0");
            whOpstoreDomain.setGoodsNum(new BigDecimal(posStoreGoodsDomain.getFfinalQty()));
            whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
            whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
            whOpstoreDomain.setTenantCode(umUserinfoDomain.getTenantCode());
            whOpstoreDomain.setMemberBcode(umUserinfoDomain.getUserinfoCode());
            whOpstoreDomain.setMemberCcode(umUserinfoDomain.getUserinfoCode());
            whOpstoreDomain.setMemberCode(umUserinfoDomain.getUserinfoParentCode());
            whOpstoreDomain.setMemberCname(umUserinfoDomain.getUserinfoCompname());
            whOpstoreDomain.setMemberBname(umUserinfoDomain.getUserinfoCompname());
            whOpstoreDomain.setMemberCname(umUserinfoDomain.getUserinfoCompname());
            whOpstoreDomain.setWarehouseCode(umUserinfoDomain.getUserinfoOcode());
            whOpstoreDomain.setWarehouseName(umUserinfoDomain.getUserinfoParentName());
            this.assWhOpstoreGoodsDomain(whOpstoreDomain, posStoreGoodsDomain, umUserinfoDomain);
            try {
                this.sendSaveOpstore(whOpstoreDomain);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".timingStock.sendSaveOpstore.param", (Throwable)e);
                return;
            }
        }
    }

    private void assWhOpstoreGoodsDomain(WhOpstoreDomain whOpstoreDomain, PosStoreGoodsDomain posStoreGoodsDomain, UmUserinfoDomain umUserinfoDomain) {
        if (null == whOpstoreDomain || null == posStoreGoodsDomain || null == umUserinfoDomain) {
            return;
        }
        WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)whOpstoreGoodsDomain, (Object)whOpstoreDomain);
            whOpstoreGoodsDomain.setGoodsNo(posStoreGoodsDomain.getFmaterielNo());
            whOpstoreGoodsDomain.setGoodsName(posStoreGoodsDomain.getFmaterielName());
            whOpstoreGoodsDomain.setGoodsEocode(posStoreGoodsDomain.getFmaterielNo());
            BigDecimal decimal = new BigDecimal(posStoreGoodsDomain.getFfinalQty());
            whOpstoreGoodsDomain.setGoodsNum(decimal);
            whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
        whOpstoreGoodsDomainList.add(whOpstoreGoodsDomain);
        whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        this.assWhOpstoreSkuDomain(whOpstoreGoodsDomain, whOpstoreDomain);
    }

    private void assWhOpstoreSkuDomain(WhOpstoreGoodsDomain whOpstoreGoodsDomain, WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain || null == whOpstoreGoodsDomain) {
            return;
        }
        WhOpstoreSkuDomain whOpstoreSkuDomain = new WhOpstoreSkuDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)whOpstoreSkuDomain, (Object)whOpstoreGoodsDomain);
            whOpstoreSkuDomain.setGoodsNum(whOpstoreGoodsDomain.getGoodsNum());
            whOpstoreSkuDomain.setGoodsWeight(BigDecimal.ZERO);
            whOpstoreSkuDomain.setStoreGoodsBtype(whOpstoreDomain.getStoreGoodsBtype());
            whOpstoreSkuDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
            whOpstoreSkuDomain.setSkuEocode(whOpstoreGoodsDomain.getGoodsEocode());
            whOpstoreSkuDomain.setSkuNo(whOpstoreGoodsDomain.getGoodsNo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<WhOpstoreSkuDomain> opstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
        whOpstoreDomain.setMemberMcode(whOpstoreSkuDomain.getMemberCode());
        whOpstoreDomain.setMemberMname(whOpstoreSkuDomain.getMemberName());
        opstoreSkuDomainList.add(whOpstoreSkuDomain);
        whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(opstoreSkuDomainList);
    }

    @Override
    public String sendUpdateGoodsNum(WhOpstoreDomain whOpstoreDomain) {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain) || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreSkuDomainList())) {
            logger.error(this.SYS_CODE + ".sendUpdateGoodsNum.whOpstoreDomainisnull", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
            return "error";
        }
        final WhOpstoreSkuDomain skuDomain = whOpstoreDomain.getWhOpstoreSkuDomainList().get(0);
        if (StringUtils.isBlank((String)skuDomain.getSkuNo()) || EmptyUtil.isEmpty((Object)skuDomain.getGoodsNum()) || StringUtils.isBlank((String)skuDomain.getWarehouseCode())) {
            logger.error(this.SYS_CODE + ".sendUpdateGoodsNum.whOpstoreDomain.skuNo", (Object)JsonUtil.buildNormalBinder().toJson((Object)skuDomain));
            return "error";
        }
        WhStoregoodsNumRequest whStoregoodsNumRequest = new WhStoregoodsNumRequest();
        whStoregoodsNumRequest.setMap((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("item_no", skuDomain.getSkuNo());
                this.put("sku_no", skuDomain.getSkuNo());
                this.put("quantity", skuDomain.getGoodsNum());
                this.put("kdt_id", skuDomain.getWarehouseCode());
            }
        });
        whStoregoodsNumRequest.init(this.getDdMap(skuDomain.getTenantCode(), this.ddcode, "asddata"));
        String host = this.getDdFlag(skuDomain.getTenantCode(), ComConstants.AND_UTPSTORK, ComConstants.AND_UTPSTORK);
        if (StringUtils.isBlank((String)host)) {
            logger.info(this.SYS_CODE + ".sendUpdateGoodsNum", (Object)"method is null");
            return "error";
        }
        whStoregoodsNumRequest.setHost(host);
        WhStoregoodsNumResponse storegoodsNumResponse = null;
        try {
            storegoodsNumResponse = this.restTempfacade.execute(whStoregoodsNumRequest);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendUpdateGoodsNum.storegoodsNumResponse.e", (Throwable)e);
            return "error";
        }
        if (null == storegoodsNumResponse) {
            logger.info(this.SYS_CODE + ".sendUpdateGoodsNum.storegoodsNumResponse.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)whStoregoodsNumRequest));
            return "error";
        }
        if (!storegoodsNumResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendUpdateGoodsNum.success", (Object)("msg:" + storegoodsNumResponse.getMsg() + "whOpstoreReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)whStoregoodsNumRequest)));
            return "error";
        }
        return "success";
    }

    @Override
    public String sendUpdateSkuNum(final WhOpstoreSkuDomain whOpstoreDomain) {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            logger.error(this.SYS_CODE + ".sendUpdateSkuNum.whOpstoreDomainisnull");
            return "error";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getSkuNo()) || EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsNum()) || StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
            logger.error(this.SYS_CODE + ".sendUpdateSkuNum.whOpstoreDomain.skuNo", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
            return "error";
        }
        WhStoregoodsNumRequest whStoregoodsNumRequest = new WhStoregoodsNumRequest();
        whStoregoodsNumRequest.setMap((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("item_no", whOpstoreDomain.getSkuNo());
                this.put("sku_no", whOpstoreDomain.getSkuNo());
                this.put("quantity", whOpstoreDomain.getGoodsNum());
                this.put("kdt_id", whOpstoreDomain.getWarehouseCode());
            }
        });
        whStoregoodsNumRequest.init(this.getDdMap(whOpstoreDomain.getTenantCode(), this.ddcode, "asddata"));
        WhStoregoodsNumResponse storegoodsNumResponse = null;
        try {
            storegoodsNumResponse = this.restTempfacade.execute(whStoregoodsNumRequest);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendUpdateSkuNum.storegoodsNumResponse.e", (Throwable)e);
            return "error";
        }
        if (null == storegoodsNumResponse) {
            logger.info(this.SYS_CODE + ".sendUpdateSkuNum.storegoodsNumResponse.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)whStoregoodsNumRequest));
            return "error";
        }
        if (!storegoodsNumResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendUpdateSkuNum.success", (Object)("msg:" + storegoodsNumResponse.getMsg() + "whOpstoreReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)whStoregoodsNumRequest)));
            return "error";
        }
        return "success";
    }

    @Override
    public String sendPullUpdateGoodsNum(String tenantCode, Integer proMinutes) {
        WhStoregoodsRequest whOpstoreReDomain = new WhStoregoodsRequest();
        this.createStoreNum(whOpstoreReDomain, tenantCode, proMinutes);
        return "success";
    }

    @Override
    public String updateToken(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return "error";
        }
        String json = this.getDdFlag(tenantCode, flagSettingType, flagSettingCode);
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (MapUtil.isEmpty((Map)map) || EmptyUtil.isEmpty(map.get("host")) || EmptyUtil.isEmpty(map.get("appid")) || EmptyUtil.isEmpty(map.get("appkey")) || EmptyUtil.isEmpty(map.get("method")) || EmptyUtil.isEmpty(map.get("host1"))) {
            logger.error(this.SYS_CODE + ".updateToken.getDdMap.map", (Object)map);
            return "error";
        }
        Object host = map.get("host");
        Object host1 = map.get("host1");
        final Object appid = map.get("appid");
        final Object appkey = map.get("appkey");
        final Object method = map.get("method");
        String key = "token" + flagSettingType + "-" + tenantCode;
        String tokenValue = DisUtil.getRemot((String)key);
        logger.error(this.SYS_CODE + ".updateToken.old", (Object)tokenValue);
        if (!StringUtils.isBlank((String)tokenValue)) {
            TokenRequest tokenRequest = new TokenRequest();
            tokenRequest.setMap((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("appid", appid);
                    this.put("appkey", appkey);
                    this.put("method", method);
                }
            });
            tokenRequest.setHost(host1.toString());
            tokenRequest.setOrgTenantCode(tenantCode);
            TokenResponse tokenResponse = this.esbfacade.executeDoGet(tokenRequest);
            if (null == tokenResponse) {
                logger.error(this.SYS_CODE + ".updateToken.tokenResponse", (Object)tokenValue);
                return "error";
            }
            if (!tokenResponse.getSuccess().booleanValue()) {
                logger.error(this.SYS_CODE + ".updateToken.error", (Object)JsonUtil.buildNormalBinder().toJson((Object)tokenResponse));
                return "error";
            }
            tokenValue = tokenResponse.getDataObj();
            DisUtil.set((String)key, (String)tokenValue, (int)86400);
            logger.info(this.SYS_CODE + ".updateToken.newToken", (Object)DisUtil.get((String)key));
        }
        return "success";
    }

    public String createStoreNum(WhStoregoodsRequest whOpstoreReDomain, String tenantCode, final Integer proMinutes) {
        whOpstoreReDomain.setMap((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("proMinutes", proMinutes.toString());
            }
        });
        whOpstoreReDomain.setTenantCode(tenantCode);
        String host = this.getDdFlag(tenantCode, ComConstants.AND_QRYSTORK, ComConstants.AND_QRYSTORK);
        if (StringUtils.isBlank((String)host)) {
            logger.info(this.SYS_CODE + ".createStore.umUserinfoDomain", (Object)"method is null");
            return "error";
        }
        whOpstoreReDomain.setHost(host);
        whOpstoreReDomain.setOrgTenantCode(tenantCode);
        WhStoregoodsResponse whStoregoodsResponse = null;
        try {
            whStoregoodsResponse = this.esbfacade.executeDoGet(whOpstoreReDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".createStore.whStoregoodsResponse.e", (Throwable)e);
            return "error";
        }
        if (null == whStoregoodsResponse) {
            logger.info(this.SYS_CODE + ".createStore.whStoregoodsResponse.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain));
            return "error";
        }
        if (!whStoregoodsResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".createStore.whOpstoreResponse", (Object)("msg:" + whStoregoodsResponse.getMsg() + "whOpstoreReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain)));
            return "error";
        }
        if (EmptyUtil.isEmpty((Object)whStoregoodsResponse.getDataObj())) {
            logger.info(this.SYS_CODE + ".createStore.dataObj", (Object)("msg:" + whStoregoodsResponse.getMsg() + "whOpstoreReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain)));
            return "error";
        }
        PosStoreDomain posStoreDomain = (PosStoreDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(whStoregoodsResponse.getDataObj(), PosStoreDomain.class);
        if (EmptyUtil.isEmpty((Object)posStoreDomain) || ListUtil.isEmpty(posStoreDomain.getData())) {
            logger.error(this.SYS_CODE + ".createStore.posStoreGoodsDomainwhStoregoodsResponse", (Object)("whStoregoodsResponse:" + JsonUtil.buildNonDefaultBinder().toJson((Object)whStoregoodsResponse)));
            return "error";
        }
        this.makeWhOpstoreDomainstockRelease(posStoreDomain.getData(), null, "1", tenantCode);
        return "success";
    }
}

