/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.asd.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.ext.channel.asd.domain.um.UmUserDomainBean;
import com.yqbsoft.laser.service.ext.channel.asd.domain.um.UmUserReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.um.UmUserinfoDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.channel.asd.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.um.QueryAddUserinfoRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.um.QueryUserinfoRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.um.UmUserinfoRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.um.AsdUserinfoAddResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.um.AsdUserinfoResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.um.UmUserinfoResponse;
import com.yqbsoft.laser.service.ext.channel.asd.service.BusUserService;
import com.yqbsoft.laser.service.ext.channel.asd.supbase.UserinfoBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BusUserServiceImpl
extends UserinfoBaseService
implements BusUserService {
    private String SYS_CODE = "asddata.BusUserServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusUserServiceImpl.class);
    private String ddcode = "user";
    @Autowired
    RestTempfacade restTempfacade;
    @Autowired
    Esbfacade esbfacade;

    @Override
    public String sendSaveBusUserinfo(UmUserinfoReDomain umUserinfo, UmUserReDomain umUser, String optype) {
        if (null == umUserinfo) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfo");
            return "error";
        }
        String tenantCode = umUserinfo.getTenantCode();
        String url = umUserinfo.getWebSiteUrl();
        if (StringUtils.isNotBlank((String)url)) {
            if (url.indexOf("http") != 0) {
                url = "http://" + url;
            }
            url = url + "/laserEr/http/post/{apiCode}/1.0/" + tenantCode + "/utf-8/shangshu";
            umUserinfo.setWebSiteUrl(url);
        }
        UmUserinfoRequest umUserinfoRequest = new UmUserinfoRequest();
        umUserinfoRequest.init(this.getDdMap(tenantCode, this.ddcode, "asddata"));
        umUserinfoRequest.setOrgTenantCode(umUserinfo.getTenantCode());
        String t = this.getTenantCodeBuUrl(umUserinfoRequest.getHost());
        if (StringUtils.isNotBlank((String)t)) {
            umUserinfo.setTenantCode(t);
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoRequest, (Object)umUserinfo);
            if (StringUtils.isBlank((String)t)) {
                umUserinfoRequest.setTenantCode(umUserinfoRequest.getToTenantCode());
            }
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.e", (Throwable)e);
            return "error";
        }
        UmUserinfoResponse umUserinfoResponse = this.restTempfacade.execute(umUserinfoRequest);
        if (null == umUserinfoResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse");
            return "error";
        }
        if (!umUserinfoResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse", (Object)umUserinfoResponse.getMsg());
            return umUserinfoResponse.getMsg();
        }
        return "success";
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getAfterDate((Date)new Date(), (int)-1, (String)"yyyy-MM-dd"));
    }

    @Override
    public String sendQueryUserinfo(String tenantCode, Integer fQryType, String start, String end) {
        if (null == fQryType) {
            fQryType = 2;
        }
        String key = "tokenasdAppidAppkey-" + tenantCode;
        String tokenValue = DisUtil.getRemot((String)key);
        QueryAddUserinfoRequest queryAddUserinfoRequest = new QueryAddUserinfoRequest();
        queryAddUserinfoRequest.setAccessToken(tokenValue);
        queryAddUserinfoRequest.setAccess_token(tokenValue);
        queryAddUserinfoRequest.setMethod("VipCardExt.Cache_VipInfoChangeIncQuery");
        queryAddUserinfoRequest.init(this.getDdMap(tenantCode, this.ddcode, "asddata"));
        if (StringUtils.isBlank((String)start)) {
            start = DateUtil.getAfterDate((Date)new Date(), (int)-1, (String)"yyyy-MM-dd");
        }
        if (StringUtils.isBlank((String)end)) {
            end = DateUtil.getAfterDate((Date)new Date(), (int)1, (String)"yyyy-MM-dd");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("fQryType", fQryType);
        paramMap.put("fStartTime", start);
        paramMap.put("fEndTime", end);
        queryAddUserinfoRequest.setfStartTime(start);
        queryAddUserinfoRequest.setfEndTime(end);
        queryAddUserinfoRequest.setBiz_Content(JsonUtil.buildNormalBinder().toJson(paramMap));
        AsdUserinfoAddResponse asdUserinfoAddResponse = this.esbfacade.executeDoGet(queryAddUserinfoRequest);
        if (null == asdUserinfoAddResponse) {
            logger.error(this.SYS_CODE + ".sendQueryUserinfo.asdUserinfoAddResponse.null");
            return "error";
        }
        if (!asdUserinfoAddResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendQueryUserinfo.asdUserinfoAddResponse.error", (Object)asdUserinfoAddResponse.getMsg());
            return asdUserinfoAddResponse.getMsg();
        }
        QueryUserinfoRequest queryUserinfoRequest = new QueryUserinfoRequest();
        queryUserinfoRequest.setMethod("VipCardExt.GetHttpCachePageData&");
        queryUserinfoRequest.setAccess_token(tokenValue);
        queryUserinfoRequest.setAccessToken(tokenValue);
        queryUserinfoRequest.init(this.getDdMap(tenantCode, this.ddcode, "asddata"));
        boolean flag = true;
        HashMap<String, Object> paramMap1 = new HashMap<String, Object>();
        paramMap1.put("HttpCacheCode", asdUserinfoAddResponse.getHttpCacheCode());
        queryUserinfoRequest.setHttpCacheCode(asdUserinfoAddResponse.getHttpCacheCode());
        logger.info(this.SYS_CODE + ".sendQueryUserinfo.for", (Object)asdUserinfoAddResponse.getPageCount());
        for (int startPage = 1; startPage <= asdUserinfoAddResponse.getPageCount(); ++startPage) {
            paramMap1.put("PageIndex", startPage);
            queryUserinfoRequest.setPageIndex(startPage);
            queryUserinfoRequest.setBiz_Content(JsonUtil.buildNormalBinder().toJson(paramMap1));
            AsdUserinfoResponse asdUserinfoResponse = this.esbfacade.executeDoGet(queryUserinfoRequest);
            if (null == asdUserinfoResponse) {
                logger.error(this.SYS_CODE + ".sendQueryUserinfo.asdUserinfoResponse.null");
                return "error";
            }
            if (!asdUserinfoResponse.getSuccess().booleanValue()) {
                logger.error(this.SYS_CODE + ".sendQueryUserinfo.asdUserinfoResponse.error", (Object)asdUserinfoResponse.getMsg());
                return asdUserinfoResponse.getMsg();
            }
            if (null != asdUserinfoResponse.getData() && ListUtil.isNotEmpty(asdUserinfoResponse.getData())) {
                if (2 == fQryType) {
                    this.saveUserinfo(asdUserinfoResponse.getData(), tenantCode);
                    continue;
                }
                if (1 != fQryType) continue;
                this.updateUserinfo(asdUserinfoResponse.getData(), tenantCode);
                continue;
            }
            logger.error(this.SYS_CODE + ".sendQueryUserinfo.asdUserinfoResponse.data", (Object)startPage);
        }
        return "success";
    }

    private String saveUserinfo(List<Map<String, Object>> data, String tenantCode) {
        if (null == data || ListUtil.isEmpty(data)) {
            return "success";
        }
        for (Map<String, Object> map : data) {
            UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
            umUserDomainBean.setMemberMcode(this.getTeananMemberCode(tenantCode));
            umUserDomainBean.setTenantCode(tenantCode);
            umUserDomainBean.setUserinfoOcode(map.get("fVipID").toString());
            umUserDomainBean.setUserinfoType(1);
            umUserDomainBean.setPartnerType((Integer)map.get("fVipTypeID"));
            umUserDomainBean.setUserinfoCompname((String)map.get("fVipName"));
            umUserDomainBean.setUserinfoCert1No((String)map.get("fCredNo"));
            umUserDomainBean.setUserinfoTel((String)map.get("fTel"));
            umUserDomainBean.setUserinfoOpcode1(String.valueOf(map.get("fUsableFillSum")));
            umUserDomainBean.setUserinfoOpcode2(String.valueOf(map.get("fUsableScore")));
            umUserDomainBean.setUserName((String)map.get("fCredNo"));
            umUserDomainBean.setUserinfoQuality("buy");
            try {
                String userinfoCode = this.sendOpenUserinfo(umUserDomainBean);
                if (!StringUtils.isBlank((String)userinfoCode)) continue;
                logger.error(this.SYS_CODE + ".saveUserinfo.userinfoCode");
            }
            catch (ApiException e) {
                logger.error(this.SYS_CODE + ".saveUserinfo.e", (Throwable)e);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".saveUserinfo.e1", (Throwable)e);
            }
        }
        return "success";
    }

    private String updateUserinfo(List<Map<String, Object>> data, String tenantCode) {
        if (null == data || ListUtil.isEmpty(data)) {
            return "success";
        }
        for (Map<String, Object> map : data) {
            UmUserinfoDomain umUserDomainBean = new UmUserinfoDomain();
            umUserDomainBean.setMemberMcode(this.getTeananMemberCode(tenantCode));
            umUserDomainBean.setTenantCode(tenantCode);
            umUserDomainBean.setUserinfoOcode(map.get("fVipID").toString());
            umUserDomainBean.setUserinfoType(1);
            umUserDomainBean.setPartnerType((Integer)map.get("fVipTypeID"));
            umUserDomainBean.setUserinfoCompname((String)map.get("fVipName"));
            umUserDomainBean.setUserinfoCert1No((String)map.get("fCredNo"));
            umUserDomainBean.setUserinfoTel((String)map.get("fTel"));
            umUserDomainBean.setUserinfoOpcode1(String.valueOf(map.get("fUsableFillSum")));
            umUserDomainBean.setUserinfoOpcode2(String.valueOf(map.get("fUsableScore")));
            try {
                String userinfoCode = this.sendUpdateUserinfo(umUserDomainBean);
                if (!StringUtils.isBlank((String)userinfoCode)) continue;
                logger.error(this.SYS_CODE + ".updateUserinfo.userinfoCode");
            }
            catch (ApiException e) {
                logger.error(this.SYS_CODE + ".updateUserinfo.e", (Throwable)e);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".updateUserinfo.e1", (Throwable)e);
            }
        }
        return "success";
    }
}

