/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.asd.supbase;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.asd.ComConstants;
import com.yqbsoft.laser.service.ext.channel.asd.common.RetuenBean;
import com.yqbsoft.laser.service.ext.channel.asd.domain.dis.DisChannelReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.facade.http.Esbfacade;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BusBaseService
extends BaseServiceImpl {
    public static final String SYS_CODE = "asddata.BusBaseService";
    @Autowired
    Esbfacade esbfacade;

    protected String getDdFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    protected Map<String, Object> getDdMap(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String json = this.getDdFlag(tenantCode, flagSettingType, flagSettingCode);
        if (StringUtils.equals((CharSequence)ComConstants.AND_APPKEY, (CharSequence)flagSettingType)) {
            Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
            if (MapUtil.isEmpty((Map)map) || EmptyUtil.isEmpty(map.get("host")) || EmptyUtil.isEmpty(map.get("appid")) || EmptyUtil.isEmpty(map.get("appkey")) || EmptyUtil.isEmpty(map.get("method")) || EmptyUtil.isEmpty(map.get("host1"))) {
                this.logger.error("asddata.BusBaseServicegetDdMap.map", (Object)map);
                return null;
            }
            Object host = map.get("host");
            Object host1 = map.get("host1");
            Object appid = map.get("appid");
            Object appkey = map.get("appkey");
            Object method = map.get("method");
            String key = "token" + flagSettingType + "-" + tenantCode;
            String tokenValue = DisUtil.get((String)key);
            this.logger.error("asddata.BusBaseServicevaue.key", (Object)tokenValue);
            map.put("accessToken", tokenValue);
            this.logger.error("asddata.BusBaseServicesendAutomaticToRedis.accessToken", (Object)map);
            json = JsonUtil.buildNonDefaultBinder().toJson((Object)map);
        }
        return (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
    }

    protected String getTenantCodeBuUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        String s = url.replace("http://", "").replace("https://", "");
        String[] str = s.split("/");
        if (str.length <= 6) {
            return null;
        }
        return str[6];
    }

    protected String getTeananMemberCode(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        return memberCode;
    }

    protected QueryResult<UmUserinfoReDomain> queryUserinfoPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "um.user.queryUserinfoPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, UmUserinfoReDomain.class);
    }

    protected UmUserinfoReDomain getUserinfoByCode(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserinfoByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserinfoReDomain)this.getForObject(apiCode, UmUserinfoReDomain.class, paramMap);
    }

    protected DisChannelReDomain getDisChannelByMemberCcode(String memberCcode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "dis.channel.queryChannelPage";
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("memberCcode", memberCcode);
        map.put("channelSort", "1");
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult qlist = this.sendReSupObject(apiCode, paramMap, DisChannelReDomain.class);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        return (DisChannelReDomain)qlist.getList().get(0);
    }

    protected QueryResult<RsSkuDomain> queryRsSkuPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "rs.sku.querySkuPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, RsSkuDomain.class);
    }

    protected RsResourceGoodsReDomain getGoodsByCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "rs.resourceGoods.getResourceGoodsByCodeStr";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("goodsCode", goodsCode);
        paramMap.put("tenantCode", tenantCode);
        return (RsResourceGoodsReDomain)this.getForObject(apiCode, RsResourceGoodsReDomain.class, paramMap);
    }

    protected String makeErrorReturn(String errorCode, String msg) {
        return JsonUtil.buildNormalBinder().toJson((Object)new RetuenBean(errorCode, msg));
    }

    protected String makeSuccessReturn(Object dataObj) {
        return JsonUtil.buildNormalBinder().toJson((Object)new RetuenBean(dataObj));
    }

    protected String makeSuccessReturn(Map<String, Object> map) {
        map.put("errmsg", "OK");
        map.put("errcode", "0");
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    protected String makerrorReturn(Map<String, Object> map) {
        map.put("errcode", "50204");
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    protected DisChannelReDomain getDisChannel(String channelOcode, String tenantCode) {
        if (StringUtils.isBlank((String)channelOcode)) {
            return null;
        }
        String apiCode = "dis.channel.queryChannelPage";
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("channelOcode", channelOcode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult qlist = this.sendReSupObject(apiCode, paramMap, DisChannelReDomain.class);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        return (DisChannelReDomain)qlist.getList().get(0);
    }
}

