/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.bocom.service;

import com.bocom.api.BocomRequest;
import com.bocom.api.DefaultBocomClient;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.bocom.BocomConstants;
import com.yqbsoft.laser.service.ext.channel.bocom.domain.MPNG210005RequestV1;
import com.yqbsoft.laser.service.ext.channel.bocom.domain.MPNG210005ResponseV1;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelInBaseService;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ChannelInServiceImpl
extends ChannelInBaseService {
    private static final String CODE = "cmc.ChannelInBaseService.ChannelInServiceImpl";

    public String getFchannelCode() {
        return BocomConstants.channelCode;
    }

    protected String httpInvoke(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            this.logger.error("cmc.ChannelInBaseService.ChannelInServiceImpl.sign.channelRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("cmc.ChannelInBaseService.ChannelInServiceImpl.sign.null", "");
        }
        this.logger.info("cmc.ChannelInBaseService.ChannelInServiceImpl.httpInvoke.channelRequest2", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
        Map configMap = channelRequest.getConfigMap();
        CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        Map map = new HashMap();
        if (StringUtils.isNotBlank((String)cmChannelClear.getExtension())) {
            map = (Map)JsonUtil.buildNonNullBinder().getJsonToObject(cmChannelClear.getExtension(), Map.class);
        }
        DefaultBocomClient client = new DefaultBocomClient((String)configMap.get("appid"), (String)configMap.get("privateKey"), (String)configMap.get("publicKey"));
        client.ignoreSSLHostnameVerifier();
        MPNG210005RequestV1 request = new MPNG210005RequestV1();
        request.setServiceUrl((String)configMap.get("tradeUrl") + "/api/pmssMpng/MPNG210005/v1");
        MPNG210005RequestV1.MPNG210005RequestV1Biz bizContent = new MPNG210005RequestV1.MPNG210005RequestV1Biz();
        MPNG210005RequestV1.MPNG210005RequestV1Biz.ReqHead reqHead = new MPNG210005RequestV1.MPNG210005RequestV1Biz.ReqHead();
        bizContent.setReqHead(reqHead);
        try {
            reqHead.setTransTime(DateUtils.parseDateToString((Date)cmChannelClear.getGmtCreate(), (String)"yyyyMMddHHmmss"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        reqHead.setVersion("1.0");
        MPNG210005RequestV1.MPNG210005RequestV1Biz.ReqBody reqBody = new MPNG210005RequestV1.MPNG210005RequestV1Biz.ReqBody();
        bizContent.setReqBody(reqBody);
        reqBody.setIp("192.168.1.10");
        reqBody.setMerPtcId((String)configMap.get("mchId"));
        reqBody.setMerTradeTime(DateUtils.getDateString((Date)cmChannelClear.getGmtCreate(), (String)"HHmmss"));
        reqBody.setNotifyUrl((String)configMap.get("notifyUrl"));
        reqBody.setMerTradeDate(DateUtils.getDateString((Date)cmChannelClear.getGmtCreate(), (String)"yyyyMMdd"));
        reqBody.setPayMerTranNo(cmChannelClear.getChannelClearSeqno());
        if ("wechatmini".equals(cmChannelClear.getFchannelClassifyCode())) {
            reqBody.setTranScene("B2C-MINIPROGRAM-WECHAT");
            reqBody.setSubAppId((String)configMap.get("wxAppid"));
            reqBody.setSubOpenId(String.valueOf(map.get("openId")));
        } else if ("alipaywap".equals(cmChannelClear.getFchannelClassifyCode())) {
            reqBody.setTranScene("B2C-SDKAPP-ALIPAY");
        } else if ("wechat".equals(cmChannelClear.getFchannelClassifyCode())) {
            reqBody.setTranScene("B2C-SDKAPP-WECHAT");
            reqBody.setSubAppId("");
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        reqBody.setTotalAmount(df.format(cmChannelClear.getOrderAmount()));
        reqBody.setLocation("ONLINE");
        reqBody.setCurrency("CNY");
        request.setBizContent(bizContent);
        MPNG210005ResponseV1 response = null;
        try {
            this.logger.info("cmc.ChannelInBaseService.ChannelInServiceImpl.httpInvoke.client.execute.req", (Object)JsonUtil.buildNormalBinder().toJson((Object)request));
            response = (MPNG210005ResponseV1)client.execute((BocomRequest)request, UUID.randomUUID().toString().replace("-", ""));
            this.logger.info("cmc.ChannelInBaseService.ChannelInServiceImpl.httpInvoke.client.execute.res", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        }
        catch (Exception e) {
            this.logger.error("cmc.ChannelInBaseService.ChannelInServiceImpl.httpInvoke.client.execute.error.res", (Object)JsonUtil.buildNormalBinder().toJson((Object)e.getMessage()));
            return "";
        }
        return JsonUtil.buildNonNullBinder().toJson((Object)response);
    }
}

