/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.bocom.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.bocom.util.StringUtil;
import com.yqbsoft.laser.service.ext.channel.bocom.util.WeChatPayConfig;
import com.yqbsoft.laser.service.ext.channel.bocom.util.WeChatPaySubmit;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelBaseSignService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import com.yqbsoft.laser.service.tool.util.XmlUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ChannelSignServiceImpl
extends ChannelBaseSignService {
    public static final String SYS_CODE = "cmc.ChannelSignServiceImpl";

    public void sign(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            this.logger.info("cmc.ChannelSignServiceImpl.sign.channelRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("cmc.ChannelSignServiceImpl.sign.null", "");
        }
        String httpUrl = WeChatPayConfig.url;
        Map exmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(channelRequest.getCmChannelClear().getExtension(), String.class, String.class);
        String verCode = "";
        if (null != exmap) {
            Map payMap;
            String pay;
            String spbill_create_ip;
            String openId = (String)exmap.get("openId");
            if (StringUtils.isNotBlank((String)openId)) {
                channelRequest.getRequestData().put("openid", openId);
            }
            if (StringUtils.isNotBlank((String)(spbill_create_ip = (String)exmap.get("client_ip")))) {
                channelRequest.getRequestData().put("spbill_create_ip", spbill_create_ip);
            }
            verCode = (String)exmap.get("verCode");
            String userAccount = (String)exmap.get("userOcode");
            String payJson = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(channelRequest.getCmChannelClear().getTenantCode() + "-pay_config-pay_config"));
            if (StringUtils.isNotBlank((String)payJson) && StringUtils.isNotBlank((String)(pay = (String)(payMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(payJson, String.class, String.class)).get(userAccount)))) {
                String[] pays = pay.split("-");
                channelRequest.getConfigMap().put("mch_id", pays[0]);
                channelRequest.getConfigMap().put("pay_key", pays[1]);
                channelRequest.getRequestData().put("mch_id", pays[0]);
                channelRequest.getRequestData().put("pay_key", pays[1]);
            }
        }
        httpUrl = this.makeSubmch(channelRequest.getConfigMap(), channelRequest.getRequestData());
        if (StringUtils.isNotBlank((String)verCode)) {
            httpUrl = WeChatPayConfig.activeurl;
            channelRequest.getRequestData().put("auth_code", verCode);
            channelRequest.getRequestData().remove("notify_url");
            channelRequest.getRequestData().remove("openid");
            channelRequest.getRequestData().remove("sub_openid");
            channelRequest.getRequestData().remove("trade_type");
            channelRequest.setDebitFlag(true);
        }
        String api_key = (String)channelRequest.getRequestData().get(WeChatPayConfig.pay_key);
        Map<String, String> params = WeChatPaySubmit.buildRequestPara(channelRequest.getRequestData());
        String resXml = "";
        this.logger.info("ChannelSignServiceImpl.sign", (Object)("\u5fae\u4fe1\u652f\u4ed8\u8bf7\u6c42\uff1a" + params));
        try {
            resXml = WebUtils.doPost((String)httpUrl, (String)"text/html;charset=utf-8", (byte[])XmlUtil.callMapToXML(params).getBytes(StandardCharsets.UTF_8), (int)5000, (int)5000);
        }
        catch (IOException e) {
            this.logger.error("ChannelSignServiceImpl.sign.e", (Throwable)e);
        }
        this.logger.info("ChannelSignServiceImpl.sign", (Object)("\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\uff1a" + resXml));
        Map resMap = XmlUtil.getMapFromXML((String)resXml);
        HashMap<String, String> res = new HashMap<String, String>();
        if (((String)resMap.get("return_code")).equals("SUCCESS") && ((String)resMap.get("result_code")).equals("SUCCESS")) {
            if (StringUtils.isBlank((String)verCode)) {
                res.put("appId", (String)resMap.get("appid"));
                res.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
                res.put("nonceStr", UUID.randomUUID().toString().replace("-", ""));
                res.put("package", "prepay_id=".concat((String)resMap.get("prepay_id")));
                res.put("signType", "MD5");
                res.put(WeChatPayConfig.pay_key, api_key);
                String sign = WeChatPaySubmit.buildRequestMysign(res);
                res.put("paySign", sign);
            } else {
                channelRequest.setDebitResult("SUCCESS");
                channelRequest.setBankSeqno((String)resMap.get("transaction_id"));
                this.processDate(resMap, channelRequest);
            }
        } else if (StringUtils.isNotBlank((String)verCode)) {
            res.put("subMsg", (String)resMap.get("err_code_des"));
            res.put("subCode", (String)resMap.get("err_code"));
            channelRequest.setBankRescode((String)resMap.get("err_code"));
            channelRequest.setBankResmsg((String)resMap.get("err_code_des"));
            channelRequest.setDebitResult((String)resMap.get("err_code"));
        }
        channelRequest.setRequestData(res);
    }

    private String makeSubmch(Map<String, String> configMap, Map<String, String> requestMap) {
        String httpUrl = WeChatPayConfig.url;
        if (configMap != null && configMap.containsKey("sub_appid")) {
            requestMap.put("sub_appid", configMap.get("sub_appid"));
            requestMap.put("sub_openid", requestMap.remove("openid"));
        }
        if (configMap != null && configMap.containsKey("sub_mch_id")) {
            requestMap.put("sub_mch_id", configMap.get("sub_mch_id"));
        }
        if (configMap != null && configMap.containsKey("sp_appid")) {
            httpUrl = WeChatPayConfig.service_v3_url;
            requestMap.remove("trade_type");
            requestMap.remove("ptradpdeCode");
            HashMap<String, String> amount = new HashMap<String, String>();
            amount.put("total", requestMap.remove("total_fee"));
            HashMap<String, String> payer = new HashMap<String, String>();
            payer.put("sp_openid", requestMap.remove("openid"));
            requestMap.put("payer", JsonUtil.buildNormalBinder().toJson(payer));
            requestMap.put("amount", JsonUtil.buildNormalBinder().toJson(amount));
        }
        return httpUrl;
    }

    private void processDate(Map<String, String> resMap, ChannelRequest channelRequest) {
        Date channelAcceptDate = null;
        String timeEnd = resMap.get("time_end");
        if (StringUtils.isNotBlank((String)timeEnd)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                channelAcceptDate = sdf.parse(timeEnd);
            }
            catch (ParseException e) {
                channelAcceptDate = new Date();
                this.logger.error("ChannelSignServiceImpl.processDate", (Object)("\u6e20\u9053\u53d7\u7406\u65f6\u95f4\u8f6c\u6362\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a" + channelRequest.getCmChannelClear().getChannelClearSeqno()));
            }
        }
        channelRequest.setChannelAcceptDate(channelAcceptDate);
    }

    public static void main(String[] args) {
        Map map1;
        Map map;
        BankRequest bankRequest = new BankRequest();
        HashMap<String, String> getRequestData = new HashMap<String, String>();
        getRequestData.put("res", "{\"success\":true,\"biz_state\":\"S\",\"rsp_body\":{\"pay_mer_tran_no\":\"845037937531940886\",\"tran_package\":\"{\\\"appId\\\":\\\"wx6a511dc69dd75567\\\",\\\"timeStamp\\\":\\\"1716371144\\\",\\\"nonceStr\\\":\\\"34c5baf34d9c4957a46c5c36783ae362\\\",\\\"package\\\":\\\"prepay_id=wx22174544035300d61fde76581712e70001\\\",\\\"signType\\\":\\\"RSA\\\",\\\"paySign\\\":\\\"Bj3LbwCkQYGPNxIYgtQe5y15Y7KPizpth5Cts+Ll1KOQ3kwq9cHj7899m1/IWAyHBFesQpgl+6SbqED3hxE9YijcbgibpLykyaQDAqK3U9xPFs7hNuFJrcD3slw+IDnZ//RvFMfBIjkJT63Y1d02lKnkWbLDxdOl8p2i0H1BGIYQb4mk1lvJ/hqsHWVDuDlymbGqm0DJPLSHz90V7OX427IkaMek4IPU3SSqQntXHQdJdayX2yl2dQuUGdR+8cLoZWYDRhwYR8LDraicizbgwY7xAx93ja3gIqgqYA8OzLjEzc+QKSrHOrcBD1FI1EPouW5E+PJ5fVYOvcU9nwD/Dg==\\\"}\",\"sys_order_no\":\"010220240522174543007400135Y\"},\"rsp_head\":{\"trans_code\":\"MPNG210005\",\"response_code\":\"CIPP0004PY0000\",\"response_status\":\"P\",\"response_time\":\"20240522174544\",\"response_msg\":\"\u4ea4\u6613\u6210\u529f\"}}");
        bankRequest.setRequestData(getRequestData);
        if (!StringUtil.isEmpty((String)bankRequest.getRequestData().get("res")) && (map = (Map)JsonUtil.buildNonNullBinder().getJsonToObject((String)bankRequest.getRequestData().get("res"), Map.class)).get("rsp_body") != null && (map1 = (Map)JsonUtil.buildNonNullBinder().getJsonToObject(JsonUtil.buildNonNullBinder().toJson(map.get("rsp_body")), Map.class)).get("tran_package") != null) {
            System.out.println(map1.get("tran_package"));
        }
        System.out.println("bocom".indexOf("wechat") > -1);
        String s = "{\"notify_biz_content\":{\"notify_url\":\"https://xinggou-mp-test.zjsjtz.com/laserBank/http/post/bank/bocom/097/2023072819990101/\",\"tran_type\":\"PAY\",\"mer_tran_no\":\"846332650877231196\",\"tran_state\":\"SUCCESS\",\"tran_state_code\":\"\",\"tran_state_msg\":\"\",\"partner_id\":\"\",\"mer_ptc_id\":\"131058121007137\",\"final_time\":\"20240527144918\",\"total_amount\":\"0.01\",\"buyer_pay_amount\":\"0.01\",\"trd_dsct_amount\":\"0.00\",\"pay_dsct_amount\":\"0\",\"currency\":\"CNY\",\"tran_content\":\"\",\"mer_memo\":\"\",\"require_values\":{\"bank_tran_no\":null,\"third_party\":null,\"third_party_tran_no\":null,\"payment_info\":null,\"refund_info\":null}},\"sign\":\"AQuXXc8R4WSEzR71Lru+ygpRLNSk9FmuWXPxssFyOpq1ZsUjmBkKFBy9pydNMWWDGKHfEmlKQeEn29HH3gQKxziLeo/cYK5Ok3NqCazDYdpx4tgyavyg73ZkpNsI2y99XUV2l00VcLJy8Ee4joMuWFkP3/bPFpcquOhlmh1ZkKwBFUAnRRRq66fiK5LMjMISRs0GaNOd0b57pmab4NOfHybDL2abuo/0T9OB5gJAePE9nPAlW7i5zxq1IflOFPenpfJUGpCTHsS1QVynY68N2dpBVCzXn3lneeMJJ4Aqau/KDrbto2aDCdRNWeHmb2bkPT9C0tyXvYnxlMqAihjJ0Q==\"}";
        Map map2 = (Map)JsonUtil.buildNonNullBinder().getJsonToObject(s, Map.class);
        Object notify_biz_content = map2.get("notify_biz_content");
        System.out.println(JsonUtil.buildNormalBinder().toJson(notify_biz_content));
        Map map12 = (Map)JsonUtil.buildNonNullBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(notify_biz_content), Map.class);
        System.out.println(map12.get("mer_tran_no"));
    }

    public ChannelRest verifySign(BankRequest bankRequest) {
        Map map;
        this.logger.info("cmc.ChannelSignServiceImpl.verifySign.bankRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)bankRequest));
        if (null == bankRequest || null == bankRequest.getConfigMap() || bankRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.null", "");
        }
        ChannelRest channelRest = new ChannelRest();
        channelRest.setChannelClearFchannel(bankRequest.getChannelClearFchannel());
        channelRest.setTenantCode(bankRequest.getTenantCode());
        if (!StringUtil.isEmpty((String)bankRequest.getRequestData().get("res"))) {
            map = (Map)JsonUtil.buildNonNullBinder().getJsonToObject((String)bankRequest.getRequestData().get("res"), Map.class);
            String rsp_body = JsonUtil.buildNonNullBinder().toJson(map.get("rsp_body"));
            this.logger.info("cmc.ChannelSignServiceImpl.verifySign.bankRequest.res.rsp_body", (Object)rsp_body);
            HashMap<String, String> htmlMap = new HashMap<String, String>();
            htmlMap.put("htmlStr", rsp_body);
            channelRest.setChannelSubStr(JsonUtil.buildNonDefaultBinder().toJson(htmlMap));
            channelRest.setClearOrderSeqno((String)bankRequest.getRequestData().get("channelClearSeqno"));
            channelRest.setDataState(Integer.valueOf(1));
        }
        if (!StringUtil.isEmpty((String)bankRequest.getRequestData().get("resStream"))) {
            map = (Map)JsonUtil.buildNonNullBinder().getJsonToObject((String)bankRequest.getRequestData().get("resStream"), Map.class);
            String notify_biz_content = JsonUtil.buildNonNullBinder().toJson(map.get("notify_biz_content"));
            this.logger.info("cmc.ChannelSignServiceImpl.verifySign.bankRequest.notice.res.notify_biz_content", (Object)notify_biz_content);
            Map map1 = (Map)JsonUtil.buildNonNullBinder().getJsonToObject(notify_biz_content, Map.class);
            this.logger.info("cmc.ChannelSignServiceImpl.verifySign.bankRequest.notice.res.map1", (Object)JsonUtil.buildNonNullBinder().toJson(map.get("map1")));
            channelRest.setChannelClearSeqno(String.valueOf(map1.get("mer_tran_no")));
            if ("SUCCESS".equals(map1.get("tran_state"))) {
                channelRest.setDataState(Integer.valueOf(2));
            } else {
                channelRest.setDataState(Integer.valueOf(3));
            }
        }
        this.logger.info("cmc.ChannelSignServiceImpl.verifySign.bankRequest.res", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRest));
        return channelRest;
    }
}

