/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.discom.service;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.discom.api.WmsWarehouseService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContract;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisDictionary;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisPackageDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundFileDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisStatementContract;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisStatementContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcContract;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcRefund;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ResChannelsendDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ResEvaluateGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ResEvaluateReplyDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ResEvaluateScopeDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsSku;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgOccontractReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsDataDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsLogDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.WhGoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.WhOpstoreDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisBaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class WmsWarehouseBaseService
extends DisBaseServiceImpl
implements WmsWarehouseService {
    private String SYS_CODE = "cmc.DisOrderBaseService";
    private static final String RESOURCEGOODS_GETNO_API_CODE = "rs.resourceGoods.getResourceBySkuNo";

    @Override
    public Map<String, Object> buildComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".buildComParam.channelApiCode");
            return null;
        }
        return this.buildComOrderParam(channelApiCode, disChannel, sendParam, configMap, param);
    }

    public abstract Map<String, Object> buildComOrderParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    public abstract Object sendComOrder(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    @Override
    public Object sendComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".sendComParam.channelApiCode");
            return "error";
        }
        Object object = this.sendComOrder(channelApiCode, disChannel, sendhttpParam, configMap, param);
        if (null == object) {
            this.logger.error(this.SYS_CODE + ".sendComParam.channelApiCode is null");
            return "error";
        }
        return object;
    }

    public abstract Map<String, Object> buildOrderParam(Map<String, Object> var1);

    public abstract String saveOrderParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    protected void saveOrder(List<DisContractDomain> disContractDomainList, DisChannel disChannel) {
        if (null == disChannel || ListUtil.isEmpty(disContractDomainList)) {
            return;
        }
        String apiCode = "dis.channelsendBase.saveContractBatch";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disContractDomainList", JsonUtil.buildNormalBinder().toJson(disContractDomainList));
        this.internalInvoke(apiCode, paramMap);
    }

    protected void updateOrderObillcode(String contractBillcode, String contractObillcode, String tenantCode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractObillcode)) {
            return;
        }
        String apiCode = "oc.contract.updateContractContractNbillcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractBillcode", contractBillcode);
        paramMap.put("contractNbillcode", contractObillcode);
        paramMap.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected DisContractDomain getContractByNbCode(String tenantCode, String contractNbillcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNbillcode)) {
            return null;
        }
        String apiCode = "dis.contract.getContractByNbCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisContractDomain)this.getForObject(apiCode, DisContractDomain.class, paramMap);
    }

    protected DisContractDomain getContractDomainByCode(String tenantCode, String contractBillcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        String apiCode = "dis.contract.getContractDomainByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractBillcode", contractBillcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisContractDomain)this.getForObject(apiCode, DisContractDomain.class, paramMap);
    }

    protected void updateOrder(String tenantCode, String contractNbillcode, Integer dataState, Integer oldDataState, Map<String, Object> map, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNbillcode)) {
            return;
        }
        String apiCode = "dis.channelsendBase.sendUpdateContractStateByNbCode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("dataState", dataState);
        paramMap.put("channelCode", disChannel.getChannelCode());
        paramMap.put("oldDataState", oldDataState);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.internalInvoke(apiCode, paramMap);
    }

    protected void updateExtrinsicStateByRefundCode(String refundCode, String dataOpnextbillstate, String tenantCode) {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)dataOpnextbillstate) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateExtrinsicStateByRefundCode.", (Object)(refundCode + "=:=" + dataOpnextbillstate + "=:=" + tenantCode));
            return;
        }
        String apiCode = "oc.refund.updateExtrinsicStateByRefundCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("refundCode", refundCode);
        paramMap.put("dataOpnextbillstate", dataOpnextbillstate);
        paramMap.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected OcRefund queryRefundByNbbillcode(String channelCode, String contractNbbillcode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)contractNbbillcode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".queryRefundByNbbillcode.", (Object)(channelCode + "=:=" + contractNbbillcode + "=:=" + tenantCode));
            return null;
        }
        String apiCode = "oc.refund.queryRefundPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractNbbillcode", contractNbbillcode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("channelCode", channelCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.getQueryResutl(apiCode, param, OcRefund.class);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error(this.SYS_CODE + ".queryRefundByNbbillcode.queryResult ", paramMap);
            return null;
        }
        return (OcRefund)queryResult.getList().get(0);
    }

    protected void updateRefunFlagByCode(BigDecimal contractGoodsRefnum, String tenantCode, String channelCode, String contractGoodsCode) {
        if (null == contractGoodsRefnum || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)contractGoodsCode)) {
            this.logger.error(this.SYS_CODE + ".updateRefunFlagByCode.param ", (Object)(contractGoodsRefnum + " =:= " + tenantCode + " =:= " + channelCode + " =:= " + contractGoodsCode));
            return;
        }
        String apiCode = "dis.contract.updateRefunFlagByCode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("contractGoodsRefnum", contractGoodsRefnum);
        paramMap.put("refundFlag", 1);
        paramMap.put("contractGoodsCode", contractGoodsCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected GoodsBean getResourceBySkuNo(String skuNo, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)skuNo)) {
            return null;
        }
        String apiCode = RESOURCEGOODS_GETNO_API_CODE;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("skuNo", skuNo);
        paramMap.put("memberCode", memberCode);
        paramMap.put("memberCcode", memberCcode);
        paramMap.put("channelCode", channelCode);
        return (GoodsBean)this.getForObject(apiCode, GoodsBean.class, paramMap);
    }

    protected RsSku getSkuBySkuNo(String skuNo, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)skuNo)) {
            return null;
        }
        String apiCode = "rs.sku.getSkuBySkuNo";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("skuNo", skuNo);
        paramMap.put("memberCode", memberCode);
        paramMap.put("memberCcode", memberCcode);
        paramMap.put("channelCode", channelCode);
        return (RsSku)this.getForObject(apiCode, RsSku.class, paramMap);
    }

    protected SgOccontractReDomain getOccontractByNbbillCode(String tenantCode, String channelCode, String contractNbbillcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)contractNbbillcode)) {
            this.logger.error(this.SYS_CODE + ".getOccontractByNbbillCode.", (Object)(channelCode + " =:= " + channelCode + " =:= " + contractNbbillcode));
            return null;
        }
        String apiCode = "sg.sgOccontract.getOccontractByNbbillCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbbillcode", contractNbbillcode);
        paramMap.put("channelCode", channelCode);
        return (SgOccontractReDomain)this.getForObject(apiCode, SgOccontractReDomain.class, paramMap);
    }

    protected void saveRefund(List<DisRefundDomain> disRefundDomainList, DisChannel disChannel) {
        if (null == disChannel || ListUtil.isEmpty(disRefundDomainList)) {
            return;
        }
        String apiCode = "dis.channelsendBase.sendSaveRefundBatch";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disRefundDomainList", JsonUtil.buildNormalBinder().toJson(disRefundDomainList));
        this.internalInvoke(apiCode, paramMap);
    }

    protected void saveRefundSimpl(DisRefundDomain disRefundDomain) {
        if (null == disRefundDomain) {
            this.logger.error(this.SYS_CODE + ".saveRefundSimpl", (Object)"param is null");
            return;
        }
        String apiCode = "dis.refund.saveRefund";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)disRefundDomain));
        this.internalInvoke(apiCode, paramMap);
    }

    protected void updateRefund(DisRefundDomain disRefundDomain) {
        if (null == disRefundDomain) {
            this.logger.error(this.SYS_CODE + ".updateRefund", (Object)"param is null");
            return;
        }
        String apiCode = "dis.refund.updateRefund";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)disRefundDomain));
        this.internalInvoke(apiCode, paramMap);
    }

    protected void sendUpdateRefundStateByCode(String tenantCode, String refundCode, String channelCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        if (null == tenantCode || null == refundCode || null == channelCode || null == dataState || null == oldDataState) {
            return;
        }
        String apiCode = "dis.channelsendBase.sendUpdateRefundStateByCode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("refundCode", refundCode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("dataState", dataState);
        paramMap.put("oldDataState", oldDataState);
        paramMap.put("map", map);
        this.internalInvoke(apiCode, paramMap);
    }

    protected DisRefundDomain getRefundByOCode(String tenantCode, String refundOcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)refundOcode)) {
            return null;
        }
        String apiCode = "dis.refund.getRefundByOcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("refundOcode", refundOcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisRefundDomain)this.getForObject(apiCode, DisRefundDomain.class, paramMap);
    }

    protected DisRefundReDomain getRefundByNbillcode(String tenantCode, String contractNbillcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNbillcode)) {
            return null;
        }
        String apiCode = "dis.refund.getRefundByNbillcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisRefundReDomain)this.getForObject(apiCode, DisRefundReDomain.class, paramMap);
    }

    protected SgSendgoodsLogDomain getSgsendgoodsLogBysgCode(String tenantCode, String sendgoodsCode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)sendgoodsCode)) {
            return null;
        }
        String apiCode = "sg.sendgoodsLog.querySendgoodsLogBySendCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("sendgoodsCode", sendgoodsCode);
        return (SgSendgoodsLogDomain)this.getForObject(apiCode, SgSendgoodsLogDomain.class, paramMap);
    }

    protected List<DisContract> queryContractByTime(String tenantCode, String channelCode, String memberCcode, String startDate, String endDate) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)startDate) || StringUtils.isBlank((String)endDate)) {
            this.logger.error(this.SYS_CODE + ".queryContractByTime ", (Object)(tenantCode + "=:=" + channelCode + "=:=" + startDate + "=:=" + endDate));
            return null;
        }
        String apiCode = "dis.contract.queryContractPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("memberCcode", memberCcode);
        paramMap.put("startDate", startDate);
        paramMap.put("endDate", endDate);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.getQueryResutl(apiCode, param, DisContract.class);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error(this.SYS_CODE + ".queryContractByTime.queryResult ", paramMap);
            return null;
        }
        return queryResult.getList();
    }

    protected List<DisDictionary> queryDictionary(String tenantCode, String channelCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode)) {
            this.logger.error(this.SYS_CODE + ".queryDictionary ", (Object)(tenantCode + "=:=" + channelCode));
            return null;
        }
        String apiCode = "dis.dictionary.queryDictionaryPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("dictionaryType", "UmUserinfo");
        paramMap.put("dictionaryDisgoods", "shopId");
        paramMap.put("dictionaryGoods", "userinfoCode");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.getQueryResutl(apiCode, param, DisDictionary.class);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error(this.SYS_CODE + ".queryDictionary.queryResult ", paramMap);
            return null;
        }
        return queryResult.getList();
    }

    protected SgSendgoodsReDomain getSgSendGoodsByCode(String tenantCode, String sendGoodsCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)sendGoodsCode)) {
            return null;
        }
        String apiCode = "sg.sendgoods.getSendgoodsReDomainByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("sendgoodsCode", sendGoodsCode);
        return (SgSendgoodsReDomain)this.getForObject(apiCode, SgSendgoodsReDomain.class, paramMap);
    }

    protected SgSendgoodsReDomain getSgSendGoods(String tenantCode, String channelCode, String contractBillcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        String apiCode = "sg.sendgoods.getSgSendGoods";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("channelCode", channelCode);
        map.put("contractBillcode", contractBillcode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return (SgSendgoodsReDomain)this.getForObject(apiCode, SgSendgoodsReDomain.class, paramMap);
    }

    protected SgSendgoodsReDomain getSendgoodsReDomainByNbbillcode(String tenantCode, String sendGoodsCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)sendGoodsCode)) {
            this.logger.error(this.SYS_CODE + ".getSendgoodsReDomainByNbbillcode", (Object)"param is null");
            return null;
        }
        String apiCode = "sg.sendgoods.getSendgoodsReDomainByNbbillcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbbillcode", sendGoodsCode);
        return (SgSendgoodsReDomain)this.getForObject(apiCode, SgSendgoodsReDomain.class, paramMap);
    }

    protected void updateDelCodeById(Integer sendgoodsId, String contractDelcode) {
        if (null == sendgoodsId || StringUtils.isBlank((String)contractDelcode)) {
            this.logger.error(this.SYS_CODE + ".updateDelCodeById", (Object)"param is null");
            return;
        }
        String apiCode = "sg.sendgoods.updateDelCodeById";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("sendgoodsId", sendgoodsId);
        paramMap.put("contractDelcode", contractDelcode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected String getSgSendgoodsState(String tenantCode, String channelCode, String status) {
        String dataState = this.getDictionaryDisValue(tenantCode, channelCode, "SgSendgoods", "status", status);
        if (StringUtils.isBlank((String)dataState)) {
            this.logger.debug(this.SYS_CODE + ".getSgSendgoodsState.dataState", (Object)(channelCode + "-" + status + "-" + tenantCode));
            return null;
        }
        return dataState;
    }

    protected String getOcContractState(String tenantCode, String channelCode, String status) {
        String dataState = this.getDictionaryDisValue(tenantCode, channelCode, "ocContract", "status", status);
        if (StringUtils.isBlank((String)dataState)) {
            this.logger.debug(this.SYS_CODE + ".getOcContractState.dataState", (Object)(channelCode + "-" + status + "-" + tenantCode));
            return null;
        }
        return dataState;
    }

    protected void sendSaveSgSendGoodsState(List<SgSendgoodsDataDomain> sgSendgoodsDataDomainList) {
        if (ListUtil.isEmpty(sgSendgoodsDataDomainList)) {
            this.logger.error(this.SYS_CODE + ".sendSaveSgSendGoodsState ", sgSendgoodsDataDomainList);
            return;
        }
        String apiCode = "sg.sendgoods.sendSgSendgoodsDataBatch";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sgSendgoodsDataDomainList", JsonUtil.buildNormalBinder().toJson(sgSendgoodsDataDomainList));
        this.internalInvoke(apiCode, paramMap);
    }

    protected void saveChannelsendBatch(List<ResChannelsendDomain> resChannelsendDomainList) {
        if (ListUtil.isEmpty(resChannelsendDomainList)) {
            this.logger.error(this.SYS_CODE + ".saveChannelsendBatch ", resChannelsendDomainList);
            return;
        }
        String apiCode = "res.evaluateBase.sendChannelSendBatch";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("resChannelsendDomainList", JsonUtil.buildNormalBinder().toJson(resChannelsendDomainList));
        this.internalInvoke(apiCode, paramMap);
    }

    protected List<DisRefundFileDomain> createFile(List<String> pictures, DisRefundDomain disRefundDomain) {
        if (ListUtil.isEmpty(pictures) || null == disRefundDomain) {
            return null;
        }
        ArrayList<DisRefundFileDomain> disRefundFileDomainList = new ArrayList<DisRefundFileDomain>();
        for (String refundFileUrl : pictures) {
            DisRefundFileDomain disRefundFileDomain = new DisRefundFileDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disRefundFileDomain, (Object)disRefundDomain);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".makeRefund.copyAllPropertys", (Throwable)e);
            }
            disRefundFileDomain.setRefundFileUrl(refundFileUrl);
            disRefundFileDomainList.add(disRefundFileDomain);
        }
        return disRefundFileDomainList;
    }

    protected Map<String, DisContractGoodsDomain> getMap(DisContractDomain disContractDomain) {
        if (null == disContractDomain || ListUtil.isEmpty(disContractDomain.getPackageList())) {
            return null;
        }
        HashMap<String, DisContractGoodsDomain> map = new HashMap<String, DisContractGoodsDomain>();
        for (DisPackageDomain disPackageDomain : disContractDomain.getPackageList()) {
            for (DisContractGoodsDomain disContractGoodsDomain : disPackageDomain.getContractGoodsList()) {
                map.put(disContractGoodsDomain.getSkuNo(), disContractGoodsDomain);
            }
        }
        return map;
    }

    protected List<DisContractGoodsDomain> getList(DisContractDomain disContractDomain) {
        if (null == disContractDomain || ListUtil.isEmpty(disContractDomain.getPackageList())) {
            return null;
        }
        ArrayList<DisContractGoodsDomain> relist = new ArrayList<DisContractGoodsDomain>();
        for (DisPackageDomain disPackageDomain : disContractDomain.getPackageList()) {
            for (DisContractGoodsDomain disContractGoodsDomain : disPackageDomain.getContractGoodsList()) {
                relist.add(disContractGoodsDomain);
            }
        }
        return relist;
    }

    protected OcContract getByNbCode(String contractNbillcode, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)contractNbillcode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".getByNbCode.", (Object)(contractNbillcode + "=:=" + channelCode + "=:=" + tenantCode));
            return null;
        }
        String apiCode = "oc.contract.getByNbCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("tenantCode", tenantCode);
        return (OcContract)this.getForObject(apiCode, OcContract.class, paramMap);
    }

    protected void updateCallOcRefundState(String refundCode, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateCallOcRefundState.", (Object)(refundCode + "=:=" + channelCode + "=:=" + tenantCode));
            return;
        }
        String apiCode = "oc.refund.updateCallOcRefundState";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("refundCode", refundCode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        this.internalInvoke(apiCode, param);
    }

    protected void defaultEvaluateScope(List<ResEvaluateScopeDomain> resEvaluateScopeDomains, DisChannel disChannel, Integer scope, String templateCode, String templateTitle, String type) {
        if (null == resEvaluateScopeDomains || null == disChannel || null == scope || StringUtils.isBlank((String)templateCode) || StringUtils.isBlank((String)templateTitle) || StringUtils.isBlank((String)type)) {
            this.logger.error(this.SYS_CODE + ".defaultEvaluateScope ", (Object)(scope + "=:=" + templateCode + "=:=" + templateTitle + "=:=" + type));
            return;
        }
        for (int i = 0; i < scope; ++i) {
            ResEvaluateScopeDomain resEvaluateScopeDomain = new ResEvaluateScopeDomain();
            resEvaluateScopeDomain.setTemplateCode(templateCode);
            resEvaluateScopeDomain.setTemplateTitle(templateTitle);
            resEvaluateScopeDomain.setEvaluateScopeValue("1");
            resEvaluateScopeDomain.setTemplateType(type);
            resEvaluateScopeDomain.setTenantCode(disChannel.getTenantCode());
            resEvaluateScopeDomain.setChannelCode(disChannel.getChannelCode());
            resEvaluateScopeDomain.setChannelName(disChannel.getChannelName());
            resEvaluateScopeDomain.setTemplateValuesCode(templateCode + i);
            resEvaluateScopeDomains.add(resEvaluateScopeDomain);
        }
    }

    protected ResEvaluateReplyDomain defaultEvaluateReply(ResEvaluateGoodsDomain resEvaluateGoodsDomain, DisChannel disChannel, String replyContent, String orderId, Date date) {
        if (null == resEvaluateGoodsDomain || null == disChannel || StringUtils.isBlank((String)replyContent) || StringUtils.isBlank((String)orderId)) {
            this.logger.error(this.SYS_CODE + ".defaultEvaluateReply ", (Object)(resEvaluateGoodsDomain + "=:=" + disChannel + "=:=" + replyContent + "=:=" + orderId));
            return null;
        }
        ResEvaluateReplyDomain resEvaluateReplyDomain = new ResEvaluateReplyDomain();
        resEvaluateReplyDomain.setEvaluateReplyContent(replyContent);
        resEvaluateReplyDomain.setEvaluateGoodsOcode(orderId);
        resEvaluateReplyDomain.setTenantCode(disChannel.getTenantCode());
        resEvaluateReplyDomain.setChannelCode(disChannel.getChannelCode());
        resEvaluateReplyDomain.setChannelName(disChannel.getChannelName());
        resEvaluateReplyDomain.setMemberCcode(resEvaluateGoodsDomain.getMemberCcode());
        resEvaluateReplyDomain.setMemberCname(resEvaluateGoodsDomain.getMemberCname());
        resEvaluateReplyDomain.setEvaluateGoodsType(resEvaluateGoodsDomain.getEvaluateGoodsType());
        resEvaluateReplyDomain.setMemberBcode(resEvaluateGoodsDomain.getMemberBcode());
        resEvaluateReplyDomain.setMemberBname(resEvaluateGoodsDomain.getMemberBname());
        if (null != date) {
            resEvaluateReplyDomain.setEvaluateReplyDate(date);
        }
        return resEvaluateReplyDomain;
    }

    protected void defaultEvaluateGoods(ResEvaluateGoodsDomain resEvaluateGoodsDomain, DisChannel disChannel, String memberCcode, String memberCname) {
        if (null == resEvaluateGoodsDomain || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".defaultEvaluateGoods ", (Object)(resEvaluateGoodsDomain + "=:=" + disChannel));
            return;
        }
        resEvaluateGoodsDomain.setMemberCcode(StringUtils.isBlank((String)memberCcode) ? disChannel.getMemberCode() : memberCcode);
        resEvaluateGoodsDomain.setMemberCname(StringUtils.isBlank((String)memberCname) ? disChannel.getMemberCname() : memberCname);
        resEvaluateGoodsDomain.setMemberCode(disChannel.getMemberCode());
        resEvaluateGoodsDomain.setMemberName(disChannel.getMemberName());
        resEvaluateGoodsDomain.setTenantCode(disChannel.getTenantCode());
        resEvaluateGoodsDomain.setChannelCode(disChannel.getChannelCode());
        resEvaluateGoodsDomain.setChannelName(disChannel.getChannelName());
    }

    protected ResChannelsendDomain makeResChannelsend(ResEvaluateGoodsDomain resEvaluateGoodsDomain, String dir) {
        if (null == resEvaluateGoodsDomain || StringUtils.isBlank((String)dir)) {
            this.logger.error(this.SYS_CODE + ".makeResChannelsend ", (Object)(resEvaluateGoodsDomain + "=:=" + dir));
            return null;
        }
        ResChannelsendDomain resChannelsendDomain = new ResChannelsendDomain();
        resChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)resEvaluateGoodsDomain));
        resChannelsendDomain.setChannelsendDir(dir);
        resChannelsendDomain.setTenantCode(resEvaluateGoodsDomain.getTenantCode());
        resChannelsendDomain.setChannelCode(resEvaluateGoodsDomain.getChannelCode());
        resChannelsendDomain.setChannelsendType("DisComment");
        return resChannelsendDomain;
    }

    protected SgSendgoodsDataDomain makeSgSendgoodsDataByOc(SgOccontractReDomain sgOc, String sendgoodsDataDir) {
        if (null == sgOc || StringUtils.isEmpty((String)sendgoodsDataDir)) {
            this.logger.error(this.SYS_CODE + ".makeSgSendgoodsDataByOc.", (Object)(sendgoodsDataDir + " =:= " + JsonUtil.buildNormalBinder().toJson((Object)sgOc)));
            return null;
        }
        SgSendgoodsDataDomain sgSendgoodsDataDomain = new SgSendgoodsDataDomain();
        sgSendgoodsDataDomain.setSendgoodsDataTxt(JsonUtil.buildNormalBinder().toJson((Object)sgOc));
        sgSendgoodsDataDomain.setSendgoodsDataDir(sendgoodsDataDir);
        sgSendgoodsDataDomain.setAppmanageIcode(sgOc.getAppmanageIcode());
        sgSendgoodsDataDomain.setMemberBcode(sgOc.getMemberBcode());
        sgSendgoodsDataDomain.setMemberBname(sgOc.getMemberBname());
        sgSendgoodsDataDomain.setMemberCcode(sgOc.getMemberCcode());
        sgSendgoodsDataDomain.setMemberCname(sgOc.getMemberCname());
        sgSendgoodsDataDomain.setMemberCode(sgOc.getMemberCode());
        sgSendgoodsDataDomain.setMemberName(sgOc.getMemberName());
        sgSendgoodsDataDomain.setSendgoodsCode(sgOc.getContractBillcode());
        sgSendgoodsDataDomain.setTenantCode(sgOc.getTenantCode());
        sgSendgoodsDataDomain.setChannelCode(sgOc.getChannelCode());
        sgSendgoodsDataDomain.setSendgoodsDataType("DisContractNotice");
        return sgSendgoodsDataDomain;
    }

    protected SgSendgoodsDataDomain makeSgSendgoodsData(SgSendgoodsReDomain sgSendgoodsDomain, List<SgSendgoodsLogDomain> sgLogList, String sendgoodsDataDir, String sgDataType) {
        if (null == sgSendgoodsDomain || StringUtils.isBlank((String)sendgoodsDataDir) || StringUtils.isBlank((String)sgDataType)) {
            this.logger.error(this.SYS_CODE + ".makeSgSendgoodsData.", (Object)(sgLogList + "=:=" + sendgoodsDataDir + "=:=" + sgDataType));
            return null;
        }
        sgSendgoodsDomain.setSgSendgoodsLogDomainList(sgLogList);
        SgSendgoodsDataDomain sgSendgoodsDataDomain = new SgSendgoodsDataDomain();
        sgSendgoodsDataDomain.setSendgoodsDataTxt(JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        sgSendgoodsDataDomain.setSendgoodsDataDir(sendgoodsDataDir);
        sgSendgoodsDataDomain.setAppmanageIcode(sgSendgoodsDomain.getAppmanageIcode());
        sgSendgoodsDataDomain.setMemberBcode(sgSendgoodsDomain.getMemberBcode());
        sgSendgoodsDataDomain.setMemberBname(sgSendgoodsDomain.getMemberBname());
        sgSendgoodsDataDomain.setMemberCcode(sgSendgoodsDomain.getMemberCcode());
        sgSendgoodsDataDomain.setMemberCname(sgSendgoodsDomain.getMemberCname());
        sgSendgoodsDataDomain.setMemberCode(sgSendgoodsDomain.getMemberCode());
        sgSendgoodsDataDomain.setMemberName(sgSendgoodsDomain.getMemberName());
        sgSendgoodsDataDomain.setSendgoodsCode(sgSendgoodsDomain.getSendgoodsCode());
        sgSendgoodsDataDomain.setTenantCode(sgSendgoodsDomain.getTenantCode());
        sgSendgoodsDataDomain.setChannelCode(sgSendgoodsDomain.getChannelCode());
        sgSendgoodsDataDomain.setSendgoodsDataType(sgDataType);
        return sgSendgoodsDataDomain;
    }

    protected DisContract getContractByCode(String contractNbillcode, String tenantCode, String channelCode) {
        String apiCode = "dis.contract.getContractByNbCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("channelCode", channelCode);
        return (DisContract)this.getForObject(apiCode, DisContract.class, paramMap);
    }

    protected DisStatementContractDomain getStatementContractByCode(String statementContractCode, String tenantCode) {
        String apiCode = "dis.statement.getStatementContractByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("statementContractCode", statementContractCode);
        paramMap.put("tenantCode", tenantCode);
        return (DisStatementContractDomain)this.getForObject(apiCode, DisStatementContractDomain.class, paramMap);
    }

    protected List<DisStatementContract> queryStatementContractPage(String channelCode, String memberCcode, String startDate, String endDate, String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelCode", channelCode);
        map.put("memberCcode", memberCcode);
        map.put("startDate", startDate);
        map.put("endDate", endDate);
        map.put("tenantCode", tenantCode);
        map.put("dataState", 0);
        map.put("pageNo", "1");
        map.put("pageSize", "20");
        paramMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String QueryResultJson = "";
        try {
            QueryResultJson = (String)this.getInternalRouter().inInvoke("dis.statement.queryStatementContractPage", paramMap);
            if (StringUtils.isBlank((String)QueryResultJson)) {
                this.logger.error(this.SYS_CODE + ".externalReconciliation.QueryResultJson.null", (Object)((Object)paramMap).toString());
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".externalReconciliation.QueryResultJson.e", (Object)((Object)paramMap).toString(), (Throwable)e);
            return null;
        }
        ArrayList<DisStatementContract> disStatementContractList = new ArrayList();
        try {
            QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(QueryResultJson, QueryResult.class);
            disStatementContractList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), DisStatementContract.class);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".externalReconciliation.queryResult.e", (Object)QueryResultJson, (Throwable)e);
            return null;
        }
        return disStatementContractList;
    }

    protected List<OcRefund> queryRefundReDomainPage(String contractNbbillcode, String channelCode, String memberCcode, String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractNbbillcode", contractNbbillcode);
        map.put("channelCode", channelCode);
        map.put("memberCcode", memberCcode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", 4);
        paramMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String QueryResultJson = "";
        try {
            QueryResultJson = (String)this.getInternalRouter().inInvoke("oc.refund.queryRefundPage", paramMap);
            if (StringUtils.isBlank((String)QueryResultJson)) {
                this.logger.error(this.SYS_CODE + ".queryRefundReDomainPage.QueryResultJson.null", (Object)((Object)paramMap).toString());
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".queryRefundReDomainPage.QueryResultJson.e", (Object)((Object)paramMap).toString(), (Throwable)e);
            return null;
        }
        ArrayList<OcRefund> ocRefundArrayList = new ArrayList();
        try {
            QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(QueryResultJson, QueryResult.class);
            ocRefundArrayList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), OcRefund.class);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".queryRefundReDomainPage.queryResult.e", (Object)QueryResultJson, (Throwable)e);
            return null;
        }
        return ocRefundArrayList;
    }

    protected void updateStatementContract(DisStatementContractDomain disStatementContractDomain) {
        String apiCode = "dis.statement.updateStatementContract";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disStatementContractDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)disStatementContractDomain));
        this.getInternalRouter().inInvoke(apiCode, paramMap);
    }

    protected void updateStatementContractStateByCode(String tenantCode, String statementContractCode, Integer dataState, Integer oldDataState) {
        String apiCode = "dis.statement.updateStatementContractStateByCode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("statementContractCode", statementContractCode);
        paramMap.put("dataState", dataState);
        paramMap.put("oldDataState", oldDataState);
        paramMap.put("map", null);
        this.getInternalRouter().inInvoke(apiCode, paramMap);
    }

    protected DisStatementContract getStatementContract(Integer statementContractId) {
        String apiCode = "dis.statement.getStatementContract";
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("statementContractId", statementContractId);
        return (DisStatementContract)this.getForObject(apiCode, DisStatementContract.class, paramMap);
    }

    protected GoodsBean getGoodsBySkuNo(String skuNo, DisChannel disChannel, OcContractGoodsDomain ocContractGoodsDomain) {
        if (StringUtils.isBlank((String)skuNo) || null == disChannel) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skuNo", skuNo);
        params.put("memberCode", ocContractGoodsDomain.getMemberCcode());
        params.put("memberCcode", ocContractGoodsDomain.getMemberCcode());
        params.put("channelCode", ocContractGoodsDomain.getMschannelCode());
        params.put("tenantCode", disChannel.getTenantCode());
        return (GoodsBean)this.getForObject(RESOURCEGOODS_GETNO_API_CODE, GoodsBean.class, params);
    }

    @Override
    public String sendPurchaseInwhNoticeBill(WhOpstoreDomain whOpstoreDomain, String memberCode, String tenantCode) {
        String channelApiCode = "cmc.diswarehouse.sendPurchaseInwhNoticeBill";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("whOpstoreDomain", whOpstoreDomain);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String receivePurchaseInwhConfirmBill(String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.diswarehouse.receivePurchaseInwhConfirmBill";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String sendPurchaseExwhNoticeBill(WhOpstoreDomain whOpstoreDomain, String memberCode, String tenantCode) {
        String channelApiCode = "cmc.warehouse.sendPurchaseInwhNoticeBill";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("whOpstoreDomain", whOpstoreDomain);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String receivePurchaseExwhConfirmBill(String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.diswarehouse.receivePurchaseExwhConfirmBill";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String sendPurchasewhAllocationNoticeBill(WhOpstoreDomain whOpstoreDomain, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.diswarehouse.sendPurchasewhAllocationNoticeBill";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("whOpstoreDomain", whOpstoreDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String receiveAllotExwhConfirmBill(String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.diswarehouse.receiveAllotExwhConfirmBill";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String sendAllotInwhNoticeBill(WhOpstoreDomain whOpstoreDomain, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.diswarehouse.sendPurchasewhWarehousingNoticeBill";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("whOpstoreDomain", whOpstoreDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String receiveAllotInwhConfirmBill(String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.diswarehouse.receiveWarehousingConfirmationNotice";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String receivePurchaseRefundConfirmBill(String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.diswarehouse.receivePurchaseRefundConfirmBill";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public List<WhGoodsBean> getNewStockById(List<WhGoodsBean> whGoodsBeanList, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.diswarehouse.getNewStockById";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("memberCode", memberCode);
        param.put("memberCode", memberCode);
        param.put("whGoodsBeanList", whGoodsBeanList);
        param.put("tenantCode", tenantCode);
        return (List)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String querySynchronizeCommodityInventory(String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.diswarehouse.querySynchronizeCommodityInventory";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }
}

