/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.fnps.common;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ext.channel.discom.api.DisSignService;
import com.yqbsoft.laser.service.ext.channel.fnps.FnpsConstants;
import com.yqbsoft.laser.service.ext.channel.fnps.common.SHA1Util;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DisSignServiceImpl
extends BaseServiceImpl
implements DisSignService {
    public String sign(Map<String, Object> paramMap, Map<String, String> configMap) {
        if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(configMap) || StringUtils.isBlank((String)configMap.get(FnpsConstants.serviceUrl)) || StringUtils.isBlank((String)"action")) {
            return "ERROR";
        }
        String path = configMap.get(FnpsConstants.serviceUrl) + configMap.get("action");
        TreeMap<String, Object> pMap = new TreeMap<String, Object>();
        pMap.putAll(paramMap);
        String sign = DisSignServiceImpl.fetchRealPath(pMap, path, configMap.get("secret"));
        if (StringUtils.isBlank((String)sign)) {
            return "ERROR";
        }
        paramMap.put("sign", sign);
        configMap.put(FnpsConstants.serviceUrl, configMap.get(FnpsConstants.serviceUrl) + configMap.get("action"));
        return "SUCCESS";
    }

    public boolean verifySign(Map<String, Object> paramMap, Map<String, String> configMap) {
        return true;
    }

    public static String fetchRealPath(Map<String, Object> map, String url, String secret) {
        if (MapUtil.isEmpty(map) || StringUtils.isEmpty((String)url) || StringUtils.isEmpty((String)secret)) {
            return null;
        }
        String param = DisSignServiceImpl.sortParam(map);
        return DisSignServiceImpl.buildUrl(url, param, secret);
    }

    public static String buildUrl(String url, String param, String secret) {
        if (StringUtils.isEmpty((String)url) || StringUtils.isEmpty((String)param) || StringUtils.isEmpty((String)secret)) {
            return null;
        }
        String sign = "";
        try {
            sign = SHA1Util.Sha1(secret + param).toLowerCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sign;
    }

    public static String sortParam(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isEmpty((String)map.get("timestamp").toString())) {
            long timestamp = new Date().getTime() / 1000L;
            map.put("timestamp", String.valueOf(timestamp));
        }
        Set<String> keySet = map.keySet();
        ArrayList<String> keyList = new ArrayList<String>(keySet);
        Collections.sort(keyList);
        StringBuilder signStr = new StringBuilder();
        for (String key : keyList) {
            String valueString;
            Object value;
            if (key.equals("sign") || (value = map.get(key)) == null || value.getClass().isArray() && Byte.TYPE.isAssignableFrom(value.getClass().getComponentType()) || StringUtils.isEmpty((String)(valueString = value.toString()))) continue;
            signStr.append(key).append(value);
        }
        return signStr.toString();
    }
}

