/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.fnps.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CaseFormat;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ext.channel.discom.api.DisSignService;
import com.yqbsoft.laser.service.ext.channel.fnps.FnpsConstants;
import com.yqbsoft.laser.service.ext.channel.fnps.common.utils.OpenapiSignatureUtils;
import com.yqbsoft.laser.service.ext.channel.fnps.config.Config;
import com.yqbsoft.laser.service.ext.channel.fnps.config.oauth.response.Token;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisSignServiceImpl
extends BaseServiceImpl
implements DisSignService {
    private static final Logger log = LoggerFactory.getLogger(DisSignServiceImpl.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final boolean IS_SANDBOX = true;
    private static final String APP_ID = "6725558136761423540";
    private static final String MERCHANT_ID = "4683547";
    private static final String SECRET_KEY = "96c38a16-a9ed-4828-8686-304f32bd1db6";
    private static final Config CONFIG = new Config(true, "6725558136761423540", "96c38a16-a9ed-4828-8686-304f32bd1db6");
    private static final Token TOKEN = new Token();

    public String sign(Map<String, Object> paramMap, Map<String, String> configMap) {
        this.logger.error("sign----paramMap-----", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
        this.logger.error("sign----configMap-----", (Object)JsonUtil.buildNormalBinder().toJson(configMap));
        HashMap<String, Object> bsMap = new HashMap<String, Object>();
        bsMap.putAll(paramMap);
        bsMap.remove("app_id");
        bsMap.remove("merchant_id");
        bsMap.remove("access_token");
        bsMap.remove("secret_key");
        bsMap.remove("version");
        bsMap.remove("timestamp");
        bsMap.remove("business_data");
        this.logger.error("bsmap++++++++++++++++++++++++", (Object)JsonUtil.buildNormalBinder().toJson(bsMap));
        String appId = configMap.get("app_id");
        String merchantId = configMap.get("merchant_id");
        String timestamp = String.valueOf(System.currentTimeMillis());
        String accessToken = configMap.get("access_token");
        String businessData = JsonUtil.buildNormalBinder().toJson(bsMap);
        String appSecret = configMap.get("secret_key");
        String sortedParamsStr = OpenapiSignatureUtils.sortApiParams(appId, merchantId, timestamp, accessToken, businessData);
        this.logger.error("sortedParamsStr+++++++++++++++++++++", (Object)sortedParamsStr);
        String signature = OpenapiSignatureUtils.genSignature(appSecret, sortedParamsStr);
        if (StringUtils.isBlank((String)signature)) {
            this.logger.error("getDeliveryArea.sendCall.sign", (Object)"sendCall is null");
            return "ERROR";
        }
        paramMap.put("signature", signature);
        configMap.put(FnpsConstants.serviceUrl, configMap.get(FnpsConstants.serviceUrl) + configMap.get("action"));
        this.logger.error("signature---------------------", (Object)signature);
        return "SUCCESS";
    }

    public boolean verifySign(Map<String, Object> paramMap, Map<String, String> configMap) {
        return true;
    }

    public static String sortTokenParams(String code, String appId, String merchantId, String timestamp) {
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("grant_type", "CODE");
        pMap.put("code", code);
        pMap.put("app_id", appId);
        pMap.put("merchant_id", merchantId);
        pMap.put("timestamp", timestamp);
        return DisSignServiceImpl.sortParams(pMap);
    }

    public static String sortRefreshTokenParams(String appId, String merchantId, String timestamp, String refreshToken) {
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("grant_type", "CODE");
        pMap.put("app_id", appId);
        pMap.put("merchant_id", merchantId);
        pMap.put("timestamp", timestamp);
        pMap.put("refresh_token", refreshToken);
        return DisSignServiceImpl.sortParams(pMap);
    }

    public static String sortApiParams(String appId, String merchantId, String timeStamp, String accessToken, String businessData) {
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("app_id", appId);
        pMap.put("merchant_id", merchantId);
        pMap.put("timestamp", timeStamp);
        pMap.put("version", "1.0");
        pMap.put("access_token", accessToken);
        pMap.put("business_data", businessData);
        return DisSignServiceImpl.sortParams(pMap);
    }

    public static String getOpenapiResultSign(String businessData, String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", "200");
        map.put("msg", "success");
        map.put("business_data", businessData);
        String sortParam = DisSignServiceImpl.sortParams(map);
        return DisSignServiceImpl.genSignature(appSecret, sortParam);
    }

    public static String genSignature(String appSecret, String toSignPara) {
        return DisSignServiceImpl.getSHA256(appSecret + toSignPara);
    }

    private static String getSHA256(String str) {
        String encodestr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodestr = DisSignServiceImpl.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("getSHA256 NoSuchAlgorithmException: {}", (Object)e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            log.error("getSHA256 UnsupportedEncodingException: {}", (Object)e.getMessage());
        }
        return encodestr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

    private static String generateJsonWithSnakeCaseKey(Object object) {
        if (null == object) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("JsonUtil.generateNoException failed", (Throwable)e);
            return null;
        }
    }

    public static String sortParams(Map<String, String> paramMap) {
        ArrayList<String> keys = new ArrayList<String>(paramMap.keySet());
        Collections.sort(keys);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = paramMap.get(key);
            if (value == null || value.length() == 0) continue;
            content.append(i == 0 ? "" : "&").append(key).append("=").append(value);
        }
        return content.toString();
    }

    public static String camelToUnderscore(String str) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, str);
    }

    static {
        TOKEN.setAccessToken("");
        TOKEN.setAppId(APP_ID);
        TOKEN.setMerchantId(MERCHANT_ID);
    }
}

