/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.fnps.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.CaseFormat;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenapiSignatureUtils {
    private static final Logger log = LoggerFactory.getLogger(OpenapiSignatureUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String sortTokenParams(String code, String appId, String merchantId, String timestamp) {
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("grant_type", "CODE");
        pMap.put("code", code);
        pMap.put("app_id", appId);
        pMap.put("merchant_id", merchantId);
        pMap.put("timestamp", timestamp);
        return OpenapiSignatureUtils.sortParams(pMap);
    }

    public static String sortRefreshTokenParams(String appId, String merchantId, String timestamp, String refreshToken) {
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("grant_type", "CODE");
        pMap.put("app_id", appId);
        pMap.put("merchant_id", merchantId);
        pMap.put("timestamp", timestamp);
        pMap.put("refresh_token", refreshToken);
        return OpenapiSignatureUtils.sortParams(pMap);
    }

    public static String sortApiParams(String appId, String merchantId, String timeStamp, String accessToken, String businessData) {
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("app_id", appId);
        pMap.put("merchant_id", merchantId);
        pMap.put("timestamp", timeStamp);
        pMap.put("access_token", accessToken);
        pMap.put("business_data", businessData);
        return OpenapiSignatureUtils.sortParams(pMap);
    }

    public static String genSignature(String appSecret, String toSignPara) {
        return OpenapiSignatureUtils.getSHA256(appSecret + toSignPara);
    }

    private static String getSHA256(String str) {
        String encodestr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodestr = OpenapiSignatureUtils.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("getSHA256 NoSuchAlgorithmException: {}", (Object)e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            log.error("getSHA256 UnsupportedEncodingException: {}", (Object)e.getMessage());
        }
        return encodestr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

    private static String generateJsonWithSnakeCaseKey(Object object) {
        if (null == object) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("JsonUtil.generateNoException failed", (Throwable)e);
            return null;
        }
    }

    public static String sortParams(Map<String, String> paramMap) {
        ArrayList<String> keys = new ArrayList<String>(paramMap.keySet());
        Collections.sort(keys);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = paramMap.get(key);
            if (value == null || value.length() == 0) continue;
            content.append(i == 0 ? "" : "&").append(key).append("=").append(value);
        }
        return content.toString();
    }

    public static String camelToUnderscore(String str) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, str);
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        OBJECT_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        OBJECT_MAPPER.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }
}

