/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.fnps.demo;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.ext.channel.fnps.common.exception.ServiceException;
import com.yqbsoft.laser.service.ext.channel.fnps.config.Config;
import com.yqbsoft.laser.service.ext.channel.fnps.config.oauth.response.Token;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.order.CancelOrderReq;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.order.CancelOrderRes;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.order.ChainstoreRangeReq;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.order.ChainstoreRangeRes;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.order.CreateOrderReq;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.order.CreateOrderRes;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.order.GetOrderDetailReq;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.order.GetOrderDetailRes;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.order.OrderItemOpenapiDTO;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.order.PreCancelOrderReq;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.order.PreCancelOrderRes;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.order.PreCreateOrderReq;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.order.PreCreateOrderRes;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.shop.ChainstoreCreateReq;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.shop.ChainstoreCreateRes;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.shop.UploadImgReq;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.shop.UploadImgRes;
import com.yqbsoft.laser.service.ext.channel.fnps.service.order.OrderService;
import com.yqbsoft.laser.service.ext.channel.fnps.service.shop.ShopService;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientDemo {
    private static final Logger log = LoggerFactory.getLogger(HttpClientDemo.class);
    private static final boolean IS_SANDBOX = true;
    private static final String APP_ID = "6725558136761423540";
    private static final String MERCHANT_ID = "4683547";
    private static final String SECRET_KEY = "96c38a16-a9ed-4828-8686-304f32bd1db6";
    private static final Config CONFIG = new Config(true, "6725558136761423540", "96c38a16-a9ed-4828-8686-304f32bd1db6");
    private static final Token TOKEN = new Token();

    public static void main(String[] args) {
        HttpClientDemo demo = new HttpClientDemo();
        demo.chainstoreRangeTest();
    }

    private void uploadImgTest() {
        ShopService shopService = new ShopService(CONFIG, TOKEN);
        UploadImgReq uploadImgReq = new UploadImgReq();
        uploadImgReq.setFileType("jpg");
        String base64Str = "";
        uploadImgReq.setFileBinary(base64Str);
        try {
            UploadImgRes uploadImgRes = shopService.uploadImg(uploadImgReq);
            log.info("uploadImgRes:{}", (Object)JSON.toJSONString((Object)uploadImgRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void chainstoreCreateTest() {
        ShopService shopService = new ShopService(CONFIG, TOKEN);
        ChainstoreCreateReq chainstoreCreateReq = new ChainstoreCreateReq();
        chainstoreCreateReq.setHeadShopName("swift");
        chainstoreCreateReq.setBranchShopName("\u4e0a\u6d77");
        chainstoreCreateReq.setChainStoreType(1);
        chainstoreCreateReq.setContactPhone("17700000000");
        chainstoreCreateReq.setAddress("\u4e0a\u6d77");
        chainstoreCreateReq.setLongitude("118.1342");
        chainstoreCreateReq.setLatitude("40.235");
        chainstoreCreateReq.setPositionSource(3);
        chainstoreCreateReq.setOutShopCode("testKFC003444");
        chainstoreCreateReq.setCategoryId("12");
        chainstoreCreateReq.setOwnerName("\u5e78\u7acb\u677e");
        chainstoreCreateReq.setOwnerIdNum("500101199807137499");
        chainstoreCreateReq.setHandheldLicencePicHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        chainstoreCreateReq.setOwnerIdPicBackHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        chainstoreCreateReq.setOwnerIdPicFrontHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        chainstoreCreateReq.setCreditCode("910X11103345");
        chainstoreCreateReq.setBusinessLicencePicHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        chainstoreCreateReq.setFoodLicensePicHash("d7c64022f6458f9aa76968e01f5686c5jpeg");
        try {
            ChainstoreCreateRes chainstoreCreateRes = shopService.createChainstore(chainstoreCreateReq);
            log.info("chainstoreCreateRes:{}", (Object)JSON.toJSONString((Object)chainstoreCreateRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void chainstoreRangeTest() {
        OrderService OrderService2 = new OrderService(CONFIG, TOKEN);
        ChainstoreRangeReq chainstoreRangeReq = new ChainstoreRangeReq();
        chainstoreRangeReq.setChainStoreId(206650091);
        try {
            ChainstoreRangeRes chainstoreRangeRes = OrderService2.chainstoreRange(chainstoreRangeReq);
            log.info("chainstoreRangeRes:{}", (Object)JSON.toJSONString((Object)chainstoreRangeRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void preCreateOrderTest() {
        OrderService OrderService2 = new OrderService(CONFIG, TOKEN);
        PreCreateOrderReq preCreateOrderReq = new PreCreateOrderReq();
        preCreateOrderReq.setChainStoreId(203040091L);
        preCreateOrderReq.setPartnerOrderCode("JSD4101231333235567");
        preCreateOrderReq.setBaseGoodsId(3000);
        preCreateOrderReq.setOrderSource(4);
        preCreateOrderReq.setOrderType(1);
        preCreateOrderReq.setPositionSource(3);
        preCreateOrderReq.setReceiverAddress("\u5317\u4eac\u5e02\u660c\u5e73\u533a\u4e2d\u4e1c\u8def0000");
        preCreateOrderReq.setReceiverLatitude(40.039115);
        preCreateOrderReq.setReceiverLongitude(116.39685489017384);
        preCreateOrderReq.setGoodsTotalAmountCent(1000L);
        preCreateOrderReq.setGoodsActualAmountCent(1000L);
        preCreateOrderReq.setRequireReceiveTime(System.currentTimeMillis() + 3600000L);
        preCreateOrderReq.setGoodsWeight(0.1);
        preCreateOrderReq.setGoodsCount(1);
        OrderItemOpenapiDTO orderItemOpenapiDTO = new OrderItemOpenapiDTO();
        orderItemOpenapiDTO.setItemName("KFC\u6c49\u5821\u4e00\u6253");
        orderItemOpenapiDTO.setItemQuantity(2);
        orderItemOpenapiDTO.setItemActualAmountCent(500L);
        orderItemOpenapiDTO.setItemAmountCent(500L);
        ArrayList<OrderItemOpenapiDTO> goodsItemList = new ArrayList<OrderItemOpenapiDTO>();
        goodsItemList.add(orderItemOpenapiDTO);
        preCreateOrderReq.setGoodsItemList(goodsItemList);
        log.info("preCreateOrderReq:{}", (Object)JSON.toJSONString((Object)preCreateOrderReq));
        try {
            PreCreateOrderRes preCreateOrderRes = OrderService2.preCreateOrder(preCreateOrderReq);
            log.info("preCreateOrderRes:{}", (Object)JSON.toJSONString((Object)preCreateOrderRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void getOrderDetailTest() {
        OrderService OrderService2 = new OrderService(CONFIG, TOKEN);
        try {
            GetOrderDetailReq orderDetailReq = new GetOrderDetailReq();
            orderDetailReq.setPartnerOrderCode("232232999uuF21");
            GetOrderDetailRes orderDetail = OrderService2.getOrderDetail(orderDetailReq);
            log.info("orderDetail:{}", (Object)JSON.toJSONString((Object)orderDetail));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void createOrderTest() {
        OrderService OrderService2 = new OrderService(CONFIG, TOKEN);
        CreateOrderReq createOrderReq = new CreateOrderReq();
        createOrderReq.setChainStoreId("206650091");
        createOrderReq.setPartnerOrderCode("JSD4101231333235567");
        createOrderReq.setBaseGoodsId("3000");
        createOrderReq.setOrderSource("4");
        createOrderReq.setOrderType(1);
        createOrderReq.setPositionSource(3);
        createOrderReq.setReceiverAddress("\u4e0a\u6d77\u5e02\u524d\u6ee9\u4f01\u4e1a\u5929\u5730");
        createOrderReq.setReceiverLatitude(40.039115);
        createOrderReq.setReceiverLongitude(116.307892);
        createOrderReq.setGoodsTotalAmountCent(1000L);
        createOrderReq.setGoodsActualAmountCent(1000L);
        createOrderReq.setRequireReceiveTime(System.currentTimeMillis() + 3600000L);
        createOrderReq.setGoodsWeight(0.1);
        createOrderReq.setGoodsCount(1);
        createOrderReq.setReceiverName("\u5f20\u4e09");
        createOrderReq.setReceiverPrimaryPhone("13123454567");
        OrderItemOpenapiDTO orderItemOpenapiDTO = new OrderItemOpenapiDTO();
        orderItemOpenapiDTO.setItemName("KFC\u6c49\u5821\u4e00\u6253");
        orderItemOpenapiDTO.setItemQuantity(2);
        orderItemOpenapiDTO.setItemActualAmountCent(500L);
        orderItemOpenapiDTO.setItemAmountCent(500L);
        ArrayList<OrderItemOpenapiDTO> goodsItemList = new ArrayList<OrderItemOpenapiDTO>();
        goodsItemList.add(orderItemOpenapiDTO);
        createOrderReq.setGoodsItemList(goodsItemList);
        log.info("createOrderReq:{}", (Object)JSON.toJSONString((Object)createOrderReq));
        try {
            CreateOrderRes order = OrderService2.createOrder(createOrderReq);
            log.info("order:{}", (Object)JSON.toJSONString((Object)order));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void preCancelOrderTest() {
        OrderService OrderService2 = new OrderService(CONFIG, TOKEN);
        try {
            PreCancelOrderReq orderDetailReq = new PreCancelOrderReq();
            orderDetailReq.setPartnerOrderCode("232232999uuF21");
            PreCancelOrderRes preCancelOrderRes = OrderService2.preCancelOrder(orderDetailReq);
            log.info("preCancelOrderRes:{}", (Object)JSON.toJSONString((Object)preCancelOrderRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    private void cancelOrderTest() {
        OrderService OrderService2 = new OrderService(CONFIG, TOKEN);
        try {
            CancelOrderReq orderDetailReq = new CancelOrderReq();
            orderDetailReq.setPartnerOrderCode("232232999uuF21");
            orderDetailReq.setOrderCancelRole(2);
            orderDetailReq.setOrderCancelCode(32);
            CancelOrderRes cancelOrderRes = OrderService2.cancelOrder(orderDetailReq);
            log.info("cancelOrderRes:{}", (Object)JSON.toJSONString((Object)cancelOrderRes));
        }
        catch (ServiceException e) {
            log.info("ServiceException\uff0ce:{}", (Throwable)e);
        }
    }

    static {
        TOKEN.setAccessToken("");
        TOKEN.setAppId(APP_ID);
        TOKEN.setMerchantId(MERCHANT_ID);
    }
}

