/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.haihang.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelInBaseService;
import com.yqbsoft.laser.service.ext.channel.haihang.HaihangConstants;
import com.yqbsoft.laser.service.ext.channel.haihang.util.Base64;
import com.yqbsoft.laser.service.ext.channel.haihang.util.HttpRequestUtils;
import com.yqbsoft.laser.service.ext.channel.haihang.util.Pboc3desmac;
import com.yqbsoft.laser.service.ext.channel.haihang.util.SignUtilsImpl;
import com.yqbsoft.laser.service.ext.channel.haihang.util.SymmtricCryptoUtil;
import com.yqbsoft.laser.service.ext.channel.haihang.util.XmlUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class ChannelInServiceImpl
extends ChannelInBaseService {
    private static final String SYS_CODE = "haihang.ChannelInServiceImpl";

    public String getFchannelCode() {
        return HaihangConstants.CHANNEL_CODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String httpInvoke(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            this.logger.error("haihang.ChannelInServiceImpl.sign.channelRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("haihang.ChannelInServiceImpl.sign.null", "");
        }
        CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        Map configMap = channelRequest.getConfigMap();
        String applyUrl = (String)configMap.get("url");
        Map data = channelRequest.getRequestData();
        this.logger.error("haihang.ChannelInServiceImpl.httpInvoke.data", (Object)JsonUtil.buildNormalBinder().toJson((Object)data));
        Map orderNoMap = JsonUtil.buildNormalBinder().getJsonToMap((String)data.get("orderNoMap"), String.class, String.class);
        BigDecimal amount = cmChannelClear.getOrderAmount().setScale(2, 5).multiply(new BigDecimal("100")).setScale(0, 5);
        String amountStr = amount.toString();
        Map noMap = JsonUtil.buildNormalBinder().getJsonToMap((String)orderNoMap.get(amountStr), String.class, String.class);
        String rep = (String)noMap.get("order_no");
        String ptradeSeqno = (String)noMap.get("ptradeSeqno");
        this.logger.info("ChannelBaseSignService.sendPayApply.rep", (Object)(cmChannelClear.getChannelClearSeqno() + "=:=" + rep));
        if (StringUtils.isBlank((String)rep)) {
            return this.makeResp(rep, cmChannelClear.getChannelClearSeqno(), "FAIL");
        }
        HashMap requestData = new HashMap();
        requestData.put("dpcode", configMap.get("dpcode"));
        requestData.put("order_no", rep);
        requestData.put("opfare", amountStr);
        requestData.put("out_trade_no", ptradeSeqno);
        HashMap applyMap = new HashMap();
        applyMap.put("commit", requestData);
        String reqXml = XmlUtil.covertXML(JsonUtil.buildNonNullBinder().toJson(applyMap), "vcardpay");
        HashMap<String, String> requestParam = new HashMap<String, String>();
        requestParam.put("service_type", "vcardpay_commit");
        requestParam.put("partnerid", (String)configMap.get("partnerid"));
        requestParam.put("request_xml", reqXml);
        String result = "";
        long timeMillis = System.currentTimeMillis();
        try {
            String req = Base64.encode(SymmtricCryptoUtil.symmtricCrypto(reqXml.getBytes(), Base64.decode((String)configMap.get("3des")), "DESede", 1));
            requestParam.put("request_xml", req);
            String sortStr = Pboc3desmac.sort(requestParam);
            requestParam.put("sign", URLEncoder.encode(new SignUtilsImpl().sign(sortStr, (String)configMap.get("rsa_private_key"), "SHA1withRSA"), "UTF-8"));
            requestParam.put("request_xml", URLEncoder.encode(req, "UTF-8"));
            result = HttpRequestUtils.sendHttpRequestForm(applyUrl, requestParam);
            this.logger.info("ChannelBaseSignService.requestData.commitpay.result", (Object)(cmChannelClear.getChannelClearSeqno() + "=:=" + result));
            String request_xml = result.split("&")[1].toString().split("=")[1].toString();
            String successflag = result.split("&")[0].toString();
            byte[] decode = Base64.decode(URLDecoder.decode(request_xml, "UTF-8"));
            if (decode.length <= 0) {
                String string = this.makeResp(result, cmChannelClear.getChannelClearSeqno(), "FAIL");
                return string;
            }
            String jmrequest_xml = new String(SymmtricCryptoUtil.symmtricCrypto(decode, Base64.decode((String)configMap.get("3des")), "DESede", 2));
            this.logger.error("ChannelInBaseService.commitpay.jmrequest_xml", (Object)(cmChannelClear.getChannelClearSeqno() + "=:=" + jmrequest_xml));
        }
        catch (Exception e) {
            this.logger.error("haihang.ChannelInServiceImpl.commitpay.doPost", (Object)(cmChannelClear.getChannelClearSeqno() + "=:=" + applyUrl + " =:= " + requestParam), (Throwable)e);
            e.printStackTrace();
            this.makeResp(result, cmChannelClear.getChannelClearSeqno(), "FAIL");
        }
        finally {
            this.logger.error("haihang.ChannelInServiceImpl.httpInvoke.time", (Object)(System.currentTimeMillis() - timeMillis));
        }
        this.logger.error("haihang.ChannelInServiceImpl.httpInvoke.rep.success", (Object)result);
        return this.makeResp(result, cmChannelClear.getChannelClearSeqno(), "SUCCESS");
    }

    public String makeResp(String rep, String tradeNo, String tradeStatus) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("'out_trade_no'", rep);
        resultMap.put("trade_no", tradeNo);
        resultMap.put("trade_status", tradeStatus);
        return JsonUtil.buildNormalBinder().toJson(resultMap);
    }

    private String sendPayApply(ChannelRequest channelRequest, String applyUrl) {
        CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        Map requestData = channelRequest.getRequestData();
        this.logger.error("haihang.ChannelInServiceImpl.httpInvoke", (Object)(cmChannelClear.getChannelClearSeqno() + "=:=" + applyUrl + " =:= " + JsonUtil.buildNormalBinder().toJson((Object)requestData)));
        String rep = "";
        long timeMillis = System.currentTimeMillis();
        try {
            String result = HttpRequestUtils.sendHttpRequestForm(applyUrl, requestData);
            this.logger.error("ChannelInBaseService.sendPayApply.httpInvoke.result", (Object)(cmChannelClear.getChannelClearSeqno() + "=:=" + result));
            String request_xml = result.split("&")[1].split("=")[1];
            byte[] decode = Base64.decode(URLDecoder.decode(request_xml, "UTF-8"));
            if (decode.length <= 0) {
                return null;
            }
            String jmrequest_xml = new String(SymmtricCryptoUtil.symmtricCrypto(decode, Base64.decode((String)channelRequest.getConfigMap().get("3des")), "DESede", 2));
            this.logger.error("ChannelInBaseService.aplly", (Object)(cmChannelClear.getChannelClearSeqno() + "=:=" + jmrequest_xml));
            JSONObject jsonObject = XmlUtil.xml2Json(jmrequest_xml);
            Object applyreturn = jsonObject.get((Object)"applyreturn");
            String applyreturnJson = JsonUtil.buildNormalBinder().toJson(applyreturn);
            Map jsonToMap = (Map)JSON.parseObject((String)applyreturnJson, Map.class);
            return (String)jsonToMap.get("order_no");
        }
        catch (Exception e) {
            this.logger.error("haihang.ChannelInServiceImpl.apply.doPost", (Object)(cmChannelClear.getChannelClearSeqno() + "=:=" + applyUrl + " =:= " + requestData), (Throwable)e);
            this.logger.error("haihang.ChannelInServiceImpl.httpInvoke.time.sendPayApply", (Object)(System.currentTimeMillis() - timeMillis));
            e.printStackTrace();
            return null;
        }
    }

    public static void main1(String[] args) {
        BigDecimal baseDomain = new BigDecimal(1.04);
        BigDecimal amount = baseDomain.setScale(2, 5);
        System.out.println(amount);
        amount = amount.multiply(new BigDecimal("100")).setScale(0, 5);
        System.out.println(amount);
    }
}

