/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.haihang.service;

import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelReBaseService;
import com.yqbsoft.laser.service.ext.channel.haihang.HaihangConstants;
import com.yqbsoft.laser.service.ext.channel.haihang.util.Base64;
import com.yqbsoft.laser.service.ext.channel.haihang.util.HttpRequestUtils;
import com.yqbsoft.laser.service.ext.channel.haihang.util.Pboc3desmac;
import com.yqbsoft.laser.service.ext.channel.haihang.util.SignUtilsImpl;
import com.yqbsoft.laser.service.ext.channel.haihang.util.SymmtricCryptoUtil;
import com.yqbsoft.laser.service.ext.channel.haihang.util.XmlUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class ChannelReServiceImpl
extends ChannelReBaseService {
    private static final String CODE = "cmc.ChannelInServiceImpl";

    public String getFchannelCode() {
        return HaihangConstants.CHANNEL_CODE;
    }

    protected String httpInvoke(ChannelRequest channelRequest) {
        Map configMap = channelRequest.getConfigMap();
        CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        HashMap requestData = new HashMap();
        requestData.put("dpcode", configMap.get("dpcode"));
        requestData.put("order_no", null);
        HashMap applyMap = new HashMap();
        applyMap.put("refund", requestData);
        String reqXml = XmlUtil.covertXML(JsonUtil.buildNonNullBinder().toJson(applyMap), "vcardpay");
        HashMap<String, String> requestParam = new HashMap<String, String>();
        requestParam.put("service_type", "vcardpay_refund");
        requestParam.put("partnerid", (String)configMap.get("partnerid"));
        requestParam.put("request_xml", reqXml);
        String result = "";
        try {
            String req = Base64.encode(SymmtricCryptoUtil.symmtricCrypto(reqXml.getBytes(), Base64.decode((String)configMap.get("3des")), "DESede", 1));
            requestParam.put("request_xml", req);
            String sortStr = Pboc3desmac.sort(requestParam);
            this.logger.info("ChannelReBaseService.requestData.refund.sortStr", (Object)(cmChannelClear.getClearOrderSeqno() + "=:=" + sortStr));
            requestParam.put("sign", URLEncoder.encode(new SignUtilsImpl().sign(sortStr, (String)configMap.get("rsa_private_key"), "SHA1withRSA"), "UTF-8"));
            requestParam.put("request_xml", URLEncoder.encode(req, "UTF-8"));
            result = HttpRequestUtils.sendHttpRequestForm((String)configMap.get("url"), requestParam);
            this.logger.info("ChannelReBaseService.requestData.refund.result", (Object)(cmChannelClear.getClearOrderSeqno() + "=:=" + result));
            String request_xml = result.split("&")[1].toString().split("=")[1].toString();
            this.logger.info("ChannelReBaseService.requestData.refund.request_xml", (Object)(cmChannelClear.getClearOrderSeqno() + "=:=" + URLDecoder.decode(request_xml, "UTF-8")));
            String successflag = result.split("&")[0].toString();
            byte[] decode = Base64.decode(URLDecoder.decode(request_xml, "UTF-8"));
            if (decode.length <= 0) {
                return this.makeResp(result, cmChannelClear.getClearOrderSeqno(), "FAIL");
            }
            String jmrequest_xml = new String(SymmtricCryptoUtil.symmtricCrypto(decode, Base64.decode((String)configMap.get("3des")), "DESede", 2));
            this.logger.error("ChannelReBaseService.refund.jmrequest_xml", (Object)(cmChannelClear.getClearOrderSeqno() + "=:=" + jmrequest_xml));
        }
        catch (Exception e) {
            this.logger.error("cmc.ChannelReBaseService.refund.doPost", (Object)(cmChannelClear.getClearOrderSeqno() + "=:=" + (String)configMap.get("url") + " =:= " + requestParam), (Throwable)e);
            e.printStackTrace();
            return this.makeResp(result, cmChannelClear.getClearOrderSeqno(), "false");
        }
        this.logger.error("cmc.ChannelReBaseService.httpInvoke.refund.rep.success", (Object)result);
        return this.makeResp(result, cmChannelClear.getClearOrderSeqno(), "true");
    }

    public String makeResp(String rep, String tradeNo, String tradeStatus) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("'out_trade_no'", rep);
        resultMap.put("trade_no", tradeNo);
        resultMap.put("trade_status", tradeStatus);
        return JsonUtil.buildNormalBinder().toJson(resultMap);
    }
}

