/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.haihang.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpRequestUtils {
    static RegistryBuilder<ConnectionSocketFactory> registryBuilder = RegistryBuilder.create();
    private static final ThreadLocal<HttpResponse> HTTPRESPONSETHREADLOCAL;
    public static PoolingHttpClientConnectionManager manager;
    public static HttpClient HTTP_CLIENT;

    public static String sendHttpRequestForm(String url, Map<String, String> requestData) throws IOException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entity : requestData.entrySet()) {
            params.add(new BasicNameValuePair(entity.getKey(), entity.getValue()));
        }
        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(params, Consts.UTF_8);
        return HttpRequestUtils.sendHttpRequestForm(url, (HttpEntity)formEntity, null);
    }

    private static final String sendHttpRequestForm(String url, HttpEntity formEntity, Map<String, String> headers) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(15000).build();
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
        httpPost.setEntity(formEntity);
        if (headers != null) {
            for (String name : headers.keySet()) {
                httpPost.setHeader(name, headers.get(name));
            }
        }
        HttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)httpPost);
        HTTPRESPONSETHREADLOCAL.set(response);
        HttpEntity entity = response.getEntity();
        InputStream is = entity.getContent();
        Header encodingHeader = entity.getContentEncoding();
        Charset contentEncoding = encodingHeader == null ? Consts.UTF_8 : Charset.forName(encodingHeader.getValue());
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, contentEncoding));
        String responseData = IOUtils.toString((Reader)reader);
        EntityUtils.consume((HttpEntity)entity);
        return responseData;
    }

    public static final String getHeader(String name) {
        Header header;
        HttpResponse httpResponse = HTTPRESPONSETHREADLOCAL.get();
        if (httpResponse != null && (header = httpResponse.getFirstHeader(name)) != null) {
            return header.getValue();
        }
        return null;
    }

    public static final Header[] getHeaders() {
        HttpResponse httpResponse = HTTPRESPONSETHREADLOCAL.get();
        if (httpResponse != null) {
            return httpResponse.getAllHeaders();
        }
        return null;
    }

    static {
        PlainConnectionSocketFactory plainSF = new PlainConnectionSocketFactory();
        registryBuilder.register("http", (Object)plainSF);
        SSLContext ssl = SSLContexts.createSystemDefault();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(ssl);
        registryBuilder.register("https", (Object)sslsf);
        HTTPRESPONSETHREADLOCAL = new ThreadLocal();
        manager = new PoolingHttpClientConnectionManager(registryBuilder.build());
        manager.setMaxTotal(20);
        manager.setDefaultMaxPerRoute(5);
        HTTP_CLIENT = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).build();
    }
}

