/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.haihang.util;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.lang.StringUtils;

public class SignatureUtil {
    public static byte[] sign(byte[] text, byte[] privateKeyData, String algorithm) throws GeneralSecurityException {
        PrivateKey privateKey = SignatureUtil.getPrivateKey(privateKeyData, algorithm);
        Signature signatureChecker = Signature.getInstance(algorithm);
        signatureChecker.initSign(privateKey);
        signatureChecker.update(text);
        return signatureChecker.sign();
    }

    public static boolean verify(byte[] text, byte[] signedText, byte[] publicKeyData, String algorithm) throws GeneralSecurityException {
        PublicKey publicKey = SignatureUtil.getPublicKey(publicKeyData, algorithm);
        Signature signatureChecker = Signature.getInstance(algorithm);
        signatureChecker.initVerify(publicKey);
        signatureChecker.update(text);
        return signatureChecker.verify(signedText);
    }

    public static PublicKey getPublicKey(byte[] keyData, String algorithm) throws GeneralSecurityException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyData);
        KeyFactory keyFactory = KeyFactory.getInstance(StringUtils.substringAfter((String)algorithm, (String)"with"));
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static PrivateKey getPrivateKey(byte[] keyData, String algorithm) throws GeneralSecurityException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyData);
        KeyFactory keyFactory = KeyFactory.getInstance(StringUtils.substringAfter((String)algorithm, (String)"with"));
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }
}

