/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.haihang.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;

public class SymmtricCryptoUtil {
    public static byte[] symmtricCrypto(byte[] text, byte[] keyData, String algorithm, int mode) throws GeneralSecurityException {
        String fullAlg = algorithm + "/CBC/PKCS5Padding";
        byte[] iv = SymmtricCryptoUtil.initIv(fullAlg);
        return SymmtricCryptoUtil.doCrypto(text, keyData, iv, fullAlg, "CBC", "PKCS5Padding", mode);
    }

    public static byte[] symmtricCrypto(byte[] text, byte[] keyData, String algorithm, String padding, int mode) throws GeneralSecurityException {
        String fullAlg = algorithm + "/CBC/" + padding;
        byte[] iv = SymmtricCryptoUtil.initIv(fullAlg);
        return SymmtricCryptoUtil.doCrypto(text, keyData, iv, fullAlg, "CBC", padding, mode);
    }

    public static byte[] symmtricCrypto(byte[] text, byte[] keyData, String algorithm, String workingMode, String padding, int mode) throws GeneralSecurityException {
        String fullAlg = algorithm + "/" + workingMode + "/" + padding;
        byte[] iv = null;
        if (StringUtils.equals((String)workingMode, (String)"CBC")) {
            iv = SymmtricCryptoUtil.initIv(fullAlg);
        }
        return SymmtricCryptoUtil.doCrypto(text, keyData, iv, fullAlg, workingMode, padding, mode);
    }

    public static InputStream getInputStream(File file, byte[] keyData, String algorithm, int mode) throws IOException, GeneralSecurityException {
        return SymmtricCryptoUtil.getInputStream(file, keyData, algorithm, "CBC", "PKCS5Padding", mode);
    }

    public static InputStream getInputStream(File file, byte[] keyData, String algorithm, String workingMode, String padding, int mode) throws IOException, GeneralSecurityException {
        String fullAlg = algorithm + "/CBC/PKCS5Padding";
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] iv = SymmtricCryptoUtil.initIv(fullAlg);
        Cipher cipher = SymmtricCryptoUtil.getCipher(keyData, iv, fullAlg, workingMode, mode);
        return new CipherInputStream(fileInputStream, cipher);
    }

    public static OutputStream getOutputStream(File file, byte[] keyData, String algorithm, int mode) throws IOException, GeneralSecurityException {
        return SymmtricCryptoUtil.getOutputStream(file, keyData, algorithm, "CBC", "PKCS5Padding", mode);
    }

    public static OutputStream getOutputStream(File file, byte[] keyData, String algorithm, String workingMode, String padding, int mode) throws IOException, GeneralSecurityException {
        String fullAlg = algorithm + "/CBC/PKCS5Padding";
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] iv = SymmtricCryptoUtil.initIv(fullAlg);
        Cipher cipher = SymmtricCryptoUtil.getCipher(keyData, iv, fullAlg, workingMode, mode);
        return new CipherOutputStream(fileOutputStream, cipher);
    }

    public static byte[] doCrypto(byte[] text, byte[] keyData, byte[] iv, String fullAlg, String workingMode, String padding, int mode) throws GeneralSecurityException {
        if (!StringUtils.equals((String)workingMode, (String)"CBC") && !StringUtils.equals((String)workingMode, (String)"ECB")) {
            throw new GeneralSecurityException("\u9519\u8bef\u7684\u5de5\u4f5c\u6a21\u5f0f,\u76ee\u524dKMI\u53ea\u652f\u6301CBC\u548cECB\u4e24\u79cd\u5de5\u4f5c\u6a21\u5f0f");
        }
        if (!StringUtils.equals((String)padding, (String)"PKCS5Padding") && !StringUtils.equals((String)padding, (String)"NoPadding")) {
            throw new GeneralSecurityException("\u9519\u8bef\u7684\u586b\u5145\u6a21\u5f0f,\u76ee\u524dKMI\u53ea\u652f\u6301PKCS5Padding\u548cNoPadding\u4e24\u79cd\u5de5\u4f5c\u6a21\u5f0f");
        }
        if (mode != 1 && mode != 2) {
            throw new GeneralSecurityException("\u9519\u8bef\u7684\u52a0\u89e3\u5bc6\u6807\u8bc6,\u76ee\u524dKMI\u53ea\u652f\u6301Cipher.ENCRYPT_MODE\u548cCipher.DECRYPT_MODE");
        }
        Cipher cipher = SymmtricCryptoUtil.getCipher(keyData, iv, fullAlg, workingMode, mode);
        return cipher.doFinal(text);
    }

    private static Cipher getCipher(byte[] keyData, byte[] iv, String fullAlg, String workingMode, int mode) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(fullAlg);
        SecretKeySpec secretKey = new SecretKeySpec(keyData, StringUtils.substringBefore((String)fullAlg, (String)"/"));
        if (StringUtils.equals((String)workingMode, (String)"CBC")) {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(mode, (Key)secretKey, ivSpec);
        } else {
            cipher.init(mode, secretKey);
        }
        return cipher;
    }

    private static byte[] initIv(String fullAlg) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(fullAlg);
        int blockSize = cipher.getBlockSize();
        byte[] iv = new byte[blockSize];
        for (int i = 0; i < blockSize; ++i) {
            iv[i] = 0;
        }
        return iv;
    }
}

