/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.huifu.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.BasePay;
import com.huifu.bspay.sdk.opps.core.request.BaseRequest;
import com.huifu.bspay.sdk.opps.core.request.V2TradePaymentDelaytransConfirmRequest;
import com.huifu.bspay.sdk.opps.core.request.V2TradePaymentDelaytransConfirmqueryRequest;
import com.huifu.bspay.sdk.opps.core.request.V2TradePaymentDelaytransConfirmrefundRequest;
import com.huifu.bspay.sdk.opps.core.utils.DateTools;
import com.huifu.bspay.sdk.opps.core.utils.SequenceTools;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelSpBaseService;
import com.yqbsoft.laser.service.ext.channel.huifu.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.huifu.domain.OcContract;
import com.yqbsoft.laser.service.ext.channel.huifu.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.huifu.domain.PteBalanceop;
import com.yqbsoft.laser.service.ext.channel.huifu.init.OppsMerchantConfigDemo;
import com.yqbsoft.laser.service.ext.channel.huifu.util.BaseCommonDemo;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChannelSpBaseServiceImpl
extends ChannelSpBaseService {
    private static final String CODE = "cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl";
    private static String channelSpStart = "cmc.channelSp.channelSpStart";
    private static String channelSpQuery = "cmc.channelSp.channelSpQuery";
    private static String channelSpCannel = "cmc.channelSp.channelSpCannel";

    public String getFchannelCode() {
        return "huifu";
    }

    protected String httpInvoke(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            this.logger.error("cmc.ChannelSpBaseService.sign.channelRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("cmc.ChannelSpBaseService.sign.null", "");
        }
        this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.httpInvoke.channelRequest2", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
        if (channelSpStart.equals(channelRequest.getChannelApiCode())) {
            return this.delaytransConfirm(channelRequest);
        }
        if (channelSpQuery.equals(channelRequest.getChannelApiCode())) {
            return this.channelSpQuery(channelRequest);
        }
        if (channelSpCannel.equals(channelRequest.getChannelApiCode())) {
            return this.channelSpCannel(channelRequest);
        }
        return null;
    }

    private String channelSpQuery(ChannelRequest channelRequest) {
        Map configMap = channelRequest.getConfigMap();
        com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        if (cmChannelClear == null || StringUtils.isBlank((String)cmChannelClear.getBusinessOrderno())) {
            return null;
        }
        PteBalanceop pteBalanceop = this.queryBalanceopPage(cmChannelClear.getTenantCode(), cmChannelClear.getBusinessOrderno(), 3);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        this.doInit(configMap);
        V2TradePaymentDelaytransConfirmqueryRequest request = new V2TradePaymentDelaytransConfirmqueryRequest();
        request.setHuifuId((String)configMap.get("huifuId"));
        request.setOrgReqDate(pteBalanceop.getBusinessDes2());
        request.setOrgReqSeqId(pteBalanceop.getBusinessDes3());
        Map<String, Object> extendInfoMap = ChannelSpBaseServiceImpl.getExtendInfos();
        request.setExtendInfo(extendInfoMap);
        return this.doExecute((BaseRequest)request);
    }

    private static Boolean confirmquery(Map<String, String> configMap) {
        if (null == BasePay.getConfig(null)) {
            try {
                BaseCommonDemo.doInit(OppsMerchantConfigDemo.getMerchantConfig(configMap));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        V2TradePaymentDelaytransConfirmqueryRequest request = new V2TradePaymentDelaytransConfirmqueryRequest();
        request.setHuifuId(configMap.get("huifuId"));
        request.setOrgReqDate(configMap.get("orgReqDate"));
        request.setOrgReqSeqId(configMap.get("orgReqSeqId"));
        Map<String, Object> extendInfoMap = ChannelSpBaseServiceImpl.getExtendInfos();
        request.setExtendInfo(extendInfoMap);
        Map<String, Object> response = null;
        try {
            response = BaseCommonDemo.doExecute((BaseRequest)request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String result = null;
        if (MapUtil.isNotEmpty(response)) {
            if ("00000000".equals(response.get("resp_code"))) {
                return true;
            }
            return false;
        }
        System.out.println(result);
        return false;
    }

    private static void confirmrefund(Map<String, String> configMap) {
        if (null == BasePay.getConfig(null)) {
            try {
                BaseCommonDemo.doInit(OppsMerchantConfigDemo.getMerchantConfig(configMap));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        V2TradePaymentDelaytransConfirmrefundRequest request = new V2TradePaymentDelaytransConfirmrefundRequest();
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        request.setReqSeqId(configMap.get("reqSeqId"));
        request.setHuifuId(configMap.get("huifuId"));
        request.setOrgReqDate(configMap.get("orgReqDate"));
        request.setOrgReqSeqId(configMap.get("orgReqSeqId"));
        Map<String, Object> extendInfoMap = ChannelSpBaseServiceImpl.getExtendInfos();
        request.setExtendInfo(extendInfoMap);
        Map<String, Object> response = null;
        try {
            response = BaseCommonDemo.doExecute((BaseRequest)request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String result = null;
        if (MapUtil.isNotEmpty(response)) {
            result = JSONObject.toJSONString(response);
        }
        System.out.println("request:" + JsonUtil.buildNormalBinder().toJson((Object)request));
        System.out.println("response:" + result);
    }

    private String channelSpCannel(ChannelRequest channelRequest) {
        com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        if (cmChannelClear == null || StringUtils.isBlank((String)cmChannelClear.getBusinessOrderno())) {
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.channelSpCannel.cmChannelClear", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            return "error";
        }
        PteBalanceop pteBalanceop = this.queryBalanceopPage(cmChannelClear.getTenantCode(), cmChannelClear.getBusinessOrderno(), 3);
        if (pteBalanceop == null) {
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.channelSpCannel.pteBalanceop", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalanceop));
            return "error";
        }
        if (StringUtils.isBlank((String)pteBalanceop.getBalanceopExtension())) {
            pteBalanceop.setDataState(-1);
            this.updateBalanceop(pteBalanceop);
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.channelSpCannel.pteBalanceop-1", (Object)pteBalanceop.getBusinessOrder());
            return "success";
        }
        List<OcContract> contractList = this.queryContractPage(pteBalanceop);
        if (ListUtil.isEmpty(contractList)) {
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.channelSpCannel.queryContractPage", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalanceop));
            return "error";
        }
        OcContract ocContract = contractList.get(0);
        if (ListUtil.isEmpty(ocContract.getGoodsList())) {
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.channelSpCannel.getGoodsList is null", (Object)ocContract.getContractBillcode());
            return "error";
        }
        String result = this.updateBalanceopInfo(pteBalanceop, ocContract);
        if (pteBalanceop.getDataState() == -1 && ocContract.getDataState() > 2) {
            this.delaytransConfirm(channelRequest);
        }
        return result;
    }

    private String delaytransConfirm(ChannelRequest channelRequest) {
        Map configMap = channelRequest.getConfigMap();
        com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        if (cmChannelClear == null || StringUtils.isBlank((String)cmChannelClear.getBusinessOrderno())) {
            return "error";
        }
        String tenantCode = cmChannelClear.getTenantCode();
        OcContract contractByCode = this.getContractByCode(tenantCode, cmChannelClear.getBusinessOrderno());
        if (contractByCode == null) {
            return "error";
        }
        CmChannelClear oldChannelClear = this.getCmChannelClear(tenantCode, contractByCode.getContractBbillcode());
        if (oldChannelClear == null) {
            return "error";
        }
        this.doInit(configMap);
        V2TradePaymentDelaytransConfirmRequest request = new V2TradePaymentDelaytransConfirmRequest();
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        request.setReqSeqId(SequenceTools.getReqSeqId32());
        request.setHuifuId((String)configMap.get("huifuId"));
        PteBalanceop pteBalanceop = this.queryBalanceopPage(tenantCode, contractByCode.getContractBillcode(), 3);
        String dtosStr = this.makeAcctInfos((String)configMap.get("huifuId"), pteBalanceop, (String)configMap.get("acctId"));
        if (StringUtils.isBlank((String)dtosStr)) {
            return "error";
        }
        this.logger.error("cmc.ChannelSpBaseService.httpInvoke \u5206\u8d26\u4fe1\u606f", (Object)dtosStr);
        Map<String, Object> extendInfoMap = ChannelSpBaseServiceImpl.getExtendInfos(oldChannelClear, dtosStr);
        request.setExtendInfo(extendInfoMap);
        Map<String, Object> response = null;
        try {
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.httpInvoke.request", (Object)JSONObject.toJSONString((Object)request));
            response = BaseCommonDemo.doExecute((BaseRequest)request);
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.httpInvoke.response", (Object)JSONObject.toJSONString(response));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pteBalanceop.setBusinessDes2(request.getReqDate());
        pteBalanceop.setBusinessDes3(request.getReqSeqId());
        if (null == pteBalanceop.getGmtPaid()) {
            pteBalanceop.setGmtPaid(new Date());
        }
        String result = "error";
        if (MapUtil.isNotEmpty(response)) {
            if ("00000000".equals(response.get("resp_code"))) {
                if ("S".equals(response.get("trans_stat"))) {
                    pteBalanceop.setDataState(4);
                    this.updateBalanceop(pteBalanceop);
                    result = "success";
                } else if ("F".equals(response.get("trans_stat"))) {
                    pteBalanceop.setDataState(5);
                    pteBalanceop.setGmtModifiedby((String)response.get("resp_desc"));
                    this.updateBalanceop(pteBalanceop);
                    result = "eror";
                } else {
                    String queryResult = this.channelSpQuery(channelRequest);
                    Map jsonToMap = JsonUtil.buildNormalBinder().getJsonToMap(queryResult, String.class, String.class);
                    if ("00000000".equals(jsonToMap.get("resp_code"))) {
                        if ("S".equals(jsonToMap.get("trans_stat"))) {
                            pteBalanceop.setDataState(4);
                            this.updateBalanceop(pteBalanceop);
                            result = "success";
                        } else if ("F".equals(jsonToMap.get("trans_stat"))) {
                            pteBalanceop.setDataState(5);
                            pteBalanceop.setGmtModifiedby((String)response.get("resp_desc"));
                            this.updateBalanceop(pteBalanceop);
                            result = "eror";
                        }
                    }
                }
            } else if ("S".equals(response.get("trans_stat"))) {
                pteBalanceop.setDataState(4);
                this.updateBalanceop(pteBalanceop);
                result = "success";
            } else if ("F".equals(response.get("trans_stat"))) {
                pteBalanceop.setDataState(5);
                pteBalanceop.setGmtModifiedby((String)response.get("resp_desc"));
                this.updateBalanceop(pteBalanceop);
                result = "eror";
            }
        }
        return result;
    }

    private String updateBalanceopInfo(PteBalanceop pteBalanceop, OcContract ocContract) {
        BigDecimal subtract;
        int size = ocContract.getGoodsList().size();
        JSONObject jsonObject = JSONObject.parseObject((String)pteBalanceop.getBalanceopExtension());
        if (jsonObject == null) {
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.updateBalanceopInfo.jsonObject", (Object)pteBalanceop.getBalanceopExtension());
            return "error";
        }
        BigDecimal dpriceOc = BigDecimal.ZERO;
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContract.getGoodsList()) {
            JSONObject dto;
            if (ocContractGoodsDomain.getContractGoodsRemoney() != null && ocContractGoodsDomain.getContractGoodsRemoney().compareTo(BigDecimal.ZERO) != 0) {
                this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.updateBalanceopInfo.contractGoodsCode", (Object)ocContractGoodsDomain.getContractGoodsCode());
                --size;
                continue;
            }
            if (jsonObject.get((Object)ocContractGoodsDomain.getContractGoodsCode()) == null || (dto = JSONObject.parseObject((String)jsonObject.get((Object)ocContractGoodsDomain.getContractGoodsCode()).toString())) == null) continue;
            BigDecimal contractGoodsMoney = ocContractGoodsDomain.getContractGoodsMoney();
            BigDecimal dpriceGoods = BigDecimal.ZERO;
            BigDecimal dpriceConfPrice = new BigDecimal(dto.get((Object)"dpriceConfPrice").toString());
            if ("2".equals(dto.get((Object)"dpriceConfPro"))) {
                dpriceGoods = contractGoodsMoney.compareTo(dpriceConfPrice) <= 0 ? contractGoodsMoney : dpriceConfPrice;
            } else if ("0".equals(dto.get((Object)"dpriceConfPro"))) {
                dpriceGoods = new BigDecimal("100").compareTo(dpriceConfPrice) <= 0 ? contractGoodsMoney : dpriceConfPrice.multiply(contractGoodsMoney).divide(new BigDecimal("100"), 2, RoundingMode.DOWN);
            }
            dpriceOc = dpriceOc.add(dpriceGoods);
        }
        if ((dpriceOc = dpriceOc.setScale(2, RoundingMode.DOWN)).compareTo(subtract = pteBalanceop.getOrderOamount().subtract(pteBalanceop.getOrderPortion()).subtract(pteBalanceop.getOrderPrice())) >= 0) {
            dpriceOc = subtract;
        }
        pteBalanceop.setOrderDviAmt(dpriceOc);
        if (size == 0 || ocContract.getDataState() == -1) {
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.updateBalanceopInfo.dataState", (Object)-1);
            pteBalanceop.setDataState(-1);
        }
        this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.updateBalanceopInfo.dpriceOc", (Object)dpriceOc);
        this.updateBalanceop(pteBalanceop);
        return "success";
    }

    public static void main(String[] args) {
        BigDecimal dpriceOc;
        String Json = "{\n\t\"appId\": null,\n\t\"balanceBank\": null,\n\t\"balanceType\": \"oc\",\n\t\"balanceopAmount\": 78.00000000,\n\t\"balanceopCode\": \"1002249502450786351\",\n\t\"balanceopExtension\": null,\n\t\"balanceopFee\": null,\n\t\"balanceopId\": 75462,\n\t\"businessBankorder\": null,\n\t\"businessDes\": null,\n\t\"businessDes1\": \"1002246256747356244\",\n\t\"businessDes2\": \"20250808\",\n\t\"businessDes3\": \"20250808030010623ud7nmv52ud2x8j\",\n\t\"businessOrder\": \"1002248350535524401\",\n\t\"businessOrderno\": \"1002199467696595015\",\n\t\"businessPayorder\": null,\n\t\"businessType\": \"oc\",\n\t\"channelCode\": \"784826783165997069\",\n\t\"channelName\": \"BBC\u6e20\u9053\",\n\t\"contractInmoney\": null,\n\t\"contractMoney\": null,\n\t\"dataBmoney\": 67.82,\n\t\"dataState\": 4,\n\t\"gmtCreate\": \"2025-07-28 16:33:37\",\n\t\"gmtModified\": \"2025-08-08 03:00:10\",\n\t\"gmtModifiedby\": \"\u5ef6\u8fdf\u4ea4\u6613\u8d44\u91d1\u51bb\u7ed3\uff0c\u4e0d\u80fd\u53d1\u8d77\u4ea4\u6613\u786e\u8ba4\",\n\t\"gmtPaid\": \"2025-08-07 08:42:02\",\n\t\"gmtPaySubmit\": \"2025-07-28 16:33:31\",\n\t\"gmtPayout\": \"2025-07-29 16:33:31\",\n\t\"goodsClass\": null,\n\t\"goodsPmoney\": 0E-8,\n\t\"memberBcode\": \"10000210782406\",\n\t\"memberBname\": \"15098089399\",\n\t\"memberCcode\": null,\n\t\"memberCname\": null,\n\t\"memberCode\": \"1234290558894\",\n\t\"memberGcode\": \"114080655224\",\n\t\"memberGname\": \"\u64c2\u9f13\u9547\u81ea\u63d0\u70b9\",\n\t\"memberMcode\": \"20000210523453\",\n\t\"memberMname\": \"15972179190\",\n\t\"memberName\": \"\u9a6c\u8001\u56db\u751f\u59dc\u5927\u849c\u6279\u53d1\u4e2d\u5fc3\",\n\t\"memberOcode\": null,\n\t\"memo\": null,\n\t\"msChannelName\": null,\n\t\"mschannelCode\": null,\n\t\"mschannelName\": null,\n\t\"opuserCode\": null,\n\t\"opuserName\": null,\n\t\"orderCurrency\": null,\n\t\"orderDviAmt\": 10.00000000,\n\t\"orderMeramt\": null,\n\t\"orderOamount\": 78.00000000,\n\t\"orderPlatamt\": null,\n\t\"orderPortion\": 3.00,\n\t\"orderPrice\": 2.00000000,\n\t\"partnerCode\": \"6666000147440273\",\n\t\"ptradeType\": null,\n\t\"refundOrderCode\": null,\n\t\"routerDir\": null,\n\t\"settleType\": 0,\n\t\"tenantCode\": \"784820388580450362\",\n\t\"userCode\": null,\n\t\"userName\": \"\u64c2\u9f13\u4e1c\u4e1c\"\n}";
        String huifuId = "6666000145251298";
        PteBalanceop pteBalanceop = (PteBalanceop)JsonUtil.buildNormalBinder().getJsonToObject(Json, PteBalanceop.class);
        BigDecimal feeAmount = pteBalanceop.getBalanceopAmount().multiply(new BigDecimal("0.0023")).setScale(2, 0);
        BigDecimal orderMoney = pteBalanceop.getBalanceopAmount().subtract(feeAmount);
        if (orderMoney.subtract(dpriceOc = pteBalanceop.getOrderPortion().add(pteBalanceop.getOrderPrice()).add(pteBalanceop.getOrderDviAmt())).setScale(2, RoundingMode.DOWN).compareTo(BigDecimal.ZERO) < 0) {
            dpriceOc = orderMoney;
        }
        JSONObject dtos = new JSONObject();
        JSONArray dtoList = new JSONArray();
        JSONObject dto = null;
        BigDecimal dataBmoney = BigDecimal.ZERO;
        if (huifuId.equals(pteBalanceop.getPartnerCode())) {
            if (dpriceOc.setScale(2, RoundingMode.DOWN).compareTo(BigDecimal.ZERO) > 0) {
                dto = new JSONObject();
                dto.put("huifu_id", (Object)huifuId);
                dto.put("div_amt", (Object)dpriceOc.setScale(2, RoundingMode.DOWN));
                dtoList.add((Object)dto);
            }
            if (orderMoney.subtract(dpriceOc).setScale(2, RoundingMode.DOWN).compareTo(BigDecimal.ZERO) > 0) {
                dataBmoney = orderMoney.subtract(dpriceOc).setScale(2, RoundingMode.DOWN);
                dto = new JSONObject();
                dto.put("huifu_id", (Object)huifuId);
                dto.put("div_amt", (Object)dataBmoney);
                dtoList.add((Object)dto);
            }
        } else {
            if (dpriceOc.setScale(2, RoundingMode.DOWN).compareTo(BigDecimal.ZERO) > 0) {
                dto = new JSONObject();
                dto.put("huifu_id", (Object)huifuId);
                dto.put("div_amt", (Object)dpriceOc.setScale(2, RoundingMode.DOWN));
                dtoList.add((Object)dto);
            }
            if (orderMoney.subtract(dpriceOc).setScale(2, RoundingMode.DOWN).compareTo(BigDecimal.ZERO) > 0) {
                dataBmoney = orderMoney.subtract(dpriceOc).setScale(2, RoundingMode.DOWN);
                dto = new JSONObject();
                dto.put("huifu_id", (Object)pteBalanceop.getPartnerCode());
                dto.put("div_amt", (Object)dataBmoney);
                dtoList.add((Object)dto);
            }
        }
        dtos.put("acct_infos", (Object)dtoList);
        if (null != pteBalanceop.getOrderDviAmt() && pteBalanceop.getOrderDviAmt().compareTo(BigDecimal.ZERO) > 0) {
            pteBalanceop.setOrderDviAmt(dpriceOc);
        }
        pteBalanceop.setDataBmoney(dataBmoney);
    }

    private String makeAcctInfos(String huifuId, PteBalanceop pteBalanceop, String acctId) {
        BigDecimal feeAmount = pteBalanceop.getBalanceopAmount().multiply(new BigDecimal("0.0023")).setScale(2, 0);
        this.logger.error("cmc.ChannelSpBaseService.queryBusMoney.feeAmount", (Object)feeAmount);
        BigDecimal orderMoney = pteBalanceop.getBalanceopAmount().subtract(feeAmount);
        BigDecimal dpriceOc = pteBalanceop.getOrderPortion().add(pteBalanceop.getOrderPrice()).add(pteBalanceop.getOrderDviAmt());
        if (orderMoney.subtract(dpriceOc).setScale(2, RoundingMode.DOWN).compareTo(BigDecimal.ZERO) < 0) {
            dpriceOc = orderMoney;
        }
        JSONObject dtos = new JSONObject();
        JSONArray dtoList = new JSONArray();
        JSONObject dto = null;
        BigDecimal dataBmoney = BigDecimal.ZERO;
        if (huifuId.equals(pteBalanceop.getPartnerCode())) {
            if (dpriceOc.setScale(2, RoundingMode.DOWN).compareTo(BigDecimal.ZERO) > 0) {
                dto = new JSONObject();
                dto.put("huifu_id", (Object)huifuId);
                dto.put("div_amt", (Object)dpriceOc.setScale(2, RoundingMode.DOWN));
                dtoList.add((Object)dto);
            }
            if (orderMoney.subtract(dpriceOc).setScale(2, RoundingMode.DOWN).compareTo(BigDecimal.ZERO) > 0) {
                dataBmoney = orderMoney.subtract(dpriceOc).setScale(2, RoundingMode.DOWN);
                dto = new JSONObject();
                dto.put("huifu_id", (Object)huifuId);
                dto.put("div_amt", (Object)dataBmoney);
                dto.put("acct_id", (Object)acctId);
                dtoList.add((Object)dto);
            }
        } else {
            if (dpriceOc.setScale(2, RoundingMode.DOWN).compareTo(BigDecimal.ZERO) > 0) {
                dto = new JSONObject();
                dto.put("huifu_id", (Object)huifuId);
                dto.put("div_amt", (Object)dpriceOc.setScale(2, RoundingMode.DOWN));
                dtoList.add((Object)dto);
            }
            if (orderMoney.subtract(dpriceOc).setScale(2, RoundingMode.DOWN).compareTo(BigDecimal.ZERO) > 0) {
                dataBmoney = orderMoney.subtract(dpriceOc).setScale(2, RoundingMode.DOWN);
                dto = new JSONObject();
                dto.put("huifu_id", (Object)pteBalanceop.getPartnerCode());
                dto.put("div_amt", (Object)dataBmoney);
                dtoList.add((Object)dto);
            }
        }
        dtos.put("acct_infos", (Object)dtoList);
        pteBalanceop.setDataBmoney(dataBmoney);
        return dtos.toJSONString();
    }

    private void updateBalanceop(PteBalanceop pteBalanceopDomain) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("pteBalanceopDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)pteBalanceopDomain));
        String json = this.internalInvoke("pte.balanceop.updateBalanceop", map);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cmc.ChannelSpBaseService.updateBalanceop.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(map));
        }
    }

    private OcContract getContractByCode(String tenantCode, String contractBillcode) {
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        HashMap<String, String> map = new HashMap<String, String>(1);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractBillcode", contractBillcode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String jsonOc = this.internalInvoke("oc.contract.getContractByCode", map);
        if (StringUtils.isBlank((String)jsonOc)) {
            this.logger.error("cmc.ChannelSpBaseService.getContractByCode.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        OcContract contract = (OcContract)JsonUtil.buildNormalBinder().getJsonToObject(jsonOc, OcContract.class);
        return contract;
    }

    private static Map<String, Object> getExtendInfos() {
        HashMap<String, Object> extendInfoMap = new HashMap<String, Object>();
        return extendInfoMap;
    }

    private static Map<String, Object> getExtendInfos(CmChannelClear cmChannelClear, String acct_infos) {
        HashMap<String, Object> extendInfoMap = new HashMap<String, Object>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        extendInfoMap.put("org_req_date", sdf.format(cmChannelClear.getChannelAcceptDate()));
        extendInfoMap.put("org_req_seq_id", cmChannelClear.getChannelClearSeqno());
        extendInfoMap.put("acct_split_bunch", acct_infos);
        return extendInfoMap;
    }

    private static String getAcctSplitBunch() {
        JSONObject dto = new JSONObject();
        dto.put("acct_infos", (Object)ChannelSpBaseServiceImpl.getAcctInfosRucan());
        return dto.toJSONString();
    }

    private static JSON getAcctInfosRucan() {
        JSONObject dto = new JSONObject();
        dto.put("div_amt", (Object)"0.01");
        dto.put("huifu_id", (Object)"6666000103423237");
        dto.put("acct_id", (Object)"C01400109");
        JSONArray dtoList = new JSONArray();
        dtoList.add((Object)dto);
        return dtoList;
    }

    private void doInit(Map<String, String> configMap) {
        if (null == BasePay.getConfig(null)) {
            try {
                BaseCommonDemo.doInit(OppsMerchantConfigDemo.getMerchantConfig(configMap));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String doExecute(BaseRequest request) {
        Map<String, Object> response = null;
        try {
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.httpInvoke.request", (Object)JSONObject.toJSONString((Object)request));
            response = BaseCommonDemo.doExecute(request);
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.httpInvoke.response", (Object)JSONObject.toJSONString(response));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String result = null;
        if (MapUtil.isNotEmpty(response)) {
            result = JSONObject.toJSONString(response);
        }
        return result;
    }

    private List<OcContract> queryContractPage(PteBalanceop pteBalanceop) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
        HashMap<String, String> map = new HashMap<String, String>(1);
        paramMap.put("tenantCode", pteBalanceop.getTenantCode());
        paramMap.put("contractBillcode", pteBalanceop.getBusinessOrder());
        paramMap.put("childFlag", true);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String jsonOc = this.internalInvoke("oc.contract.queryContractPageReDomain", map);
        if (StringUtils.isBlank((String)jsonOc)) {
            this.logger.error("cmc.ChannelSpBaseService.queryContractPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        QueryResult contractStr = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(jsonOc, QueryResult.class);
        if (contractStr == null || ListUtil.isEmpty((Collection)contractStr.getList())) {
            this.logger.error("cmc.ChannelSpBaseService.queryContractPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        return JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)contractStr.getList()), OcContract.class);
    }

    private CmChannelClear getCmChannelClear(String tenantCode, String businessOrderno) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
        HashMap<String, String> map = new HashMap<String, String>(1);
        paramMap.put("dataState", 2);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("businessOrderno", businessOrderno);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String json = this.internalInvoke("cm.channelClear.querychannelClearPage", map);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cmc.ChannelSpBaseService.getCmChannelClear.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cmc.ChannelSpBaseService.getCmChannelClear.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResult.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("cmc.ChannelSpBaseService.getCmChannelClear.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        List list = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), CmChannelClear.class);
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error("cmc.ChannelSpBaseService.getCmChannelClear.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        return (CmChannelClear)list.get(0);
    }

    protected PteBalanceop queryBalanceopPage(String tenantCode, String businessOrder, Integer dataState) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
        HashMap<String, String> map = new HashMap<String, String>(1);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("dataState", dataState);
        paramMap.put("businessOrder", businessOrder);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String json = this.internalInvoke("pte.balanceop.queryBalanceopPage", map);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cmc.ChannelSpBaseService.queryBalanceopPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResult.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("cmc.ChannelSpBaseService.queryBalanceopPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        List list = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), PteBalanceop.class);
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error("cmc.ChannelSpBaseService.queryBalanceopPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        this.logger.error("cmc.ChannelSpBaseService.queryBalanceopPage.list", (Object)(JsonUtil.buildNormalBinder().toJson(paramMap) + "____" + list.size()));
        return (PteBalanceop)list.get(0);
    }
}

