/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.facade.http;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.pos.common.facade.SupperFacade;
import com.yqbsoft.laser.service.pos.common.request.SupperRequest;
import com.yqbsoft.laser.service.pos.common.response.SupperResponse;
import com.yqbsoft.laser.service.pos.utils.RequestUtils;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;

public class HttpFormfacade
extends SupperFacade {
    private static String SYS_CODE = "HttpFormfacade";
    private static final SupperLogUtil logger = new SupperLogUtil(HttpFormfacade.class);

    private String httpRequestReJson(String requestUrl, Map<String, Object> sendhttpParam) {
        String json = "";
        try {
            HashMap<String, String> apiHeader = new HashMap<String, String>();
            apiHeader.put("X-Ca-Stage", "RELEASE");
            apiHeader.put("Authorization", "APPCODE 4c0c52cc5adb468abacde019c61d21f4");
            String accessToken = this.getToken("4_test01", "4_test01", apiHeader);
            if (StringUtils.isBlank((String)accessToken)) {
                logger.error(SYS_CODE + "accessToken", (Object)"\u83b7\u53d6token\u5931\u8d25\uff01");
                throw new Exception("\u83b7\u53d6token\u5931\u8d25!");
            }
            apiHeader.put("x-ca-nonce", new Date().getTime() + RandomUtils.generateRandom((int)2, (Integer)0));
            logger.error(SYS_CODE + ".apiHeader", (Object)JsonUtil.buildNormalBinder().toJson(apiHeader));
            if (EmptyUtil.isEmpty((Object)sendhttpParam.get("reqJson"))) {
                Map<String, Object> objectMap = RequestUtils.postForEntity(requestUrl, accessToken, String.valueOf(sendhttpParam), apiHeader);
                json = JsonUtil.buildNormalBinder().toJson(objectMap);
            } else {
                Map<String, Object> objectMap = RequestUtils.postForEntity(requestUrl, accessToken, String.valueOf(sendhttpParam.get("reqJson")), apiHeader);
                json = JsonUtil.buildNormalBinder().toJson(objectMap);
            }
        }
        catch (IOException e) {
            logger.error(SYS_CODE + ".webUtilRequest.e", (Object)requestUrl, (Throwable)e);
            throw new ApiException(SYS_CODE + ".\u8c03\u7528\u7ed3\u675f \u8fd4\u56de\u5f02\u5e38\n" + e);
        }
        catch (Exception e) {
            logger.error(SYS_CODE + ".webUtilRequest.e", (Object)requestUrl, (Throwable)e);
            throw new ApiException(SYS_CODE + ".HttpRequestReJson.ex\n", (Throwable)e);
        }
        return json;
    }

    @Override
    @Retryable(value={ApiException.class}, maxAttempts=3, backoff=@Backoff(delay=2000L, multiplier=1.5))
    public <T extends SupperResponse> T execute(SupperRequest<T> supperRequest) {
        SupperResponse localResponse;
        if (null == supperRequest) {
            return null;
        }
        String url = this.getHost() + (StringUtils.isBlank((String)supperRequest.getTopHttpMethod()) ? "" : supperRequest.getTopHttpMethod());
        String json = this.httpRequestReJson(url, supperRequest.getTextParams());
        if (StringUtils.isEmpty((String)json)) {
            logger.error(SYS_CODE + ".execute.json", (Object)(url + "====" + supperRequest.getTextParams()));
            return null;
        }
        logger.error(SYS_CODE + ".Httpfacade.execute.json", (Object)(url + "=" + json + "=" + supperRequest.getTextParams()));
        try {
            localResponse = (SupperResponse)supperRequest.getResponseClass().newInstance();
        }
        catch (Exception xe) {
            throw new ApiException((Throwable)xe);
        }
        localResponse.setMsg(json);
        localResponse.makeDomain(json);
        return (T)localResponse;
    }

    @Override
    public String sign(Map<String, String> param) {
        return null;
    }

    public HttpFormfacade(String host, String appkey, String secret, String signtype) {
        super(host, appkey, secret, signtype);
    }

    public HttpFormfacade(String host, String accessToken) {
        super(host, accessToken);
    }

    public HttpFormfacade(String host) {
        super(host);
    }

    private String getToken(String clientId, String clientSecret, Map<String, String> apiHeader) {
        String accessToken = DisUtil.getDisCache().getRemot("token" + clientId + clientSecret);
        apiHeader.put("x-ca-nonce", DateUtil.getDateString((Date)new Date(), (String)"HHmmss"));
        if (StringUtils.isNotBlank((String)accessToken)) {
            return accessToken;
        }
        Map<String, Object> accessTokenMap = RequestUtils.getForEntity("http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/authApi/auth", "4_test01", "4_test01", apiHeader);
        String token = accessTokenMap.get("returnData") + "";
        if (StringUtils.isNotBlank((String)token)) {
            DisUtil.getDisCache().set("token" + clientId + clientSecret, token, 3500);
        }
        return token;
    }
}

