/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.domain.OcContract;
import com.yqbsoft.laser.service.pos.domain.OcContractDomain;
import com.yqbsoft.laser.service.pos.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.OcContractReDomain;
import com.yqbsoft.laser.service.pos.domain.OcPackageDomain;
import com.yqbsoft.laser.service.pos.domain.OcRefund;
import com.yqbsoft.laser.service.pos.domain.OcRefundDomain;
import com.yqbsoft.laser.service.pos.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.pos.domain.RsSku;
import com.yqbsoft.laser.service.pos.domain.SgOccontractDomain;
import com.yqbsoft.laser.service.pos.domain.SgSendgoodsGoodsReDomain;
import com.yqbsoft.laser.service.pos.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.pos.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.pos.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosCancelOrderRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosContractAssignmentRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosOrderDownwardRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosRefundAssignmentRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosRefundDataRequest;
import com.yqbsoft.laser.service.pos.facade.response.JbsPosOrderResponse;
import com.yqbsoft.laser.service.pos.service.ContractService;
import com.yqbsoft.laser.service.pos.utils.JbsUtils;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ContractServiceImpl
extends BaseServiceImpl
implements ContractService {
    private String SYS_CODE = "jbsPos.ContractServiceImpl";

    @Override
    public String sendContractAssignment(SgSendgoodsReDomain sgSendgoodsReDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)sgSendgoodsReDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendContractAssignment \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsReDomain));
        try {
            String msg = this.checkContractAssignment(sgSendgoodsReDomain);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)msg)) {
                return JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsReDomain.getContractBillcode()));
            }
            String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/order/saveOrder";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsPosOrderResponse execute = null;
            JbsPosContractAssignmentRequest jbsPosContractAssignmentRequest = new JbsPosContractAssignmentRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosContractAssignmentRequest, (Object)sgSendgoodsReDomain);
            String storeCode = this.checkUserAndStoreCode(sgSendgoodsReDomain.getMemberCode());
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)storeCode)) {
                return JbsUtils.getErrorMap("\u95e8\u5e97\u4e0d\u5b58\u5728", JsonUtil.buildNormalBinder().toJson((Object)storeCode));
            }
            jbsPosContractAssignmentRequest.setMemberCode(storeCode);
            execute = httpFormfacade.execute(jbsPosContractAssignmentRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendContractAssignment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendContractAssignment Exception" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendContractAssignment Exception", null);
        }
    }

    @Override
    public String sendRefundAssignment(OcRefundReDomain ocRefundDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendRefundAssignment \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        try {
            String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/order/saveOrder";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsPosOrderResponse execute = null;
            JbsPosRefundAssignmentRequest jbsPosRefundAssignmentRequest = new JbsPosRefundAssignmentRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosRefundAssignmentRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosRefundAssignmentRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundAssignment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundAssignment Exception" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendRefundAssignment Exception", null);
        }
    }

    @Override
    public String sendOrderDownward(OcContractReDomain ocContractDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocContractDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"ocContractDomain is null");
            return JbsUtils.getErrorMap("ocContractDomain is null", "");
        }
        this.logger.error(this.SYS_CODE + "sendOrderDownward \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractDomain.getContractBillcode()) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((Integer)ocContractDomain.getDataState())) {
            return JbsUtils.getErrorMap("ContractBillcode or DataStatestr is null", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        }
        try {
            String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com";
            if (ocContractDomain.getDataState().equals("4")) {
                url = url + "/api/order/finishOrder";
            } else if (ocContractDomain.getDataState().equals("7")) {
                url = url + "/api/order/deliverGoodsOrder";
            }
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsPosOrderResponse execute = null;
            JbsPosOrderDownwardRequest jbsPosOrderDownwardRequest = new JbsPosOrderDownwardRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosOrderDownwardRequest, (Object)ocContractDomain);
            execute = httpFormfacade.execute(jbsPosOrderDownwardRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendOrderDownward \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendOrderDownward Exception" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendOrderDownward Exception", null);
        }
    }

    @Override
    public String sendCancelShipment(SgSendgoodsReDomain sgSendgoodsReDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)sgSendgoodsReDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"sgSendgoodsReDomain is null");
            return JbsUtils.getErrorMap("sgSendgoodsReDomain is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendCancelShipment \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsReDomain));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsReDomain.getSendgoodsCode()) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((Integer)sgSendgoodsReDomain.getDataState())) {
            return JbsUtils.getErrorMap("SendgoodsCode or DataState is null", null);
        }
        try {
            String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/order/cancelOrder";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsPosOrderResponse execute = null;
            JbsPosCancelOrderRequest jbsPosCancelOrderRequest = new JbsPosCancelOrderRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosCancelOrderRequest, (Object)sgSendgoodsReDomain);
            execute = httpFormfacade.execute(jbsPosCancelOrderRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendCancelShipment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendCancelShipment Exception" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendCancelShipment Exception", null);
        }
    }

    @Override
    public String sendRefundCompleted(OcRefundReDomain ocRefundDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error(this.SYS_CODE + "sendRefundCompleted \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getRefundCode()) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((Integer)ocRefundDomain.getDataState())) {
            return JbsUtils.getErrorMap("RefundCode or DataStatestr is null", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        }
        try {
            String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/order/refundOrder";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsPosOrderResponse execute = null;
            JbsPosRefundDataRequest jbsPosRefundDataRequest = new JbsPosRefundDataRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosRefundDataRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosRefundDataRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundCompleted \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundCompleted Exception" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendRefundCompleted Exception", null);
        }
    }

    @Override
    public String sendRefundRevoke(OcRefundReDomain ocRefundDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendRefundRevoke \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getRefundCode()) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((Integer)ocRefundDomain.getDataState())) {
            return JbsUtils.getErrorMap("RefundCode or DataStatestr is null", JsonUtil.getNotDefJsonUtil().toJson((Object)ocRefundDomain));
        }
        try {
            String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/order/cancelRefundOrder";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsPosOrderResponse execute = null;
            JbsPosRefundDataRequest jbsPosRefundDataRequest = new JbsPosRefundDataRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosRefundDataRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosRefundDataRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundRevoke \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundRevoke Exception" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendRefundRevoke Exception", null);
        }
    }

    @Override
    public String sendOrderFrom(String data) {
        this.logger.error(this.SYS_CODE + "sendOrderFrom \u6570\u636e>>>>>>> " + data);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, OcContractDomain.class);
        if (EmptyUtil.isEmpty((Object)ocContractDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"ocContractDomain is null");
            return JbsUtils.getPosErrorMap("ocContractDomain is null", "", "");
        }
        List<OcContract> queryResut = this.checkOccontract(ocContractDomain.getContractBillcode());
        if (ListUtil.isNotEmpty(queryResut)) {
            return JbsUtils.getPosErrorMap("\u5f53\u524d\u8ba2\u5355\u53f7\u5df2\u5b58\u5728", "", ocContractDomain.getContractBillcode());
        }
        String goodsList = JsonUtil.buildNormalBinder().toJson(ocContractDomain.getGoodsList());
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)goodsList)) {
            return JbsUtils.getPosErrorMap("\u8ba2\u5355\u5546\u54c1\u65e0\u6570\u636e", "", goodsList);
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsList, Map.class);
        List<Object> orderGoodsList = this.checkOrderGoodsByMap(list);
        if (ListUtil.isNotEmpty(orderGoodsList)) {
            return JbsUtils.getPosErrorMap("\u5546\u54c1\u4e0d\u5b58\u5728", "", orderGoodsList);
        }
        String userinfoOcode = this.checkUserAndStoreCode(ocContractDomain.getMemberCode());
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userinfoOcode)) {
            return JbsUtils.getPosErrorMap("\u5f53\u524d\u8ba2\u5355\u95e8\u5e97\u4e0d\u5b58\u5728", "", ocContractDomain.getMemberCode());
        }
        try {
            paramsMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            this.getInternalRouter().inInvoke("oc.contract.saveContract", paramsMap);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "sendOrderFrom is fail", (Throwable)e);
            return JbsUtils.getPosErrorMap("save data is fail", "", data);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String sendRefundOrderFrom(String data) {
        if (StringUtils.isEmpty((Object)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        OcRefundDomain ocRefundDomain = (OcRefundDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, OcRefundDomain.class);
        if (EmptyUtil.isEmpty((Object)ocRefundDomain) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getRefundType())) {
            this.logger.error(this.SYS_CODE, (Object)"ocRefundDomain or refundType is null");
            return JbsUtils.getPosErrorMap("ocRefundDomain or refundType is null", "", "");
        }
        List<OcRefund> queryResut = this.checkRefund(ocRefundDomain.getRefundCode());
        if (ListUtil.isNotEmpty(queryResut)) {
            return JbsUtils.getPosErrorMap("\u5f53\u524d\u9000\u5355\u53f7\u5df2\u5b58\u5728", "", ocRefundDomain.getRefundCode());
        }
        String goodsList = JsonUtil.buildNormalBinder().toJson(ocRefundDomain.getOcRefundGoodsDomainList());
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)goodsList)) {
            return JbsUtils.getPosErrorMap("\u8ba2\u5355\u5546\u54c1\u65e0\u6570\u636e", "", goodsList);
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsList, Map.class);
        List<Object> orderGoodsList = this.checkOrderGoodsByMap(list);
        if (ListUtil.isNotEmpty(orderGoodsList)) {
            return JbsUtils.getPosErrorMap("\u5546\u54c1\u4e0d\u5b58\u5728", "", orderGoodsList);
        }
        String userinfoOcode = this.checkUserAndStoreCode(ocRefundDomain.getMemberCode());
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userinfoOcode)) {
            return JbsUtils.getPosErrorMap("\u5f53\u524d\u8ba2\u5355\u95e8\u5e97\u4e0d\u5b58\u5728", "", ocRefundDomain.getMemberCode());
        }
        try {
            paramsMap.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            this.getInternalRouter().inInvoke("oc.refund.saveRefund", paramsMap);
        }
        catch (Exception e) {
            return JbsUtils.getPosErrorMap("save data is fail", "", e.getMessage());
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String sendOrderUplink(String dataStr) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)dataStr)) {
            this.logger.error(this.SYS_CODE, (Object)"dataStr is null");
            return JbsUtils.getPosErrorMap("dataStr is null", "", dataStr);
        }
        JSONObject map = (JSONObject)JsonUtil.buildNormalBinder().getJsonToObject(dataStr, JSONObject.class);
        if (EmptyUtil.isEmpty((Object)map)) {
            return JbsUtils.getPosErrorMap("map is null", "", JsonUtil.getNotDefJsonUtil().toJson((Object)map));
        }
        this.logger.error(this.SYS_CODE + ".sendOrderUplink", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)map)));
        String msg = this.checkOcContractDomain(map);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)msg)) {
            return JbsUtils.getPosErrorMap(msg, "", JsonUtil.buildNormalBinder().toJson((Object)map.getString("contractBillcode")));
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", map.getString("tenantCode"));
        paramMap.put("sendgoodsCode", map.getString("contractBillcode"));
        String sendGoods = this.internalInvoke("sg.sendgoods.getSendgoodsByCode", paramMap);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sendGoods)) {
            return JbsUtils.getPosErrorMap("\u672a\u627e\u5230\u5f53\u524d\u53d1\u8d27\u8ba2\u5355\u53f7", "", map.getString("contractBillcode"));
        }
        SgSendgoodsReDomain sgSendgoodsReDomain = (SgSendgoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(sendGoods, SgSendgoodsReDomain.class);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        try {
            map.put("sendgoodsCode", (Object)sgSendgoodsReDomain.getSendgoodsCode());
            map.put("sendgoodsLogType", (Object)"00");
            map.put("sendgoodsLogSort", (Object)"00");
            map.put("sendgoodsLogShow", (Object)"0");
            map.put("packageName", (Object)sgSendgoodsReDomain.getPackageName());
            map.put("contractBillcode", (Object)sgSendgoodsReDomain.getContractBillcode());
            map.put("goodsReceiptMem", (Object)sgSendgoodsReDomain.getGoodsReceiptMem());
            map.put("goodsReceiptPhone", (Object)sgSendgoodsReDomain.getGoodsReceiptPhone());
            map.put("goodsReceiptArrdess", (Object)sgSendgoodsReDomain.getGoodsReceiptArrdess());
            sendMap.put("sgSendgoodsLogDomain", JsonUtil.buildNormalBinder().toJson((Object)map));
            this.internalInvoke("sg.sgSendgoodsFlowEngine.saveSendgoodsGoods", sendMap);
            this.logger.error(this.SYS_CODE, (Object)(".toService--map" + JsonUtil.buildNormalBinder().toJson((Object)map)));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(this.SYS_CODE, (Object)"save Data Exception");
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String sendRefundState(String data) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", data);
        }
        JSONObject invokeMap = (JSONObject)JsonUtil.buildNormalBinder().getJsonToObject(data, JSONObject.class);
        if (MapUtil.isEmpty((Map)invokeMap)) {
            return JbsUtils.getPosErrorMap("paramsMap is null", "", "");
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("dataState")) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("tenantCode")) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("refundCode"))) {
            return JbsUtils.getPosErrorMap("refundCode\uff0ctenantCode\uff0cdataState", "", JsonUtil.buildNormalBinder().toJson((Object)invokeMap));
        }
        OcRefund ocRefund = this.getOcRefund(invokeMap.getString("refundCode"), invokeMap.getString("tenantCode"));
        if (null == ocRefund) {
            return JbsUtils.getPosErrorMap("\u9000\u5355\u53f7\u6570\u636e\u4e0d\u5b58\u5728", "", JsonUtil.buildNormalBinder().toJson((Object)invokeMap.getString("refundCode")));
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        try {
            sendMap.put("map", JsonUtil.buildNonDefaultBinder().toJson((Object)invokeMap));
            this.logger.error(this.SYS_CODE, (Object)(".toService--invokeMap" + JsonUtil.buildNormalBinder().toJson((Object)invokeMap)));
            this.getInternalRouter().inInvoke("oc.refundEngine.sendRefundNext", (Map)invokeMap);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "sendRefundState is fail");
            return JbsUtils.getPosErrorMap("updata data is fail", "", data);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String sendRefundReceipt(String data) {
        if (StringUtils.isEmpty((Object)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", data);
        }
        JSONObject invokeMap = (JSONObject)JsonUtil.buildNormalBinder().getJsonToObject(data, JSONObject.class);
        if (MapUtil.isEmpty((Map)invokeMap)) {
            return JbsUtils.getPosErrorMap("invokeMap is null", "", JsonUtil.buildNormalBinder().toJson((Object)invokeMap));
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("dataState")) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("tenantCode")) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("refundCode"))) {
            return JbsUtils.getPosErrorMap("refundCode\uff0ctenantCode\uff0cdataState", "", JsonUtil.buildNormalBinder().toJson((Object)invokeMap));
        }
        OcRefund ocRefund = this.getOcRefund(invokeMap.getString("refundCode"), invokeMap.getString("tenantCode"));
        if (null == ocRefund) {
            return JbsUtils.getPosErrorMap("\u9000\u5355\u53f7\u6570\u636e\u4e0d\u5b58\u5728", "", JsonUtil.buildNormalBinder().toJson((Object)invokeMap.getString("refundCode")));
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        try {
            sendMap.put("map", JsonUtil.buildNonDefaultBinder().toJson((Object)invokeMap));
            this.logger.error(this.SYS_CODE, (Object)(".toService--invokeMap" + JsonUtil.buildNormalBinder().toJson((Object)invokeMap)));
            this.getInternalRouter().inInvoke("oc.refundEngine.sendRefundNext", (Map)invokeMap);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "sendRefundState is fail");
            return JbsUtils.getPosErrorMap("updata data is fail", "", data);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    private OcRefund getOcRefund(String refundCode, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)refundCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("refundCode", refundCode);
        sendMap.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult queryResutl = this.getQueryResutl("oc.refund.queryRefundPage", invokeMap, OcRefund.class);
        if (ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (OcRefund)queryResutl.getList().get(0);
    }

    private List<OcRefund> checkRefund(String refundCode) {
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("refundCode", refundCode);
        map.put("tenantCode", "2019071800001392");
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult queryResut = this.getQueryResutl("oc.refund.queryRefundPage", invokeMap, OcRefund.class);
        return queryResut.getList();
    }

    private List<OcContract> checkOccontract(String contractBillcode) {
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", "2019071800001392");
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult queryResut = this.getQueryResutl("oc.contract.queryContractPage", invokeMap, OcContract.class);
        return queryResut.getList();
    }

    private String checkUserAndStoreCode(String memberCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)memberCode)) {
            this.logger.error(this.SYS_CODE + ".checkUser", (Object)"memberCode is null");
            return null;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        paramsMap.put("userinfoOcode", memberCode);
        paramsMap.put("tenantCode", "2019071800001392");
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramsMap));
        QueryResult queryResutl = this.getQueryResutl("um.user.queryUserinfoPage", invokeMap, UmUserinfoReDomainBean.class);
        if (ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return ((UmUserinfoReDomainBean)queryResutl.getList().get(0)).getUserinfoOcode();
    }

    private List<Object> checkOrderGoodsByMap(List<Map<String, Object>> goodsList) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        ArrayList<Object> noGoodsEoCodeList = new ArrayList<Object>();
        ArrayList<String> goodsEoCodeList = new ArrayList<String>();
        for (Map<String, Object> map : goodsList) {
            if (!com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)String.valueOf(map.get("skuCode")))) continue;
            paramsMap.put("skuNo", map.get("skuCode"));
            paramsMap.put("tenantCode", "2019071800001392");
            invokeMap.put("map", JsonUtil.buildNormalBinder().toJson(paramsMap));
            QueryResult queryResut = this.getQueryResutl("rs.sku.querySkuOnePage", invokeMap, RsSku.class);
            if (ListUtil.isNotEmpty((Collection)queryResut.getList()) || queryResut.getList().size() > 0) {
                goodsEoCodeList.add(((RsSku)queryResut.getList().get(0)).getGoodsEocode());
                continue;
            }
            noGoodsEoCodeList.add(map.get("skuCode"));
        }
        return noGoodsEoCodeList;
    }

    private String checkSgOccontractDomain(SgOccontractDomain sgOccontractDomain) {
        String msg = "";
        List<OcPackageDomain> packageList = sgOccontractDomain.getPackageList();
        for (OcPackageDomain ocPackageDomain : packageList) {
            List<OcContractGoodsDomain> contractGoodsList = ocPackageDomain.getContractGoodsList();
            for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getContractGoodsCode())) {
                    msg = msg + "ContractGoodsCode\u4e3a\u7a7a;";
                }
                if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsSendnum())) {
                    msg = msg + "ContractGoodsSendnum\u4e3a\u7a7a;";
                }
                if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsSendweight())) {
                    msg = msg + "ContractGoodsSendweight\u4e3a\u7a7a;";
                }
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getContractBillcode())) {
                    msg = msg + "ContractBillcode\u4e3a\u7a7a;";
                }
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsCode())) {
                    msg = msg + "GoodsCode\u4e3a\u7a7a;";
                }
                if (!com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsName())) continue;
                msg = msg + "GoodsName\u4e3a\u7a7a;";
            }
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocPackageDomain.getPackageBillno())) {
                msg = msg + "PackageBillno\u4e3a\u7a7a;";
            }
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocPackageDomain.getExpressName())) {
                msg = msg + "ExpressName\u4e3a\u7a7a;";
            }
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocPackageDomain.getExpressCode())) {
                msg = msg + "ExpressCode\u4e3a\u7a7a;";
            }
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocPackageDomain.getWarehouseCode())) {
                msg = msg + "WarehouseCode\u4e3a\u7a7a;";
            }
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocPackageDomain.getWarehouseName())) {
                msg = msg + "WarehouseName\u4e3a\u7a7a;";
            }
            if (EmptyUtil.isEmpty((Object)ocPackageDomain.getGoodsNum())) {
                msg = msg + "GoodsNum\u4e3a\u7a7a;";
            }
            if (!EmptyUtil.isEmpty((Object)ocPackageDomain.getGoodsWeight())) continue;
            msg = msg + "GoodsWeight\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getContractBbillcode())) {
            msg = msg + "ContractBbillcode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String checkOcContractDomain(JSONObject jsonObject) {
        String msg = "";
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)jsonObject.getString("contractBillcode"))) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)jsonObject.getString("dateState"))) {
            msg = msg + "DataState\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)jsonObject.getString("tenantCode"))) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String checkContractAssignment(SgSendgoodsReDomain sgSendgoodsReDomain) {
        List<SgSendgoodsGoodsReDomain> goodsList;
        String msg = "";
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsReDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsReDomain.getContractType())) {
            msg = msg + "ContractType\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsReDomain.getGoodsReceiptPhone())) {
            msg = msg + "GoodsReceiptPhone\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsReDomain.getGoodsReceiptArrdess())) {
            msg = msg + "GoodsReceiptArrdess\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsReDomain.getGoodsReceiptMem())) {
            msg = msg + "GoodsReceiptMem\u4e3a\u7a7a;";
        }
        if ((goodsList = sgSendgoodsReDomain.getSgSendgoodsGoodsReDomainList()).size() == 0 || ListUtil.isEmpty(goodsList)) {
            msg = msg + "SgSendgoodsGoodsReDomainList\u4e3a\u7a7a;";
        }
        for (SgSendgoodsGoodsReDomain goods : goodsList) {
            if (goods.getGoodsNum() == null) {
                msg = msg + "GoodsNum\u4e3a\u7a7a;";
            }
            if (goods.getGoodsWeight() == null) {
                msg = msg + "GoodsWeight\u4e3a\u7a7a;";
            }
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)goods.getSendgoodsGoodsCode())) {
                msg = msg + "SendgoodsGoodsCode\u4e3a\u7a7a;";
            }
            if (!com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)goods.getGoodsCode())) continue;
            msg = msg + "GoodsCode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsReDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }
}

