/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.facade.http;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.pos.common.facade.SupperFacade;
import com.yqbsoft.laser.service.pos.common.request.SupperRequest;
import com.yqbsoft.laser.service.pos.common.response.SupperResponse;
import com.yqbsoft.laser.service.pos.utils.RequestUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;

public class HttpFormfacade
extends SupperFacade {
    private static String SYS_CODE = "HttpFormfacade";
    private static final SupperLogUtil logger = new SupperLogUtil(HttpFormfacade.class);
    private static final AtomicInteger SEQ = new AtomicInteger(1000);
    private static final DateTimeFormatter DF_FMT_PREFIX = DateTimeFormatter.ofPattern("yyMMddHHmmssSS");
    private static ZoneId ZONE_ID = ZoneId.of("Asia/Shanghai");

    private String httpRequestReJson(String requestUrl, String clientId, String clientSecret, Map<String, Object> sendhttpParam) {
        String json = "";
        try {
            HashMap<String, String> apiHeader = new HashMap<String, String>();
            apiHeader.put("X-Ca-Stage", "RELEASE");
            String paramJson = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2019071800001392-jbs_pos-jbs_pos");
            JSONObject jsonObject = JSONObject.json2object((String)paramJson);
            apiHeader.put("Authorization", jsonObject.getString("appCode"));
            String accessToken = this.getToken(clientId, clientSecret, apiHeader);
            if (StringUtils.isBlank((String)accessToken)) {
                logger.error(SYS_CODE + "accessToken", (Object)"\u83b7\u53d6token\u5931\u8d25\uff01");
                throw new Exception("\u83b7\u53d6token\u5931\u8d25!");
            }
            LocalDateTime dataTime = LocalDateTime.now(ZONE_ID);
            if (SEQ.intValue() > 9990) {
                SEQ.getAndSet(1000);
            }
            apiHeader.put("x-ca-nonce", dataTime.format(DF_FMT_PREFIX) + SEQ.getAndIncrement());
            logger.info(SYS_CODE + ".apiHeader", (Object)JsonUtil.buildNormalBinder().toJson(apiHeader));
            logger.info(SYS_CODE + ".reqJson", (Object)JsonUtil.buildNormalBinder().toJson(sendhttpParam));
            if (EmptyUtil.isEmpty((Object)sendhttpParam.get("reqJson"))) {
                Map<String, Object> objectMap = RequestUtils.postForEntity(requestUrl, accessToken, String.valueOf(sendhttpParam), apiHeader);
                json = JsonUtil.buildNormalBinder().toJson(objectMap);
            } else {
                Map<String, Object> objectMap = RequestUtils.postForEntity(requestUrl, accessToken, String.valueOf(sendhttpParam.get("reqJson")), apiHeader);
                json = JsonUtil.buildNormalBinder().toJson(objectMap);
            }
        }
        catch (IOException e) {
            logger.error(SYS_CODE + ".webUtilRequest.e", (Object)requestUrl, (Throwable)e);
            throw new ApiException(SYS_CODE + ".\u8c03\u7528\u7ed3\u675f \u8fd4\u56de\u5f02\u5e38\n" + e);
        }
        catch (Exception e) {
            logger.error(SYS_CODE + ".webUtilRequest.e", (Object)requestUrl, (Throwable)e);
            throw new ApiException(SYS_CODE + ".HttpRequestReJson.ex\n", (Throwable)e);
        }
        return json;
    }

    @Override
    @Retryable(value={ApiException.class}, maxAttempts=3, backoff=@Backoff(delay=2000L, multiplier=1.5))
    public <T extends SupperResponse> T execute(SupperRequest<T> supperRequest) {
        SupperResponse localResponse;
        if (null == supperRequest) {
            return null;
        }
        String paramJson = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2019071800001392-jbs_pos-jbs_pos");
        JSONObject jsonObject = JSONObject.json2object((String)paramJson);
        String url = jsonObject.getString("base_url");
        String clientId = jsonObject.getString("client_id");
        String clientSecret = jsonObject.getString("client_secret");
        String outsideApiUrl = this.getOutsideApiUrl();
        if (StringUtils.isEmpty((String)url) || StringUtils.isEmpty((String)clientId) || StringUtils.isEmpty((String)clientSecret) || StringUtils.isEmpty((String)outsideApiUrl)) {
            logger.error(SYS_CODE + ".execute.requestParam", (Object)(url + "====" + clientId + "====" + clientSecret + "====" + outsideApiUrl));
            throw new ApiException("\u8bf7\u6c42\u53c2\u6570\u7f3a\u5931");
        }
        logger.error(SYS_CODE + ".Httpfacade.execute============Request=============");
        logger.error(SYS_CODE + ".Httpfacade.execute============URL:", (Object)(url + outsideApiUrl));
        logger.error(SYS_CODE + ".Httpfacade.execute============OrderNo:", (Object)(this.getInsideOrderNo() + "===" + this.getOutsideOrderNo()));
        logger.error(SYS_CODE + ".Httpfacade.execute============PARAM\u53c2\u6570:", supperRequest.getTextParams());
        Date d1 = new Date();
        String json = this.httpRequestReJson(url + outsideApiUrl, clientId, clientSecret, supperRequest.getTextParams());
        Date d2 = new Date();
        logger.error(SYS_CODE + ".Httpfacade.\u8017\u65f6" + (d2.getTime() - d1.getTime()));
        logger.error(SYS_CODE + ".Httpfacade.execute============Response=============");
        logger.error(SYS_CODE + ".Httpfacade.execute============OrderNo:", (Object)(this.getInsideOrderNo() + "===" + this.getOutsideOrderNo()));
        if (StringUtils.isBlank((String)json)) {
            logger.error(SYS_CODE + ".execute.json============Response", (Object)"\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
            throw new ApiException("\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
        }
        logger.error(SYS_CODE + ".Httpfacade.execute============Response", (Object)json);
        try {
            localResponse = (SupperResponse)supperRequest.getResponseClass().newInstance();
        }
        catch (Exception xe) {
            throw new ApiException((Throwable)xe);
        }
        localResponse.setMsg(json);
        localResponse.makeDomain(json);
        return (T)localResponse;
    }

    @Override
    public String sign(Map<String, String> param) {
        return null;
    }

    public HttpFormfacade(String host, String appkey, String secret, String signtype) {
        super(host, appkey, secret, signtype);
    }

    public HttpFormfacade(String host, String accessToken) {
        super(host, accessToken);
    }

    public HttpFormfacade(String host) {
        super(host);
    }

    public HttpFormfacade() {
    }

    private String getToken(String clientId, String clientSecret, Map<String, String> apiHeader) {
        String accessToken = DisUtil.getDisCache().getRemot("token" + clientId + clientSecret);
        apiHeader.put("x-ca-nonce", DateUtil.getDateString((Date)new Date(), (String)"HHmmss"));
        if (StringUtils.isNotBlank((String)accessToken)) {
            return accessToken;
        }
        String paramJson = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2019071800001392-jbs_pos-jbs_pos");
        JSONObject jsonObject = JSONObject.json2object((String)paramJson);
        String baseUrl = jsonObject.getString("base_url");
        Map<String, Object> accessTokenMap = RequestUtils.getForEntity(baseUrl + "/authApi/auth", clientId, clientSecret, apiHeader);
        String token = accessTokenMap.get("returnData") + "";
        if (StringUtils.isNotBlank((String)token)) {
            DisUtil.getDisCache().set("token" + clientId + clientSecret, token, 1700);
        }
        return token;
    }
}

