/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreDomain;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.sap.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapExWhConfirmRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapInWhConfirmRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapMaterialMovePostingRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapQueryWhRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapSTORequest;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapInExWhConfirmResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapMaterialMovePostingResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapQueryWhResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapSTOResponse;
import com.yqbsoft.laser.service.sap.model.HtmlJsonReBean;
import com.yqbsoft.laser.service.sap.service.JbsSapWarehouseService;
import com.yqbsoft.laser.service.sap.utils.JbsUtils;
import com.yqbsoft.laser.service.sap.utils.ParamsUtils;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JbsSapWarehouseServiceImpl
extends BaseServiceImpl
implements JbsSapWarehouseService {
    public static final String SYS_CODE = "jbsSap.JbsSapWarehouseServiceImpl";

    @Override
    public String sendSTOBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        String url = "http://devpo.jbsswift.cn:50000/RESTAdapter/os_mpf_if_sc_006";
        HttpFormfacade httpFormfacade = new HttpFormfacade(url);
        JbsSapSTOResponse execute = null;
        JbsSapSTORequest jbsSapSTORequest = new JbsSapSTORequest();
        try {
            jbsSapSTORequest.setApiMethod("os_mpf_if_sc_006");
            BeanUtils.copyAllPropertys((Object)jbsSapSTORequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapSTORequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.sendSTOBill is error", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
            e.printStackTrace();
            return JbsUtils.getErrorMap("sendSTOBill Exception", whOpstoreDomain.getOpstoreCode());
        }
    }

    @Override
    public HtmlJsonReBean receiveInDeliveryBill(String dataStr) throws Exception {
        List itemList;
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"dataStr is null");
            throw new Exception("param is null");
        }
        this.logger.error(SYS_CODE, (Object)("receiveInDeliveryBill.dataStr>>>>>>>>>" + dataStr));
        JSONObject object = JSONObject.json2object((String)dataStr);
        this.logger.error(SYS_CODE, (Object)("receiveInDeliveryBill.toObject>>>>>>>>>" + JsonUtil.buildNormalBinder().toJson((Object)object)));
        if (EmptyUtil.isEmpty((Object)object) || StringUtils.isBlank((String)object.getString("data")) || EmptyUtil.isEmpty(((HashMap)object.get((Object)"data")).get("list"))) {
            this.logger.error(SYS_CODE, (Object)("data\u53c2\u6570\u4e3a\u7a7a" + dataStr));
            throw new Exception("data\u53c2\u6570\u4e3a\u7a7a");
        }
        Map dataMap = (Map)((HashMap)object.get((Object)"data")).get("list");
        this.logger.error("jbsSap.JbsSapWarehouseServiceImplreceiveInDeliveryBill.dataMap", (Object)("------------" + dataMap));
        ArrayList<String> errorCodes = new ArrayList<String>();
        WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
        whOpstoreDomain.setStoreGoodsType("R2");
        whOpstoreDomain.setStoreGoodsBtype("2");
        whOpstoreDomain.setOpstoreOcode(dataMap.get("VBELN") + "");
        whOpstoreDomain.setStoType(dataMap.get("LFART") + "");
        whOpstoreDomain.setWarehouseCode(dataMap.get("VSTEL") + "");
        whOpstoreDomain.setMemberBcode(dataMap.get("KUNNR") + "");
        whOpstoreDomain.setMemberBname(dataMap.get("PODAT") + "");
        whOpstoreDomain.setMemberCcode(dataMap.get("LIFNR") + "");
        whOpstoreDomain.setOpstoreOcode(dataMap.get("NAME1") + "");
        whOpstoreDomain.setTenantCode("2019071800001392");
        String items = dataMap.get("item") + "";
        if (StringUtils.isNotBlank((String)items) && ListUtil.isNotEmpty((Collection)(itemList = (List)dataMap.get("item")))) {
            ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
            for (Map map : itemList) {
                WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
                whOpstoreGoodsDomain.setStoreGoodsType("R2");
                whOpstoreGoodsDomain.setStoreGoodsBtype("2");
                whOpstoreGoodsDomain.setGoodsEocode(map.get("MATNR") + "");
                whOpstoreGoodsDomain.setGoodsName(map.get("ARKTX") + "");
                whOpstoreGoodsDomain.setWarehouseCode(map.get("WERKS") + "");
                whOpstoreGoodsDomain.setWarehouseName(map.get("LGORT") + "");
                whOpstoreGoodsDomain.setGoodsNum(ParamsUtils.getBigDecimal(map.get("LFIMG")));
                whOpstoreGoodsDomain.setPartsnameNumunit(map.get("VRKME") + "");
                whOpstoreGoodsDomain.setTenantCode("2019071800001392");
                whOpstoreGoodsDomain.setMemberCode("20000210392004");
                whOpstoreGoodsDomain.setMemberName("\u5e73\u53f0");
                whOpstoreGoodsDomainList.add(whOpstoreGoodsDomain);
            }
            whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        }
        try {
            HashMap<String, String> sendMap = new HashMap<String, String>();
            this.logger.error(SYS_CODE, (Object)JsonUtil.buildNormalBinder().toJson(sendMap));
            sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
            this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("save whOpstoreDomain Exception" + whOpstoreDomain.getOpstoreOcode()));
            errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "save whOpstoreDomain Exception");
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            this.logger.error(SYS_CODE, (Object)("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff1a\n" + errorCodes));
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:\n" + errorCodes);
        }
        return new HtmlJsonReBean();
    }

    @Override
    public String InDeliveryConfirmBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            String url = "http://devpo.jbsswift.cn:50000/RESTAdapter/oa_mpf_if_sc_002";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsSapInExWhConfirmResponse execute = null;
            JbsSapInWhConfirmRequest jbsSapInWhConfirmRequest = new JbsSapInWhConfirmRequest();
            jbsSapInWhConfirmRequest.setApiMethod("oa_mpf_if_sc_002");
            BeanUtils.copyAllPropertys((Object)jbsSapInWhConfirmRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapInWhConfirmRequest);
            if (!execute.isSuccess()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38\u300b\u300b\u300b\u300b" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        }
    }

    @Override
    public HtmlJsonReBean receiveExDeliveryBill(String dataStr) throws Exception {
        List itemList;
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"dataStr is null");
            throw new Exception("param is null");
        }
        this.logger.error(SYS_CODE, (Object)("receiveInDeliveryBill.dataStr>>>>>>>>>" + dataStr));
        JSONObject object = JSONObject.json2object((String)dataStr);
        if (EmptyUtil.isEmpty((Object)object) || StringUtils.isBlank((String)object.getString("data"))) {
            this.logger.error(SYS_CODE, (Object)("data\u53c2\u6570\u4e3a\u7a7a" + dataStr));
            throw new Exception("data\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap dataMap = (HashMap)object.get((Object)"data");
        this.logger.error("jbsSap.JbsSapWarehouseServiceImplreceiveExDeliveryBill.dataMap", (Object)(">>>" + dataMap));
        WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
        whOpstoreDomain.setStoreGoodsType("O5");
        whOpstoreDomain.setStoreGoodsBtype("1");
        whOpstoreDomain.setOpstoreOcode(dataMap.get("VBELN") + "");
        whOpstoreDomain.setStoType(dataMap.get("LFART") + "");
        whOpstoreDomain.setWarehouseCode(dataMap.get("VSTEL") + "");
        whOpstoreDomain.setMemberBcode(dataMap.get("KUNNR") + "");
        whOpstoreDomain.setMemberBname(dataMap.get("PODAT") + "");
        whOpstoreDomain.setMemberCcode(dataMap.get("LIFNR") + "");
        whOpstoreDomain.setOpstoreOcode(dataMap.get("NAME1") + "");
        whOpstoreDomain.setTenantCode("2019071800001392");
        String items = dataMap.get("item") + "";
        if (StringUtils.isNotBlank((String)items) && ListUtil.isNotEmpty((Collection)(itemList = (List)dataMap.get("item")))) {
            ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
            for (Map map : itemList) {
                WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
                whOpstoreGoodsDomain.setStoreGoodsType("O5");
                whOpstoreGoodsDomain.setStoreGoodsBtype("1");
                whOpstoreGoodsDomain.setGoodsEocode(map.get("MATNR") + "");
                whOpstoreGoodsDomain.setGoodsName(map.get("ARKTX") + "");
                whOpstoreGoodsDomain.setWarehouseCode(map.get("WERKS") + "");
                whOpstoreGoodsDomain.setWarehouseName(map.get("LGORT") + "");
                whOpstoreGoodsDomain.setGoodsNum(ParamsUtils.getBigDecimal(map.get("LFIMG")));
                whOpstoreGoodsDomain.setPartsnameNumunit(map.get("VRKME") + "");
                whOpstoreGoodsDomain.setTenantCode("2019071800001392");
                whOpstoreGoodsDomainList.add(whOpstoreGoodsDomain);
            }
            whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        try {
            HashMap<String, String> sendMap = new HashMap<String, String>();
            whOpstoreDomain.setStoreGoodsType("O5");
            whOpstoreDomain.setStoreGoodsBtype("1");
            sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
            this.logger.error(SYS_CODE, (Object)("\u53c2\u6570\u300b\u300b\u300b" + JsonUtil.buildNormalBinder().toJson(sendMap)));
            this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("save whOpstoreDomain Exception" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
            errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "save whOpstoreDomain Exception");
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorCodes);
        }
        return new HtmlJsonReBean();
    }

    @Override
    public String ExDeliveryConfirmBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            String url = "http://devpo.jbsswift.cn:50000/RESTAdapter/oa_mpf_if_sc_004";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsSapInExWhConfirmResponse execute = null;
            JbsSapExWhConfirmRequest jbsSapExWhConfirmRequest = new JbsSapExWhConfirmRequest();
            jbsSapExWhConfirmRequest.setApiMethod("oa_mpf_if_sc_004");
            BeanUtils.copyAllPropertys((Object)jbsSapExWhConfirmRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapExWhConfirmRequest);
            if (!execute.isSuccess()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u63a8\u9001SAP\u8c03\u62e8\u51fa\u5e93\u63a5\u53e3\u5f02\u5e38>>" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u63a8\u9001SAP\u8c03\u62e8\u51fa\u5e93\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        }
    }

    @Override
    public String queryInventoryInfo(Map<String, Object> paramsMap) throws ApiException {
        if (MapUtil.isEmpty(paramsMap)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        String url = "http://devpo.jbsswift.cn:50000/RESTAdapter/os_mpf_if_sc_008";
        JbsSapQueryWhResponse execute = null;
        HttpFormfacade httpFormfacade = new HttpFormfacade(url);
        JbsSapQueryWhRequest jbsSapQueryWhRequest = new JbsSapQueryWhRequest();
        jbsSapQueryWhRequest.setApiMethod("os_mpf_if_sc_008");
        jbsSapQueryWhRequest.setMaterial((List)paramsMap.get("material"));
        jbsSapQueryWhRequest.setPlant((List)paramsMap.get("plant"));
        jbsSapQueryWhRequest.setSloc((Map)paramsMap.get("sloc"));
        jbsSapQueryWhRequest.setBatch((List)paramsMap.get("batch"));
        jbsSapQueryWhRequest.setPeriod((Map)paramsMap.get("period"));
        execute = httpFormfacade.execute(jbsSapQueryWhRequest);
        if (!execute.getSuccess().booleanValue()) {
            return JbsUtils.getErrorMap("\u8c03\u7528\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
    }

    @Override
    public String MaterialMovePosting(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            String url = "http://devpo.jbsswift.cn:50000/RESTAdapter/os_mpf_if_sc_005";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsSapMaterialMovePostingResponse execute = null;
            JbsSapMaterialMovePostingRequest jbsSapMaterialMovePostingRequest = new JbsSapMaterialMovePostingRequest();
            jbsSapMaterialMovePostingRequest.setApiMethod("os_mpf_if_sc_005");
            BeanUtils.copyAllPropertys((Object)jbsSapMaterialMovePostingRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapMaterialMovePostingRequest);
            if (!execute.isSuccess()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38", whOpstoreDomain.getOpstoreOcode());
        }
    }
}

