/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.sap.domian.DaCashSumListReDomain;
import com.yqbsoft.laser.service.sap.domian.DaSalesRateSumListReDomain;
import com.yqbsoft.laser.service.sap.domian.DaSalesSumListReDomain;
import com.yqbsoft.laser.service.sap.domian.DaSalesSumReDomain;
import com.yqbsoft.laser.service.sap.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapSalesSumContractRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapSendContractRequest;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapOrderResponse;
import com.yqbsoft.laser.service.sap.service.ContractService;
import com.yqbsoft.laser.service.sap.utils.JbsUtils;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.List;

public class ContractServiceImpl
extends BaseServiceImpl
implements ContractService {
    private String SYS_CODE = "jbsSap.ContractServiceImpl";

    @Override
    public String sendContract(DaSalesSumReDomain daSalesSumReDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)daSalesSumReDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error(this.SYS_CODE + ".sendContract", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)daSalesSumReDomain)));
        String url = "http://devpo.jbsswift.cn:50000/RESTAdapter/oa_mpf_if_otc_001";
        HttpFormfacade httpFormfacade = new HttpFormfacade(url);
        JbsSapOrderResponse execute = null;
        JbsSapSalesSumContractRequest jbsSapSalesSumContractRequest = new JbsSapSalesSumContractRequest();
        try {
            String msg = this.checkSendContract(daSalesSumReDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                return JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)daSalesSumReDomain));
            }
            jbsSapSalesSumContractRequest.setApiMethod("oa_mpf_if_otc_001");
            BeanUtils.copyAllPropertys((Object)jbsSapSalesSumContractRequest, (Object)daSalesSumReDomain);
            execute = httpFormfacade.execute(jbsSapSalesSumContractRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            this.logger.error("---\u4e0a\u4f20\u6210\u529f result----", (Object)JsonUtil.buildNormalBinder().toJson((Object)execute));
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)"sendContract is error");
            e.printStackTrace();
            return JbsUtils.getErrorMap("sendContract Exception", null);
        }
    }

    @Override
    public String sendContractPayment(DaSalesSumReDomain daSalesSumReDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)daSalesSumReDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error(this.SYS_CODE + ".sendContractPayment", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)daSalesSumReDomain)));
        String url = "http://devpo.jbsswift.cn:50000/RESTAdapter/oa_mpf_if_otc_002";
        HttpFormfacade httpFormfacade = new HttpFormfacade(url);
        JbsSapOrderResponse execute = null;
        JbsSapSendContractRequest jbsSapContractRequest = new JbsSapSendContractRequest();
        try {
            String msg = this.checkContractPayment(daSalesSumReDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                return JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)daSalesSumReDomain));
            }
            jbsSapContractRequest.setApiMethod("oa_mpf_if_otc_002");
            BeanUtils.copyAllPropertys((Object)jbsSapContractRequest, (Object)daSalesSumReDomain);
            execute = httpFormfacade.execute(jbsSapContractRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)"sendContractPayment is error");
            this.logger.error(this.SYS_CODE, (Object)JsonUtil.buildNormalBinder().toJson(null));
            e.printStackTrace();
            return JbsUtils.getErrorMap("sendContractPayment Exception", null);
        }
    }

    private String checkContractPayment(DaSalesSumReDomain daSalesSumReDomain) {
        List<DaCashSumListReDomain> daCashSumListReDomainList;
        String msg = "";
        if (StringUtils.isBlank((String)daSalesSumReDomain.getSalesSumCode())) {
            msg = msg + "SalesSumCode\u4e3a\u7a7a";
        }
        if (EmptyUtil.isEmpty((Object)daSalesSumReDomain.getTransactionDate())) {
            msg = msg + "TransactionDate\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)daSalesSumReDomain.getMemberCode())) {
            msg = msg + "MemberCode\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((Integer)daSalesSumReDomain.getDataType()) || daSalesSumReDomain.getDataType().equals(3) && daSalesSumReDomain.getDataType().equals(4)) {
            msg = msg + "DataType\u4e3a\u7a7a && \u7c7b\u578b\u4e0d\u5bf9";
        }
        if (EmptyUtil.isEmpty((Object)daSalesSumReDomain.getTransactionStartDate())) {
            msg = msg + "TransactionStartDate\u4e3a\u7a7a";
        }
        if (EmptyUtil.isEmpty((Object)daSalesSumReDomain.getTransactionEndDate())) {
            msg = msg + "TransactionEndDate\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(daCashSumListReDomainList = daSalesSumReDomain.getDaCashSumListReDomainList())) {
            msg = msg + "DaCashSumListReDomainList\u4e3a\u7a7a";
        }
        for (DaCashSumListReDomain daCashSumListReDomain : daCashSumListReDomainList) {
            if (StringUtils.isBlank((String)daCashSumListReDomain.getAmountSign())) {
                msg = msg + "AmountSign\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daCashSumListReDomain.getTransactionCode())) {
                msg = msg + "TransactionCode\u4e3a\u7a7a";
            }
            if (EmptyUtil.isEmpty((Object)daCashSumListReDomain.getTransactionAmount())) {
                msg = msg + "TransactionAmount\u4e3a\u7a7a";
            }
            if (!StringUtils.isBlank((String)daCashSumListReDomain.getTransactionCurrency())) continue;
            msg = msg + "TransactionCurrency\u4e3a\u7a7a";
        }
        return msg;
    }

    private String checkSendContract(DaSalesSumReDomain daSalesSumReDomain) {
        List<DaSalesSumListReDomain> sumListReDomainList;
        String msg = "";
        if (StringUtils.isBlank((String)daSalesSumReDomain.getSalesSumCode())) {
            msg = msg + "SalesSumCode\u4e3a\u7a7a";
        }
        if (EmptyUtil.isEmpty((Object)daSalesSumReDomain.getTransactionDate())) {
            msg = msg + "TransactionDate\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)daSalesSumReDomain.getMemberCode())) {
            msg = msg + "MemberCode\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((Integer)daSalesSumReDomain.getDataType()) || daSalesSumReDomain.getDataType().equals(1) && daSalesSumReDomain.getDataType().equals(2)) {
            msg = msg + "DataType\u4e3a\u7a7a && \u7c7b\u578b\u4e0d\u5bf9";
        }
        if (EmptyUtil.isEmpty((Object)daSalesSumReDomain.getTransactionStartDate())) {
            msg = msg + "TransactionStartDate\u4e3a\u7a7a";
        }
        if (EmptyUtil.isEmpty((Object)daSalesSumReDomain.getTransactionEndDate())) {
            msg = msg + "TransactionEndDate\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(sumListReDomainList = daSalesSumReDomain.getDaSalesSumListReDomainList())) {
            msg = msg + "DaSalesSumListReDomainList\u4e3a\u7a7a";
        }
        for (DaSalesSumListReDomain daSalesSumListReDomain : sumListReDomainList) {
            List<DaSalesRateSumListReDomain> daSalesRateSumListReDomainList;
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getMatnr())) {
                msg = msg + "Matnr\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getBarCode())) {
                msg = msg + "BarCode\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getBatch())) {
                msg = msg + "Batch\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getIssWerks())) {
                msg = msg + "IssWerks\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getIssLgort())) {
                msg = msg + "IssLgort\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getCntSign())) {
                msg = msg + "CntSign\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((Integer)daSalesSumListReDomain.getCnt())) {
                msg = msg + "Cnt\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getOriginalCostSign())) {
                msg = msg + "OriginalCostSign\u4e3a\u7a7a";
            }
            if (EmptyUtil.isEmpty((Object)daSalesSumListReDomain.getOriginalCost())) {
                msg = msg + "OriginalCost\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getTaxAmtType())) {
                msg = msg + "TaxAmtType\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getTaxAmtCode())) {
                msg = msg + "TaxAmtCode\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getTaxAmtSign())) {
                msg = msg + "TaxAmtSign\u4e3a\u7a7a";
            }
            if (EmptyUtil.isEmpty((Object)daSalesSumListReDomain.getTaxAmt())) {
                msg = msg + "TaxAmt\u4e3a\u7a7a";
            }
            if (ListUtil.isEmpty(daSalesRateSumListReDomainList = daSalesSumListReDomain.getDaSalesRateSumListReDomainList())) {
                msg = msg + "DaSalesRateSumListReDomainList\u4e3a\u7a7a";
            }
            for (DaSalesRateSumListReDomain daSalesRateSumListReDomain : daSalesRateSumListReDomainList) {
                if (StringUtils.isBlank((String)daSalesRateSumListReDomain.getDiscType())) {
                    msg = msg + "DiscType\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((String)daSalesRateSumListReDomain.getDiscAmtSign())) {
                    msg = msg + "DiscAmtSign\u4e3a\u7a7a";
                }
                if (EmptyUtil.isEmpty((Object)daSalesRateSumListReDomain.getDiscAmt())) {
                    msg = msg + "DiscAmt\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((String)daSalesRateSumListReDomain.getDiscTaxType())) {
                    msg = msg + "DiscTaxType\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((String)daSalesRateSumListReDomain.getDiscTaxSign())) {
                    msg = msg + "DiscTaxSign\u4e3a\u7a7a";
                }
                if (!EmptyUtil.isEmpty((Object)daSalesRateSumListReDomain.getDiscTax())) continue;
                msg = msg + "DiscTax\u4e3a\u7a7a";
            }
        }
        return msg;
    }
}

