/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.sap.domian.DaSalesSumReDomain;
import com.yqbsoft.laser.service.sap.service.ContractService;
import com.yqbsoft.laser.service.sap.service.DataService;
import com.yqbsoft.laser.service.sap.utils.JbsUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataServiceImpl
extends BaseServiceImpl
implements DataService {
    private String SYS_CODE = "jbsSap.DataServiceImpl";
    private ContractService contractService;
    private Map<String, Object> allData = new HashMap<String, Object>();
    private final String date = DateUtil.getAfterDate((Date)new Date(), (int)-1, (String)"yyyy-MM-dd");
    private final String startDate = this.date + " 00:00:00";
    private final String endDate = this.date + " 23:59:59";

    public void setContractService(ContractService contractService) {
        this.contractService = contractService;
    }

    @Override
    public void sendSumData(String salesSumCode) throws ApiException, IOException {
    }

    @Override
    public String sendSalesOrderSumReport(String tenantCode) throws ApiException {
        try {
            this.queryData(tenantCode, 1);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("createSendSalesOrderSumReport exception----" + e.getMessage()));
            e.printStackTrace();
            return JbsUtils.getErrorMap(this.SYS_CODE + ".createSendSalesOrderSumReport", "error");
        }
        return JbsUtils.getSuccessMap("success");
    }

    @Override
    public String sendRefundOrderSumReport(String tenantCode) throws ApiException {
        try {
            this.queryData(tenantCode, 2);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("createSendRefundOrderSumReport exception" + e.getMessage()));
            e.printStackTrace();
            return JbsUtils.getErrorMap(this.SYS_CODE + ".createSendRefundOrderSumReport", "error");
        }
        return JbsUtils.getSuccessMap("success");
    }

    @Override
    public String sendSalesCashSumReport(String tenantCode) throws ApiException {
        try {
            this.queryData(tenantCode, 3);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("createSendSalesCashSumReport exception" + e.getMessage()));
            e.printStackTrace();
            return JbsUtils.getErrorMap(this.SYS_CODE + ".createSendSalesCashSumReport", "error");
        }
        return JbsUtils.getSuccessMap("success");
    }

    @Override
    public String sendRefundCashSumReport(String tenantCode) throws ApiException {
        try {
            this.queryData(tenantCode, 4);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("createSendRefundCashSumReport exception" + e.getMessage()));
            e.printStackTrace();
            return JbsUtils.getErrorMap(this.SYS_CODE + ".createSendRefundCashSumReport", "error");
        }
        return JbsUtils.getSuccessMap("success");
    }

    private void queryData(String tenantCode, int type) throws Exception {
        List daSalesSumReDomains;
        this.logger.error("----------------queryData\u5f00\u59cb-----------------------");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flag", 1);
        map.put("tenantCode", tenantCode);
        map.put("dataType", type);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        for (int cnt = 0; cnt < 1000 && ListUtil.isNotEmpty((Collection)(daSalesSumReDomains = (List)this.readObj("da.daSalesSum.sendSumData", invokeMap, "list", new Object[]{DaSalesSumReDomain.class}))); ++cnt) {
            this.logger.error("----------------queryData\u6570\u91cf-----------------------\uff1a" + daSalesSumReDomains.size());
            int i = 1;
            for (DaSalesSumReDomain daSalesSumReDomain : daSalesSumReDomains) {
                if (this.allData.get(daSalesSumReDomain.getSalesSumCode()) == null) {
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    dataMap.put("salesSumReDomain", daSalesSumReDomain);
                    this.logger.error("----------------\u63a8\u9001\u6570\u636e-----------------------" + i + "=======", (Object)(daSalesSumReDomain.getSalesSumCode() + "===" + daSalesSumReDomain.getDataType()));
                    if (daSalesSumReDomain.getDataType() == 1 || daSalesSumReDomain.getDataType() == 2) {
                        this.updateDataStatus(this.contractService.sendContract(dataMap), daSalesSumReDomain.getSalesSumCode());
                    } else if (daSalesSumReDomain.getDataType() == 3 || daSalesSumReDomain.getDataType() == 4) {
                        this.updateDataStatus(this.contractService.sendContractPayment(dataMap), daSalesSumReDomain.getSalesSumCode());
                    }
                }
                this.allData.put(daSalesSumReDomain.getSalesSumCode(), daSalesSumReDomain.getSalesSumId());
                ++i;
            }
        }
        this.logger.error("----------------queryData\u7ed3\u675f-----------------------");
    }

    private void updateDataStatus(String result, String salesSumCode) {
        this.logger.error("----------------updateDataStatus\u5f00\u59cb-----------------------", (Object)result);
        if (StringUtils.isNotBlank((String)result)) {
            Map resultMap = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(result, String.class, Object.class);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("salesSumCode", salesSumCode);
            if (resultMap != null && ((Boolean)resultMap.get("success")).booleanValue()) {
                map.put("dataState", 1);
            } else {
                map.put("dataState", 2);
            }
            map.put("memo", resultMap.get("msg") != null ? (String)resultMap.get("msg") : "");
            HashMap<String, String> invokeMap = new HashMap<String, String>();
            invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
            this.logger.error("----------------updateDataStatus\u6570\u636e-----------------------" + JsonUtil.buildNonDefaultBinder().toJson(map));
            this.inAsyncInvoke("da.daSalesSum.updateDataState", invokeMap);
            this.logger.error("----------------updateDataStatus\u7ed3\u675f-----------------------");
        }
    }
}

