/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.sap.JbsSapServerConstants;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreDomain;
import com.yqbsoft.laser.service.sap.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapExWhConfirmRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapInWhConfirmRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapMaterialMovePostingRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapQueryWhRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapSTORequest;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapInExWhConfirmResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapMaterialMovePostingResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapQueryWhResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapSTOResponse;
import com.yqbsoft.laser.service.sap.model.HtmlJsonReBean;
import com.yqbsoft.laser.service.sap.service.JbsSapWarehouseService;
import com.yqbsoft.laser.service.sap.utils.JbsUtils;
import com.yqbsoft.laser.service.sap.utils.ParamsUtils;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JbsSapWarehouseServiceImpl
extends BaseServiceImpl
implements JbsSapWarehouseService {
    public static final String SYS_CODE = "jbsSap.JbsSapWarehouseServiceImpl";

    @Override
    public String sendSTOBill(WhOpstoreDomain whOpstoreDomain) throws Exception {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        String url = JbsSapServerConstants.SAP_CREATE_STO_URL;
        HttpFormfacade httpFormfacade = new HttpFormfacade(url);
        JbsSapSTORequest jbsSapSTORequest = new JbsSapSTORequest();
        jbsSapSTORequest.setApiMethod("os_mpf_if_sc_006");
        BeanUtils.copyAllPropertys((Object)jbsSapSTORequest, (Object)whOpstoreDomain);
        JbsSapSTOResponse execute = httpFormfacade.execute(jbsSapSTORequest);
        if (null == execute || !execute.getSuccess().booleanValue()) {
            return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
    }

    @Override
    public HtmlJsonReBean receiveInDeliveryBill(String dataStr) throws Exception {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"dataStr is null");
            throw new Exception("param is null");
        }
        this.logger.error(SYS_CODE, (Object)("receiveInDeliveryBill.dataStr>>>>>>>>>" + dataStr));
        JSONObject object = JSONObject.json2object((String)dataStr);
        this.logger.error(SYS_CODE, (Object)("receiveInDeliveryBill.toObject>>>>>>>>>" + JsonUtil.buildNormalBinder().toJson((Object)object)));
        if (EmptyUtil.isEmpty((Object)object) || StringUtils.isBlank((String)object.getString("data")) || EmptyUtil.isEmpty(((HashMap)object.get((Object)"data")).get("list"))) {
            this.logger.error(SYS_CODE, (Object)("data\u53c2\u6570\u4e3a\u7a7a" + dataStr));
            throw new Exception("data\u53c2\u6570\u4e3a\u7a7a");
        }
        Map dataMap = (Map)((HashMap)object.get((Object)"data")).get("list");
        this.logger.error("jbsSap.JbsSapWarehouseServiceImplreceiveInDeliveryBill.dataMap", (Object)("------------" + dataMap));
        ArrayList<String> errorCodes = new ArrayList<String>();
        WhOpstoreDomain whOpstoreDomain = ParamsUtils.JbsSapMap2opDomain(dataMap);
        if (null == whOpstoreDomain) {
            this.logger.error(SYS_CODE, (Object)("data \u8f6c\u6362\u5bf9\u8c61\u5f02\u5e38>>>>" + JsonUtil.buildNormalBinder().toJson((Object)dataMap)));
            errorCodes.add("data \u8f6c\u6362\u5bf9\u8c61\u5f02\u5e38");
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:\n" + errorCodes);
        }
        try {
            HashMap<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
            this.logger.error(SYS_CODE, (Object)JsonUtil.buildNormalBinder().toJson(sendMap));
            this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("save whOpstoreDomain Exception" + whOpstoreDomain.getOpstoreOcode()));
            errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "save whOpstoreDomain Exception");
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            this.logger.error(SYS_CODE, (Object)("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff1a\n" + errorCodes));
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:\n" + errorCodes);
        }
        return new HtmlJsonReBean();
    }

    @Override
    public String InDeliveryConfirmBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            String url = JbsSapServerConstants.SAP_INWH_CONFIRM_URL;
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsSapInExWhConfirmResponse execute = null;
            JbsSapInWhConfirmRequest jbsSapInWhConfirmRequest = new JbsSapInWhConfirmRequest();
            jbsSapInWhConfirmRequest.setApiMethod("oa_mpf_if_sc_002");
            BeanUtils.copyAllPropertys((Object)jbsSapInWhConfirmRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapInWhConfirmRequest);
            if (!execute.isSuccess()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38\u300b\u300b\u300b\u300b" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        }
    }

    @Override
    public HtmlJsonReBean receiveExDeliveryBill(String dataStr) throws Exception {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"dataStr is null");
            throw new Exception("dataStr is null");
        }
        this.logger.error(SYS_CODE, (Object)("receiveExDeliveryBill.dataStr>>>>>>>>>" + dataStr));
        JSONObject object = JSONObject.json2object((String)dataStr);
        if (EmptyUtil.isEmpty((Object)object) || StringUtils.isBlank((String)object.getString("data")) || EmptyUtil.isEmpty(((HashMap)object.get((Object)"data")).get("list"))) {
            this.logger.error(SYS_CODE, (Object)("data\u53c2\u6570\u4e3a\u7a7a" + dataStr));
            throw new Exception("data\u53c2\u6570\u4e3a\u7a7a");
        }
        Map dataMap = (Map)((HashMap)object.get((Object)"data")).get("list");
        this.logger.error("jbsSap.JbsSapWarehouseServiceImplreceiveExDeliveryBill.dataMap", (Object)("------------" + dataMap));
        ArrayList<String> errorCodes = new ArrayList<String>();
        WhOpstoreDomain whOpstoreDomain = ParamsUtils.JbsSapMap2opDomain(dataMap);
        if (null == whOpstoreDomain) {
            this.logger.error(SYS_CODE, (Object)("data \u8f6c\u6362\u5bf9\u8c61\u5f02\u5e38>>>>" + JsonUtil.buildNormalBinder().toJson((Object)dataMap)));
            errorCodes.add("data \u8f6c\u6362\u5bf9\u8c61\u5f02\u5e38");
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:\n" + errorCodes);
        }
        try {
            HashMap<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
            this.logger.error(SYS_CODE, (Object)JsonUtil.buildNormalBinder().toJson(sendMap));
            this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("save whOpstoreDomain Exception" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
            errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "save whOpstoreDomain Exception");
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorCodes);
        }
        return new HtmlJsonReBean();
    }

    @Override
    public String ExDeliveryConfirmBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            String url = JbsSapServerConstants.SAP_EXWH_CONFIRM_URL;
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsSapInExWhConfirmResponse execute = null;
            JbsSapExWhConfirmRequest jbsSapExWhConfirmRequest = new JbsSapExWhConfirmRequest();
            jbsSapExWhConfirmRequest.setApiMethod("oa_mpf_if_sc_004");
            BeanUtils.copyAllPropertys((Object)jbsSapExWhConfirmRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapExWhConfirmRequest);
            if (!execute.isSuccess()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u63a8\u9001SAP\u8c03\u62e8\u51fa\u5e93\u63a5\u53e3\u5f02\u5e38>>" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u63a8\u9001SAP\u8c03\u62e8\u51fa\u5e93\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        }
    }

    @Override
    public String queryInventoryInfo(Map<String, Object> paramsMap) throws ApiException {
        if (MapUtil.isEmpty(paramsMap)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        String url = JbsSapServerConstants.SAP_QUERY_SAPWH_URL;
        JbsSapQueryWhResponse execute = null;
        HttpFormfacade httpFormfacade = new HttpFormfacade(url);
        JbsSapQueryWhRequest jbsSapQueryWhRequest = new JbsSapQueryWhRequest();
        jbsSapQueryWhRequest.setApiMethod("os_mpf_if_sc_008");
        jbsSapQueryWhRequest.setMaterial((List)paramsMap.get("material"));
        jbsSapQueryWhRequest.setPlant((List)paramsMap.get("plant"));
        jbsSapQueryWhRequest.setSloc((Map)paramsMap.get("sloc"));
        jbsSapQueryWhRequest.setBatch((List)paramsMap.get("batch"));
        jbsSapQueryWhRequest.setPeriod((Map)paramsMap.get("period"));
        execute = httpFormfacade.execute(jbsSapQueryWhRequest);
        if (!execute.getSuccess().booleanValue()) {
            return JbsUtils.getErrorMap("\u8c03\u7528\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
    }

    @Override
    public String MaterialMovePosting(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            String url = JbsSapServerConstants.SAP_MATERIAL_MOVEPOSTING_URL;
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsSapMaterialMovePostingResponse execute = null;
            JbsSapMaterialMovePostingRequest jbsSapMaterialMovePostingRequest = new JbsSapMaterialMovePostingRequest();
            jbsSapMaterialMovePostingRequest.setApiMethod("os_mpf_if_sc_005");
            BeanUtils.copyAllPropertys((Object)jbsSapMaterialMovePostingRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapMaterialMovePostingRequest);
            if (!execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", String.valueOf(execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38" + e + "\nParam:" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
            return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38", whOpstoreDomain.getOpstoreOcode());
        }
    }
}

