/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.sap.domian.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreDomain;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.sap.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapExWhConfirmRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapInWhConfirmRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapMaterialMovePostingRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapQueryWhRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapSTORequest;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapInExWhConfirmResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapMaterialMovePostingResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapQueryWhResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapSTOResponse;
import com.yqbsoft.laser.service.sap.model.HtmlJsonReBean;
import com.yqbsoft.laser.service.sap.model.WhOpstoreGoods;
import com.yqbsoft.laser.service.sap.service.JbsSapWarehouseService;
import com.yqbsoft.laser.service.sap.utils.JbsUtils;
import com.yqbsoft.laser.service.sap.utils.ParamsUtils;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JbsSapWarehouseServiceImpl
extends BaseServiceImpl
implements JbsSapWarehouseService {
    public static final String SYS_CODE = "jbsSap.JbsSapWarehouseServiceImpl";

    @Override
    public String sendSTOBill(WhOpstoreDomain whOpstoreDomain) throws Exception {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        HttpFormfacade httpFormfacade = new HttpFormfacade();
        JbsSapSTORequest jbsSapSTORequest = new JbsSapSTORequest();
        jbsSapSTORequest.setApiMethod("os_mpf_if_sc_006");
        BeanUtils.copyAllPropertys((Object)jbsSapSTORequest, (Object)whOpstoreDomain);
        JbsSapSTOResponse execute = httpFormfacade.execute(jbsSapSTORequest);
        if (null == execute || !execute.getSuccess().booleanValue()) {
            return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
    }

    @Override
    public HtmlJsonReBean receiveInDeliveryBill(String dataStr) throws Exception {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"dataStr is null");
            throw new Exception("param is null");
        }
        JSONObject object = JSONObject.json2object((String)dataStr);
        if (EmptyUtil.isEmpty((Object)object) || StringUtils.isBlank((String)object.getString("data")) || EmptyUtil.isEmpty(((HashMap)object.get((Object)"data")).get("list"))) {
            this.logger.error(SYS_CODE, (Object)("data\u53c2\u6570\u4e3a\u7a7a" + dataStr));
            throw new Exception("data\u53c2\u6570\u4e3a\u7a7a");
        }
        Map dataMap = (Map)((HashMap)object.get((Object)"data")).get("list");
        ArrayList<String> errorCodes = new ArrayList<String>();
        WhOpstoreDomain whOpstoreDomain = ParamsUtils.JbsSapMap2opDomain(dataMap);
        if (null == whOpstoreDomain) {
            this.logger.error(SYS_CODE, (Object)("data \u8f6c\u6362\u5bf9\u8c61\u5931\u8d25>>>>" + JsonUtil.buildNormalBinder().toJson((Object)dataMap)));
            errorCodes.add("data \u8f6c\u6362\u5bf9\u8c61\u5931\u8d25");
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorCodes);
        }
        try {
            HashMap<String, String> sendMap = new HashMap<String, String>();
            Map checkResultMap = this.checkExist(whOpstoreDomain);
            Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
            WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
            this.checkGoodsClass(currentObj);
            sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
            this.logger.info(SYS_CODE, (Object)(checkFlag + "=" + JsonUtil.buildNormalBinder().toJson(sendMap)));
            if (checkFlag.booleanValue()) {
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendUpdateOpstore", sendMap);
            } else {
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"SAP\u63a5\u6536\u5185\u5411\u4ea4\u8d27\u5355\u63a5\u53e3\u5f02\u5e38>>>>", (Throwable)e);
            errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "SAP\u63a5\u6536\u5185\u5411\u4ea4\u8d27\u5355\u63a5\u53e3\u5f02\u5e38");
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            this.logger.error(SYS_CODE, (Object)("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff1a" + errorCodes));
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorCodes);
        }
        return new HtmlJsonReBean();
    }

    @Override
    public String InDeliveryConfirmBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            JbsSapInExWhConfirmResponse execute = null;
            JbsSapInWhConfirmRequest jbsSapInWhConfirmRequest = new JbsSapInWhConfirmRequest();
            jbsSapInWhConfirmRequest.setApiMethod("oa_mpf_if_sc_002");
            BeanUtils.copyAllPropertys((Object)jbsSapInWhConfirmRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapInWhConfirmRequest);
            if (!execute.isSuccess()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"SAP\u5185\u5411\u4ea4\u8d27\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38>>>>", (Throwable)e);
            return JbsUtils.getErrorMap("SAP\u5185\u5411\u4ea4\u8d27\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        }
    }

    @Override
    public HtmlJsonReBean receiveExDeliveryBill(String dataStr) throws Exception {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"dataStr is null");
            throw new Exception("dataStr is null");
        }
        JSONObject object = JSONObject.json2object((String)dataStr);
        if (EmptyUtil.isEmpty((Object)object) || StringUtils.isBlank((String)object.getString("data")) || EmptyUtil.isEmpty(((HashMap)object.get((Object)"data")).get("list"))) {
            this.logger.error(SYS_CODE, (Object)("data\u53c2\u6570\u4e3a\u7a7a" + dataStr));
            throw new Exception("data\u53c2\u6570\u4e3a\u7a7a");
        }
        Map dataMap = (Map)((HashMap)object.get((Object)"data")).get("list");
        ArrayList<String> errorCodes = new ArrayList<String>();
        WhOpstoreDomain whOpstoreDomain = ParamsUtils.JbsSapMap2opDomain(dataMap);
        if (null == whOpstoreDomain) {
            this.logger.error(SYS_CODE, (Object)("data \u8f6c\u6362\u5bf9\u8c61\u5931\u8d25>>>>" + JsonUtil.buildNormalBinder().toJson((Object)dataMap)));
            errorCodes.add("data \u8f6c\u6362\u5bf9\u8c61\u5931\u8d25");
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorCodes);
        }
        try {
            HashMap<String, String> sendMap = new HashMap<String, String>();
            Map checkResultMap = this.checkExist(whOpstoreDomain);
            Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
            WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
            this.checkGoodsClass(currentObj);
            sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
            this.logger.info(SYS_CODE, (Object)(checkFlag + "=" + JsonUtil.buildNormalBinder().toJson(sendMap)));
            if (checkFlag.booleanValue()) {
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendUpdateOpstore", sendMap);
            } else {
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"SAP\u63a5\u6536\u5916\u5411\u4ea4\u8d27\u5355\u63a5\u53e3\u5f02\u5e38>>", (Throwable)e);
            errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "SAP\u63a5\u6536\u5916\u5411\u4ea4\u8d27\u5355\u63a5\u53e3\u5f02\u5e38");
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorCodes);
        }
        return new HtmlJsonReBean();
    }

    @Override
    public String ExDeliveryConfirmBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            JbsSapInExWhConfirmResponse execute = null;
            JbsSapExWhConfirmRequest jbsSapExWhConfirmRequest = new JbsSapExWhConfirmRequest();
            jbsSapExWhConfirmRequest.setApiMethod("oa_mpf_if_sc_004");
            BeanUtils.copyAllPropertys((Object)jbsSapExWhConfirmRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapExWhConfirmRequest);
            if (!execute.isSuccess()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"\u63a8\u9001SAP\u5916\u5411\u4ea4\u8d27\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38>>", (Throwable)e);
            return JbsUtils.getErrorMap("\u63a8\u9001SAP\u5916\u5411\u4ea4\u8d27\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain.getOpstoreCode()));
        }
    }

    @Override
    public String queryInventoryInfo(Map<String, Object> paramsMap) throws ApiException {
        if (MapUtil.isEmpty(paramsMap)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        JbsSapQueryWhResponse execute = null;
        HttpFormfacade httpFormfacade = new HttpFormfacade();
        JbsSapQueryWhRequest jbsSapQueryWhRequest = new JbsSapQueryWhRequest();
        jbsSapQueryWhRequest.setApiMethod("os_mpf_if_sc_008");
        jbsSapQueryWhRequest.setMaterial((List)paramsMap.get("material"));
        jbsSapQueryWhRequest.setPlant((List)paramsMap.get("plant"));
        jbsSapQueryWhRequest.setSloc((Map)paramsMap.get("sloc"));
        jbsSapQueryWhRequest.setBatch((List)paramsMap.get("batch"));
        jbsSapQueryWhRequest.setPeriod((Map)paramsMap.get("period"));
        execute = httpFormfacade.execute(jbsSapQueryWhRequest);
        if (!execute.getSuccess().booleanValue()) {
            return JbsUtils.getErrorMap("\u8c03\u7528\u5931\u8d25:" + execute.getMsg(), JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute.getReturnData()));
    }

    public static void main(String[] args) {
        HashMap map = new HashMap();
        ArrayList MaterialList = new ArrayList();
        HashMap<String, String> MaterialMap = new HashMap<String, String>();
        MaterialMap.put("Low", "X0100501");
        MaterialMap.put("High", "");
        MaterialList.add(MaterialMap);
        ArrayList PlantList = new ArrayList();
        HashMap<String, String> PlantMap = new HashMap<String, String>();
        PlantMap.put("Low", "");
        PlantMap.put("High", "");
        PlantList.add(PlantMap);
        ArrayList SlocList = new ArrayList();
        HashMap<String, String> SlocMap = new HashMap<String, String>();
        SlocMap.put("Low", "");
        SlocMap.put("High", "");
        SlocList.add(SlocMap);
        ArrayList BatchList = new ArrayList();
        HashMap<String, String> BatchMap = new HashMap<String, String>();
        BatchMap.put("Low", "");
        BatchMap.put("High", "");
        BatchList.add(BatchMap);
        ArrayList PeriodList = new ArrayList();
        HashMap<String, String> PeriodMap = new HashMap<String, String>();
        PeriodMap.put("Low", "");
        PeriodMap.put("High", "");
        PeriodList.add(PeriodMap);
        map.put("Material", MaterialList);
        map.put("Plant", PlantList);
        map.put("Sloc", SlocList);
        map.put("Batch", BatchList);
        map.put("Period", PeriodList);
        System.out.println(JsonUtil.buildNormalBinder().toJson(map));
    }

    @Override
    public String MaterialMovePosting(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        if ("L0".equals(whOpstoreDomain.getStoreGoodsBtype()) && StringUtils.isBlank((String)whOpstoreDomain.getCompanyCode())) {
            return JbsUtils.getErrorMap("\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a", "");
        }
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            return JbsUtils.getErrorMap("GoodsList\u5546\u54c1\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", "");
        }
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                return JbsUtils.getErrorMap("SkuList\u6279\u6b21\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", "");
            }
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                if (!StringUtils.isBlank((String)whOpstoreSkuDomain.getPntreeCode())) continue;
                return JbsUtils.getErrorMap("SkuList\u6279\u6b21\u5c42\u7ea7\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "");
            }
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            JbsSapMaterialMovePostingResponse execute = null;
            JbsSapMaterialMovePostingRequest jbsSapMaterialMovePostingRequest = new JbsSapMaterialMovePostingRequest();
            jbsSapMaterialMovePostingRequest.setApiMethod("os_mpf_if_sc_005");
            BeanUtils.copyAllPropertys((Object)jbsSapMaterialMovePostingRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapMaterialMovePostingRequest);
            if (!execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute.getReturnData()));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute.getReturnData()));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"SAP\u7269\u6599\u79fb\u52a8\u8fc7\u8d26\u63a5\u53e3\u5f02\u5e38>>>", (Throwable)e);
            return JbsUtils.getErrorMap("SAP\u7269\u6599\u79fb\u52a8\u8fc7\u8d26\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        }
    }

    public Map checkExist(WhOpstoreDomain whOpstoreDomain) throws Exception {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        if (null == whOpstoreDomain || StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
            throw new Exception("checkExist\u4f20\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        try {
            WhOpstoreDomain getDbObj = null;
            queryMap.put("opstoreOcode", whOpstoreDomain.getOpstoreOcode());
            queryMap.put("tenantCode", "2019071800001392");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
            QueryResult queryStoreResult = this.sendReSupObject("wh.WhOpstore.queryOpstorePage", map, WhOpstoreDomain.class);
            if (queryStoreResult != null && ListUtil.isNotEmpty((Collection)queryStoreResult.getList()) && !EmptyUtil.isEmpty(queryStoreResult.getList().get(0))) {
                getDbObj = (WhOpstoreDomain)queryStoreResult.getList().get(0);
                BeanUtils.copyAllPropertysNotNull((Object)getDbObj, (Object)whOpstoreDomain);
                List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
                HashMap<String, WhOpstoreGoodsDomain> receiveDataMap = new HashMap<String, WhOpstoreGoodsDomain>();
                for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                    receiveDataMap.put(whOpstoreGoodsDomain.getChannelName() + "-" + whOpstoreGoodsDomain.getGoodsProperty2() + "-" + whOpstoreGoodsDomain.getOpstoreGoodsEocode(), whOpstoreGoodsDomain);
                }
                queryMap.clear();
                map.clear();
                if (StringUtils.isBlank((String)getDbObj.getOpstoreCode())) {
                    throw new Exception("checkExist\u67e5\u8be2Goods\u7684opstoreCode\u4e3a\u7a7a");
                }
                queryMap.put("tenantCode", "2019071800001392");
                queryMap.put("opstoreCode", getDbObj.getOpstoreCode());
                QueryResult queryDbGoodsResult = this.sendReSupObject("wh.WhOpstore.queryOpstoreGoodsPage", queryMap, WhOpstoreGoods.class);
                if (queryDbGoodsResult != null && ListUtil.isNotEmpty((Collection)queryDbGoodsResult.getList())) {
                    ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomains = new ArrayList<WhOpstoreGoodsDomain>();
                    for (WhOpstoreGoods whOpstoreGoods : queryDbGoodsResult.getList()) {
                        WhOpstoreGoodsDomain whOpstoreGoodsDomain = (WhOpstoreGoodsDomain)receiveDataMap.get(whOpstoreGoods.getChannelName() + "-" + whOpstoreGoods.getGoodsProperty2() + "-" + whOpstoreGoods.getOpstoreGoodsEocode());
                        if (null == whOpstoreGoodsDomain) continue;
                        BeanUtils.copyAllPropertysNotNull((Object)whOpstoreGoods, (Object)whOpstoreGoodsDomain);
                        WhOpstoreGoodsDomain afterEditObj = new WhOpstoreGoodsDomain();
                        BeanUtils.copyAllPropertys((Object)afterEditObj, (Object)whOpstoreGoods);
                        whOpstoreGoodsDomains.add(afterEditObj);
                    }
                    getDbObj.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomains);
                }
                queryMap.put("checkFlag", "true");
            } else {
                queryMap.put("checkFlag", "false");
            }
            queryMap.put("currentObj", null == getDbObj ? whOpstoreDomain : getDbObj);
            return queryMap;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"checkExist\u5904\u7406\u6570\u636e\u5f02\u5e38", (Throwable)e);
            throw new Exception("checkExist\u5904\u7406\u6570\u636e\u5f02\u5e38");
        }
    }

    public void checkGoodsClass(WhOpstoreDomain whOpstoreDomain) {
        if (!EmptyUtil.isEmpty((Object)whOpstoreDomain) && ListUtil.isNotEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            HashMap<String, String> sendMap = new HashMap<String, String>();
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("goodsClass", "plat");
                paramMap.put("goodsNo", whOpstoreGoodsDomain.getGoodsNo());
                paramMap.put("memberCode", whOpstoreDomain.getMemberCode());
                paramMap.put("tenantCode", "2019071800001392");
                sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
                QueryResult queryResult = this.sendReSupObject("rs.resourceGoods.queryResourceGoodsPage", sendMap, RsResourceGoodsReDomain.class);
                if (null == queryResult || !ListUtil.isNotEmpty((Collection)queryResult.getList())) continue;
                RsResourceGoodsReDomain rsResourceGoods = (RsResourceGoodsReDomain)queryResult.getList().get(0);
                whOpstoreGoodsDomain.setClasstreeCode(rsResourceGoods.getClasstreeCode());
                whOpstoreGoodsDomain.setClasstreeName(rsResourceGoods.getClasstreeName());
            }
        }
    }
}

