/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.sap.domian.InvInvlist;
import com.yqbsoft.laser.service.sap.domian.InvInvlistDomain;
import com.yqbsoft.laser.service.sap.domian.InvInvlistGoods;
import com.yqbsoft.laser.service.sap.domian.InvInvrate;
import com.yqbsoft.laser.service.sap.domian.InvUserinv;
import com.yqbsoft.laser.service.sap.domian.OcContractReDomain;
import com.yqbsoft.laser.service.sap.domian.OcRefundReDomain;
import com.yqbsoft.laser.service.sap.domian.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.sap.domian.UmUser;
import com.yqbsoft.laser.service.sap.domian.UmUserinfo;
import com.yqbsoft.laser.service.sap.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapSendInvoiceRequest;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapSendInvoiceResponse;
import com.yqbsoft.laser.service.sap.service.InvoiceService;
import com.yqbsoft.laser.service.sap.utils.JbsUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvoiceServiceImpl
extends BaseServiceImpl
implements InvoiceService {
    private String SYS_CODE = "jbsSap.InvoiceServiceImpl";

    @Override
    public String sendInvoice(InvInvlist invInvlist) throws Exception {
        InvInvlist invList;
        this.logger.error(this.SYS_CODE + ".sendInvoice.invInvlist", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invInvlist));
        if (null == invInvlist) {
            this.logger.error(this.SYS_CODE + ".sendInvoice.invInvlist.null");
            this.updateInvlist(invInvlist, "invInvlist\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return JbsUtils.getErrorMap("invInvlist\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", "01");
        }
        InvInvlist invlist = this.queryInvlist(invInvlist.getInvlistCode());
        List<InvInvlistGoods> invInvlistGoodsList = this.queryInvlistGoodsPage(invlist.getTenantCode(), invlist.getInvlistCode());
        if (ListUtil.isEmpty(invInvlistGoodsList)) {
            this.logger.error(this.SYS_CODE + ".sendInvoice.invInvlistGoodsList.null", (Object)(invlist.getTenantCode() + "=======" + invlist.getInvlistCode()));
            this.updateInvlist(invlist, "invInvlistGoodsList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return JbsUtils.getErrorMap("invInvlistGoodsList\u4e0d\u80fd\u4e3a\u7a7a\uff01", "01");
        }
        OcContractReDomain ocContractReDomain = this.checkOcContract(invlist.getInvlistOpcode());
        if (null == ocContractReDomain) {
            this.logger.error(this.SYS_CODE + ".sendInvoice.ocContractReDomain.null");
            this.updateInvlist(invlist, "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
            return JbsUtils.getErrorMap("\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728", "01");
        }
        if (1 != ocContractReDomain.getContractInvstate()) {
            this.updateInvlist(invlist, "\u8ba2\u5355\u5df2\u5f00\u7968");
            return JbsUtils.getErrorMap("\u8ba2\u5355\u5df2\u5f00\u7968", "02");
        }
        if (ocContractReDomain.getDataState() < 0 || 2 == ocContractReDomain.getDataState()) {
            this.updateInvlist(invlist, "\u8ba2\u5355\u672a\u53d1\u8d27/\u5df2\u53d6\u6d88");
            return JbsUtils.getErrorMap("\u8ba2\u5355\u672a\u53d1\u8d27/\u5df2\u53d6\u6d88", "03");
        }
        OcRefundReDomain ocRefundReDomain = this.checkOcRefund(invlist.getInvlistOpcode());
        if (!EmptyUtil.isEmpty((Object)ocRefundReDomain)) {
            if ("P01".equals(ocRefundReDomain.getRefundType()) && (8 != ocRefundReDomain.getDataState() || ocRefundReDomain.getDataState() < 0)) {
                this.updateInvlist(invlist, "\u8ba2\u5355\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u9000\u5355(\u7ebf\u4e0b)");
                return JbsUtils.getErrorMap("\u8ba2\u5355\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u9000\u5355(\u7ebf\u4e0b)", "04");
            }
            if (null != ocRefundReDomain && (4 != ocRefundReDomain.getDataState() || ocRefundReDomain.getDataState() < 0)) {
                this.updateInvlist(invlist, "\u8ba2\u5355\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u9000\u5355\uff08\u5c0f\u7a0b\u5e8f\u8ba2\u5355\uff09");
                return JbsUtils.getErrorMap("\u8ba2\u5355\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u9000\u5355\uff08\u5c0f\u7a0b\u5e8f\u8ba2\u5355\uff09", "04");
            }
        }
        String originalInvoiceNo = null;
        InvUserinv invUserinv = this.queryOneInvUser(invlist.getUserinvCode());
        UmUserinfo userinfo = this.queryOneUmUserinfo(invInvlistGoodsList.get(0).getMemberCcode());
        List<UmUser> userslist = this.queryUmUser(userinfo.getUserinfoCode());
        List<InvUserinv> invUser = this.queryInvUser(userslist.get(0).getUserCode());
        InvUserinv invUserinvSeller = invUser.get(0);
        if (EmptyUtil.isEmpty((Object)invUserinvSeller)) {
            this.updateInvlist(invlist, "\u65e0\u9500\u65b9\u4fe1\u606f");
            return JbsUtils.getErrorMap("\u65e0\u9500\u65b9\u4fe1\u606f", "");
        }
        if (StringUtils.isNotBlank((String)invlist.getInvlistBatchcode()) && StringUtils.isNotBlank((String)(invList = this.queryInvlist(invlist.getInvlistBatchcode())).getInvlistOcode())) {
            originalInvoiceNo = invList.getInvlistOcode();
        }
        Integer i = 0;
        BigDecimal sumMoney = new BigDecimal(0);
        ArrayList<Map<String, Object>> invoiceDetailsList = new ArrayList<Map<String, Object>>();
        for (InvInvlistGoods invInvlistGoods : invInvlistGoodsList) {
            HashMap<String, Object> detailsMap = new HashMap<String, Object>();
            i = i + 1;
            detailsMap.put("requestionLineNo", i);
            detailsMap.put("invoiceLineNature", 0);
            detailsMap.put("itemCode", invInvlistGoods.getSkuNo());
            detailsMap.put("goodsQuantity", invInvlistGoods.getGoodsNum());
            detailsMap.put("goodsPrice", invInvlistGoods.getContractGoodsPrice());
            detailsMap.put("goodsTotalPrice", invInvlistGoods.getContractGoodsMoney());
            sumMoney = sumMoney.add(invInvlistGoods.getContractGoodsMoney());
            List<RsResourceGoodsReDomain> resourceGoodsList = this.getResourceGoods(invInvlistGoods.getGoodsCode());
            RsResourceGoodsReDomain rsResourceGoodsReDomain = resourceGoodsList.get(0);
            if (EmptyUtil.isEmpty((Object)rsResourceGoodsReDomain) && StringUtils.isBlank((String)rsResourceGoodsReDomain.getAreaCode())) {
                this.updateInvlist(invlist, "\u67e5\u8be2\u5f00\u7968\u65e0\u5546\u54c1\u4fe1\u606fgoods/\u65e0\u7a0e\u7387");
                return JbsUtils.getErrorMap("\u67e5\u8be2\u5f00\u7968\u65e0\u5546\u54c1\u4fe1\u606fgoods/\u65e0\u7a0e\u7387", invInvlistGoods.getGoodsCode());
            }
            List<InvInvrate> invInvrateList = this.queryRate(rsResourceGoodsReDomain.getAreaCode());
            InvInvrate invInvrate = invInvrateList.get(0);
            if (EmptyUtil.isEmpty((Object)invInvrate) && EmptyUtil.isEmpty((Object)invInvrate.getInvrateRate())) {
                this.updateInvlist(invlist, "\u65e0\u7a0e\u7387\u503c");
                return JbsUtils.getErrorMap("\u65e0\u7a0e\u7387\u503c", "");
            }
            BigDecimal newRate = invInvrate.getInvrateRate().divide(new BigDecimal(100));
            BigDecimal tempRate = new BigDecimal(1).add(newRate);
            BigDecimal amountTax = invInvlistGoods.getContractGoodsMoney().divide(tempRate, 2, 4);
            BigDecimal goodsTotalTax = invInvlistGoods.getContractGoodsMoney().subtract(amountTax.setScale(2, 4));
            detailsMap.put("goodsTotalTax", goodsTotalTax);
            if ("1".equals(invInvlist.getInvlistType())) {
                detailsMap.put("goodsQuantity", invInvlistGoods.getGoodsNum().negate());
                detailsMap.put("goodsPrice", invInvlistGoods.getContractGoodsPrice().negate());
                detailsMap.put("goodsTotalPrice", invInvlistGoods.getContractGoodsMoney().negate());
                detailsMap.put("goodsTotalTax", goodsTotalTax.negate());
            }
            invoiceDetailsList.add(detailsMap);
        }
        String url = "http://172.18.32.187:18000/output/orderimport";
        HttpFormfacade httpFormfacade = new HttpFormfacade(url);
        httpFormfacade.setInsideOrderNo(invInvlist.getInvlistCode());
        JbsSapSendInvoiceResponse execute = null;
        JbsSapSendInvoiceRequest jbsSapSendInvoiceRequest = new JbsSapSendInvoiceRequest();
        ArrayList errorCodes = new ArrayList();
        try {
            BeanUtils.copyAllPropertys((Object)jbsSapSendInvoiceRequest, (Object)invInvlist);
            String invoiceTerminalCode = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2019071800001392-inv-invoiceTerminalCode");
            jbsSapSendInvoiceRequest.setInvoiceTerminalCode(invoiceTerminalCode);
            jbsSapSendInvoiceRequest.setOriginalInvoiceNo(originalInvoiceNo);
            jbsSapSendInvoiceRequest.setInvoiceDetailsList(invoiceDetailsList);
            jbsSapSendInvoiceRequest.setInvoiceTotalPrice(sumMoney);
            jbsSapSendInvoiceRequest.setSellerTaxNo(invUserinvSeller.getUserinvNo());
            jbsSapSendInvoiceRequest.setSellerBankAccount(invUserinvSeller.getUserinvBank() + "-" + invUserinvSeller.getUserinvBankno());
            jbsSapSendInvoiceRequest.setSellerAddressPhone(invUserinvSeller.getUserinvAdd() + "-" + invUserinvSeller.getUserinvUphone());
            jbsSapSendInvoiceRequest.setBuyerTaxNo(invUserinv.getUserinvNo());
            jbsSapSendInvoiceRequest.setBuyerName(invUserinv.getUserinvMember());
            jbsSapSendInvoiceRequest.setBuyerBankAccount(invUserinv.getUserinvBank() + "-" + invUserinv.getUserinvBankno());
            jbsSapSendInvoiceRequest.setBuyerAddressPhone(invUserinv.getUserinvAdd() + "-" + invUserinv.getUserinvUphone());
            this.logger.error(this.SYS_CODE, (Object)("\u53d1\u7968\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570>>>>" + JsonUtil.buildNormalBinder().toJson(jbsSapSendInvoiceRequest.getTextParams())));
            execute = httpFormfacade.execute(jbsSapSendInvoiceRequest);
            if (!execute.isSuccess()) {
                return JbsUtils.getSuccessMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u7b49\u5f85\u5f02\u6b65");
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)"\u53d1\u7968\u63a5\u53e3>>>>", (Throwable)e);
            this.updateInvlist(invlist, "\u63a8\u9001\u53d1\u7968\u63a5\u53e3\u5931\u8d25");
            return JbsUtils.getErrorMap("\u53d1\u7968\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson(execute));
        }
        this.logger.error(this.SYS_CODE, (Object)("\u53d1\u7968\u63a5\u53e3\u54cd\u5e94\u53c2\u6570>>>>" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String receiveInvoice(String dataStr) throws Exception {
        this.logger.error(this.SYS_CODE + ".receiveInvoice.dataStr->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)dataStr));
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(this.SYS_CODE + ".receiveInvoice.dataStr->", (Object)"\u4e3a\u7a7a");
            return JbsUtils.getErrorMap("\u63a5\u6536\u56de\u5199\u53d1\u7968\u63a5\u53e3\u5931\u8d25", dataStr);
        }
        JSONObject object = JSONObject.json2object((String)dataStr);
        String msg = this.checkInvinvlist(object);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error(this.SYS_CODE + ".receiveInvoice.object->", (Object)JsonUtil.buildNormalBinder().toJson((Object)object));
            return JbsUtils.getErrorMap(msg, dataStr);
        }
        InvInvlist invlist = this.queryInvlist(object.getString("invlistCode"));
        if (StringUtils.isBlank((String)invlist.getInvlistOpcode())) {
            this.logger.error(this.SYS_CODE + ".receiveInvoice.invlist.invlistOpcode->", (Object)"\u4e3a\u7a7a");
            return JbsUtils.getErrorMap("\u67e5\u8be2\u53d1\u7968\u6570\u636e\u7684invlistOpcode\u4e3a\u7a7a", dataStr);
        }
        if ("2".equals(object.getString("dataState"))) {
            invlist.setInvlistOcode(object.getString("invlistOcode"));
            invlist.setInvlistOcode1(object.getString("invlistOcode1"));
            invlist.setInvlistOcode2(object.getString("invlistOcode2"));
            invlist.setInvlistOurl(object.getString("invlistOurl"));
            invlist.setDataState(1);
        } else if ("0".equals(object.getString("dataState"))) {
            invlist.setDataState(3);
        }
        this.logger.error(this.SYS_CODE + ".receiveInvoice.update->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invlist));
        try {
            this.updateInvlist(invlist, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u4fee\u6539\u53d1\u7968\u5931\u8d25", "");
        }
        try {
            this.updateContractInvstate(invlist.getInvlistOpcode(), object.getString("dataState"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u4fee\u6539\u8ba2\u5355\u53d1\u7968\u5931\u8d25", "");
        }
        return JbsUtils.getSuccessMap("");
    }

    public void updateContractInvstate(String invlistOpcode, String dataState) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", invlistOpcode);
        map.put("dataState", dataState);
        map.put("oldDataState", null);
        map.put("tenantCode", "2019071800001392");
        this.getInternalRouter().inInvoke("oc.contract.updateContractInvstate", map);
    }

    public void updateInvlist(InvInvlist invlist, String memo) throws Exception {
        InvInvlistDomain invInvlistDomain = new InvInvlistDomain();
        HashMap<String, String> invlistMap = new HashMap<String, String>();
        if (EmptyUtil.isEmpty((Object)invlist)) {
            this.logger.error(this.SYS_CODE + ".updateInvlist.invlist \u4e3a\u7a7a");
        }
        BeanUtils.copyAllPropertys((Object)invInvlistDomain, (Object)invlist);
        invInvlistDomain.setMemo(memo);
        invlistMap.put("invInvlistDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)invInvlistDomain));
        this.getInternalRouter().inInvoke("inv.invlist.updateInvlist", invlistMap);
    }

    public String checkInvinvlist(JSONObject object) {
        String msg = "";
        if (StringUtils.isBlank((String)object.getString("invlistCode"))) {
            msg = msg + "invlistCode\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("invlistOcode"))) {
            msg = msg + "invlistOcode\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("invlistOcode1"))) {
            msg = msg + "invlistOcode1\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("invlistOcode2"))) {
            msg = msg + "invlistOcode2\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("dataState"))) {
            msg = msg + "dataState\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("invlistOurl"))) {
            msg = msg + "invlistOurl\u4e3a\u7a7a";
        }
        return msg;
    }

    public InvInvlist queryInvlist(String invlistBatchcode) throws Exception {
        HashMap<String, String> invlistMap = new HashMap<String, String>();
        invlistMap.put("tenantCode", "2019071800001392");
        invlistMap.put("invlistCode", invlistBatchcode);
        String invListStr = (String)this.getInternalRouter().inInvoke("inv.invlist.getInvlistByCode", invlistMap);
        InvInvlist invInvlist = (InvInvlist)JsonUtil.buildNonNullBinder().getJsonToObject(invListStr, InvInvlist.class);
        if (invInvlist == null) {
            this.logger.error(this.SYS_CODE + ".checkInvUser.queryInvlist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(invlistMap));
            throw new Exception("invInvlist\u4e3a\u7a7a\uff01");
        }
        this.logger.error(this.SYS_CODE + ".queryInvlist->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invInvlist));
        return invInvlist;
    }

    public List<InvInvrate> queryRate(String areaCode) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> rateMap = new HashMap<String, String>();
        rateMap.put("invrateOpcode", areaCode);
        rateMap.put("invrateOptype", "areaCode");
        rateMap.put("tenantCode", "2019071800001392");
        map.put("map", JsonUtil.buildNormalBinder().toJson(rateMap));
        QueryResult invInvrateResult = this.sendReSupObject("inv.invset.queryInvratePage", map, InvInvrate.class);
        List invInvrateList = invInvrateResult.getList();
        if (ListUtil.isEmpty((Collection)invInvrateList)) {
            this.logger.error(this.SYS_CODE + ".queryRate.invlist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invInvrateList));
            throw new Exception("invInvrateList\u4e3a\u7a7a\uff01");
        }
        this.logger.error(this.SYS_CODE + ".queryRate->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invInvrateList));
        return invInvrateList;
    }

    public List<RsResourceGoodsReDomain> getResourceGoods(String goodsCode) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> goodsMap = new HashMap<String, String>();
        goodsMap.put("goodsCode", goodsCode);
        goodsMap.put("tenantCode", "2019071800001392");
        map.put("map", JsonUtil.buildNonNullBinder().toJson(goodsMap));
        QueryResult resourceGoodsResult = this.sendReSupObject("rs.resourceGoods.queryResourceGoodsPage", map, RsResourceGoodsReDomain.class);
        List resourceGoodslist = resourceGoodsResult.getList();
        if (ListUtil.isEmpty((Collection)resourceGoodslist)) {
            this.logger.error(this.SYS_CODE + ".getResourceGoods.invlist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsMap));
            throw new Exception("resourceGoodslist\u4e3a\u7a7a\uff01");
        }
        this.logger.error(this.SYS_CODE + ".getResourceGoods->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)resourceGoodslist));
        return resourceGoodslist;
    }

    public List<InvUserinv> queryInvUser(String userCode) throws Exception {
        HashMap<String, String> invMap = new HashMap<String, String>();
        HashMap<String, String> invMapStr = new HashMap<String, String>();
        invMapStr.put("userCode", userCode);
        invMapStr.put("tenantCode", "2019071800001392");
        invMap.put("map", JsonUtil.buildNormalBinder().toJson(invMapStr));
        QueryResult invQueryResult = this.sendReSupObject("inv.userinv.queryUserinvPage", invMap, InvUserinv.class);
        List invlist = invQueryResult.getList();
        if (ListUtil.isEmpty((Collection)invlist)) {
            this.logger.error(this.SYS_CODE + ".queryInvUser.invlist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(invMapStr));
            throw new Exception("invlist\u4e3a\u7a7a\uff01");
        }
        this.logger.error(this.SYS_CODE + ".queryInvUser->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invlist));
        return invlist;
    }

    public List<UmUser> queryUmUser(String userinfoCode) throws Exception {
        HashMap<String, String> userMap = new HashMap<String, String>();
        HashMap<String, String> userMapStr = new HashMap<String, String>();
        userMapStr.put("userPcode", userinfoCode);
        userMapStr.put("tenantCode", "2019071800001392");
        userMap.put("map", JsonUtil.buildNormalBinder().toJson(userMapStr));
        QueryResult umQueryResult = this.sendReSupObject("um.user.queryUserPage", userMap, UmUser.class);
        List userslist = umQueryResult.getList();
        if (ListUtil.isEmpty((Collection)userslist)) {
            this.logger.error(this.SYS_CODE + ".queryUmUser.userslist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(userMapStr));
            throw new Exception("userslist\u4e3a\u7a7a\uff01");
        }
        return userslist;
    }

    public UmUserinfo queryOneUmUserinfo(String userinfoCode) throws Exception {
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        userInfoMap.put("userinfoCode", userinfoCode);
        userInfoMap.put("tenantCode", "2019071800001392");
        String userInfoStr = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoByUserCode", userInfoMap);
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNonNullBinder().getJsonToObject(userInfoStr, UmUserinfo.class);
        if (umUserinfo == null) {
            this.logger.error(this.SYS_CODE + ".queryOneUmUserinfo.umUserinfo.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(userInfoMap));
            throw new Exception("umUserinfo\u4e3a\u7a7a\uff01");
        }
        return umUserinfo;
    }

    public InvUserinv queryOneInvUser(String userinvCode) throws Exception {
        HashMap<String, String> userinvMap = new HashMap<String, String>();
        userinvMap.put("tenantCode", "2019071800001392");
        userinvMap.put("userinvCode", userinvCode);
        String userinvStr = (String)this.getInternalRouter().inInvoke("inv.userinv.getUserinvByCode", userinvMap);
        InvUserinv invUserinv = (InvUserinv)JsonUtil.buildNonNullBinder().getJsonToObject(userinvStr, InvUserinv.class);
        if (invUserinv == null) {
            this.logger.error(this.SYS_CODE + ".queryOneInvUser.invUserinv.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(userinvMap));
            throw new Exception("invUserinv\u4e3a\u7a7a\uff01");
        }
        this.logger.error(this.SYS_CODE + ".queryOneInvUser->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invUserinv));
        return invUserinv;
    }

    public OcRefundReDomain checkOcRefund(String contractBillcode) {
        HashMap<String, String> parameter = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", "2019071800001392");
        parameter.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String json = (String)this.getInternalRouter().inInvoke("oc.refund.getRefundByCode", parameter);
        OcRefundReDomain ocRefundReDomain = (OcRefundReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcRefundReDomain.class);
        this.logger.error(this.SYS_CODE + ".checkOcRefund.ocRefundReDomain.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        return ocRefundReDomain;
    }

    public OcContractReDomain checkOcContract(String contractBillcode) {
        HashMap<String, String> parameter = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", "2019071800001392");
        parameter.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String json = (String)this.getInternalRouter().inInvoke("oc.contract.getContractByCode", parameter);
        OcContractReDomain ocContractReDomain = (OcContractReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcContractReDomain.class);
        this.logger.error(this.SYS_CODE + ".checkOcContract.ocContractReDomain.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        return ocContractReDomain;
    }

    public List<InvInvlistGoods> queryInvlistGoodsPage(String tenantCode, String invlistCode) throws Exception {
        HashMap<String, String> parameter = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("invlistCode", invlistCode);
        map.put("tenantCode", tenantCode);
        parameter.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult invQueryResult = this.sendReSupObject("inv.invlistGoods.queryInvlistGoodsPage", parameter, InvInvlistGoods.class);
        List invlist = invQueryResult.getList();
        if (ListUtil.isEmpty((Collection)invlist)) {
            this.logger.error(this.SYS_CODE + ".queryInvlistGoodsPage.invlist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            throw new Exception("invlist\u4e3a\u7a7a\uff01");
        }
        this.logger.error(this.SYS_CODE + ".queryInvlistGoodsPage->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invlist));
        return invlist;
    }
}

