/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.sap.domian.DaCashSumListReDomain;
import com.yqbsoft.laser.service.sap.domian.DaSalesRateSumListReDomain;
import com.yqbsoft.laser.service.sap.domian.DaSalesSumListReDomain;
import com.yqbsoft.laser.service.sap.domian.DaSalesSumReDomain;
import com.yqbsoft.laser.service.sap.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapSalesSumContractRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapSendContractRequest;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapOrderResponse;
import com.yqbsoft.laser.service.sap.service.ContractService;
import com.yqbsoft.laser.service.sap.utils.JbsUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContractServiceImpl
extends BaseServiceImpl
implements ContractService {
    private String SYS_CODE = "jbsSap.ContractServiceImpl";

    @Override
    public Map<String, Object> sendContract(Map<String, Object> map) throws IOException {
        this.logger.error(this.SYS_CODE + ".sendContract", (Object)"\u63a5\u6536\u6570\u636e\u5f00\u59cb\n");
        if (MapUtil.isEmpty(map)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return (Map)JsonUtil.buildNormalBinder().getJsonToMap(JbsUtils.getErrorMap("param is null", ""), String.class, Object.class);
        }
        DaSalesSumReDomain daSalesSumReDomain = (DaSalesSumReDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(map.get("salesSumReDomain")), DaSalesSumReDomain.class);
        this.logger.info(this.SYS_CODE + ".sendContract", (Object)("\u63a5\u6536\u6570\u636eid\n" + daSalesSumReDomain.getSalesSumCode()));
        this.logger.info(this.SYS_CODE + ".sendContract", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)daSalesSumReDomain)));
        HttpFormfacade httpFormfacade = new HttpFormfacade();
        JbsSapOrderResponse execute = null;
        JbsSapSalesSumContractRequest jbsSapSalesSumContractRequest = new JbsSapSalesSumContractRequest();
        try {
            String msg = this.checkSendContract(daSalesSumReDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                this.logger.error(this.SYS_CODE + ".sendContract.checkSendContract", (Object)JsonUtil.buildNormalBinder().toJson((Object)msg));
                return (Map)JsonUtil.buildNormalBinder().getJsonToMap(JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)daSalesSumReDomain)), String.class, Object.class);
            }
            jbsSapSalesSumContractRequest.setApiMethod("oa_mpf_if_otc_001");
            BeanUtils.copyAllPropertys((Object)jbsSapSalesSumContractRequest, (Object)daSalesSumReDomain);
            execute = httpFormfacade.execute(jbsSapSalesSumContractRequest);
            this.logger.info(this.SYS_CODE + ".sendContract.execute", (Object)JsonUtil.buildNormalBinder().toJson((Object)execute));
            if (null == execute || !execute.getSuccess().booleanValue()) {
                return (Map)JsonUtil.buildNormalBinder().getJsonToMap(JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute)), String.class, Object.class);
            }
            return (Map)JsonUtil.buildNormalBinder().getJsonToMap(JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute)), String.class, Object.class);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "sendContract Exception", (Object)e.toString(), (Throwable)e);
            return (Map)JsonUtil.buildNormalBinder().getJsonToMap(JbsUtils.getErrorMap("sendContract Exception", e.getMessage()), String.class, Object.class);
        }
    }

    @Override
    public Map<String, Object> sendContractPayment(Map<String, Object> map) throws IOException {
        if (null == map || null == map.get("salesSumReDomain")) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return (Map)JsonUtil.buildNormalBinder().getJsonToMap(JbsUtils.getErrorMap("param is null", ""), String.class, Object.class);
        }
        DaSalesSumReDomain daSalesSumReDomain = (DaSalesSumReDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(map.get("salesSumReDomain")), DaSalesSumReDomain.class);
        this.logger.error(this.SYS_CODE + ".sendContractPayment.data", (Object)("\u63a5\u6536\u6570\u636eid\n" + daSalesSumReDomain.getSalesSumCode()));
        String paramJson = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2019071800001392-jbs_sap-jbs_sap");
        JSONObject jsonObject = JSONObject.json2object((String)paramJson);
        HttpFormfacade httpFormfacade = new HttpFormfacade();
        JbsSapOrderResponse execute = null;
        JbsSapSendContractRequest jbsSapContractRequest = new JbsSapSendContractRequest();
        try {
            String msg = this.checkContractPayment(daSalesSumReDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                this.logger.error(this.SYS_CODE + ".sendContractPayment.checkContractPayment", (Object)msg);
                return (Map)JsonUtil.buildNormalBinder().getJsonToMap(JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)daSalesSumReDomain)), String.class, Object.class);
            }
            jbsSapContractRequest.setApiMethod("oa_mpf_if_otc_002");
            BeanUtils.copyAllPropertys((Object)jbsSapContractRequest, (Object)daSalesSumReDomain);
            execute = httpFormfacade.execute(jbsSapContractRequest);
            this.logger.info(this.SYS_CODE + ".sendContractPayment.execute", (Object)JsonUtil.buildNormalBinder().toJson((Object)execute));
            if (null == execute || !execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE + ".sendContractPayment.error", (Object)JsonUtil.buildNormalBinder().toJson((Object)execute));
                return (Map)JsonUtil.buildNormalBinder().getJsonToMap(JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute)), String.class, Object.class);
            }
            return (Map)JsonUtil.buildNormalBinder().getJsonToMap(JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute)), String.class, Object.class);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendContractPayment.e", (Object)JsonUtil.buildNormalBinder().toJson((Object)e.getMessage()));
            return (Map)JsonUtil.buildNormalBinder().getJsonToMap(JbsUtils.getErrorMap("sendContractPayment Exception", e.getMessage()), String.class, Object.class);
        }
    }

    @Override
    public String sendContractBatch(List<DaSalesSumReDomain> daSalesSumReDomains) throws IOException {
        if (ListUtil.isEmpty(daSalesSumReDomains)) {
            return JbsUtils.getErrorMap("params is null", "");
        }
        this.logger.info(this.SYS_CODE + ".sendContractBatch.params", (Object)JsonUtil.buildNormalBinder().toJson(daSalesSumReDomains));
        try {
            ArrayList<String> errorStr = new ArrayList<String>();
            ArrayList<String> successStr = new ArrayList<String>();
            HashMap<String, Object> sendMap = new HashMap<String, Object>();
            for (DaSalesSumReDomain daSalesSumReDomain : daSalesSumReDomains) {
                sendMap.put("salesSumReDomain", daSalesSumReDomain);
                Map<String, Object> returnMap = this.sendContract(sendMap);
                this.logger.error(this.SYS_CODE + ".sendContractBatch.sendContract", (Object)JsonUtil.buildNormalBinder().toJson(returnMap));
                if (MapUtil.isNotEmpty(returnMap)) {
                    if (!Boolean.valueOf(returnMap.get("success") + "").booleanValue()) {
                        errorStr.add(daSalesSumReDomain.getSalesSumCode() + "\uff1a" + returnMap.get("msg"));
                        continue;
                    }
                    successStr.add(daSalesSumReDomain.getSalesSumCode());
                    continue;
                }
                errorStr.add(daSalesSumReDomain.getSalesSumCode() + "\uff1areturn is null");
            }
            if (ListUtil.isNotEmpty(successStr)) {
                this.logger.error(this.SYS_CODE + ".sendContractBatch.successStr", (Object)JsonUtil.buildNormalBinder().toJson(successStr));
                for (String code : successStr) {
                    HashMap<String, Object> updMap = new HashMap<String, Object>();
                    HashMap<String, String> sendUpMap = new HashMap<String, String>();
                    updMap.put("salesSumCode", code);
                    updMap.put("dataState", 1);
                    sendUpMap.put("map", JsonUtil.buildNormalBinder().toJson(updMap));
                    try {
                        this.internalInvoke("da.daSalesSum.updateDataState", sendUpMap);
                    }
                    catch (Exception e) {
                        throw new ApiException(this.SYS_CODE + ".updateStatesalesSumModelByCode.ex", (Throwable)e);
                    }
                }
            }
            this.logger.error(this.SYS_CODE + ".sendContractBatch.errorStr", (Object)JsonUtil.buildNormalBinder().toJson(errorStr));
            if (ListUtil.isNotEmpty(errorStr)) {
                throw new ApiException("\u90e8\u5206\u63a8\u9001\u5931\u8d25\uff1a" + JsonUtil.buildNormalBinder().toJson(errorStr));
            }
            return JbsUtils.getSuccessMap("");
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendContractBatch.Exception", (Object)e.toString(), (Throwable)e);
            return JbsUtils.getErrorMap("\u6279\u91cf\u63a8\u9001\u63a5\u53e3\u5f02\u5e38", "");
        }
    }

    @Override
    public String sendContractPaymentBatch(List<DaSalesSumReDomain> daSalesSumReDomains) throws IOException {
        if (ListUtil.isEmpty(daSalesSumReDomains)) {
            this.logger.info(this.SYS_CODE + ".sendContractPaymentBatch.checkParams", (Object)"params is null");
            return JbsUtils.getErrorMap("params is null", "");
        }
        this.logger.info(this.SYS_CODE + ".sendContractPaymentBatch.params", (Object)JsonUtil.buildNormalBinder().toJson(daSalesSumReDomains));
        ArrayList<String> successStr = new ArrayList<String>();
        try {
            ArrayList<String> errorStr = new ArrayList<String>();
            HashMap<String, Object> sendMap = new HashMap<String, Object>();
            for (DaSalesSumReDomain daSalesSumReDomain : daSalesSumReDomains) {
                sendMap.put("salesSumReDomain", daSalesSumReDomain);
                Map<String, Object> returnMap = this.sendContractPayment(sendMap);
                this.logger.error(this.SYS_CODE + ".sendContractPaymentBatch.sendContract", (Object)JsonUtil.buildNormalBinder().toJson(returnMap));
                if (MapUtil.isNotEmpty(returnMap)) {
                    if (!Boolean.valueOf(returnMap.get("success") + "").booleanValue()) {
                        errorStr.add(daSalesSumReDomain.getSalesSumCode() + "\uff1a" + returnMap.get("msg"));
                        continue;
                    }
                    successStr.add(daSalesSumReDomain.getSalesSumCode());
                    continue;
                }
                errorStr.add(daSalesSumReDomain.getSalesSumCode() + "\uff1areturn is null");
            }
            if (ListUtil.isNotEmpty(successStr)) {
                this.logger.error(this.SYS_CODE + ".sendContractBatch.successStr", (Object)JsonUtil.buildNormalBinder().toJson(successStr));
                for (String code : successStr) {
                    HashMap<String, Object> updMap = new HashMap<String, Object>();
                    HashMap<String, String> sendUpMap = new HashMap<String, String>();
                    updMap.put("salesSumCode", code);
                    updMap.put("dataState", 1);
                    sendUpMap.put("map", JsonUtil.buildNormalBinder().toJson(updMap));
                    try {
                        this.internalInvoke("da.daSalesSum.updateDataState", sendUpMap);
                    }
                    catch (Exception e) {
                        throw new ApiException(this.SYS_CODE + ".updateStatesalesSumModelByCode.ex", (Throwable)e);
                    }
                }
            }
            this.logger.error(this.SYS_CODE + ".sendContractBatch.errorStr", (Object)JsonUtil.buildNormalBinder().toJson(errorStr));
            if (ListUtil.isNotEmpty(errorStr)) {
                throw new ApiException("\u90e8\u5206\u63a8\u9001\u5931\u8d25\uff1a" + JsonUtil.buildNormalBinder().toJson(errorStr));
            }
            return JbsUtils.getSuccessMap("");
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendContractPaymentBatch.Exception", (Object)e.toString(), (Throwable)e);
            return JbsUtils.getErrorMap("\u6279\u91cf\u63a8\u9001\u63a5\u53e3\u5f02\u5e38", "");
        }
    }

    private String checkContractPayment(DaSalesSumReDomain daSalesSumReDomain) {
        List<DaCashSumListReDomain> daCashSumListReDomainList;
        String msg = "";
        if (StringUtils.isBlank((String)daSalesSumReDomain.getSalesSumCode())) {
            msg = msg + "SalesSumCode\u4e3a\u7a7a";
        }
        if (EmptyUtil.isEmpty((Object)daSalesSumReDomain.getTransactionDate())) {
            msg = msg + "TransactionDate\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)daSalesSumReDomain.getMemberCode())) {
            msg = msg + "MemberCode\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((Integer)daSalesSumReDomain.getDataType()) || 3 == daSalesSumReDomain.getDataType() && 4 == daSalesSumReDomain.getDataType()) {
            msg = msg + "DataType\u4e3a\u7a7a && \u7c7b\u578b\u4e0d\u5bf9";
        }
        if (EmptyUtil.isEmpty((Object)daSalesSumReDomain.getTransactionStartDate())) {
            msg = msg + "TransactionStartDate\u4e3a\u7a7a";
        }
        if (EmptyUtil.isEmpty((Object)daSalesSumReDomain.getTransactionEndDate())) {
            msg = msg + "TransactionEndDate\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(daCashSumListReDomainList = daSalesSumReDomain.getDaCashSumListReDomainList())) {
            msg = msg + "DaCashSumListReDomainList\u4e3a\u7a7a";
        }
        for (DaCashSumListReDomain daCashSumListReDomain : daCashSumListReDomainList) {
            if (StringUtils.isBlank((String)daCashSumListReDomain.getAmountSign())) {
                msg = msg + "AmountSign\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daCashSumListReDomain.getTransactionCode())) {
                msg = msg + "TransactionCode\u4e3a\u7a7a";
            }
            if (EmptyUtil.isEmpty((Object)daCashSumListReDomain.getTransactionAmount())) {
                msg = msg + "TransactionAmount\u4e3a\u7a7a";
            }
            if (!StringUtils.isBlank((String)daCashSumListReDomain.getTransactionCurrency())) continue;
            msg = msg + "TransactionCurrency\u4e3a\u7a7a";
        }
        return msg;
    }

    private String checkSendContract(DaSalesSumReDomain daSalesSumReDomain) {
        List<DaSalesSumListReDomain> sumListReDomainList;
        String msg = "";
        if (StringUtils.isBlank((String)daSalesSumReDomain.getSalesSumCode())) {
            msg = msg + "SalesSumCode\u4e3a\u7a7a";
        }
        if (EmptyUtil.isEmpty((Object)daSalesSumReDomain.getTransactionDate())) {
            msg = msg + "TransactionDate\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)daSalesSumReDomain.getMemberCode())) {
            msg = msg + "MemberCode\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((Integer)daSalesSumReDomain.getDataType()) || daSalesSumReDomain.getDataType().equals(1) && daSalesSumReDomain.getDataType().equals(2)) {
            msg = msg + "DataType\u4e3a\u7a7a && \u7c7b\u578b\u4e0d\u5bf9";
        }
        if (EmptyUtil.isEmpty((Object)daSalesSumReDomain.getTransactionStartDate())) {
            msg = msg + "TransactionStartDate\u4e3a\u7a7a";
        }
        if (EmptyUtil.isEmpty((Object)daSalesSumReDomain.getTransactionEndDate())) {
            msg = msg + "TransactionEndDate\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(sumListReDomainList = daSalesSumReDomain.getDaSalesSumListReDomainList())) {
            msg = msg + "DaSalesSumListReDomainList\u4e3a\u7a7a";
        }
        for (DaSalesSumListReDomain daSalesSumListReDomain : sumListReDomainList) {
            List<DaSalesRateSumListReDomain> daSalesRateSumListReDomainList;
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getMatnr())) {
                msg = msg + "Matnr\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getIssWerks())) {
                msg = msg + "IssWerks\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getCntSign())) {
                msg = msg + "CntSign\u4e3a\u7a7a";
            }
            if (EmptyUtil.isEmpty((Object)daSalesSumListReDomain.getCnt())) {
                msg = msg + "Cnt\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getOriginalCostSign())) {
                msg = msg + "OriginalCostSign\u4e3a\u7a7a";
            }
            if (EmptyUtil.isEmpty((Object)daSalesSumListReDomain.getOriginalCost())) {
                msg = msg + "OriginalCost\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getTaxAmtType())) {
                msg = msg + "TaxAmtType\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)daSalesSumListReDomain.getTaxAmtSign())) {
                msg = msg + "TaxAmtSign\u4e3a\u7a7a";
            }
            if (EmptyUtil.isEmpty((Object)daSalesSumListReDomain.getTaxAmt())) {
                msg = msg + "TaxAmt\u4e3a\u7a7a";
            }
            if (ListUtil.isEmpty(daSalesRateSumListReDomainList = daSalesSumListReDomain.getDaSalesRateSumListReDomainList())) continue;
            for (DaSalesRateSumListReDomain daSalesRateSumListReDomain : daSalesRateSumListReDomainList) {
                if (StringUtils.isBlank((String)daSalesRateSumListReDomain.getDiscType())) {
                    msg = msg + "DiscType\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((String)daSalesRateSumListReDomain.getDiscAmtSign())) {
                    msg = msg + "DiscAmtSign\u4e3a\u7a7a";
                }
                if (EmptyUtil.isEmpty((Object)daSalesRateSumListReDomain.getDiscAmt())) {
                    msg = msg + "DiscAmt\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((String)daSalesRateSumListReDomain.getDiscTaxType())) {
                    msg = msg + "DiscTaxType\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((String)daSalesRateSumListReDomain.getDiscTaxSign())) {
                    msg = msg + "DiscTaxSign\u4e3a\u7a7a";
                }
                if (!EmptyUtil.isEmpty((Object)daSalesRateSumListReDomain.getDiscTax())) continue;
                msg = msg + "DiscTax\u4e3a\u7a7a";
            }
        }
        return msg;
    }
}

