/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.sap.domian.DaStoreErpDomain;
import com.yqbsoft.laser.service.sap.domian.GoodsBean;
import com.yqbsoft.laser.service.sap.domian.RsResourceGoods;
import com.yqbsoft.laser.service.sap.domian.RsSku;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreDomain;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreGoodsReDomain;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreSkuReDomain;
import com.yqbsoft.laser.service.sap.domian.WhWarehouseReDomain;
import com.yqbsoft.laser.service.sap.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapExWhConfirmRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapInWhConfirmRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapMaterialMovePostingRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapQueryWhRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapSTORequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSendPurchaseRequest;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapInExWhConfirmResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapMaterialMovePostingResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapQueryWhResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapSTOResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSendPurchaseResponse;
import com.yqbsoft.laser.service.sap.model.HtmlJsonReBean;
import com.yqbsoft.laser.service.sap.model.WhOpstoreGoods;
import com.yqbsoft.laser.service.sap.model.WhOpstoreSku;
import com.yqbsoft.laser.service.sap.model.WhWarehouse;
import com.yqbsoft.laser.service.sap.service.JbsSapWarehouseService;
import com.yqbsoft.laser.service.sap.utils.JbsUtils;
import com.yqbsoft.laser.service.sap.utils.ParamsUtils;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class JbsSapWarehouseServiceImpl
extends BaseServiceImpl
implements JbsSapWarehouseService {
    public static final String SYS_CODE = "jbsSap.JbsSapWarehouseServiceImpl";

    @Override
    public String sendSTOBill(WhOpstoreDomain whOpstoreDomain) throws Exception {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.sendSTOBill.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            JbsSapSTORequest jbsSapSTORequest = new JbsSapSTORequest();
            jbsSapSTORequest.setApiMethod("os_mpf_if_sc_006");
            BeanUtils.copyAllPropertys((Object)jbsSapSTORequest, (Object)whOpstoreDomain);
            JbsSapSTOResponse execute = httpFormfacade.execute(jbsSapSTORequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            this.updateWhOutSiteNumber(execute, whOpstoreDomain);
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.STO\u521b\u5efa\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return JbsUtils.getErrorMap(".STO\u521b\u5efa\u63a5\u53e3\u5f02\u5e38", whOpstoreDomain.getOpstoreCode());
        }
    }

    private void updateWhOutSiteNumber(JbsSapSTOResponse execute, WhOpstoreDomain whOpstoreDomain) {
        try {
            if (!EmptyUtil.isEmpty((Object)execute) && ListUtil.isNotEmpty(execute.getStoDataList()) && !EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
                List<Map<String, String>> stoDataList = execute.getStoDataList();
                HashMap<String, String> stoDataMap = new HashMap<String, String>();
                for (Map<String, String> map : stoDataList) {
                    stoDataMap.put(map.get("skuNo"), map.get("stoNumber"));
                }
                this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.updateWhOutSiteNumber.whOpstoreDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                HashMap<String, List<WhOpstoreSkuReDomain>> skuReMap = new HashMap<String, List<WhOpstoreSkuReDomain>>();
                HashMap<String, List<WhOpstoreSkuDomain>> skuMap = new HashMap<String, List<WhOpstoreSkuDomain>>();
                if (ListUtil.isNotEmpty(whOpstoreDomain.getWhOpstoreGoodsReDomainList())) {
                    this.handleReSku(whOpstoreDomain.getWhOpstoreGoodsReDomainList(), skuReMap, stoDataMap);
                } else if (ListUtil.isNotEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
                    this.handleSku(whOpstoreDomain.getWhOpstoreGoodsDomainList(), skuMap, stoDataMap);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.STOCreate.updateWhOutSiteNumber Exception", (Object)e.toString(), (Throwable)e);
            throw new ApiException("\u56de\u5199STO\u5355\u53f7\u5f02\u5e38" + whOpstoreDomain.getOpstoreCode());
        }
    }

    private void handleReSku(List<WhOpstoreGoodsReDomain> whOpstoreGoodsReDomainList, Map<String, List<WhOpstoreSkuReDomain>> skuReMap, Map<String, String> stoMap) {
        if (ListUtil.isNotEmpty(whOpstoreGoodsReDomainList) && MapUtil.isNotEmpty(stoMap) && null != skuReMap) {
            for (WhOpstoreGoodsReDomain whOpstoreGoodsReDomain : whOpstoreGoodsReDomainList) {
                List<WhOpstoreSkuReDomain> whOpstoreSkuReDomainList = whOpstoreGoodsReDomain.getWhOpstoreSkuReDomainList();
                if (!ListUtil.isNotEmpty(whOpstoreSkuReDomainList)) continue;
                for (WhOpstoreSkuReDomain whOpstoreSkuReDomain : whOpstoreSkuReDomainList) {
                    String mapKey = whOpstoreSkuReDomain.getSkuNo();
                    List<WhOpstoreSkuReDomain> whOpstoreSkuReDomains = skuReMap.get(mapKey);
                    if (ListUtil.isEmpty(whOpstoreSkuReDomains)) {
                        whOpstoreSkuReDomains = new ArrayList<WhOpstoreSkuReDomain>();
                    }
                    whOpstoreSkuReDomains.add(whOpstoreSkuReDomain);
                    skuReMap.put(mapKey, whOpstoreSkuReDomains);
                }
            }
            this.handleUpdate(stoMap, skuReMap, null);
        }
    }

    private void handleSku(List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList, Map<String, List<WhOpstoreSkuDomain>> skuMap, Map<String, String> stoMap) {
        if (ListUtil.isNotEmpty(whOpstoreGoodsDomainList) && null != skuMap && MapUtil.isNotEmpty(stoMap)) {
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                if (!ListUtil.isNotEmpty(whOpstoreSkuDomainList)) continue;
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                    String mapKey = whOpstoreSkuDomain.getSkuNo();
                    List<WhOpstoreSkuDomain> whOpstoreSkuDomains = skuMap.get(mapKey);
                    if (ListUtil.isEmpty(whOpstoreSkuDomains)) {
                        whOpstoreSkuDomains = new ArrayList<WhOpstoreSkuDomain>();
                    }
                    whOpstoreSkuDomains.add(whOpstoreSkuDomain);
                    skuMap.put(mapKey, whOpstoreSkuDomains);
                }
            }
            this.handleUpdate(stoMap, null, skuMap);
        }
    }

    private void handleUpdate(Map<String, String> stoMap, Map<String, List<WhOpstoreSkuReDomain>> skuReMap, Map<String, List<WhOpstoreSkuDomain>> skuMap) {
        List<WhOpstoreSkuDomain> skuDomainList;
        String stoNum;
        if (MapUtil.isEmpty(stoMap) || MapUtil.isEmpty(skuReMap) && MapUtil.isEmpty(skuMap)) {
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.handleUpdate.param.null1", (Object)JsonUtil.buildNormalBinder().toJson(stoMap));
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.handleUpdate.param.null2", (Object)JsonUtil.buildNormalBinder().toJson(skuReMap));
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.handleUpdate.param.null3", (Object)JsonUtil.buildNormalBinder().toJson(skuMap));
            throw new ApiException("jbsSap.JbsSapWarehouseServiceImpl.handleUpdate.null");
        }
        ArrayList<WhOpstoreSkuDomain> skuDataList = new ArrayList<WhOpstoreSkuDomain>();
        Set<String> stoSet = stoMap.keySet();
        if (MapUtil.isNotEmpty(skuMap)) {
            for (String stoKey : stoSet) {
                if (!skuMap.containsKey(stoKey)) continue;
                stoNum = stoMap.get(stoKey);
                skuDomainList = skuMap.get(stoKey);
                if (!ListUtil.isNotEmpty(skuDomainList)) continue;
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : skuDomainList) {
                    whOpstoreSkuDomain.setOperatorCode(stoNum);
                    skuDataList.add(whOpstoreSkuDomain);
                }
            }
        } else if (MapUtil.isNotEmpty(skuReMap)) {
            for (String stoKey : stoSet) {
                if (!skuReMap.containsKey(stoKey)) continue;
                stoNum = stoMap.get(stoKey);
                skuDomainList = skuReMap.get(stoKey);
                if (!ListUtil.isNotEmpty(skuDomainList)) continue;
                for (WhOpstoreSkuReDomain whOpstoreSkuReDomain : skuDomainList) {
                    whOpstoreSkuReDomain.setOperatorCode(stoNum);
                    skuDataList.add(whOpstoreSkuReDomain);
                }
            }
        }
        this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.handleUpdate.stoMap", (Object)JsonUtil.buildNormalBinder().toJson(stoMap));
        this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.handleUpdate.skuMap", (Object)JsonUtil.buildNormalBinder().toJson(skuMap));
        this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.handleUpdate.skuReMap", (Object)JsonUtil.buildNormalBinder().toJson(skuReMap));
        this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.handleUpdate.skuDataList", (Object)JsonUtil.buildNormalBinder().toJson(skuDataList));
        if (ListUtil.isNotEmpty(skuDataList)) {
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : skuDataList) {
                HashMap<String, String> sendMap = new HashMap<String, String>();
                sendMap.put("whOpstoreSkuDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreSkuDomain));
                this.internalInvoke("wh.WhOpstore.updateOpStoreSkuDomainByCode", sendMap);
            }
        }
    }

    @Override
    public String sendPurchaseRequest(WhOpstoreDomain whOpstoreDomain) throws Exception {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            JbsSendPurchaseRequest jbsSendPurchaseRequest = new JbsSendPurchaseRequest();
            jbsSendPurchaseRequest.setApiMethod("os_mpf_if_sc_010");
            BeanUtils.copyAllPropertys((Object)jbsSendPurchaseRequest, (Object)whOpstoreDomain);
            JbsSendPurchaseResponse execute = httpFormfacade.execute(jbsSendPurchaseRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.\u521b\u5efa\u91c7\u8d2d\u7533\u8bf7\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return JbsUtils.getErrorMap(".\u521b\u5efa\u91c7\u8d2d\u7533\u8bf7\u63a5\u53e3\u5f02\u5e38", whOpstoreDomain.getOpstoreCode());
        }
    }

    @Override
    public HtmlJsonReBean receiveInDeliveryBill(String dataStr) throws Exception {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"dataStr is null");
            throw new Exception("param is null");
        }
        this.logger.info(SYS_CODE, (Object)("jbsSap.receiveInDeliveryBill.param" + dataStr));
        JSONObject object = JSONObject.json2object((String)dataStr);
        if (EmptyUtil.isEmpty((Object)object) || StringUtils.isBlank((String)object.getString("data")) || EmptyUtil.isEmpty(((HashMap)object.get((Object)"data")).get("list"))) {
            this.logger.error(SYS_CODE, (Object)("data\u53c2\u6570\u4e3a\u7a7a" + dataStr));
            throw new Exception("data\u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        WhOpstoreDomain whOpstoreDomain = null;
        try {
            Map dataMap = (Map)((HashMap)object.get((Object)"data")).get("list");
            whOpstoreDomain = ParamsUtils.JbsSapMap2opDomain(dataMap);
            if (null == whOpstoreDomain) {
                this.logger.error(SYS_CODE, (Object)("data \u8f6c\u6362\u5bf9\u8c61\u5931\u8d25>>>>" + JsonUtil.buildNormalBinder().toJson((Object)dataMap)));
                errorCodes.add("data \u8f6c\u6362\u5bf9\u8c61\u5931\u8d25");
                throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorCodes);
            }
            if ("D5".equals(whOpstoreDomain.getStoreGoodsBtype())) {
                this.queryReturnOrderInfo(whOpstoreDomain);
                if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreNcode())) {
                    throw new ApiException(whOpstoreDomain.getOpstoreCode() + ":\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53cd\u914d\u7533\u8bf7\u5355");
                }
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            Map checkResultMap = this.checkExist(whOpstoreDomain);
            Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
            WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
            this.checkGoodsClass(currentObj);
            if (StringUtils.isBlank((String)currentObj.getWarehouseName())) {
                this.HandleWarehouseName(currentObj);
            }
            sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
            this.logger.info(SYS_CODE, (Object)(checkFlag + "=" + JsonUtil.buildNormalBinder().toJson(sendMap)));
            if (checkFlag.booleanValue()) {
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendUpdateOpstore", sendMap);
            } else {
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"SAP\u63a5\u6536\u5185\u5411\u4ea4\u8d27\u5355\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "SAP\u63a5\u6536\u5185\u5411\u4ea4\u8d27\u5355\u63a5\u53e3\u5f02\u5e38");
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            this.logger.error(SYS_CODE, (Object)("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff1a" + errorCodes));
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorCodes);
        }
        return new HtmlJsonReBean();
    }

    @Override
    public String InDeliveryConfirmBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.InDeliveryConfirmBill.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            httpFormfacade.setOutsideOrderNo(whOpstoreDomain.getOpstoreOcode());
            JbsSapInExWhConfirmResponse execute = null;
            JbsSapInWhConfirmRequest jbsSapInWhConfirmRequest = new JbsSapInWhConfirmRequest();
            jbsSapInWhConfirmRequest.setApiMethod("oa_mpf_if_sc_002");
            BeanUtils.copyAllPropertys((Object)jbsSapInWhConfirmRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapInWhConfirmRequest);
            if (!execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"SAP\u5185\u5411\u4ea4\u8d27\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38>>>>", (Throwable)e);
            return JbsUtils.getErrorMap("SAP\u5185\u5411\u4ea4\u8d27\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        }
    }

    @Override
    public HtmlJsonReBean receiveExDeliveryBill(String dataStr) throws Exception {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"dataStr is null");
            throw new Exception("param is null");
        }
        this.logger.info(SYS_CODE, (Object)("jbsSap.receiveExDeliveryBill.param" + dataStr));
        JSONObject object = JSONObject.json2object((String)dataStr);
        if (EmptyUtil.isEmpty((Object)object) || StringUtils.isBlank((String)object.getString("data")) || EmptyUtil.isEmpty(((HashMap)object.get((Object)"data")).get("list"))) {
            this.logger.error(SYS_CODE, (Object)("data\u53c2\u6570\u4e3a\u7a7a" + dataStr));
            throw new Exception("data\u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        WhOpstoreDomain whOpstoreDomain = null;
        try {
            Map dataMap = (Map)((HashMap)object.get((Object)"data")).get("list");
            whOpstoreDomain = ParamsUtils.JbsSapMap2opDomain(dataMap);
            if (null == whOpstoreDomain) {
                this.logger.error(SYS_CODE, (Object)("data \u8f6c\u6362\u5bf9\u8c61\u5931\u8d25>>>>" + JsonUtil.buildNormalBinder().toJson((Object)dataMap)));
                errorCodes.add("data \u8f6c\u6362\u5bf9\u8c61\u5931\u8d25");
                throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorCodes);
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            Map checkResultMap = this.checkExist(whOpstoreDomain);
            Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
            WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
            this.checkGoodsClass(currentObj);
            if (StringUtils.isBlank((String)currentObj.getWarehouseName())) {
                this.HandleWarehouseName(currentObj);
            }
            sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
            this.logger.info(SYS_CODE, (Object)(checkFlag + "=" + JsonUtil.buildNormalBinder().toJson(sendMap)));
            if (checkFlag.booleanValue()) {
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendUpdateOpstore", sendMap);
            } else {
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"SAP\u63a5\u6536\u5916\u5411\u4ea4\u8d27\u5355\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "SAP\u63a5\u6536\u5916\u5411\u4ea4\u8d27\u5355\u63a5\u53e3\u5f02\u5e38");
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            this.logger.error(SYS_CODE, (Object)("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff1a" + errorCodes));
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorCodes);
        }
        return new HtmlJsonReBean();
    }

    @Override
    public String ExDeliveryConfirmBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.ExDeliveryConfirmBill.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            httpFormfacade.setOutsideOrderNo(whOpstoreDomain.getOpstoreOcode());
            JbsSapInExWhConfirmResponse execute = null;
            JbsSapExWhConfirmRequest jbsSapExWhConfirmRequest = new JbsSapExWhConfirmRequest();
            jbsSapExWhConfirmRequest.setApiMethod("oa_mpf_if_sc_004");
            BeanUtils.copyAllPropertys((Object)jbsSapExWhConfirmRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapExWhConfirmRequest);
            if (!execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"\u63a8\u9001SAP\u5916\u5411\u4ea4\u8d27\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38>>", (Throwable)e);
            return JbsUtils.getErrorMap("\u63a8\u9001SAP\u5916\u5411\u4ea4\u8d27\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain.getOpstoreCode()));
        }
    }

    @Override
    public String queryInventoryInfo(Map<String, Object> paramsMap, String tenantCode, String warehouseCode) throws ApiException {
        if (StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        if (null == paramsMap) {
            paramsMap = new HashMap<String, Object>();
        }
        ArrayList<String> whList = new ArrayList<String>();
        if (StringUtils.isBlank((String)warehouseCode)) {
            String[] whMap = new HashMap();
            HashMap<String, String> map = new HashMap<String, String>();
            whMap.put("tenantCode", "2019071800001392");
            map.put("map", JsonUtil.buildNormalBinder().toJson((Object)whMap));
            QueryResult qwh = this.getQueryResutl("wh.warehouse.queryWarehousePage", map, WhWarehouseReDomain.class);
            if (null == qwh || ListUtil.isEmpty((Collection)qwh.getList())) {
                throw new ApiException("\u65e0\u4ed3\u5e93\u5217\u8868");
            }
            for (WhWarehouseReDomain whWarehouseReDomain : qwh.getList()) {
                whList.add(StringUtils.isNotBlank((String)whWarehouseReDomain.getWarehouseOcode()) ? whWarehouseReDomain.getWarehouseOcode() : whWarehouseReDomain.getWarehouseCode());
            }
        } else if (warehouseCode.contains(",")) {
            for (String code : warehouseCode.split(",")) {
                whList.add(code);
            }
        } else {
            whList.add(warehouseCode);
        }
        String batch = EmptyUtil.isEmpty((Object)paramsMap.get("batchNum")) ? DateUtil.getDateString((Date)new Date(), (String)"yyyyMMdd") : paramsMap.get("batchNum") + "";
        paramsMap.put("batchNum", paramsMap.get("batchNum") + "");
        try {
            for (String whCode : whList) {
                HashMap<String, String> sendMap = new HashMap<String, String>();
                sendMap.put("warehouseCode", whCode);
                sendMap.put("storeErpTime", batch);
                sendMap.put("tenantCode", tenantCode);
                this.getInternalRouter().inInvoke("da.dastoreerp.deleteStoreBatch", sendMap);
                if (null == paramsMap) {
                    paramsMap = new HashMap<String, Object>();
                }
                int startRow = 1;
                int rows = 200;
                if (EmptyUtil.isEmpty((Object)paramsMap.get("startRow"))) {
                    paramsMap.put("startRow", startRow);
                }
                if (EmptyUtil.isEmpty((Object)paramsMap.get("rows"))) {
                    paramsMap.put("rows", rows);
                }
                JbsSapQueryWhResponse execute = null;
                try {
                    HttpFormfacade httpFormfacade = new HttpFormfacade();
                    JbsSapQueryWhRequest jbsSapQueryWhRequest = new JbsSapQueryWhRequest();
                    jbsSapQueryWhRequest.setApiMethod("os_mpf_if_sc_008");
                    Map<String, Object> sendParamMap = this.handleQueryParam(paramsMap, whCode);
                    jbsSapQueryWhRequest.setParamMap(sendParamMap);
                    Date starDate = new Date();
                    this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.queryInventoryInfo.send", (Object)JsonUtil.buildNormalBinder().toJson((Object)jbsSapQueryWhRequest));
                    execute = httpFormfacade.execute(jbsSapQueryWhRequest);
                    if (!execute.getSuccess().booleanValue()) {
                        this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.queryInventoryInfo.error", (Object)(JsonUtil.buildNormalBinder().toJson((Object)jbsSapQueryWhRequest) + "=" + execute.getMsg()));
                        this.getInternalRouter().inInvoke("da.dastoreerp.deleteStoreBatch", sendMap);
                        return JbsUtils.getErrorMap("\u8c03\u7528\u5931\u8d25:" + execute.getMsg(), JsonUtil.buildNormalBinder().toJson((Object)execute));
                    }
                    this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.queryInventoryInfo.return", (Object)"");
                    if (ListUtil.isEmpty(execute.getStoreErpDomainList())) {
                        this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.queryInventoryInfo.return.null", (Object)"");
                        continue;
                    }
                    if ("success".equals(this.saveSap(execute.getStoreErpDomainList(), batch, starDate, tenantCode))) continue;
                    this.getInternalRouter().inInvoke("da.dastoreerp.deleteStoreBatch", sendMap);
                    this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.queryInventoryInfo.error", (Object)paramsMap.toString());
                    return JbsUtils.getErrorMap("\u67e5\u8be2SAP\u5e93\u5b58\u4fdd\u5b58\u5931\u8d25", paramsMap.toString());
                }
                catch (Exception e) {
                    this.logger.error(SYS_CODE, (Object)"\u67e5\u8be2SAP\u5e93\u5b58\u8bb0\u5f55\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
                    return JbsUtils.getErrorMap("\u67e5\u8be2SAP\u5e93\u5b58\u8bb0\u5f55\u63a5\u53e3\u5f02\u5e38", paramsMap.toString());
                }
            }
            return JbsUtils.getSuccessMap("");
        }
        catch (Exception e) {
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.queryInventoryInfo.e", (Throwable)e);
            throw new ApiException("\u62c9\u53d6\u6570\u636e\u5931\u8d25" + e.toString());
        }
    }

    private Map<String, Object> handleQueryParam(Map<String, Object> paramsMap, String warehouseCode) {
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        if (MapUtil.isNotEmpty(paramsMap)) {
            if (paramsMap.containsKey("skuNoList") && ListUtil.isNotEmpty((Collection)((List)paramsMap.get("skuNoList")))) {
                List skuNoList = (List)paramsMap.get("skuNoList");
                this.handleSkuParam(sendMap, skuNoList);
            }
            if (paramsMap.containsKey("batchNum")) {
                ArrayList batchNumMapList = new ArrayList();
                HashMap<String, String> batchNumMap = new HashMap<String, String>();
                batchNumMap.put("Low", paramsMap.get("batchNum") + "");
                batchNumMap.put("High", null);
                batchNumMapList.add(batchNumMap);
                sendMap.put("Batch", batchNumMapList);
            }
            if (paramsMap.containsKey("storeWhlocal")) {
                ArrayList storeWhlocalMapList = new ArrayList();
                HashMap<String, String> storeWhlocalMap = new HashMap<String, String>();
                storeWhlocalMap.put("Low", paramsMap.get("storeWhlocal") + "");
                storeWhlocalMap.put("High", null);
                storeWhlocalMapList.add(storeWhlocalMap);
                sendMap.put("Sloc", storeWhlocalMapList);
            }
            if (paramsMap.containsKey("warehouseCode") || StringUtils.isNotBlank((String)warehouseCode)) {
                ArrayList warehouseMapList = new ArrayList();
                HashMap<String, String> warehouseMap = new HashMap<String, String>();
                warehouseMap.put("Low", StringUtils.isNotBlank((String)warehouseCode) ? warehouseCode : paramsMap.get("warehouseCode") + "");
                warehouseMap.put("High", null);
                warehouseMapList.add(warehouseMap);
                sendMap.put("Plant", warehouseMapList);
            }
            if (paramsMap.containsKey("documentNumber") && MapUtil.isNotEmpty((Map)((Map)paramsMap.get("documentNumber")))) {
                Map documentNumberMap = (Map)paramsMap.get("documentNumber");
                this.handleDocumentNumberParam(sendMap, documentNumberMap);
            }
        }
        return sendMap;
    }

    private void handleDocumentNumberParam(Map<String, Object> sendMap, Map<String, Date> documentNumberMap) {
        if (null != sendMap && MapUtil.isNotEmpty(documentNumberMap)) {
            Date endTime;
            ArrayList documentNumberMapList = new ArrayList();
            HashMap<String, String> documentNumberParamMap = new HashMap<String, String>();
            Date startTime = documentNumberMap.get("startTime");
            if (!EmptyUtil.isEmpty((Object)startTime)) {
                String startTimeStr = DateUtil.getDateString((Date)startTime, (String)"yyyyMMddHHmmss");
                documentNumberParamMap.put("from", startTimeStr);
            }
            if (!EmptyUtil.isEmpty((Object)(endTime = documentNumberMap.get("endTime")))) {
                String endTimeStr = DateUtil.getDateString((Date)endTime, (String)"yyyyMMddHHmmss");
                documentNumberParamMap.put("to", endTimeStr);
            }
            documentNumberMapList.add(documentNumberParamMap);
            sendMap.put("Period", documentNumberMapList);
        }
    }

    private void handleSkuParam(Map<String, Object> sendMap, List<String> skuNoList) {
        if (null != sendMap && ListUtil.isNotEmpty(skuNoList)) {
            ArrayList skuMapList = new ArrayList();
            for (String sku : skuNoList) {
                HashMap<String, String> skuMap = new HashMap<String, String>();
                skuMap.put("Low", sku);
                skuMap.put("High", null);
                skuMapList.add(skuMap);
            }
            sendMap.put("Material", skuMapList);
        }
    }

    private String saveSap(List<DaStoreErpDomain> daStoreErpDomainList, String batch, Date starDate, String tenantCode) {
        if (ListUtil.isEmpty(daStoreErpDomainList) || StringUtils.isBlank((String)batch)) {
            return "success";
        }
        ArrayList<DaStoreErpDomain> daStoreErpDomainDbList = new ArrayList<DaStoreErpDomain>();
        for (DaStoreErpDomain daStoreErpDomain : daStoreErpDomainList) {
            String skuNo = daStoreErpDomain.getSkuNo();
            String warehouseCode = daStoreErpDomain.getWarehouseCode();
            WhWarehouseReDomain whWarehouseReDomain = this.queryWh(warehouseCode, tenantCode);
            if (null != whWarehouseReDomain) {
                daStoreErpDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("goodsClass", "plat");
            paramMap.put("skuNo", skuNo);
            paramMap.put("memberCode", "20021000276227");
            paramMap.put("tenantCode", tenantCode);
            String returnJsonStr = this.internalInvoke("rs.resourceGoods.getResourceBySkuNo", paramMap);
            if (StringUtils.isNotBlank((String)returnJsonStr)) {
                GoodsBean goodsBean = (GoodsBean)JsonUtil.buildNormalBinder().getJsonToObject(returnJsonStr, GoodsBean.class);
                daStoreErpDomain.setGoodsCode(goodsBean.getRsSku().getGoodsCode());
                daStoreErpDomain.setSkuCode(goodsBean.getRsSku().getSkuCode());
                daStoreErpDomain.setSkuName(goodsBean.getRsSku().getSkuName());
            }
            daStoreErpDomain.setStoreErpEtime(new Date());
            daStoreErpDomain.setStoreErpStime(starDate);
            daStoreErpDomain.setStoreErpType("sap");
            daStoreErpDomain.setStoreErpTime(batch);
            daStoreErpDomainDbList.add(daStoreErpDomain);
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("daStoreErpDomainList", JsonUtil.buildNormalBinder().toJson(daStoreErpDomainDbList));
        this.getInternalRouter().inInvoke("da.dastoreerp.saveStoreErpBatch", sendMap);
        return "success";
    }

    private WhWarehouseReDomain queryWh(String key, String tenantCode) {
        HashMap<String, String> whMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        whMap.put("warehouseCode", key);
        whMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(whMap));
        QueryResult qwh = this.getQueryResutl("wh.warehouse.queryWarehousePage", map, WhWarehouseReDomain.class);
        if (null != qwh && ListUtil.isNotEmpty((Collection)qwh.getList())) {
            return (WhWarehouseReDomain)qwh.getList().get(0);
        }
        whMap.put("warehouseOcode", key);
        whMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(whMap));
        qwh = this.getQueryResutl("wh.warehouse.queryWarehousePage", map, WhWarehouseReDomain.class);
        if (null != qwh && ListUtil.isNotEmpty((Collection)qwh.getList())) {
            return (WhWarehouseReDomain)qwh.getList().get(0);
        }
        return null;
    }

    @Override
    public String MaterialMovePosting(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.MaterialMovePosting.paramas", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        if ("L0".equals(whOpstoreDomain.getStoreGoodsBtype()) && StringUtils.isBlank((String)whOpstoreDomain.getCompanyCode())) {
            return JbsUtils.getErrorMap("\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a", "");
        }
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            return JbsUtils.getErrorMap("GoodsList\u5546\u54c1\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", "");
        }
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                return JbsUtils.getErrorMap("SkuList\u6279\u6b21\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", "");
            }
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                if (!StringUtils.isBlank((String)whOpstoreSkuDomain.getPntreeCode())) continue;
                return JbsUtils.getErrorMap("SkuList\u6279\u6b21\u5c42\u7ea7\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "");
            }
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            httpFormfacade.setOutsideOrderNo(whOpstoreDomain.getOpstoreOcode());
            JbsSapMaterialMovePostingResponse execute = null;
            JbsSapMaterialMovePostingRequest jbsSapMaterialMovePostingRequest = new JbsSapMaterialMovePostingRequest();
            jbsSapMaterialMovePostingRequest.setApiMethod("os_mpf_if_sc_005");
            BeanUtils.copyAllPropertys((Object)jbsSapMaterialMovePostingRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapMaterialMovePostingRequest);
            if (!execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", execute.getReturnData());
            }
            return JbsUtils.getSuccessMap(execute.getReturnData());
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"SAP\u7269\u6599\u79fb\u52a8\u8fc7\u8d26\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return JbsUtils.getErrorMap("SAP\u7269\u6599\u79fb\u52a8\u8fc7\u8d26\u63a5\u53e3\u5f02\u5e38", "");
        }
    }

    public Map checkExist(WhOpstoreDomain whOpstoreDomain) throws Exception {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        if (null == whOpstoreDomain || StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
            throw new Exception("checkExist.\u4f20\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        try {
            WhOpstoreDomain getDbObj = null;
            queryMap.put("opstoreOcode", whOpstoreDomain.getOpstoreOcode());
            queryMap.put("tenantCode", "2019071800001392");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
            QueryResult queryStoreResult = this.sendReSupObject("wh.WhOpstore.queryOpstorePage", map, WhOpstoreDomain.class);
            if (queryStoreResult != null && ListUtil.isNotEmpty((Collection)queryStoreResult.getList()) && !EmptyUtil.isEmpty(queryStoreResult.getList().get(0))) {
                getDbObj = (WhOpstoreDomain)queryStoreResult.getList().get(0);
                BeanUtils.copyAllPropertysNotNull((Object)getDbObj, (Object)whOpstoreDomain);
                List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
                HashMap<String, WhOpstoreGoodsDomain> receiveGoodsDataMap = new HashMap<String, WhOpstoreGoodsDomain>();
                HashMap<String, WhOpstoreSkuDomain> receiveSkuDataMap = new HashMap<String, WhOpstoreSkuDomain>();
                if (ListUtil.isNotEmpty(whOpstoreGoodsDomainList)) {
                    for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                        List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                        if (ListUtil.isNotEmpty(whOpstoreSkuDomainList)) {
                            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                                receiveSkuDataMap.put(whOpstoreGoodsDomain.getChannelName() + "-" + whOpstoreGoodsDomain.getGoodsProperty2() + "-" + whOpstoreGoodsDomain.getGoodsEocode() + "-" + whOpstoreSkuDomain.getSkuNo(), whOpstoreSkuDomain);
                            }
                        }
                        receiveGoodsDataMap.put(whOpstoreGoodsDomain.getChannelName() + "-" + whOpstoreGoodsDomain.getGoodsProperty2() + "-" + whOpstoreGoodsDomain.getGoodsEocode(), whOpstoreGoodsDomain);
                    }
                }
                queryMap.clear();
                map.clear();
                if (StringUtils.isBlank((String)getDbObj.getOpstoreCode())) {
                    throw new Exception("checkExist\u67e5\u8be2Goods\u5546\u54c1\u7684opstoreCode\u4e3a\u7a7a");
                }
                queryMap.put("tenantCode", "2019071800001392");
                queryMap.put("opstoreCode", getDbObj.getOpstoreCode());
                map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
                this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.checkExist.queryMapGoodsMap", (Object)JsonUtil.buildNormalBinder().toJson(map));
                QueryResult queryDbGoodsResult = this.sendReSupObject("wh.WhOpstore.queryOpstoreGoodsPage", map, WhOpstoreGoods.class);
                this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.checkExist.queryMapGoodsResult", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryDbGoodsResult));
                if (queryDbGoodsResult != null && ListUtil.isNotEmpty((Collection)queryDbGoodsResult.getList())) {
                    ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomains = new ArrayList<WhOpstoreGoodsDomain>();
                    for (WhOpstoreGoods whOpstoreGoods : queryDbGoodsResult.getList()) {
                        WhOpstoreGoodsDomain whOpstoreGoodsDomain = (WhOpstoreGoodsDomain)receiveGoodsDataMap.get(whOpstoreGoods.getChannelName() + "-" + whOpstoreGoods.getGoodsProperty2() + "-" + whOpstoreGoods.getGoodsEocode());
                        if (null == whOpstoreGoodsDomain) continue;
                        BeanUtils.copyAllPropertysNotNull((Object)whOpstoreGoods, (Object)whOpstoreGoodsDomain);
                        WhOpstoreGoodsDomain afterEditGoodsObj = new WhOpstoreGoodsDomain();
                        BeanUtils.copyAllPropertys((Object)afterEditGoodsObj, (Object)whOpstoreGoods);
                        if (StringUtils.isBlank((String)getDbObj.getOpstoreCode())) {
                            throw new Exception("checkExist\u67e5\u8be2Sku\u6279\u6b21\u7684opstoreGoodsCode\u4e3a\u7a7a");
                        }
                        queryMap.clear();
                        map.clear();
                        queryMap.put("tenantCode", "2019071800001392");
                        queryMap.put("opstoreGoodsCode", afterEditGoodsObj.getOpstoreGoodsCode());
                        map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
                        this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.checkExist.queryMapSkuMap", (Object)JsonUtil.buildNormalBinder().toJson(map));
                        QueryResult queryDbSkuResult = this.sendReSupObject("wh.WhOpstore.queryOpstoreSkuPage", map, WhOpstoreSku.class);
                        this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.checkExist.queryMapSkuResult", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryDbSkuResult));
                        if (queryDbSkuResult != null && ListUtil.isNotEmpty((Collection)queryDbSkuResult.getList())) {
                            ArrayList<WhOpstoreSkuDomain> whStoreSkuDomains = new ArrayList<WhOpstoreSkuDomain>();
                            for (WhOpstoreSku whOpstoreSku : queryDbSkuResult.getList()) {
                                WhOpstoreSkuDomain whOpstoreSkuDomain = (WhOpstoreSkuDomain)receiveSkuDataMap.get(whOpstoreGoodsDomain.getChannelName() + "-" + whOpstoreGoodsDomain.getGoodsProperty2() + "-" + whOpstoreGoodsDomain.getGoodsEocode() + "-" + whOpstoreSku.getSkuNo());
                                if (null == whOpstoreSkuDomain) continue;
                                BeanUtils.copyAllPropertysNotNull((Object)whOpstoreSku, (Object)whOpstoreSkuDomain);
                                WhOpstoreSkuDomain afterEditSkuObj = new WhOpstoreSkuDomain();
                                BeanUtils.copyAllPropertys((Object)afterEditSkuObj, (Object)whOpstoreSku);
                                whStoreSkuDomains.add(afterEditSkuObj);
                            }
                            afterEditGoodsObj.setWhOpstoreSkuDomainList(whStoreSkuDomains);
                        }
                        whOpstoreGoodsDomains.add(afterEditGoodsObj);
                    }
                    getDbObj.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomains);
                }
                queryMap.put("checkFlag", "true");
            } else {
                queryMap.put("checkFlag", "false");
            }
            queryMap.put("currentObj", null == getDbObj ? whOpstoreDomain : getDbObj);
            this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.checkExist.FinnalResult", (Object)JsonUtil.buildNormalBinder().toJson(queryMap));
            return queryMap;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"checkExist\u5904\u7406\u6570\u636e\u5f02\u5e38", (Throwable)e);
            throw new Exception("checkExist\u5904\u7406\u6570\u636e\u5f02\u5e38");
        }
    }

    private void HandleWarehouseName(WhOpstoreDomain whOpstoreDomain) {
        if (!EmptyUtil.isEmpty((Object)whOpstoreDomain) && StringUtils.isNotBlank((String)whOpstoreDomain.getWarehouseCode()) && StringUtils.isBlank((String)whOpstoreDomain.getWarehouseName())) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("warehouseOcode", whOpstoreDomain.getWarehouseCode());
            queryMap.put("tenantCode", "2019071800001392");
            HashMap<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
            QueryResult queryResult = this.sendReSupObject("wh.warehouse.queryWarehousePage", sendMap, WhWarehouse.class);
            if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList()) && !EmptyUtil.isEmpty(queryResult.getList().get(0))) {
                whOpstoreDomain.setWarehouseName(((WhWarehouse)queryResult.getList().get(0)).getWarehouseName());
            }
        }
    }

    public void checkGoodsClass(WhOpstoreDomain whOpstoreDomain) throws Exception {
        if (!EmptyUtil.isEmpty((Object)whOpstoreDomain) && ListUtil.isNotEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("goodsClass", "plat");
                paramMap.put("skuNo", whOpstoreGoodsDomain.getGoodsNo());
                paramMap.put("memberCode", whOpstoreDomain.getMemberCode());
                paramMap.put("tenantCode", "2019071800001392");
                String returnJsonStr = this.internalInvoke("rs.resourceGoods.getResourceBySkuNo", paramMap);
                this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.checkGoodsClass", (Object)("internalInvoke\u8fd4\u56de\n" + returnJsonStr));
                if (StringUtils.isNotBlank((String)returnJsonStr)) {
                    GoodsBean goodsBean = (GoodsBean)JsonUtil.buildNormalBinder().getJsonToObject(returnJsonStr, GoodsBean.class);
                    this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.checkGoodsClass", (Object)("GoodsBeanJSON\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)goodsBean)));
                    if (null == goodsBean || null == goodsBean.getRsResourceGoods() || null == goodsBean.getRsSku()) continue;
                    RsResourceGoods rsResourceGoods = goodsBean.getRsResourceGoods();
                    whOpstoreGoodsDomain.setClasstreeCode(rsResourceGoods.getClasstreeCode());
                    whOpstoreGoodsDomain.setClasstreeName(rsResourceGoods.getClasstreeName());
                    whOpstoreGoodsDomain.setGoodsSpec5(rsResourceGoods.getGoodsProperty2());
                    List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                    BigDecimal sumNum = BigDecimal.ZERO;
                    BigDecimal sumWeight = BigDecimal.ZERO;
                    if (!ListUtil.isNotEmpty(whOpstoreSkuDomainList)) continue;
                    for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                        whOpstoreSkuDomain.setClasstreeCode(goodsBean.getRsSku().getClasstreeCode());
                        whOpstoreSkuDomain.setClasstreeName(goodsBean.getRsSku().getClasstreeName());
                    }
                    continue;
                }
                throw new ApiException(whOpstoreGoodsDomain.getGoodsNo() + ":\u8be5\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
        }
    }

    private void calculateNumOrWeight(RsSku rsSku, WhOpstoreSkuDomain whOpstoreSkuDomain) {
        Optional.ofNullable(rsSku).map(RsSku::getSkuName).map(name -> {
            if (name.contains("-")) {
                return name.split("-")[0];
            }
            return name;
        }).map(str -> new BigDecimal((String)str)).map(divide -> {
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.calculateNumOrWeight", (Object)(" divide: " + divide));
            BigDecimal goodsNum = whOpstoreSkuDomain.getGoodsNum();
            BigDecimal goodsWeight = whOpstoreSkuDomain.getGoodsWeight();
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.calculateNumOrWeight", (Object)(" goodsNum: " + goodsNum + "goodsWeight: " + goodsWeight));
            if (goodsNum == null && goodsWeight != null) {
                goodsNum = goodsWeight.divide((BigDecimal)divide, 4, RoundingMode.HALF_UP);
                this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.calculateNumOrWeight", (Object)(" goodsNum: " + goodsNum));
                whOpstoreSkuDomain.setGoodsNum(goodsNum);
                whOpstoreSkuDomain.setPartsnameNumunit(rsSku.getPartsnameNumunit());
            }
            if (goodsWeight == null && goodsNum != null) {
                goodsWeight = goodsNum.multiply((BigDecimal)divide);
                this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.calculateNumOrWeight", (Object)(" goodsWeight: " + goodsWeight));
                whOpstoreSkuDomain.setGoodsWeight(goodsWeight);
                whOpstoreSkuDomain.setPartsnameWeightunit(rsSku.getPartsnameWeightunit());
            }
            return whOpstoreSkuDomain;
        }).orElseThrow(() -> new ApiException());
    }

    private void queryReturnOrderInfo(WhOpstoreDomain whOpstoreDomain) {
        if (!EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            String stoNumber = "";
            if (ListUtil.isNotEmpty(whOpstoreGoodsDomainList)) {
                WhOpstoreGoodsDomain whOpstoreGoodsDomain = whOpstoreGoodsDomainList.get(0);
                stoNumber = whOpstoreGoodsDomain.getGoodsProperty3();
            }
            if (StringUtils.isNotBlank((String)stoNumber)) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("operatorCode", stoNumber);
                paramMap.put("tenantCode", "2019071800001392");
                HashMap<String, String> sendMap = new HashMap<String, String>();
                sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
                QueryResult queryResutl = this.getQueryResutl("wh.WhOpstore.queryOpstoreSkuPage", sendMap, WhOpstoreSkuDomain.class);
                this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.queryReturnOrderInfo.queryResutl", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryResutl));
                if (null != queryResutl && ListUtil.isNotEmpty((Collection)queryResutl.getList())) {
                    String opstoreOldcode;
                    WhOpstoreSkuDomain whOpstoreSkuDomain = (WhOpstoreSkuDomain)queryResutl.getList().get(0);
                    String opstoreCode = whOpstoreSkuDomain.getOpstoreCode();
                    HashMap<String, String> paramOpMap = new HashMap<String, String>();
                    paramOpMap.put("opstoreCode", opstoreCode);
                    paramOpMap.put("tenantCode", "2019071800001392");
                    HashMap<String, String> sendOpMap = new HashMap<String, String>();
                    sendOpMap.put("map", JsonUtil.buildNormalBinder().toJson(paramOpMap));
                    QueryResult queryOpResutl = this.getQueryResutl("wh.WhOpstore.queryOpstorePage", sendOpMap, WhOpstoreDomain.class);
                    this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.queryReturnOrderInfo.queryOpResutl", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryOpResutl));
                    if (null != queryOpResutl && ListUtil.isNotEmpty((Collection)queryOpResutl.getList()) && StringUtils.isNotBlank((String)(opstoreOldcode = ((WhOpstoreDomain)queryOpResutl.getList().get(0)).getOpstoreOldcode()))) {
                        paramOpMap.put("opstoreCode", opstoreOldcode);
                        paramOpMap.put("tenantCode", "2019071800001392");
                        sendOpMap.put("map", JsonUtil.buildNormalBinder().toJson(paramOpMap));
                        QueryResult queryReturnResutl = this.getQueryResutl("wh.WhOpstore.queryOpstorePage", sendOpMap, WhOpstoreDomain.class);
                        this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.queryReturnOrderInfo.queryReturnResutl", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryReturnResutl));
                        if (null != queryReturnResutl && ListUtil.isNotEmpty((Collection)queryReturnResutl.getList())) {
                            String str = "";
                            for (WhOpstoreDomain opstoreDomain : queryReturnResutl.getList()) {
                                str = str + opstoreDomain.getOpstoreOcode() + ",";
                            }
                            whOpstoreDomain.setOpstoreNcode(str.substring(0, str.length() - 1));
                        }
                    }
                }
            }
        }
    }
}

