/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.wms.utils;

import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.wms.JbsWmsServerConstants;
import com.yqbsoft.laser.service.wms.utils.supportUtils.SpiUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class JbsUtils {
    public static String checkParam(Object obj) {
        if (null == obj || String.valueOf(obj).toLowerCase().equals("null")) {
            return "";
        }
        return String.valueOf(obj);
    }

    public static String getMap(String sysRecode, String errorCode, String msg, String dataObj, boolean flag) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysRecode", sysRecode + "");
        map.put("errorCode", errorCode + "");
        map.put("msg", msg + "");
        map.put("dataObj", dataObj + "");
        map.put("success", flag);
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    public static String getSuccessMap(String dataObj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysRecode", "success");
        map.put("errorCode", "");
        map.put("msg", "\u64cd\u4f5c\u6210\u529f");
        map.put("dataObj", dataObj + "");
        map.put("success", true);
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    public static String getErrorMap(String msg, String dataObj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysRecode", "error");
        map.put("errorCode", "-1");
        map.put("msg", msg + "");
        map.put("dataObj", dataObj + "");
        map.put("success", false);
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    public static String getPosSuccessMap(Object successData) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", true);
        map.put("msg", "\u64cd\u4f5c\u6210\u529f");
        map.put("returnData", successData);
        map.put("returnData2", "");
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    public static String getPosErrorMap(String errorMsg, Object successData, Object errorData) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", false);
        map.put("msg", errorMsg + "");
        map.put("returnData", successData);
        map.put("returnData2", errorData);
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    public static String getSHA256String(String str) {
        String encodeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodeStr = JbsUtils.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodeStr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

    public static String sortMapToStr(Map<String, String> map) {
        String result = "";
        try {
            ArrayList<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(map.entrySet());
            Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : infoIds) {
                if (entry.getKey() == null && entry.getKey() == "" || ((String)entry.getKey()).equals("sign")) continue;
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (val == "" || val == null) continue;
                sb.append(key + val);
            }
            result = sb.toString();
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    public static Map<String, Object> postForEntity(String url, String requestBody, Map<String, String> apiHeader) throws IOException {
        RestTemplate client = JbsUtils.getRestTemplate();
        client.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        HttpHeaders headers = JbsUtils.getHttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (MapUtil.isNotEmpty(apiHeader)) {
            for (String headerKey : apiHeader.keySet()) {
                headers.add(headerKey, apiHeader.get(headerKey));
            }
        }
        LinkedMultiValueMap postParameters = new LinkedMultiValueMap();
        postParameters.add((Object)"reqJson", (Object)requestBody);
        HttpEntity requestEntity = new HttpEntity((Object)postParameters, (MultiValueMap)headers);
        System.out.println(url);
        System.out.println(requestBody);
        Map response = (Map)client.postForEntity(url, (Object)requestEntity, Map.class, new Object[0]).getBody();
        return response;
    }

    public static RestTemplate getRestTemplate() {
        return new RestTemplate();
    }

    public static HttpHeaders getHttpHeaders() {
        return new HttpHeaders();
    }

    public static String getSign(String paramUrl, String body) {
        if (StringUtils.isBlank((String)paramUrl) || StringUtils.isBlank((String)body)) {
            return "";
        }
        try {
            Map<String, String> queryMap = SpiUtils.getQueryMap(paramUrl, "UTF-8");
            String sign = SpiUtils.sign(queryMap, body, JbsWmsServerConstants.WMS_APPSECRET, "UTF-8");
            if (StringUtils.isBlank((String)sign)) {
                return "";
            }
            return sign;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

