/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdoms.order.service;

import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.domain.ECLP.EclpOpenService.response.queryOrder.QueryOrderExtResult;
import com.jd.open.api.sdk.domain.ECLP.EclpOpenService.response.queryStock.WarehouseStockResponse;
import com.jd.open.api.sdk.request.ECLP.EclpOrderAddOrderRequest;
import com.jd.open.api.sdk.request.ECLP.EclpOrderExtQueryOrderRequest;
import com.jd.open.api.sdk.request.ECLP.EclpStockQueryStockRequest;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.response.ECLP.EclpOrderAddOrderResponse;
import com.jd.open.api.sdk.response.ECLP.EclpStockQueryStockResponse;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.discom.api.DisRefundService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcContract;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.WhGoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOrderBaseService;
import com.yqbsoft.laser.service.ext.channel.jdoms.JdJosConstants;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DisOrderServiceImpl
extends DisOrderBaseService {
    private String SYS_CODE = "jdoms.DisOrderServiceImpl";
    DisRefundService disRefundService;
    static final String PROVINCE_ADD_API_CODE = "bs.province.saveProvince";
    static final String AREA_ADD_API_CODE = "bs.area.saveAreaList";
    static final String ROAD_ADD_API_CODE = "bs.road.saveRoadBatch";

    public void setDisRefundService(DisRefundService disRefundService) {
        this.disRefundService = disRefundService;
    }

    protected String getChannelCode() {
        return JdJosConstants.channelCode;
    }

    public Map<String, Object> buildComOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".buildComOrderParam", (Object)("====" + channelApiCode + "===" + sendParam.toString() + "====" + configMap.toString() + "====" + param.toString()));
            return null;
        }
        sendParam.put("serverUrl", configMap.get("ophost"));
        sendParam.put("accessToken", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCcode()));
        sendParam.put("appKey", configMap.get("key"));
        sendParam.put("appSecret", configMap.get("secret"));
        if ("cmc.disOrder.saveOcContract".equals(channelApiCode)) {
            sendParam.put("ocContractReDomain", param.get("ocContractReDomain"));
            sendParam.put("memberCode", param.get("memberCode"));
            sendParam.put("tenantCode", param.get("tenantCode"));
        } else if ("cmc.disOrder.saveOcContractState".equals(channelApiCode)) {
            sendParam.put("ocContractReDomain", param.get("ocContractReDomain"));
            sendParam.put("memberCode", param.get("memberCode"));
            sendParam.put("tenantCode", param.get("tenantCode"));
        }
        return sendParam;
    }

    public Object sendComOrder(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String shopNo = configMap.get("shopNo");
        String userinvCode = configMap.get("userinvCode");
        String deptNo = configMap.get("deptNo");
        String supplierNo = configMap.get("supplierNo");
        String serverUrl = configMap.get("ophost");
        String accessToken = this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCcode());
        String appKey = configMap.get("key");
        String appSecret = configMap.get("secret");
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        if ("cmc.disOrder.saveOcContract".equalsIgnoreCase(channelApiCode)) {
            return "SUCCESS";
        }
        if (!"cmc.disOrder.saveOcContractState".equalsIgnoreCase(channelApiCode)) {
            if ("cmc.disOrder.sendQuerySendgoodsLog".equals(channelApiCode)) {
                return "SUCCESS";
            }
            if ("cmc.disOrder.getFreight".equals(channelApiCode)) {
                List whGoodsBeanList = (List)param.get("whGoodsBeanList");
                String string = (String)param.get("areaStr");
            } else {
                if ("cmc.disOrder.getBalance".equals(channelApiCode)) {
                    return null;
                }
                if ("cmc.disOrder.saveSendGoods".equalsIgnoreCase(channelApiCode)) {
                    SgSendgoodsReDomain sgSendgoodsReDomain = (SgSendgoodsReDomain)param.get("sgSendgoodsReDomain");
                    EclpOrderAddOrderRequest queryOrderOpenResp = this.submitJdVopOrder((JdClient)client, configMap, sgSendgoodsReDomain, disChannel, userinvCode);
                    EclpOrderAddOrderResponse response = null;
                    try {
                        response = (EclpOrderAddOrderResponse)client.execute((JdRequest)queryOrderOpenResp);
                        if (EmptyUtil.isEmpty((Object)response) || StringUtils.isBlank((String)response.getEclpSoNo())) {
                            this.logger.error(this.SYS_CODE + ".submitJdVopOrder.request", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryOrderOpenResp));
                            return "error";
                        }
                        SgSendgoodsDomain sgSendgoodsDomain = new SgSendgoodsDomain();
                        sgSendgoodsDomain.setSendgoodsId(sgSendgoodsReDomain.getSendgoodsId());
                        sgSendgoodsDomain.setSendgoodsCode(sgSendgoodsReDomain.getSendgoodsCode());
                        sgSendgoodsDomain.setContractBillcode(sgSendgoodsReDomain.getContractBillcode());
                        sgSendgoodsDomain.setTenantCode(sgSendgoodsReDomain.getTenantCode());
                        sgSendgoodsDomain.setContractObillcode(response.getEclpSoNo());
                        this.updateSendgoodsNo(sgSendgoodsDomain);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return "success";
                }
                if ("cmc.disOrder.getBalanceDetail".equals(channelApiCode)) {
                    return null;
                }
                if ("cmc.disOrder.getNewStockById".equals(channelApiCode)) {
                    List whGoodsBeanList = (List)param.get("whGoodsBeanList");
                    return this.getJdVopStock((JdClient)client, whGoodsBeanList, deptNo);
                }
                if ("cmc.disOrder.queryOrder".equals(channelApiCode)) {
                    return new QueryResult();
                }
                if ("cmc.disOrder.getOrderDetail".equals(channelApiCode)) {
                    return null;
                }
                if ("cmc.disOrder.getSimilarSkuList".equals(channelApiCode)) {
                    String skuId = (String)param.get("skuId");
                    String result = this.getSimilarSkuList((JdClient)client, Long.valueOf(skuId));
                    if (StringUtils.isBlank((String)result)) {
                        return "ERROR";
                    }
                    return result;
                }
                if (!"cmc.disOrder.orderCancelJdMessage".equals(channelApiCode) && !"cmc.disOrder.orderRejectionJdMessage".equals(channelApiCode) && !"cmc.disOrder.jdVopMessageVop".equals(channelApiCode) && "cmc.disOrder.saveSendDeliverGoodsState".equals(channelApiCode)) {
                    EclpOrderExtQueryOrderRequest queryOrderRequest = new EclpOrderExtQueryOrderRequest();
                    Object response = null;
                    try {
                        client.execute((JdRequest)queryOrderRequest);
                        if (EmptyUtil.isEmpty(response) || ListUtil.isNotEmpty((Collection)response.getQueryorderResult())) {
                            this.logger.error(this.SYS_CODE + ".queryOrderOpenResp.request", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryOrderRequest));
                            return "ERROR";
                        }
                        this.logger.error(this.SYS_CODE + ".queryOrderOpenResp.response", (Object)JsonUtil.buildNormalBinder().toJson(response));
                        List eclpSoNoList = response.getQueryorderResult().stream().filter(e -> null != e.getEclpSoNo()).map(QueryOrderExtResult::getEclpSoNo).collect(Collectors.toList());
                        if (ListUtil.isNotEmpty(eclpSoNoList)) {
                            HashMap<String, String> paramMap = new HashMap<String, String>();
                            paramMap.put("contractNbillcode", String.join((CharSequence)",", eclpSoNoList));
                            QueryResult queryResu = this.getQueryResutl("oc.contract.queryContractPage", paramMap, OcContract.class);
                            this.logger.error(this.SYS_CODE + ".queryOrderOpenResp.queryResu", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryResu));
                            if (null != queryResu && ListUtil.isNotEmpty((Collection)queryResu.getList())) {
                                for (OcContract ocContract : queryResu.getList()) {
                                    HashMap<String, String> packageExpressDomain = new HashMap<String, String>();
                                    packageExpressDomain.put("contractBillcode", ocContract.getContractBillcode());
                                    packageExpressDomain.put("channelCode", disChannel.getChannelCode());
                                    packageExpressDomain.put("tenantCode", disChannel.getTenantCode());
                                    HashMap<String, String> invokeMap = new HashMap<String, String>();
                                    invokeMap.put("packageExpressDomain", JsonUtil.buildNormalBinder().toJson(packageExpressDomain));
                                    String string = (String)this.getInternalRouter().inInvoke("oc.contract.updatePackageExpress", "1.0", "0", invokeMap);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return "SUCCESS";
                }
            }
        }
        return "SUCCESS";
    }

    private void updateSendgoodsNo(SgSendgoodsDomain sgSendgoodsDomain) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        this.logger.debug(this.SYS_CODE + ".updateSgSendgoodsMsg.params", (Object)JsonUtil.buildNormalBinder().toJson(params));
        this.getInternalRouter().inInvoke("sg.sendgoods.updateSendgoods", params);
    }

    private EclpOrderAddOrderRequest submitJdVopOrder(JdClient client, Map<String, String> configMap, SgSendgoodsReDomain sgSendgoodsReDomain, DisChannel disChannel, String userinvCode) {
        if (null == sgSendgoodsReDomain || ListUtil.isEmpty((Collection)sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList())) {
            this.logger.error(this.SYS_CODE + ".sendSendgoodsJdOms.submitJdVopOrder.error", (Object)JsonUtil.buildNormalBinder().toJson(configMap));
            return null;
        }
        List sgSendgoodsGoodsDomainList = sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList();
        SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain = (SgSendgoodsGoodsDomain)sgSendgoodsGoodsDomainList.get(0);
        EclpOrderAddOrderRequest request = new EclpOrderAddOrderRequest();
        request.setIsvUUID(sgSendgoodsReDomain.getSendgoodsCode());
        request.setIsvSource("ISV0020008043546");
        request.setShopNo("ESP0020008224959");
        request.setDepartmentNo("EBU4418054948746");
        request.setWarehouseNo("110017684");
        request.setSalesPlatformOrderNo(sgSendgoodsReDomain.getContractBillcode());
        request.setSalePlatformSource("6");
        request.setSalesPlatformCreateTime(sgSendgoodsReDomain.getGmtCreate());
        request.setConsigneeName(sgSendgoodsReDomain.getGoodsReceiptMem());
        request.setConsigneeMobile(sgSendgoodsReDomain.getGoodsReceiptPhone());
        request.setConsigneePhone(sgSendgoodsReDomain.getGoodsReceiptPhone());
        request.setConsigneeAddress(sgSendgoodsReDomain.getGoodsReceiptArrdess());
        request.setConsigneeRemark(sgSendgoodsReDomain.getSendgoodsRemark());
        request.setOrderMark("00002122401000000000110000000200004000200000002000");
        request.setQuantity("1");
        request.setIsvGoodsNo(sgSendgoodsGoodsDomain.getGoodsNo());
        return request;
    }

    private String getId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private List<WhGoodsBean> getJdVopStock(JdClient client, List<WhGoodsBean> whGoodsBeanList, String deptNo) {
        EclpStockQueryStockRequest request = new EclpStockQueryStockRequest();
        for (WhGoodsBean whGoodsBean : whGoodsBeanList) {
            this.logger.info(this.SYS_CODE + ".getJdVopStock", (Object)JsonUtil.buildNormalBinder().toJson((Object)this.getId()));
            request.setDeptNo(deptNo);
            request.setIsvSku(whGoodsBean.getSkuEocode());
            request.setWarehouseNo(whGoodsBean.getWarhouseCode());
            EclpStockQueryStockResponse response = null;
            try {
                response = (EclpStockQueryStockResponse)client.execute((JdRequest)request);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!response.getCode().equals("0")) {
                this.logger.info(this.SYS_CODE + ".getJdVopStock", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
                continue;
            }
            int[] totalNum = ((WarehouseStockResponse)response.getQuerystockResult().get(0)).getTotalNum();
            int goodsNum = totalNum[0];
            whGoodsBean.setGoodsNum(Integer.valueOf(goodsNum));
            whGoodsBean.setFlag(true);
        }
        return whGoodsBeanList;
    }

    public static void main(String[] args) {
        DefaultJdClient client = new DefaultJdClient("https://api.jd.com/routerjson", "c1ef91987bb94a128620674dc1a74937yzfl", "88A78D96C3D85D22CCF4BC55B34E5EB7", "3aebc5a245db49e89117395ab65e839f");
        EclpStockQueryStockRequest request = new EclpStockQueryStockRequest();
        request.setDeptNo("EBU4418054948746");
        request.setIsvSku("CESHI001");
        request.setWarehouseNo("110017684");
        try {
            EclpStockQueryStockResponse response = (EclpStockQueryStockResponse)client.execute((JdRequest)request);
            System.out.println(JsonUtil.buildNormalBinder().toJson((Object)response));
            int[] totalNum = ((WarehouseStockResponse)response.getQuerystockResult().get(0)).getTotalNum();
            int goodsNum = totalNum[0];
            System.out.println(goodsNum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String rejectionOrderByJdMessageProcess(JdClient client, Map<String, Object> keyMap, DisChannel disChannel) {
        String type = "5";
        return "SUCCESS";
    }

    public String cancelOrderByJdMessageProcess(JdClient client, Map<String, Object> keyMap, DisChannel disChannel) {
        return "SUCCESS";
    }

    private String getSimilarSkuList(JdClient client, Long skuId) {
        return "ERROR";
    }

    private String updateContractState(OcContractReDomain ocContractReDomain, int dataState) {
        if (null == ocContractReDomain) {
            return "ERROR";
        }
        int olddataState = ocContractReDomain.getDataState();
        if (olddataState == dataState) {
            return "SUCCESS";
        }
        String contractBillcode = ocContractReDomain.getContractBillcode();
        String tenantCode = ocContractReDomain.getTenantCode();
        if (2 == olddataState && dataState == 3) {
            this.updateOcContract(contractBillcode, tenantCode);
        } else if (2 == olddataState && dataState == 4) {
            this.updateOcContract(contractBillcode, tenantCode);
            this.updateOcContract(contractBillcode, tenantCode);
        } else if (2 == olddataState && dataState == -2) {
            this.updateBackOcContract(contractBillcode, tenantCode);
        } else if (3 == olddataState && dataState == 4) {
            this.updateOcContract(contractBillcode, tenantCode);
        } else if (3 == olddataState && dataState == -2) {
            this.updateBackOcContract(contractBillcode, tenantCode);
        } else if (4 == olddataState && dataState == -2) {
            this.updateBackOcContract(contractBillcode, tenantCode);
        }
        return "SUCCESS";
    }

    private void updateBackOcContract(String contractBillcode, String tenantCode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractBillcode", contractBillcode);
        this.internalInvoke("oc.contractEngine.sendContractBack", paramMap);
    }

    private void updateOcContract(String contractBillcode, String tenantCode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractBillcode", contractBillcode);
        this.internalInvoke("oc.contractEngine.sendContractNext", paramMap);
    }

    private List<OcContractReDomain> queryOcContract(String tenantCode) {
        String apiCode = "oc.contract.queryContractPage";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("contractType", "40");
        map.put("dataState", "2,3");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult qoc = this.sendReSupObject(apiCode, paramMap, OcContractReDomain.class);
        if (null == qoc || ListUtil.isEmpty((Collection)qoc.getList())) {
            return null;
        }
        return qoc.getList();
    }

    public Map<String, Object> buildOrderParam(Map<String, Object> map) {
        return map;
    }

    private String decodeParam(String detail) {
        if (StringUtils.isBlank((String)detail)) {
            return null;
        }
        try {
            detail = new String(detail.getBytes("ISO-8859-1"), "utf-8");
            detail = URLDecoder.decode(detail, "UTF-8");
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".decodeParam", (Object)("=======" + e));
        }
        return detail;
    }

    public String saveOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + "saveOrderParam.come====", (Object)sendhttpParam.toString());
        if (null == sendhttpParam || null == sendhttpParam.get("jd_param_json")) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.jd_param_json is null!", (Object)sendhttpParam.toString());
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        String jdParamList = this.decodeParam((String)sendhttpParam.get("jd_param_json"));
        if (StringUtils.isBlank((String)jdParamList)) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.jd_param_json", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jd_param_json");
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(jdParamList, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.jsonToMap", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jsonToMap");
        }
        String methodType = (String)sendhttpParam.get("methodType");
        if ("afterSaleBillStatus".equals(methodType) || "newAfterSaleBill".equals(methodType) || "newApplyAfterSaleBill".equals(methodType) || "updateApplyAfterSaleBill".equals(methodType)) {
            this.logger.error(this.SYS_CODE, (Object)("come!!!" + jsonToMap + "=:=" + methodType));
            String str = this.disRefundService.saveSendRefundState(sendhttpParam);
            this.logger.error(this.SYS_CODE, (Object)("come =:=" + str + "=:=" + methodType));
            return str;
        }
        String memberCode = (String)sendhttpParam.get("memberCode");
        String tenantCode = (String)sendhttpParam.get("tenantCode");
        if (null == jsonToMap.get("billId") && null == jsonToMap.get("statusId") && null == jsonToMap.get("timestamp")) {
            if (null == jsonToMap.get("orderId")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.orderId is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String orderId = (String)jsonToMap.get("orderId");
            if (null == jsonToMap.get("deliveryStatus")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryStatus is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String deliveryStatus = (String)jsonToMap.get("deliveryStatus");
            if (null == jsonToMap.get("deliveryStatusTime")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryStatusTime is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("deliveryCarrierNo")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryCarrierNo is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("deliveryCarrierName")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryCarrierName is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("createPin")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.createPin is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("opTime")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.opTime is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == this.getContractByNbCode(disChannel.getTenantCode(), orderId, disChannel)) {
                DisContractDomain disContractDomain = this.getSendOrder(orderId, memberCode, tenantCode);
                ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
                if (null != disContractDomain) {
                    disContractList.add(disContractDomain);
                }
                try {
                    this.saveOrder(disContractList, disChannel);
                }
                catch (Exception e) {
                    this.logger.error(this.SYS_CODE + ".saveOrderParam1111.saveOrder");
                }
            }
            if ("32000".equals(deliveryStatus)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), deliveryStatus);
            if ("33060".equals(dataStateStr) || "20020".equals(dataStateStr)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
                dataStateStr = String.valueOf(deliveryStatus);
            }
            Integer dataState = Integer.valueOf(dataStateStr);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dataStatestr", deliveryStatus);
            try {
                this.updateOrder(disChannel.getTenantCode(), orderId, dataState, null, map, disChannel);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".updateOrder000 result is error");
            }
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        if (null != jsonToMap.get("billId") && null != jsonToMap.get("statusId") && null != jsonToMap.get("timestamp")) {
            String billId = (String)jsonToMap.get("billId");
            String statusId = (String)jsonToMap.get("statusId");
            if (null == this.getContractByNbCode(disChannel.getTenantCode(), billId, disChannel)) {
                DisContractDomain disContractDomain = this.getSendOrder(billId, memberCode, tenantCode);
                ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
                if (null != disContractDomain) {
                    disContractList.add(disContractDomain);
                }
                try {
                    this.saveOrder(disContractList, disChannel);
                }
                catch (Exception e) {
                    this.logger.error(this.SYS_CODE + ".saveOrderParam1111.saveOrder");
                }
            }
            if ("pickFinishOrder".equals(methodType) && "2".equals(statusId)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if ("applyCancelOrder".equals(methodType)) {
                if (StringUtils.isBlank((String)billId) || StringUtils.isBlank((String)statusId)) {
                    this.logger.error(this.SYS_CODE + ".applyCancelOrder:", (Object)("billId:" + billId + ";statusId:" + statusId + "=:=" + jsonToMap));
                    return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
                }
                if ("20030".equals(statusId)) {
                    return this.buildRefund(disChannel, billId, statusId, memberCode, tenantCode, jsonToMap);
                }
            }
            if ("32000".equals(statusId)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), statusId);
            if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
                dataStateStr = String.valueOf(statusId);
            }
            Integer dataState = Integer.valueOf(dataStateStr);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dataStatestr", statusId);
            try {
                this.updateOrder(disChannel.getTenantCode(), billId, dataState, null, map, disChannel);
            }
            catch (Exception e) {
                // empty catch block
            }
            if ("20032".equals(statusId) || "20020".equals(statusId)) {
                DisRefundReDomain disRefundReDomain = this.getRefundByNbillcode(disChannel.getTenantCode(), billId, disChannel);
                if (null != disRefundReDomain) {
                    HashMap<String, String> mapP = new HashMap<String, String>();
                    mapP.put("dataStatestr", statusId);
                    this.sendUpdateRefundStateByCode(disChannel.getTenantCode(), disRefundReDomain.getRefundCode(), disChannel.getChannelCode(), Integer.parseInt(statusId), disRefundReDomain.getDataState(), mapP);
                } else {
                    return this.buildRefund(disChannel, billId, statusId, memberCode, tenantCode, jsonToMap);
                }
            }
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
    }

    private String resultReturn(String code, String msg, String data) {
        return "{\"code\":\"" + code + '\"' + ",\"msg\":" + '\"' + msg + '\"' + ",\"data\":\"" + data + "\"}";
    }

    private String buildRefund(DisChannel disChannel, String billId, String statusId, String memberCode, String tenantCode, Map<String, Object> jsonToMap) {
        DisContractDomain disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), billId, disChannel);
        if (null == disContractDomain) {
            disContractDomain = this.getSendOrder(billId, memberCode, tenantCode);
            if (null == disContractDomain) {
                this.logger.error(this.SYS_CODE + ".applyCancelOrder.disContractDomain is null", (Object)billId);
                return this.resultReturn("-1", "ERROR", "jd_param_json");
            }
            ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
            disContractList.add(disContractDomain);
            this.saveOrder(disContractList, disChannel);
            disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), billId, disChannel);
        }
        if (null == (disContractDomain = this.getContractDomainByCode(disChannel.getTenantCode(), disContractDomain.getContractBillcode(), disChannel))) {
            this.logger.error(this.SYS_CODE + ".applyCancelOrder.disContractDomain is null", (Object)(billId + "=:=" + disContractDomain));
            return null;
        }
        DisRefundDomain disRefundDomain = this.createRefundInfoForVop(disContractDomain, disChannel, this.getQueryParamMap("billId,statusId,remark,timestamp", new Object[]{billId, statusId, jsonToMap.get("remark"), jsonToMap.get("timestamp")}));
        ArrayList<DisRefundDomain> disRefundDomainList = new ArrayList<DisRefundDomain>();
        disRefundDomainList.add(disRefundDomain);
        this.logger.error(this.SYS_CODE + " disRefundDomainList.jdVopV2 : ", (Object)(disRefundDomainList.size() + " =:= " + disRefundDomainList));
        this.saveRefund(disRefundDomainList, disChannel);
        return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
    }

    private DisRefundDomain createRefundInfoForVop(DisContractDomain disContractDomain, DisChannel disChannel, Map<String, Object> map) {
        if (null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".createRefundJdVopV2", map);
            return null;
        }
        return this.buildRefundInfoForVop(disContractDomain, disChannel, map);
    }

    private DisRefundDomain buildRefundInfoForVop(DisContractDomain disContractDomain, DisChannel disChannel, Map<String, Object> map) {
        this.logger.error(this.SYS_CODE + ".buildRefundInfoForVop", (Object)(JsonUtil.buildNormalBinder().toJson((Object)disContractDomain) + " =:= " + map));
        if (null == disContractDomain) {
            this.logger.info(this.SYS_CODE + ".buildRefundInfoForVop.disContractDomain", map);
            return null;
        }
        DisRefundDomain disRefundDomain = new DisRefundDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRefundDomain, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".buildRefundInfoForVop.copyAllPropertys", (Throwable)e);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String ctimeStr = (String)map.get("timestamp");
        try {
            disRefundDomain.setRefundDate(sdf.parse(ctimeStr));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        disRefundDomain.setRefundCreate(disContractDomain.getContractValidate());
        String refundAuditTime = this.getRefundAuditTime(disChannel.getTenantCode(), disChannel.getChannelCode());
        if (null != refundAuditTime && StringUtils.isNotBlank((String)refundAuditTime)) {
            disRefundDomain.setRefundInvstate(Integer.valueOf(Integer.parseInt(refundAuditTime)));
        }
        String res_reason = null == map.get("remark") ? null : map.get("remark").toString();
        disRefundDomain.setRefundEx(res_reason);
        disRefundDomain.setRefundUsertype("0");
        disRefundDomain.setRefundMeo(res_reason);
        disRefundDomain.setDataStatestr(String.valueOf(map.get("statusId")));
        disRefundDomain.setRefundType("JdVop");
        disRefundDomain.setRefundMoney(disContractDomain.getDataBmoney());
        disRefundDomain.setOcRefundGoodsDomainList(this.createRefundGoods(disContractDomain, disRefundDomain));
        return disRefundDomain;
    }

    private List<DisRefundGoodsDomain> createRefundGoods(DisContractDomain disContractDomain, DisRefundDomain disRefundDomain) {
        if (null == disRefundDomain || null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".createRefundGoods.", (Object)(disContractDomain + "=:=" + disRefundDomain));
            return null;
        }
        BigDecimal refundMoney = BigDecimal.ZERO;
        Map map = this.getMap(disContractDomain);
        if (MapUtil.isEmpty((Map)map)) {
            return null;
        }
        ArrayList<DisRefundGoodsDomain> refundGoodsList = new ArrayList<DisRefundGoodsDomain>();
        for (String key : map.keySet()) {
            BigDecimal refnum;
            DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.get(key);
            if (null == disContractGoodsDomain) {
                return null;
            }
            BigDecimal bigDecimal = refnum = null == disContractGoodsDomain.getContractGoodsRefnum() ? BigDecimal.ZERO : disContractGoodsDomain.getContractGoodsRefnum();
            if (disContractGoodsDomain.getGoodsCamount().compareTo(refnum) == 0) {
                refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsMoney());
                continue;
            }
            disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
            DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
            refundGoodsList.add(disRefundGoodsDomain);
            refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsPrice().multiply(refnum));
        }
        disRefundDomain.setRefundMoney(disRefundDomain.getRefundMoney().subtract(refundMoney));
        return refundGoodsList;
    }

    private DisRefundGoodsDomain create(DisContractGoodsDomain disContractGoodsDomain) {
        if (null == disContractGoodsDomain) {
            this.logger.error(this.SYS_CODE + ".create.", (Object)"param is null");
            return null;
        }
        DisRefundGoodsDomain disRefundGoodsDomain = new DisRefundGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRefundGoodsDomain, (Object)disContractGoodsDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BigDecimal refnum = null == disContractGoodsDomain.getContractGoodsRefnum() ? BigDecimal.ZERO : disContractGoodsDomain.getContractGoodsRefnum();
        BigDecimal allowNum = disContractGoodsDomain.getGoodsCamount().subtract(refnum);
        disRefundGoodsDomain.setRefundGoodsNum(allowNum);
        disRefundGoodsDomain.setRefundGoodsAmt(disContractGoodsDomain.getContractGoodsMoney());
        disRefundGoodsDomain.setRefundGoodsWeight(disContractGoodsDomain.getGoodsCweight());
        disRefundGoodsDomain.setRefundGoodsPrice(disContractGoodsDomain.getPricesetNprice());
        return disRefundGoodsDomain;
    }

    private Boolean getddflagsetting(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        if (StringUtils.isEmpty((String)value)) {
            field = "00000000".concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
            value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        }
        if (StringUtils.isEmpty((String)value) || "true".equals(value)) {
            this.logger.error(this.SYS_CODE + ".getddflagsetting:" + value);
            return true;
        }
        return false;
    }

    public Map<String, String> addressResolution(String address) {
        String province = null;
        String city = null;
        String provinceAndCity = null;
        String county = null;
        String town = null;
        String detailAddress = null;
        LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
        ArrayList<LinkedHashMap<String, String>> table = new ArrayList<LinkedHashMap<String, String>>();
        HashMap<String, String> resultMap = new HashMap<String, String>(4);
        if (address.startsWith("\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a")) {
            resultMap.put("province", "\u9999\u6e2f");
            return resultMap;
        }
        if (address.contains("\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a")) {
            resultMap.put("province", "\u6fb3\u95e8");
            return resultMap;
        }
        if (address.contains("\u53f0\u6e7e")) {
            resultMap.put("province", "\u53f0\u6e7e");
            return resultMap;
        }
        if (address.indexOf(",") > 0) {
            String[] s = address.split(",");
            if (s.length > 0) {
                resultMap.put("province", s[0]);
            }
            if (s.length > 1) {
                resultMap.put("city", s[1]);
            }
            if (s.length > 2) {
                resultMap.put("county", s[2]);
            }
            if (s.length > 4) {
                resultMap.put("town", s[3]);
                resultMap.put("village", s[4]);
            } else {
                resultMap.put("village", s[3]);
            }
            return resultMap;
        }
        String regex = "((?<provinceAndCity>[^\u5e02]+\u81ea\u6cbb\u5dde|.*?\u5730\u533a|.*?\u884c\u653f\u5355\u4f4d|.+\u76df|.*?\u5e02|.*?\u53bf)(?<county>[^\u53bf]+\u53bf|.+\u533a|.+\u5e02|.+\u65d7|.+\u6d77\u57df|.+\u5c9b)?(?<town>[^\u533a]+\u533a|.+\u9547)?(?<detailAddress>.*))";
        Matcher m = Pattern.compile(regex).matcher(address);
        while (m.find()) {
            provinceAndCity = m.group("provinceAndCity");
            String regex2 = "((?<province>[^\u7701]+\u7701|.+\u81ea\u6cbb\u533a|\u4e0a\u6d77\u5e02|\u5317\u4eac\u5e02|\u5929\u6d25\u5e02|\u91cd\u5e86\u5e02|\u4e0a\u6d77|\u5317\u4eac|\u5929\u6d25|\u91cd\u5e86)(?<city>.*))";
            Matcher m2 = Pattern.compile(regex2).matcher(provinceAndCity);
            while (m2.find()) {
                province = m2.group("province");
                row.put("province", province == null ? "" : province.trim());
                city = m2.group("city");
                row.put("city", city == null ? "" : city.trim());
            }
            county = m.group("county");
            row.put("county", county == null ? "" : county.trim());
            town = m.group("town");
            row.put("town", town == null ? "" : town.trim());
            detailAddress = m.group("detailAddress");
            row.put("detailAddress", detailAddress == null ? "" : detailAddress.trim());
            table.add(row);
        }
        if (table != null && table.size() > 0) {
            if (StringUtils.isNotBlank((String)((String)((Map)table.get(0)).get("province"))) && (province = (String)((Map)table.get(0)).get("province")).contains("\u81ea\u6cbb\u533a")) {
                province = province.contains("\u5185\u8499\u53e4") ? province.substring(0, 4) : province.substring(0, 3);
            }
            if (StringUtils.isNotBlank(province)) {
                if (StringUtils.isNotBlank((String)((String)((Map)table.get(0)).get("city")))) {
                    city = (String)((Map)table.get(0)).get("city");
                    if (city.equals("\u4e0a\u6d77\u5e02") || city.equals("\u91cd\u5e86\u5e02") || city.equals("\u5317\u4eac\u5e02") || city.equals("\u5929\u6d25\u5e02")) {
                        province = (String)((Map)table.get(0)).get("city");
                    }
                } else if (province.equals("\u4e0a\u6d77\u5e02") || province.equals("\u91cd\u5e86\u5e02") || province.equals("\u5317\u4eac\u5e02") || province.equals("\u5929\u6d25\u5e02")) {
                    city = province;
                }
                if (StringUtils.isNotBlank((String)((String)((Map)table.get(0)).get("county")))) {
                    county = (String)((Map)table.get(0)).get("county");
                }
                province = province.substring(0, province.length() - 1);
            }
        } else {
            return resultMap;
        }
        resultMap.put("province", province);
        resultMap.put("city", city);
        resultMap.put("county", county == null ? "" : county);
        resultMap.put("town", town == null ? "" : town);
        resultMap.put("village", detailAddress);
        return resultMap;
    }
}

