/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.maihe.service.impl;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.maihe.common.LogRouterlogDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.ext.ActiveDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.ext.ActivePromotionDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.ext.ActiveRebateDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.ext.GrantDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.reb.RebPointsGoodsDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.reb.RebPointsUsersDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.wh.WhOpstoreReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.wh.WhWarehouseReDomain;
import com.yqbsoft.laser.service.ext.maihe.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.maihe.facade.request.wh.WhOpstoreRequest;
import com.yqbsoft.laser.service.ext.maihe.facade.request.wh.WhWarehouseRequest;
import com.yqbsoft.laser.service.ext.maihe.facade.response.oa.OaResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.response.wh.WhOpstoreResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.response.wh.WhWarehouseResponse;
import com.yqbsoft.laser.service.ext.maihe.service.BusStoreService;
import com.yqbsoft.laser.service.ext.maihe.supbase.StoreBaseService;
import com.yqbsoft.laser.service.ext.maihe.util.ActiveAdutiEnums;
import com.yqbsoft.laser.service.ext.maihe.util.ActiveEnums;
import com.yqbsoft.laser.service.ext.maihe.util.ComplianceRebEnums;
import com.yqbsoft.laser.service.ext.maihe.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.ext.maihe.util.RebActivePromotionEnums;
import com.yqbsoft.laser.service.ext.maihe.util.RebEnums;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BusStoreServiceImpl
extends StoreBaseService
implements BusStoreService {
    private String SYS_CODE = "maihe.BusStoreServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusStoreServiceImpl.class);
    private String ddcode = "store";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusWarehouse(WhWarehouseReDomain whWarehouseDomain) {
        if (null == whWarehouseDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseDomain");
            return "error";
        }
        String tenantCode = whWarehouseDomain.getTenantCode();
        WhWarehouseRequest whWarehouseRequest = new WhWarehouseRequest();
        whWarehouseRequest.init(this.getDdMap(tenantCode, this.ddcode, "maihe"));
        try {
            BeanUtils.copyAllPropertys((Object)whWarehouseRequest, (Object)whWarehouseDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Throwable)e);
            return "error";
        }
        WhWarehouseResponse whWarehouseResponse = this.restTempfacade.execute(whWarehouseRequest);
        if (null == whWarehouseResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseResponse");
            return "error";
        }
        if (!whWarehouseResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseResponse", (Object)whWarehouseResponse.getMsg());
            return whWarehouseResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusOpstore(WhOpstoreReDomain whOpstoreReDomain) {
        if (null == whOpstoreReDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOpstore.WhWarehouseDomain");
            return "error";
        }
        String tenantCode = whOpstoreReDomain.getTenantCode();
        WhOpstoreRequest whOpstoreRequest = new WhOpstoreRequest();
        whOpstoreRequest.init(this.getDdMap(tenantCode, this.ddcode, "maihe"));
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreRequest, (Object)whOpstoreReDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.e", (Object)e);
            return "error";
        }
        WhOpstoreResponse whOpstoreResponse = this.restTempfacade.execute(whOpstoreRequest);
        if (null == whOpstoreResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.whOpstoreResponse");
            return "error";
        }
        if (!whOpstoreResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.whOpstoreResponse", (Object)whOpstoreResponse.getMsg());
            return whOpstoreResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendGrantToOa(GrantDomain grantDomain) {
        HashMap<String, String> oaMap = new HashMap<String, String>();
        oaMap.put("customerCode", "MH");
        oaMap.put("workCode", "customer_information");
        oaMap.put("userCode", "seeyon2");
        oaMap.put("unitCode", "MH_OA_DMS");
        Date date = new Date();
        oaMap.put("calendar", DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd"));
        oaMap.put("planStart", DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        oaMap.put("pk_robot", "d114a8c9dd3711ee88f80068eb57e0de");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applyPerson", grantDomain.getApplyPerson());
        map.put("applyDepart", grantDomain.getApplyDepart());
        map.put("brandName", grantDomain.getBrandName());
        map.put("grantType", "\u8fd4\u5229\u53d1\u653e");
        ArrayList customerList = new ArrayList();
        HashMap<String, Object> smap1 = new HashMap<String, Object>();
        smap1.put("customer", grantDomain.getCustomerName());
        smap1.put("sapCode", grantDomain.getSapCode());
        smap1.put("projectName", "\u8fd4\u5229");
        smap1.put("amout", grantDomain.getAmout());
        smap1.put("attachNo", grantDomain.getGrantSubNo());
        smap1.put("themeName", grantDomain.getSignName());
        smap1.put("remarkName", grantDomain.getRemark());
        customerList.add(smap1);
        map.put("customerList", customerList);
        oaMap.put("workParam", JsonUtil.buildNormalBinder().toJson(map));
        String req = JsonUtil.buildNormalBinder().toJson(oaMap);
        LogRouterlogDomain logRouterlogDomain = new LogRouterlogDomain();
        logRouterlogDomain.setAppapiCode("amoutAudit");
        logRouterlogDomain.setAppapiVersion("1.0");
        logRouterlogDomain.setRouteDire("51");
        logRouterlogDomain.setRouterlogName("");
        logRouterlogDomain.setRouterlogMessage(req);
        logRouterlogDomain.setTenantCode(grantDomain.getTenantCode());
        String url = this.getUrl(grantDomain.getTenantCode(), "oaUrl", "oaUrl");
        logger.info(this.SYS_CODE + ".sendGrantToOa.oa.req", (Object)("url=" + url + ";req" + req));
        String adressRes = OKHttpClientUtil.sendPost(url, req);
        logger.info(this.SYS_CODE + ".sendGrantToOa.oa.res", (Object)adressRes);
        logRouterlogDomain.setRouterlogReturn(adressRes);
        if (StringUtils.isEmpty((String)adressRes)) {
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".sendGrantToOa.\u540c\u6b65oa\u8fd4\u5229\u4f59\u989d\u7533\u8bf7\u8fd4\u56de\u4e3a\u7a7a");
            return "fail";
        }
        OaResponse oaResponse = (OaResponse)JsonUtil.buildNonNullBinder().getJsonToObject(adressRes, OaResponse.class);
        logRouterlogDomain.setRouterlogReturnstate(oaResponse.getErrorCode());
        logRouterlogDomain.setRouterlogReturnstates(oaResponse.getData());
        logRouterlogDomain.setRouterlogMesid(oaResponse.getData());
        logRouterlogDomain.setRouterlogMespid(grantDomain.getGrantNo());
        logRouterlogDomain.setRouterlogType("10");
        this.sendLog(logRouterlogDomain);
        if ("0".equals(oaResponse.getErrorCode())) {
            logger.error(this.SYS_CODE + ".sendGrantToOa.\u540c\u6b65a\u8fd4\u5229\u4f59\u989d\u7533\u8bf7\u51fa\u73b0\u5f02\u5e38", (Object)oaResponse.getErrorMessage());
            return "fail";
        }
        return "success";
    }

    public String sendGrantToOa(ActiveDomain activeDomain) {
        HashMap<String, String> oaMap = new HashMap<String, String>();
        oaMap.put("customerCode", "MH");
        oaMap.put("workCode", "customer_information");
        oaMap.put("userCode", "seeyon2");
        oaMap.put("unitCode", "MH_OA_DMS");
        Date date = new Date();
        oaMap.put("calendar", DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd"));
        oaMap.put("planStart", DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        oaMap.put("pk_robot", "d114a8c9dd3711ee88f80068eb57e0de");
        HashMap<String, Object> map = new HashMap<String, Object>();
        ActiveRebateDomain activeRebate = activeDomain.getActiveRebate();
        map.put("applyPerson", activeDomain.getApplyPerson());
        map.put("applyDepart", activeDomain.getApplyDepart());
        map.put("brandName", activeDomain.getBrandName());
        map.put("grantType", ActiveAdutiEnums.getNameByCode(activeRebate.getRebType()));
        map.put("attachUrl", activeDomain.getAttachUrl());
        ArrayList customerList = new ArrayList();
        for (RebPointsUsersDomain rebPointsUsersDomain : activeRebate.getRebPointsUsersDomainList()) {
            HashMap<String, String> smap1 = new HashMap<String, String>();
            smap1.put("customer", rebPointsUsersDomain.getPointsUserName());
            smap1.put("sapCode", rebPointsUsersDomain.getPointsUserOp());
            smap1.put("projectName", "\u9884\u4ed8\u8d27\u6b3e");
            smap1.put("amout", rebPointsUsersDomain.getPointsUserOp1());
            smap1.put("attachNo", rebPointsUsersDomain.getPointsUserTerm());
            smap1.put("themeName", rebPointsUsersDomain.getPointsUserType());
            smap1.put("remarkName", rebPointsUsersDomain.getPointsUserCode());
            customerList.add(smap1);
            HashMap<String, String> smap2 = new HashMap<String, String>();
            smap2.put("customer", rebPointsUsersDomain.getPointsUserName());
            smap2.put("sapCode", rebPointsUsersDomain.getPointsUserOp());
            smap2.put("projectName", "\u8fd4\u5229");
            smap2.put("amout", rebPointsUsersDomain.getPointsUserOp2());
            smap2.put("attachNo", rebPointsUsersDomain.getPointsUserTerm());
            smap2.put("themeName", rebPointsUsersDomain.getPointsUserType());
            smap2.put("remarkName", rebPointsUsersDomain.getPointsUserCode());
            customerList.add(smap2);
            HashMap<String, String> smap3 = new HashMap<String, String>();
            smap3.put("customer", rebPointsUsersDomain.getPointsUserName());
            smap3.put("sapCode", rebPointsUsersDomain.getPointsUserOp());
            smap3.put("projectName", "\u6388\u4fe1");
            smap3.put("amout", rebPointsUsersDomain.getPointsUserOp3());
            smap3.put("attachNo", rebPointsUsersDomain.getPointsUserTerm());
            smap3.put("themeName", rebPointsUsersDomain.getPointsUserType());
            smap3.put("remarkName", rebPointsUsersDomain.getPointsUserCode());
            customerList.add(smap3);
        }
        map.put("customerList", customerList);
        oaMap.put("workParam", JsonUtil.buildNormalBinder().toJson(map));
        String req = JsonUtil.buildNormalBinder().toJson(oaMap);
        LogRouterlogDomain logRouterlogDomain = new LogRouterlogDomain();
        logRouterlogDomain.setAppapiCode("amoutAudit");
        logRouterlogDomain.setAppapiVersion("1.0");
        logRouterlogDomain.setRouteDire("51");
        logRouterlogDomain.setRouterlogName("");
        logRouterlogDomain.setRouterlogMessage(req);
        logRouterlogDomain.setTenantCode(activeDomain.getTenantCode());
        String url = this.getUrl(activeDomain.getTenantCode(), "oaUrl", "oaUrl");
        logger.info(this.SYS_CODE + ".sendGrantToOa.oa.req", (Object)("url=" + url + ";req" + req));
        String adressRes = OKHttpClientUtil.sendPost(url, req);
        logger.info(this.SYS_CODE + ".sendGrantToOa.oa.res", (Object)adressRes);
        logRouterlogDomain.setRouterlogReturn(adressRes);
        if (StringUtils.isEmpty((String)adressRes)) {
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".sendGrantToOa.\u540c\u6b65oa\u4f59\u989d\u7533\u8bf7\u8fd4\u56de\u4e3a\u7a7a");
            return "fail";
        }
        OaResponse oaResponse = (OaResponse)JsonUtil.buildNonNullBinder().getJsonToObject(adressRes, OaResponse.class);
        logRouterlogDomain.setRouterlogReturnstate(oaResponse.getErrorCode());
        logRouterlogDomain.setRouterlogReturnstates(oaResponse.getData());
        logRouterlogDomain.setRouterlogMesid(oaResponse.getData());
        logRouterlogDomain.setRouterlogMespid(activeDomain.getGrantNo());
        logRouterlogDomain.setRouterlogMespid(activeDomain.getGrantNo());
        logRouterlogDomain.setRouterlogType("3");
        this.sendLog(logRouterlogDomain);
        if ("0".equals(oaResponse.getErrorCode())) {
            logger.error(this.SYS_CODE + ".sendGrantToOa.\u540c\u6b65a\u4f59\u989d\u7533\u8bf7\u51fa\u73b0\u5f02\u5e38", (Object)oaResponse.getErrorMessage());
            return "fail";
        }
        return "success";
    }

    @Override
    public String sendActiveToOa(ActiveDomain activeDomain) {
        Object subMap;
        ActiveRebateDomain activeRebate;
        if ("3".equals(activeDomain.getGrantType())) {
            return this.sendGrantToOa(activeDomain);
        }
        HashMap<String, String> oaMap = new HashMap<String, String>();
        oaMap.put("customerCode", "MH");
        oaMap.put("workCode", "customer_information");
        oaMap.put("userCode", "seeyon2");
        oaMap.put("unitCode", "MH_OA_DMS");
        Date date = new Date();
        oaMap.put("calendar", DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd"));
        oaMap.put("planStart", DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        oaMap.put("pk_robot", "d114a819dd3711ee88f80068eb57e0de");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applyDate", activeDomain.getApplyDate());
        map.put("applyPerson", activeDomain.getApplyPerson());
        map.put("applyDepart", activeDomain.getApplyDepart());
        map.put("brandName", activeDomain.getBrandName());
        map.put("grantType", RebActivePromotionEnums.getNameByCode(activeDomain.getGrantType()));
        map.put("startTime", activeDomain.getStartTime());
        map.put("endTime", activeDomain.getEndTime());
        if ("1".equals(activeDomain.getGrantType())) {
            ArrayList customerList;
            List<RebPointsUsersDomain> rebPointsUsersDomainList;
            activeRebate = activeDomain.getActiveRebate();
            if ("1".equals(activeRebate.getRebType())) {
                map.put("type", "\u5355\u54c1\u8fd4\u5229");
                rebPointsUsersDomainList = activeRebate.getRebPointsUsersDomainList();
                customerList = new ArrayList();
                for (RebPointsUsersDomain rebPointsUsersDomain : rebPointsUsersDomainList) {
                    for (RebPointsGoodsDomain rebPointsGoodsDomain : activeRebate.getRebPointsGoodsDomainList()) {
                        HashMap<String, Object> customerMap = new HashMap<String, Object>();
                        customerMap.put("sapCode", rebPointsUsersDomain.getPointsUserOp());
                        customerMap.put("customerName", rebPointsUsersDomain.getPointsUserName());
                        customerMap.put("ratio", rebPointsGoodsDomain.getPointsuserGoodsRatio());
                        ArrayList skuList = new ArrayList();
                        HashMap<String, String> skuMap = new HashMap<String, String>();
                        skuMap.put("skuName", rebPointsGoodsDomain.getPointsGoodsName());
                        skuMap.put("skuNo", rebPointsGoodsDomain.getPointsGoodsOp());
                        skuMap.put("spuName", rebPointsGoodsDomain.getPointsGoodsOp1());
                        skuMap.put("barCode", rebPointsGoodsDomain.getPointsGoodsOp2());
                        skuList.add(skuMap);
                        customerMap.put("skuList", rebPointsGoodsDomain.getPointsGoodsName());
                        customerList.add(customerMap);
                    }
                }
                map.put("rebList", customerList);
            } else if ("2".equals(activeRebate.getRebType())) {
                map.put("type", "\u6708\u8fd4");
                rebPointsUsersDomainList = activeRebate.getRebPointsUsersDomainList();
                customerList = new ArrayList();
                for (RebPointsUsersDomain rebPointsUsersDomain : rebPointsUsersDomainList) {
                    HashMap<String, Object> customerMap = new HashMap<String, Object>();
                    customerMap.put("sapCode", rebPointsUsersDomain.getPointsUserOp());
                    customerMap.put("customerName", rebPointsUsersDomain.getPointsUserName());
                    for (RebPointsGoodsDomain rebPointsGoodsDomain : activeRebate.getRebPointsGoodsDomainList()) {
                        customerMap.put("ratio", rebPointsGoodsDomain.getPointsuserGoodsRatio());
                        HashMap<String, Object> skuMap = new HashMap<String, Object>();
                        skuMap.put("tenantCode", activeDomain.getTenantCode());
                        skuMap.put("classtreeCode", rebPointsGoodsDomain.getPointsGoodsOp());
                        skuMap.put("channelCode", "796759704660738049");
                        QueryResult<RsSkuDomain> rsSkuDomainQueryResult = this.queryRsSkuPage(skuMap);
                        if (rsSkuDomainQueryResult != null && CollectionUtils.isNotEmpty((Collection)rsSkuDomainQueryResult.getList())) {
                            ArrayList skuList = new ArrayList();
                            HashMap<String, String> skuListMap = new HashMap<String, String>();
                            for (RsSkuDomain rsSkuDomain : rsSkuDomainQueryResult.getList()) {
                                skuListMap.put("skuName", rsSkuDomain.getSkuName());
                                skuListMap.put("skuNo", rsSkuDomain.getSkuEocode());
                                skuListMap.put("spuName", rsSkuDomain.getGoodsName());
                                skuListMap.put("barCode", rsSkuDomain.getSkuBarcode());
                                skuList.add(skuListMap);
                            }
                            customerMap.put("skuList", skuList);
                        }
                        customerList.add(customerMap);
                    }
                }
                map.put("rebList", customerList);
            } else if ("3".equals(activeRebate.getRebType())) {
                map.put("type", "\u8fbe\u6807\u8fd4\u5229");
                map.put("subType", ComplianceRebEnums.getNameByCode(activeRebate.getComplianceRebType()));
                rebPointsUsersDomainList = activeRebate.getRebPointsUsersDomainList();
                customerList = new ArrayList();
                for (RebPointsUsersDomain rebPointsUsersDomain : rebPointsUsersDomainList) {
                    HashMap<String, Object> customerMap = new HashMap<String, Object>();
                    customerMap.put("sapCode", rebPointsUsersDomain.getPointsUserOp());
                    customerMap.put("customerName", rebPointsUsersDomain.getPointsUserName());
                    for (RebPointsGoodsDomain rebPointsGoodsDomain : activeRebate.getRebPointsGoodsDomainList()) {
                        if ("1".equals(activeRebate.getComplianceRebType())) {
                            customerMap.put("Q1", rebPointsGoodsDomain.getPointsGoodsOp1());
                            customerMap.put("Q2", rebPointsGoodsDomain.getPointsGoodsOp2());
                            customerMap.put("Q3", rebPointsGoodsDomain.getPointsGoodsOp3());
                            customerMap.put("Q4", rebPointsGoodsDomain.getPointsGoodsTerm());
                        } else {
                            customerMap.put("Y", rebPointsGoodsDomain.getPointsGoodsOp1());
                        }
                        HashMap<String, Object> skuMap = new HashMap<String, Object>();
                        skuMap.put("tenantCode", activeDomain.getTenantCode());
                        skuMap.put("classtreeCode", rebPointsGoodsDomain.getPointsGoodsOp());
                        skuMap.put("channelCode", "796759704660738049");
                        QueryResult<RsSkuDomain> rsSkuDomainQueryResult = this.queryRsSkuPage(skuMap);
                        if (rsSkuDomainQueryResult != null && CollectionUtils.isNotEmpty((Collection)rsSkuDomainQueryResult.getList())) {
                            ArrayList skuList = new ArrayList();
                            HashMap<String, String> skuListMap = new HashMap<String, String>();
                            for (RsSkuDomain rsSkuDomain : rsSkuDomainQueryResult.getList()) {
                                skuListMap.put("skuName", rsSkuDomain.getSkuName());
                                skuListMap.put("skuNo", rsSkuDomain.getSkuEocode());
                                skuListMap.put("spuName", rsSkuDomain.getGoodsName());
                                skuListMap.put("barCode", rsSkuDomain.getSkuBarcode());
                                skuList.add(skuListMap);
                            }
                            customerMap.put("skuList", skuList);
                        }
                        customerList.add(customerMap);
                    }
                }
                map.put("rebList", customerList);
            }
        } else if ("2".equals(activeDomain.getGrantType())) {
            activeRebate = activeDomain.getActiveRebate();
            map.put("type", ActiveEnums.getNameByCode(activeRebate.getRebType()));
            ArrayList<Object> customerList = new ArrayList<Object>();
            subMap = new HashMap();
            subMap.put("activeName", activeRebate.getUpointsName());
            subMap.put("remark", activeRebate.getActiveFeeRemark());
            List<RebPointsUsersDomain> rebPointsUsersDomainList = activeRebate.getRebPointsUsersDomainList();
            ArrayList subCustomerList = new ArrayList();
            for (RebPointsUsersDomain rebPointsUsersDomain : rebPointsUsersDomainList) {
                HashMap<String, String> customerMap = new HashMap<String, String>();
                customerMap.put("sapCode", rebPointsUsersDomain.getPointsUserOp());
                customerMap.put("customerName", rebPointsUsersDomain.getPointsUserName());
                subCustomerList.add(customerMap);
            }
            subMap.put("customerList", subCustomerList);
            customerList.add(subMap);
            map.put("activeList", customerList);
        } else if ("4".equals(activeDomain.getGrantType())) {
            ActivePromotionDomain activePromotion = activeDomain.getActivePromotion();
            String activePromotionType = activePromotion.getActivePromotionType();
            if ("1".equals(activePromotionType)) {
                subMap = activePromotion.getActivePromotionDirect();
            } else if ("2".equals(activePromotionType) || "3".equals(activePromotionType) || "4".equals(activePromotionType)) {
                // empty if block
            }
            map.put("rebType", RebEnums.getNameByCode(activePromotionType));
        }
        oaMap.put("workParam", JsonUtil.buildNormalBinder().toJson(map));
        String req = JsonUtil.buildNormalBinder().toJson(oaMap);
        LogRouterlogDomain logRouterlogDomain = new LogRouterlogDomain();
        logRouterlogDomain.setAppapiCode("activeApply");
        logRouterlogDomain.setAppapiVersion("1.0");
        logRouterlogDomain.setRouteDire("51");
        logRouterlogDomain.setRouterlogName("");
        logRouterlogDomain.setRouterlogMessage(req);
        logRouterlogDomain.setTenantCode(activeDomain.getTenantCode());
        String url = this.getUrl(activeDomain.getTenantCode(), "oaUrl", "oaUrl");
        logger.info(this.SYS_CODE + ".sendActiveToOa.oa.req", (Object)("url=" + url + ";req" + req));
        String adressRes = OKHttpClientUtil.sendPost(url, req);
        logger.info(this.SYS_CODE + ".sendActiveToOa.oa.res", (Object)adressRes);
        logRouterlogDomain.setRouterlogReturn(adressRes);
        if (StringUtils.isEmpty((String)adressRes)) {
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".sendActiveToOa.\u540c\u6b65oa\u6d3b\u52a8\u7533\u8bf7\u8fd4\u56de\u4e3a\u7a7a");
            return "fail";
        }
        OaResponse oaResponse = (OaResponse)JsonUtil.buildNonNullBinder().getJsonToObject(adressRes, OaResponse.class);
        logRouterlogDomain.setRouterlogReturnstate(oaResponse.getErrorCode());
        logRouterlogDomain.setRouterlogReturnstates(oaResponse.getData());
        logRouterlogDomain.setRouterlogMesid(oaResponse.getData());
        logRouterlogDomain.setRouterlogMespid(activeDomain.getGrantNo());
        logRouterlogDomain.setRouterlogType(activeDomain.getGrantType());
        this.sendLog(logRouterlogDomain);
        if ("0".equals(oaResponse.getErrorCode())) {
            logger.error(this.SYS_CODE + ".sendGrantToOa.\u540c\u6b65oa\u6d3b\u52a8\u7533\u8bf7\u73b0\u5f02\u5e38", (Object)oaResponse.getErrorMessage());
            return "fail";
        }
        return "success";
    }

    private String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            logger.error(this.SYS_CODE + ".getUrl.param");
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        logger.info(this.SYS_CODE + ".getUrl.field", (Object)field);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    public void sendLog(LogRouterlogDomain logRouterlogDomain) {
        String api_code = "log.logRouterlog.saveRouterlog";
        if (null == logRouterlogDomain) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("logRouterlogDomain", JsonUtil.buildNormalBinder().toJson((Object)logRouterlogDomain));
        this.inAsyncInvoke(api_code, paramMap);
    }
}

