/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.maihe.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.maihe.api.ExUserService;
import com.yqbsoft.laser.service.ext.maihe.common.LogRouterlogDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.crp.CrpUrechargeDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.dis.DisChannelReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.inv.InvUserinv;
import com.yqbsoft.laser.service.ext.maihe.domain.reb.RebUpointsDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.rs.RsBrandDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmAddressReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmUserDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmUserDomainBean;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmUserReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmUserinfoDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UserinfoThemeDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.vd.VdFaccountOuterCtrlDomain;
import com.yqbsoft.laser.service.ext.maihe.facade.response.oa.OaUserinfoResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.response.sap.SapAdressResponse;
import com.yqbsoft.laser.service.ext.maihe.supbase.UserinfoBaseService;
import com.yqbsoft.laser.service.ext.maihe.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class ExUserServiceImpl
extends UserinfoBaseService
implements ExUserService {
    private String SYS_CODE = "maihe.ExUserServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(ExUserServiceImpl.class);

    @Override
    public String sendSaveExUserUserinfo(UmUserDomainBean umUserDomainBean) {
        if (null == umUserDomainBean) {
            logger.error(this.SYS_CODE + ".sendSaveExUserUserinfo.umUserDomainBean");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExUserUserinfo.umUserDomainBean", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkUmUser(umUserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExUserUserinfo.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExUserUserinfo.msg", msg);
        }
        String tenantCode = umUserDomainBean.getTenantCode();
        umUserDomainBean.setMemberMcode(this.getTeananMemberCode(tenantCode));
        try {
            String userinfoCode = this.sendOpenUserinfo(umUserDomainBean);
            if (StringUtils.isBlank((String)userinfoCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExUserUserinfo.userinfoCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExUserUserinfo.userinfoCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(userinfoCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExUserUserinfo.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExUserUserinfo.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExUserUserinfo.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExUserUserinfo.e1", e.getMessage());
        }
    }

    @Override
    public String sendUpdateExUserUserinfo(String data) {
        logger.info(this.SYS_CODE + ".sendUpdateExUserUserinfo.umUserinfoDomain" + data);
        if (StringUtils.isEmpty((String)data)) {
            logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.umUserinfoDomain.\u6570\u636e\u4e3a\u7a7a", (Object)data);
            return this.makeErrorReturn(this.SYS_CODE + ".sendUpdateExUserUserinfo.resStream", "\u6570\u636e\u4e3a\u7a7a");
        }
        OaUserinfoResponse oaUserinfoResponse = (OaUserinfoResponse)JsonUtil.buildNormalBinder().getJsonToObject(data, OaUserinfoResponse.class);
        if (null == oaUserinfoResponse) {
            logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.umUserinfoDomain.\u53c2\u6570\u4e3a\u7a7a", (Object)data);
            return this.makeErrorReturn(this.SYS_CODE + ".sendUpdateExUserUserinfo.umUserDomainBean", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)oaUserinfoResponse.getRouterlogCode())) {
            logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.umUserinfoDomain", (Object)data);
            return this.makeErrorReturn(this.SYS_CODE + ".sendUpdateExUserUserinfo.umUserDomainBean", "\u6d41\u6c34\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)oaUserinfoResponse.getDataState())) {
            logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.umUserinfoDomain", (Object)data);
            return this.makeErrorReturn(this.SYS_CODE + ".sendUpdateExUserUserinfo.umUserDomainBean", "\u5ba1\u6838\u72b6\u6001\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(oaUserinfoResponse.getUserinfoThemeList())) {
            logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.umUserinfoDomain", (Object)data);
            return this.makeErrorReturn(this.SYS_CODE + ".sendUpdateExUserUserinfo.umUserDomainBean", "\u4e3b\u4f53\u96c6\u5408\u4fe1\u606f\u4e3a\u7a7a");
        }
        try {
            String tenantCode = "796758877233610836";
            LogRouterlogDomain logRouterlogDomain = this.queryLog(oaUserinfoResponse.getRouterlogCode(), tenantCode);
            if (null == logRouterlogDomain) {
                logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.queryExUserUserinfoByMap.isnull", (Object)(oaUserinfoResponse.getRouterlogCode() + ":::" + tenantCode));
                return this.makeErrorReturn(this.SYS_CODE + ".sendUpdateExUserUserinfo.msg", "DMS\u672a\u627e\u5230\u6d41\u6c34\u4fe1\u606f");
            }
            if ("userinfoAdress".equals(logRouterlogDomain.getRouterlogType())) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("addressCode", logRouterlogDomain.getRouterlogMespid());
                UmAddressReDomain addressByCode = this.getAddressByCode(map);
                if (addressByCode == null) {
                    logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.getAddressByCode.isnull", (Object)(logRouterlogDomain.getRouterlogMespid() + ":::" + tenantCode));
                    return this.makeErrorReturn(this.SYS_CODE + ".sendUpdateExUserUserinfo.msg", "DMS\u672a\u627e\u5230\u53d1\u7968\u4fe1\u606f");
                }
                if (oaUserinfoResponse.getDataState().equals("2")) {
                    this.updateAddressState(addressByCode.getAddressId(), 2, null);
                } else {
                    UmUserinfoReDomain umUserinfoDomain = this.getUserinfoByCode(addressByCode.getUserCode(), tenantCode);
                    if (null == umUserinfoDomain) {
                        logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.umUserinfoDomain.isnull", (Object)(logRouterlogDomain.getRouterlogMespid() + ":::" + tenantCode));
                        return this.makeErrorReturn(this.SYS_CODE + ".sendUpdateExUserUserinfo.msg", "DMS\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f");
                    }
                    this.saveOrUpdateAdrees(umUserinfoDomain);
                    this.updateAddressState(addressByCode.getAddressId(), 1, null);
                }
            } else {
                UmUserinfoReDomain umUserinfoDomain = this.getUserinfoByCode(logRouterlogDomain.getRouterlogMespid(), tenantCode);
                if (null == umUserinfoDomain) {
                    logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.umUserinfoDomain.isnull", (Object)(logRouterlogDomain.getRouterlogMespid() + ":::" + tenantCode));
                    return this.makeErrorReturn(this.SYS_CODE + ".sendUpdateExUserUserinfo.msg", "DMS\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f1");
                }
                UmUserDomain umUserDomain = this.getUserByPcode(tenantCode, umUserinfoDomain.getUserinfoCode());
                if (null == umUserDomain) {
                    logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.getUserByPcode.isnull", (Object)(tenantCode + ":::" + umUserinfoDomain.getUserinfoCode()));
                    return this.makeErrorReturn(this.SYS_CODE + ".sendUpdateExUserUserinfo.msg", "DMS\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f2");
                }
                InvUserinv invUserinv = this.queryUserinvByUserCode(tenantCode, umUserDomain.getUserCode());
                if (null == invUserinv) {
                    logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.queryUserinvByUserCode.isnull", (Object)(umUserDomain.getUserCode() + ":::" + tenantCode));
                    return this.makeErrorReturn(this.SYS_CODE + ".sendUpdateExUserUserinfo.msg", "DMS\u672a\u627e\u5230\u53d1\u7968\u4fe1\u606f");
                }
                umUserinfoDomain.setInvUserinv(invUserinv);
                umUserinfoDomain.setUserinfoThemeList(oaUserinfoResponse.getUserinfoThemeList());
                if (oaUserinfoResponse.getDataState().equals("2")) {
                    if ("userInfoCreate".equals(logRouterlogDomain.getRouterlogType())) {
                        ((UmUserinfoDomain)umUserinfoDomain).setDataState(3);
                    }
                    umUserinfoDomain.setUserinfoState(2);
                    this.sendUpdateUserinfo(umUserinfoDomain);
                } else {
                    ((UmUserinfoDomain)umUserinfoDomain).setDataState(0);
                    umUserinfoDomain.setUserinfoState(1);
                    umUserinfoDomain.setUserinfoSort(this.signWether(oaUserinfoResponse));
                    umUserinfoDomain.setUmUserinfoQuaDomainList(this.createUmUserinfoQuaList(oaUserinfoResponse, umUserinfoDomain));
                    umUserinfoDomain.setMemberMcode(this.getTeananMemberCode(tenantCode));
                    this.saveOrUpdateUserinfo(umUserinfoDomain);
                    this.saveOrUpdateAdrees(umUserinfoDomain);
                    this.saveOpenAccout(umUserinfoDomain);
                    this.sendUpdateUserinfo(umUserinfoDomain);
                }
            }
            return this.makeSuccessReturn("\u64cd\u4f5c\u6210\u529f");
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendUpdateExUserUserinfo.e", e.getErrCode());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExUserUserinfo.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExUserUserinfo.e1", e.getMessage());
        }
    }

    private String signWether(OaUserinfoResponse oaUserinfoResponse) {
        String sign = "0";
        if (CollectionUtils.isEmpty(oaUserinfoResponse.getUserinfoThemeList())) {
            for (UserinfoThemeDomain userinfoThemeDomain : oaUserinfoResponse.getUserinfoThemeList()) {
                if (!"1".equals(userinfoThemeDomain.getSignWhether())) continue;
                sign = "1";
            }
        }
        return sign;
    }

    private void saveOpenAccout(UmUserinfoDomain umUserinfoDomain) {
        List<UserinfoThemeDomain> userinfoThemeList = umUserinfoDomain.getUserinfoThemeList();
        for (UserinfoThemeDomain userinfoThemeDomain : userinfoThemeList) {
            String signBrand = userinfoThemeDomain.getSignBrand();
            if (StringUtils.isEmpty((String)signBrand)) {
                logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.saveOpenAccout\u54c1\u724c\u540d\u79f0" + userinfoThemeDomain.getSignBrand() + "\u4e0d\u80fd\u4e3a\u7a7a");
                throw new ApiException("\u54c1\u724c\u540d\u79f0" + userinfoThemeDomain.getSignBrand() + "\u4e0d\u80fd\u4e3a\u7a7a");
            }
            RsBrandDomain brandByName = this.getBrandByName(signBrand, umUserinfoDomain.getTenantCode());
            if (brandByName == null) {
                logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.saveOpenAccout\u54c1\u724c\u540d\u79f0" + userinfoThemeDomain.getSignBrand() + "DMS\u6682\u672a\u7ef4\u62a4");
                throw new ApiException("\u54c1\u724c\u540d\u79f0" + userinfoThemeDomain.getSignBrand() + "DMS\u6682\u672a\u7ef4\u62a4");
            }
            HashMap<String, Object> crpMap = new HashMap<String, Object>();
            crpMap.put("userinfoCode", umUserinfoDomain.getUserinfoCode());
            crpMap.put("tenantCode", umUserinfoDomain.getTenantCode());
            crpMap.put("memberCode", brandByName.getMemberCode());
            QueryResult<CrpUrechargeDomain> queryResult = this.getCrpAccount(crpMap);
            if (queryResult != null && CollectionUtils.isNotEmpty((Collection)queryResult.getList())) {
                logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.\u8d26\u6237\u5df2\u7ecf\u5b58\u5728" + umUserinfoDomain.getUserinfoCode());
                return;
            }
            CrpUrechargeDomain crpUrechargeDomain = new CrpUrechargeDomain();
            crpUrechargeDomain.setTenantCode(umUserinfoDomain.getTenantCode());
            crpUrechargeDomain.setUserinfoCode(umUserinfoDomain.getUserinfoCode());
            crpUrechargeDomain.setMemberCode(brandByName.getMemberCode());
            crpUrechargeDomain.setMemberName(signBrand);
            crpUrechargeDomain.setRechargeCategory("2");
            crpUrechargeDomain.setRechargeMode("1");
            crpUrechargeDomain.setRechargeAllmoney(BigDecimal.ZERO);
            crpUrechargeDomain.setRechargeSmoney(BigDecimal.ZERO);
            crpUrechargeDomain.setRechargeName1(userinfoThemeDomain.getCompanyTheme());
            crpUrechargeDomain.setChannelCode(brandByName.getChannelCode());
            this.saveCrpAccount(crpUrechargeDomain);
            RebUpointsDomain rebUpointsDomain = new RebUpointsDomain();
            rebUpointsDomain.setTenantCode(umUserinfoDomain.getTenantCode());
            rebUpointsDomain.setChannelCode(brandByName.getChannelCode());
            rebUpointsDomain.setUserinfoCode(umUserinfoDomain.getUserinfoCode());
            rebUpointsDomain.setUserinfoName(umUserinfoDomain.getUserinfoCompname());
            rebUpointsDomain.setMemberCode(brandByName.getMemberCode());
            rebUpointsDomain.setMemberName(signBrand);
            rebUpointsDomain.setUpointsType("1");
            rebUpointsDomain.setPointsUserqua(userinfoThemeDomain.getCompanyTheme());
            rebUpointsDomain.setUpointsNum(BigDecimal.ZERO);
            rebUpointsDomain.setUpointsLnum(BigDecimal.ZERO);
            rebUpointsDomain.setUpointsOnum(BigDecimal.ZERO);
            this.saveRebAccount(rebUpointsDomain);
            VdFaccountOuterCtrlDomain vdFaccountOuterCtrlDomain = new VdFaccountOuterCtrlDomain();
            String batchcode = "0201";
            vdFaccountOuterCtrlDomain.setFaccountDefBatchcode(batchcode);
            vdFaccountOuterCtrlDomain.setMerchantCode(umUserinfoDomain.getUserinfoCode());
            vdFaccountOuterCtrlDomain.setMerchantName(null == umUserinfoDomain.getUserinfoCompname() ? umUserinfoDomain.getUserinfoPhone() : umUserinfoDomain.getUserinfoCompname());
            vdFaccountOuterCtrlDomain.setTenantCode(umUserinfoDomain.getTenantCode());
            vdFaccountOuterCtrlDomain.setFaccountOuterCtrlExno(umUserinfoDomain.getUserinfoCode());
            vdFaccountOuterCtrlDomain.setFaccountOuterCtrlCallurl("um.user.udateCallFaccount");
            vdFaccountOuterCtrlDomain.setChannelCode(brandByName.getChannelCode());
            vdFaccountOuterCtrlDomain.setChannelName(brandByName.getChannelName());
            vdFaccountOuterCtrlDomain.setGoodsClass("b2b");
            vdFaccountOuterCtrlDomain.setMemberMcode(StringUtils.isBlank((String)umUserinfoDomain.getUserinfoParentCode()) ? umUserinfoDomain.getUserinfoCode() : umUserinfoDomain.getUserinfoParentCode());
            vdFaccountOuterCtrlDomain.setMemberMname(StringUtils.isBlank((String)umUserinfoDomain.getUserinfoParentCode()) ? umUserinfoDomain.getUserinfoCompname() : umUserinfoDomain.getUserinfoParentName());
            vdFaccountOuterCtrlDomain.setMemberCode(brandByName.getMemberCode());
            vdFaccountOuterCtrlDomain.setMemberName(signBrand);
            vdFaccountOuterCtrlDomain.setFaccountReqno(userinfoThemeDomain.getCompanyTheme());
            this.saveVdAccount(vdFaccountOuterCtrlDomain);
        }
    }

    private String saveVdAccount(VdFaccountOuterCtrlDomain vdFaccountOuterCtrlDomain) {
        String apiCode = "vd.faccount.saveOpenFaccoun";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("vdFaccountOuterCtrlDomain", JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterCtrlDomain));
        return this.internalInvoke(apiCode, map);
    }

    private String saveRebAccount(RebUpointsDomain rebUpointsDomain) {
        String apiCode = "reb.upoints.saveUpoints";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rebUpointsDomain", JsonUtil.buildNormalBinder().toJson((Object)rebUpointsDomain));
        return this.internalInvoke(apiCode, map);
    }

    private String saveCrpAccount(CrpUrechargeDomain crpUrechargeDomain) {
        String apiCode = "crp.send.sendsaveCrpUrecharge";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("crpUrechargeDomain", JsonUtil.buildNormalBinder().toJson((Object)crpUrechargeDomain));
        return this.internalInvoke(apiCode, map);
    }

    private QueryResult<CrpUrechargeDomain> getCrpAccount(Map<String, Object> map) {
        if (map == null) {
            logger.error(this.SYS_CODE + ".getCrpAccount.null");
            logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.saveOpenAccout.getCrpAccount\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ApiException("Crp\u7f3a\u5c11\u8d26\u6237\u67e5\u8be2\u6570\u636e");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject("crp.send.queryCrpUrechargePage", paramMap, CrpUrechargeDomain.class);
    }

    private RsBrandDomain getBrandByName(String brandName, String tenantCode) {
        if (StringUtils.isBlank((String)brandName) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getBrandByName.null");
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("brandName", brandName);
        param.put("tenantCode", tenantCode);
        return (RsBrandDomain)this.getForObject("rs.brand.getBrandByName", RsBrandDomain.class, param);
    }

    private void saveOrUpdateUserinfo(UmUserinfoDomain umUserinfoDomain) {
        if (0 == umUserinfoDomain.getDataState()) {
            HashMap<String, Object> SapMap = new HashMap<String, Object>();
            SapMap.put("method", "MAIHE.DMS.KUNNR");
            SapMap.put("app_key", "MHDMS");
            SapMap.put("version", "1.0");
            SapMap.put("timestamp", DateUtils.parseDateTime((Date)new Date()));
            ArrayList addressSapList = new ArrayList();
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("CUSTOMER", umUserinfoDomain.getUserinfoCode());
            map1.put("KUNNR", StringUtils.isBlank((String)umUserinfoDomain.getUserinfoOcode()) ? "" : umUserinfoDomain.getUserinfoOcode());
            map1.put("NAME1", umUserinfoDomain.getUserinfoCompname());
            map1.put("STRAS", umUserinfoDomain.getInvUserinv().getUserinvAdd());
            map1.put("NAME2", umUserinfoDomain.getUserinfoCon());
            map1.put("TELF2", umUserinfoDomain.getUserinfoPhone());
            map1.put("STCD5", umUserinfoDomain.getInvUserinv().getUserinvNo());
            map1.put("BANKA", umUserinfoDomain.getInvUserinv().getUserinvBankname());
            map1.put("BANKN", umUserinfoDomain.getInvUserinv().getUserinvBankno());
            map1.put("ACCNAME", umUserinfoDomain.getInvUserinv().getUserinvMember());
            map1.put("SPERR", "");
            QueryResult<UmUserReDomain> qulist = this.queryUserPage(this.getQueryMapParam("userPhone,tenantCode", new Object[]{umUserinfoDomain.getUserinfoPhone(), umUserinfoDomain.getTenantCode()}));
            if (qulist == null || CollectionUtils.isEmpty((Collection)qulist.getList())) {
                logger.error(this.SYS_CODE + ".saveOrUpdateUserinfo.queryUserPage.isnull", (Object)umUserinfoDomain.getUserinfoPhone());
                throw new ApiException("DMS\u6682\u672a\u67e5\u5230\u7528\u6237\u4fe1\u606f");
            }
            map1.put("ERNAM", ((UmUserReDomain)qulist.getList().get(0)).getUserRelname());
            map1.put("ERDAT", ((UmUserReDomain)qulist.getList().get(0)).getGmtCreate());
            ArrayList themeList = new ArrayList();
            for (UserinfoThemeDomain userinfoThemeDomain : umUserinfoDomain.getUserinfoThemeList()) {
                HashMap<String, String> themeMap = new HashMap<String, String>();
                themeMap.put("BUKRS", userinfoThemeDomain.getCompanyTheme());
                themeMap.put("ZTERM", userinfoThemeDomain.getSettleMethodName());
                themeMap.put("VTWEG", userinfoThemeDomain.getCustomerChannelName());
                themeList.add(themeMap);
            }
            map1.put("items", themeList);
            addressSapList.add(map1);
            SapMap.put("goodlist", addressSapList);
            String req = JsonUtil.buildNormalBinder().toJson(SapMap);
            LogRouterlogDomain logRouterlogDomain = new LogRouterlogDomain();
            logRouterlogDomain.setAppapiCode("/sap/zdms_query?api=dms_kunnr");
            logRouterlogDomain.setAppapiVersion("1.0");
            logRouterlogDomain.setRouteDire("51");
            logRouterlogDomain.setRouterlogName("");
            logRouterlogDomain.setRouterlogMessage(req);
            logRouterlogDomain.setTenantCode(umUserinfoDomain.getTenantCode());
            String url = this.getUrl(umUserinfoDomain.getTenantCode(), "sapuserinfoUrl", "sapuserinfoUrl");
            logger.info(this.SYS_CODE + ".saveOrUpdateUserinfo.sap.", (Object)("url=" + url + ";req" + req));
            String adressRes = OKHttpClientUtil.sendPost(url, req);
            logger.info(this.SYS_CODE + ".saveOrUpdateUserinfo.sap.res", (Object)adressRes);
            logRouterlogDomain.setRouterlogReturn(adressRes);
            if (StringUtils.isEmpty((String)adressRes)) {
                this.sendLog(logRouterlogDomain);
                throw new ApiException("\u540c\u6b65SAP\u7528\u6237\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a");
            }
            SapAdressResponse sapAdressResponse = (SapAdressResponse)JsonUtil.buildNonNullBinder().getJsonToObject(adressRes, SapAdressResponse.class);
            logRouterlogDomain.setRouterlogReturnstate(sapAdressResponse.getStatus());
            logRouterlogDomain.setRouterlogReturnstates(sapAdressResponse.getMessage());
            this.sendLog(logRouterlogDomain);
            if ("E".equals(sapAdressResponse.getStatus())) {
                logger.error(this.SYS_CODE + ".saveOrUpdateUserinfo.zdms_query.\u540c\u6b65sap\u7528\u6237\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Object)sapAdressResponse.getMessage());
                throw new ApiException("\u540c\u6b65SAP\u7528\u6237\u4fe1\u606f\u5f02\u5e38" + sapAdressResponse.getMessage());
            }
            umUserinfoDomain.setUserinfoOcode(sapAdressResponse.getNumber());
        }
    }

    private void saveOrUpdateAdrees(UmUserinfoDomain umUserinfoDomain) {
        HashMap<String, Object> UserinfoMap = new HashMap<String, Object>();
        UserinfoMap.put("tenantCode", umUserinfoDomain.getTenantCode());
        UserinfoMap.put("userCode", umUserinfoDomain.getUserinfoCode());
        QueryResult<UmAddressReDomain> queryResult = this.queryAddressPage(UserinfoMap);
        if (queryResult != null && CollectionUtils.isNotEmpty((Collection)queryResult.getList())) {
            for (UmAddressReDomain umAddressReDomain : queryResult.getList()) {
                this.updateAddressState(umAddressReDomain.getAddressId(), 1, null);
                HashMap<String, Object> SapMap = new HashMap<String, Object>();
                SapMap.put("method", "MAIHE.DMS.KUNSE");
                SapMap.put("app_key", "MHDMS");
                SapMap.put("version", "1.0");
                SapMap.put("timestamp", DateUtils.parseDateTime((Date)new Date()));
                ArrayList addressSapList = new ArrayList();
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                map1.put("KUNSE", StringUtils.isEmpty((String)umAddressReDomain.getRoadCode()) ? "" : umAddressReDomain.getRoadCode());
                map1.put("KUNNR", umUserinfoDomain.getUserinfoOcode());
                map1.put("CUSTOMER_SE", umAddressReDomain.getAddressCode());
                map1.put("NAME1_SE", umAddressReDomain.getRoadName());
                map1.put("SORTL_SE", umAddressReDomain.getAddressMap());
                map1.put("REGIO_SE", umAddressReDomain.getProvinceCode());
                map1.put("ORT01_SE", umAddressReDomain.getCityName());
                map1.put("STRAS_SE", umAddressReDomain.getAddressDetail());
                map1.put("TELF2_SE", umAddressReDomain.getAddressPhone());
                map1.put("NAME2_SE", umAddressReDomain.getAddressMember());
                map1.put("SPERR_SE", "");
                map1.put("ERNAM_SE", umAddressReDomain.getUserName());
                map1.put("ERDAT_SE", umAddressReDomain.getGmtModified());
                addressSapList.add(map1);
                SapMap.put("goodlist", addressSapList);
                String req = JsonUtil.buildNormalBinder().toJson(SapMap);
                LogRouterlogDomain logRouterlogDomain = new LogRouterlogDomain();
                logRouterlogDomain.setAppapiCode("/sap/zdms_query?api=dms_kunse");
                logRouterlogDomain.setAppapiVersion("1.0");
                logRouterlogDomain.setRouteDire("51");
                logRouterlogDomain.setRouterlogName("");
                logRouterlogDomain.setRouterlogMessage(req);
                logRouterlogDomain.setTenantCode(umUserinfoDomain.getTenantCode());
                String url = this.getUrl(umUserinfoDomain.getTenantCode(), "sapaddressUrl", "sapaddressUrl");
                logger.info(this.SYS_CODE + ".saveOrUpdateAdrees.sap.", (Object)("url=" + url + ";req" + req));
                String adressRes = OKHttpClientUtil.sendPost(url, req);
                logger.info(this.SYS_CODE + ".saveOrUpdateAdrees.sap.res", (Object)adressRes);
                logRouterlogDomain.setRouterlogReturn(adressRes);
                if (StringUtils.isEmpty((String)adressRes)) {
                    this.sendLog(logRouterlogDomain);
                    throw new ApiException("\u540c\u6b65SAP\u5730\u5740\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a");
                }
                SapAdressResponse sapAdressResponse = (SapAdressResponse)JsonUtil.buildNonNullBinder().getJsonToObject(adressRes, SapAdressResponse.class);
                logRouterlogDomain.setRouterlogReturnstate(sapAdressResponse.getStatus());
                logRouterlogDomain.setRouterlogReturnstates(sapAdressResponse.getMessage());
                this.sendLog(logRouterlogDomain);
                if ("E".equals(sapAdressResponse.getStatus())) {
                    logger.error(this.SYS_CODE + ".saveOrUpdateAdrees.zdms_query.\u540c\u6b65sap\u5730\u5740\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38");
                    throw new ApiException("\u540c\u6b65SAP\u5730\u5740\u4fe1\u606f\u5f02\u5e38" + sapAdressResponse.getMessage());
                }
                umAddressReDomain.setRoadCode(sapAdressResponse.getNumber());
                this.updateAddress(umAddressReDomain);
            }
        }
    }

    private String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            logger.error(this.SYS_CODE + ".getUrl.param");
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        logger.info(this.SYS_CODE + ".getUrl.field", (Object)field);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    public void sendLog(LogRouterlogDomain logRouterlogDomain) {
        String api_code = "log.logRouterlog.saveRouterlog";
        if (null == logRouterlogDomain) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("logRouterlogDomain", JsonUtil.buildNormalBinder().toJson((Object)logRouterlogDomain));
        this.inAsyncInvoke(api_code, paramMap);
    }

    public LogRouterlogDomain queryLog(String logRouterCode, String tenantCode) {
        String apiCode = "log.logRouterlog.queryRouterlogPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("routerlogMesid", logRouterCode);
        map.put("tenantCode", tenantCode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult qlist = this.sendReSupObject(apiCode, paramMap, LogRouterlogDomain.class);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        return (LogRouterlogDomain)qlist.getList().get(0);
    }

    private List<UmUserinfoQuaDomain> createUmUserinfoQuaList(OaUserinfoResponse oaUserinfoResponse, UmUserinfoDomain umUserinfoDomain) {
        ArrayList<UmUserinfoQuaDomain> list = new ArrayList<UmUserinfoQuaDomain>();
        for (UmUserinfoQuaDomain umUserinfoQuaDomain : umUserinfoDomain.getUmUserinfoQuaDomainList()) {
            if (!umUserinfoQuaDomain.getUserinfoQuaKey().equals("registerCapital") && !umUserinfoQuaDomain.getUserinfoQuaKey().equals("followWhether") && !umUserinfoQuaDomain.getUserinfoQuaKey().equals("teamNum") && !umUserinfoQuaDomain.getUserinfoQuaKey().equals("salesVolume") && !umUserinfoQuaDomain.getUserinfoQuaKey().equals("networkNum") && !umUserinfoQuaDomain.getUserinfoQuaKey().equals("onlineNum") && !umUserinfoQuaDomain.getUserinfoQuaKey().equals("offlineNum")) continue;
            list.add(umUserinfoQuaDomain);
        }
        String brandName = "";
        String brandCode = "";
        String dischannelName = "";
        String dischannelCode = "";
        String userinfoCert2Url = "";
        for (UserinfoThemeDomain userinfoThemeDomain : oaUserinfoResponse.getUserinfoThemeList()) {
            UmUserinfoQuaDomain umUserinfoQuaDomain = new UmUserinfoQuaDomain();
            umUserinfoQuaDomain.setTenantCode(umUserinfoDomain.getTenantCode());
            umUserinfoQuaDomain.setUserinfoCode(umUserinfoDomain.getUserinfoCode());
            umUserinfoQuaDomain.setUserinfoQuaKey(userinfoThemeDomain.getCompanyTheme());
            umUserinfoQuaDomain.setUserinfoQuaVaule(JsonUtil.buildNonNullBinder().toJson((Object)userinfoThemeDomain));
            umUserinfoQuaDomain.setUserinfoQuaVaule1("company");
            list.add(umUserinfoQuaDomain);
            RsBrandDomain oldRsBrandDomain = this.queryBrandByName(userinfoThemeDomain.getSignBrand(), umUserinfoDomain.getTenantCode());
            brandCode = brandCode + oldRsBrandDomain.getBrandCode() + ",";
            brandName = brandName + userinfoThemeDomain.getSignBrand() + ",";
            userinfoCert2Url = userinfoCert2Url + userinfoThemeDomain.getCompanyTheme() + ",";
            dischannelName = userinfoThemeDomain.getCustomerChannelName();
            dischannelCode = this.queryDisChannelCode(userinfoThemeDomain.getCustomerChannelName(), umUserinfoDomain.getTenantCode());
            UmUserinfoQuaDomain umUserinfoQuaDomain8 = new UmUserinfoQuaDomain();
            umUserinfoQuaDomain8.setTenantCode(umUserinfoDomain.getTenantCode());
            umUserinfoQuaDomain8.setUserinfoCode(umUserinfoDomain.getUserinfoCode());
            umUserinfoQuaDomain8.setUserinfoQuaKey(oldRsBrandDomain.getBrandCode() + "_limit");
            umUserinfoQuaDomain8.setUserinfoQuaVaule(userinfoThemeDomain.getCreditAmout());
            list.add(umUserinfoQuaDomain8);
            UmUserinfoQuaDomain umUserinfoQuaDomain9 = new UmUserinfoQuaDomain();
            umUserinfoQuaDomain9.setTenantCode(umUserinfoDomain.getTenantCode());
            umUserinfoQuaDomain9.setUserinfoCode(umUserinfoDomain.getUserinfoCode());
            umUserinfoQuaDomain9.setUserinfoQuaKey(oldRsBrandDomain.getBrandCode() + "_minAmount");
            umUserinfoQuaDomain9.setUserinfoQuaVaule(userinfoThemeDomain.getMinAmount());
            list.add(umUserinfoQuaDomain9);
            UmUserinfoQuaDomain umUserinfoQuaDomain10 = new UmUserinfoQuaDomain();
            umUserinfoQuaDomain10.setTenantCode(umUserinfoDomain.getTenantCode());
            umUserinfoQuaDomain10.setUserinfoCode(umUserinfoDomain.getUserinfoCode());
            umUserinfoQuaDomain10.setUserinfoQuaKey(oldRsBrandDomain.getBrandCode());
            umUserinfoQuaDomain10.setUserinfoQuaVaule(userinfoThemeDomain.getCompanyTheme());
            umUserinfoQuaDomain10.setUserinfoQuaVaule1("1");
            umUserinfoQuaDomain10.setUserinfoQuaVaule2(userinfoThemeDomain.getSignBrand());
            umUserinfoQuaDomain10.setUserinfoQuaUrl(oldRsBrandDomain.getMemberCode());
            list.add(umUserinfoQuaDomain10);
        }
        if (!StringUtils.isEmpty((String)brandCode)) {
            umUserinfoDomain.setMschannelCode(brandCode.substring(0, brandCode.lastIndexOf(",")));
            umUserinfoDomain.setMschannelName(brandName.substring(0, brandName.lastIndexOf(",")));
            umUserinfoDomain.setUserinfoCert2Url(userinfoCert2Url.substring(0, userinfoCert2Url.lastIndexOf(",")));
        }
        umUserinfoDomain.setUserinfoDischannelcode(dischannelCode);
        umUserinfoDomain.setUserinfoDischannelname(dischannelName);
        return list;
    }

    private String queryDisChannelCode(String userinfoDischannelname, String tenantCode) {
        String apiCode = "dis.channel.queryChannelPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("channelName", userinfoDischannelname);
        map.put("tenantCode", tenantCode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult qlist = this.sendReSupObject(apiCode, paramMap, DisChannelReDomain.class);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            throw new ApiException("\u6e20\u9053\u540d\u79f0\u5728DMS\u5c1a\u672a\u7ef4\u62a4");
        }
        return ((DisChannelReDomain)qlist.getList().get(0)).getChannelCode();
    }

    private RsBrandDomain queryBrandByName(String mschannelName, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("brandName", mschannelName);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult queryResult = this.sendReSupObject("rs.brand.queryBrandPage", paramMap, RsBrandDomain.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            throw new ApiException("\u54c1\u724c\u540d\u79f0\u5728DMS\u5c1a\u672a\u7ef4\u62a4");
        }
        return (RsBrandDomain)queryResult.getList().get(0);
    }

    @Override
    public String sendDelExUserUserinfo(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendDelExUserUserinfo.map");
            return this.makeErrorReturn(this.SYS_CODE + ".sendDelExUserUserinfo.map", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendDelExUserUserinfo.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendDelExUserUserinfo.msg", msg);
        }
        try {
            Integer userinfoId = (Integer)map.get("userinfoId");
            Integer dataState = -1;
            String userinfoCode = (String)map.get("userinfoCode");
            this.sendUpdateUserinfoState(userinfoId, dataState, null, map);
            if (StringUtils.isBlank((String)userinfoCode)) {
                logger.error(this.SYS_CODE + ".sendDelExUserUserinfo.userinfoCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendDelExUserUserinfo.userinfoCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(userinfoCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendDelExUserUserinfo.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendDelExUserUserinfo.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendDelExUserUserinfo.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendDelExUserUserinfo.e1", e.getMessage());
        }
    }

    @Override
    public String sendStarExUserUserinfo(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendStarExUserUserinfo.map");
            return this.makeErrorReturn(this.SYS_CODE + ".sendStarExUserUserinfo.map", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendStarExUserUserinfo.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendStarExUserUserinfo.msg", msg);
        }
        try {
            Integer userinfoId = (Integer)map.get("userinfoId");
            Integer dataState = 0;
            String userinfoCode = (String)map.get("userinfoCode");
            this.sendUpdateUserinfoState(userinfoId, dataState, null, map);
            if (StringUtils.isBlank((String)userinfoCode)) {
                logger.error(this.SYS_CODE + ".sendStarExUserUserinfo.userinfoCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendStarExUserUserinfo.userinfoCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(userinfoCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendStarExUserUserinfo.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendStarExUserUserinfo.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendStarExUserUserinfo.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendStarExUserUserinfo.e1", e.getMessage());
        }
    }

    @Override
    public String sendStopExUserUserinfo(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendStopExUserUserinfo.map");
            return this.makeErrorReturn(this.SYS_CODE + ".sendStopExUserUserinfo.map", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendStopExUserUserinfo.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendStopExUserUserinfo.msg", msg);
        }
        try {
            Integer userinfoId = (Integer)map.get("userinfoId");
            Integer dataState = -1;
            String userinfoCode = (String)map.get("userinfoCode");
            this.sendUpdateUserinfoState(userinfoId, dataState, null, map);
            if (StringUtils.isBlank((String)userinfoCode)) {
                logger.error(this.SYS_CODE + ".sendStopExUserUserinfo.userinfoCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendStopExUserUserinfo.userinfoCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(userinfoCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendStopExUserUserinfo.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendStopExUserUserinfo.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendStopExUserUserinfo.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendStopExUserUserinfo.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveUserinfo(Map<String, Object> resStream, String tenantCode) {
        QueryResult<UmUserinfoReDomain> qlist;
        logger.error(this.SYS_CODE + ".sendSaveUserinfo.map", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        if (MapUtil.isEmpty(resStream) || StringUtils.isBlank((String)tenantCode)) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExUserUserinfo.resStream", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUserDomainBean umUserDomainBean = (UmUserDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), UmUserDomainBean.class);
        if (StringUtils.isBlank((String)umUserDomainBean.getUserinfoCode())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExUserUserinfo.userinfoCode", "\u6570\u636e\u4e3a\u7a7a");
        }
        umUserDomainBean.setUserinfoOcode(umUserDomainBean.getUserinfoCode());
        umUserDomainBean.setUserinfoCode(null);
        umUserDomainBean.setUserinfoQuality("supplier");
        umUserDomainBean.setTenantCode(tenantCode);
        String msg = this.checkMap(umUserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveUserinfo.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveUserinfo.msg", msg);
        }
        if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoOcode()) && null != (qlist = this.queryUserinfoPage(this.getQueryMapParam("userinfoOcode,tenantCode", new Object[]{umUserDomainBean.getUserinfoOcode(), umUserDomainBean.getTenantCode()}))) && !ListUtil.isEmpty((Collection)qlist.getList())) {
            UmUserinfoReDomain umUserinfoReDomain = (UmUserinfoReDomain)qlist.getList().get(0);
            logger.error(this.SYS_CODE + ".sendSaveUserinfo.umUserinfoReDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoReDomain));
            if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoCompname()) && !umUserDomainBean.getUserinfoCompname().equals(umUserinfoReDomain.getUserinfoCompname()) || StringUtils.isNotBlank((String)umUserDomainBean.getMschannelName()) && !umUserDomainBean.getMschannelName().equals(umUserinfoReDomain.getMschannelName()) || StringUtils.isNotBlank((String)umUserDomainBean.getProvinceCode()) && !umUserDomainBean.getProvinceCode().equals(umUserinfoReDomain.getProvinceCode()) || StringUtils.isNotBlank((String)umUserDomainBean.getCityCode()) && !umUserDomainBean.getCityCode().equals(umUserinfoReDomain.getCityCode()) || StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoOpcode2()) && !umUserDomainBean.getUserinfoOpcode2().equals(umUserinfoReDomain.getUserinfoOpcode2()) || StringUtils.isNotBlank((String)umUserDomainBean.getMschannelCode()) && !umUserDomainBean.getMschannelCode().equals(umUserinfoReDomain.getMschannelCode())) {
                umUserinfoReDomain.setUserinfoCompname(umUserDomainBean.getUserinfoCompname());
                umUserinfoReDomain.setProvinceCode(umUserDomainBean.getProvinceCode());
                umUserinfoReDomain.setCityCode(umUserDomainBean.getCityCode());
                umUserinfoReDomain.setMschannelCode(umUserDomainBean.getMschannelCode());
                umUserinfoReDomain.setMschannelName(umUserDomainBean.getMschannelName());
                umUserinfoReDomain.setUserinfoParentCode(DisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode));
                umUserinfoReDomain.setUserinfoParentName("\u65e5\u4e30");
                umUserinfoReDomain.setUserinfoOpcode2(umUserDomainBean.getUserinfoOpcode2());
                this.sendUpdateUserinfo(umUserinfoReDomain);
            }
            return this.makeSuccessReturn(umUserinfoReDomain.getUserinfoCode());
        }
        try {
            umUserDomainBean.setUserinfoDataState(4);
            String userinfoCode = this.sendOpenUserinfo(umUserDomainBean);
            if (StringUtils.isBlank((String)userinfoCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExUserUserinfo.userinfoCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExUserUserinfo.userinfoCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(userinfoCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExUserUserinfo.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExUserUserinfo.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExUserUserinfo.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExUserUserinfo.e1", e.getMessage());
        }
    }

    public QueryResult<UmUserinfoDomain> queryExUserUserinfo(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".queryExUserUserinfo.map");
            throw new ApiException(this.SYS_CODE + ".queryExUserUserinfo.map\u53c2\u6570\u4e3a\u7a7a");
        }
        String userinfoOcode = (String)map.get("userinfoOcode");
        if (StringUtils.isEmpty((String)userinfoOcode)) {
            logger.error(this.SYS_CODE + ".queryExUserUserinfo.map");
            throw new ApiException(this.SYS_CODE + ".queryExUserUserinfo.map\u53c2\u6570userinfoOcode \u4e3a\u7a7a");
        }
        List<UmUserinfoDomain> umUserinfoDomains = this.queryExUserUserinfoByMap(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(umUserinfoDomains.size());
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUserinfoDomains);
        return queryResult;
    }

    private String checkMap(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)((String)map.get("userinfoOcode")))) {
            msg = msg + "userinfoOcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)((String)map.get("tenantCode")))) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isNotBlank((String)((String)map.get("userinfoOcode")))) {
            QueryResult<UmUserinfoReDomain> qlist = this.queryUserinfoPage(this.getQueryMapParam("userinfoOcode,tenantCode", new Object[]{(String)map.get("userinfoOcode"), (String)map.get("tenantCode")}));
            if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
                msg = msg + "userinfoOcode[" + (String)map.get("userinfoOcode") + "]\u4e0d\u5b58\u5728! ";
            } else {
                map.put("userinfoId", ((UmUserinfoReDomain)qlist.getList().get(0)).getUserinfoId());
                map.put("userinfoCode", ((UmUserinfoReDomain)qlist.getList().get(0)).getUserinfoCode());
            }
        }
        return msg;
    }

    private String checkMap(UmUserDomainBean umUserDomainBean) {
        if (null == umUserDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umUserDomainBean.getUserinfoOcode())) {
            msg = msg + "userinfoOcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)umUserDomainBean.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkUmUserinfo(UmUserinfoDomain umUserinfoDomain) {
        if (null == umUserinfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umUserinfoDomain.getRouterlogCode())) {
            msg = msg + "routerlogCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkUmUser(UmUserDomainBean umUserDomainBean) {
        QueryResult<UmUserReDomain> qulist;
        if (null == umUserDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umUserDomainBean.getUserinfoOcode())) {
            msg = msg + "userinfoOcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)umUserDomainBean.getUserinfoCompname())) {
            msg = msg + "userinfoCompname\u4e3a\u7a7a! ";
        }
        if (null == umUserDomainBean.getUserinfoType()) {
            msg = msg + "userinfoType\u4e3a\u7a7a! ";
        } else if (1 != umUserDomainBean.getUserinfoType() && 2 != umUserDomainBean.getUserinfoType()) {
            msg = msg + "userinfoType[" + umUserDomainBean.getUserinfoType() + "]\u5f02\u5e38! ";
        }
        if (StringUtils.isBlank((String)umUserDomainBean.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoOcode())) {
            QueryResult<UmUserinfoReDomain> qlist = this.queryUserinfoPage(this.getQueryMapParam("userinfoOcode,tenantCode", new Object[]{umUserDomainBean.getUserinfoOcode(), umUserDomainBean.getTenantCode()}));
            logger.error("qlist", (Object)JsonUtil.buildNormalBinder().toJson(qlist));
            if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
                msg = msg + "userinfoOcode[" + umUserDomainBean.getUserinfoOcode() + "]\u91cd\u590d! ";
            }
        }
        String userPhone = umUserDomainBean.getUserPhone();
        if (StringUtils.isBlank((String)umUserDomainBean.getUserPhone()) && StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoPhone())) {
            userPhone = umUserDomainBean.getUserinfoPhone();
        }
        if (StringUtils.isNotBlank((String)userPhone) && null != (qulist = this.queryUserPage(this.getQueryMapParam("userPhone,tenantCode", new Object[]{userPhone, umUserDomainBean.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qulist.getList())) {
            msg = msg + "userPhone/userinfoPhone[" + userPhone + "]\u91cd\u590d! ";
        }
        if (StringUtils.isBlank((String)umUserDomainBean.getUserinfoQuality())) {
            msg = msg + "userinfoQuality\u4e3a\u7a7a! ";
        }
        return msg;
    }

    @Override
    public String sendUpdateUserUserinfoBack(Map<String, Object> map) {
        return null;
    }
}

